#line 1 "pgc.c"
/*-------------------------------------------------------------------------
 *
 * pgc.l
 *	  lexical scanner for ecpg
 *
 * This is a modified version of src/backend/parser/scan.l
 *
 * The ecpg scanner is not backup-free, so the fail rules are
 * only here to simplify syncing this file with scan.l.
 *
 *
 * Portions Copyright (c) 1996-2024, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/interfaces/ecpg/preproc/pgc.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_fe.h"

#include <ctype.h>
#include <limits.h>

#include "common/string.h"

#include "preproc_extern.h"
#include "preproc.h"

#line 31 "pgc.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer base_yy_create_buffer
#define yy_delete_buffer base_yy_delete_buffer
#define yy_scan_buffer base_yy_scan_buffer
#define yy_scan_string base_yy_scan_string
#define yy_scan_bytes base_yy_scan_bytes
#define yy_init_buffer base_yy_init_buffer
#define yy_flush_buffer base_yy_flush_buffer
#define yy_load_buffer_state base_yy_load_buffer_state
#define yy_switch_to_buffer base_yy_switch_to_buffer
#define yypush_buffer_state base_yypush_buffer_state
#define yypop_buffer_state base_yypop_buffer_state
#define yyensure_buffer_stack base_yyensure_buffer_stack
#define yy_flex_debug base_yy_flex_debug
#define yyin base_yyin
#define yyleng base_yyleng
#define yylex base_yylex
#define yylineno base_yylineno
#define yyout base_yyout
#define yyrestart base_yyrestart
#define yytext base_yytext
#define yywrap base_yywrap
#define yyalloc base_yyalloc
#define yyrealloc base_yyrealloc
#define yyfree base_yyfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define base_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer base_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define base_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer base_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define base_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer base_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define base_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string base_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define base_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes base_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define base_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer base_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define base_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer base_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define base_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state base_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define base_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer base_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define base_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state base_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define base_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state base_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define base_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack base_yyensure_buffer_stack
#endif

#ifdef yylex
#define base_yylex_ALREADY_DEFINED
#else
#define yylex base_yylex
#endif

#ifdef yyrestart
#define base_yyrestart_ALREADY_DEFINED
#else
#define yyrestart base_yyrestart
#endif

#ifdef yylex_init
#define base_yylex_init_ALREADY_DEFINED
#else
#define yylex_init base_yylex_init
#endif

#ifdef yylex_init_extra
#define base_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra base_yylex_init_extra
#endif

#ifdef yylex_destroy
#define base_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy base_yylex_destroy
#endif

#ifdef yyget_debug
#define base_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug base_yyget_debug
#endif

#ifdef yyset_debug
#define base_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug base_yyset_debug
#endif

#ifdef yyget_extra
#define base_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra base_yyget_extra
#endif

#ifdef yyset_extra
#define base_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra base_yyset_extra
#endif

#ifdef yyget_in
#define base_yyget_in_ALREADY_DEFINED
#else
#define yyget_in base_yyget_in
#endif

#ifdef yyset_in
#define base_yyset_in_ALREADY_DEFINED
#else
#define yyset_in base_yyset_in
#endif

#ifdef yyget_out
#define base_yyget_out_ALREADY_DEFINED
#else
#define yyget_out base_yyget_out
#endif

#ifdef yyset_out
#define base_yyset_out_ALREADY_DEFINED
#else
#define yyset_out base_yyset_out
#endif

#ifdef yyget_leng
#define base_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng base_yyget_leng
#endif

#ifdef yyget_text
#define base_yyget_text_ALREADY_DEFINED
#else
#define yyget_text base_yyget_text
#endif

#ifdef yyget_lineno
#define base_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno base_yyget_lineno
#endif

#ifdef yyset_lineno
#define base_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno base_yyset_lineno
#endif

#ifdef yywrap
#define base_yywrap_ALREADY_DEFINED
#else
#define yywrap base_yywrap
#endif

#ifdef yyalloc
#define base_yyalloc_ALREADY_DEFINED
#else
#define yyalloc base_yyalloc
#endif

#ifdef yyrealloc
#define base_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc base_yyrealloc
#endif

#ifdef yyfree
#define base_yyfree_ALREADY_DEFINED
#else
#define yyfree base_yyfree
#endif

#ifdef yytext
#define base_yytext_ALREADY_DEFINED
#else
#define yytext base_yytext
#endif

#ifdef yyleng
#define base_yyleng_ALREADY_DEFINED
#else
#define yyleng base_yyleng
#endif

#ifdef yyin
#define base_yyin_ALREADY_DEFINED
#else
#define yyin base_yyin
#endif

#ifdef yyout
#define base_yyout_ALREADY_DEFINED
#else
#define yyout base_yyout
#endif

#ifdef yy_flex_debug
#define base_yy_flex_debug_ALREADY_DEFINED
#else
#define yy_flex_debug base_yy_flex_debug
#endif

#ifdef yylineno
#define base_yylineno_ALREADY_DEFINED
#else
#define yylineno base_yylineno
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define base_yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 144
#define YY_END_OF_BUFFER 145
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[636] =
    {   0,
        0,    0,   10,   10,    0,    0,    0,    0,    0,    0,
        9,    9,    0,    0,    0,    0,   19,   19,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  145,  143,   10,   17,    5,    5,
        6,    6,   42,   38,   44,   39,   44,    9,   23,   17,
       20,   19,   19,   19,   19,   24,   24,   17,   29,   23,
       33,   33,   35,   40,  134,  134,  132,   91,   91,  132,
      132,  113,   91,   91,  113,   43,  113,   74,   85,  113,
       12,   89,   90,   84,   87,   83,   88,  113,   86,   59,

       59,   81,   82,  113,   96,  113,   79,   79,   94,   95,
       92,  113,   93,   72,    1,    1,   55,   36,   55,   53,
       54,   55,   14,   54,   54,   54,   54,   59,   59,   54,
       54,   54,   54,   71,   71,   71,   71,   71,   71,  142,
      142,  142,  142,  138,  138,  137,  136,  135,  119,  119,
       10,    5,    7,    4,    3,   42,   41,   44,    9,   23,
       21,   19,   19,   19,   19,   18,   19,   19,   24,   26,
       27,   26,   26,   26,   22,   33,   32,   34,    0,    0,
      133,    0,    0,    0,    0,    0,  105,    0,    0,    0,
        0,    0,    0,  110,  101,    0,   80,  108,  102,  106,

      103,  107,   97,  112,   61,    2,    0,  109,   61,   59,
        0,    0,    0,   99,  104,   98,   79,   79,  100,    1,
        0,   55,   52,   55,    0,    0,   30,   56,   31,    1,
       46,   61,    2,   61,   59,   67,   67,   67,   67,   67,
       67,   45,   47,   70,   49,   51,   48,   50,   71,    8,
       15,   13,    0,   11,    0,  141,    0,    0,    0,  137,
      135,    0,    0,  118,    3,   19,   19,   19,   19,   27,
        0,    0,   28,   34,    0,    0,    0,    0,    0,   78,
       78,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  111,   61,    0,    2,    0,   75,   62,

       61,   64,   63,   60,    0,   79,   55,   55,   57,   31,
        1,    1,   61,   68,   68,   68,    2,   61,   59,   67,
       66,   67,   64,   63,   65,   67,   60,   67,   59,   70,
        0,    0,    0,   37,   16,  140,  139,   19,   19,   18,
       19,   19,   27,    0,    0,   28,    0,    0,    0,    0,
        0,    0,    0,    0,   78,   78,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   61,    0,   63,
        0,   79,   55,   57,   68,   63,   61,    0,   61,   68,
       59,   63,   63,   67,   67,   61,   67,   67,   67,   70,
        0,    0,    0,   70,  140,  140,  139,  139,   19,    0,

        0,  127,    0,    0,    0,    0,    0,    0,    0,   78,
       78,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   79,   55,   55,   63,   68,
       68,   68,   68,   68,    0,   61,   61,   63,   69,   69,
       67,   63,   61,   70,    0,    0,    0,    0,    0,   25,
      127,    0,  129,    0,  123,    0,    0,    0,    0,    0,
        0,   78,   78,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  117,    0,   79,   55,   68,   63,    0,
        0,   61,   68,   69,   63,   67,   67,    0,    0,    0,
        0,   70,   70,    0,    0,  131,  123,  125,    0,    0,

        0,    0,  115,    0,  117,    0,   73,   68,   68,   58,
        0,   69,   69,    0,    0,    0,    0,   70,    0,  125,
        0,    0,    0,   76,   76,  115,  121,   73,   73,   79,
       79,   79,   79,   58,   70,    0,    0,    0,    0,   76,
       76,   76,    0,   76,    0,  121,    0,    0,    0,   79,
       79,   79,   79,   79,   79,   58,   70,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   79,   79,   79,
       79,   79,   79,   79,   79,  126,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   79,   79,   79,   79,   79,
       79,   79,   79,  126,    0,  128,    0,  122,    0,    0,

        0,    0,    0,    0,   79,   79,   79,   79,   79,   79,
        0,  130,  122,  124,   77,   77,    0,    0,  116,   79,
       79,   79,  116,  124,   77,   77,   77,   77,  114,    0,
      114,   79,  120,  120,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
       22,   22,   22,   22,   22,   23,   23,   24,   25,   26,
       27,   28,   29,   29,   30,   31,   32,   33,   34,   35,
       36,   36,   37,   36,   36,   38,   39,   40,   41,   42,
       43,   44,   45,   46,   47,   36,   36,   48,   36,   36,
       49,   50,   51,   52,   53,   29,   30,   31,   32,   33,

       34,   35,   36,   36,   54,   36,   36,   38,   39,   40,
       41,   42,   43,   44,   45,   46,   55,   36,   36,   56,
       36,   36,   57,   58,   59,   29,    1,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,

       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60
    } ;

static const YY_CHAR yy_meta[61] =
    {   0,
        1,    2,    3,    3,    4,    5,    4,    6,    7,    4,
        8,    9,    9,   10,    7,    1,   11,   12,   13,   14,
       14,   14,   14,   15,   16,   17,   18,   19,    4,   20,
       20,   20,   20,   20,   20,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   22,   23,
        9,    4,   24,   21,   21,   21,    1,    4,    1,   21
    } ;

static const flex_int16_t yy_base[731] =
    {   0,
        0,    0, 2508, 2507,    0,   54, 2511, 2509,    0,    5,
     2503, 2502, 2501, 2500, 2499, 2498,   18,   21,    1,   28,
        7,   22,    0,   29, 2476, 2475, 2467, 2466,  112,    0,
       40,  171,  205,    0,  265,    0,   28,   59,   73,   86,
      325,    0,  385,    0, 2476, 3570,    0, 3570,    0,    0,
       22, 2460,    0, 2466, 3570, 3570,   10,    0,    0, 2460,
     3570,   90,   93,  174, 2453,    0,    0, 2458,  426, 2457,
        0,    0, 2459, 2460, 3570,  178, 3570, 3570, 3570,   12,
       14, 3570,   98,  185, 2437, 3570,   49,  416, 2436, 2449,
     3570, 3570, 3570,  437,   52, 3570,  166,  176,  438,  454,

      469, 3570, 3570, 2432, 2428, 2426,    0,   43, 3570, 3570,
     3570, 2395, 3570, 3570,  476,  491, 2425, 3570,  518,  446,
        0,    0, 3570, 3570, 2434,  491, 2436,  559,  497,  177,
       81, 2421, 2421,    0, 2436, 2435, 2434, 2434, 2432, 2398,
        0, 3570,    0, 3570,  536, 3570, 3570,    0, 3570,  539,
        0,    0,   26, 3570,    0,    0, 3570, 3570,    0,    0,
     3570,  482,  549, 2375,  554, 3570, 2360,  571,    0, 3570,
      438,    0,    0,    0, 3570,    0, 3570, 2345,  581,  592,
     3570,  146, 2294, 2268,  595,  467, 3570,  617,  461,  528,
     2252,  160, 2243, 3570, 3570,  510, 3570, 3570, 3570, 3570,

     3570, 3570, 2243, 3570,  658,    0, 1882, 3570,  664,  673,
      588, 1831,  679, 3570, 3570, 3570,    0, 1845, 3570,  701,
      532,    0,    0,  722,  491,  552, 3570,  692, 1870,  776,
     3570,  699,    0,  722,  739,    0,  714,  748,  755,  815,
      776, 3570, 3570,  706,    0,    0,    0,    0,    0, 3570,
     3570, 3570,  543, 3570, 1851, 3570, 1869, 1845,  785, 3570,
        0,  814,  817, 3570,    0,  849,  809,  827,  852,  668,
        0,    0,    0, 1864,  693, 1837,  422, 1837,  840, 3570,
        0, 1853,    0,  714,  713, 1824, 1751,  739, 1739, 1748,
     1725, 1727, 1724, 3570,  869,  802,    0, 1753, 3570, 3570,

      877,  841,  884, 1700, 1696, 1712,  933, 1729,    0, 1733,
        0,  987,  892,    0,  912,  896,    0,  933,  945,    0,
      780,  485,  949,  967,  888,  837, 1026, 1673,  987,  963,
     1674,    0, 1015, 3570, 3570,  921,  974, 1020, 1024, 1051,
     1061, 1067, 3570,    0,    0, 3570, 1665, 1664,  778, 1658,
     1658,  980, 1071, 1040, 1048, 1078, 1647, 1645, 1636, 1637,
     1640, 1630, 1609, 1579,  920, 1565, 1568, 1066, 1071, 1075,
     1081, 1103, 1146,    0,    0, 1091, 1109, 1102, 1113, 1117,
     1146, 1156, 1162,    0, 1166, 1172,    0, 1185, 1190, 1059,
     1214, 1217, 1220, 1224, 1236, 3570, 1241, 3570, 1245,    0,

        0, 1143, 1249, 1558, 1541, 1540, 1255, 1510, 1266, 1536,
     1273,  795, 1279, 1511, 1494, 1463,  461, 1470, 1435, 1416,
      711, 1412,  846, 1416, 1286, 1405,    0, 1327, 1286,    0,
     1281,    0, 1297, 1304, 1327, 1337, 1343, 1347,    0, 1351,
        0, 1367, 1360, 1092, 1420, 1389, 1478, 1399,    0, 3570,
     1155, 1407, 3570, 1410, 1293, 1394, 1381, 1404,  917, 1401,
     1439, 1533, 1537,    0, 1372, 1349, 1361,    0, 1351, 1338,
     1343, 1328, 1328, 1395, 1309, 1305,  925,    0, 1522, 1434,
     1441, 1537, 1445,    0, 1541,    0, 1453, 1594,    0,    0,
     1323, 1215, 1652,    0, 1563, 3570, 1481, 1500, 1575, 1304,

        0, 1301, 1566, 1299, 1569, 1292, 1639,    0, 1569, 1593,
     1310,    0, 1604, 1294,  531, 1674,    0, 1733,    0, 1578,
     1645,  496, 1275, 1582, 1604, 1628, 1634, 1721,    0, 1250,
      576,  994, 1239, 1667, 1784,    0, 1209, 1227,  888, 1656,
     1681, 1693, 1163, 1729, 1161, 1736, 1157,  998, 1141, 1117,
     1268, 1109,  960, 1095, 1087, 3570,    0, 1081, 1081, 1117,
     1049,  940,  915,  886,  867,  835,  832, 1160,  808,  807,
     1213,  806,  794,  769,  772, 1760, 1843,  759,  747,  730,
      955, 1070, 1218,  716,  694,  685, 1763, 1846,  675,  674,
      672, 1231,  662, 1767, 1849, 3570, 1852, 1770,  648,  567,

      558,  561, 1244,  557,  555, 1855, 1775,  543,  529, 1858,
     1861, 3570, 1879, 1885, 1888, 1891,  463,  428, 1894, 1897,
     1900,  168, 1903, 1906, 1909, 1912, 1915, 1918, 1921,   13,
     1924, 1927, 1930, 1933, 3570, 1937, 1961, 1985, 2009, 2033,
     2057, 2081, 2105, 2129, 2153, 2177, 2201, 2225, 2249, 2273,
     2297, 2321, 2345, 2369, 2393, 2417, 2436, 2459, 2483, 2502,
     2523, 2537, 2550, 2560, 2579, 2603, 2627, 2651, 2670, 2693,
     2714, 2733,  764,  944, 1016, 2752, 2773, 2792, 1414, 2803,
     2822, 2846, 2857, 2878, 2886, 2905, 2924, 2943, 2967, 2991,
     3015, 3034, 3057, 3078, 3097, 3121, 1053, 1215, 1216, 3140,

     3159, 3180, 3188, 3207, 3226, 3245, 1384, 3268, 1301, 1419,
     3292, 3311, 3330, 3341, 3360, 3379, 1474, 1534, 3403, 3422,
     3441, 3460, 3484, 1608, 3503, 3522, 3545, 1619, 1620, 1648
    } ;

static const flex_int16_t yy_def[731] =
    {   0,
      636,  636,  637,  637,  638,  638,  639,  639,  640,  640,
      641,  641,  642,  642,  642,  642,  643,  643,  644,  644,
      642,  642,  645,  645,  639,  639,  642,  642,  635,   29,
      646,  646,  635,   33,  635,   35,  647,  647,  648,  648,
      635,   41,  635,   43,  635,  635,  649,  635,  650,  650,
      635,  635,  651,  635,  635,  635,  635,  652,  653,  635,
      635,  635,  635,  635,  635,  654,  654,  635,  655,  653,
      656,  656,  657,  635,  635,  658,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  659,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,

      635,  635,  635,  635,  635,  635,  660,  660,  635,  635,
      635,  635,  635,  635,  635,  635,  661,  635,  659,  662,
      661,  661,  635,  635,  661,  635,  661,  663,  663,  664,
      661,  661,  661,  665,  665,  665,  665,  665,  665,  666,
      667,  635,  668,  635,  635,  635,  635,  669,  635,  670,
      649,  650,  635,  635,  671,  651,  635,  635,  652,  653,
      635,  635,  635,  635,  635,  635,  635,  672,  654,  635,
      635,  673,  674,  675,  635,  656,  635,  676,  635,  658,
      635,  635,  635,  635,  635,  659,  635,  635,  188,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,

      635,  635,  635,  635,  635,  677,  678,  635,  635,  635,
      635,  679,  635,  635,  635,  635,  660,  660,  635,  635,
      659,  661,  661,  188,  188,  635,  635,  680,  681,  682,
      635,  683,  684,  683,  685,  686,  686,  686,  686,  686,
      686,  635,  635,  687,  661,  661,  661,  661,  688,  635,
      635,  635,  635,  635,  689,  635,  690,  691,  635,  635,
      692,  635,  693,  635,  694,  695,  696,  696,  696,  635,
      697,  698,  699,  676,  635,  635,  635,  635,  188,  635,
      279,  279,  188,  279,  188,  188,  188,  279,  635,  635,
      635,  635,  635,  635,  635,  635,  677,  678,  635,  635,

      635,  635,  635,  679,  679,  660,  279,  307,  700,  681,
      682,  682,  683,  701,  701,  701,  702,  313,  703,  686,
      686,  686,  635,  704,  686,  686,  686,  327,  705,  706,
      635,  707,  708,  635,  635,  635,  635,  695,  695,  695,
      695,  696,  635,  709,  710,  635,  635,  635,  635,  635,
      635,  635,  711,  279,  279,  279,  188,  188,  188,  188,
      279,  279,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  660,  711,  700,  701,  712,  713,  635,  318,  701,
      703,  714,  704,  715,  715,  318,  686,  686,  686,  716,
      708,  708,  708,  708,  635,  635,  635,  635,  695,  717,

      718,  635,  635,  635,  635,  635,  635,  635,  711,  719,
      711,  279,  711,  188,  188,  188,  188,  279,  279,  635,
      635,  635,  635,  635,  635,  660,  373,  279,  712,  720,
      720,  701,  701,  701,  635,  318,  713,  714,  721,  721,
      715,  722,  318,  716,  723,  708,  635,  708,  724,  635,
      635,  635,  635,  635,  635,  635,  635,  719,  635,  279,
      711,  711,  711,  188,  188,  188,  188,  279,  279,  635,
      635,  635,  635,  635,  635,  660,  428,  720,  725,  635,
      635,  318,  701,  721,  726,  715,  715,  723,  488,  488,
      488,  488,  727,  728,  635,  635,  635,  635,  635,  188,

      279,  635,  635,  635,  635,  635,  660,  720,  720,  635,
      635,  721,  721,  488,  488,  488,  488,  727,  729,  635,
      635,  635,  635,  188,  635,  635,  635,  635,  528,  660,
      660,  660,  660,  635,  635,  730,  635,  635,  635,  279,
      635,  279,  279,  635,  635,  635,  635,  635,  635,  660,
      660,  660,  660,  660,  660,  635,  535,  635,  635,  635,
      635,  635,  279,  635,  635,  635,  635,  660,  660,  660,
      660,  660,  660,  660,  660,  635,  635,  635,  635,  635,
      279,  635,  635,  635,  635,  660,  660,  660,  660,  660,
      660,  660,  660,  635,  635,  635,  635,  635,  635,  279,

      635,  635,  635,  635,  660,  660,  660,  660,  660,  660,
      635,  635,  635,  635,  279,  635,  635,  635,  635,  660,
      660,  660,  635,  635,  279,  635,  279,  635,  635,  635,
      635,  660,  635,  635,    0,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,

      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635
    } ;

static const flex_int16_t yy_nxt[3631] =
    {   0,
      635,  635,   72,   67,   50,   56,   50,   73,   50,   50,
       56,   68,  635,   51,   50,  158,   50,   48,   52,   62,
       63,   64,   62,   63,   64,   50,   50,   50,   50,  635,
       67,   72,   48,  141,   65,  153,   73,   65,   68,  153,
      154,   78,   79,   78,  154,  182,  633,   80,  183,   57,
       69,   50,  142,  143,   57,  142,   70,   50,   50,  158,
       50,  184,   50,   50,  141,  183,  199,   51,   50,  184,
       50,   70,   52,   81,  145,  145,  145,   69,  200,   50,
       50,   50,   50,  142,  143,  189,  142,  145,  145,  145,
      218,  162,  163,  163,  165,  165,  165,  146,  218,  185,

      185,  185,  190,  166,  186,   50,  164,  245,  246,  167,
      146,   50,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       75,   75,   75,   75,   76,   76,   76,   76,   75,   75,
       75,   76,   78,   79,   78,  165,  165,  165,   80,  179,
      179,  179,  201,  275,  166,  276,  185,  185,  185,  204,
      167,  186,  202,  203,  277,  205,  205,  205,  205,  292,

      242,  632,  181,  243,   81,   82,   83,   84,   83,   85,
       86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
       96,   97,   98,   99,  100,  101,  101,  101,  102,  103,
      104,  105,  106,   82,  107,  107,  107,  107,  108,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  109,   82,  110,   82,  107,  107,  107,
      107,  111,  112,  113,  107,  114,  115,  116,  115,  117,
      118,  119,  120,  121,  122,  123,  124,  124,  121,  121,
      124,  125,  126,  127,  128,  129,  129,  129,  130,  124,
      131,  132,  133,  122,  134,  135,  134,  134,  136,  134,

      134,  134,  134,  134,  137,  134,  134,  134,  134,  134,
      134,  138,  139,  124,  114,  124,  121,  134,  134,  138,
      139,  114,  122,  114,  134,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  147,  147,  147,  147,  148,  148,  148,
      148,  147,  147,  147,  148,  149,  149,  149,  149,  149,
      149,  149,  149,  149,  149,  149,  149,  149,  149,  149,

      149,  149,  149,  149,  149,  149,  149,  149,  149,  149,
      149,  149,  149,  149,  150,  150,  150,  150,  150,  150,
      150,  150,  150,  150,  150,  150,  150,  150,  150,  150,
      150,  150,  150,  149,  149,  149,  149,  150,  150,  150,
      150,  149,  149,  149,  150,  171,  171,  171,  191,  182,
      196,  206,  192,  227,  350,  197,  207,  270,  270,  270,
      630,  351,  193,  198,  208,  228,  228,  228,  228,  192,
      193,  209,  172,  210,  210,  210,  210,  220,  220,  220,
      173,  174,  221,  162,  163,  163,  209,  211,  210,  210,
      210,  210,  220,  220,  220,  285,  629,  221,  164,  286,

      287,  212,  211,  189,  321,  321,  213,  467,  231,  212,
      232,  232,  232,  232,  234,  467,  235,  235,  235,  235,
      190,  213,  224,  196,  224,  285,  224,  224,  197,  286,
      238,  224,  224,  537,  224,  538,  224,  259,  259,  259,
      262,  262,  262,  224,  224,  224,  224,  491,  334,  241,
      165,  165,  165,  335,  225,  165,  165,  165,  516,  166,
      260,  622,  288,  264,  166,  167,  289,  290,  225,  224,
      167,  226,  268,  163,  163,  224,  234,  621,  235,  235,
      235,  235,  179,  179,  179,  226,  288,  269,  620,  237,
      289,  619,  238,  179,  179,  179,  185,  185,  185,  239,

      617,  186,  302,  616,  302,  181,  240,  303,  303,  303,
      303,  241,  615,  551,  240,  552,  181,  279,  279,  280,
      281,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  282,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  279,  284,  279,  279,  279,
      283,  283,  283,  279,  279,  279,  279,  295,  295,  295,
      295,  300,  614,  301,  301,  301,  301,  343,  343,  343,
      209,  211,  210,  210,  210,  210,  610,  211,  210,  210,

      210,  210,  220,  220,  220,  608,  211,  221,  607,  606,
      296,  228,  228,  228,  228,  354,  355,  356,  313,  313,
      313,  313,  331,  332,  605,  213,  307,  604,  307,  347,
      307,  307,  315,  321,  321,  307,  307,  348,  307,  300,
      308,  318,  318,  318,  318,  357,  347,  307,  307,  307,
      307,  316,  358,  603,  333,  315,  234,  471,  319,  319,
      319,  319,  323,  599,  323,  471,  322,  324,  324,  324,
      324,  361,  238,  307,  325,  325,  325,  271,  362,  307,
      312,  598,  312,  271,  312,  312,  259,  259,  259,  312,
      312,  241,  312,  597,  312,  329,  329,  329,  329,  321,

      321,  312,  312,  312,  312,  593,  592,  326,  412,  260,
      268,  163,  163,  460,  404,  262,  262,  262,  262,  262,
      262,  295,  295,  295,  295,  269,  591,  312,  268,  163,
      163,  404,  322,  312,  327,  327,  327,  327,  264,  590,
      588,  264,  587,  269,  327,  327,  327,  327,  327,  327,
      339,  165,  165,  268,  163,  163,  325,  325,  325,  340,
      303,  303,  303,  303,  585,  341,  584,  328,  342,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  295,  295,
      295,  295,  473,  279,  279,  279,  368,  368,  368,  368,

      473,  583,  211,  370,  370,  370,  370,  325,  325,  325,
      211,  313,  313,  313,  313,  377,  377,  377,  377,  582,
      561,  296,  395,  395,  395,  315,  323,  562,  323,  369,
      459,  376,  376,  376,  376,  279,  371,  307,  373,  307,
      326,  307,  307,  308,  316,  396,  307,  307,  581,  307,
      378,  308,  379,  379,  379,  379,  422,  272,  307,  307,
      307,  307,  234,  272,  381,  381,  381,  381,  382,  382,
      382,  382,  580,  422,  320,  397,  397,  397,  238,  331,
      332,  407,  407,  407,  307,  380,  383,  383,  383,  383,
      307,  312,  572,  312,  320,  312,  312,  241,  398,  573,

      312,  312,  600,  312,  386,  312,  329,  329,  329,  329,
      600,  333,  312,  312,  312,  312,  391,  391,  391,  385,
      388,  339,  165,  165,  408,  339,  165,  165,  553,  273,
      340,  393,  539,  554,  340,  273,  341,  566,  312,  389,
      341,  354,  355,  356,  312,  327,  327,  327,  327,  354,
      355,  356,  339,  165,  165,  327,  327,  327,  327,  327,
      327,  340,  339,  165,  165,  394,  344,  341,  268,  163,
      163,  340,  344,  410,  411,  331,  332,  399,  328,  354,
      355,  356,  579,  342,  412,  368,  368,  368,  368,  282,
      368,  368,  368,  368,  370,  370,  370,  370,  375,  211,

      370,  370,  370,  370,  425,  425,  425,  333,  331,  332,
      429,  429,  429,  429,  577,  576,  375,  601,  369,  575,
      413,  435,  435,  435,  435,  601,  574,  371,  377,  377,
      377,  377,  436,  436,  436,  436,  437,  437,  437,  437,
      333,  571,  433,  431,  451,  451,  451,  426,  410,  411,
      427,  568,  427,  578,  427,  427,  451,  451,  451,  428,
      427,  434,  427,  386,  308,  381,  381,  381,  381,  320,
      578,  427,  427,  427,  427,  438,  438,  438,  438,  238,
      567,  383,  383,  383,  383,  442,  442,  442,  442,  300,
      565,  443,  443,  443,  443,  413,  586,  427,  241,  323,

      564,  323,  563,  427,  324,  324,  324,  324,  440,  329,
      329,  329,  329,  586,  385,  391,  391,  391,  391,  391,
      391,  391,  391,  391,  314,  391,  391,  391,  345,  346,
      393,  515,  516,  393,  345,  346,  445,  395,  395,  395,
      446,  447,  397,  397,  397,  558,  339,  165,  165,  589,
      452,  452,  452,  559,  602,  340,  407,  407,  407,  560,
      396,  399,  558,  517,  394,  398,  589,  394,  410,  411,
      394,  602,  448,  453,  394,  410,  411,  609,  555,  412,
      461,  462,  463,  550,  282,  609,  412,  425,  425,  425,
      618,  282,  412,  375,  497,  497,  497,  282,  618,  408,

      479,  479,  479,  479,  569,  429,  429,  429,  429,  539,
      491,  323,  570,  323,  400,  413,  376,  376,  376,  376,
      400,  569,  413,  377,  377,  377,  377,  480,  413,  528,
      475,  307,  527,  307,  525,  307,  307,  524,  431,  491,
      428,  307,  507,  307,  480,  477,  481,  481,  481,  481,
      375,  506,  307,  307,  307,  307,  482,  482,  482,  482,
      504,  503,  437,  437,  437,  437,  438,  438,  438,  438,
      485,  485,  485,  485,  441,  502,  433,  635,  307,  482,
      482,  482,  482,  501,  307,  468,  442,  442,  442,  442,
      391,  391,  391,  500,  464,  483,  505,  505,  505,  440,

      391,  391,  391,  390,  390,  445,  464,  390,  452,  452,
      452,  495,  495,  495,  353,  393,  447,  459,  499,  487,
      488,  489,  391,  391,  488,  488,  488,  304,  498,  488,
      488,  453,  401,  304,  496,  488,  491,  304,  401,  394,
      461,  462,  463,  488,  488,  488,  488,  476,  488,  394,
      474,  472,  412,  510,  510,  510,  510,  282,  480,  470,
      511,  511,  511,  511,  437,  437,  437,  437,  469,  488,
      492,  488,  442,  442,  442,  442,  488,  488,  488,  391,
      391,  391,  497,  497,  497,  392,  392,  449,  413,  392,
      392,  392,  392,  449,  393,  392,  392,  392,  392,  392,

      392,  520,  520,  520,  468,  392,  466,  493,  493,  493,
      493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
      493,  493,  493,  493,  493,  493,  392,  465,  394,  478,
      493,  493,  493,  493,  461,  462,  463,  493,  461,  462,
      463,  479,  479,  479,  479,  464,  412,  450,  484,  459,
      412,  282,  457,  450,  635,  282,  482,  482,  482,  482,
      485,  485,  485,  485,  495,  495,  495,  526,  526,  526,
      505,  505,  505,  456,  509,  455,  521,  521,  521,  520,
      520,  520,  413,  540,  541,  542,  413,  496,  479,  479,
      479,  479,  454,  513,  488,  489,  391,  391,  488,  488,

      488,  424,  423,  488,  488,  544,  544,  544,  522,  488,
      514,  523,  534,  534,  534,  534,  421,  488,  488,  488,
      488,  494,  488,  485,  485,  485,  485,  494,  523,  526,
      526,  526,  519,  536,  543,  546,  546,  546,  519,  536,
      529,  529,  529,  488,  492,  488,  521,  521,  521,  420,
      488,  488,  488,  391,  391,  391,  545,  540,  541,  542,
      392,  450,  419,  392,  392,  392,  392,  450,  446,  447,
      392,  530,  531,  418,  417,  532,  416,  415,  522,  392,
      414,  523,  544,  544,  544,  533,  556,  556,  556,  556,
      406,  405,  532,  533,  540,  541,  542,  403,  523,  402,

      448,  332,  394,  535,  535,  535,  535,  535,  535,  535,
      535,  535,  535,  535,  535,  535,  535,  535,  535,  535,
      535,  535,  529,  529,  529,  320,  535,  535,  535,  535,
      544,  544,  544,  535,  391,  391,  391,  546,  546,  546,
      227,  392,  373,  372,  392,  392,  392,  392,  635,  446,
      447,  392,  305,  547,  522,  299,  367,  548,  366,  365,
      392,  594,  594,  594,  594,  594,  594,  549,  594,  594,
      594,  613,  613,  613,  548,  549,  613,  613,  613,  364,
      363,  448,  360,  394,  488,  489,  391,  391,  488,  488,
      488,  557,  490,  488,  488,  490,  490,  490,  490,  488,

      515,  516,  490,  557,  557,  557,  557,  488,  488,  488,
      488,  490,  488,  557,  557,  557,  557,  557,  557,  557,
      557,  557,  557,  557,  557,  557,  557,  557,  557,  557,
      557,  557,  517,  488,  492,  488,  557,  557,  557,  557,
      488,  488,  488,  557,  595,  595,  595,  595,  595,  595,
      595,  595,  595,  611,  611,  611,  611,  611,  611,  623,
      623,  623,  611,  611,  611,  359,  353,  596,  352,  349,
      596,  177,  337,  596,  336,  256,  612,  227,  306,  612,
      613,  613,  613,  305,  299,  612,  624,  624,  624,  625,
      626,  627,  628,  628,  628,  623,  623,  623,  631,  631,

      631,  624,  624,  624,  623,  623,  623,  624,  624,  624,
      625,  626,  627,  628,  628,  628,  625,  626,  627,  628,
      628,  628,  631,  631,  631,  631,  631,  631,  634,  634,
      634,  634,  634,  634,  634,  634,  634,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   47,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,

       49,   49,   49,   49,   49,   49,   49,   49,   49,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   58,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   58,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   58,   58,   58,
       58,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

       59,   59,   59,   59,   59,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   66,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,   77,   77,

       77,  140,  140,  140,  140,  140,  140,  140,  140,  140,
      140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
      140,  140,  140,  140,  140,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  151,
      151,  151,  151,  151,  151,  151,  294,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  152,  152,  152,  152,  152,  152,  152,
      152,  152,  293,  152,  152,  291,  152,  152,  152,  152,
      152,  152,  152,  152,  152,  152,  152,  156,  156,  156,

      156,  278,  156,  156,  156,  156,  156,  156,  156,  156,
      156,  156,  156,  156,  156,  156,  156,  156,  156,  156,
      156,  159,  159,  159,  159,  159,  159,  159,  277,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  160,  160,  160,  160,  160,
      160,  160,  177,  160,  160,  160,  160,  160,  160,  160,
      160,  160,  160,  160,  160,  160,  160,  160,  160,  169,
      169,  169,  169,  169,  169,  169,  266,  169,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  168,  169,  170,  170,  170,  170,  170,  170,  170,

      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  176,  176,  176,
      176,  176,  256,  176,  176,  176,  176,  176,  176,  176,
      176,  176,  176,  176,  176,  176,  176,  176,  176,  176,
      176,  178,  254,  253,  252,  251,  250,  248,  247,  233,
      230,  223,  219,  216,  215,  178,  178,  214,  195,  178,
      180,  180,  194,  187,  180,  157,  177,  175,  161,  168,
      161,  157,  180,  155,  180,  635,   60,   60,  180,  180,
       74,   74,  180,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,

      188,  188,  188,  188,  188,  188,  188,  217,   60,   60,
       60,   60,   48,   48,   54,  217,   54,   48,   48,  635,
      635,  217,  217,  635,  635,  217,  222,  635,  635,  222,
      635,  635,  222,  222,  635,  222,  635,  635,  635,  222,
      222,  222,  229,  635,  635,  635,  635,  635,  635,  635,
      229,  635,  635,  635,  635,  635,  229,  229,  635,  635,
      229,  236,  635,  236,  635,  635,  635,  635,  635,  236,
      236,  635,  635,  236,  244,  635,  635,  244,  635,  244,
      244,  635,  635,  244,  249,  635,  635,  635,  635,  635,
      635,  635,  249,  635,  635,  635,  635,  635,  249,  249,

      635,  635,  249,  255,  255,  255,  255,  635,  255,  255,
      255,  255,  255,  255,  255,  255,  255,  255,  255,  635,
      255,  635,  255,  255,  255,  255,  255,  257,  257,  257,
      257,  635,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  258,  258,  258,  258,  258,  258,  258,  258,  258,
      258,  258,  258,  258,  258,  258,  258,  258,  258,  635,
      258,  258,  258,  258,  258,  261,  635,  635,  635,  635,
      635,  635,  635,  261,  635,  635,  635,  635,  635,  261,
      261,  635,  635,  261,  263,  263,  635,  635,  263,  635,

      635,  635,  635,  635,  635,  635,  263,  635,  263,  635,
      635,  635,  263,  263,  635,  635,  263,  265,  635,  635,
      265,  635,  635,  265,  265,  635,  265,  635,  635,  635,
      265,  265,  265,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  274,  635,  635,
      635,  635,  635,  635,  635,  274,  635,  635,  635,  635,
      635,  274,  274,  635,  635,  274,  297,  635,  635,  297,
      635,  635,  297,  297,  635,  297,  635,  635,  635,  297,
      297,  297,  298,  298,  298,  298,  298,  298,  298,  298,

      298,  298,  298,  298,  298,  298,  298,  298,  298,  298,
      298,  298,  298,  298,  298,  298,  309,  635,  635,  635,
      635,  635,  309,  309,  635,  635,  309,  310,  635,  635,
      635,  635,  635,  635,  635,  310,  635,  635,  635,  635,
      635,  310,  310,  635,  635,  310,  311,  311,  635,  311,
      311,  311,  311,  311,  311,  311,  311,  311,  311,  311,
      311,  311,  311,  311,  311,  311,  311,  311,  311,  311,
      314,  635,  635,  635,  635,  635,  314,  314,  635,  635,
      314,  317,  635,  635,  317,  635,  635,  317,  317,  635,
      317,  635,  635,  635,  317,  317,  317,  236,  635,  236,

      635,  635,  635,  635,  635,  236,  236,  635,  635,  236,
      320,  635,  635,  635,  635,  635,  635,  635,  320,  635,
      635,  635,  635,  635,  320,  320,  635,  635,  320,  330,
      635,  635,  635,  635,  330,  330,  635,  330,  635,  635,
      635,  635,  635,  330,  330,  330,  635,  330,  249,  635,
      635,  635,  635,  635,  635,  635,  249,  635,  635,  635,
      635,  635,  249,  249,  635,  635,  249,  255,  255,  255,
      255,  635,  255,  255,  255,  255,  255,  255,  255,  255,
      255,  255,  255,  635,  255,  635,  255,  255,  255,  255,
      255,  257,  257,  257,  257,  257,  257,  257,  257,  257,

      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  258,  258,  258,  258,  258,
      258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
      258,  258,  258,  258,  258,  258,  258,  258,  258,  261,
      635,  635,  635,  635,  635,  635,  635,  261,  635,  635,
      635,  635,  635,  261,  261,  635,  635,  261,  263,  263,
      635,  635,  263,  635,  635,  635,  635,  635,  635,  635,
      263,  635,  263,  635,  635,  635,  263,  263,  635,  635,
      263,  265,  635,  635,  265,  635,  635,  265,  265,  635,
      265,  635,  635,  635,  265,  265,  265,  338,  338,  338,

      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
      338,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  374,  635,  635,  635,  635,
      635,  635,  635,  374,  635,  635,  635,  635,  635,  374,
      374,  635,  635,  374,  375,  635,  635,  635,  635,  635,
      635,  635,  375,  635,  635,  635,  635,  635,  375,  375,
      635,  635,  375,  317,  635,  635,  317,  635,  635,  317,
      317,  635,  317,  635,  635,  635,  317,  317,  317,  236,

      635,  236,  635,  635,  635,  635,  635,  236,  236,  635,
      635,  236,  384,  635,  635,  635,  635,  635,  635,  635,
      384,  635,  635,  635,  635,  635,  384,  384,  635,  635,
      384,  387,  635,  635,  635,  635,  635,  387,  635,  387,
      635,  635,  635,  635,  635,  387,  387,  635,  635,  387,
      330,  635,  635,  635,  635,  330,  330,  635,  330,  635,
      635,  635,  635,  635,  330,  330,  330,  635,  330,  392,
      392,  635,  635,  392,  392,  635,  392,  392,  392,  392,
      392,  392,  635,  635,  635,  635,  392,  392,  392,  392,
      635,  392,  409,  409,  409,  409,  409,  409,  409,  409,

      409,  409,  409,  409,  409,  409,  409,  409,  409,  409,
      409,  409,  409,  409,  409,  409,  430,  635,  635,  635,
      635,  635,  635,  635,  430,  635,  635,  635,  635,  635,
      430,  430,  635,  635,  430,  432,  635,  635,  635,  635,
      635,  635,  635,  432,  635,  635,  635,  635,  635,  432,
      432,  635,  635,  432,  439,  635,  635,  635,  635,  635,
      439,  439,  635,  635,  439,  441,  635,  635,  635,  635,
      635,  635,  635,  441,  635,  635,  635,  635,  635,  441,
      441,  635,  635,  441,  444,  635,  635,  635,  635,  444,
      444,  635,  444,  635,  635,  635,  635,  635,  444,  444,

      444,  635,  444,  458,  458,  458,  458,  458,  458,  458,
      458,  458,  458,  458,  458,  635,  458,  458,  458,  458,
      458,  458,  458,  458,  458,  458,  458,  478,  635,  635,
      635,  635,  635,  635,  635,  478,  635,  635,  635,  635,
      635,  478,  478,  635,  635,  478,  484,  635,  635,  635,
      635,  635,  635,  635,  484,  635,  635,  635,  635,  635,
      484,  484,  635,  635,  484,  486,  635,  635,  635,  635,
      635,  635,  635,  486,  635,  635,  635,  635,  635,  486,
      486,  635,  635,  486,  490,  490,  490,  490,  490,  490,
      490,  490,  490,  490,  490,  490,  490,  490,  490,  490,

      490,  490,  490,  490,  490,  490,  490,  490,  508,  635,
      635,  635,  635,  635,  635,  635,  508,  635,  635,  635,
      635,  635,  508,  508,  635,  635,  508,  512,  635,  635,
      635,  635,  635,  635,  635,  512,  635,  635,  635,  635,
      635,  512,  512,  635,  635,  512,  518,  518,  635,  635,
      518,  518,  635,  518,  518,  518,  518,  518,  518,  635,
      635,  635,  635,  518,  518,  518,  518,  635,  518,   45,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,

      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635
    } ;

static const flex_int16_t yy_chk[3631] =
    {   0,
        0,    0,   23,   19,    5,    9,    5,   23,    5,    5,
       10,   19,    0,    5,    5,   57,    5,   21,    5,   17,
       17,   17,   18,   18,   18,    5,    5,    5,    5,    0,
       20,   24,   22,   37,   17,   51,   24,   18,   20,  153,
       51,   31,   31,   31,  153,   80,  630,   31,   80,    9,
       19,    5,   37,   37,   10,   37,   21,    5,    6,   57,
        6,   81,    6,    6,   38,   80,   95,    6,    6,   81,
        6,   22,    6,   31,   39,   39,   39,   20,   95,    6,
        6,    6,    6,   38,   38,   87,   38,   40,   40,   40,
      108,   62,   62,   62,   63,   63,   63,   39,  108,   83,

       83,   83,   87,   63,   83,    6,   62,  131,  131,   63,
       40,    6,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   32,   32,   32,   64,   64,   64,   32,   76,
       76,   76,   97,  182,   64,  182,   84,   84,   84,   98,
       64,   84,   97,   97,  192,   98,   98,   98,   98,  192,

      130,  622,   76,  130,   32,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,

       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,

       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   69,   69,   69,   88,   88,
       94,   99,   88,  120,  277,   94,   99,  171,  171,  171,
      618,  277,   88,   94,   99,  120,  120,  120,  120,   88,
       88,  100,   69,  100,  100,  100,  100,  115,  115,  115,
       69,   69,  115,  162,  162,  162,  101,  100,  101,  101,
      101,  101,  116,  116,  116,  189,  617,  116,  162,  189,

      189,  100,  101,  186,  322,  322,  100,  417,  126,  100,
      126,  126,  126,  126,  129,  417,  129,  129,  129,  129,
      186,  101,  119,  196,  119,  225,  119,  119,  196,  225,
      129,  119,  119,  522,  119,  522,  119,  145,  145,  145,
      150,  150,  150,  119,  119,  119,  119,  515,  253,  129,
      163,  163,  163,  253,  119,  165,  165,  165,  515,  163,
      145,  609,  190,  150,  165,  163,  190,  190,  221,  119,
      165,  119,  168,  168,  168,  119,  128,  608,  128,  128,
      128,  128,  179,  179,  179,  221,  226,  168,  605,  128,
      226,  604,  128,  180,  180,  180,  185,  185,  185,  128,

      602,  185,  211,  601,  211,  179,  128,  211,  211,  211,
      211,  128,  600,  531,  128,  531,  180,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  205,  205,  205,
      205,  209,  599,  209,  209,  209,  209,  270,  270,  270,
      210,  205,  210,  210,  210,  210,  593,  209,  213,  213,

      213,  213,  220,  220,  220,  591,  210,  220,  590,  589,
      205,  228,  228,  228,  228,  284,  284,  284,  232,  232,
      232,  232,  244,  244,  586,  210,  224,  585,  224,  275,
      224,  224,  232,  237,  237,  224,  224,  275,  224,  234,
      224,  234,  234,  234,  234,  285,  275,  224,  224,  224,
      224,  232,  285,  584,  244,  234,  235,  421,  235,  235,
      235,  235,  238,  580,  238,  421,  237,  238,  238,  238,
      238,  288,  235,  224,  239,  239,  239,  673,  288,  224,
      230,  579,  230,  673,  230,  230,  259,  259,  259,  230,
      230,  235,  230,  578,  230,  241,  241,  241,  241,  321,

      321,  230,  230,  230,  230,  575,  574,  239,  412,  259,
      267,  267,  267,  412,  349,  262,  262,  262,  263,  263,
      263,  296,  296,  296,  296,  267,  573,  230,  268,  268,
      268,  349,  321,  230,  240,  240,  240,  240,  262,  572,
      570,  263,  569,  268,  240,  240,  240,  240,  240,  240,
      266,  266,  266,  269,  269,  269,  326,  326,  326,  266,
      302,  302,  302,  302,  567,  266,  566,  240,  269,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  295,  295,
      295,  295,  423,  279,  279,  279,  301,  301,  301,  301,

      423,  565,  295,  303,  303,  303,  303,  325,  325,  325,
      301,  313,  313,  313,  313,  316,  316,  316,  316,  564,
      539,  295,  336,  336,  336,  313,  315,  539,  315,  301,
      459,  315,  315,  315,  315,  459,  303,  307,  477,  307,
      325,  307,  307,  477,  313,  336,  307,  307,  563,  307,
      318,  307,  318,  318,  318,  318,  365,  674,  307,  307,
      307,  307,  319,  674,  319,  319,  319,  319,  323,  323,
      323,  323,  562,  365,  324,  337,  337,  337,  319,  330,
      330,  352,  352,  352,  307,  318,  324,  324,  324,  324,
      307,  312,  553,  312,  329,  312,  312,  319,  337,  553,

      312,  312,  581,  312,  329,  312,  329,  329,  329,  329,
      581,  330,  312,  312,  312,  312,  333,  333,  333,  324,
      329,  338,  338,  338,  352,  339,  339,  339,  532,  675,
      338,  333,  548,  532,  339,  675,  338,  548,  312,  329,
      339,  354,  354,  354,  312,  327,  327,  327,  327,  355,
      355,  355,  340,  340,  340,  327,  327,  327,  327,  327,
      327,  340,  341,  341,  341,  333,  697,  340,  342,  342,
      342,  341,  697,  353,  353,  390,  390,  341,  327,  356,
      356,  356,  561,  342,  353,  368,  368,  368,  368,  353,
      369,  369,  369,  369,  370,  370,  370,  370,  376,  368,

      371,  371,  371,  371,  372,  372,  372,  390,  444,  444,
      376,  376,  376,  376,  559,  558,  377,  582,  368,  555,
      353,  378,  378,  378,  378,  582,  554,  370,  377,  377,
      377,  377,  379,  379,  379,  379,  380,  380,  380,  380,
      444,  552,  377,  376,  402,  402,  402,  372,  373,  373,
      373,  550,  373,  560,  373,  373,  451,  451,  451,  373,
      373,  377,  373,  381,  373,  381,  381,  381,  381,  383,
      560,  373,  373,  373,  373,  382,  382,  382,  382,  381,
      549,  383,  383,  383,  383,  385,  385,  385,  385,  386,
      547,  386,  386,  386,  386,  373,  568,  373,  381,  388,

      545,  388,  543,  373,  388,  388,  388,  388,  382,  389,
      389,  389,  389,  568,  383,  391,  391,  391,  392,  392,
      392,  393,  393,  393,  386,  394,  394,  394,  698,  699,
      391,  492,  492,  392,  698,  699,  393,  395,  395,  395,
      394,  394,  397,  397,  397,  537,  399,  399,  399,  571,
      403,  403,  403,  537,  583,  399,  407,  407,  407,  538,
      395,  399,  537,  492,  391,  397,  571,  392,  409,  409,
      393,  583,  394,  403,  394,  411,  411,  592,  533,  409,
      413,  413,  413,  530,  409,  592,  411,  425,  425,  425,
      603,  411,  413,  429,  455,  455,  455,  413,  603,  407,

      431,  431,  431,  431,  551,  429,  429,  429,  429,  523,
      514,  433,  551,  433,  709,  409,  433,  433,  433,  433,
      709,  551,  411,  434,  434,  434,  434,  511,  413,  506,
      425,  428,  504,  428,  502,  428,  428,  500,  429,  491,
      428,  428,  476,  428,  435,  428,  435,  435,  435,  435,
      437,  475,  428,  428,  428,  428,  436,  436,  436,  436,
      473,  472,  437,  437,  437,  437,  438,  438,  438,  438,
      440,  440,  440,  440,  442,  471,  437,  443,  428,  443,
      443,  443,  443,  470,  428,  469,  442,  442,  442,  442,
      446,  446,  446,  467,  466,  437,  474,  474,  474,  438,

      448,  448,  448,  707,  707,  446,  465,  707,  452,  452,
      452,  454,  454,  454,  460,  448,  446,  458,  457,  442,
      445,  445,  445,  445,  445,  445,  445,  679,  456,  445,
      445,  452,  710,  679,  454,  445,  445,  679,  710,  446,
      461,  461,  461,  445,  445,  445,  445,  426,  445,  448,
      424,  422,  461,  480,  480,  480,  480,  461,  481,  420,
      481,  481,  481,  481,  483,  483,  483,  483,  419,  445,
      445,  445,  487,  487,  487,  487,  445,  445,  445,  447,
      447,  447,  497,  497,  497,  447,  447,  717,  461,  447,
      447,  447,  447,  717,  447,  447,  447,  447,  447,  447,

      447,  498,  498,  498,  418,  447,  416,  447,  447,  447,
      447,  447,  447,  447,  447,  447,  447,  447,  447,  447,
      447,  447,  447,  447,  447,  447,  447,  415,  447,  479,
      447,  447,  447,  447,  462,  462,  462,  447,  463,  463,
      463,  479,  479,  479,  479,  414,  462,  718,  485,  410,
      463,  462,  408,  718,  482,  463,  482,  482,  482,  482,
      485,  485,  485,  485,  495,  495,  495,  503,  503,  503,
      505,  505,  505,  406,  479,  405,  499,  499,  499,  520,
      520,  520,  462,  524,  524,  524,  463,  495,  509,  509,
      509,  509,  404,  485,  488,  488,  488,  488,  488,  488,

      488,  367,  366,  488,  488,  525,  525,  525,  499,  488,
      488,  499,  510,  510,  510,  510,  364,  488,  488,  488,
      488,  724,  488,  513,  513,  513,  513,  724,  499,  526,
      526,  526,  728,  729,  524,  527,  527,  527,  728,  729,
      507,  507,  507,  488,  488,  488,  521,  521,  521,  363,
      488,  488,  488,  493,  493,  493,  525,  540,  540,  540,
      493,  730,  362,  493,  493,  493,  493,  730,  493,  493,
      493,  507,  507,  361,  360,  507,  359,  358,  521,  493,
      357,  521,  541,  541,  541,  507,  534,  534,  534,  534,
      351,  350,  507,  507,  542,  542,  542,  348,  521,  347,

      493,  331,  493,  516,  516,  516,  516,  516,  516,  516,
      516,  516,  516,  516,  516,  516,  516,  516,  516,  516,
      516,  516,  528,  528,  528,  328,  516,  516,  516,  516,
      544,  544,  544,  516,  518,  518,  518,  546,  546,  546,
      310,  518,  308,  306,  518,  518,  518,  518,  305,  518,
      518,  518,  304,  528,  528,  298,  293,  528,  292,  291,
      518,  576,  576,  576,  587,  587,  587,  528,  594,  594,
      594,  598,  598,  598,  528,  528,  607,  607,  607,  290,
      289,  518,  287,  518,  535,  535,  535,  535,  535,  535,
      535,  535,  535,  535,  535,  535,  535,  535,  535,  535,

      535,  535,  535,  535,  535,  535,  535,  535,  535,  535,
      535,  535,  535,  535,  535,  535,  535,  535,  535,  535,
      535,  535,  535,  535,  535,  535,  535,  535,  535,  535,
      535,  535,  535,  535,  535,  535,  535,  535,  535,  535,
      535,  535,  535,  535,  577,  577,  577,  588,  588,  588,
      595,  595,  595,  597,  597,  597,  606,  606,  606,  610,
      610,  610,  611,  611,  611,  286,  282,  577,  278,  276,
      588,  274,  258,  595,  257,  255,  597,  229,  218,  606,
      613,  613,  613,  212,  207,  611,  614,  614,  614,  615,
      615,  615,  616,  616,  616,  619,  619,  619,  620,  620,

      620,  621,  621,  621,  623,  623,  623,  624,  624,  624,
      625,  625,  625,  626,  626,  626,  627,  627,  627,  628,
      628,  628,  629,  629,  629,  631,  631,  631,  632,  632,
      632,  633,  633,  633,  634,  634,  634,  636,  636,  636,
      636,  636,  636,  636,  636,  636,  636,  636,  636,  636,
      636,  636,  636,  636,  636,  636,  636,  636,  636,  636,
      636,  637,  637,  637,  637,  637,  637,  637,  637,  637,
      637,  637,  637,  637,  637,  637,  637,  637,  637,  637,
      637,  637,  637,  637,  637,  638,  638,  638,  638,  638,
      638,  638,  638,  638,  638,  638,  638,  638,  638,  638,

      638,  638,  638,  638,  638,  638,  638,  638,  638,  639,
      639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
      639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
      639,  639,  639,  640,  640,  640,  640,  640,  640,  640,
      640,  640,  640,  640,  640,  640,  640,  640,  640,  640,
      640,  640,  640,  640,  640,  640,  640,  641,  641,  641,
      641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
      641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
      641,  642,  642,  642,  642,  642,  642,  642,  642,  642,
      642,  642,  642,  642,  642,  642,  642,  642,  642,  642,

      642,  642,  642,  642,  642,  643,  643,  643,  643,  643,
      643,  643,  643,  643,  643,  643,  643,  643,  643,  643,
      643,  643,  643,  643,  643,  643,  643,  643,  643,  644,
      644,  644,  644,  644,  644,  644,  644,  644,  644,  644,
      644,  644,  644,  644,  644,  644,  644,  644,  644,  644,
      644,  644,  644,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  646,  646,  646,
      646,  646,  646,  646,  646,  646,  646,  646,  646,  646,
      646,  646,  646,  646,  646,  646,  646,  646,  646,  646,

      646,  647,  647,  647,  647,  647,  647,  647,  647,  647,
      647,  647,  647,  647,  647,  647,  647,  647,  647,  647,
      647,  647,  647,  647,  647,  648,  648,  648,  648,  648,
      648,  648,  648,  648,  648,  648,  648,  648,  648,  648,
      648,  648,  648,  648,  648,  648,  648,  648,  648,  649,
      649,  649,  649,  649,  649,  649,  203,  649,  649,  649,
      649,  649,  649,  649,  649,  649,  649,  649,  649,  649,
      649,  649,  649,  650,  650,  650,  650,  650,  650,  650,
      650,  650,  193,  650,  650,  191,  650,  650,  650,  650,
      650,  650,  650,  650,  650,  650,  650,  651,  651,  651,

      651,  184,  651,  651,  651,  651,  651,  651,  651,  651,
      651,  651,  651,  651,  651,  651,  651,  651,  651,  651,
      651,  652,  652,  652,  652,  652,  652,  652,  183,  652,
      652,  652,  652,  652,  652,  652,  652,  652,  652,  652,
      652,  652,  652,  652,  652,  653,  653,  653,  653,  653,
      653,  653,  178,  653,  653,  653,  653,  653,  653,  653,
      653,  653,  653,  653,  653,  653,  653,  653,  653,  654,
      654,  654,  654,  654,  654,  654,  167,  654,  654,  654,
      654,  654,  654,  654,  654,  654,  654,  654,  654,  654,
      654,  164,  654,  655,  655,  655,  655,  655,  655,  655,

      655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
      655,  655,  655,  655,  655,  655,  655,  656,  656,  656,
      656,  656,  140,  656,  656,  656,  656,  656,  656,  656,
      656,  656,  656,  656,  656,  656,  656,  656,  656,  656,
      656,  657,  139,  138,  137,  136,  135,  133,  132,  127,
      125,  117,  112,  106,  105,  657,  657,  104,   90,  657,
      658,  658,   89,   85,  658,   74,   73,   70,   68,   65,
       60,   54,  658,   52,  658,   45,   28,   27,  658,  658,
       26,   25,  658,  659,  659,  659,  659,  659,  659,  659,
      659,  659,  659,  659,  659,  659,  659,  659,  659,  659,

      659,  659,  659,  659,  659,  659,  659,  660,   16,   15,
       14,   13,   12,   11,    8,  660,    7,    4,    3,    0,
        0,  660,  660,    0,    0,  660,  661,    0,    0,  661,
        0,    0,  661,  661,    0,  661,    0,    0,    0,  661,
      661,  661,  662,    0,    0,    0,    0,    0,    0,    0,
      662,    0,    0,    0,    0,    0,  662,  662,    0,    0,
      662,  663,    0,  663,    0,    0,    0,    0,    0,  663,
      663,    0,    0,  663,  664,    0,    0,  664,    0,  664,
      664,    0,    0,  664,  665,    0,    0,    0,    0,    0,
        0,    0,  665,    0,    0,    0,    0,    0,  665,  665,

        0,    0,  665,  666,  666,  666,  666,    0,  666,  666,
      666,  666,  666,  666,  666,  666,  666,  666,  666,    0,
      666,    0,  666,  666,  666,  666,  666,  667,  667,  667,
      667,    0,  667,  667,  667,  667,  667,  667,  667,  667,
      667,  667,  667,  667,  667,  667,  667,  667,  667,  667,
      667,  668,  668,  668,  668,  668,  668,  668,  668,  668,
      668,  668,  668,  668,  668,  668,  668,  668,  668,    0,
      668,  668,  668,  668,  668,  669,    0,    0,    0,    0,
        0,    0,    0,  669,    0,    0,    0,    0,    0,  669,
      669,    0,    0,  669,  670,  670,    0,    0,  670,    0,

        0,    0,    0,    0,    0,    0,  670,    0,  670,    0,
        0,    0,  670,  670,    0,    0,  670,  671,    0,    0,
      671,    0,    0,  671,  671,    0,  671,    0,    0,    0,
      671,  671,  671,  672,  672,  672,  672,  672,  672,  672,
      672,  672,  672,  672,  672,  672,  672,  672,  672,  672,
      672,  672,  672,  672,  672,  672,  672,  676,    0,    0,
        0,    0,    0,    0,    0,  676,    0,    0,    0,    0,
        0,  676,  676,    0,    0,  676,  677,    0,    0,  677,
        0,    0,  677,  677,    0,  677,    0,    0,    0,  677,
      677,  677,  678,  678,  678,  678,  678,  678,  678,  678,

      678,  678,  678,  678,  678,  678,  678,  678,  678,  678,
      678,  678,  678,  678,  678,  678,  680,    0,    0,    0,
        0,    0,  680,  680,    0,    0,  680,  681,    0,    0,
        0,    0,    0,    0,    0,  681,    0,    0,    0,    0,
        0,  681,  681,    0,    0,  681,  682,  682,    0,  682,
      682,  682,  682,  682,  682,  682,  682,  682,  682,  682,
      682,  682,  682,  682,  682,  682,  682,  682,  682,  682,
      683,    0,    0,    0,    0,    0,  683,  683,    0,    0,
      683,  684,    0,    0,  684,    0,    0,  684,  684,    0,
      684,    0,    0,    0,  684,  684,  684,  685,    0,  685,

        0,    0,    0,    0,    0,  685,  685,    0,    0,  685,
      686,    0,    0,    0,    0,    0,    0,    0,  686,    0,
        0,    0,    0,    0,  686,  686,    0,    0,  686,  687,
        0,    0,    0,    0,  687,  687,    0,  687,    0,    0,
        0,    0,    0,  687,  687,  687,    0,  687,  688,    0,
        0,    0,    0,    0,    0,    0,  688,    0,    0,    0,
        0,    0,  688,  688,    0,    0,  688,  689,  689,  689,
      689,    0,  689,  689,  689,  689,  689,  689,  689,  689,
      689,  689,  689,    0,  689,    0,  689,  689,  689,  689,
      689,  690,  690,  690,  690,  690,  690,  690,  690,  690,

      690,  690,  690,  690,  690,  690,  690,  690,  690,  690,
      690,  690,  690,  690,  690,  691,  691,  691,  691,  691,
      691,  691,  691,  691,  691,  691,  691,  691,  691,  691,
      691,  691,  691,  691,  691,  691,  691,  691,  691,  692,
        0,    0,    0,    0,    0,    0,    0,  692,    0,    0,
        0,    0,    0,  692,  692,    0,    0,  692,  693,  693,
        0,    0,  693,    0,    0,    0,    0,    0,    0,    0,
      693,    0,  693,    0,    0,    0,  693,  693,    0,    0,
      693,  694,    0,    0,  694,    0,    0,  694,  694,    0,
      694,    0,    0,    0,  694,  694,  694,  695,  695,  695,

      695,  695,  695,  695,  695,  695,  695,  695,  695,  695,
      695,  695,  695,  695,  695,  695,  695,  695,  695,  695,
      695,  696,  696,  696,  696,  696,  696,  696,  696,  696,
      696,  696,  696,  696,  696,  696,  696,  696,  696,  696,
      696,  696,  696,  696,  696,  700,    0,    0,    0,    0,
        0,    0,    0,  700,    0,    0,    0,    0,    0,  700,
      700,    0,    0,  700,  701,    0,    0,    0,    0,    0,
        0,    0,  701,    0,    0,    0,    0,    0,  701,  701,
        0,    0,  701,  702,    0,    0,  702,    0,    0,  702,
      702,    0,  702,    0,    0,    0,  702,  702,  702,  703,

        0,  703,    0,    0,    0,    0,    0,  703,  703,    0,
        0,  703,  704,    0,    0,    0,    0,    0,    0,    0,
      704,    0,    0,    0,    0,    0,  704,  704,    0,    0,
      704,  705,    0,    0,    0,    0,    0,  705,    0,  705,
        0,    0,    0,    0,    0,  705,  705,    0,    0,  705,
      706,    0,    0,    0,    0,  706,  706,    0,  706,    0,
        0,    0,    0,    0,  706,  706,  706,    0,  706,  708,
      708,    0,    0,  708,  708,    0,  708,  708,  708,  708,
      708,  708,    0,    0,    0,    0,  708,  708,  708,  708,
        0,  708,  711,  711,  711,  711,  711,  711,  711,  711,

      711,  711,  711,  711,  711,  711,  711,  711,  711,  711,
      711,  711,  711,  711,  711,  711,  712,    0,    0,    0,
        0,    0,    0,    0,  712,    0,    0,    0,    0,    0,
      712,  712,    0,    0,  712,  713,    0,    0,    0,    0,
        0,    0,    0,  713,    0,    0,    0,    0,    0,  713,
      713,    0,    0,  713,  714,    0,    0,    0,    0,    0,
      714,  714,    0,    0,  714,  715,    0,    0,    0,    0,
        0,    0,    0,  715,    0,    0,    0,    0,    0,  715,
      715,    0,    0,  715,  716,    0,    0,    0,    0,  716,
      716,    0,  716,    0,    0,    0,    0,    0,  716,  716,

      716,    0,  716,  719,  719,  719,  719,  719,  719,  719,
      719,  719,  719,  719,  719,    0,  719,  719,  719,  719,
      719,  719,  719,  719,  719,  719,  719,  720,    0,    0,
        0,    0,    0,    0,    0,  720,    0,    0,    0,    0,
        0,  720,  720,    0,    0,  720,  721,    0,    0,    0,
        0,    0,    0,    0,  721,    0,    0,    0,    0,    0,
      721,  721,    0,    0,  721,  722,    0,    0,    0,    0,
        0,    0,    0,  722,    0,    0,    0,    0,    0,  722,
      722,    0,    0,  722,  723,  723,  723,  723,  723,  723,
      723,  723,  723,  723,  723,  723,  723,  723,  723,  723,

      723,  723,  723,  723,  723,  723,  723,  723,  725,    0,
        0,    0,    0,    0,    0,    0,  725,    0,    0,    0,
        0,    0,  725,  725,    0,    0,  725,  726,    0,    0,
        0,    0,    0,    0,    0,  726,    0,    0,    0,    0,
        0,  726,  726,    0,    0,  726,  727,  727,    0,    0,
      727,  727,    0,  727,  727,  727,  727,  727,  727,    0,
        0,    0,    0,  727,  727,  727,  727,    0,  727,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,

      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[145] =
    {   0,
1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
    1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
    0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 
    1, 1, 1, 1, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"

#line 33 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"

/* LCOV_EXCL_START */

extern YYSTYPE base_yylval;

static int		xcdepth = 0;	/* depth of nesting in slash-star comments */
static char	   *dolqstart = NULL;	/* current $foo$ quote start string */

/*
 * literalbuf is used to accumulate literal values when multiple rules
 * are needed to parse a single literal.  Call startlit to reset buffer
 * to empty, addlit to add text.  Note that the buffer is permanently
 * malloc'd to the largest size needed so far in the current run.
 */
static char	   *literalbuf = NULL;		/* expandable buffer */
static int		literallen;				/* actual current length */
static int		literalalloc;			/* current allocated buffer size */

/* Used for detecting global state together with braces_open */
static int		parenths_open;

/* Used to tell parse_include() whether the command was #include or #include_next */
static bool		include_next;

#define startlit()	(literalbuf[0] = '\0', literallen = 0)
static void addlit(char *ytext, int yleng);
static void addlitchar(unsigned char ychar);
static int	process_integer_literal(const char *token, YYSTYPE *lval, int base);
static void parse_include(void);
static bool ecpg_isspace(char ch);
static bool isdefine(void);
static bool isinformixdefine(void);

char *token_start;

/* vars to keep track of start conditions when scanning literals */
static int state_before_str_start;
static int state_before_str_stop;

/*
 * State for handling include files and macro expansion.  We use a new
 * flex input buffer for each level of include or macro, and create a
 * struct _yy_buffer to remember the previous level.  There is not a struct
 * for the currently active input source; that state is kept in the global
 * variables YY_CURRENT_BUFFER, yylineno, and input_filename.
 */
static struct _yy_buffer
{
	YY_BUFFER_STATE		buffer;
	long				lineno;
	char			   *filename;
	struct _yy_buffer  *next;
} *yy_buffer = NULL;

/*
 * Vars for handling ifdef/elif/endif constructs.  preproc_tos is the current
 * nesting depth of such constructs, and stacked_if_value[preproc_tos] is the
 * state for the innermost level.  (For convenience, stacked_if_value[0] is
 * initialized as though we are in the active branch of some outermost IF.)
 * The active field is true if the current branch is active (being expanded).
 * The saw_active field is true if we have found any successful branch,
 * so that all subsequent branches of this level should be skipped.
 * The else_branch field is true if we've found an 'else' (so that another
 * 'else' or 'elif' at this level is an error.)
 * For IFs nested within an inactive branch, all branches always have active
 * set to false, but saw_active and else_branch are maintained normally.
 * ifcond is valid only while evaluating an if-condition; it's true if we
 * are doing ifdef, false if ifndef.
 */
#define MAX_NESTED_IF 128
static short preproc_tos;
static bool ifcond;
static struct _if_value
{
	bool		active;
	bool		saw_active;
	bool		else_branch;
} stacked_if_value[MAX_NESTED_IF];

#line 1871 "pgc.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xdc> double-quoted strings in C
 *  <xh> hexadecimal byte string
 *  <xn> national character quoted strings
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xqc> single-quoted strings in C
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xcond> condition of an EXEC SQL IFDEF construct
 *  <xskip> skipping the inactive part of an EXEC SQL IFDEF construct
 *
 * Note: we intentionally don't mimic the backend's <xeu> state; we have
 * no need to distinguish it from <xe> state.
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/* Additional exclusive states that are specific to ECPG */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  SQL-style comments, which start with -- and extend to the
 * next newline, are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * non_newline_space tracks all space characters except newlines.
 *
 * XXX if you change the set of whitespace characters, fix ecpg_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* special stuff for C strings */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {numericfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/* Positional parameters don't accept underscores. */
/*
 * An identifier immediately following an integer literal is disallowed because
 * in some cases it's ambiguous what is meant: for example, 0x1234 could be
 * either a hexinteger or a decinteger "0" and an identifier "x1234".  We can
 * detect such problems by seeing if integer_junk matches a longer substring
 * than any of the XXXinteger patterns (decinteger, hexinteger, octinteger,
 * bininteger).  One "junk" pattern is sufficient because
 * {decinteger}{identifier} will match all the same strings we'd match with
 * {hexinteger}{identifier} etc.
 *
 * Note that the rule for integer_junk must appear after the ones for
 * XXXinteger to make this work correctly: 0x1234 will match both hexinteger
 * and integer_junk, and we need hexinteger to be chosen in that case.
 *
 * Also disallow strings matched by numeric_junk, real_junk and param_junk
 * for consistency.
 */
/* special characters for other dbms */
/* we have to react differently in compat mode */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
/* some stuff needed for ecpg */
/* we might want to parse all cpp include files */
/* take care of cpp lines, they may also be continued */
/* first a general line for all commands not starting with "i" */
/* and then the other commands starting with "i", we have to add these
 * separately because the cppline production would match on "include" too
 */
#line 2050 "pgc.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xdc 4
#define xh 5
#define xn 6
#define xq 7
#define xqs 8
#define xe 9
#define xqc 10
#define xdolq 11
#define xui 12
#define xus 13
#define xcond 14
#define xskip 15
#define C 16
#define SQL 17
#define incl 18
#define def 19
#define def_ident 20
#define undef 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 463 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"



#line 467 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
		/* code to execute during start of each call of yylex() */
		char *newdefsymbol = NULL;

		token_start = NULL;


#line 2299 "pgc.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 636 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 635 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 474 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* ignore */
				}
	YY_BREAK
/* <SQL> */

case 2:
YY_RULE_SETUP
#line 480 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/*", yyout);
				}
	YY_BREAK
/* <C,SQL> */

case 3:
YY_RULE_SETUP
#line 492 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					if (state_before_str_start == SQL)
					{
						xcdepth++;
						/* Put back any characters past slash-star; see above */
						yyless(2);
						fputs("/_*", yyout);
					}
					else if (state_before_str_start == C)
					{
						ECHO;
					}
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 506 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					if (state_before_str_start == SQL)
					{
						if (xcdepth <= 0)
						{
							ECHO;
							BEGIN(SQL);
							token_start = NULL;
						}
						else
						{
							xcdepth--;
							fputs("*_/", yyout);
						}
					}
					else if (state_before_str_start == C)
					{
						ECHO;
						BEGIN(C);
						token_start = NULL;
					}
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 529 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 533 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 537 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					ECHO;
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 541 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					mmfatal(PARSE_ERROR, "unterminated /* comment");
				}
	YY_BREAK
/* <xc> */

case 8:
YY_RULE_SETUP
#line 547 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xb);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 9:
/* rule 9 can match eol */
#line 556 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 556 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 559 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated bit string literal"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 561 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xh);
					startlit();
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 567 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated hexadecimal string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 569 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xqc);
					startlit();
				}
	YY_BREAK

case 13:
YY_RULE_SETUP
#line 577 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* National character.
					 * Transfer it as-is to the backend.
					 */
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xn);
					startlit();
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 587 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xq);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 593 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 599 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 17:
YY_RULE_SETUP
#line 607 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 619 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(state_before_str_stop);
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 628 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
case 20:
/* rule 20 can match eol */
#line 629 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 629 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(state_before_str_start);

					switch (state_before_str_stop)
					{
						case xb:
							if (literalbuf[strspn(literalbuf, "01")] != '\0')
								mmerror(PARSE_ERROR, ET_ERROR, "invalid bit string literal");
							base_yylval.str = psprintf("b'%s'", literalbuf);
							return BCONST;
						case xh:
							if (literalbuf[strspn(literalbuf, "0123456789abcdefABCDEF")] != '\0')
								mmerror(PARSE_ERROR, ET_ERROR, "invalid hexadecimal string literal");
							base_yylval.str = psprintf("x'%s'", literalbuf);
							return XCONST;
						case xq:
							/* fallthrough */
						case xqc:
							base_yylval.str = psprintf("'%s'", literalbuf);
							return SCONST;
						case xe:
							base_yylval.str = psprintf("E'%s'", literalbuf);
							return SCONST;
						case xn:
							base_yylval.str = psprintf("N'%s'", literalbuf);
							return SCONST;
						case xus:
							base_yylval.str = psprintf("U&'%s'", literalbuf);
							return USCONST;
						default:
							mmfatal(PARSE_ERROR, "unhandled previous state in xqs\n");
					}
				}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 669 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 670 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 671 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 672 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 675 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 678 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 681 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 684 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 687 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xqc):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xn):
case YY_STATE_EOF(xus):
#line 691 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 30:
YY_RULE_SETUP
#line 694 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					token_start = yytext;
					if (dolqstart)
						free(dolqstart);
					dolqstart = mm_strdup(yytext);
					BEGIN(xdolq);
					startlit();
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 703 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
case 32:
YY_RULE_SETUP
#line 711 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					if (strcmp(yytext, dolqstart) == 0)
					{
						addlit(yytext, yyleng);
						free(dolqstart);
						dolqstart = NULL;
						BEGIN(SQL);
						base_yylval.str = mm_strdup(literalbuf);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 33:
/* rule 33 can match eol */
YY_RULE_SETUP
#line 732 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 735 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 738 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* single quote or dollar sign */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 742 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated dollar-quoted string"); }
	YY_BREAK

case 36:
YY_RULE_SETUP
#line 745 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 750 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 38:
YY_RULE_SETUP
#line 757 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 0)
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/*
					 * The server will truncate the identifier here.  We do
					 * not, as (1) it does not change the result; (2) we don't
					 * know what NAMEDATALEN the server might use; (3) this
					 * code path is also taken for literal query strings in
					 * PREPARE and EXECUTE IMMEDIATE, which can certainly be
					 * longer than NAMEDATALEN.
					 */
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 772 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					BEGIN(state_before_str_start);
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 777 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 0)
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/* The backend will truncate the identifier here. We do not as it does not change the result. */
					base_yylval.str = psprintf("U&\"%s\"", literalbuf);
					return UIDENT;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 785 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 788 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 791 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted identifier"); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 792 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xdc);
					startlit();
				}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 797 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xdc):
#line 800 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 45:
YY_RULE_SETUP
#line 803 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return TYPECAST;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 807 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return DOT_DOT;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 811 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return COLON_EQUALS;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 815 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return EQUALS_GREATER;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 819 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return LESS_EQUALS;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 823 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return GREATER_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 827 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 832 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 837 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
			  /* are we simulating Informix? */
				if (INFORMIX_MODE)
				{
					unput(':');
				}
				else
					return yytext[0];
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 847 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/*
					 * We may find a ';' inside a structure
					 * definition in a TYPE or VAR statement.
					 * This is not an EOL marker.
					 */
					if (yytext[0] == ';' && struct_level == 0)
						BEGIN(C);
					return yytext[0];
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 858 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					base_yylval.str = mm_strdup(yytext);
					return Op;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 955 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					base_yylval.ival = atol(yytext+1);
					return PARAM;
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 959 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after parameter");
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 963 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return IP;
				}
	YY_BREAK
/* <SQL> */

case 59:
YY_RULE_SETUP
#line 970 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return process_integer_literal(yytext, &base_yylval, 10);
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 973 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return process_integer_literal(yytext, &base_yylval, 16);
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 976 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 980 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval, 10);
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 985 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 989 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/*
					 * throw back the [Ee][+-], and figure out whether what
					 * remains is an {decinteger} or {numeric}.
					 */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval, 10);
				}
	YY_BREAK
/* <C,SQL> */

case 65:
YY_RULE_SETUP
#line 1000 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return process_integer_literal(yytext, &base_yylval, 8);
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1003 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return process_integer_literal(yytext, &base_yylval, 2);
				}
	YY_BREAK
/*
	 * Note that some trailing junk is valid in C (such as 100LL), so we
	 * contain this to SQL mode.
	 */
case 67:
YY_RULE_SETUP
#line 1011 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 1014 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1017 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 70:
/* rule 70 can match eol */
YY_RULE_SETUP
#line 1021 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					base_yylval.str = mm_strdup(yytext+1);
					return CVARIABLE;
				}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1026 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* First check to see if it's a define symbol to expand */
					if (!isdefine())
					{
						int		kwvalue;

						/*
						 * User-defined typedefs override SQL keywords, but
						 * not C keywords.  Currently, a typedef name is just
						 * reported as IDENT, but someday we might need to
						 * return a distinct token type.
						 */
						if (get_typedef(yytext, true) == NULL)
						{
							/* Is it an SQL/ECPG keyword? */
							kwvalue = ScanECPGKeywordLookup(yytext);
							if (kwvalue >= 0)
								return kwvalue;
						}

						/* Is it a C keyword? */
						kwvalue = ScanCKeywordLookup(yytext);
						if (kwvalue >= 0)
							return kwvalue;

						/*
						 * None of the above.  Return it as an identifier.
						 *
						 * The backend will attempt to truncate and case-fold
						 * the identifier, but I see no good reason for ecpg
						 * to do so; that's just another way that ecpg could get
						 * out of step with the backend.
						 */
						base_yylval.str = mm_strdup(yytext);
						return IDENT;
					}
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1064 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
/*
	 * Begin ECPG-specific rules
	 */
case 73:
/* rule 73 can match eol */
YY_RULE_SETUP
#line 1073 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ BEGIN(SQL); return SQL_START; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 1074 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(SQL);
							return SQL_START;
						}
						else
							return S_ANYTHING;
					 }
	YY_BREAK
case 75:
/* rule 75 can match eol */
YY_RULE_SETUP
#line 1084 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ ECHO; }
	YY_BREAK
case 76:
/* rule 76 can match eol */
YY_RULE_SETUP
#line 1085 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						if (system_includes)
						{
							include_next = false;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 77:
/* rule 77 can match eol */
YY_RULE_SETUP
#line 1097 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						if (system_includes)
						{
							include_next = true;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 78:
/* rule 78 can match eol */
YY_RULE_SETUP
#line 1109 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						base_yylval.str = mm_strdup(yytext);
						return CPP_LINE;
					}
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 1113 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						/*
						 * Try to detect a function name:
						 * look for identifiers at the global scope
						 * keep the last identifier before the first '(' and '{'
						 */
						if (braces_open == 0 && parenths_open == 0)
						{
							if (current_function)
								free(current_function);
							current_function = mm_strdup(yytext);
						}
						/* Informix uses SQL defines only in SQL space */
						/* however, some defines have to be taken care of for compatibility */
						if ((!INFORMIX_MODE || !isinformixdefine()) && !isdefine())
						{
							int		kwvalue;

							kwvalue = ScanCKeywordLookup(yytext);
							if (kwvalue >= 0)
								return kwvalue;
							else
							{
								base_yylval.str = mm_strdup(yytext);
								return IDENT;
							}
						}
					}
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 1141 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ mmerror(PARSE_ERROR, ET_ERROR, "nested /* ... */ comments"); }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 1142 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return ':'; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 1143 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return ';'; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 1144 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return ','; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 1145 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return '*'; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 1146 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return '%'; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 1147 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return '/'; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 1148 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return '+'; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1149 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return '-'; }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 1150 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ parenths_open++; return '('; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 1151 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ parenths_open--; return ')'; }
	YY_BREAK
case 91:
/* rule 91 can match eol */
YY_RULE_SETUP
#line 1152 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ ECHO; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 1153 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return '{'; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1154 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return '}'; }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 1155 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return '['; }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 1156 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return ']'; }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 1157 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return '='; }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1158 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_MEMBER; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 1159 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_RSHIFT; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 1160 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_LSHIFT; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 1161 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_OR; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 1162 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_AND; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 1163 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_INC; }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 1164 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_DEC; }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1165 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_EQUAL; }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 1166 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_NEQUAL; }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 1167 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_ADD; }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 1168 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_SUB; }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 1169 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_MUL; }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 1170 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_DIV; }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 1171 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_MOD; }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 1172 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_MEMPOINT; }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 1173 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_DOTPOINT; }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 1174 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ return S_ANYTHING; }
	YY_BREAK
case 114:
/* rule 114 can match eol */
YY_RULE_SETUP
#line 1175 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ BEGIN(def_ident); }
	YY_BREAK
case 115:
/* rule 115 can match eol */
YY_RULE_SETUP
#line 1176 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(def_ident);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 1188 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ BEGIN(undef); }
	YY_BREAK
case 117:
/* rule 117 can match eol */
YY_RULE_SETUP
#line 1189 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(undef);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 118:
/* rule 118 can match eol */
YY_RULE_SETUP
#line 1201 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					struct _defines *ptr, *ptr2 = NULL;
					int i;

					/*
					 *	Skip the ";" and trailing whitespace. Note that yytext
					 *	contains at least one non-space character plus the ";"
					 */
					for (i = strlen(yytext)-2;
						 i > 0 && ecpg_isspace(yytext[i]);
						 i--)
						;
					yytext[i+1] = '\0';


					/* Find and unset any matching define; should be only 1 */
					for (ptr = defines; ptr; ptr2 = ptr, ptr = ptr->next)
					{
						if (strcmp(yytext, ptr->name) == 0)
						{
							free(ptr->value);
							ptr->value = NULL;
							/* We cannot forget it if there's a cmdvalue */
							if (ptr->cmdvalue == NULL)
							{
								if (ptr2 == NULL)
									defines = ptr->next;
								else
									ptr2->next = ptr->next;
								free(ptr->name);
								free(ptr);
							}
							break;
						}
					}

					BEGIN(C);
				}
	YY_BREAK
case 119:
/* rule 119 can match eol */
YY_RULE_SETUP
#line 1239 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL UNDEF command");
						yyterminate();
				}
	YY_BREAK
case 120:
/* rule 120 can match eol */
YY_RULE_SETUP
#line 1243 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ BEGIN(incl); }
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 1244 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  BEGIN(incl);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 122:
/* rule 122 can match eol */
YY_RULE_SETUP
#line 1256 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					  if (preproc_tos >= MAX_NESTED_IF-1)
						  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					  preproc_tos++;
					  stacked_if_value[preproc_tos].active = false;
					  stacked_if_value[preproc_tos].saw_active = false;
					  stacked_if_value[preproc_tos].else_branch = false;
					  ifcond = true;
					  BEGIN(xcond);
					}
	YY_BREAK
case 123:
/* rule 123 can match eol */
YY_RULE_SETUP
#line 1266 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  if (preproc_tos >= MAX_NESTED_IF-1)
							  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
						  preproc_tos++;
						  stacked_if_value[preproc_tos].active = false;
						  stacked_if_value[preproc_tos].saw_active = false;
						  stacked_if_value[preproc_tos].else_branch = false;
						  ifcond = true;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 124:
/* rule 124 can match eol */
YY_RULE_SETUP
#line 1285 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					  if (preproc_tos >= MAX_NESTED_IF-1)
						  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					  preproc_tos++;
					  stacked_if_value[preproc_tos].active = false;
					  stacked_if_value[preproc_tos].saw_active = false;
					  stacked_if_value[preproc_tos].else_branch = false;
					  ifcond = false;
					  BEGIN(xcond);
					}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 1295 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  if (preproc_tos >= MAX_NESTED_IF-1)
							  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
						  preproc_tos++;
						  stacked_if_value[preproc_tos].active = false;
						  stacked_if_value[preproc_tos].saw_active = false;
						  stacked_if_value[preproc_tos].else_branch = false;
						  ifcond = false;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 126:
/* rule 126 can match eol */
YY_RULE_SETUP
#line 1314 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						ifcond = true;
						BEGIN(xcond);
					}
	YY_BREAK
case 127:
/* rule 127 can match eol */
YY_RULE_SETUP
#line 1322 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						ifcond = true;
						BEGIN(xcond);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 128:
/* rule 128 can match eol */
YY_RULE_SETUP
#line 1340 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{	/* only exec sql endif pops the stack, so take care of duplicated 'else' */
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
					else if (stacked_if_value[preproc_tos].else_branch)
						mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
					else
					{
						stacked_if_value[preproc_tos].else_branch = true;
						stacked_if_value[preproc_tos].active =
							(stacked_if_value[preproc_tos-1].active &&
							 !stacked_if_value[preproc_tos].saw_active);
						stacked_if_value[preproc_tos].saw_active = true;

						if (stacked_if_value[preproc_tos].active)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
				}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 1359 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						else if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
						else
						{
							stacked_if_value[preproc_tos].else_branch = true;
							stacked_if_value[preproc_tos].active =
								(stacked_if_value[preproc_tos-1].active &&
								 !stacked_if_value[preproc_tos].saw_active);
							stacked_if_value[preproc_tos].saw_active = true;

							if (stacked_if_value[preproc_tos].active)
								BEGIN(C);
							else
								BEGIN(xskip);
						}
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 130:
/* rule 130 can match eol */
YY_RULE_SETUP
#line 1387 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
					else
						preproc_tos--;

					if (stacked_if_value[preproc_tos].active)
					   BEGIN(C);
					else
					   BEGIN(xskip);
				}
	YY_BREAK
case 131:
/* rule 131 can match eol */
YY_RULE_SETUP
#line 1398 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
						else
							preproc_tos--;

						if (stacked_if_value[preproc_tos].active)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 132:
YY_RULE_SETUP
#line 1419 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ /* ignore */ }
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 1421 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					{
						struct _defines *defptr;
						unsigned int i;
						bool this_active;

						/*
						 *	Skip the ";" and trailing whitespace. Note that yytext
						 *	contains at least one non-space character plus the ";"
						 */
						for (i = strlen(yytext)-2;
							 i > 0 && ecpg_isspace(yytext[i]);
							 i--)
							;
						yytext[i+1] = '\0';

						/* Does a definition exist? */
						for (defptr = defines; defptr; defptr = defptr->next)
						{
							if (strcmp(yytext, defptr->name) == 0)
							{
								/* Found it, but is it currently undefined? */
								if (defptr->value == NULL)
									defptr = NULL; /* pretend it's not found */
								break;
							}
						}

						this_active = (defptr ? ifcond : !ifcond);
						stacked_if_value[preproc_tos].active =
							(stacked_if_value[preproc_tos-1].active &&
							 !stacked_if_value[preproc_tos].saw_active &&
							 this_active);
						stacked_if_value[preproc_tos].saw_active |= this_active;
					}

					if (stacked_if_value[preproc_tos].active)
						BEGIN(C);
					else
						BEGIN(xskip);
				}
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 1463 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL IFDEF command");
				yyterminate();
			}
	YY_BREAK
case 135:
YY_RULE_SETUP
#line 1467 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
				newdefsymbol = mm_strdup(yytext);
				BEGIN(def);
				startlit();
			}
	YY_BREAK
case 136:
/* rule 136 can match eol */
YY_RULE_SETUP
#line 1472 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL DEFINE command");
				yyterminate();
			}
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 1476 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
						struct _defines *ptr;

						/* Does it already exist? */
						for (ptr = defines; ptr != NULL; ptr = ptr->next)
						{
							if (strcmp(newdefsymbol, ptr->name) == 0)
							{
								free(ptr->value);
								ptr->value = mm_strdup(literalbuf);
								/* Don't leak newdefsymbol */
								free(newdefsymbol);
								break;
							}
						}
						if (ptr == NULL)
						{
							/* Not present, make a new entry */
							ptr = (struct _defines *) mm_alloc(sizeof(struct _defines));

							ptr->name = newdefsymbol;
							ptr->value = mm_strdup(literalbuf);
							ptr->cmdvalue = NULL;
							ptr->used = NULL;
							ptr->next = defines;
							defines = ptr;
						}

						BEGIN(C);
					}
	YY_BREAK
case 138:
/* rule 138 can match eol */
YY_RULE_SETUP
#line 1506 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 139:
/* rule 139 can match eol */
YY_RULE_SETUP
#line 1507 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{	parse_include(); }
	YY_BREAK
case 140:
/* rule 140 can match eol */
YY_RULE_SETUP
#line 1508 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{	parse_include(); }
	YY_BREAK
case 141:
/* rule 141 can match eol */
YY_RULE_SETUP
#line 1509 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ parse_include(); }
	YY_BREAK
case 142:
/* rule 142 can match eol */
YY_RULE_SETUP
#line 1510 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					mmfatal(PARSE_ERROR, "syntax error in EXEC SQL INCLUDE command");
					yyterminate();
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(xcond):
case YY_STATE_EOF(xskip):
case YY_STATE_EOF(C):
case YY_STATE_EOF(SQL):
case YY_STATE_EOF(incl):
case YY_STATE_EOF(def):
case YY_STATE_EOF(def_ident):
case YY_STATE_EOF(undef):
#line 1515 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{
					if (yy_buffer == NULL)
					{
						/* No more input */
						if (preproc_tos > 0)
						{
							preproc_tos = 0;
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						}
						yyterminate();
					}
					else
					{
						/* Revert to previous input source */
						struct _yy_buffer *yb = yy_buffer;
						int i;
						struct _defines *ptr;

						/* Check to see if we are exiting a macro value */
						for (ptr = defines; ptr; ptr = ptr->next)
						{
							if (ptr->used == yy_buffer)
							{
								ptr->used = NULL;
								break; /* there can't be multiple matches */
							}
						}

						if (yyin != NULL)
							fclose(yyin);

						yy_delete_buffer(YY_CURRENT_BUFFER);
						yy_switch_to_buffer(yy_buffer->buffer);

						yylineno = yy_buffer->lineno;

						/* We have to output the filename only if we change files here */
						i = strcmp(input_filename, yy_buffer->filename);

						free(input_filename);
						input_filename = yy_buffer->filename;

						yy_buffer = yy_buffer->next;
						free(yb);

						if (i != 0)
							output_line_number();

					}
				}
	YY_BREAK
case 143:
/* rule 143 can match eol */
YY_RULE_SETUP
#line 1566 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
{ mmfatal(PARSE_ERROR, "internal error: unreachable state; please report this to <%s>", PACKAGE_BUGREPORT); }
	YY_BREAK
case 144:
YY_RULE_SETUP
#line 1568 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 4066 "pgc.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 636 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 636 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 635);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1568 "/build/postgresql-old-upgrade/src/build/../postgresql-17.7/src/interfaces/ecpg/preproc/pgc.l"


/* LCOV_EXCL_STOP */

void
lex_init(void)
{
	braces_open = 0;
	parenths_open = 0;
	current_function = NULL;

	yylineno = 1;

	/* initialize state for if/else/endif */
	preproc_tos = 0;
	stacked_if_value[preproc_tos].active = true;
	stacked_if_value[preproc_tos].saw_active = true;
	stacked_if_value[preproc_tos].else_branch = false;

	/* initialize literal buffer to a reasonable but expansible size */
	if (literalbuf == NULL)
	{
		literalalloc = 1024;
		literalbuf = (char *) mm_alloc(literalalloc);
	}
	startlit();

	BEGIN(C);
}

static void
addlit(char *ytext, int yleng)
{
	/* enlarge buffer if needed */
	if ((literallen+yleng) >= literalalloc)
	{
		do
			literalalloc *= 2;
		while ((literallen+yleng) >= literalalloc);
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	memcpy(literalbuf+literallen, ytext, yleng);
	literallen += yleng;
	literalbuf[literallen] = '\0';
}

static void
addlitchar(unsigned char ychar)
{
	/* enlarge buffer if needed */
	if ((literallen+1) >= literalalloc)
	{
		literalalloc *= 2;
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	literalbuf[literallen] = ychar;
	literallen += 1;
	literalbuf[literallen] = '\0';
}

/*
 * Process {decinteger}, {hexinteger}, etc.  Note this will also do the right
 * thing with {numeric}, ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval, int base)
{
	int			val;
	char	   *endptr;

	errno = 0;
	val = strtoint(base == 10 ? token : token + 2, &endptr, base);
	if (*endptr != '\0' || errno == ERANGE)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = mm_strdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
parse_include(void)
{
	/* got the include file name */
	struct _yy_buffer *yb;
	struct _include_path *ip;
	char inc_file[MAXPGPATH];
	unsigned int i;

	yb = mm_alloc(sizeof(struct _yy_buffer));

	yb->buffer =	YY_CURRENT_BUFFER;
	yb->lineno = yylineno;
	yb->filename = input_filename;
	yb->next = yy_buffer;

	yy_buffer = yb;

	/*
	 * skip the ";" if there is one and trailing whitespace. Note that
	 * yytext contains at least one non-space character plus the ";"
	 */
	for (i = strlen(yytext)-2;
		 i > 0 && ecpg_isspace(yytext[i]);
		 i--)
		;

	if (yytext[i] == ';')
		i--;

	yytext[i+1] = '\0';

	yyin = NULL;

	/* If file name is enclosed in '"' remove these and look only in '.' */
	/* Informix does look into all include paths though, except filename starts with '/' */
	if (yytext[0] == '"' && yytext[i] == '"' &&
		((compat != ECPG_COMPAT_INFORMIX && compat != ECPG_COMPAT_INFORMIX_SE) || yytext[1] == '/'))
	{
		yytext[i] = '\0';
		memmove(yytext, yytext+1, strlen(yytext));

		strlcpy(inc_file, yytext, sizeof(inc_file));
		yyin = fopen(inc_file, "r");
		if (!yyin)
		{
			if (strlen(inc_file) <= 2 || strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
			{
				strcat(inc_file, ".h");
				yyin = fopen(inc_file, "r");
			}
		}

	}
	else
	{
		if ((yytext[0] == '"' && yytext[i] == '"') || (yytext[0] == '<' && yytext[i] == '>'))
		{
			yytext[i] = '\0';
			memmove(yytext, yytext+1, strlen(yytext));
		}

		for (ip = include_paths; yyin == NULL && ip != NULL; ip = ip->next)
		{
			if (strlen(ip->path) + strlen(yytext) + 4 > MAXPGPATH)
			{
				fprintf(stderr, _("Error: include path \"%s/%s\" is too long on line %d, skipping\n"), ip->path, yytext, yylineno);
				continue;
			}
			snprintf (inc_file, sizeof(inc_file), "%s/%s", ip->path, yytext);
			yyin = fopen(inc_file, "r");
			if (!yyin)
			{
				if (strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
				{
					strcat(inc_file, ".h");
					yyin = fopen(inc_file, "r");
				}
			}
			/* if the command was "include_next" we have to disregard the first hit */
			if (yyin && include_next)
			{
				fclose (yyin);
				yyin = NULL;
				include_next = false;
			}
		}
	}
	if (!yyin)
		mmfatal(NO_INCLUDE_FILE, "could not open include file \"%s\" on line %d", yytext, yylineno);

	input_filename = mm_strdup(inc_file);
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));
	yylineno = 1;
	output_line_number();

	BEGIN(C);
}

/*
 * ecpg_isspace() --- return true if flex scanner considers char whitespace
 */
static bool
ecpg_isspace(char ch)
{
	if (ch == ' ' ||
		ch == '\t' ||
		ch == '\n' ||
		ch == '\r' ||
		ch == '\f' ||
		ch == '\v')
		return true;
	return false;
}

/*
 * If yytext matches a define symbol, begin scanning the symbol's value
 * and return true
 */
static bool
isdefine(void)
{
	struct _defines *ptr;

	/* is it a define? */
	for (ptr = defines; ptr; ptr = ptr->next)
	{
		/* notice we do not match anything being actively expanded */
		if (strcmp(yytext, ptr->name) == 0 &&
			ptr->value != NULL &&
			ptr->used == NULL)
		{
			/* Save state associated with the current buffer */
			struct _yy_buffer *yb;

			yb = mm_alloc(sizeof(struct _yy_buffer));

			yb->buffer =  YY_CURRENT_BUFFER;
			yb->lineno = yylineno;
			yb->filename = mm_strdup(input_filename);
			yb->next = yy_buffer;
			yy_buffer = yb;

			/* Mark symbol as being actively expanded */
			ptr->used = yb;

			/*
			 * We use yy_scan_string which will copy the value, so there's
			 * no need to worry about a possible undef happening while we
			 * are still scanning it.
			 */
			yy_scan_string(ptr->value);
			return true;
		}
	}

	return false;
}

/*
 * Handle replacement of INFORMIX built-in defines.  This works just
 * like isdefine() except for the source of the string to scan.
 */
static bool
isinformixdefine(void)
{
	const char *new = NULL;

	if (strcmp(yytext, "dec_t") == 0)
		new = "decimal";
	else if (strcmp(yytext, "intrvl_t") == 0)
		new = "interval";
	else if (strcmp(yytext, "dtime_t") == 0)
		new = "timestamp";

	if (new)
	{
		struct _yy_buffer *yb;

		yb = mm_alloc(sizeof(struct _yy_buffer));

		yb->buffer =  YY_CURRENT_BUFFER;
		yb->lineno = yylineno;
		yb->filename = mm_strdup(input_filename);
		yb->next = yy_buffer;
		yy_buffer = yb;

		yy_scan_string(new);
		return true;
	}

	return false;
}

