// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkStreamLinesCopy_fs.h"

const char *vtkStreamLinesCopy_fs =
"//VTK::System::Dec\n"
"//VTK::Output::Dec\n"
"//VTK::DepthPeeling::Dec\n"
"varying vec2 tcoordVC;\n"
"\n"
"uniform sampler2D source;\n"
"uniform sampler2D depthSource;\n"
"\n"
"void main(void)\n"
"{\n"
"  gl_FragDepth = texture2D(depthSource, tcoordVC).x;\n"
"  //VTK::DepthPeeling::PreColor\n"
"  gl_FragData[0] = texture2D(source, tcoordVC);\n"
"  if (gl_FragData[0].a <= 0.0)\n"
"    {\n"
"    discard;\n"
"    }\n"
"  //VTK::DepthPeeling::Impl\n"
"}\n"
"";
