// python wrapper for vtkParallelSerialWriter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkParallelSerialWriter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkParallelSerialWriter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkParallelSerialWriter_ClassNew(); }


static PyObject *
PyvtkParallelSerialWriter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkParallelSerialWriter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkParallelSerialWriter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkParallelSerialWriter *tempr = vtkParallelSerialWriter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkParallelSerialWriter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkParallelSerialWriter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkParallelSerialWriter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkParallelSerialWriter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetWriter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetWriter(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetWriter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetWriter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetWriter() :
      op->vtkParallelSerialWriter::GetWriter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkParallelSerialWriter::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetFileNameMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileNameMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileNameMethod(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetFileNameMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetFileNameMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileNameMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileNameMethod() :
      op->vtkParallelSerialWriter::GetFileNameMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkParallelSerialWriter::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_Write(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Write");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Write() :
      op->vtkParallelSerialWriter::Write());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetPiece(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPiece");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPiece() :
      op->vtkParallelSerialWriter::GetPiece());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetPiece(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPiece");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPiece(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetPiece(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetNumberOfPieces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPieces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfPieces() :
      op->vtkParallelSerialWriter::GetNumberOfPieces());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetNumberOfPieces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfPieces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfPieces(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetNumberOfPieces(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetGhostLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGhostLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGhostLevel() :
      op->vtkParallelSerialWriter::GetGhostLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetGhostLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGhostLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGhostLevel(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetGhostLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetPreGatherHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPreGatherHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetPreGatherHelper(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetPreGatherHelper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetPreGatherHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPreGatherHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetPreGatherHelper() :
      op->vtkParallelSerialWriter::GetPreGatherHelper());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetPostGatherHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPostGatherHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetPostGatherHelper(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetPostGatherHelper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetPostGatherHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPostGatherHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetPostGatherHelper() :
      op->vtkParallelSerialWriter::GetPostGatherHelper());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetWriteAllTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteAllTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetWriteAllTimeSteps() :
      op->vtkParallelSerialWriter::GetWriteAllTimeSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetWriteAllTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteAllTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteAllTimeSteps(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetWriteAllTimeSteps(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_WriteAllTimeStepsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteAllTimeStepsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteAllTimeStepsOn();
    }
    else
    {
      op->vtkParallelSerialWriter::WriteAllTimeStepsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_WriteAllTimeStepsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteAllTimeStepsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteAllTimeStepsOff();
    }
    else
    {
      op->vtkParallelSerialWriter::WriteAllTimeStepsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetInterpreter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpreter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  vtkClientServerInterpreter *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkClientServerInterpreter"))
  {
    if (ap.IsBound())
    {
      op->SetInterpreter(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetInterpreter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetFileNameSuffix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileNameSuffix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileNameSuffix() :
      op->vtkParallelSerialWriter::GetFileNameSuffix());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetFileNameSuffix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileNameSuffix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileNameSuffix(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetFileNameSuffix(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetNumberOfIORanks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfIORanks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfIORanks(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetNumberOfIORanks(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetNumberOfIORanksMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfIORanksMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfIORanksMinValue() :
      op->vtkParallelSerialWriter::GetNumberOfIORanksMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetNumberOfIORanksMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfIORanksMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfIORanksMaxValue() :
      op->vtkParallelSerialWriter::GetNumberOfIORanksMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetNumberOfIORanks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfIORanks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfIORanks() :
      op->vtkParallelSerialWriter::GetNumberOfIORanks());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetRankAssignmentMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRankAssignmentMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRankAssignmentMode(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetRankAssignmentMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetRankAssignmentModeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRankAssignmentModeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRankAssignmentModeMinValue() :
      op->vtkParallelSerialWriter::GetRankAssignmentModeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetRankAssignmentModeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRankAssignmentModeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRankAssignmentModeMaxValue() :
      op->vtkParallelSerialWriter::GetRankAssignmentModeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetRankAssignmentMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRankAssignmentMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRankAssignmentMode() :
      op->vtkParallelSerialWriter::GetRankAssignmentMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkParallelSerialWriter::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelSerialWriter_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelSerialWriter *op = static_cast<vtkParallelSerialWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkParallelSerialWriter::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkParallelSerialWriter_Methods[] = {
  {"IsTypeOf", PyvtkParallelSerialWriter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkParallelSerialWriter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkParallelSerialWriter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkParallelSerialWriter\nC++: static vtkParallelSerialWriter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkParallelSerialWriter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkParallelSerialWriter\nC++: vtkParallelSerialWriter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkParallelSerialWriter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkParallelSerialWriter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetWriter", PyvtkParallelSerialWriter_SetWriter, METH_VARARGS,
   "SetWriter(self, __a:vtkAlgorithm) -> None\nC++: void SetWriter(vtkAlgorithm *)\n\nSet/get the internal writer.\n"},
  {"GetWriter", PyvtkParallelSerialWriter_GetWriter, METH_VARARGS,
   "GetWriter(self) -> vtkAlgorithm\nC++: virtual vtkAlgorithm *GetWriter()\n\n"},
  {"GetMTime", PyvtkParallelSerialWriter_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nReturn the MTime also considering the internal writer.\n"},
  {"SetFileNameMethod", PyvtkParallelSerialWriter_SetFileNameMethod, METH_VARARGS,
   "SetFileNameMethod(self, _arg:str) -> None\nC++: virtual void SetFileNameMethod(const char *_arg)\n\nName of the method used to set the file name of the internal\nwriter. By default, this is SetFileName.\n"},
  {"GetFileNameMethod", PyvtkParallelSerialWriter_GetFileNameMethod, METH_VARARGS,
   "GetFileNameMethod(self) -> str\nC++: virtual char *GetFileNameMethod()\n\n"},
  {"SetFileName", PyvtkParallelSerialWriter_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nGet/Set the name of the output file.\n"},
  {"GetFileName", PyvtkParallelSerialWriter_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"Write", PyvtkParallelSerialWriter_Write, METH_VARARGS,
   "Write(self) -> int\nC++: int Write()\n\nInvoke the writer.  Returns 1 for success, 0 for failure.\n"},
  {"GetPiece", PyvtkParallelSerialWriter_GetPiece, METH_VARARGS,
   "GetPiece(self) -> int\nC++: virtual int GetPiece()\n\nGet/Set the piece number to write.  The same piece number is used\nfor all inputs.\n"},
  {"SetPiece", PyvtkParallelSerialWriter_SetPiece, METH_VARARGS,
   "SetPiece(self, _arg:int) -> None\nC++: virtual void SetPiece(int _arg)\n\n"},
  {"GetNumberOfPieces", PyvtkParallelSerialWriter_GetNumberOfPieces, METH_VARARGS,
   "GetNumberOfPieces(self) -> int\nC++: virtual int GetNumberOfPieces()\n\nGet/Set the number of pieces into which the inputs are split.\n"},
  {"SetNumberOfPieces", PyvtkParallelSerialWriter_SetNumberOfPieces, METH_VARARGS,
   "SetNumberOfPieces(self, _arg:int) -> None\nC++: virtual void SetNumberOfPieces(int _arg)\n\n"},
  {"GetGhostLevel", PyvtkParallelSerialWriter_GetGhostLevel, METH_VARARGS,
   "GetGhostLevel(self) -> int\nC++: virtual int GetGhostLevel()\n\nGet/Set the number of ghost levels to be written.\n"},
  {"SetGhostLevel", PyvtkParallelSerialWriter_SetGhostLevel, METH_VARARGS,
   "SetGhostLevel(self, _arg:int) -> None\nC++: virtual void SetGhostLevel(int _arg)\n\n"},
  {"SetPreGatherHelper", PyvtkParallelSerialWriter_SetPreGatherHelper, METH_VARARGS,
   "SetPreGatherHelper(self, __a:vtkAlgorithm) -> None\nC++: void SetPreGatherHelper(vtkAlgorithm *)\n\nGet/Set the pre-reduction helper. Pre-Reduction helper is an\nalgorithm that runs on each node's data before it is sent to the\nroot.\n"},
  {"GetPreGatherHelper", PyvtkParallelSerialWriter_GetPreGatherHelper, METH_VARARGS,
   "GetPreGatherHelper(self) -> vtkAlgorithm\nC++: virtual vtkAlgorithm *GetPreGatherHelper()\n\n"},
  {"SetPostGatherHelper", PyvtkParallelSerialWriter_SetPostGatherHelper, METH_VARARGS,
   "SetPostGatherHelper(self, __a:vtkAlgorithm) -> None\nC++: void SetPostGatherHelper(vtkAlgorithm *)\n\nGet/Set the reduction helper. Reduction helper is an algorithm\nwith multiple input connections, that produces a single output as\nthe reduced output. This is run on the root node to produce a\nresult from the gathered results of each node.\n"},
  {"GetPostGatherHelper", PyvtkParallelSerialWriter_GetPostGatherHelper, METH_VARARGS,
   "GetPostGatherHelper(self) -> vtkAlgorithm\nC++: virtual vtkAlgorithm *GetPostGatherHelper()\n\n"},
  {"GetWriteAllTimeSteps", PyvtkParallelSerialWriter_GetWriteAllTimeSteps, METH_VARARGS,
   "GetWriteAllTimeSteps(self) -> int\nC++: virtual int GetWriteAllTimeSteps()\n\nMust be set to true to write all timesteps, otherwise only the\ncurrent timestep will be written out. Off by default.\n"},
  {"SetWriteAllTimeSteps", PyvtkParallelSerialWriter_SetWriteAllTimeSteps, METH_VARARGS,
   "SetWriteAllTimeSteps(self, _arg:int) -> None\nC++: virtual void SetWriteAllTimeSteps(int _arg)\n\n"},
  {"WriteAllTimeStepsOn", PyvtkParallelSerialWriter_WriteAllTimeStepsOn, METH_VARARGS,
   "WriteAllTimeStepsOn(self) -> None\nC++: virtual void WriteAllTimeStepsOn()\n\n"},
  {"WriteAllTimeStepsOff", PyvtkParallelSerialWriter_WriteAllTimeStepsOff, METH_VARARGS,
   "WriteAllTimeStepsOff(self) -> None\nC++: virtual void WriteAllTimeStepsOff()\n\n"},
  {"SetInterpreter", PyvtkParallelSerialWriter_SetInterpreter, METH_VARARGS,
   "SetInterpreter(self, interp:vtkClientServerInterpreter) -> None\nC++: void SetInterpreter(vtkClientServerInterpreter *interp)\n\nGet/Set the interpreter to use to call methods on the writer.\n"},
  {"GetFileNameSuffix", PyvtkParallelSerialWriter_GetFileNameSuffix, METH_VARARGS,
   "GetFileNameSuffix(self) -> str\nC++: virtual char *GetFileNameSuffix()\n\nProvides an option to pad the time step when writing out time\nseries data. Only allow this format: ABC%.Xd where ABC is an\narbitrary string which may or may not exist and d must exist and\nd must be the last character '.' and X may or may not exist, X\nmust be an integer if it exists. Default is nullptr.\n"},
  {"SetFileNameSuffix", PyvtkParallelSerialWriter_SetFileNameSuffix, METH_VARARGS,
   "SetFileNameSuffix(self, _arg:str) -> None\nC++: virtual void SetFileNameSuffix(const char *_arg)\n\n"},
  {"SetNumberOfIORanks", PyvtkParallelSerialWriter_SetNumberOfIORanks, METH_VARARGS,
   "SetNumberOfIORanks(self, _arg:int) -> None\nC++: virtual void SetNumberOfIORanks(int _arg)\n\nIn parallel runs, this writer can consolidate output from\nmultiple ranks to a subset of ranks. This specifies the number of\nranks that will do the final writing to disk. If NumberOfIORanks\nis 0, then all ranks will save the local data. If set to 1\n(default), the root node alone will write to disk. All data from\nall ranks will be gathered to the root node before being written\nout.\n"},
  {"GetNumberOfIORanksMinValue", PyvtkParallelSerialWriter_GetNumberOfIORanksMinValue, METH_VARARGS,
   "GetNumberOfIORanksMinValue(self) -> int\nC++: virtual int GetNumberOfIORanksMinValue()\n\n"},
  {"GetNumberOfIORanksMaxValue", PyvtkParallelSerialWriter_GetNumberOfIORanksMaxValue, METH_VARARGS,
   "GetNumberOfIORanksMaxValue(self) -> int\nC++: virtual int GetNumberOfIORanksMaxValue()\n\n"},
  {"GetNumberOfIORanks", PyvtkParallelSerialWriter_GetNumberOfIORanks, METH_VARARGS,
   "GetNumberOfIORanks(self) -> int\nC++: virtual int GetNumberOfIORanks()\n\n"},
  {"SetRankAssignmentMode", PyvtkParallelSerialWriter_SetRankAssignmentMode, METH_VARARGS,
   "SetRankAssignmentMode(self, _arg:int) -> None\nC++: virtual void SetRankAssignmentMode(int _arg)\n\nWhen `NumberOfIORanks` is greater than 1 and less than the number\nof MPI ranks, this controls how the ranks that write to disk are\ndetermined. This also affects which ranks send data to which rank\nfor IO.\n\nIn ASSIGNMENT_MODE_CONTIGUOUS (default), all MPI ranks are\nnumerically grouped into `NumberOfIORanks` groups with the first\nrank in each group acting as the `root` node for that group and\nis the one that does IO. For example, if there are 16 MPI ranks\nand NumberOfIORanks is set to 3 then the groups are `[0 - 5], [6\n- 10], [11 - 15]` with the first rank in each group 0, 6, and 15\ndoing the IO.\n\nIn ASSIGNMENT_MODE_ROUND_ROBIN, the grouping is done in round\nrobin fashion, thus for 16 MPI ranks with NumberOfIORanks set to\n3, the groups are `[0, 3, ..., 15], [1, 4, ..., 13], [2, 5, ...,\n14]` with 0, 1 and 2 doing the IO.\n"},
  {"GetRankAssignmentModeMinValue", PyvtkParallelSerialWriter_GetRankAssignmentModeMinValue, METH_VARARGS,
   "GetRankAssignmentModeMinValue(self) -> int\nC++: virtual int GetRankAssignmentModeMinValue()\n\n"},
  {"GetRankAssignmentModeMaxValue", PyvtkParallelSerialWriter_GetRankAssignmentModeMaxValue, METH_VARARGS,
   "GetRankAssignmentModeMaxValue(self) -> int\nC++: virtual int GetRankAssignmentModeMaxValue()\n\n"},
  {"GetRankAssignmentMode", PyvtkParallelSerialWriter_GetRankAssignmentMode, METH_VARARGS,
   "GetRankAssignmentMode(self) -> int\nC++: virtual int GetRankAssignmentMode()\n\n"},
  {"SetController", PyvtkParallelSerialWriter_SetController, METH_VARARGS,
   "SetController(self, controller:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *controller)\n\nGet/Set the controller to use. By default initialized to\n`vtkMultiProcessController::GetGlobalController` in the\nconstructor.\n"},
  {"GetController", PyvtkParallelSerialWriter_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkParallelSerialWriter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("writer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetWriter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetWriter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetWriter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriter/SetWriter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetFileNameMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetFileNameMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetFileNameMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileNameMethod/SetFileNameMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("piece"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetPiece(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetPiece(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetPiece(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPiece/SetPiece\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ghost_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetGhostLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetGhostLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetGhostLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGhostLevel/SetGhostLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pre_gather_helper"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetPreGatherHelper(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetPreGatherHelper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetPreGatherHelper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPreGatherHelper/SetPreGatherHelper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("post_gather_helper"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetPostGatherHelper(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetPostGatherHelper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetPostGatherHelper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPostGatherHelper/SetPostGatherHelper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_all_time_steps"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetWriteAllTimeSteps(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetWriteAllTimeSteps(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetWriteAllTimeSteps(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteAllTimeSteps/SetWriteAllTimeSteps\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpreter"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetInterpreter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetInterpreter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInterpreter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name_suffix"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetFileNameSuffix(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetFileNameSuffix(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetFileNameSuffix(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileNameSuffix/SetFileNameSuffix\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rank_assignment_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetRankAssignmentMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetRankAssignmentMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetRankAssignmentMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRankAssignmentMode/SetRankAssignmentMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_io_ranks_min_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetNumberOfIORanksMinValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfIORanksMinValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_io_ranks_max_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetNumberOfIORanksMaxValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfIORanksMaxValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_io_ranks"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelSerialWriter_GetNumberOfIORanks(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelSerialWriter_SetNumberOfIORanks(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelSerialWriter_SetNumberOfIORanks(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfIORanks/SetNumberOfIORanks\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkParallelSerialWriter_Doc =
  "vtkParallelSerialWriter - parallel meta-writer for serial formats\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "vtkParallelSerialWriter is a meta-writer that enables serial writers\n"
  "to work in parallel. By default, it gathers data to the 1st node\n"
  "(root node) and invokes the internal writer. The reduction is\n"
  "controlled by the PreGatherHelper and PostGatherHelper. Instead of\n"
  "collecting all the data to the root node the filter supports reducing\n"
  "down to a target number of ranks which ranks chosen in either\n"
  "round-robin or contiguous fashion.\n\n"
  "This also makes it possible to write time-series for temporal\n"
  "datasets using simple non-time-aware writers.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkParallelSerialWriter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsIOCore.vtkParallelSerialWriter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkParallelSerialWriter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkParallelSerialWriter_StaticNew()
{
  return vtkParallelSerialWriter::New();
}

PyObject *PyvtkParallelSerialWriter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkParallelSerialWriter_Type, PyvtkParallelSerialWriter_Methods,
    "vtkParallelSerialWriter",
 &PyvtkParallelSerialWriter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 2; c++)
  {
    static const struct { const char *name; int value; }
      constants[2] = {
        { "ASSIGNMENT_MODE_CONTIGUOUS", vtkParallelSerialWriter::ASSIGNMENT_MODE_CONTIGUOUS },
        { "ASSIGNMENT_MODE_ROUND_ROBIN", vtkParallelSerialWriter::ASSIGNMENT_MODE_ROUND_ROBIN },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkParallelSerialWriter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkParallelSerialWriter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkParallelSerialWriter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkParallelSerialWriter", o) != 0)
  {
    Py_DECREF(o);
  }

}

