// python wrapper for vtkPythonAnnotationFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPythonAnnotationFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPythonAnnotationFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPythonAnnotationFilter_ClassNew(); }


static PyObject *
PyvtkPythonAnnotationFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPythonAnnotationFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPythonAnnotationFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPythonAnnotationFilter *tempr = vtkPythonAnnotationFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPythonAnnotationFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPythonAnnotationFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPythonAnnotationFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPythonAnnotationFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_SetExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExpression(temp0);
    }
    else
    {
      op->vtkPythonAnnotationFilter::SetExpression(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetExpression() :
      op->vtkPythonAnnotationFilter::GetExpression());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_SetArrayAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArrayAssociation(temp0);
    }
    else
    {
      op->vtkPythonAnnotationFilter::SetArrayAssociation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetArrayAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetArrayAssociation() :
      op->vtkPythonAnnotationFilter::GetArrayAssociation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetComputedAnnotationValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputedAnnotationValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetComputedAnnotationValue() :
      op->vtkPythonAnnotationFilter::GetComputedAnnotationValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetDataTimeValid(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTimeValid");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDataTimeValid() :
      op->vtkPythonAnnotationFilter::GetDataTimeValid());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetDataTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetDataTime() :
      op->vtkPythonAnnotationFilter::GetDataTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetNumberOfTimeSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfTimeSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfTimeSteps() :
      op->vtkPythonAnnotationFilter::GetNumberOfTimeSteps());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetTimeStep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeStep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTimeStep(temp0) :
      op->vtkPythonAnnotationFilter::GetTimeStep(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetTimeRangeValid(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeRangeValid");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTimeRangeValid() :
      op->vtkPythonAnnotationFilter::GetTimeRangeValid());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetTimeRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetTimeRange() :
      op->vtkPythonAnnotationFilter::GetTimeRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_GetCurrentInputDataObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCurrentInputDataObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetCurrentInputDataObject() :
      op->vtkPythonAnnotationFilter::GetCurrentInputDataObject());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonAnnotationFilter_SetComputedAnnotationValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputedAnnotationValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonAnnotationFilter *op = static_cast<vtkPythonAnnotationFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputedAnnotationValue(temp0);
    }
    else
    {
      op->vtkPythonAnnotationFilter::SetComputedAnnotationValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPythonAnnotationFilter_Methods[] = {
  {"IsTypeOf", PyvtkPythonAnnotationFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPythonAnnotationFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPythonAnnotationFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPythonAnnotationFilter\nC++: static vtkPythonAnnotationFilter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPythonAnnotationFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPythonAnnotationFilter\nC++: vtkPythonAnnotationFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPythonAnnotationFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPythonAnnotationFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetExpression", PyvtkPythonAnnotationFilter_SetExpression, METH_VARARGS,
   "SetExpression(self, _arg:str) -> None\nC++: virtual void SetExpression(const char *_arg)\n\nSet the expression to evaluate. Here is a set of common\nexpressions:\n- \"Momentum %s\" %\n  str(Momentum[available_timesteps.index(provided_time)])\n"},
  {"GetExpression", PyvtkPythonAnnotationFilter_GetExpression, METH_VARARGS,
   "GetExpression(self) -> str\nC++: virtual char *GetExpression()\n\n"},
  {"SetArrayAssociation", PyvtkPythonAnnotationFilter_SetArrayAssociation, METH_VARARGS,
   "SetArrayAssociation(self, _arg:int) -> None\nC++: virtual void SetArrayAssociation(int _arg)\n\nSet the input array association. This dictates which array names\nare made available in the namespace by default. You can still use\ninput.PointData['foo'] or input.CellData['bar'] explicitly to\npick a specific array in your expression.\n"},
  {"GetArrayAssociation", PyvtkPythonAnnotationFilter_GetArrayAssociation, METH_VARARGS,
   "GetArrayAssociation(self) -> int\nC++: virtual int GetArrayAssociation()\n\n"},
  {"GetComputedAnnotationValue", PyvtkPythonAnnotationFilter_GetComputedAnnotationValue, METH_VARARGS,
   "GetComputedAnnotationValue(self) -> str\nC++: virtual char *GetComputedAnnotationValue()\n\nGet the value that is going to be printed to the output.\n"},
  {"GetDataTimeValid", PyvtkPythonAnnotationFilter_GetDataTimeValid, METH_VARARGS,
   "GetDataTimeValid(self) -> bool\nC++: virtual bool GetDataTimeValid()\n\nGet methods for use in annotation.py. The values are only valid\nduring RequestData().\n"},
  {"GetDataTime", PyvtkPythonAnnotationFilter_GetDataTime, METH_VARARGS,
   "GetDataTime(self) -> float\nC++: virtual double GetDataTime()\n\n"},
  {"GetNumberOfTimeSteps", PyvtkPythonAnnotationFilter_GetNumberOfTimeSteps, METH_VARARGS,
   "GetNumberOfTimeSteps(self) -> int\nC++: virtual int GetNumberOfTimeSteps()\n\n"},
  {"GetTimeStep", PyvtkPythonAnnotationFilter_GetTimeStep, METH_VARARGS,
   "GetTimeStep(self, index:int) -> float\nC++: double GetTimeStep(int index)\n\n"},
  {"GetTimeRangeValid", PyvtkPythonAnnotationFilter_GetTimeRangeValid, METH_VARARGS,
   "GetTimeRangeValid(self) -> bool\nC++: virtual bool GetTimeRangeValid()\n\n"},
  {"GetTimeRange", PyvtkPythonAnnotationFilter_GetTimeRange, METH_VARARGS,
   "GetTimeRange(self) -> (float, float)\nC++: virtual double *GetTimeRange()\n\n"},
  {"GetCurrentInputDataObject", PyvtkPythonAnnotationFilter_GetCurrentInputDataObject, METH_VARARGS,
   "GetCurrentInputDataObject(self) -> vtkDataObject\nC++: virtual vtkDataObject *GetCurrentInputDataObject()\n\n"},
  {"SetComputedAnnotationValue", PyvtkPythonAnnotationFilter_SetComputedAnnotationValue, METH_VARARGS,
   "SetComputedAnnotationValue(self, value:str) -> None\nC++: void SetComputedAnnotationValue(const char *value)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPythonAnnotationFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("expression"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonAnnotationFilter_GetExpression(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonAnnotationFilter_SetExpression(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonAnnotationFilter_SetExpression(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExpression/SetExpression\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("array_association"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonAnnotationFilter_GetArrayAssociation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonAnnotationFilter_SetArrayAssociation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonAnnotationFilter_SetArrayAssociation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetArrayAssociation/SetArrayAssociation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("computed_annotation_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonAnnotationFilter_GetComputedAnnotationValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonAnnotationFilter_SetComputedAnnotationValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonAnnotationFilter_SetComputedAnnotationValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputedAnnotationValue/SetComputedAnnotationValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_time_valid"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonAnnotationFilter_GetDataTimeValid(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTimeValid\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonAnnotationFilter_GetDataTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_range_valid"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonAnnotationFilter_GetTimeRangeValid(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeRangeValid\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonAnnotationFilter_GetTimeRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTimeRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("current_input_data_object"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonAnnotationFilter_GetCurrentInputDataObject(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCurrentInputDataObject\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPythonAnnotationFilter_Doc =
  "vtkPythonAnnotationFilter - filter used to generate text annotation\nfrom Python expressions.\n\n"
  "Superclass: vtkTableAlgorithm\n\n"
  "vtkPythonAnnotationFilter is designed to generate vtkTableAlgorithm\n"
  "with a single string in it. The goal is that user will write a Python\n"
  "expression, similar to an expression in Python Calculator\n"
  "(vtkPythonCalculator). The generated result is converted to string\n"
  "and placed in the output.\n\n"
  "The variables available in the expression evaluation scope are as\n"
  "follows:\n"
  "\\li sanitized array names for all arrays in the chosen\n"
  "    ArrayAssociation.\n"
  "\\li input: refers to the input dataset (wrapped as\n"
  "vtk.numpy_interface.dataset_adapter.DataObject or subclass).\n"
  "\\li time_value: vtkDataObject::DATA_TIME_STEP() from input.\n"
  "\\li time_steps: vtkDataObject::TIME_STEPS() from the input, if any\n"
  "\\li time_range: vtkDataObject::TIME_RANGE() from the input, if any\n\n"
  "Examples of valid expressions are:\n"
  "\\li \"Max temp is %s\" % max(Temp)\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPythonAnnotationFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersPython.vtkPythonAnnotationFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPythonAnnotationFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPythonAnnotationFilter_StaticNew()
{
  return vtkPythonAnnotationFilter::New();
}

PyObject *PyvtkPythonAnnotationFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPythonAnnotationFilter_Type, PyvtkPythonAnnotationFilter_Methods,
    "vtkPythonAnnotationFilter",
 &PyvtkPythonAnnotationFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkTableAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPythonAnnotationFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPythonAnnotationFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPythonAnnotationFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPythonAnnotationFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

