// python wrapper for vtkPVFeatureEdges
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVFeatureEdges.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVFeatureEdges(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVFeatureEdges_ClassNew(); }


static PyObject *
PyvtkPVFeatureEdges_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVFeatureEdges::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVFeatureEdges::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVFeatureEdges *tempr = vtkPVFeatureEdges::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVFeatureEdges *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVFeatureEdges::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVFeatureEdges::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVFeatureEdges::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_SetBoundaryEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBoundaryEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBoundaryEdges(temp0);
    }
    else
    {
      op->vtkPVFeatureEdges::SetBoundaryEdges(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetBoundaryEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoundaryEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBoundaryEdges() :
      op->vtkPVFeatureEdges::GetBoundaryEdges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_BoundaryEdgesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BoundaryEdgesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->BoundaryEdgesOn();
    }
    else
    {
      op->vtkPVFeatureEdges::BoundaryEdgesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_BoundaryEdgesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BoundaryEdgesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->BoundaryEdgesOff();
    }
    else
    {
      op->vtkPVFeatureEdges::BoundaryEdgesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_SetFeatureEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFeatureEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFeatureEdges(temp0);
    }
    else
    {
      op->vtkPVFeatureEdges::SetFeatureEdges(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetFeatureEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFeatureEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFeatureEdges() :
      op->vtkPVFeatureEdges::GetFeatureEdges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_FeatureEdgesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FeatureEdgesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->FeatureEdgesOn();
    }
    else
    {
      op->vtkPVFeatureEdges::FeatureEdgesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_FeatureEdgesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "FeatureEdgesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->FeatureEdgesOff();
    }
    else
    {
      op->vtkPVFeatureEdges::FeatureEdgesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_SetFeatureAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFeatureAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFeatureAngle(temp0);
    }
    else
    {
      op->vtkPVFeatureEdges::SetFeatureAngle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetFeatureAngleMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFeatureAngleMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetFeatureAngleMinValue() :
      op->vtkPVFeatureEdges::GetFeatureAngleMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetFeatureAngleMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFeatureAngleMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetFeatureAngleMaxValue() :
      op->vtkPVFeatureEdges::GetFeatureAngleMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetFeatureAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFeatureAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetFeatureAngle() :
      op->vtkPVFeatureEdges::GetFeatureAngle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_SetNonManifoldEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonManifoldEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonManifoldEdges(temp0);
    }
    else
    {
      op->vtkPVFeatureEdges::SetNonManifoldEdges(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetNonManifoldEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonManifoldEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNonManifoldEdges() :
      op->vtkPVFeatureEdges::GetNonManifoldEdges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_NonManifoldEdgesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NonManifoldEdgesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->NonManifoldEdgesOn();
    }
    else
    {
      op->vtkPVFeatureEdges::NonManifoldEdgesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_NonManifoldEdgesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NonManifoldEdgesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->NonManifoldEdgesOff();
    }
    else
    {
      op->vtkPVFeatureEdges::NonManifoldEdgesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_SetManifoldEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetManifoldEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetManifoldEdges(temp0);
    }
    else
    {
      op->vtkPVFeatureEdges::SetManifoldEdges(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetManifoldEdges(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetManifoldEdges");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetManifoldEdges() :
      op->vtkPVFeatureEdges::GetManifoldEdges());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_ManifoldEdgesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ManifoldEdgesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ManifoldEdgesOn();
    }
    else
    {
      op->vtkPVFeatureEdges::ManifoldEdgesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_ManifoldEdgesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ManifoldEdgesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ManifoldEdgesOff();
    }
    else
    {
      op->vtkPVFeatureEdges::ManifoldEdgesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_SetColoring(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColoring(temp0);
    }
    else
    {
      op->vtkPVFeatureEdges::SetColoring(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetColoring(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColoring");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetColoring() :
      op->vtkPVFeatureEdges::GetColoring());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_ColoringOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ColoringOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ColoringOn();
    }
    else
    {
      op->vtkPVFeatureEdges::ColoringOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_ColoringOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ColoringOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ColoringOff();
    }
    else
    {
      op->vtkPVFeatureEdges::ColoringOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_SetMergePoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMergePoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMergePoints(temp0);
    }
    else
    {
      op->vtkPVFeatureEdges::SetMergePoints(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFeatureEdges_GetMergePoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMergePoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFeatureEdges *op = static_cast<vtkPVFeatureEdges *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMergePoints() :
      op->vtkPVFeatureEdges::GetMergePoints());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVFeatureEdges_Methods[] = {
  {"IsTypeOf", PyvtkPVFeatureEdges_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVFeatureEdges_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVFeatureEdges_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVFeatureEdges\nC++: static vtkPVFeatureEdges *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVFeatureEdges_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVFeatureEdges\nC++: vtkPVFeatureEdges *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVFeatureEdges_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVFeatureEdges_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetBoundaryEdges", PyvtkPVFeatureEdges_SetBoundaryEdges, METH_VARARGS,
   "SetBoundaryEdges(self, _arg:bool) -> None\nC++: virtual void SetBoundaryEdges(bool _arg)\n\nTurn on/off the extraction of boundary edges. Default is true.\n"},
  {"GetBoundaryEdges", PyvtkPVFeatureEdges_GetBoundaryEdges, METH_VARARGS,
   "GetBoundaryEdges(self) -> bool\nC++: virtual bool GetBoundaryEdges()\n\n"},
  {"BoundaryEdgesOn", PyvtkPVFeatureEdges_BoundaryEdgesOn, METH_VARARGS,
   "BoundaryEdgesOn(self) -> None\nC++: virtual void BoundaryEdgesOn()\n\n"},
  {"BoundaryEdgesOff", PyvtkPVFeatureEdges_BoundaryEdgesOff, METH_VARARGS,
   "BoundaryEdgesOff(self) -> None\nC++: virtual void BoundaryEdgesOff()\n\n"},
  {"SetFeatureEdges", PyvtkPVFeatureEdges_SetFeatureEdges, METH_VARARGS,
   "SetFeatureEdges(self, _arg:bool) -> None\nC++: virtual void SetFeatureEdges(bool _arg)\n\nTurn on/off the extraction of feature edges. Default is true.\n\note: Unused if input is a vtkHyperTreeGrid instance.\n"},
  {"GetFeatureEdges", PyvtkPVFeatureEdges_GetFeatureEdges, METH_VARARGS,
   "GetFeatureEdges(self) -> bool\nC++: virtual bool GetFeatureEdges()\n\n"},
  {"FeatureEdgesOn", PyvtkPVFeatureEdges_FeatureEdgesOn, METH_VARARGS,
   "FeatureEdgesOn(self) -> None\nC++: virtual void FeatureEdgesOn()\n\n"},
  {"FeatureEdgesOff", PyvtkPVFeatureEdges_FeatureEdgesOff, METH_VARARGS,
   "FeatureEdgesOff(self) -> None\nC++: virtual void FeatureEdgesOff()\n\n"},
  {"SetFeatureAngle", PyvtkPVFeatureEdges_SetFeatureAngle, METH_VARARGS,
   "SetFeatureAngle(self, _arg:float) -> None\nC++: virtual void SetFeatureAngle(double _arg)\n\nSpecify the feature angle for extracting feature edges. Default\nis 30.0\n\note: Unused if input is a vtkHyperTreeGrid instance.\n"},
  {"GetFeatureAngleMinValue", PyvtkPVFeatureEdges_GetFeatureAngleMinValue, METH_VARARGS,
   "GetFeatureAngleMinValue(self) -> float\nC++: virtual double GetFeatureAngleMinValue()\n\n"},
  {"GetFeatureAngleMaxValue", PyvtkPVFeatureEdges_GetFeatureAngleMaxValue, METH_VARARGS,
   "GetFeatureAngleMaxValue(self) -> float\nC++: virtual double GetFeatureAngleMaxValue()\n\n"},
  {"GetFeatureAngle", PyvtkPVFeatureEdges_GetFeatureAngle, METH_VARARGS,
   "GetFeatureAngle(self) -> float\nC++: virtual double GetFeatureAngle()\n\n"},
  {"SetNonManifoldEdges", PyvtkPVFeatureEdges_SetNonManifoldEdges, METH_VARARGS,
   "SetNonManifoldEdges(self, _arg:bool) -> None\nC++: virtual void SetNonManifoldEdges(bool _arg)\n\nTurn on/off the extraction of non-manifold edges. Default is\ntrue.\n\note: Unused if input is a vtkHyperTreeGrid instance.\n"},
  {"GetNonManifoldEdges", PyvtkPVFeatureEdges_GetNonManifoldEdges, METH_VARARGS,
   "GetNonManifoldEdges(self) -> bool\nC++: virtual bool GetNonManifoldEdges()\n\n"},
  {"NonManifoldEdgesOn", PyvtkPVFeatureEdges_NonManifoldEdgesOn, METH_VARARGS,
   "NonManifoldEdgesOn(self) -> None\nC++: virtual void NonManifoldEdgesOn()\n\n"},
  {"NonManifoldEdgesOff", PyvtkPVFeatureEdges_NonManifoldEdgesOff, METH_VARARGS,
   "NonManifoldEdgesOff(self) -> None\nC++: virtual void NonManifoldEdgesOff()\n\n"},
  {"SetManifoldEdges", PyvtkPVFeatureEdges_SetManifoldEdges, METH_VARARGS,
   "SetManifoldEdges(self, _arg:bool) -> None\nC++: virtual void SetManifoldEdges(bool _arg)\n\nTurn on/off the extraction of manifold edges. This typically\ncorrespond to interior edges. Default is false.\n\note: Unused if input is a vtkHyperTreeGrid instance.\n"},
  {"GetManifoldEdges", PyvtkPVFeatureEdges_GetManifoldEdges, METH_VARARGS,
   "GetManifoldEdges(self) -> bool\nC++: virtual bool GetManifoldEdges()\n\n"},
  {"ManifoldEdgesOn", PyvtkPVFeatureEdges_ManifoldEdgesOn, METH_VARARGS,
   "ManifoldEdgesOn(self) -> None\nC++: virtual void ManifoldEdgesOn()\n\n"},
  {"ManifoldEdgesOff", PyvtkPVFeatureEdges_ManifoldEdgesOff, METH_VARARGS,
   "ManifoldEdgesOff(self) -> None\nC++: virtual void ManifoldEdgesOff()\n\n"},
  {"SetColoring", PyvtkPVFeatureEdges_SetColoring, METH_VARARGS,
   "SetColoring(self, _arg:bool) -> None\nC++: virtual void SetColoring(bool _arg)\n\nTurn on/off the coloring of edges by type. Default is false.\n\note: Unused if input is a vtkHyperTreeGrid instance.\n"},
  {"GetColoring", PyvtkPVFeatureEdges_GetColoring, METH_VARARGS,
   "GetColoring(self) -> bool\nC++: virtual bool GetColoring()\n\n"},
  {"ColoringOn", PyvtkPVFeatureEdges_ColoringOn, METH_VARARGS,
   "ColoringOn(self) -> None\nC++: virtual void ColoringOn()\n\n"},
  {"ColoringOff", PyvtkPVFeatureEdges_ColoringOff, METH_VARARGS,
   "ColoringOff(self) -> None\nC++: virtual void ColoringOff()\n\n"},
  {"SetMergePoints", PyvtkPVFeatureEdges_SetMergePoints, METH_VARARGS,
   "SetMergePoints(self, _arg:bool) -> None\nC++: virtual void SetMergePoints(bool _arg)\n\nTurn on/off merging of coincident points using a locator. Note\nthat when merging is on, points with different point attributes\n(e.g., normals) are merged, which may cause rendering artifacts.\nDefault is false.\n\note: Unused if input is NOT a vtkHyperTreeGrid instance.\n"},
  {"GetMergePoints", PyvtkPVFeatureEdges_GetMergePoints, METH_VARARGS,
   "GetMergePoints(self) -> bool\nC++: virtual bool GetMergePoints()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVFeatureEdges_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("boundary_edges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFeatureEdges_GetBoundaryEdges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFeatureEdges_SetBoundaryEdges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFeatureEdges_SetBoundaryEdges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBoundaryEdges/SetBoundaryEdges\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("feature_edges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFeatureEdges_GetFeatureEdges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFeatureEdges_SetFeatureEdges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFeatureEdges_SetFeatureEdges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFeatureEdges/SetFeatureEdges\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("feature_angle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFeatureEdges_GetFeatureAngle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFeatureEdges_SetFeatureAngle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFeatureEdges_SetFeatureAngle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFeatureAngle/SetFeatureAngle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("non_manifold_edges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFeatureEdges_GetNonManifoldEdges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFeatureEdges_SetNonManifoldEdges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFeatureEdges_SetNonManifoldEdges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNonManifoldEdges/SetNonManifoldEdges\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("manifold_edges"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFeatureEdges_GetManifoldEdges(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFeatureEdges_SetManifoldEdges(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFeatureEdges_SetManifoldEdges(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetManifoldEdges/SetManifoldEdges\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("coloring"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFeatureEdges_GetColoring(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFeatureEdges_SetColoring(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFeatureEdges_SetColoring(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetColoring/SetColoring\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("merge_points"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFeatureEdges_GetMergePoints(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFeatureEdges_SetMergePoints(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFeatureEdges_SetMergePoints(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMergePoints/SetMergePoints\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVFeatureEdges_Doc =
  "vtkPVFeatureEdges - Feature Edges filter that delegates to type\nspecific implementations\n\n"
  "Superclass: vtkPolyDataAlgorithm\n\n"
  "This is a meta filter of vtkPVFeatureEdges that allows selection of\n"
  "input vtkHyperTreeGrid or vtkPolyData\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVFeatureEdges_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsCore.vtkPVFeatureEdges", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVFeatureEdges_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVFeatureEdges_StaticNew()
{
  return vtkPVFeatureEdges::New();
}

PyObject *PyvtkPVFeatureEdges_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVFeatureEdges_Type, PyvtkPVFeatureEdges_Methods,
    "vtkPVFeatureEdges",
 &PyvtkPVFeatureEdges_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPolyDataAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVFeatureEdges_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVFeatureEdges(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVFeatureEdges_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVFeatureEdges", o) != 0)
  {
    Py_DECREF(o);
  }

}

