#ifndef SBK_KURLLABELWRAPPER_H
#define SBK_KURLLABELWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kurllabel.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KUrlLabelWrapper : public KUrlLabel
{
public:
    KUrlLabelWrapper(::QWidget * parent = nullptr);
    KUrlLabelWrapper(const ::QString & url, const ::QString & text = QString(), ::QWidget * parent = nullptr);
    KUrlLabelWrapper(const KUrlLabelWrapper &) = delete;
    KUrlLabelWrapper& operator=(const KUrlLabelWrapper &) = delete;
    KUrlLabelWrapper(KUrlLabelWrapper &&) = delete;
    KUrlLabelWrapper& operator=(KUrlLabelWrapper &&) = delete;
    ~KUrlLabelWrapper() override;

    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * arg__1) override;
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * ev) override;
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * event) override;
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    void dragMoveEvent(::QDragMoveEvent * event) override;
    void dropEvent(::QDropEvent * event) override;
    void enterEvent(::QEnterEvent * event) override;
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * ev) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * ev) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * event) override;
    void initPainter(::QPainter * painter) const override;
    void initStyleOption(::QStyleOptionFrame * option) const override;
    static void sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionFrame * option);
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent(::QKeyEvent * ev) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    void leaveEvent(::QEvent * arg__1) override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent(::QMouseEvent * ev) override;
    void mousePressEvent(::QMouseEvent * ev) override;
    void mouseReleaseEvent(::QMouseEvent * arg__1) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * arg__1) override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent(::QResizeEvent * event) override;
    void setFont(const ::QFont & font) override;
    static void sbk_o_setFont(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QFont & font);
    void setVisible(bool visible) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * event) override;
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;
    void wheelEvent(::QWheelEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 49> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KURLLABELWRAPPER_H
