
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kmessageboxnotifyinterface_wrapper.h"

// Argument includes
#include <QString>
#include <qmessagebox.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMessageBoxNotifyInterface_Type = nullptr;
static PyTypeObject *Sbk_KMessageBoxNotifyInterface_TypeF(void)
{
    return _Sbk_KMessageBoxNotifyInterface_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMessageBoxNotifyInterfaceWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KMessageBoxNotifyInterfaceWrapper::KMessageBoxNotifyInterfaceWrapper()
{
}

void KMessageBoxNotifyInterfaceWrapper::sendNotification(::QMessageBox::Icon notificationType, const ::QString & message, ::QWidget * parent)
{
    static const char *funcName = "sendNotification";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageBoxNotifyInterface_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KMessageBoxNotifyInterface.sendNotification");
        return;
    }
    sbk_o_sendNotification("KMessageBoxNotifyInterface", funcName, gil, pyOverride, notificationType, message, parent);
}

void KMessageBoxNotifyInterfaceWrapper::sbk_o_sendNotification(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMessageBox::Icon notificationType, const ::QString & message, ::QWidget * parent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMessageBox_Icon_IDX])))->converter, &notificationType),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &message),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), parent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMessageBox_Icon_IDX])))->converter, &notificationType),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &message),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), parent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

KMessageBoxNotifyInterfaceWrapper::~KMessageBoxNotifyInterfaceWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMessageBoxNotifyInterface_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMessageBoxNotifyInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBoxNotifyInterface_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("KMessageBoxNotifyInterface");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMessageBoxNotifyInterface >()))
        return -1;

    KMessageBoxNotifyInterfaceWrapper *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KMessageBoxNotifyInterface_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // KMessageBoxNotifyInterface()
        cptr = new KMessageBoxNotifyInterfaceWrapper();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KMessageBoxNotifyInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KMessageBoxNotifyInterfaceFunc_sendNotification(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageBoxNotifyInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBoxNotifyInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "sendNotification", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMessageBoxNotifyInterface::sendNotification(QMessageBox::Icon,QString,QWidget*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMessageBox_Icon_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
        overloadId = 0; // sendNotification(QMessageBox::Icon,QString,QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "sendNotification", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageBoxNotifyInterface_IDX]);

    // Call function/method
    {
        ::QMessageBox::Icon cppArg0{QMessageBox::NoIcon};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sendNotification(QMessageBox::Icon,QString,QWidget*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("KMessageBoxNotifyInterface.sendNotification");
                return {};
            }
            cppSelf->sendNotification(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KMessageBoxNotifyInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMessageBoxNotifyInterface_methods[] = {
    {"sendNotification", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxNotifyInterfaceFunc_sendNotification), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMessageBoxNotifyInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMessageBoxNotifyInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBoxNotifyInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMessageBoxNotifyInterfaceWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMessageBoxNotifyInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMessageBoxNotifyInterface_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMessageBoxNotifyInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMessageBoxNotifyInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMessageBoxNotifyInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMessageBoxNotifyInterface_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMessageBoxNotifyInterface_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMessageBoxNotifyInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMessageBoxNotifyInterface_spec = {
    "1:KWidgetsAddons.KMessageBoxNotifyInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMessageBoxNotifyInterface_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMessageBoxNotifyInterface_PythonToCpp_KMessageBoxNotifyInterface_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMessageBoxNotifyInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMessageBoxNotifyInterface_PythonToCpp_KMessageBoxNotifyInterface_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMessageBoxNotifyInterface_TypeF()))
        return KMessageBoxNotifyInterface_PythonToCpp_KMessageBoxNotifyInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMessageBoxNotifyInterface_PTR_CppToPython_KMessageBoxNotifyInterface(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KMessageBoxNotifyInterface_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::KMessageBoxNotifyInterface *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_KMessageBoxNotifyInterface_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMessageBoxNotifyInterface_SignatureStrings[] = {
    "KWidgetsAddons.KMessageBoxNotifyInterface(self)",
    "KWidgetsAddons.KMessageBoxNotifyInterface.sendNotification(self,notificationType:PySide6.QtWidgets.QMessageBox.Icon,message:QString,parent:PySide6.QtWidgets.QWidget)",
    nullptr}; // Sentinel
#else
static constexpr size_t KMessageBoxNotifyInterface_SignatureByteSize = 129;
static constexpr uint8_t KMessageBoxNotifyInterface_SignatureBytes[129] = {
    0x78, 0xda, 0x8d, 0x8c, 0x31, 0x0b, 0xc2, 0x30, 0x10, 0x85, 0xf7, 0xfe, 0x12, 0x0b, 0x21, 0xa3,
    0x43, 0x37, 0xdd, 0x4a, 0x50, 0x0c, 0x15, 0x9c, 0x43, 0x72, 0x09, 0x07, 0x7a, 0x57, 0x72, 0x37,
    0x98, 0x7f, 0x2f, 0xb4, 0x82, 0x1d, 0x3a, 0xb8, 0xbd, 0xf7, 0xf1, 0xde, 0xe7, 0x1e, 0x98, 0x0a,
    0xa8, 0x9c, 0x52, 0x62, 0x12, 0xeb, 0x2e, 0x20, 0x12, 0x0a, 0x9c, 0xf9, 0x7d, 0x65, 0xc5, 0xdc,
    0x46, 0x52, 0xa8, 0x39, 0x44, 0x38, 0x08, 0x3c, 0x73, 0xdf, 0xb9, 0x7f, 0xf7, 0x56, 0x80, 0xd2,
    0xc2, 0x30, 0x06, 0x45, 0xa6, 0x45, 0x60, 0x68, 0x43, 0xee, 0x6d, 0x86, 0xe1, 0xd6, 0x26, 0x4c,
    0x70, 0xb4, 0x5e, 0xbf, 0x66, 0xeb, 0x7f, 0x4e, 0x3b, 0x46, 0x26, 0xf3, 0x5a, 0xfb, 0xe0, 0x27,
    0xad, 0x48, 0xc5, 0xcc, 0xa1, 0x02, 0xe9, 0xde, 0x73, 0x0d, 0x7d, 0xf7, 0x01, 0x20, 0x72, 0x50,
    0x57
};
#endif

PyTypeObject *init_KMessageBoxNotifyInterface(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KMessageBoxNotifyInterface_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KMessageBoxNotifyInterface_IDX].type;

    Shiboken::AutoDecRef Sbk_KMessageBoxNotifyInterface_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KMessageBoxNotifyInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMessageBoxNotifyInterface",
        "KMessageBoxNotifyInterface*",
        &Sbk_KMessageBoxNotifyInterface_spec,
        &Shiboken::callCppDestructor< KMessageBoxNotifyInterface >,
        Sbk_KMessageBoxNotifyInterface_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KMessageBoxNotifyInterface_Type; // references _Sbk_KMessageBoxNotifyInterface_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMessageBoxNotifyInterface_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMessageBoxNotifyInterface_SignatureBytes, KMessageBoxNotifyInterface_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMessageBoxNotifyInterface_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageBoxNotifyInterface_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMessageBoxNotifyInterface_PythonToCpp_KMessageBoxNotifyInterface_PTR,
        is_KMessageBoxNotifyInterface_PythonToCpp_KMessageBoxNotifyInterface_PTR_Convertible,
        KMessageBoxNotifyInterface_PTR_CppToPython_KMessageBoxNotifyInterface);

    Shiboken::Conversions::registerConverterName(converter, "KMessageBoxNotifyInterface");
    Shiboken::Conversions::registerConverterName(converter, "KMessageBoxNotifyInterface*");
    Shiboken::Conversions::registerConverterName(converter, "KMessageBoxNotifyInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMessageBoxNotifyInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMessageBoxNotifyInterfaceWrapper).name());

    qRegisterMetaType< ::KMessageBoxNotifyInterface *>();

    return pyType;
}
