
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kled_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <kled.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KLed_Type = nullptr;
static PyTypeObject *Sbk_KLed_TypeF(void)
{
    return _Sbk_KLed_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KLedWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KLedWrapper::KLedWrapper(::QWidget * parent) : KLed(parent)
{
}

KLedWrapper::KLedWrapper(const ::QColor & color, ::KLed::State state, ::KLed::Look look, ::KLed::Shape shape, ::QWidget * parent) : KLed(color, state, look, shape, parent)
{
}

KLedWrapper::KLedWrapper(const ::QColor & color, ::QWidget * parent) : KLed(color, parent)
{
}

void KLedWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KLed", funcName, gil, pyOverride, signal);
}

void KLedWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KLed", funcName, gil, pyOverride, event);
}

int KLedWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KLed", funcName, gil, pyOverride);
}

void KLedWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KLed", funcName, gil, pyOverride, signal);
}

void KLedWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KLed", funcName, gil, pyOverride, event);
}

bool KLedWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KLed", funcName, gil, pyOverride, event);
}

bool KLedWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KLed", funcName, gil, pyOverride, watched, event);
}

void KLedWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KLed", funcName, gil, pyOverride, event);
}

bool KLedWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KLed", funcName, gil, pyOverride, next);
}

void KLedWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KLed", funcName, gil, pyOverride, event);
}

bool KLedWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KLed", funcName, gil, pyOverride);
}

int KLedWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KLed", funcName, gil, pyOverride, arg__1);
}

void KLedWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KLed", funcName, gil, pyOverride, painter);
}

void KLedWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KLed", funcName, gil, pyOverride, event);
}

::QVariant KLedWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KLed", funcName, gil, pyOverride, arg__1);
}

void KLedWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KLed", funcName, gil, pyOverride, event);
}

int KLedWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KLed", funcName, gil, pyOverride, arg__1);
}

::QSize KLedWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::KLed::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KLed", funcName, gil, pyOverride);
}

void KLedWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KLed", funcName, gil, pyOverride, event);
}

bool KLedWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KLed", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KLedWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KLed", funcName, gil, pyOverride);
}

void KLedWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::KLed::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KLed", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KLedWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KLed", funcName, gil, pyOverride, offset);
}

void KLedWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::KLed::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KLed", funcName, gil, pyOverride, arg__1);
}

void KLedWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KLed", funcName, gil, pyOverride, visible);
}

::QPainter * KLedWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KLed", funcName, gil, pyOverride);
}

void KLedWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KLed", funcName, gil, pyOverride, event);
}

::QSize KLedWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::KLed::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KLed", funcName, gil, pyOverride);
}

void KLedWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KLed", funcName, gil, pyOverride, event);
}

void KLedWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLed_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KLed", funcName, gil, pyOverride, event);
}

const QMetaObject *KLedWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KLed::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KLedWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KLed::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KLedWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KLedWrapper *>(this));
    }
    return KLed::qt_metacast(_clname);
}

KLedWrapper::~KLedWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KLed_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KLed_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KLed >()))
        return -1;

    KLedWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    if (numArgs == 3)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:KLed", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KLed::KLed(QWidget*=)
    // 1: KLed::KLed(QColor,KLed::State,KLed::Look,KLed::Shape,QWidget*=)
    // 2: KLed::KLed(QColor,QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KLed(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // KLed(QColor,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 2; // KLed(QColor,QWidget*)
        } else if (numArgs >= 4
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_State_IDX])))->converter, (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_Look_IDX])))->converter, (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_Shape_IDX])))->converter, (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 1; // KLed(QColor,KLed::State,KLed::Look,KLed::Shape,QWidget*)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[4])))) {
                overloadId = 1; // KLed(QColor,KLed::State,KLed::Look,KLed::Shape,QWidget*)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KLed(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KLed(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KLed(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KLedWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KLedWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KLed(const QColor &color, KLed::State state, KLed::Look look, KLed::Shape shape, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 4}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::KLed::State cppArg1{KLed::Off};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::KLed::Look cppArg2{KLed::Flat};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::KLed::Shape cppArg3{KLed::Rectangular};
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QWidget *cppArg4 = nullptr;
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KLed(QColor,KLed::State,KLed::Look,KLed::Shape,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KLedWrapper(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KLedWrapper(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                }

            }
            break;
        }
        case 2: // KLed(const QColor &color, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KLed(QColor,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KLedWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KLedWrapper(*cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KLed >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KLedFunc_color(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // color()const
        QColor cppResult = const_cast<const ::KLed *>(cppSelf)->color();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLedFunc_darkFactor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // darkFactor()const
        int cppResult = const_cast<const ::KLed *>(cppSelf)->darkFactor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLedFunc_look(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // look()const
        KLed::Look cppResult = const_cast<const ::KLed *>(cppSelf)->look();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_Look_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLedFunc_minimumSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumSizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KLed *>(cppSelf)->::KLed::minimumSizeHint()
            : const_cast<const ::KLed *>(cppSelf)->minimumSizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLedFunc_off(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // off()
        cppSelf->off();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KLedFunc_on(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // on()
        cppSelf->on();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KLedFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KLed::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KLedFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KLed::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KLedFunc_setColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KLed::setColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setColor(QColor)
            cppSelf->setColor(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KLedFunc_setDarkFactor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KLed::setDarkFactor(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDarkFactor(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDarkFactor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDarkFactor(int)
            cppSelf->setDarkFactor(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KLedFunc_setLook(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KLed::setLook(KLed::Look)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_Look_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setLook(KLed::Look)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLook", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);

    // Call function/method
    {
        ::KLed::Look cppArg0{KLed::Flat};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLook(KLed::Look)
            cppSelf->setLook(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KLedFunc_setShape(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KLed::setShape(KLed::Shape)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_Shape_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setShape(KLed::Shape)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShape", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);

    // Call function/method
    {
        ::KLed::Shape cppArg0{KLed::Rectangular};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShape(KLed::Shape)
            cppSelf->setShape(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KLedFunc_setState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KLed::setState(KLed::State)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_State_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setState(KLed::State)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setState", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);

    // Call function/method
    {
        ::KLed::State cppArg0{KLed::Off};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setState(KLed::State)
            cppSelf->setState(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KLedFunc_shape(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // shape()const
        KLed::Shape cppResult = const_cast<const ::KLed *>(cppSelf)->shape();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_Shape_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLedFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KLed *>(cppSelf)->::KLed::sizeHint()
            : const_cast<const ::KLed *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLedFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // state()const
        KLed::State cppResult = const_cast<const ::KLed *>(cppSelf)->state();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_State_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLedFunc_toggle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggle()
        cppSelf->toggle();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KLed_PropertyStrings[] = {
    "color::",
    "darkFactor::",
    "look::",
    "shape::",
    "state::",
    nullptr // Sentinel
};

static const char *Sbk_KLed_EnumFlagInfo[] = {
    "Look:IntEnum",
    "Shape:IntEnum",
    "State:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KLed_methods[] = {
    {"color", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_color), METH_NOARGS, nullptr},
    {"darkFactor", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_darkFactor), METH_NOARGS, nullptr},
    {"look", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_look), METH_NOARGS, nullptr},
    {"minimumSizeHint", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_minimumSizeHint), METH_NOARGS, nullptr},
    {"off", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_off), METH_NOARGS, nullptr},
    {"on", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_on), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_paintEvent), METH_O, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_resizeEvent), METH_O, nullptr},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_setColor), METH_O, nullptr},
    {"setDarkFactor", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_setDarkFactor), METH_O, nullptr},
    {"setLook", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_setLook), METH_O, nullptr},
    {"setShape", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_setShape), METH_O, nullptr},
    {"setState", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_setState), METH_O, nullptr},
    {"shape", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_shape), METH_NOARGS, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_sizeHint), METH_NOARGS, nullptr},
    {"state", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_state), METH_NOARGS, nullptr},
    {"toggle", reinterpret_cast<PyCFunction>(Sbk_KLedFunc_toggle), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KLed_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KLed *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KLedWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KLed_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KLed_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KLedSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KLed *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KLed_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KLed_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KLed_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KLed_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KLed_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KLed_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KLed_spec = {
    "1:KWidgetsAddons.KLed",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KLed_slots
};

} //extern "C"

static void *Sbk_KLed_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KLed *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KLed *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KLed *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KLed_State(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KLed::State>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KLed::State *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KLed_State_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_State_IDX])))
        return Enum_PythonToCpp_KLed_State;
    return {};
}

static PyObject *KLed_State_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KLed::State>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KLed::State *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KLed_Shape(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KLed::Shape>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KLed::Shape *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KLed_Shape_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_Shape_IDX])))
        return Enum_PythonToCpp_KLed_Shape;
    return {};
}

static PyObject *KLed_Shape_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KLed::Shape>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KLed::Shape *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KLed_Look(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KLed::Look>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KLed::Look *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KLed_Look_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLed_Look_IDX])))
        return Enum_PythonToCpp_KLed_Look;
    return {};
}

static PyObject *KLed_Look_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KLed::Look>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KLed::Look *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KLed_PythonToCpp_KLed_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KLed_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KLed_PythonToCpp_KLed_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KLed_TypeF()))
        return KLed_PythonToCpp_KLed_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KLed_PTR_CppToPython_KLed(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KLed *>(const_cast<void *>(cppIn)), Sbk_KLed_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KLed_SignatureStrings[] = {
    "2:KWidgetsAddons.KLed(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,state:KWidgetsAddons.KLed.State=None,shape:KWidgetsAddons.KLed.Shape=None,look:KWidgetsAddons.KLed.Look=None,color:QColor=None,darkFactor:int=None)",
    "1:KWidgetsAddons.KLed(self,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],state:KWidgetsAddons.KLed.State,look:KWidgetsAddons.KLed.Look,shape:KWidgetsAddons.KLed.Shape,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,state:KWidgetsAddons.KLed.State=None,shape:KWidgetsAddons.KLed.Shape=None,look:KWidgetsAddons.KLed.Look=None,color:QColor=None,darkFactor:int=None)",
    "0:KWidgetsAddons.KLed(self,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int],parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,state:KWidgetsAddons.KLed.State=None,shape:KWidgetsAddons.KLed.Shape=None,look:KWidgetsAddons.KLed.Look=None,color:QColor=None,darkFactor:int=None)",
    "KWidgetsAddons.KLed.color(self)->PySide6.QtGui.QColor",
    "KWidgetsAddons.KLed.darkFactor(self)->int",
    "KWidgetsAddons.KLed.look(self)->KWidgetsAddons.KLed.Look",
    "KWidgetsAddons.KLed.minimumSizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KLed.off(self)",
    "KWidgetsAddons.KLed.on(self)",
    "KWidgetsAddons.KLed.paintEvent(self,arg__1:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KLed.resizeEvent(self,arg__1:PySide6.QtGui.QResizeEvent)",
    "KWidgetsAddons.KLed.setColor(self,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "KWidgetsAddons.KLed.setDarkFactor(self,darkFactor:int)",
    "KWidgetsAddons.KLed.setLook(self,look:KWidgetsAddons.KLed.Look)",
    "KWidgetsAddons.KLed.setShape(self,shape:KWidgetsAddons.KLed.Shape)",
    "KWidgetsAddons.KLed.setState(self,state:KWidgetsAddons.KLed.State)",
    "KWidgetsAddons.KLed.shape(self)->KWidgetsAddons.KLed.Shape",
    "KWidgetsAddons.KLed.sizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KLed.state(self)->KWidgetsAddons.KLed.State",
    "KWidgetsAddons.KLed.toggle(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KLed_SignatureByteSize = 404;
static constexpr uint8_t KLed_SignatureBytes[404] = {
    0x78, 0xda, 0xdd, 0x93, 0x51, 0x4b, 0xc3, 0x30, 0x10, 0xc7, 0xdf, 0xf7, 0x29, 0xf6, 0xe8, 0xa4,
    0x16, 0x27, 0xb2, 0x87, 0xc2, 0x04, 0x99, 0x3a, 0x61, 0x45, 0xd7, 0x0d, 0xf5, 0x41, 0x64, 0x64,
    0x4b, 0x56, 0xc3, 0xb2, 0x4b, 0x49, 0x52, 0xa5, 0x7e, 0x7a, 0xd3, 0xa6, 0xed, 0x74, 0x26, 0x2d,
    0xf8, 0xa4, 0x7b, 0x6a, 0xc9, 0xfd, 0xfe, 0xff, 0xbb, 0x5c, 0xee, 0xce, 0x82, 0xc9, 0x13, 0xc5,
    0x31, 0x51, 0xf2, 0x12, 0x63, 0x0e, 0xd2, 0x9f, 0x84, 0x04, 0x1f, 0x49, 0xc2, 0xd6, 0x5e, 0x82,
    0x04, 0x01, 0x15, 0x4c, 0xb3, 0x39, 0xc5, 0x64, 0xe0, 0x47, 0xaa, 0x04, 0xfd, 0xc8, 0xfc, 0x0c,
    0x21, 0x65, 0x2c, 0x51, 0xc2, 0x3b, 0x0e, 0x26, 0x24, 0x7b, 0xe7, 0x02, 0xdf, 0x03, 0xcb, 0x86,
    0x77, 0x1c, 0x88, 0x27, 0x15, 0x52, 0xc4, 0x66, 0xed, 0xcf, 0xf3, 0x48, 0x09, 0xbd, 0xa2, 0xc4,
    0x01, 0xe5, 0x11, 0x03, 0x31, 0xce, 0x37, 0x56, 0x26, 0xd4, 0x01, 0x83, 0xac, 0x38, 0xe3, 0x22,
    0x88, 0x46, 0xf9, 0xc7, 0x9c, 0x60, 0x24, 0x36, 0x37, 0x68, 0xa5, 0xf4, 0x31, 0x05, 0x55, 0x9c,
    0xf5, 0x3a, 0x7d, 0xf7, 0x55, 0x8d, 0x83, 0xca, 0x12, 0x0a, 0xb1, 0xff, 0x00, 0x94, 0xc3, 0xf3,
    0xee, 0xda, 0xe3, 0x94, 0xfa, 0xc6, 0xdc, 0xeb, 0x46, 0x21, 0x52, 0x14, 0xfa, 0x73, 0x25, 0x34,
    0xe9, 0x75, 0xf7, 0xa0, 0x59, 0xbc, 0x44, 0x83, 0x73, 0x4d, 0x3d, 0x22, 0x41, 0x11, 0xa8, 0xaf,
    0xc0, 0x88, 0x0b, 0xa2, 0x3f, 0xfe, 0x98, 0xf1, 0x25, 0x62, 0x95, 0x5d, 0x65, 0x94, 0x82, 0xa4,
    0x31, 0x10, 0xdc, 0xd5, 0xe5, 0xbe, 0xb4, 0x75, 0xaf, 0xb9, 0x27, 0x6d, 0x6d, 0x3d, 0xb8, 0x77,
    0x3d, 0xfd, 0x37, 0xef, 0x7a, 0x68, 0x9d, 0xb7, 0x99, 0x14, 0xd2, 0xa2, 0xfb, 0xbd, 0x93, 0x0b,
    0x5b, 0xb3, 0xad, 0xaa, 0x9d, 0x7d, 0x25, 0xd5, 0x59, 0xac, 0x64, 0x5e, 0x7d, 0xc5, 0xb8, 0x2e,
    0x61, 0x15, 0x6e, 0x29, 0xd0, 0x6d, 0xba, 0x9d, 0xd3, 0x0f, 0x72, 0xab, 0xcd, 0x7f, 0x96, 0x68,
    0x5e, 0x32, 0x8f, 0x5b, 0xf5, 0x7c, 0xbd, 0x36, 0x1a, 0x7b, 0x14, 0x1a, 0x82, 0x09, 0xd2, 0x09,
    0xaf, 0xdf, 0x48, 0x99, 0xd5, 0x43, 0x22, 0x5e, 0x2c, 0xfa, 0xc1, 0x5e, 0x77, 0xa6, 0x35, 0x65,
    0x77, 0x11, 0x44, 0xea, 0xda, 0x5a, 0x6d, 0x66, 0x3b, 0xcc, 0xee, 0x23, 0x89, 0x1a, 0xd5, 0x8f,
    0xf4, 0xc7, 0x56, 0xc4, 0x59, 0xf1, 0xd5, 0xf7, 0x01, 0xd9, 0x9b, 0x47, 0xa7, 0x2c, 0xac, 0xa6,
    0xa5, 0x79, 0xea, 0x9d, 0xfa, 0x62, 0x6d, 0x8c, 0x41, 0xcb, 0x6e, 0xb9, 0x2d, 0xf2, 0xf5, 0x2c,
    0x2d, 0x9a, 0x77, 0xd8, 0x61, 0x51, 0x97, 0xe0, 0x98, 0xf8, 0x22, 0xbd, 0x5d, 0xfa, 0xdb, 0x59,
    0x97, 0x75, 0xcd, 0xae, 0x9c, 0x39, 0x60, 0x95, 0x2a, 0x1e, 0xc7, 0xac, 0xd4, 0x76, 0x3e, 0x01,
    0x2b, 0xa7, 0xff, 0x66
};
#endif

PyTypeObject *init_KLed(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX].type;

    Shiboken::AutoDecRef Sbk_KLed_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KLed_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KLed",
        "KLed*",
        &Sbk_KLed_spec,
        &Shiboken::callCppDestructor< KLed >,
        Sbk_KLed_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KLed_Type; // references _Sbk_KLed_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KLed_SignatureStrings);
#else
    InitSignatureBytes(pyType, KLed_SignatureBytes, KLed_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KLed_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KLed_PythonToCpp_KLed_PTR,
        is_KLed_PythonToCpp_KLed_PTR_Convertible,
        KLed_PTR_CppToPython_KLed);

    Shiboken::Conversions::registerConverterName(converter, "KLed");
    Shiboken::Conversions::registerConverterName(converter, "KLed*");
    Shiboken::Conversions::registerConverterName(converter, "KLed&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KLed).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KLedWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KLed_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KLed_TypeF(), &Sbk_KLedSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KLed_TypeF(), &Sbk_KLed_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KLed_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'State'.
    const char *State_Initializer[] = {
        "Off",
        "On",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t State_InitializerValues[] = {
        uint8_t(KLed::State::Off), //  0x00  0
        uint8_t(KLed::State::On)   //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KLed_TypeF(),
        "1:KWidgetsAddons.KLed.State",
        State_Initializer, State_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KLed_State_IDX].type = EType;
    // Register converter for enum 'KLed::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KLed_State_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KLed_State,
            is_Enum_PythonToCpp_KLed_State_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KLed::State");
        Shiboken::Conversions::registerConverterAlias(converter, "State");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'State' enum.

    // Initialization of enum 'Shape'.
    const char *Shape_Initializer[] = {
        "Rectangular",
        "Circular",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Shape_InitializerValues[] = {
        uint8_t(KLed::Shape::Rectangular), //  0x00  0
        uint8_t(KLed::Shape::Circular)     //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KLed_TypeF(),
        "1:KWidgetsAddons.KLed.Shape",
        Shape_Initializer, Shape_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KLed_Shape_IDX].type = EType;
    // Register converter for enum 'KLed::Shape'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KLed_Shape_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KLed_Shape,
            is_Enum_PythonToCpp_KLed_Shape_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KLed::Shape");
        Shiboken::Conversions::registerConverterAlias(converter, "Shape");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Shape' enum.

    // Initialization of enum 'Look'.
    const char *Look_Initializer[] = {
        "Flat",
        "Raised",
        "Sunken",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Look_InitializerValues[] = {
        uint8_t(KLed::Look::Flat),   //  0x00  0
        uint8_t(KLed::Look::Raised), //  0x01  1
        uint8_t(KLed::Look::Sunken)  //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KLed_TypeF(),
        "1:KWidgetsAddons.KLed.Look",
        Look_Initializer, Look_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KLed_Look_IDX].type = EType;
    // Register converter for enum 'KLed::Look'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KLed_Look_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KLed_Look,
            is_Enum_PythonToCpp_KLed_Look_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KLed::Look");
        Shiboken::Conversions::registerConverterAlias(converter, "Look");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Look' enum.

    qRegisterMetaType< ::KLed::State >("KLed::State");
    qRegisterMetaType< ::KLed::Shape >("KLed::Shape");
    qRegisterMetaType< ::KLed::Look >("KLed::Look");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KLed::staticMetaObject, sizeof(KLedWrapper));

    return pyType;
}
