/* message.c generated by valac 0.56.18, the Vala compiler
 * generated from message.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2025 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <ibus.h>
#include <string.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkwayland.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MESSAGE_DIALOG (message_dialog_get_type ())
#define MESSAGE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MESSAGE_DIALOG, MessageDialog))
#define MESSAGE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MESSAGE_DIALOG, MessageDialogClass))
#define IS_MESSAGE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MESSAGE_DIALOG))
#define IS_MESSAGE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MESSAGE_DIALOG))
#define MESSAGE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MESSAGE_DIALOG, MessageDialogClass))

typedef struct _MessageDialog MessageDialog;
typedef struct _MessageDialogClass MessageDialogClass;
typedef struct _MessageDialogPrivate MessageDialogPrivate;
enum  {
	MESSAGE_DIALOG_0_PROPERTY,
	MESSAGE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* message_dialog_properties[MESSAGE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	MESSAGE_DIALOG_CLOSE_SIGNAL,
	MESSAGE_DIALOG_REALIZE_SURFACE_SIGNAL,
	MESSAGE_DIALOG_NUM_SIGNALS
};
static guint message_dialog_signals[MESSAGE_DIALOG_NUM_SIGNALS] = {0};

struct _MessageDialog {
	GtkBox parent_instance;
	MessageDialogPrivate * priv;
};

struct _MessageDialogClass {
	GtkBoxClass parent_class;
};

struct _MessageDialogPrivate {
	GtkWindow* m_toplevel;
	GtkBox* m_vbox;
	GtkBox* m_hbox;
	GtkLabel* m_title_label;
	GtkLabel* m_description_label;
	GtkProgressBar* m_progress_bar;
	GtkLabel* m_progress_label;
	GtkLabel* m_timeout_label;
	GtkButton* m_button;
	gint m_timeout_time;
	gint m_elapsed_time;
	guint m_timeout_id;
	GdkRectangle m_cursor_location;
	gboolean m_is_wayland;
	gboolean m_no_wayland_panel;
	gboolean m_hide_after_show;
};

static gint MessageDialog_private_offset;
static gpointer message_dialog_parent_class = NULL;

VALA_EXTERN GType message_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MessageDialog, g_object_unref)
VALA_EXTERN MessageDialog* message_dialog_new (gboolean is_wayland,
                                   gboolean no_wayland_panel,
                                   IBusMessage* message);
VALA_EXTERN MessageDialog* message_dialog_construct (GType object_type,
                                         gboolean is_wayland,
                                         gboolean no_wayland_panel,
                                         IBusMessage* message);
static void __lambda68_ (MessageDialog* self,
                  GtkWidget* w,
                  GtkAllocation* a);
static void message_dialog_adjust_window_position (MessageDialog* self,
                                            GtkWidget* window);
static void ___lambda68__gtk_widget_size_allocate (GtkWidget* _sender,
                                            GtkAllocation* allocation,
                                            gpointer self);
static void ___lambda69_ (MessageDialog* self,
                   GtkWidget* w);
static void message_dialog_realize_window (MessageDialog* self,
                                    gboolean initial);
static void ____lambda69__gtk_widget_realize (GtkWidget* _sender,
                                       gpointer self);
static void ___lambda70_ (MessageDialog* self,
                   GtkWidget* w);
static void ____lambda70__gtk_widget_show (GtkWidget* _sender,
                                    gpointer self);
static void ___lambda71_ (MessageDialog* self,
                   GtkWidget* w);
static void ____lambda71__gtk_widget_hide (GtkWidget* _sender,
                                    gpointer self);
static void message_dialog_create_ui (MessageDialog* self,
                               IBusMessage* message);
VALA_EXTERN void message_dialog_set_cursor_location (MessageDialog* self,
                                         gint x,
                                         gint y,
                                         gint width,
                                         gint height);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static void __lambda72_ (MessageDialog* self,
                  GtkButton* w);
static void ___lambda72__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean ___lambda73_ (MessageDialog* self);
static gboolean ____lambda73__gsource_func (gpointer self);
VALA_EXTERN void message_dialog_update_message (MessageDialog* self,
                                    IBusMessage* message);
VALA_EXTERN void message_dialog_show (MessageDialog* self);
VALA_EXTERN void message_dialog_hide (MessageDialog* self);
static void message_dialog_move (MessageDialog* self,
                          gint x,
                          gint y);
static void message_dialog_adjust_window_position_horizontal (MessageDialog* self,
                                                       GtkWidget* window);
static void message_dialog_get_monitor_geometry (MessageDialog* self,
                                          GtkWidget* window,
                                          GdkRectangle* result);
static void message_dialog_finalize (GObject * obj);
static GType message_dialog_get_type_once (void);

static inline gpointer
message_dialog_get_instance_private (MessageDialog* self)
{
	return G_STRUCT_MEMBER_P (self, MessageDialog_private_offset);
}

static void
__lambda68_ (MessageDialog* self,
             GtkWidget* w,
             GtkAllocation* a)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (a != NULL);
	message_dialog_adjust_window_position (self, w);
}

static void
___lambda68__gtk_widget_size_allocate (GtkWidget* _sender,
                                       GtkAllocation* allocation,
                                       gpointer self)
{
	__lambda68_ ((MessageDialog*) self, _sender, allocation);
}

static void
___lambda69_ (MessageDialog* self,
              GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	message_dialog_realize_window (self, TRUE);
}

static void
____lambda69__gtk_widget_realize (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda69_ ((MessageDialog*) self, _sender);
}

static void
___lambda70_ (MessageDialog* self,
              GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	if (self->priv->m_hide_after_show) {
		message_dialog_realize_window (self, FALSE);
	}
	self->priv->m_hide_after_show = FALSE;
}

static void
____lambda70__gtk_widget_show (GtkWidget* _sender,
                               gpointer self)
{
	___lambda70_ ((MessageDialog*) self, _sender);
}

static void
___lambda71_ (MessageDialog* self,
              GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	self->priv->m_hide_after_show = TRUE;
}

static void
____lambda71__gtk_widget_hide (GtkWidget* _sender,
                               gpointer self)
{
	___lambda71_ ((MessageDialog*) self, _sender);
}

MessageDialog*
message_dialog_construct (GType object_type,
                          gboolean is_wayland,
                          gboolean no_wayland_panel,
                          IBusMessage* message)
{
	MessageDialog * self = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkWindow* _tmp9_;
	g_return_val_if_fail (message != NULL, NULL);
	self = (MessageDialog*) g_object_new (object_type, "name", "IBusMessageDialog", "orientation", GTK_ORIENTATION_HORIZONTAL, "visible", TRUE, NULL);
	self->priv->m_is_wayland = is_wayland;
	self->priv->m_no_wayland_panel = no_wayland_panel;
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_toplevel);
	self->priv->m_toplevel = _tmp0_;
	_tmp1_ = self->priv->m_toplevel;
	gtk_widget_add_events ((GtkWidget*) _tmp1_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp2_ = self->priv->m_toplevel;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "size-allocate", (GCallback) ___lambda68__gtk_widget_size_allocate, self, 0);
	if (self->priv->m_is_wayland) {
		GtkWindow* _tmp3_;
		GtkWindow* _tmp4_;
		GtkWindow* _tmp5_;
		_tmp3_ = self->priv->m_toplevel;
		g_signal_connect_object ((GtkWidget*) _tmp3_, "realize", (GCallback) ____lambda69__gtk_widget_realize, self, 0);
		_tmp4_ = self->priv->m_toplevel;
		g_signal_connect_object ((GtkWidget*) _tmp4_, "show", (GCallback) ____lambda70__gtk_widget_show, self, 0);
		_tmp5_ = self->priv->m_toplevel;
		g_signal_connect_object ((GtkWidget*) _tmp5_, "hide", (GCallback) ____lambda71__gtk_widget_hide, self, 0);
	}
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->m_vbox);
	self->priv->m_vbox = _tmp6_;
	_tmp7_ = self->priv->m_vbox;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->m_vbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
	_tmp9_ = self->priv->m_toplevel;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) self);
	message_dialog_create_ui (self, message);
	return self;
}

MessageDialog*
message_dialog_new (gboolean is_wayland,
                    gboolean no_wayland_panel,
                    IBusMessage* message)
{
	return message_dialog_construct (TYPE_MESSAGE_DIALOG, is_wayland, no_wayland_panel, message);
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

void
message_dialog_set_cursor_location (MessageDialog* self,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height)
{
	GdkRectangle location = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	g_return_if_fail (self != NULL);
	memset (&_tmp0_, 0, sizeof (GdkRectangle));
	_tmp0_.x = x;
	_tmp0_.y = y;
	_tmp0_.width = width;
	_tmp0_.height = height;
	location = _tmp0_;
	_tmp1_ = self->priv->m_cursor_location;
	_tmp2_ = location;
	if (_cairo_rectangle_int_equal (&_tmp1_, &_tmp2_) == TRUE) {
		return;
	}
	_tmp3_ = location;
	self->priv->m_cursor_location = _tmp3_;
}

static void
__lambda72_ (MessageDialog* self,
             GtkButton* w)
{
	g_return_if_fail (w != NULL);
	if (self->priv->m_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->m_timeout_id);
		self->priv->m_timeout_id = (guint) 0;
	}
	g_signal_emit (self, message_dialog_signals[MESSAGE_DIALOG_CLOSE_SIGNAL], 0);
}

static void
___lambda72__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda72_ ((MessageDialog*) self, _sender);
}

static gboolean
___lambda73_ (MessageDialog* self)
{
	GtkLabel* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean result;
	if (self->priv->m_elapsed_time >= self->priv->m_timeout_time) {
		g_signal_emit (self, message_dialog_signals[MESSAGE_DIALOG_CLOSE_SIGNAL], 0);
		self->priv->m_timeout_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp0_ = self->priv->m_timeout_label;
	_tmp1_ = self->priv->m_timeout_time;
	_tmp2_ = self->priv->m_elapsed_time;
	self->priv->m_elapsed_time = _tmp2_ + 1;
	_tmp3_ = g_strdup_printf (_ ("%5dSec"), _tmp1_ - _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_text (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
____lambda73__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda73_ ((MessageDialog*) self);
	return result;
}

static void
message_dialog_create_ui (MessageDialog* self,
                          IBusMessage* message)
{
	gchar* title = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* description = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	const gchar* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkBox* _tmp25_;
	GtkBox* _tmp26_;
	GtkBox* _tmp27_;
	GtkProgressBar* _tmp28_;
	GtkProgressBar* _tmp29_;
	GtkProgressBar* _tmp30_;
	GtkProgressBar* _tmp31_;
	GtkLabel* _tmp32_;
	gint progress = 0;
	gdouble progress_f = 0.0;
	gboolean _tmp33_ = FALSE;
	GtkLabel* _tmp47_;
	GtkLabel* _tmp48_;
	GtkLabel* _tmp49_;
	GtkLabel* _tmp50_;
	GtkLabel* _tmp51_;
	gboolean _tmp52_ = FALSE;
	GtkButton* _tmp59_;
	GtkButton* _tmp60_;
	GtkButton* _tmp61_;
	GtkBox* _tmp62_;
	GtkLabel* _tmp63_;
	GtkBox* _tmp64_;
	GtkLabel* _tmp65_;
	GtkBox* _tmp66_;
	GtkBox* _tmp67_;
	GtkBox* _tmp68_;
	GtkProgressBar* _tmp69_;
	GtkBox* _tmp70_;
	GtkLabel* _tmp71_;
	GtkBox* _tmp72_;
	GtkLabel* _tmp73_;
	GtkBox* _tmp74_;
	GtkButton* _tmp75_;
	GtkWindow* _tmp76_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = ibus_message_get_title (message);
	_tmp1_ = g_strdup (_tmp0_);
	title = _tmp1_;
	_tmp2_ = ibus_message_get_description (message);
	_tmp3_ = g_strdup (_tmp2_);
	description = _tmp3_;
	_tmp4_ = title;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		const gchar* _tmp7_;
		GtkLabel* _tmp8_;
		_tmp7_ = title;
		_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
		g_object_ref_sink (_tmp8_);
		_g_object_unref0 (self->priv->m_title_label);
		self->priv->m_title_label = _tmp8_;
	} else {
		GtkLabel* _tmp9_;
		GtkLabel* _tmp10_;
		_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
		g_object_ref_sink (_tmp9_);
		_g_object_unref0 (self->priv->m_title_label);
		self->priv->m_title_label = _tmp9_;
		_tmp10_ = self->priv->m_title_label;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp10_, TRUE);
	}
	_tmp11_ = self->priv->m_title_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
	_tmp12_ = self->priv->m_title_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_CENTER);
	_tmp13_ = self->priv->m_title_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp13_, 8);
	_tmp14_ = self->priv->m_title_label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp14_, 8);
	_tmp15_ = self->priv->m_title_label;
	gtk_label_set_line_wrap (_tmp15_, TRUE);
	_tmp16_ = self->priv->m_title_label;
	gtk_label_set_width_chars (_tmp16_, 50);
	_tmp17_ = description;
	_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->m_description_label);
	self->priv->m_description_label = _tmp18_;
	_tmp19_ = self->priv->m_description_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
	_tmp20_ = self->priv->m_description_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_CENTER);
	_tmp21_ = self->priv->m_description_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp21_, 8);
	_tmp22_ = self->priv->m_description_label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp22_, 8);
	_tmp23_ = self->priv->m_description_label;
	gtk_label_set_line_wrap (_tmp23_, TRUE);
	_tmp24_ = self->priv->m_description_label;
	gtk_label_set_width_chars (_tmp24_, 50);
	_tmp25_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->m_hbox);
	self->priv->m_hbox = _tmp25_;
	_tmp26_ = self->priv->m_hbox;
	gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
	_tmp27_ = self->priv->m_hbox;
	gtk_widget_set_valign ((GtkWidget*) _tmp27_, GTK_ALIGN_CENTER);
	_tmp28_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->m_progress_bar);
	self->priv->m_progress_bar = _tmp28_;
	_tmp29_ = self->priv->m_progress_bar;
	gtk_progress_bar_set_ellipsize (_tmp29_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp30_ = self->priv->m_progress_bar;
	gtk_widget_set_halign ((GtkWidget*) _tmp30_, GTK_ALIGN_CENTER);
	_tmp31_ = self->priv->m_progress_bar;
	gtk_widget_set_valign ((GtkWidget*) _tmp31_, GTK_ALIGN_CENTER);
	_tmp32_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->m_progress_label);
	self->priv->m_progress_label = _tmp32_;
	progress = ibus_message_get_progress (message);
	progress_f = progress / 100.0;
	if (progress_f <= 1.0) {
		_tmp33_ = progress >= 0;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		GtkProgressBar* _tmp34_;
		GtkProgressBar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GtkLabel* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp34_ = self->priv->m_progress_bar;
		gtk_progress_bar_set_fraction (_tmp34_, progress_f);
		_tmp35_ = self->priv->m_progress_bar;
		_tmp36_ = g_strdup_printf ("%2u%%\n", (guint) progress);
		_tmp37_ = _tmp36_;
		gtk_progress_bar_set_text (_tmp35_, _tmp37_);
		_g_free0 (_tmp37_);
		_tmp38_ = self->priv->m_progress_label;
		_tmp39_ = g_strdup_printf ("%2u%%\n", (guint) progress);
		_tmp40_ = _tmp39_;
		gtk_label_set_text (_tmp38_, _tmp40_);
		_g_free0 (_tmp40_);
	} else {
		GtkBox* _tmp41_;
		if (progress_f > 1.0) {
			g_warning ("message.vala:150: Progress should be below 100.");
		}
		_tmp41_ = self->priv->m_hbox;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp41_, TRUE);
	}
	self->priv->m_timeout_time = ibus_message_get_timeout (message);
	if (self->priv->m_timeout_time >= 0) {
		gchar* _tmp42_;
		gchar* _tmp43_;
		GtkLabel* _tmp44_;
		_tmp42_ = g_strdup_printf (_ ("%5dSec"), self->priv->m_timeout_time);
		_tmp43_ = _tmp42_;
		_tmp44_ = (GtkLabel*) gtk_label_new (_tmp43_);
		g_object_ref_sink (_tmp44_);
		_g_object_unref0 (self->priv->m_timeout_label);
		self->priv->m_timeout_label = _tmp44_;
		_g_free0 (_tmp43_);
	} else {
		GtkLabel* _tmp45_;
		GtkLabel* _tmp46_;
		_tmp45_ = (GtkLabel*) gtk_label_new (NULL);
		g_object_ref_sink (_tmp45_);
		_g_object_unref0 (self->priv->m_timeout_label);
		self->priv->m_timeout_label = _tmp45_;
		_tmp46_ = self->priv->m_timeout_label;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp46_, TRUE);
	}
	_tmp47_ = self->priv->m_timeout_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp47_, 20, -1);
	_tmp48_ = self->priv->m_timeout_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp48_, GTK_ALIGN_CENTER);
	_tmp49_ = self->priv->m_timeout_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp49_, GTK_ALIGN_CENTER);
	_tmp50_ = self->priv->m_timeout_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp50_, 8);
	_tmp51_ = self->priv->m_timeout_label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp51_, 8);
	if (ibus_message_get_serial (message) > ((guint) 0)) {
		_tmp52_ = self->priv->m_timeout_time >= 0;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		GtkButton* _tmp53_;
		GtkButton* _tmp54_;
		_tmp53_ = (GtkButton*) gtk_button_new ();
		g_object_ref_sink (_tmp53_);
		_g_object_unref0 (self->priv->m_button);
		self->priv->m_button = _tmp53_;
		_tmp54_ = self->priv->m_button;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp54_, TRUE);
	} else {
		GtkButton* _tmp55_;
		GtkButton* _tmp56_;
		GtkStyleContext* _tmp57_;
		GtkButton* _tmp58_;
		_tmp55_ = (GtkButton*) gtk_button_new_with_label (_ ("Close"));
		g_object_ref_sink (_tmp55_);
		_g_object_unref0 (self->priv->m_button);
		self->priv->m_button = _tmp55_;
		_tmp56_ = self->priv->m_button;
		_tmp57_ = gtk_widget_get_style_context ((GtkWidget*) _tmp56_);
		gtk_style_context_add_class (_tmp57_, "text-button");
		_tmp58_ = self->priv->m_button;
		gtk_widget_set_can_default ((GtkWidget*) _tmp58_, TRUE);
	}
	_tmp59_ = self->priv->m_button;
	gtk_button_set_use_underline (_tmp59_, TRUE);
	_tmp60_ = self->priv->m_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp60_, GTK_ALIGN_BASELINE);
	_tmp61_ = self->priv->m_button;
	g_signal_connect_object (_tmp61_, "clicked", (GCallback) ___lambda72__gtk_button_clicked, self, 0);
	if (self->priv->m_timeout_time >= 0) {
		self->priv->m_elapsed_time = 1;
		self->priv->m_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda73__gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp62_ = self->priv->m_vbox;
	_tmp63_ = self->priv->m_title_label;
	gtk_box_pack_start (_tmp62_, (GtkWidget*) _tmp63_, FALSE, FALSE, (guint) 4);
	_tmp64_ = self->priv->m_vbox;
	_tmp65_ = self->priv->m_description_label;
	gtk_box_pack_start (_tmp64_, (GtkWidget*) _tmp65_, FALSE, FALSE, (guint) 4);
	_tmp66_ = self->priv->m_vbox;
	_tmp67_ = self->priv->m_hbox;
	gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = self->priv->m_hbox;
	_tmp69_ = self->priv->m_progress_bar;
	gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = self->priv->m_hbox;
	_tmp71_ = self->priv->m_progress_label;
	gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp71_);
	_tmp72_ = self->priv->m_vbox;
	_tmp73_ = self->priv->m_timeout_label;
	gtk_box_pack_start (_tmp72_, (GtkWidget*) _tmp73_, FALSE, FALSE, (guint) 4);
	_tmp74_ = self->priv->m_vbox;
	_tmp75_ = self->priv->m_button;
	gtk_box_pack_start (_tmp74_, (GtkWidget*) _tmp75_, FALSE, FALSE, (guint) 0);
	_tmp76_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp76_, 1, 1);
	_g_free0 (description);
	_g_free0 (title);
}

void
message_dialog_update_message (MessageDialog* self,
                               IBusMessage* message)
{
	gchar* title = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* description = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkLabel* _tmp11_;
	const gchar* _tmp12_;
	gint progress = 0;
	gdouble progress_f = 0.0;
	gboolean _tmp18_ = FALSE;
	GtkWindow* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = ibus_message_get_title (message);
	_tmp1_ = g_strdup (_tmp0_);
	title = _tmp1_;
	_tmp2_ = ibus_message_get_description (message);
	_tmp3_ = g_strdup (_tmp2_);
	description = _tmp3_;
	_tmp4_ = title;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		GtkLabel* _tmp7_;
		const gchar* _tmp8_;
		GtkLabel* _tmp9_;
		_tmp7_ = self->priv->m_title_label;
		_tmp8_ = title;
		gtk_label_set_text (_tmp7_, _tmp8_);
		_tmp9_ = self->priv->m_title_label;
		gtk_widget_show ((GtkWidget*) _tmp9_);
	} else {
		GtkLabel* _tmp10_;
		_tmp10_ = self->priv->m_title_label;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
	}
	_tmp11_ = self->priv->m_description_label;
	_tmp12_ = description;
	gtk_label_set_text (_tmp11_, _tmp12_);
	self->priv->m_timeout_time = ibus_message_get_timeout (message);
	if (self->priv->m_timeout_time >= 0) {
		GtkLabel* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GtkLabel* _tmp16_;
		_tmp13_ = self->priv->m_timeout_label;
		_tmp14_ = g_strdup_printf (_ ("%5dSec"), self->priv->m_timeout_time);
		_tmp15_ = _tmp14_;
		gtk_label_set_text (_tmp13_, _tmp15_);
		_g_free0 (_tmp15_);
		_tmp16_ = self->priv->m_timeout_label;
		gtk_widget_show ((GtkWidget*) _tmp16_);
		self->priv->m_elapsed_time = 1;
	} else {
		GtkLabel* _tmp17_;
		_tmp17_ = self->priv->m_timeout_label;
		gtk_widget_hide ((GtkWidget*) _tmp17_);
	}
	progress = ibus_message_get_progress (message);
	progress_f = progress / 100.0;
	if (progress_f <= 1.0) {
		_tmp18_ = progress >= 0;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GtkProgressBar* _tmp19_;
		GtkProgressBar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GtkLabel* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		GtkBox* _tmp26_;
		_tmp19_ = self->priv->m_progress_bar;
		gtk_progress_bar_set_fraction (_tmp19_, progress_f);
		_tmp20_ = self->priv->m_progress_bar;
		_tmp21_ = g_strdup_printf ("%2u%%\n", (guint) progress);
		_tmp22_ = _tmp21_;
		gtk_progress_bar_set_text (_tmp20_, _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = self->priv->m_progress_label;
		_tmp24_ = g_strdup_printf ("%2u%%\n", (guint) progress);
		_tmp25_ = _tmp24_;
		gtk_label_set_text (_tmp23_, _tmp25_);
		_g_free0 (_tmp25_);
		_tmp26_ = self->priv->m_hbox;
		gtk_widget_show ((GtkWidget*) _tmp26_);
	} else {
		GtkBox* _tmp27_;
		if (progress_f > 1.0) {
			g_warning ("message.vala:242: Progress should be below 100.");
		}
		_tmp27_ = self->priv->m_hbox;
		gtk_widget_hide ((GtkWidget*) _tmp27_);
	}
	_tmp28_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp28_, 1, 1);
	message_dialog_show (self);
	_g_free0 (description);
	_g_free0 (title);
}

void
message_dialog_show (MessageDialog* self)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
}

void
message_dialog_hide (MessageDialog* self)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->m_is_wayland) {
		g_signal_emit (self, message_dialog_signals[MESSAGE_DIALOG_REALIZE_SURFACE_SIGNAL], 0, NULL);
	}
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

/**
     * move:
     * @x: left position of the #MessageDialog
     * @y: top position of the #MessageDialog
     */
static void
message_dialog_move (MessageDialog* self,
                     gint x,
                     gint y)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_window_move (_tmp0_, x, y);
}

static void
message_dialog_adjust_window_position (MessageDialog* self,
                                       GtkWidget* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	message_dialog_adjust_window_position_horizontal (self, window);
}

/**
     * adjust_window_position_horizontal:
     * @window: A Gtk.Widget of the toplevel window.
     *
     * Horizontal writing mode but not the horizontal lookup table
     * when the allocation is emmitted.
     */
static void
message_dialog_adjust_window_position_horizontal (MessageDialog* self,
                                                  GtkWidget* window)
{
	GdkPoint cursor_left_bottom = {0};
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkPoint _tmp3_ = {0};
	GtkAllocation allocation = {0};
	GtkWindow* _tmp4_;
	GtkAllocation _tmp5_ = {0};
	GdkPoint window_right_bottom = {0};
	GdkPoint _tmp6_;
	GtkAllocation _tmp7_;
	GdkPoint _tmp8_;
	GtkAllocation _tmp9_;
	GdkPoint _tmp10_ = {0};
	GdkRectangle monitor_area = {0};
	GdkRectangle _tmp11_ = {0};
	gint monitor_right = 0;
	GdkRectangle _tmp12_;
	GdkRectangle _tmp13_;
	gint monitor_bottom = 0;
	GdkRectangle _tmp14_;
	GdkRectangle _tmp15_;
	gint x = 0;
	gint y = 0;
	GdkPoint _tmp16_;
	GdkPoint _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->m_cursor_location;
	_tmp1_ = self->priv->m_cursor_location;
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_.x = _tmp0_.x;
	_tmp3_.y = _tmp1_.y + _tmp2_.height;
	cursor_left_bottom = _tmp3_;
	_tmp4_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp4_, &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = cursor_left_bottom;
	_tmp7_ = allocation;
	_tmp8_ = cursor_left_bottom;
	_tmp9_ = allocation;
	_tmp10_.x = _tmp6_.x + _tmp7_.width;
	_tmp10_.y = _tmp8_.y + _tmp9_.height;
	window_right_bottom = _tmp10_;
	message_dialog_get_monitor_geometry (self, window, &_tmp11_);
	monitor_area = _tmp11_;
	_tmp12_ = monitor_area;
	_tmp13_ = monitor_area;
	monitor_right = _tmp12_.x + _tmp13_.width;
	_tmp14_ = monitor_area;
	_tmp15_ = monitor_area;
	monitor_bottom = _tmp14_.y + _tmp15_.height;
	_tmp16_ = window_right_bottom;
	if (_tmp16_.x > monitor_right) {
		GtkAllocation _tmp17_;
		_tmp17_ = allocation;
		x = monitor_right - _tmp17_.width;
	} else {
		GdkPoint _tmp18_;
		_tmp18_ = cursor_left_bottom;
		x = _tmp18_.x;
	}
	if (x < 0) {
		x = 0;
	}
	_tmp19_ = window_right_bottom;
	if (_tmp19_.y > monitor_bottom) {
		GdkRectangle _tmp20_;
		GtkAllocation _tmp21_;
		_tmp20_ = self->priv->m_cursor_location;
		_tmp21_ = allocation;
		y = _tmp20_.y - _tmp21_.height;
	} else {
		GdkPoint _tmp22_;
		_tmp22_ = cursor_left_bottom;
		y = _tmp22_.y;
	}
	if (y < 0) {
		y = 0;
	}
	message_dialog_move (self, x, y);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
message_dialog_get_monitor_geometry (MessageDialog* self,
                                     GtkWidget* window,
                                     GdkRectangle* result)
{
	GdkRectangle monitor_area = {0};
	GdkRectangle _tmp0_ = {0};
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkMonitor* _tmp4_;
	GdkMonitor* _tmp5_;
	GdkRectangle _tmp6_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_.x = 0;
	monitor_area = _tmp0_;
	_tmp1_ = gtk_widget_get_display (window);
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = self->priv->m_cursor_location;
	_tmp4_ = gdk_display_get_monitor_at_point (_tmp1_, _tmp2_.x, _tmp3_.y);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	monitor = _tmp5_;
	gdk_monitor_get_geometry (monitor, &_tmp6_);
	monitor_area = _tmp6_;
	*result = monitor_area;
	_g_object_unref0 (monitor);
	return;
}

static void
message_dialog_realize_window (MessageDialog* self,
                               gboolean initial)
{
	GdkWindow* window = NULL;
	GtkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	GType instance_type = 0UL;
	GdkWindow* _tmp4_;
	GType wayland_type = 0UL;
	void* surface = NULL;
	GdkWindow* _tmp6_;
	void* _tmp7_;
	void* _tmp8_;
	g_return_if_fail (self != NULL);
	if (self->priv->m_no_wayland_panel) {
		return;
	}
	_tmp0_ = self->priv->m_toplevel;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	window = _tmp2_;
	_tmp3_ = window;
	if (!gdk_window_ensure_native (_tmp3_)) {
		g_warning ("message.vala:338: No native window.");
		_g_object_unref0 (window);
		return;
	}
	_tmp4_ = window;
	instance_type = G_TYPE_FROM_INSTANCE ((GObject*) _tmp4_);
	wayland_type = gdk_wayland_window_get_type ();
	if (!g_type_is_a (instance_type, wayland_type)) {
		g_warning ("message.vala:344: Not GdkWindowWayland.");
		_g_object_unref0 (window);
		return;
	}
	if (initial) {
		GdkWindow* _tmp5_;
		_tmp5_ = window;
		gdk_wayland_window_set_use_custom_surface (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_wayland_window_get_type (), GdkWaylandWindow));
	}
	_tmp6_ = window;
	_tmp7_ = gdk_wayland_window_get_wl_surface (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gdk_wayland_window_get_type (), GdkWaylandWindow));
	surface = _tmp7_;
	_tmp8_ = surface;
	g_signal_emit (self, message_dialog_signals[MESSAGE_DIALOG_REALIZE_SURFACE_SIGNAL], 0, _tmp8_);
	_g_object_unref0 (window);
}

static void
message_dialog_class_init (MessageDialogClass * klass,
                           gpointer klass_data)
{
	message_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MessageDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = message_dialog_finalize;
	message_dialog_signals[MESSAGE_DIALOG_CLOSE_SIGNAL] = g_signal_new ("close", TYPE_MESSAGE_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	message_dialog_signals[MESSAGE_DIALOG_REALIZE_SURFACE_SIGNAL] = g_signal_new ("realize-surface", TYPE_MESSAGE_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}

static void
message_dialog_instance_init (MessageDialog * self,
                              gpointer klass)
{
	self->priv = message_dialog_get_instance_private (self);
}

static void
message_dialog_finalize (GObject * obj)
{
	MessageDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MESSAGE_DIALOG, MessageDialog);
	_g_object_unref0 (self->priv->m_toplevel);
	_g_object_unref0 (self->priv->m_vbox);
	_g_object_unref0 (self->priv->m_hbox);
	_g_object_unref0 (self->priv->m_title_label);
	_g_object_unref0 (self->priv->m_description_label);
	_g_object_unref0 (self->priv->m_progress_bar);
	_g_object_unref0 (self->priv->m_progress_label);
	_g_object_unref0 (self->priv->m_timeout_label);
	_g_object_unref0 (self->priv->m_button);
	G_OBJECT_CLASS (message_dialog_parent_class)->finalize (obj);
}

static GType
message_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MessageDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) message_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MessageDialog), 0, (GInstanceInitFunc) message_dialog_instance_init, NULL };
	GType message_dialog_type_id;
	message_dialog_type_id = g_type_register_static (gtk_box_get_type (), "MessageDialog", &g_define_type_info, 0);
	MessageDialog_private_offset = g_type_add_instance_private (message_dialog_type_id, sizeof (MessageDialogPrivate));
	return message_dialog_type_id;
}

GType
message_dialog_get_type (void)
{
	static volatile gsize message_dialog_type_id__once = 0;
	if (g_once_init_enter (&message_dialog_type_id__once)) {
		GType message_dialog_type_id;
		message_dialog_type_id = message_dialog_get_type_once ();
		g_once_init_leave (&message_dialog_type_id__once, message_dialog_type_id);
	}
	return message_dialog_type_id__once;
}

