/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_async_decoder = R"doc(Creates the decoder block for use in GNU Radio flowgraphs from a given FEC API object derived from the generic_decoder class.

Decodes frames received as async messages over a message port. This decoder deployment expects messages of soft decision symbols in and can produce either packed, PDU messages ( = True) or messages full of unpacked bits ( = False).


This decoder works off a full message as one frame or block to decode. The message length is used to calculate the frame length. To support this, the decoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that after being decoded.


The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are packed. All inputs messages are one soft decision per item. By default, the  mode is set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream decoders. That is, putting the same data into both the tagged stream decoder deployment and this with the default setting should produce the same data.


Because the block handles data as a full frame per message, this decoder deployment cannot work with any decoders that require history. For example, the gr::fec::code::cc_decoder decoder in streaming mode requires an extra rate*(K-1) bits to complete the decoding, so it would have to wait for the next message to come in and finish processing. Therefore, the streaming mode of the CC decoder is not allowed. The other three modes will work with this deployment since the frame is self-contained for decoding.

Constructor Specific Documentation:

Build the PDU-based FEC decoder block from an FECAPI decoder object.

Args:
    my_decoder : An FECAPI decoder object child of the generic_decoder class.
    packed : Sets output to packed bytes if true; otherwise, 1 bit per byte.
    rev_pack : If packing bits, should they be reversed?
    mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.)doc";


static const char* __doc_gr_fec_async_decoder_async_decoder_0 = R"doc()doc";


static const char* __doc_gr_fec_async_decoder_async_decoder_1 = R"doc()doc";


static const char* __doc_gr_fec_async_decoder_make = R"doc(Creates the decoder block for use in GNU Radio flowgraphs from a given FEC API object derived from the generic_decoder class.

Decodes frames received as async messages over a message port. This decoder deployment expects messages of soft decision symbols in and can produce either packed, PDU messages ( = True) or messages full of unpacked bits ( = False).


This decoder works off a full message as one frame or block to decode. The message length is used to calculate the frame length. To support this, the decoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that after being decoded.


The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are packed. All inputs messages are one soft decision per item. By default, the  mode is set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream decoders. That is, putting the same data into both the tagged stream decoder deployment and this with the default setting should produce the same data.


Because the block handles data as a full frame per message, this decoder deployment cannot work with any decoders that require history. For example, the gr::fec::code::cc_decoder decoder in streaming mode requires an extra rate*(K-1) bits to complete the decoding, so it would have to wait for the next message to come in and finish processing. Therefore, the streaming mode of the CC decoder is not allowed. The other three modes will work with this deployment since the frame is self-contained for decoding.

Constructor Specific Documentation:

Build the PDU-based FEC decoder block from an FECAPI decoder object.

Args:
    my_decoder : An FECAPI decoder object child of the generic_decoder class.
    packed : Sets output to packed bytes if true; otherwise, 1 bit per byte.
    rev_pack : If packing bits, should they be reversed?
    mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.)doc";


static const char* __doc_gr_fec_async_decoder_general_work = R"doc(compute output items from input items

WORK_CALLED_PRODUCE is used where not all outputs produce the same number of items. general_work must call produce() for each output to indicate the number of items actually produced.


WORK_DONE indicates that no more data will be produced by this block.


general_work must call consume or consume_each to indicate how many items were consumed on each input stream.)doc";
