/* geary-folder-path.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from geary-folder-path.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018-2019 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF (geary_folder_path_folder_path_weak_ref_get_type ())
#define GEARY_FOLDER_PATH_FOLDER_PATH_WEAK_REF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF, GearyFolderPathFolderPathWeakRef))
#define GEARY_FOLDER_PATH_FOLDER_PATH_WEAK_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF, GearyFolderPathFolderPathWeakRefClass))
#define GEARY_FOLDER_PATH_IS_FOLDER_PATH_WEAK_REF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF))
#define GEARY_FOLDER_PATH_IS_FOLDER_PATH_WEAK_REF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF))
#define GEARY_FOLDER_PATH_FOLDER_PATH_WEAK_REF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF, GearyFolderPathFolderPathWeakRefClass))

typedef struct _GearyFolderPathFolderPathWeakRef GearyFolderPathFolderPathWeakRef;
typedef struct _GearyFolderPathFolderPathWeakRefClass GearyFolderPathFolderPathWeakRefClass;
enum  {
	GEARY_FOLDER_PATH_0_PROPERTY,
	GEARY_FOLDER_PATH_NAME_PROPERTY,
	GEARY_FOLDER_PATH_LENGTH_PROPERTY,
	GEARY_FOLDER_PATH_CASE_SENSITIVE_PROPERTY,
	GEARY_FOLDER_PATH_IS_ROOT_PROPERTY,
	GEARY_FOLDER_PATH_IS_TOP_LEVEL_PROPERTY,
	GEARY_FOLDER_PATH_PARENT_PROPERTY,
	GEARY_FOLDER_PATH_NUM_PROPERTIES
};
static GParamSpec* geary_folder_path_properties[GEARY_FOLDER_PATH_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _geary_folder_path_folder_path_weak_ref_unref0(var) ((var == NULL) ? NULL : (var = (geary_folder_path_folder_path_weak_ref_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GearyFolderPathFolderPathWeakRefPrivate GearyFolderPathFolderPathWeakRefPrivate;
typedef struct _GearyFolderPathParamSpecFolderPathWeakRef GearyFolderPathParamSpecFolderPathWeakRef;
enum  {
	GEARY_FOLDER_ROOT_0_PROPERTY,
	GEARY_FOLDER_ROOT_LABEL_PROPERTY,
	GEARY_FOLDER_ROOT_DEFAULT_CASE_SENSITIVITY_PROPERTY,
	GEARY_FOLDER_ROOT_NUM_PROPERTIES
};
static GParamSpec* geary_folder_root_properties[GEARY_FOLDER_ROOT_NUM_PROPERTIES];
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _GearyFolderPathPrivate {
	gchar* _name;
	gboolean _case_sensitive;
	GearyFolderPath* _parent;
	gchar** path;
	gint path_length1;
	gint _path_size_;
	GeeMap* children;
	guint* stored_hash;
};

struct _GearyFolderPathFolderPathWeakRef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GearyFolderPathFolderPathWeakRefPrivate * priv;
};

struct _GearyFolderPathFolderPathWeakRefClass {
	GTypeClass parent_class;
	void (*finalize) (GearyFolderPathFolderPathWeakRef *self);
};

struct _GearyFolderPathFolderPathWeakRefPrivate {
	GWeakRef weak_ref;
};

struct _GearyFolderPathParamSpecFolderPathWeakRef {
	GParamSpec parent_instance;
};

struct _GearyFolderRootPrivate {
	gchar* _label;
	gboolean _default_case_sensitivity;
};

static gint GearyFolderPath_private_offset;
static gpointer geary_folder_path_parent_class = NULL;
static gint GearyFolderPathFolderPathWeakRef_private_offset;
static gpointer geary_folder_path_folder_path_weak_ref_parent_class = NULL;
static GeeHashableIface * geary_folder_path_gee_hashable_parent_iface = NULL;
static GeeComparableIface * geary_folder_path_gee_comparable_parent_iface = NULL;
static gint GearyFolderRoot_private_offset;
static gpointer geary_folder_root_parent_class = NULL;

static gpointer geary_folder_path_folder_path_weak_ref_ref (gpointer instance);
static void geary_folder_path_folder_path_weak_ref_unref (gpointer instance);
static GParamSpec* geary_folder_path_param_spec_folder_path_weak_ref (const gchar* name,
                                                               const gchar* nick,
                                                               const gchar* blurb,
                                                               GType object_type,
                                                               GParamFlags flags) G_GNUC_UNUSED ;
static void geary_folder_path_value_set_folder_path_weak_ref (GValue* value,
                                                       gpointer v_object) G_GNUC_UNUSED ;
static void geary_folder_path_value_take_folder_path_weak_ref (GValue* value,
                                                        gpointer v_object) G_GNUC_UNUSED ;
static gpointer geary_folder_path_value_get_folder_path_weak_ref (const GValue* value) G_GNUC_UNUSED ;
static GType geary_folder_path_folder_path_weak_ref_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void geary_folder_path_set_name (GearyFolderPath* self,
                                 const gchar* value);
static void geary_folder_path_set_case_sensitive (GearyFolderPath* self,
                                           gboolean value);
static void geary_folder_path_set_parent (GearyFolderPath* self,
                                   GearyFolderPath* value);
VALA_EXTERN GearyFolderPath* geary_folder_path_new (void);
VALA_EXTERN GearyFolderPath* geary_folder_path_construct (GType object_type);
static GearyFolderPath* geary_folder_path_new_child (GearyFolderPath* parent,
                                              const gchar* name,
                                              gboolean case_sensitive);
static GearyFolderPath* geary_folder_path_construct_child (GType object_type,
                                                    GearyFolderPath* parent,
                                                    const gchar* name,
                                                    gboolean case_sensitive);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static GearyFolderPath* geary_folder_path_real_get_child (GearyFolderPath* self,
                                                   const gchar* name,
                                                   GearyTrillian is_case_sensitive);
static GearyFolderPath* geary_folder_path_folder_path_weak_ref_get (GearyFolderPathFolderPathWeakRef* self);
static GearyFolderPathFolderPathWeakRef* geary_folder_path_folder_path_weak_ref_new (GearyFolderPath* path);
static GearyFolderPathFolderPathWeakRef* geary_folder_path_folder_path_weak_ref_construct (GType object_type,
                                                                                    GearyFolderPath* path);
static gint geary_folder_path_compare_internal (GearyFolderPath* self,
                                         GearyFolderPath* other,
                                         gboolean allow_case_sensitive,
                                         gboolean normalize);
static gint geary_folder_path_real_compare_to (GeeComparable* base,
                                        GearyFolderPath* other);
static guint geary_folder_path_real_hash (GeeHashable* base);
static guint* _uint_dup (guint* self);
static gboolean geary_folder_path_real_equal_to (GeeHashable* base,
                                          GearyFolderPath* other);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (gchar** value,
                         gint value_length1);
static gint geary_folder_path_compare_names (GearyFolderPath* a,
                                      GearyFolderPath* b,
                                      gboolean allow_case_sensitive,
                                      gboolean normalize);
static void geary_folder_path_folder_path_weak_ref_finalize (GearyFolderPathFolderPathWeakRef * obj);
static GType geary_folder_path_folder_path_weak_ref_get_type_once (void);
static void geary_folder_path_finalize (GObject * obj);
static GType geary_folder_path_get_type_once (void);
static void _vala_geary_folder_path_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_geary_folder_path_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void geary_folder_root_set_label (GearyFolderRoot* self,
                                  const gchar* value);
static void geary_folder_root_set_default_case_sensitivity (GearyFolderRoot* self,
                                                     gboolean value);
static gchar* _variant_get1 (GVariant* value);
static void geary_folder_root_finalize (GObject * obj);
static GType geary_folder_root_get_type_once (void);
static void _vala_geary_folder_root_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_geary_folder_root_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_folder_path_get_instance_private (GearyFolderPath* self)
{
	return G_STRUCT_MEMBER_P (self, GearyFolderPath_private_offset);
}

const gchar*
geary_folder_path_get_name (GearyFolderPath* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
geary_folder_path_set_name (GearyFolderPath* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_FOLDER_PATH (self));
	old_value = geary_folder_path_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_folder_path_properties[GEARY_FOLDER_PATH_NAME_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

guint
geary_folder_path_get_length (GearyFolderPath* self)
{
	guint result;
	guint length = 0U;
	GearyFolderPath* parent = NULL;
	GearyFolderPath* _tmp0_;
	GearyFolderPath* _tmp1_;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), 0U);
	length = (guint) 0;
	_tmp0_ = self->priv->_parent;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	parent = _tmp1_;
	while (TRUE) {
		GearyFolderPath* _tmp2_;
		guint _tmp3_;
		GearyFolderPath* _tmp4_;
		GearyFolderPath* _tmp5_;
		GearyFolderPath* _tmp6_;
		_tmp2_ = parent;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = length;
		length = _tmp3_ + 1;
		_tmp4_ = parent;
		_tmp5_ = _tmp4_->priv->_parent;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (parent);
		parent = _tmp6_;
	}
	result = length;
	_g_object_unref0 (parent);
	return result;
}

gboolean
geary_folder_path_get_case_sensitive (GearyFolderPath* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), FALSE);
	result = self->priv->_case_sensitive;
	return result;
}

static void
geary_folder_path_set_case_sensitive (GearyFolderPath* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IS_FOLDER_PATH (self));
	old_value = geary_folder_path_get_case_sensitive (self);
	if (old_value != value) {
		self->priv->_case_sensitive = value;
		g_object_notify_by_pspec ((GObject *) self, geary_folder_path_properties[GEARY_FOLDER_PATH_CASE_SENSITIVE_PROPERTY]);
	}
}

gboolean
geary_folder_path_get_is_root (GearyFolderPath* self)
{
	gboolean result;
	GearyFolderPath* _tmp0_;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), FALSE);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_ == NULL;
	return result;
}

gboolean
geary_folder_path_get_is_top_level (GearyFolderPath* self)
{
	gboolean result;
	GearyFolderPath* parent = NULL;
	GearyFolderPath* _tmp0_;
	GearyFolderPath* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GearyFolderPath* _tmp3_;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), FALSE);
	_tmp0_ = self->priv->_parent;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	parent = _tmp1_;
	_tmp3_ = parent;
	if (_tmp3_ != NULL) {
		GearyFolderPath* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = parent;
		_tmp5_ = geary_folder_path_get_is_root (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_object_unref0 (parent);
	return result;
}

GearyFolderPath*
geary_folder_path_get_parent (GearyFolderPath* self)
{
	GearyFolderPath* result;
	GearyFolderPath* _tmp0_;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

static void
geary_folder_path_set_parent (GearyFolderPath* self,
                              GearyFolderPath* value)
{
	GearyFolderPath* old_value;
	g_return_if_fail (GEARY_IS_FOLDER_PATH (self));
	old_value = geary_folder_path_get_parent (self);
	if (old_value != value) {
		GearyFolderPath* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parent);
		self->priv->_parent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_folder_path_properties[GEARY_FOLDER_PATH_PARENT_PROPERTY]);
	}
}

/** Constructor only for use by {@link FolderRoot}. */
GearyFolderPath*
geary_folder_path_construct (GType object_type)
{
	GearyFolderPath * self = NULL;
	gchar** _tmp0_;
	self = (GearyFolderPath*) geary_base_object_construct (object_type);
	geary_folder_path_set_name (self, "");
	geary_folder_path_set_parent (self, NULL);
	geary_folder_path_set_case_sensitive (self, FALSE);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->path = (_vala_array_free (self->priv->path, self->priv->path_length1, (GDestroyNotify) g_free), NULL);
	self->priv->path = _tmp0_;
	self->priv->path_length1 = 0;
	self->priv->_path_size_ = self->priv->path_length1;
	return self;
}

GearyFolderPath*
geary_folder_path_new (void)
{
	return geary_folder_path_construct (GEARY_TYPE_FOLDER_PATH);
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GearyFolderPath*
geary_folder_path_construct_child (GType object_type,
                                   GearyFolderPath* parent,
                                   const gchar* name,
                                   gboolean case_sensitive)
{
	GearyFolderPath * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (parent), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (GearyFolderPath*) geary_base_object_construct (object_type);
	geary_folder_path_set_parent (self, parent);
	geary_folder_path_set_name (self, name);
	geary_folder_path_set_case_sensitive (self, case_sensitive);
	_tmp0_ = (parent->priv->path != NULL) ? _vala_array_dup2 (parent->priv->path, parent->priv->path_length1) : parent->priv->path;
	_tmp0__length1 = parent->priv->path_length1;
	self->priv->path = (_vala_array_free (self->priv->path, self->priv->path_length1, (GDestroyNotify) g_free), NULL);
	self->priv->path = _tmp0_;
	self->priv->path_length1 = _tmp0__length1;
	self->priv->_path_size_ = self->priv->path_length1;
	_tmp1_ = g_strdup (name);
	_vala_array_add1 (&self->priv->path, &self->priv->path_length1, &self->priv->_path_size_, _tmp1_);
	return self;
}

static GearyFolderPath*
geary_folder_path_new_child (GearyFolderPath* parent,
                             const gchar* name,
                             gboolean case_sensitive)
{
	return geary_folder_path_construct_child (GEARY_TYPE_FOLDER_PATH, parent, name, case_sensitive);
}

/**
     * Returns the {@link FolderRoot} of this path.
     */
GearyFolderRoot*
geary_folder_path_get_root (GearyFolderPath* self)
{
	GearyFolderPath* path = NULL;
	GearyFolderPath* _tmp0_;
	GearyFolderPath* _tmp6_;
	GearyFolderRoot* _tmp7_;
	GearyFolderRoot* result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), NULL);
	_tmp0_ = _g_object_ref0 (self);
	path = _tmp0_;
	while (TRUE) {
		GearyFolderPath* _tmp1_;
		GearyFolderPath* _tmp2_;
		GearyFolderPath* _tmp3_;
		GearyFolderPath* _tmp4_;
		GearyFolderPath* _tmp5_;
		_tmp1_ = path;
		_tmp2_ = _tmp1_->priv->_parent;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = path;
		_tmp4_ = _tmp3_->priv->_parent;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (path);
		path = _tmp5_;
	}
	_tmp6_ = path;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_TYPE_FOLDER_ROOT, GearyFolderRoot));
	result = _tmp7_;
	_g_object_unref0 (path);
	return result;
}

/**
     * Returns an array of the names of non-root elements in the path.
     */
static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
geary_folder_path_as_array (GearyFolderPath* self,
                            gint* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), NULL);
	_tmp0_ = self->priv->path;
	_tmp0__length1 = self->priv->path_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

/**
     * Creates a path that is a child of this folder.
     *
     * Specifying {@link Trillian.TRUE} or {@link Trillian.FALSE} for
     * `is_case_sensitive` forces case-sensitivity either way. If
     * {@link Trillian.UNKNOWN}, then {@link
     * FolderRoot.default_case_sensitivity} is used.
     */
static GearyFolderPath*
geary_folder_path_real_get_child (GearyFolderPath* self,
                                  const gchar* name,
                                  GearyTrillian is_case_sensitive)
{
	GearyFolderPath* child = NULL;
	GearyFolderPathFolderPathWeakRef* child_ref = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GearyFolderPathFolderPathWeakRef* _tmp2_;
	GearyFolderPath* _tmp5_;
	GearyFolderPath* result;
	g_return_val_if_fail (name != NULL, NULL);
	child = NULL;
	_tmp0_ = self->priv->children;
	_tmp1_ = gee_map_get (_tmp0_, name);
	child_ref = (GearyFolderPathFolderPathWeakRef*) _tmp1_;
	_tmp2_ = child_ref;
	if (_tmp2_ != NULL) {
		GearyFolderPathFolderPathWeakRef* _tmp3_;
		GearyFolderPath* _tmp4_;
		_tmp3_ = child_ref;
		_tmp4_ = geary_folder_path_folder_path_weak_ref_get (_tmp3_);
		_g_object_unref0 (child);
		child = _tmp4_;
	}
	_tmp5_ = child;
	if (_tmp5_ == NULL) {
		GearyFolderRoot* _tmp6_;
		GearyFolderRoot* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		GearyFolderPath* _tmp10_;
		GeeMap* _tmp11_;
		GearyFolderPath* _tmp12_;
		GearyFolderPathFolderPathWeakRef* _tmp13_;
		GearyFolderPathFolderPathWeakRef* _tmp14_;
		_tmp6_ = geary_folder_path_get_root (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_folder_root_get_default_case_sensitivity (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = geary_folder_path_new_child (self, name, geary_trillian_to_boolean (is_case_sensitive, _tmp9_));
		_g_object_unref0 (child);
		child = _tmp10_;
		_g_object_unref0 (_tmp7_);
		_tmp11_ = self->priv->children;
		_tmp12_ = child;
		_tmp13_ = geary_folder_path_folder_path_weak_ref_new (_tmp12_);
		_tmp14_ = _tmp13_;
		gee_map_set (_tmp11_, name, _tmp14_);
		_geary_folder_path_folder_path_weak_ref_unref0 (_tmp14_);
	}
	result = child;
	_geary_folder_path_folder_path_weak_ref_unref0 (child_ref);
	return result;
}

GearyFolderPath*
geary_folder_path_get_child (GearyFolderPath* self,
                             const gchar* name,
                             GearyTrillian is_case_sensitive)
{
	GearyFolderPathClass* _klass_;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), NULL);
	_klass_ = GEARY_FOLDER_PATH_GET_CLASS (self);
	if (_klass_->get_child) {
		return _klass_->get_child (self, name, is_case_sensitive);
	}
	return NULL;
}

/**
     * Determines if this path is a strict ancestor of another.
     */
gboolean
geary_folder_path_is_descendant (GearyFolderPath* self,
                                 GearyFolderPath* target)
{
	gboolean is_descendent = FALSE;
	GearyFolderPath* path = NULL;
	GearyFolderPath* _tmp0_;
	GearyFolderPath* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), FALSE);
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (target), FALSE);
	is_descendent = FALSE;
	_tmp0_ = target->priv->_parent;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	path = _tmp1_;
	while (TRUE) {
		GearyFolderPath* _tmp2_;
		GearyFolderPath* _tmp3_;
		GearyFolderPath* _tmp4_;
		GearyFolderPath* _tmp5_;
		GearyFolderPath* _tmp6_;
		_tmp2_ = path;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = path;
		if (gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_HASHABLE, GeeHashable), self)) {
			is_descendent = TRUE;
			break;
		}
		_tmp4_ = path;
		_tmp5_ = _tmp4_->priv->_parent;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (path);
		path = _tmp6_;
	}
	result = is_descendent;
	_g_object_unref0 (path);
	return result;
}

/**
     * Does a Unicode-normalized, case insensitive match.  Useful for
     * getting a rough idea if a folder matches a name, but shouldn't
     * be used to determine strict equality.
     */
gint
geary_folder_path_compare_normalized_ci (GearyFolderPath* self,
                                         GearyFolderPath* other)
{
	gint result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), 0);
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (other), 0);
	result = geary_folder_path_compare_internal (self, other, FALSE, TRUE);
	return result;
}

/**
     * {@inheritDoc}
     *
     * Comparisons for FolderPath is defined as (a) empty paths
     * are less-than non-empty paths and (b) each element is compared
     * to the corresponding path element of the other FolderPath
     * following collation rules for casefolded (case-insensitive)
     * compared, and (c) shorter paths are less-than longer paths,
     * assuming the path elements are equal up to the shorter path's
     * length.
     *
     * Note that {@link FolderPath.case_sensitive} affects comparisons.
     *
     * Returns -1 if this path is lexiographically before the other, 1
     * if its after, and 0 if they are equal.
     */
static gint
geary_folder_path_real_compare_to (GeeComparable* base,
                                   GearyFolderPath* other)
{
	GearyFolderPath * self;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_FOLDER_PATH, GearyFolderPath);
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (other), 0);
	result = geary_folder_path_compare_internal (self, other, TRUE, FALSE);
	return result;
}

/**
     * {@inheritDoc}
     *
     * Note that {@link FolderPath.case_sensitive} affects comparisons.
     */
static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static guint
geary_folder_path_real_hash (GeeHashable* base)
{
	GearyFolderPath * self;
	guint* _tmp0_;
	guint* _tmp21_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_FOLDER_PATH, GearyFolderPath);
	_tmp0_ = self->priv->stored_hash;
	if (_tmp0_ == NULL) {
		guint _tmp1_;
		guint* _tmp2_;
		GearyFolderPath* path = NULL;
		GearyFolderPath* _tmp3_;
		_tmp1_ = (guint) 0;
		_tmp2_ = __uint_dup0 (&_tmp1_);
		_g_free0 (self->priv->stored_hash);
		self->priv->stored_hash = _tmp2_;
		_tmp3_ = _g_object_ref0 (self);
		path = _tmp3_;
		while (TRUE) {
			GearyFolderPath* _tmp4_;
			guint _tmp5_ = 0U;
			gboolean _tmp6_;
			guint* _tmp15_;
			guint _tmp16_;
			guint* _tmp17_;
			GearyFolderPath* _tmp18_;
			GearyFolderPath* _tmp19_;
			GearyFolderPath* _tmp20_;
			_tmp4_ = path;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp6_ = self->priv->_case_sensitive;
			if (_tmp6_) {
				GHashFunc _tmp7_;
				GearyFolderPath* _tmp8_;
				const gchar* _tmp9_;
				_tmp7_ = g_str_hash;
				_tmp8_ = path;
				_tmp9_ = _tmp8_->priv->_name;
				_tmp5_ = _tmp7_ (_tmp9_);
			} else {
				GHashFunc _tmp10_;
				GearyFolderPath* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp10_ = g_str_hash;
				_tmp11_ = path;
				_tmp12_ = _tmp11_->priv->_name;
				_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
				_tmp14_ = _tmp13_;
				_tmp5_ = _tmp10_ (_tmp14_);
				_g_free0 (_tmp14_);
			}
			_tmp15_ = self->priv->stored_hash;
			_tmp16_ = (*_tmp15_) ^ _tmp5_;
			_tmp17_ = __uint_dup0 (&_tmp16_);
			_g_free0 (self->priv->stored_hash);
			self->priv->stored_hash = _tmp17_;
			_tmp18_ = path;
			_tmp19_ = _tmp18_->priv->_parent;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (path);
			path = _tmp20_;
		}
		_g_object_unref0 (path);
	}
	_tmp21_ = self->priv->stored_hash;
	result = *_tmp21_;
	return result;
}

/** {@inheritDoc} */
static gboolean
geary_folder_path_real_equal_to (GeeHashable* base,
                                 GearyFolderPath* other)
{
	GearyFolderPath * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_FOLDER_PATH, GearyFolderPath);
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (other), FALSE);
	result = geary_folder_path_compare_internal (self, other, TRUE, FALSE) == 0;
	return result;
}

/**
     * Returns a representation useful for serialisation.
     *
     * This can be used to transmit folder paths as D-Bus method and
     * GLib Action parameters, and so on.
     *
     * @return a serialised form of this path, that will match the
     * GVariantType specified by {@link VARIANT_TYPE}.
     * @see FolderRoot.from_variant
     */
static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (gchar** value,
               gint value_length1)
{
	gchar** _tmp8_;
	GVariantBuilder _tmp9_;
	gint _tmp10_;
	_tmp8_ = value;
	g_variant_builder_init (&_tmp9_, G_VARIANT_TYPE ("as"));
	for (_tmp10_ = 0; _tmp10_ < value_length1; _tmp10_++) {
		g_variant_builder_add_value (&_tmp9_, g_variant_new_string (*_tmp8_));
		_tmp8_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp9_));
}

GVariant*
geary_folder_path_to_variant (GearyFolderPath* self)
{
	GearyFolderRoot* _tmp0_;
	GearyFolderRoot* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GVariant* _tmp11_;
	GVariant** _tmp12_;
	GVariant** _tmp13_;
	gint _tmp13__length1;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GVariant* result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), NULL);
	_tmp0_ = geary_folder_path_get_root (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_folder_root_get_label (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _variant_new1 (_tmp3_);
	_tmp6_ = geary_folder_path_as_array (self, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp11_ = _variant_new2 (_tmp7_, _tmp5_);
	_tmp12_ = g_new0 (GVariant*, 2 + 1);
	_tmp12_[0] = _tmp4_;
	_tmp12_[1] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 2;
	_tmp14_ = g_variant_new_tuple (_tmp13_, 2);
	g_variant_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_variant_unref), NULL);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_tmp1_);
	result = _tmp15_;
	return result;
}

/**
     * Returns a representation useful for debugging.
     *
     * Do not use this for obtaining an IMAP mailbox name to send to a
     * server, use {@link
     * Geary.Imap.MailboxSpecifier.MailboxSpecifier.from_folder_path}
     * instead. This method is useful for debugging and logging only.
     */
gchar*
geary_folder_path_to_string (GearyFolderPath* self)
{
	static const gchar SEP = '>';
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = geary_folder_path_get_is_root (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = builder;
		g_string_append_c (_tmp3_, SEP);
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = self->priv->path;
		_tmp4__length1 = self->priv->path_length1;
		{
			gchar** name_collection = NULL;
			gint name_collection_length1 = 0;
			gint _name_collection_size_ = 0;
			gint name_it = 0;
			name_collection = _tmp4_;
			name_collection_length1 = _tmp4__length1;
			for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
				gchar* _tmp5_;
				gchar* name = NULL;
				_tmp5_ = g_strdup (name_collection[name_it]);
				name = _tmp5_;
				{
					GString* _tmp6_;
					GString* _tmp7_;
					const gchar* _tmp8_;
					_tmp6_ = builder;
					g_string_append_c (_tmp6_, SEP);
					_tmp7_ = builder;
					_tmp8_ = name;
					g_string_append (_tmp7_, _tmp8_);
					_g_free0 (name);
				}
			}
		}
	}
	_tmp9_ = builder;
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_string_free0 (builder);
	return result;
}

static gint
geary_folder_path_compare_internal (GearyFolderPath* self,
                                    GearyFolderPath* other,
                                    gboolean allow_case_sensitive,
                                    gboolean normalize)
{
	gint a_len = 0;
	guint _tmp0_;
	guint _tmp1_;
	gint b_len = 0;
	guint _tmp2_;
	guint _tmp3_;
	gint result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (self), 0);
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (other), 0);
	if (self == other) {
		result = 0;
		return result;
	}
	_tmp0_ = geary_folder_path_get_length (self);
	_tmp1_ = _tmp0_;
	a_len = (gint) _tmp1_;
	_tmp2_ = geary_folder_path_get_length (other);
	_tmp3_ = _tmp2_;
	b_len = (gint) _tmp3_;
	if (a_len != b_len) {
		result = a_len - b_len;
		return result;
	}
	result = geary_folder_path_compare_names (self, other, allow_case_sensitive, normalize);
	return result;
}

static gint
geary_folder_path_compare_names (GearyFolderPath* a,
                                 GearyFolderPath* b,
                                 gboolean allow_case_sensitive,
                                 gboolean normalize)
{
	gint cmp = 0;
	gboolean _tmp0_ = FALSE;
	GearyFolderPath* _tmp1_;
	gint result;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (a), 0);
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (b), 0);
	cmp = 0;
	_tmp1_ = a->priv->_parent;
	if (_tmp1_ == NULL) {
		GearyFolderPath* _tmp2_;
		_tmp2_ = b->priv->_parent;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GCompareFunc _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = ((GCompareFunc) g_strcmp0);
		_tmp4_ = geary_folder_root_get_label (G_TYPE_CHECK_INSTANCE_CAST (a, GEARY_TYPE_FOLDER_ROOT, GearyFolderRoot));
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_folder_root_get_label (G_TYPE_CHECK_INSTANCE_CAST (b, GEARY_TYPE_FOLDER_ROOT, GearyFolderRoot));
		_tmp7_ = _tmp6_;
		cmp = _tmp3_ (_tmp5_, _tmp7_);
	} else {
		GearyFolderPath* _tmp8_;
		GearyFolderPath* _tmp9_;
		_tmp8_ = a->priv->_parent;
		_tmp9_ = b->priv->_parent;
		cmp = geary_folder_path_compare_names (_tmp8_, _tmp9_, allow_case_sensitive, normalize);
	}
	if (cmp == 0) {
		gchar* a_name = NULL;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* b_name = NULL;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp18_ = FALSE;
		GCompareFunc _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp10_ = a->priv->_name;
		_tmp11_ = g_strdup (_tmp10_);
		a_name = _tmp11_;
		_tmp12_ = b->priv->_name;
		_tmp13_ = g_strdup (_tmp12_);
		b_name = _tmp13_;
		if (normalize) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp14_ = a_name;
			_tmp15_ = g_utf8_normalize (_tmp14_, (gssize) -1, G_NORMALIZE_DEFAULT);
			_g_free0 (a_name);
			a_name = _tmp15_;
			_tmp16_ = b_name;
			_tmp17_ = g_utf8_normalize (_tmp16_, (gssize) -1, G_NORMALIZE_DEFAULT);
			_g_free0 (b_name);
			b_name = _tmp17_;
		}
		if (!allow_case_sensitive) {
			_tmp18_ = TRUE;
		} else {
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_;
			_tmp20_ = a->priv->_case_sensitive;
			if (!_tmp20_) {
				gboolean _tmp21_;
				_tmp21_ = b->priv->_case_sensitive;
				_tmp19_ = !_tmp21_;
			} else {
				_tmp19_ = FALSE;
			}
			_tmp18_ = _tmp19_;
		}
		if (_tmp18_) {
			const gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp22_ = a_name;
			_tmp23_ = g_utf8_casefold (_tmp22_, (gssize) -1);
			_g_free0 (a_name);
			a_name = _tmp23_;
			_tmp24_ = b_name;
			_tmp25_ = g_utf8_casefold (_tmp24_, (gssize) -1);
			_g_free0 (b_name);
			b_name = _tmp25_;
		}
		_tmp26_ = ((GCompareFunc) g_strcmp0);
		_tmp27_ = a_name;
		_tmp28_ = b_name;
		result = _tmp26_ (_tmp27_, _tmp28_);
		_g_free0 (b_name);
		_g_free0 (a_name);
		return result;
	}
	result = cmp;
	return result;
}

static inline gpointer
geary_folder_path_folder_path_weak_ref_get_instance_private (GearyFolderPathFolderPathWeakRef* self)
{
	return G_STRUCT_MEMBER_P (self, GearyFolderPathFolderPathWeakRef_private_offset);
}

static GearyFolderPathFolderPathWeakRef*
geary_folder_path_folder_path_weak_ref_construct (GType object_type,
                                                  GearyFolderPath* path)
{
	GearyFolderPathFolderPathWeakRef* self = NULL;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (path), NULL);
	self = (GearyFolderPathFolderPathWeakRef*) g_type_create_instance (object_type);
	g_weak_ref_clear (&self->priv->weak_ref);
	g_weak_ref_init (&self->priv->weak_ref, G_TYPE_CHECK_INSTANCE_CAST (path, G_TYPE_OBJECT, GObject));
	return self;
}

static GearyFolderPathFolderPathWeakRef*
geary_folder_path_folder_path_weak_ref_new (GearyFolderPath* path)
{
	return geary_folder_path_folder_path_weak_ref_construct (GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF, path);
}

static GearyFolderPath*
geary_folder_path_folder_path_weak_ref_get (GearyFolderPathFolderPathWeakRef* self)
{
	GObject* _tmp0_;
	GearyFolderPath* _tmp1_;
	GearyFolderPath* result;
	g_return_val_if_fail (GEARY_FOLDER_PATH_IS_FOLDER_PATH_WEAK_REF (self), NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->weak_ref);
	_tmp1_ = GEARY_IS_FOLDER_PATH (_tmp0_) ? ((GearyFolderPath*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}

static void
geary_folder_path_value_folder_path_weak_ref_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_folder_path_value_folder_path_weak_ref_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_folder_path_folder_path_weak_ref_unref (value->data[0].v_pointer);
	}
}

static void
geary_folder_path_value_folder_path_weak_ref_copy_value (const GValue* src_value,
                                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_folder_path_folder_path_weak_ref_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_folder_path_value_folder_path_weak_ref_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_folder_path_value_folder_path_weak_ref_collect_value (GValue* value,
                                                            guint n_collect_values,
                                                            GTypeCValue* collect_values,
                                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyFolderPathFolderPathWeakRef * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_folder_path_folder_path_weak_ref_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_folder_path_value_folder_path_weak_ref_lcopy_value (const GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	GearyFolderPathFolderPathWeakRef ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_folder_path_folder_path_weak_ref_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
geary_folder_path_param_spec_folder_path_weak_ref (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags)
{
	GearyFolderPathParamSpecFolderPathWeakRef* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
geary_folder_path_value_get_folder_path_weak_ref (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF), NULL);
	return value->data[0].v_pointer;
}

static void
geary_folder_path_value_set_folder_path_weak_ref (GValue* value,
                                                  gpointer v_object)
{
	GearyFolderPathFolderPathWeakRef * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_folder_path_folder_path_weak_ref_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_folder_path_folder_path_weak_ref_unref (old);
	}
}

static void
geary_folder_path_value_take_folder_path_weak_ref (GValue* value,
                                                   gpointer v_object)
{
	GearyFolderPathFolderPathWeakRef * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_folder_path_folder_path_weak_ref_unref (old);
	}
}

static void
geary_folder_path_folder_path_weak_ref_class_init (GearyFolderPathFolderPathWeakRefClass * klass,
                                                   gpointer klass_data)
{
	geary_folder_path_folder_path_weak_ref_parent_class = g_type_class_peek_parent (klass);
	((GearyFolderPathFolderPathWeakRefClass *) klass)->finalize = geary_folder_path_folder_path_weak_ref_finalize;
	g_type_class_adjust_private_offset (klass, &GearyFolderPathFolderPathWeakRef_private_offset);
}

static void
geary_folder_path_folder_path_weak_ref_instance_init (GearyFolderPathFolderPathWeakRef * self,
                                                      gpointer klass)
{
	self->priv = geary_folder_path_folder_path_weak_ref_get_instance_private (self);
	self->ref_count = 1;
}

static void
geary_folder_path_folder_path_weak_ref_finalize (GearyFolderPathFolderPathWeakRef * obj)
{
	GearyFolderPathFolderPathWeakRef * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF, GearyFolderPathFolderPathWeakRef);
	g_signal_handlers_destroy (self);
	g_weak_ref_clear (&self->priv->weak_ref);
}

 G_GNUC_NO_INLINE static GType
geary_folder_path_folder_path_weak_ref_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_folder_path_value_folder_path_weak_ref_init, geary_folder_path_value_folder_path_weak_ref_free_value, geary_folder_path_value_folder_path_weak_ref_copy_value, geary_folder_path_value_folder_path_weak_ref_peek_pointer, "p", geary_folder_path_value_folder_path_weak_ref_collect_value, "p", geary_folder_path_value_folder_path_weak_ref_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyFolderPathFolderPathWeakRefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_folder_path_folder_path_weak_ref_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyFolderPathFolderPathWeakRef), 0, (GInstanceInitFunc) geary_folder_path_folder_path_weak_ref_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_folder_path_folder_path_weak_ref_type_id;
	geary_folder_path_folder_path_weak_ref_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyFolderPathFolderPathWeakRef", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearyFolderPathFolderPathWeakRef_private_offset = g_type_add_instance_private (geary_folder_path_folder_path_weak_ref_type_id, sizeof (GearyFolderPathFolderPathWeakRefPrivate));
	return geary_folder_path_folder_path_weak_ref_type_id;
}

static GType
geary_folder_path_folder_path_weak_ref_get_type (void)
{
	static gsize geary_folder_path_folder_path_weak_ref_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_path_folder_path_weak_ref_type_id__once)) {
		GType geary_folder_path_folder_path_weak_ref_type_id;
		geary_folder_path_folder_path_weak_ref_type_id = geary_folder_path_folder_path_weak_ref_get_type_once ();
		g_once_init_leave (&geary_folder_path_folder_path_weak_ref_type_id__once, geary_folder_path_folder_path_weak_ref_type_id);
	}
	return geary_folder_path_folder_path_weak_ref_type_id__once;
}

static gpointer
geary_folder_path_folder_path_weak_ref_ref (gpointer instance)
{
	GearyFolderPathFolderPathWeakRef * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
geary_folder_path_folder_path_weak_ref_unref (gpointer instance)
{
	GearyFolderPathFolderPathWeakRef * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_FOLDER_PATH_FOLDER_PATH_WEAK_REF_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
geary_folder_path_class_init (GearyFolderPathClass * klass,
                              gpointer klass_data)
{
	geary_folder_path_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyFolderPath_private_offset);
	((GearyFolderPathClass *) klass)->get_child = (GearyFolderPath* (*) (GearyFolderPath*, const gchar*, GearyTrillian)) geary_folder_path_real_get_child;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_folder_path_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_folder_path_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_folder_path_finalize;
	/** The base name of this folder, excluding parents. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_PATH_NAME_PROPERTY, geary_folder_path_properties[GEARY_FOLDER_PATH_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The number of children under the root in this path. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_PATH_LENGTH_PROPERTY, geary_folder_path_properties[GEARY_FOLDER_PATH_LENGTH_PROPERTY] = g_param_spec_uint ("length", "length", "length", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Whether this path is lexiographically case-sensitive.
	     *
	     * This has implications, as {@link FolderPath} is Comparable and Hashable.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_PATH_CASE_SENSITIVE_PROPERTY, geary_folder_path_properties[GEARY_FOLDER_PATH_CASE_SENSITIVE_PROPERTY] = g_param_spec_boolean ("case-sensitive", "case-sensitive", "case-sensitive", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if this path is a root folder path. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_PATH_IS_ROOT_PROPERTY, geary_folder_path_properties[GEARY_FOLDER_PATH_IS_ROOT_PROPERTY] = g_param_spec_boolean ("is-root", "is-root", "is-root", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if this path is a child of the root folder. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_PATH_IS_TOP_LEVEL_PROPERTY, geary_folder_path_properties[GEARY_FOLDER_PATH_IS_TOP_LEVEL_PROPERTY] = g_param_spec_boolean ("is-top-level", "is-top-level", "is-top-level", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the parent of this path. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_PATH_PARENT_PROPERTY, geary_folder_path_properties[GEARY_FOLDER_PATH_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", GEARY_TYPE_FOLDER_PATH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_folder_path_gee_hashable_interface_init (GeeHashableIface * iface,
                                               gpointer iface_data)
{
	geary_folder_path_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->hash = (guint (*) (GeeHashable*)) geary_folder_path_real_hash;
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_folder_path_real_equal_to;
}

static void
geary_folder_path_gee_comparable_interface_init (GeeComparableIface * iface,
                                                 gpointer iface_data)
{
	geary_folder_path_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*) (GeeComparable*, gconstpointer)) geary_folder_path_real_compare_to;
}

static void
geary_folder_path_instance_init (GearyFolderPath * self,
                                 gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = geary_folder_path_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEARY_FOLDER_PATH_TYPE_FOLDER_PATH_WEAK_REF, (GBoxedCopyFunc) geary_folder_path_folder_path_weak_ref_ref, (GDestroyNotify) geary_folder_path_folder_path_weak_ref_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->children = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	self->priv->stored_hash = NULL;
}

static void
geary_folder_path_finalize (GObject * obj)
{
	GearyFolderPath * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_FOLDER_PATH, GearyFolderPath);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_parent);
	self->priv->path = (_vala_array_free (self->priv->path, self->priv->path_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->children);
	_g_free0 (self->priv->stored_hash);
	G_OBJECT_CLASS (geary_folder_path_parent_class)->finalize (obj);
}

/**
 * A generic structure for representing and maintaining folder paths.
 *
 * A FolderPath may have one parent and one child.  A FolderPath without a parent is called a
 * root folder can be be created with {@link FolderRoot}, which is a FolderPath.
 *
 * @see FolderRoot
 */
 G_GNUC_NO_INLINE static GType
geary_folder_path_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyFolderPathClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_folder_path_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyFolderPath), 0, (GInstanceInitFunc) geary_folder_path_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_folder_path_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) geary_folder_path_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_folder_path_type_id;
	geary_folder_path_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyFolderPath", &g_define_type_info, 0);
	g_type_add_interface_static (geary_folder_path_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	g_type_add_interface_static (geary_folder_path_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
	GearyFolderPath_private_offset = g_type_add_instance_private (geary_folder_path_type_id, sizeof (GearyFolderPathPrivate));
	return geary_folder_path_type_id;
}

GType
geary_folder_path_get_type (void)
{
	static gsize geary_folder_path_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_path_type_id__once)) {
		GType geary_folder_path_type_id;
		geary_folder_path_type_id = geary_folder_path_get_type_once ();
		g_once_init_leave (&geary_folder_path_type_id__once, geary_folder_path_type_id);
	}
	return geary_folder_path_type_id__once;
}

static void
_vala_geary_folder_path_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GearyFolderPath * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_FOLDER_PATH, GearyFolderPath);
	switch (property_id) {
		case GEARY_FOLDER_PATH_NAME_PROPERTY:
		g_value_set_string (value, geary_folder_path_get_name (self));
		break;
		case GEARY_FOLDER_PATH_LENGTH_PROPERTY:
		g_value_set_uint (value, geary_folder_path_get_length (self));
		break;
		case GEARY_FOLDER_PATH_CASE_SENSITIVE_PROPERTY:
		g_value_set_boolean (value, geary_folder_path_get_case_sensitive (self));
		break;
		case GEARY_FOLDER_PATH_IS_ROOT_PROPERTY:
		g_value_set_boolean (value, geary_folder_path_get_is_root (self));
		break;
		case GEARY_FOLDER_PATH_IS_TOP_LEVEL_PROPERTY:
		g_value_set_boolean (value, geary_folder_path_get_is_top_level (self));
		break;
		case GEARY_FOLDER_PATH_PARENT_PROPERTY:
		g_value_set_object (value, geary_folder_path_get_parent (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_folder_path_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GearyFolderPath * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_FOLDER_PATH, GearyFolderPath);
	switch (property_id) {
		case GEARY_FOLDER_PATH_NAME_PROPERTY:
		geary_folder_path_set_name (self, g_value_get_string (value));
		break;
		case GEARY_FOLDER_PATH_CASE_SENSITIVE_PROPERTY:
		geary_folder_path_set_case_sensitive (self, g_value_get_boolean (value));
		break;
		case GEARY_FOLDER_PATH_PARENT_PROPERTY:
		geary_folder_path_set_parent (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_folder_root_get_instance_private (GearyFolderRoot* self)
{
	return G_STRUCT_MEMBER_P (self, GearyFolderRoot_private_offset);
}

const gchar*
geary_folder_root_get_label (GearyFolderRoot* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_FOLDER_ROOT (self), NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
geary_folder_root_set_label (GearyFolderRoot* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_FOLDER_ROOT (self));
	old_value = geary_folder_root_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_folder_root_properties[GEARY_FOLDER_ROOT_LABEL_PROPERTY]);
	}
}

gboolean
geary_folder_root_get_default_case_sensitivity (GearyFolderRoot* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_FOLDER_ROOT (self), FALSE);
	result = self->priv->_default_case_sensitivity;
	return result;
}

static void
geary_folder_root_set_default_case_sensitivity (GearyFolderRoot* self,
                                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IS_FOLDER_ROOT (self));
	old_value = geary_folder_root_get_default_case_sensitivity (self);
	if (old_value != value) {
		self->priv->_default_case_sensitivity = value;
		g_object_notify_by_pspec ((GObject *) self, geary_folder_root_properties[GEARY_FOLDER_ROOT_DEFAULT_CASE_SENSITIVITY_PROPERTY]);
	}
}

/**
     * Constructs a new folder root with given default sensitivity.
     */
GearyFolderRoot*
geary_folder_root_construct (GType object_type,
                             const gchar* label,
                             gboolean default_case_sensitivity)
{
	GearyFolderRoot * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (GearyFolderRoot*) geary_folder_path_construct (object_type);
	geary_folder_root_set_label (self, label);
	geary_folder_root_set_default_case_sensitivity (self, default_case_sensitivity);
	return self;
}

GearyFolderRoot*
geary_folder_root_new (const gchar* label,
                       gboolean default_case_sensitivity)
{
	return geary_folder_root_construct (GEARY_TYPE_FOLDER_ROOT, label, default_case_sensitivity);
}

/**
     * Copies a folder path using this as the root.
     *
     * This method can be used to simply copy a path, or change the
     * root that a path is attached to.
     */
GearyFolderPath*
geary_folder_root_copy (GearyFolderRoot* self,
                        GearyFolderPath* original)
{
	GearyFolderPath* copy = NULL;
	GearyFolderPath* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	GearyFolderPath* result;
	g_return_val_if_fail (GEARY_IS_FOLDER_ROOT (self), NULL);
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (original), NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER_PATH, GearyFolderPath));
	copy = _tmp0_;
	_tmp2_ = geary_folder_path_as_array (original, &_tmp1_);
	{
		gchar** step_collection = NULL;
		gint step_collection_length1 = 0;
		gint _step_collection_size_ = 0;
		gint step_it = 0;
		step_collection = _tmp2_;
		step_collection_length1 = _tmp1_;
		for (step_it = 0; step_it < step_collection_length1; step_it = step_it + 1) {
			gchar* _tmp3_;
			gchar* step = NULL;
			_tmp3_ = g_strdup (step_collection[step_it]);
			step = _tmp3_;
			{
				GearyFolderPath* _tmp4_;
				const gchar* _tmp5_;
				GearyFolderPath* _tmp6_;
				_tmp4_ = copy;
				_tmp5_ = step;
				_tmp6_ = geary_folder_path_get_child (_tmp4_, _tmp5_, GEARY_TRILLIAN_UNKNOWN);
				_g_object_unref0 (copy);
				copy = _tmp6_;
				_g_free0 (step);
			}
		}
		step_collection = (_vala_array_free (step_collection, step_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = copy;
	return result;
}

/**
     * Reconstructs a path under this root from a GLib variant.
     *
     * @see FolderPath.to_variant
     * @throws EngineError.BAD_PARAMETERS when the variant is not the
     * have the correct type or if the given root label does not match
     * this root's label.
     */
static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

GearyFolderPath*
geary_folder_root_from_variant (GearyFolderRoot* self,
                                GVariant* serialised,
                                GError** error)
{
	const gchar* _tmp0_;
	gchar* label = NULL;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GearyFolderPath* path = NULL;
	GearyFolderPath* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	gsize _tmp14_ = 0;
	const gchar** _tmp15_;
	const gchar** _tmp16_;
	gint _tmp16__length1;
	GError* _inner_error0_ = NULL;
	GearyFolderPath* result;
	g_return_val_if_fail (GEARY_IS_FOLDER_ROOT (self), NULL);
	g_return_val_if_fail (serialised != NULL, NULL);
	_tmp0_ = g_variant_get_type_string (serialised);
	if (g_strcmp0 (_tmp0_, GEARY_FOLDER_PATH_VARIANT_TYPE) != 0) {
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp1_ = g_variant_get_type_string (serialised);
		_tmp2_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_BAD_PARAMETERS, "Invalid serialised id type: %s", _tmp1_);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = g_variant_get_child_value (serialised, (gsize) 0);
	_tmp4_ = _tmp3_;
	_tmp5_ = _variant_get1 (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_variant_unref0 (_tmp4_);
	label = _tmp6_;
	_tmp7_ = self->priv->_label;
	_tmp8_ = label;
	if (g_strcmp0 (_tmp7_, _tmp8_) != 0) {
		const gchar* _tmp9_;
		GError* _tmp10_;
		_tmp9_ = label;
		_tmp10_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_BAD_PARAMETERS, "Invalid serialised folder root label: %s", _tmp9_);
		_inner_error0_ = _tmp10_;
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (label);
			return NULL;
		} else {
			_g_free0 (label);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER_PATH, GearyFolderPath));
	path = _tmp11_;
	_tmp12_ = g_variant_get_child_value (serialised, (gsize) 1);
	_tmp13_ = _tmp12_;
	_tmp15_ = g_variant_get_strv (_tmp13_, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	_g_variant_unref0 (_tmp13_);
	{
		const gchar** step_collection = NULL;
		gint step_collection_length1 = 0;
		gint _step_collection_size_ = 0;
		gint step_it = 0;
		step_collection = _tmp16_;
		step_collection_length1 = _tmp16__length1;
		for (step_it = 0; step_it < step_collection_length1; step_it = step_it + 1) {
			gchar* _tmp17_;
			gchar* step = NULL;
			_tmp17_ = g_strdup (step_collection[step_it]);
			step = _tmp17_;
			{
				GearyFolderPath* _tmp18_;
				const gchar* _tmp19_;
				GearyFolderPath* _tmp20_;
				_tmp18_ = path;
				_tmp19_ = step;
				_tmp20_ = geary_folder_path_get_child (_tmp18_, _tmp19_, GEARY_TRILLIAN_UNKNOWN);
				_g_object_unref0 (path);
				path = _tmp20_;
				_g_free0 (step);
			}
		}
		step_collection = (g_free (step_collection), NULL);
	}
	result = path;
	_g_free0 (label);
	return result;
}

static void
geary_folder_root_class_init (GearyFolderRootClass * klass,
                              gpointer klass_data)
{
	geary_folder_root_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyFolderRoot_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_folder_root_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_folder_root_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_folder_root_finalize;
	/**
	     * A label for a folder root.
	     *
	     * Since there may be multiple folder roots (for example, local
	     * and remote folders, or for different remote namespaces), the
	     * label can be used to look up a specific root.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_ROOT_LABEL_PROPERTY, geary_folder_root_properties[GEARY_FOLDER_ROOT_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The default case sensitivity of descendant folders.
	     *
	     * @see FolderPath.get_child
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_FOLDER_ROOT_DEFAULT_CASE_SENSITIVITY_PROPERTY, geary_folder_root_properties[GEARY_FOLDER_ROOT_DEFAULT_CASE_SENSITIVITY_PROPERTY] = g_param_spec_boolean ("default-case-sensitivity", "default-case-sensitivity", "default-case-sensitivity", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_folder_root_instance_init (GearyFolderRoot * self,
                                 gpointer klass)
{
	self->priv = geary_folder_root_get_instance_private (self);
}

static void
geary_folder_root_finalize (GObject * obj)
{
	GearyFolderRoot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_FOLDER_ROOT, GearyFolderRoot);
	_g_free0 (self->priv->_label);
	G_OBJECT_CLASS (geary_folder_root_parent_class)->finalize (obj);
}

/**
 * The root of a folder hierarchy.
 *
 * A {@link FolderPath} can only be created by starting with a
 * FolderRoot and adding children via {@link FolderPath.get_child}.
 * Because all FolderPaths hold references to their parents, this
 * element can be retrieved with {@link FolderPath.get_root}.
 */
 G_GNUC_NO_INLINE static GType
geary_folder_root_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyFolderRootClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_folder_root_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyFolderRoot), 0, (GInstanceInitFunc) geary_folder_root_instance_init, NULL };
	GType geary_folder_root_type_id;
	geary_folder_root_type_id = g_type_register_static (GEARY_TYPE_FOLDER_PATH, "GearyFolderRoot", &g_define_type_info, 0);
	GearyFolderRoot_private_offset = g_type_add_instance_private (geary_folder_root_type_id, sizeof (GearyFolderRootPrivate));
	return geary_folder_root_type_id;
}

GType
geary_folder_root_get_type (void)
{
	static gsize geary_folder_root_type_id__once = 0;
	if (g_once_init_enter (&geary_folder_root_type_id__once)) {
		GType geary_folder_root_type_id;
		geary_folder_root_type_id = geary_folder_root_get_type_once ();
		g_once_init_leave (&geary_folder_root_type_id__once, geary_folder_root_type_id);
	}
	return geary_folder_root_type_id__once;
}

static void
_vala_geary_folder_root_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GearyFolderRoot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_FOLDER_ROOT, GearyFolderRoot);
	switch (property_id) {
		case GEARY_FOLDER_ROOT_LABEL_PROPERTY:
		g_value_set_string (value, geary_folder_root_get_label (self));
		break;
		case GEARY_FOLDER_ROOT_DEFAULT_CASE_SENSITIVITY_PROPERTY:
		g_value_set_boolean (value, geary_folder_root_get_default_case_sensitivity (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_folder_root_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GearyFolderRoot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_FOLDER_ROOT, GearyFolderRoot);
	switch (property_id) {
		case GEARY_FOLDER_ROOT_LABEL_PROPERTY:
		geary_folder_root_set_label (self, g_value_get_string (value));
		break;
		case GEARY_FOLDER_ROOT_DEFAULT_CASE_SENSITIVITY_PROPERTY:
		geary_folder_root_set_default_case_sensitivity (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

