
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "sqlqueryjob_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_SqlQueryJob_Type = nullptr;
static PyTypeObject *Sbk_SqlQueryJob_TypeF(void)
{
    return _Sbk_SqlQueryJob_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void SqlQueryJobWrapper::pysideInitQtMetaTypes()
{
}

void SqlQueryJobWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

SqlQueryJobWrapper::SqlQueryJobWrapper(::QObject * parent) : SqlQueryJob(parent)
{
}

SqlQueryJobWrapper::SqlQueryJobWrapper(const ::QString & query, ::QObject * parent) : SqlQueryJob(query, parent)
{
}

void SqlQueryJobWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlQueryJob_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("SqlQueryJob", funcName, gil, pyOverride, event);
}

void SqlQueryJobWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlQueryJob_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SqlQueryJob", funcName, gil, pyOverride, signal);
}

void SqlQueryJobWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlQueryJob_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("SqlQueryJob", funcName, gil, pyOverride, event);
}

void SqlQueryJobWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlQueryJob_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SqlQueryJob", funcName, gil, pyOverride, signal);
}

bool SqlQueryJobWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlQueryJob_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("SqlQueryJob", funcName, gil, pyOverride, event);
}

bool SqlQueryJobWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlQueryJob_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("SqlQueryJob", funcName, gil, pyOverride, watched, event);
}

void SqlQueryJobWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SqlQueryJob_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("SqlQueryJob", funcName, gil, pyOverride, event);
}

const QMetaObject *SqlQueryJobWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return SqlQueryJob::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int SqlQueryJobWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = SqlQueryJob::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *SqlQueryJobWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< SqlQueryJobWrapper *>(this));
    }
    return SqlQueryJob::qt_metacast(_clname);
}

SqlQueryJobWrapper::~SqlQueryJobWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_SqlQueryJob_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SqlQueryJob_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SqlQueryJob >()))
        return -1;

    SqlQueryJobWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:SqlQueryJob", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: SqlQueryJob::SqlQueryJob(QObject*=)
    // 1: SqlQueryJob::SqlQueryJob(QString,QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // SqlQueryJob(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // SqlQueryJob(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // SqlQueryJob(QString,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            overloadId = 1; // SqlQueryJob(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // SqlQueryJob(QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // SqlQueryJob(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) SqlQueryJobWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new SqlQueryJobWrapper(cppArg0);
                }

                // Ownership transferences (constructor heuristics).
                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // SqlQueryJob(const QString &query, QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // SqlQueryJob(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) SqlQueryJobWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new SqlQueryJobWrapper(cppArg0, cppArg1);
                }

                // Ownership transferences (constructor heuristics).
                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< SqlQueryJob >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]);
    };


    return 1;
}

static PyObject *Sbk_SqlQueryJobFunc_addBindValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqlQueryJobWrapper *>(reinterpret_cast< ::SqlQueryJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SqlQueryJob::addBindValue(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArg)))) {
        overloadId = 0; // addBindValue(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addBindValue", errInfo, SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]);

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addBindValue(QVariant)
            cppSelf->addBindValue(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SqlQueryJobFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqlQueryJobWrapper *>(reinterpret_cast< ::SqlQueryJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // error()const
        QSqlError cppResult = const_cast<const SqlQueryJobWrapper *>(cppSelf)->error();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtSqlTypeStructs[SBK_QSqlError_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SqlQueryJobFunc_lastInsertId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqlQueryJobWrapper *>(reinterpret_cast< ::SqlQueryJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // lastInsertId()const
        QVariant cppResult = const_cast<const SqlQueryJobWrapper *>(cppSelf)->lastInsertId();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SqlQueryJobFunc_numRowsAffected(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqlQueryJobWrapper *>(reinterpret_cast< ::SqlQueryJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // numRowsAffected()const
        int cppResult = const_cast<const SqlQueryJobWrapper *>(cppSelf)->numRowsAffected();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SqlQueryJobFunc_records(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqlQueryJobWrapper *>(reinterpret_cast< ::SqlQueryJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // records()const
        QList<QSqlRecord> cppResult = const_cast<const SqlQueryJobWrapper *>(cppSelf)->records();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QSqlRecord_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SqlQueryJobFunc_setQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqlQueryJobWrapper *>(reinterpret_cast< ::SqlQueryJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SqlQueryJob::setQuery(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setQuery(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setQuery", errInfo, SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setQuery(QString)
            cppSelf->setQuery(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_SqlQueryJobFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SqlQueryJobWrapper *>(reinterpret_cast< ::SqlQueryJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // start()
        cppSelf->start();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_SqlQueryJob_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SqlQueryJob_methods[] = {
    {"addBindValue", reinterpret_cast<PyCFunction>(Sbk_SqlQueryJobFunc_addBindValue), METH_O, nullptr},
    {"error", reinterpret_cast<PyCFunction>(Sbk_SqlQueryJobFunc_error), METH_NOARGS, nullptr},
    {"lastInsertId", reinterpret_cast<PyCFunction>(Sbk_SqlQueryJobFunc_lastInsertId), METH_NOARGS, nullptr},
    {"numRowsAffected", reinterpret_cast<PyCFunction>(Sbk_SqlQueryJobFunc_numRowsAffected), METH_NOARGS, nullptr},
    {"records", reinterpret_cast<PyCFunction>(Sbk_SqlQueryJobFunc_records), METH_NOARGS, nullptr},
    {"setQuery", reinterpret_cast<PyCFunction>(Sbk_SqlQueryJobFunc_setQuery), METH_O, nullptr},
    {"start", reinterpret_cast<PyCFunction>(Sbk_SqlQueryJobFunc_start), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_SqlQueryJob_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::SqlQueryJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<SqlQueryJobWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_SqlQueryJob_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_SqlQueryJob_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_SqlQueryJob_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_SqlQueryJob_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SqlQueryJob_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SqlQueryJob_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SqlQueryJob_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SqlQueryJob_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_SqlQueryJob_spec = {
    "1:PyFalkon.SqlQueryJob",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_SqlQueryJob_slots
};

} //extern "C"

static void *Sbk_SqlQueryJob_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::SqlQueryJob *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void SqlQueryJob_PythonToCpp_SqlQueryJob_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_SqlQueryJob_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_SqlQueryJob_PythonToCpp_SqlQueryJob_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_SqlQueryJob_TypeF()))
        return SqlQueryJob_PythonToCpp_SqlQueryJob_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *SqlQueryJob_PTR_CppToPython_SqlQueryJob(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::SqlQueryJob *>(const_cast<void *>(cppIn)), Sbk_SqlQueryJob_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *SqlQueryJob_SignatureStrings[] = {
    "1:PyFalkon.SqlQueryJob(self,parent:PySide6.QtCore.QObject=nullptr)",
    "0:PyFalkon.SqlQueryJob(self,query:QString,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.SqlQueryJob.addBindValue(self,value:QVariant)",
    "PyFalkon.SqlQueryJob.error(self)->PySide6.QtSql.QSqlError",
    "PyFalkon.SqlQueryJob.lastInsertId(self)->QVariant",
    "PyFalkon.SqlQueryJob.numRowsAffected(self)->int",
    "PyFalkon.SqlQueryJob.records(self)->QList[PySide6.QtSql.QSqlRecord]",
    "PyFalkon.SqlQueryJob.setQuery(self,query:QString)",
    "PyFalkon.SqlQueryJob.start(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t SqlQueryJob_SignatureByteSize = 209;
static constexpr uint8_t SqlQueryJob_SignatureBytes[209] = {
    0x78, 0xda, 0x8d, 0x90, 0x41, 0x0b, 0xc2, 0x30, 0x0c, 0x85, 0xef, 0xfe, 0x12, 0x07, 0x5a, 0xf4,
    0xe2, 0x61, 0xa0, 0xa0, 0xa2, 0x30, 0x11, 0xb4, 0x1b, 0x78, 0x11, 0x0f, 0xd5, 0x66, 0x52, 0xad,
    0xad, 0xa6, 0x99, 0xe2, 0xbf, 0x77, 0x9b, 0x6c, 0x1e, 0xec, 0xc4, 0x4b, 0x48, 0xe8, 0x7b, 0xdf,
    0x4b, 0xd3, 0x0f, 0xd7, 0xcf, 0xb9, 0xd0, 0x67, 0x6b, 0x58, 0x72, 0xd3, 0x3c, 0x03, 0x7c, 0x2e,
    0xec, 0xbe, 0xed, 0x40, 0xa7, 0x9d, 0xab, 0x40, 0x30, 0x94, 0x0b, 0x12, 0x25, 0x61, 0xc0, 0x38,
    0x4d, 0x2d, 0x02, 0xe3, 0xab, 0xfd, 0x09, 0x0e, 0x34, 0x34, 0x99, 0xd6, 0x57, 0xc2, 0xa0, 0xd5,
    0xfb, 0x81, 0xb8, 0x15, 0x53, 0xc8, 0x13, 0x42, 0x65, 0x8e, 0xff, 0x02, 0x7d, 0x38, 0x26, 0xa4,
    0x9c, 0x28, 0x23, 0x37, 0x42, 0x67, 0xf0, 0x66, 0xdf, 0x8b, 0x36, 0xe4, 0x1b, 0x81, 0x4a, 0x18,
    0x6a, 0xb0, 0x01, 0xa2, 0xc5, 0x52, 0x1f, 0x74, 0x47, 0x9f, 0xe0, 0x5c, 0xc2, 0x78, 0x5e, 0x66,
    0xc5, 0xb3, 0xdf, 0xa9, 0x85, 0xa3, 0xc8, 0x38, 0x40, 0x8a, 0x64, 0x05, 0xa8, 0xc2, 0xfc, 0x0e,
    0x93, 0x5d, 0x62, 0xfb, 0x70, 0xe3, 0x34, 0xcd, 0xbf, 0x03, 0xb5, 0x49, 0x35, 0xe9, 0x11, 0x0e,
    0x16, 0xa5, 0xab, 0xe1, 0x4b, 0xe5, 0x68, 0xfb, 0xbd, 0x63, 0x5c, 0xca, 0x76, 0x7e, 0x86, 0x03,
    0x2a, 0x7b, 0xcf, 0xb9, 0x1b, 0x2e, 0xe2, 0x48, 0x20, 0xbd, 0x33, 0x5b, 0x2f, 0xca, 0xfe, 0xba,
    0x32
};
#endif

PyTypeObject *init_SqlQueryJob(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX].type;

    Shiboken::AutoDecRef Sbk_SqlQueryJob_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_SqlQueryJob_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "SqlQueryJob",
        "SqlQueryJob*",
        &Sbk_SqlQueryJob_spec,
        &Shiboken::callCppDestructor< SqlQueryJob >,
        Sbk_SqlQueryJob_Type_bases.object(),
        0);
    auto *pyType = _Sbk_SqlQueryJob_Type; // references _Sbk_SqlQueryJob_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, SqlQueryJob_SignatureStrings);
#else
    InitSignatureBytes(pyType, SqlQueryJob_SignatureBytes, SqlQueryJob_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_SqlQueryJob_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_SqlQueryJob_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        SqlQueryJob_PythonToCpp_SqlQueryJob_PTR,
        is_SqlQueryJob_PythonToCpp_SqlQueryJob_PTR_Convertible,
        SqlQueryJob_PTR_CppToPython_SqlQueryJob);

    Shiboken::Conversions::registerConverterName(converter, "SqlQueryJob");
    Shiboken::Conversions::registerConverterName(converter, "SqlQueryJob*");
    Shiboken::Conversions::registerConverterName(converter, "SqlQueryJob&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SqlQueryJob).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(SqlQueryJobWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_SqlQueryJob_TypeF(), &Sbk_SqlQueryJob_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::SqlQueryJob::staticMetaObject);
    SqlQueryJobWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::SqlQueryJob::staticMetaObject, sizeof(SqlQueryJobWrapper));

    return pyType;
}
