// Generated by pmgen.py from techlibs/xilinx/xilinx_dsp48a.pmg

struct xilinx_dsp48a_pm {
  Module *module;
  SigMap sigmap;
  std::function<void()> on_accept;
  bool setup_done;
  bool generate_mode;
  int accept_cnt;

  uint32_t rngseed;
  int rng(unsigned int n) {
    rngseed ^= rngseed << 13;
    rngseed ^= rngseed >> 17;
    rngseed ^= rngseed << 5;
    return rngseed % n;
  }

  typedef std::tuple<> index_0_key_type;
  typedef std::tuple<Cell*> index_0_value_type;
  dict<index_0_key_type, vector<index_0_value_type>> index_0;
  typedef std::tuple<SigSpec> index_3_key_type;
  typedef std::tuple<Cell*> index_3_value_type;
  dict<index_3_key_type, vector<index_3_value_type>> index_3;
  typedef std::tuple<SigBit> index_9_key_type;
  typedef std::tuple<Cell*, IdString> index_9_value_type;
  dict<index_9_key_type, vector<index_9_value_type>> index_9;
  typedef std::tuple<SigSpec, SigSpec> index_12_key_type;
  typedef std::tuple<Cell*, IdString> index_12_value_type;
  dict<index_12_key_type, vector<index_12_value_type>> index_12;
  typedef std::tuple<SigBit> index_17_key_type;
  typedef std::tuple<Cell*, int> index_17_value_type;
  dict<index_17_key_type, vector<index_17_value_type>> index_17;
  typedef std::tuple<SigBit> index_21_key_type;
  typedef std::tuple<Cell*, int> index_21_value_type;
  dict<index_21_key_type, vector<index_21_value_type>> index_21;
  dict<SigBit, pool<Cell*>> sigusers;
  pool<Cell*> blacklist_cells;
  pool<Cell*> autoremove_cells;
  dict<Cell*,int> rollback_cache;
  int rollback;

  struct state_xilinx_dsp48a_pack_t {
    SigSpec argD;
    SigSpec argQ;
    SigBit clock;
    Cell* dsp;
    Cell* ff;
    Cell* ffA0;
    Cell* ffA1;
    Cell* ffB0;
    Cell* ffB1;
    Cell* ffD;
    Cell* ffM;
    Cell* ffP;
    Cell* postAdd;
    IdString postAddAB;
    Cell* postAddMux;
    IdString postAddMuxAB;
    Cell* preAdd;
    SigSpec sigA;
    SigSpec sigB;
    SigSpec sigC;
    SigSpec sigD;
    SigSpec sigM;
    SigSpec sigP;
  } st_xilinx_dsp48a_pack;

  struct udata_xilinx_dsp48a_pack_t {
    Cell* dff;
    SigSpec dffD;
    SigSpec dffQ;
    SigBit dffclock;
  } ud_xilinx_dsp48a_pack;

  IdString id_b_A{"\\A"};
  IdString id_b_A0REG{"\\A0REG"};
  IdString id_b_A1REG{"\\A1REG"};
  IdString id_b_B{"\\B"};
  IdString id_b_B0REG{"\\B0REG"};
  IdString id_b_B1REG{"\\B1REG"};
  IdString id_b_C{"\\C"};
  IdString id_b_CLK{"\\CLK"};
  IdString id_b_CLK_POLARITY{"\\CLK_POLARITY"};
  IdString id_b_D{"\\D"};
  IdString id_b_DREG{"\\DREG"};
  IdString id_b_DSP48A{"\\DSP48A"};
  IdString id_b_DSP48A1{"\\DSP48A1"};
  IdString id_b_EN{"\\EN"};
  IdString id_b_EN_POLARITY{"\\EN_POLARITY"};
  IdString id_b_MREG{"\\MREG"};
  IdString id_b_OPMODE{"\\OPMODE"};
  IdString id_b_P{"\\P"};
  IdString id_b_PREG{"\\PREG"};
  IdString id_b_Q{"\\Q"};
  IdString id_b_SRST{"\\SRST"};
  IdString id_b_SRST_POLARITY{"\\SRST_POLARITY"};
  IdString id_b_SRST_VALUE{"\\SRST_VALUE"};
  IdString id_b_Y{"\\Y"};
  IdString id_b_init{"\\init"};
  IdString id_b_keep{"\\keep"};
  IdString id_d_add{"$add"};
  IdString id_d_dff{"$dff"};
  IdString id_d_dffe{"$dffe"};
  IdString id_d_mul{"$mul"};
  IdString id_d_mux{"$mux"};
  IdString id_d_sdff{"$sdff"};
  IdString id_d_sdffce{"$sdffce"};
  IdString id_d_sdffe{"$sdffe"};
  IdString id_d_sub{"$sub"};

  void add_siguser(const SigSpec &sig, Cell *cell) {
    for (auto bit : sigmap(sig)) {
      if (bit.wire == nullptr) continue;
      sigusers[bit].insert(cell);
    }
  }

  void blacklist(Cell *cell) {
    if (cell != nullptr && blacklist_cells.insert(cell).second) {
      auto ptr = rollback_cache.find(cell);
      if (ptr == rollback_cache.end()) return;
      int rb = ptr->second;
      if (rollback == 0 || rollback > rb)
        rollback = rb;
    }
  }

  void autoremove(Cell *cell) {
    if (cell != nullptr) {
      autoremove_cells.insert(cell);
      blacklist(cell);
    }
  }

  SigSpec port(Cell *cell, IdString portname) {
    try {
      return sigmap(cell->getPort(portname));
    } catch(std::out_of_range&) { log_error("Accessing non existing port %s\n",portname.c_str()); }
  }

  SigSpec port(Cell *cell, IdString portname, const SigSpec& defval) {
    return sigmap(cell->connections_.at(portname, defval));
  }

  Const param(Cell *cell, IdString paramname) {
    try {
      return cell->getParam(paramname);
    } catch(std::out_of_range&) { log_error("Accessing non existing parameter %s\n",paramname.c_str()); }
  }

  Const param(Cell *cell, IdString paramname, const Const& defval) {
    return cell->parameters.at(paramname, defval);
  }

  int nusers(const SigSpec &sig) {
    pool<Cell*> users;
    for (auto bit : sigmap(sig))
      for (auto user : sigusers[bit])
        users.insert(user);
    return GetSize(users);
  }

  xilinx_dsp48a_pm(Module *module, const vector<Cell*> &cells) :
      module(module), sigmap(module), setup_done(false), generate_mode(false), rngseed(12345678) {
    setup(cells);
  }

  xilinx_dsp48a_pm(Module *module) :
      module(module), sigmap(module), setup_done(false), generate_mode(false), rngseed(12345678) {
  }

  void setup(const vector<Cell*> &cells) {
    ud_xilinx_dsp48a_pack.dff = nullptr;
    ud_xilinx_dsp48a_pack.dffD = SigSpec();
    ud_xilinx_dsp48a_pack.dffQ = SigSpec();
    ud_xilinx_dsp48a_pack.dffclock = SigBit();
    log_assert(!setup_done);
    setup_done = true;
    for (auto port : module->ports)
      add_siguser(module->wire(port), nullptr);
    for (auto cell : module->cells())
      for (auto &conn : cell->connections())
        add_siguser(conn.second, cell);
    for (auto cell : cells) {
      do {
        Cell *dsp = cell;
        index_0_value_type value;
        std::get<0>(value) = cell;
        if (!(dsp->type.in(id_b_DSP48A, id_b_DSP48A1))) continue;
        index_0_key_type key;
        index_0[key].push_back(value);
      } while (0);
      do {
        Cell *preAdd = cell;
        index_3_value_type value;
        std::get<0>(value) = cell;
        if (!(preAdd->type.in(id_d_add, id_d_sub))) continue;
        if (!(GetSize(port(preAdd, id_b_Y)) <= 18)) continue;
        if (!(nusers(port(preAdd, id_b_Y)) == 2)) continue;
        if (!(GetSize(port(preAdd, id_b_A)) <= 18)) continue;
        if (!(GetSize(port(preAdd, id_b_B)) <= 18)) continue;
        index_3_key_type key;
        std::get<0>(key) = port(preAdd, id_b_Y);
        index_3[key].push_back(value);
      } while (0);
      do {
        Cell *postAdd = cell;
        index_9_value_type value;
        std::get<0>(value) = cell;
        if (!(postAdd->type.in(id_d_add))) continue;
        if (!(GetSize(port(postAdd, id_b_Y)) <= 48)) continue;
        vector<IdString> _pmg_choices_AB = {id_b_A, id_b_B};
        for (const IdString &AB : _pmg_choices_AB) {
        std::get<1>(value) = AB;
        if (!(nusers(port(postAdd, AB)) == 2)) continue;
        index_9_key_type key;
        std::get<0>(key) = port(postAdd, AB)[0];
        index_9[key].push_back(value);
        }
      } while (0);
      do {
        Cell *postAddMux = cell;
        index_12_value_type value;
        std::get<0>(value) = cell;
        if (!(postAddMux->type.in(id_d_mux))) continue;
        if (!(nusers(port(postAddMux, id_b_Y)) == 2)) continue;
        vector<IdString> _pmg_choices_AB = {id_b_A, id_b_B};
        for (const IdString &AB : _pmg_choices_AB) {
        std::get<1>(value) = AB;
        index_12_key_type key;
        std::get<0>(key) = port(postAddMux, AB);
        std::get<1>(key) = port(postAddMux, id_b_Y);
        index_12[key].push_back(value);
        }
      } while (0);
      do {
        Cell *ff = cell;
        index_17_value_type value;
        std::get<0>(value) = cell;
        if (!(ff->type.in(id_d_dff, id_d_dffe, id_d_sdff, id_d_sdffe))) continue;
        if (!(param(ff, id_b_CLK_POLARITY).as_bool())) continue;
        int &offset = std::get<1>(value);
        for (offset = 0; offset < GetSize(port(ff, id_b_D)); offset++) {
        index_17_key_type key;
        std::get<0>(key) = port(ff, id_b_Q)[offset];
        index_17[key].push_back(value);
        }
      } while (0);
      do {
        Cell *ff = cell;
        index_21_value_type value;
        std::get<0>(value) = cell;
        if (!(ff->type.in(id_d_dff, id_d_dffe, id_d_sdff, id_d_sdffe))) continue;
        if (!(param(ff, id_b_CLK_POLARITY).as_bool())) continue;
        int &offset = std::get<1>(value);
        for (offset = 0; offset < GetSize(port(ff, id_b_D)); offset++) {
        index_21_key_type key;
        std::get<0>(key) = port(ff, id_b_D)[offset];
        index_21[key].push_back(value);
        }
      } while (0);
    }
  }

  ~xilinx_dsp48a_pm() {
    for (auto cell : autoremove_cells)
      module->remove(cell);
  }

  int run_xilinx_dsp48a_pack(std::function<void()> on_accept_f) {
    log_assert(setup_done);
    accept_cnt = 0;
    on_accept = on_accept_f;
    rollback = 0;
    st_xilinx_dsp48a_pack.argD = SigSpec();
    st_xilinx_dsp48a_pack.argQ = SigSpec();
    st_xilinx_dsp48a_pack.clock = SigBit();
    st_xilinx_dsp48a_pack.dsp = nullptr;
    st_xilinx_dsp48a_pack.ff = nullptr;
    st_xilinx_dsp48a_pack.ffA0 = nullptr;
    st_xilinx_dsp48a_pack.ffA1 = nullptr;
    st_xilinx_dsp48a_pack.ffB0 = nullptr;
    st_xilinx_dsp48a_pack.ffB1 = nullptr;
    st_xilinx_dsp48a_pack.ffD = nullptr;
    st_xilinx_dsp48a_pack.ffM = nullptr;
    st_xilinx_dsp48a_pack.ffP = nullptr;
    st_xilinx_dsp48a_pack.postAdd = nullptr;
    st_xilinx_dsp48a_pack.postAddAB = IdString();
    st_xilinx_dsp48a_pack.postAddMux = nullptr;
    st_xilinx_dsp48a_pack.postAddMuxAB = IdString();
    st_xilinx_dsp48a_pack.preAdd = nullptr;
    st_xilinx_dsp48a_pack.sigA = SigSpec();
    st_xilinx_dsp48a_pack.sigB = SigSpec();
    st_xilinx_dsp48a_pack.sigC = SigSpec();
    st_xilinx_dsp48a_pack.sigD = SigSpec();
    st_xilinx_dsp48a_pack.sigM = SigSpec();
    st_xilinx_dsp48a_pack.sigP = SigSpec();
    block_0(1);
    log_assert(rollback_cache.empty());
    return accept_cnt;
  }

  int run_xilinx_dsp48a_pack(std::function<void(xilinx_dsp48a_pm&)> on_accept_f) {
    return run_xilinx_dsp48a_pack([&](){on_accept_f(*this);});
  }

  int run_xilinx_dsp48a_pack() {
    return run_xilinx_dsp48a_pack([](){});
  }

  void block_subpattern_xilinx_dsp48a_pack_(int recursion) { block_0(recursion); }
  void block_subpattern_xilinx_dsp48a_pack_in_dffe(int recursion) { block_16(recursion); }
  void block_subpattern_xilinx_dsp48a_pack_out_dffe(int recursion) { block_20(recursion); }

  // techlibs/xilinx/xilinx_dsp48a.pmg:52
  void block_0(int recursion YS_MAYBE_UNUSED) {
    Cell* &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;
    Cell* _pmg_backup_dsp = dsp;

    index_0_key_type key;
    auto cells_ptr = index_0.find(key);

    if (cells_ptr != index_0.end()) {
      const vector<index_0_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        dsp = std::get<0>(cells[_pmg_idx]);
        if (blacklist_cells.count(dsp)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_1(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            dsp = _pmg_backup_dsp;
            return;
          }
          rollback = 0;
        }
      }
    }

    dsp = nullptr;
    dsp = _pmg_backup_dsp;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:56
  void block_1(int recursion YS_MAYBE_UNUSED) {
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_2(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    auto unextend = [](const SigSpec &sig) {
      int i;
      for (i = GetSize(sig)-1; i > 0; i--)
        if (sig[i] != sig[i-1])
          break;
      // Do not remove non-const sign bit
      if (sig[i].wire)
        ++i;
      return sig.extract(0, i);
    };
    sigA = unextend(port(dsp, id_b_A));
    sigB = unextend(port(dsp, id_b_B));
    sigC = port(dsp, id_b_C, SigSpec());
    sigD = port(dsp, id_b_D, SigSpec());
    SigSpec P = port(dsp, id_b_P);
    // Only care about those bits that are used
    int i;
    for (i = GetSize(P)-1; i >= 0; i--)
      if (nusers(P[i]) > 1)
        break;
    i++;
    log_assert(nusers(P.extract_end(i)) <= 1);
    // This sigM could have no users if downstream sinks (e.g. id_d_add) is
    //   narrower than id_d_mul result, for example
    if (i == 0)
      reject;
    sigM = P.extract(0, i);
    clock = port(dsp, id_b_CLK, SigBit());

    block_2(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    clock = SigBit();
    sigA = SigSpec();
    sigB = SigSpec();
    sigC = SigSpec();
    sigD = SigSpec();
    sigM = SigSpec();
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:94
  void block_2(int recursion YS_MAYBE_UNUSED) {
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigB = sigB;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_3(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (param(dsp, id_b_B1REG).as_int() == 0 && param(dsp, id_b_B0REG).as_int() == 0 && port(dsp, id_b_OPMODE, SigSpec()).extract(4, 1).is_fully_zero()) {
      argQ = sigB;
      subpattern(in_dffe);
      if (dff) {
        ffB1 = dff;
        clock = dffclock;
        sigB = dffD;
      }
    }

    block_3(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    clock = _pmg_backup_clock;
    sigB = _pmg_backup_sigB;
    argQ = SigSpec();
    ffB1 = nullptr;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:108
  void block_3(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    Cell* &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;
    Cell* _pmg_backup_preAdd = preAdd;

    if (!(sigD.empty() || sigD.is_fully_zero())) {
      preAdd = nullptr;
      block_4(recursion+1);
      preAdd = _pmg_backup_preAdd;
      return;
    }

    if (!(param(dsp, id_b_B0REG).as_int() == 0)) {
      preAdd = nullptr;
      block_4(recursion+1);
      preAdd = _pmg_backup_preAdd;
      return;
    }

    if (!(port(dsp, id_b_OPMODE, SigSpec()).extract(4, 1).is_fully_zero())) {
      preAdd = nullptr;
      block_4(recursion+1);
      preAdd = _pmg_backup_preAdd;
      return;
    }

    index_3_key_type key;
    std::get<0>(key) = sigB;
    auto cells_ptr = index_3.find(key);

    if (cells_ptr != index_3.end()) {
      const vector<index_3_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        preAdd = std::get<0>(cells[_pmg_idx]);
        if (blacklist_cells.count(preAdd)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_4(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            preAdd = _pmg_backup_preAdd;
            return;
          }
          rollback = 0;
        }
      }
    }

    preAdd = nullptr;
    block_4(recursion+1);
    preAdd = _pmg_backup_preAdd;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:127
  void block_4(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigSpec _pmg_backup_sigB = sigB;
    SigSpec _pmg_backup_sigD = sigD;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_5(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (preAdd) {
      sigD = port(preAdd, id_b_A);
      sigB = port(preAdd, id_b_B);
    }

    block_5(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    sigB = _pmg_backup_sigB;
    sigD = _pmg_backup_sigD;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:135
  void block_5(int recursion YS_MAYBE_UNUSED) {
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigSpec _pmg_backup_argQ = argQ;
    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigB = sigB;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_6(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (param(dsp, id_b_B0REG).as_int() == 0) {
      argQ = sigB;
      subpattern(in_dffe);
      if (dff) {
        if (ffB1) {
          if (dff->type != ffB1->type)
            goto ffB0_end;
          if (dff->type.in(id_d_sdff, id_d_sdffe, id_d_sdffce)) {
            if (param(dff, id_b_SRST_POLARITY) != param(ffB1, id_b_SRST_POLARITY))
              goto ffB0_end;
            if (port(dff, id_b_SRST) != port(ffB1, id_b_SRST))
              goto ffB0_end;
          }
          if (dff->type.in(id_d_dffe, id_d_sdffe, id_d_sdffce)) {
            if (param(dff, id_b_EN_POLARITY) != param(ffB1, id_b_EN_POLARITY))
              goto ffB0_end;
            if (port(dff, id_b_EN) != port(ffB1, id_b_EN))
              goto ffB0_end;
          }
        }
        ffB0 = dff;
        clock = dffclock;
        sigB = dffD;
      }
    }
  ffB0_end:

    block_6(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argQ = _pmg_backup_argQ;
    clock = _pmg_backup_clock;
    sigB = _pmg_backup_sigB;
    ffB0 = nullptr;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:166
  void block_6(int recursion YS_MAYBE_UNUSED) {
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &ffA0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA0;
    Cell* &ffA1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA1;
    SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigSpec _pmg_backup_argQ = argQ;
    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigA = sigA;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_7(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (param(dsp, id_b_A0REG).as_int() == 0 && param(dsp, id_b_A1REG).as_int() == 0) {
      argQ = sigA;
      subpattern(in_dffe);
      if (dff) {
        ffA1 = dff;
        clock = dffclock;
        sigA = dffD;
        // Now attempt to match A0
        if (ffA1) {
          argQ = sigA;
          subpattern(in_dffe);
          if (dff) {
            if (dff->type != ffA1->type)
              goto ffA0_end;
            if (dff->type.in(id_d_sdff, id_d_sdffe, id_d_sdffce)) {
              if (param(dff, id_b_SRST_POLARITY) != param(ffA1, id_b_SRST_POLARITY))
                goto ffA0_end;
              if (port(dff, id_b_SRST) != port(ffA1, id_b_SRST))
                goto ffA0_end;
            }
            if (dff->type.in(id_d_dffe, id_d_sdffe, id_d_sdffce)) {
              if (param(dff, id_b_EN_POLARITY) != param(ffA1, id_b_EN_POLARITY))
                goto ffA0_end;
              if (port(dff, id_b_EN) != port(ffA1, id_b_EN))
                goto ffA0_end;
            }
            ffA0 = dff;
            clock = dffclock;
            sigA = dffD;
  ffA0_end:        ;
          }
        }
      }
    }

    block_7(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argQ = _pmg_backup_argQ;
    clock = _pmg_backup_clock;
    sigA = _pmg_backup_sigA;
    ffA0 = nullptr;
    ffA1 = nullptr;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:208
  void block_7(int recursion YS_MAYBE_UNUSED) {
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffA0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA0;
    Cell* const &ffA1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA1;
    Cell* const &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &ffD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffD;
    SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigSpec _pmg_backup_argQ = argQ;
    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigD = sigD;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_8(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (param(dsp, id_b_DREG).as_int() == 0) {
      argQ = sigD;
      subpattern(in_dffe);
      if (dff) {
        ffD = dff;
        clock = dffclock;
        sigD = dffD;
      }
    }

    block_8(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argQ = _pmg_backup_argQ;
    clock = _pmg_backup_clock;
    sigD = _pmg_backup_sigD;
    ffD = nullptr;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:221
  void block_8(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffA0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA0;
    Cell* const &ffA1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA1;
    Cell* const &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &ffD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffD;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &ffM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffM;
    SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    SigSpec &sigP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigP;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigM = sigM;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_9(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (param(dsp, id_b_MREG).as_int() == 0 && nusers(sigM) == 2) {
      argD = sigM;
      subpattern(out_dffe);
      if (dff) {
        ffM = dff;
        clock = dffclock;
        sigM = dffQ;
      }
    }
    sigP = sigM;

    block_9(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    clock = _pmg_backup_clock;
    sigM = _pmg_backup_sigM;
    argD = SigSpec();
    ffM = nullptr;
    sigP = SigSpec();
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:239
  void block_9(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffA0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA0;
    Cell* const &ffA1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA1;
    Cell* const &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &ffD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffD;
    Cell* const &ffM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffM;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigP;
    Cell* &postAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAdd;
    IdString &postAddAB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddAB;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;
    Cell* _pmg_backup_postAdd = postAdd;

    if (!(port(dsp, id_b_OPMODE, SigSpec()).extract(2,2).is_fully_zero())) {
      postAdd = nullptr;
      block_10(recursion+1);
      postAdd = _pmg_backup_postAdd;
      return;
    }

    index_9_key_type key;
    std::get<0>(key) = sigP[0];
    auto cells_ptr = index_9.find(key);

    if (cells_ptr != index_9.end()) {
      const vector<index_9_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        postAdd = std::get<0>(cells[_pmg_idx]);
        const IdString &AB YS_MAYBE_UNUSED = std::get<1>(cells[_pmg_idx]);
        if (blacklist_cells.count(postAdd)) continue;
        if (!(GetSize(port(postAdd, AB)) >= GetSize(sigP))) continue;
        if (!(port(postAdd, AB).extract(0, GetSize(sigP)) == sigP)) continue;
        if (!(port(postAdd, AB).extract_end(GetSize(sigP)) == SigSpec(sigP[GetSize(sigP)-1], GetSize(port(postAdd, AB))-GetSize(sigP)) || port(postAdd, AB).extract_end(GetSize(sigP)) == SigSpec(State::S0, GetSize(port(postAdd, AB))-GetSize(sigP)))) continue;
        auto _pmg_backup_postAddAB = postAddAB;
        postAddAB = AB;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_10(recursion+1);
        postAddAB = _pmg_backup_postAddAB;
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            postAdd = _pmg_backup_postAdd;
            return;
          }
          rollback = 0;
        }
      }
    }

    postAdd = nullptr;
    block_10(recursion+1);
    postAdd = _pmg_backup_postAdd;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:258
  void block_10(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffA0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA0;
    Cell* const &ffA1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA1;
    Cell* const &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &ffD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffD;
    Cell* const &ffM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffM;
    Cell* const &postAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAdd;
    const IdString &postAddAB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddAB;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    SigSpec &sigP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigP;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigSpec _pmg_backup_sigC = sigC;
    SigSpec _pmg_backup_sigP = sigP;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_11(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (postAdd) {
      sigC = port(postAdd, postAddAB == id_b_A ? id_b_B : id_b_A);
      sigP = port(postAdd, id_b_Y);
    }

    block_11(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    sigC = _pmg_backup_sigC;
    sigP = _pmg_backup_sigP;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:266
  void block_11(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffA0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA0;
    Cell* const &ffA1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA1;
    Cell* const &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &ffD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffD;
    Cell* const &ffM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffM;
    Cell* const &postAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAdd;
    const IdString &postAddAB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddAB;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &ffP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffP;
    SigSpec &sigP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigP;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigSpec _pmg_backup_argD = argD;
    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigP = sigP;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_12(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (param(dsp, id_b_PREG).as_int() == 0) {
      if (nusers(sigP) == 2) {
        argD = sigP;
        subpattern(out_dffe);
        if (dff) {
          ffP = dff;
          clock = dffclock;
          sigP = dffQ;
        }
      }
    }

    block_12(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argD = _pmg_backup_argD;
    clock = _pmg_backup_clock;
    sigP = _pmg_backup_sigP;
    ffP = nullptr;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:293
  void block_12(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffA0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA0;
    Cell* const &ffA1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA1;
    Cell* const &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &ffD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffD;
    Cell* const &ffM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffM;
    Cell* const &ffP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffP;
    Cell* const &postAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAdd;
    const IdString &postAddAB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddAB;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigP;
    Cell* &postAddMux YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddMux;
    IdString &postAddMuxAB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddMuxAB;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;
    Cell* _pmg_backup_postAddMux = postAddMux;

    if (!(postAdd)) {
      postAddMux = nullptr;
      block_13(recursion+1);
      postAddMux = _pmg_backup_postAddMux;
      return;
    }

    if (!(ffP)) {
      postAddMux = nullptr;
      block_13(recursion+1);
      postAddMux = _pmg_backup_postAddMux;
      return;
    }

    index_12_key_type key;
    std::get<0>(key) = sigP;
    std::get<1>(key) = sigC;
    auto cells_ptr = index_12.find(key);

    if (cells_ptr != index_12.end()) {
      const vector<index_12_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        postAddMux = std::get<0>(cells[_pmg_idx]);
        const IdString &AB YS_MAYBE_UNUSED = std::get<1>(cells[_pmg_idx]);
        if (blacklist_cells.count(postAddMux)) continue;
        auto _pmg_backup_postAddMuxAB = postAddMuxAB;
        postAddMuxAB = AB;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_13(recursion+1);
        postAddMuxAB = _pmg_backup_postAddMuxAB;
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            postAddMux = _pmg_backup_postAddMux;
            return;
          }
          rollback = 0;
        }
      }
    }

    postAddMux = nullptr;
    block_13(recursion+1);
    postAddMux = _pmg_backup_postAddMux;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:305
  void block_13(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffA0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA0;
    Cell* const &ffA1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA1;
    Cell* const &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &ffD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffD;
    Cell* const &ffM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffM;
    Cell* const &ffP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffP;
    Cell* const &postAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAdd;
    const IdString &postAddAB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddAB;
    Cell* const &postAddMux YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddMux;
    const IdString &postAddMuxAB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddMuxAB;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigP;
    SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigSpec _pmg_backup_sigC = sigC;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_14(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (postAddMux)
      sigC = port(postAddMux, postAddMuxAB == id_b_A ? id_b_B : id_b_A);

    block_14(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    sigC = _pmg_backup_sigC;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:310
  void block_14(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.dsp;
    Cell* const &ffA0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA0;
    Cell* const &ffA1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffA1;
    Cell* const &ffB0 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB0;
    Cell* const &ffB1 YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffB1;
    Cell* const &ffD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffD;
    Cell* const &ffM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffM;
    Cell* const &ffP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ffP;
    Cell* const &postAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAdd;
    const IdString &postAddAB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddAB;
    Cell* const &postAddMux YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddMux;
    const IdString &postAddMuxAB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.postAddMuxAB;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigD;
    const SigSpec &sigM YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigM;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.sigP;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_15(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    accept;

    block_15(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  void block_15(int recursion YS_MAYBE_UNUSED) {
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:321
  void block_16(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_17(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    dff = nullptr;
    if (argQ.empty())
      reject;
    for (const auto &c : argQ.chunks()) {
      // Abandon matches when 'Q' is a constant
      if (!c.wire)
        reject;
      // Abandon matches when 'Q' has the keep attribute set
      if (c.wire->get_bool_attribute(id_b_keep))
        reject;
      // Abandon matches when 'Q' has a non-zero init attribute set
      // (not supported by DSP48E1)
      Const init = c.wire->attributes.at(id_b_init, Const());
      if (!init.empty())
        for (auto b : init.extract(c.offset, c.width))
          if (b != State::Sx && b != State::S0)
            reject;
    }

    block_17(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:342
  void block_17(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &ff YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ff;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;
    Cell* _pmg_backup_ff = ff;

    index_17_key_type key;
    std::get<0>(key) = argQ[0];
    auto cells_ptr = index_17.find(key);

    if (cells_ptr != index_17.end()) {
      const vector<index_17_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        ff = std::get<0>(cells[_pmg_idx]);
        const int &offset YS_MAYBE_UNUSED = std::get<1>(cells[_pmg_idx]);
        if (blacklist_cells.count(ff)) continue;
        if (!(ff->type.in(id_d_dff, id_d_dffe) || param(ff, id_b_SRST_VALUE).is_fully_zero())) continue;
        if (!(GetSize(port(ff, id_b_Q)) >= offset + GetSize(argQ))) continue;
        if (!(port(ff, id_b_Q).extract(offset, GetSize(argQ)) == argQ)) continue;
        if (!(clock == SigBit() || port(ff, id_b_CLK)[0] == clock)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_18(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            ff = _pmg_backup_ff;
            return;
          }
          rollback = 0;
        }
      }
    }

    ff = nullptr;
    ff = _pmg_backup_ff;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:360
  void block_18(int recursion YS_MAYBE_UNUSED) {
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* const &ff YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ff;
    SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigSpec _pmg_backup_argQ = argQ;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_19(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    SigSpec Q = port(ff, id_b_Q);
    dff = ff;
    dffclock = port(ff, id_b_CLK);
    dffD = argQ;
    SigSpec D = port(ff, id_b_D);
    argQ = Q;
    dffD.replace(argQ, D);

    block_19(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argQ = _pmg_backup_argQ;
  }

  void block_19(int recursion YS_MAYBE_UNUSED) {
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:387
  void block_20(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_21(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    dff = nullptr;
    for (auto c : argD.chunks())
      // Abandon matches when 'D' has the keep attribute set
      if (c.wire->get_bool_attribute(id_b_keep))
        reject;

    block_21(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:395
  void block_21(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* &ff YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ff;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;
    Cell* _pmg_backup_ff = ff;

    index_21_key_type key;
    std::get<0>(key) = argD[0];
    auto cells_ptr = index_21.find(key);

    if (cells_ptr != index_21.end()) {
      const vector<index_21_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        ff = std::get<0>(cells[_pmg_idx]);
        const int &offset YS_MAYBE_UNUSED = std::get<1>(cells[_pmg_idx]);
        if (blacklist_cells.count(ff)) continue;
        if (!(GetSize(port(ff, id_b_D)) >= offset + GetSize(argD))) continue;
        if (!(port(ff, id_b_D).extract(offset, GetSize(argD)) == argD)) continue;
        if (!(clock == SigBit() || port(ff, id_b_CLK)[0] == clock)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_22(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            ff = _pmg_backup_ff;
            return;
          }
          rollback = 0;
        }
      }
    }

    ff = nullptr;
    ff = _pmg_backup_ff;
  }

  // techlibs/xilinx/xilinx_dsp48a.pmg:410
  void block_22(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argD;
    const SigBit &clock YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.clock;
    Cell* const &ff YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.ff;
    SigSpec &argQ YS_MAYBE_UNUSED = st_xilinx_dsp48a_pack.argQ;
    Cell* &dff YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_xilinx_dsp48a_pack.dffclock;

    SigSpec _pmg_backup_argQ = argQ;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_23(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_xilinx_dsp48a_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    SigSpec D = port(ff, id_b_D);
    SigSpec Q = port(ff, id_b_Q);
    argQ = argD;
    argQ.replace(D, Q);
    // Abandon matches when 'Q' has a non-zero init attribute set
    // (not supported by DSP48E1)
    for (auto c : argQ.chunks()) {
      Const init = c.wire->attributes.at(id_b_init, Const());
      if (!init.empty())
        for (auto b : init.extract(c.offset, c.width))
          if (b != State::Sx && b != State::S0)
            reject;
    }
    dff = ff;
    dffQ = argQ;
    dffclock = port(ff, id_b_CLK);

    block_23(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argQ = _pmg_backup_argQ;
  }

  void block_23(int recursion YS_MAYBE_UNUSED) {
  }
};
