// generated by Fast Light User Interface Designer (fluid) version 1.0404

#include "PresetsUI.h"
// PresetsUI.cc
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2010, Alan Calvert
// Copyright 2017-2023, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original.


#include "Misc/TextMsgBuffer.h"

    namespace { // Implementation details...
        TextMsgBuffer& textMsgBuffer = TextMsgBuffer::instance();
    }
#include "MasterUI.h"

void PresetsUI_::refresh() {
  //
}

PresetsUI_::~PresetsUI_() {
  //
      ;
}

void PresetsUI::cb_Ucopywin_i(ScaleTrackedWindow* o, void*) {
  saveWin(synth, o->w(), o->h(), o->x(), o->y(), false,"PresetWin");
  o->hide();
}
void PresetsUI::cb_Ucopywin(ScaleTrackedWindow* o, void* v) {
  ((PresetsUI*)(o->user_data()))->cb_Ucopywin_i(o,v);
}

void PresetsUI::cb_Ucopybrowse_i(Fl_Browser* o, void*) {
  //

              int result = o->value();
              Upresetname->cut(0, 25);
              Upresetname->insert(o->text(result));
              Upresetname->position(0);
}
void PresetsUI::cb_Ucopybrowse(Fl_Browser* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_Ucopybrowse_i(o,v);
}

void PresetsUI::cb_UcopyPresbutton_i(Fl_Button*, void*) {
  // to file

              string name = string(Upresetname->value());
              int miscMsg = textMsgBuffer.push(name);
              send_data(0, TOPLEVEL::action::lowPrio, TOPLEVEL::type::Copy, TOPLEVEL::control::copyPaste, npart, kititem, engine, insert, parameter, offset, miscMsg);
              Ucopywin->hide();
}
void PresetsUI::cb_UcopyPresbutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_UcopyPresbutton_i(o,v);
}

void PresetsUI::cb_UcopyClipbutton_i(Fl_Button*, void*) {
  // to clipboard

          send_data(0, TOPLEVEL::action::forceUpdate | TOPLEVEL::action::lowPrio, TOPLEVEL::type::Copy, TOPLEVEL::control::copyPaste, npart, kititem, engine, insert, parameter, offset, UNUSED);
          Ucopywin->hide();
}
void PresetsUI::cb_UcopyClipbutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_UcopyClipbutton_i(o,v);
}

void PresetsUI::cb_Ucopycancel_i(Fl_Button*, void*) {
  //

         Ucopywin->hide();
         saveWin(synth, Ucopywin->w(), Ucopywin->h(), Ucopywin->x(), Ucopywin->y(), false,"PresetWin");
}
void PresetsUI::cb_Ucopycancel(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_Ucopycancel_i(o,v);
}

void PresetsUI::cb_Upresetname_i(Fl_Input* o, void*) {
  //

          const char *tmp = o->value();
          if (tmp == NULL)
          tmp = "";
          if (strlen(tmp) > 0)
          {
              UcopyPresbutton->activate();
          }
          else
          {
              UcopyPresbutton->deactivate();
          }
}
void PresetsUI::cb_Upresetname(Fl_Input* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_Upresetname_i(o,v);
}

void PresetsUI::cb_Upastewin_i(ScaleTrackedWindow* o, void*) {
  saveWin(synth, o->w(), o->h(), o->x(), o->y(), false,"PresetWin");
  o->hide();
}
void PresetsUI::cb_Upastewin(ScaleTrackedWindow* o, void* v) {
  ((PresetsUI*)(o->user_data()))->cb_Upastewin_i(o,v);
}

void PresetsUI::cb_Upastebrowse_i(Fl_Browser* o, void*) {
  //

          if (o->value())
          {
              int result = o->value();
              if (result > 0)
              {
                  UpastePresbutton->activate();
                  Udeletepbutton->activate();
              }
          }
          else
          {
              UpastePresbutton->deactivate();
              Udeletepbutton->deactivate();
          }
}
void PresetsUI::cb_Upastebrowse(Fl_Browser* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_Upastebrowse_i(o,v);
}

void PresetsUI::cb_UpastePresbutton_i(Fl_Button*, void*) {
  // from preset

              if (Upastebrowse->value() <= 0)
              return;

              string name = Upastebrowse->text(Upastebrowse->value());
              int miscMsg = textMsgBuffer.push(name);
              send_data(0, TOPLEVEL::action::forceUpdate | TOPLEVEL::action::lowPrio, TOPLEVEL::type::Paste, TOPLEVEL::control::copyPaste, npart, kititem, engine, insert, parameter, offset, miscMsg);
              Upastewin->hide();
}
void PresetsUI::cb_UpastePresbutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_UpastePresbutton_i(o,v);
}

void PresetsUI::cb_UpasteClipbutton_i(Fl_Button*, void*) {
  // from clipboard

            send_data(0, TOPLEVEL::action::forceUpdate | TOPLEVEL::action::lowPrio, TOPLEVEL::type::Paste, TOPLEVEL::control::copyPaste, npart, kititem, engine, insert, parameter, offset, UNUSED);
            Upastewin->hide();
}
void PresetsUI::cb_UpasteClipbutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_UpasteClipbutton_i(o,v);
}

void PresetsUI::cb_Upastecancel_i(Fl_Button*, void*) {
  //

          Upastewin->hide();
          saveWin(synth, Upastewin->w(), Upastewin->h(), Upastewin->x(), Upastewin->y(), false,"PresetWin");
}
void PresetsUI::cb_Upastecancel(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_Upastecancel_i(o,v);
}

void PresetsUI::cb_Udeletepbutton_i(Fl_Button*, void*) {
  //
  string name = Upastebrowse->text(Upastebrowse->value());
  int miscMsg = textMsgBuffer.push(name);
  send_data(1, TOPLEVEL::action::lowPrio, TOPLEVEL::type::Paste, TOPLEVEL::control::copyPaste, npart, kititem, engine, insert, parameter, offset, miscMsg);
  Upastewin->hide();
}
void PresetsUI::cb_Udeletepbutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_Udeletepbutton_i(o,v);
}

PresetsUI::PresetsUI(SynthEngine *_synth) {
  //
      synth = _synth;
      make_window();
      UcopyW = 0;
      UpasteW = 0;
      presetsDW = 265; // these are shared between both
      presetsDH = 430;
}

PresetsUI::~PresetsUI() {
  //
       if (Upastewin->visible())
           saveWin(synth, Upastewin->w(), Upastewin->h(), Upastewin->x(), Upastewin->y(), false,"PresetWin");
       else if (Ucopywin->visible())
             saveWin(synth, Ucopywin->w(), Ucopywin->h(), Ucopywin->x(), Ucopywin->y(), false,"PresetWin");

      Ucopywin->hide();
      delete(Ucopywin);
      Upastewin->hide();
      delete(Upastewin);
      ;
}

ScaleTrackedWindow* PresetsUI::make_window() {
  { ScaleTrackedWindow* o = Ucopywin = new ScaleTrackedWindow(265, 430, "Yoshimi : Copy to");
    Ucopywin->box(FL_PLASTIC_THIN_UP_BOX);
    Ucopywin->color(FL_BACKGROUND2_COLOR);
    Ucopywin->selection_color(FL_BACKGROUND_COLOR);
    Ucopywin->labeltype(FL_NO_LABEL);
    Ucopywin->labelfont(0);
    Ucopywin->labelsize(14);
    Ucopywin->labelcolor(FL_FOREGROUND_COLOR);
    Ucopywin->callback((Fl_Callback*)cb_Ucopywin, (void*)(this));
    Ucopywin->align(Fl_Align(FL_ALIGN_TOP));
    Ucopywin->when(FL_WHEN_RELEASE);
    { Ucopybrowse = new Fl_Browser(10, 25, 245, 320);
      Ucopybrowse->type(1);
      Ucopybrowse->labelcolor((Fl_Color)64);
      Ucopybrowse->textcolor((Fl_Color)64);
      Ucopybrowse->callback((Fl_Callback*)cb_Ucopybrowse);
    } // Fl_Browser* Ucopybrowse
    { UcopyPresbutton = new Fl_Button(145, 355, 110, 24, "Copy to Preset");
      UcopyPresbutton->box(FL_PLASTIC_THIN_UP_BOX);
      UcopyPresbutton->color((Fl_Color)228);
      UcopyPresbutton->labelcolor((Fl_Color)64);
      UcopyPresbutton->callback((Fl_Callback*)cb_UcopyPresbutton);
    } // Fl_Button* UcopyPresbutton
    { UcopyClipbutton = new Fl_Button(25, 385, 90, 35, "Copy to Clipboard");
      UcopyClipbutton->box(FL_PLASTIC_THIN_UP_BOX);
      UcopyClipbutton->color((Fl_Color)228);
      UcopyClipbutton->labelcolor((Fl_Color)64);
      UcopyClipbutton->callback((Fl_Callback*)cb_UcopyClipbutton);
      UcopyClipbutton->align(Fl_Align(192));
    } // Fl_Button* UcopyClipbutton
    { Ucopycancel = new Fl_Button(160, 385, 80, 35, "Cancel");
      Ucopycancel->box(FL_THIN_UP_BOX);
      Ucopycancel->color((Fl_Color)196);
      Ucopycancel->labelcolor((Fl_Color)64);
      Ucopycancel->callback((Fl_Callback*)cb_Ucopycancel);
      Ucopycancel->align(Fl_Align(192));
    } // Fl_Button* Ucopycancel
    { Ucopytype = new Fl_Box(10, 5, 40, 15, "Type:");
      Ucopytype->labelsize(11);
      Ucopytype->labelcolor((Fl_Color)64);
      Ucopytype->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
    } // Fl_Box* Ucopytype
    { Fl_Box* o = Ucopytypetext = new Fl_Box(50, 5, 205, 15);
      Ucopytypetext->box(FL_FLAT_BOX);
      Ucopytypetext->color(FL_BACKGROUND2_COLOR);
      Ucopytypetext->labelfont(1);
      Ucopytypetext->labelsize(11);
      Ucopytypetext->labelcolor((Fl_Color)64);
      Ucopytypetext->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      o->label(groupName.c_str());
    } // Fl_Box* Ucopytypetext
    { Fl_Input* o = Upresetname = new Fl_Input(10, 355, 130, 24);
      Upresetname->labelcolor((Fl_Color)64);
      Upresetname->textcolor((Fl_Color)64);
      Upresetname->callback((Fl_Callback*)cb_Upresetname);
      Upresetname->when(FL_WHEN_CHANGED);
      o->maximum_size(25);
    } // Fl_Input* Upresetname
    Ucopywin->set_modal();
    Ucopywin->resizable(Ucopywin);
    o->size_range(265, 430, 0, 0, 0, 0, 1);
    Ucopywin->end();
  } // ScaleTrackedWindow* Ucopywin
  { ScaleTrackedWindow* o = Upastewin = new ScaleTrackedWindow(265, 430, "Yoshimi");
    Upastewin->box(FL_PLASTIC_THIN_UP_BOX);
    Upastewin->color(FL_BACKGROUND2_COLOR);
    Upastewin->selection_color(FL_BACKGROUND_COLOR);
    Upastewin->labeltype(FL_NO_LABEL);
    Upastewin->labelfont(0);
    Upastewin->labelsize(14);
    Upastewin->labelcolor(FL_FOREGROUND_COLOR);
    Upastewin->callback((Fl_Callback*)cb_Upastewin, (void*)(this));
    Upastewin->align(Fl_Align(FL_ALIGN_TOP));
    Upastewin->when(FL_WHEN_RELEASE);
    { Upastebrowse = new Fl_Browser(10, 25, 245, 320);
      Upastebrowse->type(2);
      Upastebrowse->labelcolor((Fl_Color)64);
      Upastebrowse->textcolor((Fl_Color)64);
      Upastebrowse->callback((Fl_Callback*)cb_Upastebrowse);
    } // Fl_Browser* Upastebrowse
    { UpastePresbutton = new Fl_Button(10, 355, 160, 24, "Paste from Preset");
      UpastePresbutton->box(FL_PLASTIC_THIN_UP_BOX);
      UpastePresbutton->color((Fl_Color)228);
      UpastePresbutton->labelcolor((Fl_Color)64);
      UpastePresbutton->callback((Fl_Callback*)cb_UpastePresbutton);
    } // Fl_Button* UpastePresbutton
    { UpasteClipbutton = new Fl_Button(25, 385, 90, 35, "Paste from Clipboard");
      UpasteClipbutton->box(FL_PLASTIC_THIN_UP_BOX);
      UpasteClipbutton->color((Fl_Color)228);
      UpasteClipbutton->labelcolor((Fl_Color)64);
      UpasteClipbutton->callback((Fl_Callback*)cb_UpasteClipbutton);
      UpasteClipbutton->align(Fl_Align(192));
    } // Fl_Button* UpasteClipbutton
    { Upastecancel = new Fl_Button(160, 385, 80, 35, "Cancel");
      Upastecancel->box(FL_THIN_UP_BOX);
      Upastecancel->color((Fl_Color)196);
      Upastecancel->labelcolor((Fl_Color)64);
      Upastecancel->callback((Fl_Callback*)cb_Upastecancel);
      Upastecancel->align(Fl_Align(192));
    } // Fl_Button* Upastecancel
    { Fl_Box* o = Upastetypetext = new Fl_Box(55, 5, 200, 15);
      Upastetypetext->box(FL_FLAT_BOX);
      Upastetypetext->color(FL_BACKGROUND2_COLOR);
      Upastetypetext->labelfont(1);
      Upastetypetext->labelsize(11);
      Upastetypetext->labelcolor((Fl_Color)64);
      Upastetypetext->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      o->label(groupName.c_str());
    } // Fl_Box* Upastetypetext
    { Upastetype = new Fl_Box(15, 5, 40, 15, "Type:");
      Upastetype->labelsize(11);
      Upastetype->labelcolor((Fl_Color)64);
      Upastetype->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
    } // Fl_Box* Upastetype
    { Udeletepbutton = new Fl_Button(180, 355, 75, 24, "Delete");
      Udeletepbutton->box(FL_PLASTIC_THIN_UP_BOX);
      Udeletepbutton->color((Fl_Color)228);
      Udeletepbutton->labelcolor((Fl_Color)64);
      Udeletepbutton->callback((Fl_Callback*)cb_Udeletepbutton);
    } // Fl_Button* Udeletepbutton
    Upastewin->set_modal();
    Upastewin->resizable(Upastewin);
    o->size_range(265, 430, 0, 0, 0, 0, 1);
    Upastewin->end();
  } // ScaleTrackedWindow* Upastewin
  return Upastewin;
}

string PresetsUI::setExten() {
  //
      string text = "";
      if (npart == TOPLEVEL::systemEffects)
          text = "system";
      else if (npart == TOPLEVEL::insertEffects)
          text = "insert";
      else
          text = "part " + std::to_string(npart + 1);
      return text;
}

void PresetsUI::Ucopy(int _npart, int _kititem, int _engine , int _insert , int _parameter , int _offset ) {
  //

      npart = _npart;
      kititem = _kititem;
      engine = _engine;
      insert = _insert;
      parameter = _parameter;
      offset = _offset;
      Ucopywin->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("Copy from - " + setExten()), UNUSED, TOPLEVEL::windowTitle)).c_str());
      string names = Ufetch();
      if (names.empty())
          return;

      size_t pos = 0;
      unsigned char ch = 10;
      Ucopybrowse->clear();
      UcopyPresbutton->deactivate();
      Ucopytypetext->label(groupName.c_str());
      do {
          pos = names.find(ch);
          if (pos != string::npos)
          {
              string line = names.substr(0, pos);
              names = names.substr(pos + 1, names.length());
              Ucopybrowse->add(line.c_str());
          }
          else
              Ucopybrowse->add(names.c_str());
      }
      while(pos != string::npos);

      Ucopywin->show();
}

void PresetsUI::Upaste(int _npart, int _kititem, int _engine , int _insert , int _parameter , int _offset ) {
  //

      npart = _npart;
      kititem = _kititem;
      engine = _engine;
      insert = _insert;
      parameter = _parameter;
      offset = _offset;
      Upastewin->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("Paste to - " + setExten()), UNUSED, TOPLEVEL::windowTitle)).c_str());
      string names = Ufetch();
      if (names.empty())
          return;
      size_t pos = 0;
      unsigned char ch = 10;
      Upastebrowse->clear();
      UpastePresbutton->deactivate();
      UpasteClipbutton->activate();
      Udeletepbutton->deactivate();
      Upastetypetext->label(groupName.c_str());
      do {
          pos = names.find(ch);
          if (pos != string::npos)
          {
              string line = names.substr(0, pos);
              names = names.substr(pos + 1, names.length());
              Upastebrowse->add(line.c_str());
          }
          else
              Upastebrowse->add(names.c_str());
      }
      while(pos != string::npos);
      if (Ufetch(2).empty())
          UpasteClipbutton->deactivate();
      else
          UpasteClipbutton->activate();
      Upastewin->show();
}

string PresetsUI::Ufetch(int sent ) {
  //
      int  W, H, X, Y, O;
      loadWin(synth, W, H, X, Y, O, "PresetWin");
      if (W < presetsDW || H < presetsDH)
      {
          W = presetsDW;
          H = presetsDH;
      }
      checkSane(X, Y, W, H, presetsDW, presetsDH, true);

      Ucopywin->resize(X, Y, W, H);
      Upastewin->resize(X, Y, W, H);
      UpresetsRtext();

      CommandBlock putData;
      putData.data.value = sent;
      putData.data.type = TOPLEVEL::type::List;
      putData.data.source = TOPLEVEL::action::lowPrio;
      putData.data.control = TOPLEVEL::control::copyPaste;
      putData.data.part = npart;
      putData.data.kit = kititem;
      putData.data.engine = engine;
      putData.data.insert = insert;
      putData.data.parameter = parameter;
      putData.data.offset = offset;
      putData.data.miscmsg = UNUSED;
      //synth->CBtest(&putData);
      int value = synth->interchange.readAllData(putData);
      if (sent == 2)
      {
          return textMsgBuffer.fetch(value);
      }
      putData.data.value = 1;
      int Ugroup = synth->interchange.readAllData(putData);
      groupName = textMsgBuffer.fetch(Ugroup);
      //std::cout << "In GUI >" << groupName << std::endl;
      return textMsgBuffer.fetch(value);
}

void PresetsUI::send_data(float value, int action, int type, int control, int part , int kititem , int engine , int insert , int parameter , int offset , int miscmsg ) {
  //
          collect_writeData(synth, value, action, type, control, part, kititem, engine, insert, parameter, offset, miscmsg);
}

void PresetsUI::UpresetsRtext() {
  //

      if (Ucopywin->visible())
      {
          if (UcopyW != Ucopywin->w())
          {
              UcopyW = Ucopywin->w();
              UpasteW = 0;

              float dScale = Ucopywin->w() / float(presetsDW);

              int size14 = int(14 * dScale);
              int size11 = int(11 * dScale);

              Ucopybrowse->textsize(size14);
              UcopyPresbutton->labelsize(size14);
              UcopyClipbutton->labelsize(size14);
              Ucopycancel->labelsize(size14);
              Upresetname->textsize(size14);
              Ucopytype->labelsize(size11);
              Ucopytypetext->labelsize(size11);

              Ucopywin->redraw();
          }
      }
      else if (Upastewin->visible())
      {
          if (UpasteW != Upastewin->w())
          {
              UpasteW = Upastewin->w();
              UcopyW = 0;

              float dScale = Upastewin->w() / float(presetsDW);

              int size14 = int(14 * dScale);
              int size11 = int(11 * dScale);

              Upastebrowse->textsize(size14);
              UpastePresbutton->labelsize(size14);
              UpasteClipbutton->labelsize(size14);
              Upastecancel->labelsize(size14);
              Udeletepbutton->labelsize(size14);
              Upastetype->labelsize(size11);
              Upastetypetext->labelsize(size11);

              Upastewin->redraw();
          }

      } {}
}
