/** @file
 * VirtualBox API class wrapper code for IUSBDevice.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_USBDEVICE

#include "USBDeviceWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(USBDeviceWrap)

//
// IUSBDevice properties
//

STDMETHODIMP USBDeviceWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "USBDevice::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        UuidOutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "USBDevice::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(VendorId)(USHORT *aVendorId)
{
    LogRelFlow(("{%p} %s: enter aVendorId=%p\n", this, "USBDevice::getVendorId", aVendorId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVendorId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_VENDORID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVendorId(aVendorId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_VENDORID_RETURN(this, hrc, 0 /*normal*/,*aVendorId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_VENDORID_RETURN(this, hrc, 1 /*hrc exception*/,*aVendorId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_VENDORID_RETURN(this, hrc, 9 /*unhandled exception*/,*aVendorId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVendorId=%RU16 hrc=%Rhrc\n", this, "USBDevice::getVendorId", *aVendorId, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(ProductId)(USHORT *aProductId)
{
    LogRelFlow(("{%p} %s: enter aProductId=%p\n", this, "USBDevice::getProductId", aProductId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProductId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PRODUCTID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProductId(aProductId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PRODUCTID_RETURN(this, hrc, 0 /*normal*/,*aProductId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PRODUCTID_RETURN(this, hrc, 1 /*hrc exception*/,*aProductId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PRODUCTID_RETURN(this, hrc, 9 /*unhandled exception*/,*aProductId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProductId=%RU16 hrc=%Rhrc\n", this, "USBDevice::getProductId", *aProductId, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(Revision)(USHORT *aRevision)
{
    LogRelFlow(("{%p} %s: enter aRevision=%p\n", this, "USBDevice::getRevision", aRevision));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRevision);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_REVISION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRevision(aRevision);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_REVISION_RETURN(this, hrc, 0 /*normal*/,*aRevision);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_REVISION_RETURN(this, hrc, 1 /*hrc exception*/,*aRevision);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_REVISION_RETURN(this, hrc, 9 /*unhandled exception*/,*aRevision);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRevision=%RU16 hrc=%Rhrc\n", this, "USBDevice::getRevision", *aRevision, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(Manufacturer)(BSTR *aManufacturer)
{
    LogRelFlow(("{%p} %s: enter aManufacturer=%p\n", this, "USBDevice::getManufacturer", aManufacturer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aManufacturer);
        BSTROutConverter TmpManufacturer(aManufacturer);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_MANUFACTURER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getManufacturer(TmpManufacturer.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_MANUFACTURER_RETURN(this, hrc, 0 /*normal*/,TmpManufacturer.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_MANUFACTURER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_MANUFACTURER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aManufacturer=%ls hrc=%Rhrc\n", this, "USBDevice::getManufacturer", *aManufacturer, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(Product)(BSTR *aProduct)
{
    LogRelFlow(("{%p} %s: enter aProduct=%p\n", this, "USBDevice::getProduct", aProduct));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProduct);
        BSTROutConverter TmpProduct(aProduct);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PRODUCT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProduct(TmpProduct.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PRODUCT_RETURN(this, hrc, 0 /*normal*/,TmpProduct.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PRODUCT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PRODUCT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProduct=%ls hrc=%Rhrc\n", this, "USBDevice::getProduct", *aProduct, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(SerialNumber)(BSTR *aSerialNumber)
{
    LogRelFlow(("{%p} %s: enter aSerialNumber=%p\n", this, "USBDevice::getSerialNumber", aSerialNumber));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSerialNumber);
        BSTROutConverter TmpSerialNumber(aSerialNumber);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_SERIALNUMBER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSerialNumber(TmpSerialNumber.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_SERIALNUMBER_RETURN(this, hrc, 0 /*normal*/,TmpSerialNumber.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_SERIALNUMBER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_SERIALNUMBER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSerialNumber=%ls hrc=%Rhrc\n", this, "USBDevice::getSerialNumber", *aSerialNumber, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(Address)(BSTR *aAddress)
{
    LogRelFlow(("{%p} %s: enter aAddress=%p\n", this, "USBDevice::getAddress", aAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAddress);
        BSTROutConverter TmpAddress(aAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_ADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAddress(TmpAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_ADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_ADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_ADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAddress=%ls hrc=%Rhrc\n", this, "USBDevice::getAddress", *aAddress, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(Port)(USHORT *aPort)
{
    LogRelFlow(("{%p} %s: enter aPort=%p\n", this, "USBDevice::getPort", aPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPort);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PORT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPort(aPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PORT_RETURN(this, hrc, 0 /*normal*/,*aPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PORT_RETURN(this, hrc, 1 /*hrc exception*/,*aPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PORT_RETURN(this, hrc, 9 /*unhandled exception*/,*aPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPort=%RU16 hrc=%Rhrc\n", this, "USBDevice::getPort", *aPort, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(PortPath)(BSTR *aPortPath)
{
    LogRelFlow(("{%p} %s: enter aPortPath=%p\n", this, "USBDevice::getPortPath", aPortPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPortPath);
        BSTROutConverter TmpPortPath(aPortPath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PORTPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPortPath(TmpPortPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PORTPATH_RETURN(this, hrc, 0 /*normal*/,TmpPortPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PORTPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_PORTPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPortPath=%ls hrc=%Rhrc\n", this, "USBDevice::getPortPath", *aPortPath, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(Version)(USHORT *aVersion)
{
    LogRelFlow(("{%p} %s: enter aVersion=%p\n", this, "USBDevice::getVersion", aVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVersion);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_VERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVersion(aVersion);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_VERSION_RETURN(this, hrc, 0 /*normal*/,*aVersion);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_VERSION_RETURN(this, hrc, 1 /*hrc exception*/,*aVersion);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_VERSION_RETURN(this, hrc, 9 /*unhandled exception*/,*aVersion);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVersion=%RU16 hrc=%Rhrc\n", this, "USBDevice::getVersion", *aVersion, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(Speed)(USBConnectionSpeed_T *aSpeed)
{
    LogRelFlow(("{%p} %s: enter aSpeed=%p\n", this, "USBDevice::getSpeed", aSpeed));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSpeed);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_SPEED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSpeed(aSpeed);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_SPEED_RETURN(this, hrc, 0 /*normal*/,*aSpeed);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_SPEED_RETURN(this, hrc, 1 /*hrc exception*/,*aSpeed);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_SPEED_RETURN(this, hrc, 9 /*unhandled exception*/,*aSpeed);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSpeed=%RU32 hrc=%Rhrc\n", this, "USBDevice::getSpeed", *aSpeed, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(Remote)(BOOL *aRemote)
{
    LogRelFlow(("{%p} %s: enter aRemote=%p\n", this, "USBDevice::getRemote", aRemote));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRemote);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_REMOTE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRemote(aRemote);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_REMOTE_RETURN(this, hrc, 0 /*normal*/,*aRemote != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_REMOTE_RETURN(this, hrc, 1 /*hrc exception*/,*aRemote != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_REMOTE_RETURN(this, hrc, 9 /*unhandled exception*/,*aRemote != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRemote=%RTbool hrc=%Rhrc\n", this, "USBDevice::getRemote", *aRemote, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(DeviceInfo)(ComSafeArrayOut(BSTR, aDeviceInfo))
{
    LogRelFlow(("{%p} %s: enter aDeviceInfo=%p\n", this, "USBDevice::getDeviceInfo", aDeviceInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDeviceInfo);
        ArrayBSTROutConverter TmpDeviceInfo(ComSafeArrayOutArg(aDeviceInfo));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_DEVICEINFO_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDeviceInfo(TmpDeviceInfo.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_DEVICEINFO_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDeviceInfo.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_DEVICEINFO_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_DEVICEINFO_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDeviceInfo=%zu hrc=%Rhrc\n", this, "USBDevice::getDeviceInfo", ComSafeArraySize(*aDeviceInfo), hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(Backend)(BSTR *aBackend)
{
    LogRelFlow(("{%p} %s: enter aBackend=%p\n", this, "USBDevice::getBackend", aBackend));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBackend);
        BSTROutConverter TmpBackend(aBackend);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_BACKEND_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBackend(TmpBackend.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_BACKEND_RETURN(this, hrc, 0 /*normal*/,TmpBackend.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_BACKEND_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_USBDEVICE_GET_BACKEND_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBackend=%ls hrc=%Rhrc\n", this, "USBDevice::getBackend", *aBackend, hrc));
    return hrc;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(InternalAndReservedAttribute1IUSBDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(InternalAndReservedAttribute2IUSBDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(InternalAndReservedAttribute3IUSBDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP USBDeviceWrap::COMGETTER(InternalAndReservedAttribute4IUSBDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IUSBDevice methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(USBDeviceWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(USBDeviceWrap, IUSBDevice)
#endif // VBOX_WITH_XPCOM
