/** @file
 * VirtualBox API class wrapper code for IHostX86.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_HOSTX86

#include "HostX86Wrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(HostX86Wrap)

//
// IHostX86 properties
//

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute1IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute2IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute3IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute4IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute5IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute6IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute7IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute8IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute9IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute10IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute11IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::COMGETTER(InternalAndReservedAttribute12IHostX86)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IHostX86 methods
//

STDMETHODIMP HostX86Wrap::GetProcessorCPUIDLeaf(ULONG aCpuId,
                                                ULONG aLeaf,
                                                ULONG aSubLeaf,
                                                ULONG *aValEax,
                                                ULONG *aValEbx,
                                                ULONG *aValEcx,
                                                ULONG *aValEdx)
{
    LogRelFlow(("{%p} %s: enter aCpuId=%RU32 aLeaf=%RU32 aSubLeaf=%RU32 aValEax=%p aValEbx=%p aValEcx=%p aValEdx=%p\n", this, "HostX86::getProcessorCPUIDLeaf", aCpuId, aLeaf, aSubLeaf, aValEax, aValEbx, aValEcx, aValEdx));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValEax);
        CheckComArgOutPointerValidThrow(aValEbx);
        CheckComArgOutPointerValidThrow(aValEcx);
        CheckComArgOutPointerValidThrow(aValEdx);


        
        
        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTX86_GETPROCESSORCPUIDLEAF_ENTER(this, aCpuId, aLeaf, aSubLeaf);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcessorCPUIDLeaf(aCpuId,
                                        aLeaf,
                                        aSubLeaf,
                                        aValEax,
                                        aValEbx,
                                        aValEcx,
                                        aValEdx);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTX86_GETPROCESSORCPUIDLEAF_RETURN(this, hrc, 0 /*normal*/, aCpuId, aLeaf, aSubLeaf, *aValEax, *aValEbx, *aValEcx, *aValEdx);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTX86_GETPROCESSORCPUIDLEAF_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, aLeaf, aSubLeaf, *aValEax, *aValEbx, *aValEcx, *aValEdx);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTX86_GETPROCESSORCPUIDLEAF_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, aLeaf, aSubLeaf, *aValEax, *aValEbx, *aValEcx, *aValEdx);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValEax=%RU32 *aValEbx=%RU32 *aValEcx=%RU32 *aValEdx=%RU32 hrc=%Rhrc\n", this, "HostX86::getProcessorCPUIDLeaf", *aValEax, *aValEbx, *aValEcx, *aValEdx, hrc));
    return hrc;
}

STDMETHODIMP HostX86Wrap::InternalAndReservedMethod1IHostX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::InternalAndReservedMethod2IHostX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::InternalAndReservedMethod3IHostX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::InternalAndReservedMethod4IHostX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::InternalAndReservedMethod5IHostX86()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostX86Wrap::InternalAndReservedMethod6IHostX86()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostX86Wrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(HostX86Wrap, IHostX86)
#endif // VBOX_WITH_XPCOM
