/** @file VBoxEvents.cpp
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator:      src/VBox/Main/idl/comimpl.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */


#define LOG_GROUP LOG_GROUP_MAIN_EVENT
#include <VBox/com/array.h>
#include <VBox/log.h>
#include <iprt/asm.h>
#include "VBoxEvents.h"

// IMachineStateChangedEvent implementation code
class ATL_NO_VTABLE MachineStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IMachineStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(MachineStateChangedEvent, IMachineStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(MachineStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(MachineStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IMachineStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IMachineStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IMachineStateChangedEvent)
        COM_INTERFACE_ENTRY(IMachineStateChangedEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    MachineStateChangedEvent() { Log12(("MachineStateChangedEvent %p\n", this)); }
    virtual ~MachineStateChangedEvent() { Log12(("~MachineStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute state
private:
    MachineState_T    m_state;
public:
    STDMETHOD(COMGETTER(State))(MachineState_T * a_state) RT_OVERRIDE
    {
        *a_state = m_state;
        return S_OK;
    }
    // purely internal setter
    inline void set_state(MachineState_T a_state)
    {
         m_state = a_state;
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MachineStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(MachineStateChangedEvent, IMachineStateChangedEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateMachineStateChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, MachineState_T a_state)
{
    ComObjPtr<MachineStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnMachineStateChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        EvtObj->set_state(a_state);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireMachineStateChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, MachineState_T a_state)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateMachineStateChangedEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_state);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IExtPackInstalledEvent implementation code
class ATL_NO_VTABLE ExtPackInstalledEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IExtPackInstalledEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ExtPackInstalledEvent, IExtPackInstalledEvent)
    DECLARE_NOT_AGGREGATABLE(ExtPackInstalledEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ExtPackInstalledEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IExtPackInstalledEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IExtPackInstalledEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IExtPackInstalledEvent)
        COM_INTERFACE_ENTRY(IExtPackInstalledEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ExtPackInstalledEvent() { Log12(("ExtPackInstalledEvent %p\n", this)); }
    virtual ~ExtPackInstalledEvent() { Log12(("~ExtPackInstalledEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute name
private:
    Utf8Str    m_name;
public:
    STDMETHOD(COMGETTER(Name))(BSTR * a_name) RT_OVERRIDE
    {
        return m_name.cloneToEx(a_name);
    }
    // purely internal setter
    inline HRESULT set_name(const Utf8Str &a_rString)
    {
        return m_name.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ExtPackInstalledEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ExtPackInstalledEvent, IExtPackInstalledEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateExtPackInstalledEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_name)
{
    ComObjPtr<ExtPackInstalledEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnExtPackInstalled, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_name(a_name);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireExtPackInstalledEvent(IEventSource *aSource, const Utf8Str & a_name)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateExtPackInstalledEvent(ptrEvent.asOutParam(), aSource, a_name);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IExtPackUninstalledEvent implementation code
class ATL_NO_VTABLE ExtPackUninstalledEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IExtPackUninstalledEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ExtPackUninstalledEvent, IExtPackUninstalledEvent)
    DECLARE_NOT_AGGREGATABLE(ExtPackUninstalledEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ExtPackUninstalledEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IExtPackUninstalledEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IExtPackUninstalledEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IExtPackUninstalledEvent)
        COM_INTERFACE_ENTRY(IExtPackUninstalledEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ExtPackUninstalledEvent() { Log12(("ExtPackUninstalledEvent %p\n", this)); }
    virtual ~ExtPackUninstalledEvent() { Log12(("~ExtPackUninstalledEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute name
private:
    Utf8Str    m_name;
public:
    STDMETHOD(COMGETTER(Name))(BSTR * a_name) RT_OVERRIDE
    {
        return m_name.cloneToEx(a_name);
    }
    // purely internal setter
    inline HRESULT set_name(const Utf8Str &a_rString)
    {
        return m_name.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ExtPackUninstalledEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ExtPackUninstalledEvent, IExtPackUninstalledEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateExtPackUninstalledEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_name)
{
    ComObjPtr<ExtPackUninstalledEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnExtPackUninstalled, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_name(a_name);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireExtPackUninstalledEvent(IEventSource *aSource, const Utf8Str & a_name)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateExtPackUninstalledEvent(ptrEvent.asOutParam(), aSource, a_name);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IMachineDataChangedEvent implementation code
class ATL_NO_VTABLE MachineDataChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IMachineDataChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(MachineDataChangedEvent, IMachineDataChangedEvent)
    DECLARE_NOT_AGGREGATABLE(MachineDataChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(MachineDataChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IMachineDataChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IMachineDataChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IMachineDataChangedEvent)
        COM_INTERFACE_ENTRY(IMachineDataChangedEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    MachineDataChangedEvent() { Log12(("MachineDataChangedEvent %p\n", this)); }
    virtual ~MachineDataChangedEvent() { Log12(("~MachineDataChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute temporary
private:
    BOOL    m_temporary;
public:
    STDMETHOD(COMGETTER(Temporary))(BOOL * a_temporary) RT_OVERRIDE
    {
        *a_temporary = m_temporary;
        return S_OK;
    }
    // purely internal setter
    inline void set_temporary(BOOL a_temporary)
    {
         m_temporary = a_temporary;
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MachineDataChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(MachineDataChangedEvent, IMachineDataChangedEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateMachineDataChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_temporary)
{
    ComObjPtr<MachineDataChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnMachineDataChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        EvtObj->set_temporary(a_temporary);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireMachineDataChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_temporary)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateMachineDataChangedEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_temporary);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IMediumRegisteredEvent implementation code
class ATL_NO_VTABLE MediumRegisteredEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IMediumRegisteredEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(MediumRegisteredEvent, IMediumRegisteredEvent)
    DECLARE_NOT_AGGREGATABLE(MediumRegisteredEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(MediumRegisteredEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IMediumRegisteredEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IMediumRegisteredEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IMediumRegisteredEvent)
        COM_INTERFACE_ENTRY(IMediumRegisteredEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    MediumRegisteredEvent() { Log12(("MediumRegisteredEvent %p\n", this)); }
    virtual ~MediumRegisteredEvent() { Log12(("~MediumRegisteredEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute mediumId
private:
    Utf8Str    m_mediumId;
public:
    STDMETHOD(COMGETTER(MediumId))(BSTR * a_mediumId) RT_OVERRIDE
    {
        return m_mediumId.cloneToEx(a_mediumId);
    }
    // purely internal setter
    inline HRESULT set_mediumId(const Utf8Str &a_rString)
    {
        return m_mediumId.assignEx(a_rString);
    }

    // attribute mediumType
private:
    DeviceType_T    m_mediumType;
public:
    STDMETHOD(COMGETTER(MediumType))(DeviceType_T * a_mediumType) RT_OVERRIDE
    {
        *a_mediumType = m_mediumType;
        return S_OK;
    }
    // purely internal setter
    inline void set_mediumType(DeviceType_T a_mediumType)
    {
         m_mediumType = a_mediumType;
    }

    // attribute registered
private:
    BOOL    m_registered;
public:
    STDMETHOD(COMGETTER(Registered))(BOOL * a_registered) RT_OVERRIDE
    {
        *a_registered = m_registered;
        return S_OK;
    }
    // purely internal setter
    inline void set_registered(BOOL a_registered)
    {
         m_registered = a_registered;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MediumRegisteredEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(MediumRegisteredEvent, IMediumRegisteredEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateMediumRegisteredEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_mediumId, DeviceType_T a_mediumType, BOOL a_registered)
{
    ComObjPtr<MediumRegisteredEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnMediumRegistered, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_mediumId(a_mediumId);
        EvtObj->set_mediumType(a_mediumType);
        EvtObj->set_registered(a_registered);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireMediumRegisteredEvent(IEventSource *aSource, const Utf8Str & a_mediumId, DeviceType_T a_mediumType, BOOL a_registered)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateMediumRegisteredEvent(ptrEvent.asOutParam(), aSource, a_mediumId, a_mediumType, a_registered);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IMediumConfigChangedEvent implementation code
class ATL_NO_VTABLE MediumConfigChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IMediumConfigChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(MediumConfigChangedEvent, IMediumConfigChangedEvent)
    DECLARE_NOT_AGGREGATABLE(MediumConfigChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(MediumConfigChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IMediumConfigChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IMediumConfigChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IMediumConfigChangedEvent)
        COM_INTERFACE_ENTRY(IMediumConfigChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    MediumConfigChangedEvent() { Log12(("MediumConfigChangedEvent %p\n", this)); }
    virtual ~MediumConfigChangedEvent() { Log12(("~MediumConfigChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute medium
private:
    ComPtr<IMedium>    m_medium;
public:
    STDMETHOD(COMGETTER(Medium))(IMedium * * a_medium) RT_OVERRIDE
    {
        return m_medium.queryInterfaceTo(a_medium);
    }
    // purely internal setter
    inline void set_medium(IMedium * a_medium)
    {
         m_medium = a_medium;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MediumConfigChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(MediumConfigChangedEvent, IMediumConfigChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateMediumConfigChangedEvent(IEvent **aEvent, IEventSource *aSource, IMedium * a_medium)
{
    ComObjPtr<MediumConfigChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnMediumConfigChanged, FALSE /*waitable*/);
        EvtObj->set_medium(a_medium);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireMediumConfigChangedEvent(IEventSource *aSource, IMedium * a_medium)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateMediumConfigChangedEvent(ptrEvent.asOutParam(), aSource, a_medium);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IMachineRegisteredEvent implementation code
class ATL_NO_VTABLE MachineRegisteredEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IMachineRegisteredEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(MachineRegisteredEvent, IMachineRegisteredEvent)
    DECLARE_NOT_AGGREGATABLE(MachineRegisteredEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(MachineRegisteredEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IMachineRegisteredEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IMachineRegisteredEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IMachineRegisteredEvent)
        COM_INTERFACE_ENTRY(IMachineRegisteredEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    MachineRegisteredEvent() { Log12(("MachineRegisteredEvent %p\n", this)); }
    virtual ~MachineRegisteredEvent() { Log12(("~MachineRegisteredEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute registered
private:
    BOOL    m_registered;
public:
    STDMETHOD(COMGETTER(Registered))(BOOL * a_registered) RT_OVERRIDE
    {
        *a_registered = m_registered;
        return S_OK;
    }
    // purely internal setter
    inline void set_registered(BOOL a_registered)
    {
         m_registered = a_registered;
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MachineRegisteredEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(MachineRegisteredEvent, IMachineRegisteredEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateMachineRegisteredEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_registered)
{
    ComObjPtr<MachineRegisteredEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnMachineRegistered, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        EvtObj->set_registered(a_registered);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireMachineRegisteredEvent(IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_registered)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateMachineRegisteredEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_registered);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ISessionStateChangedEvent implementation code
class ATL_NO_VTABLE SessionStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ISessionStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(SessionStateChangedEvent, ISessionStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(SessionStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(SessionStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ISessionStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ISessionStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ISessionStateChangedEvent)
        COM_INTERFACE_ENTRY(ISessionStateChangedEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    SessionStateChangedEvent() { Log12(("SessionStateChangedEvent %p\n", this)); }
    virtual ~SessionStateChangedEvent() { Log12(("~SessionStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute state
private:
    SessionState_T    m_state;
public:
    STDMETHOD(COMGETTER(State))(SessionState_T * a_state) RT_OVERRIDE
    {
        *a_state = m_state;
        return S_OK;
    }
    // purely internal setter
    inline void set_state(SessionState_T a_state)
    {
         m_state = a_state;
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SessionStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(SessionStateChangedEvent, ISessionStateChangedEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateSessionStateChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, SessionState_T a_state)
{
    ComObjPtr<SessionStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnSessionStateChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        EvtObj->set_state(a_state);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireSessionStateChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, SessionState_T a_state)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateSessionStateChangedEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_state);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestPropertyChangedEvent implementation code
class ATL_NO_VTABLE GuestPropertyChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestPropertyChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestPropertyChangedEvent, IGuestPropertyChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestPropertyChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestPropertyChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestPropertyChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestPropertyChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestPropertyChangedEvent)
        COM_INTERFACE_ENTRY(IGuestPropertyChangedEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestPropertyChangedEvent() { Log12(("GuestPropertyChangedEvent %p\n", this)); }
    virtual ~GuestPropertyChangedEvent() { Log12(("~GuestPropertyChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute name
private:
    Utf8Str    m_name;
public:
    STDMETHOD(COMGETTER(Name))(BSTR * a_name) RT_OVERRIDE
    {
        return m_name.cloneToEx(a_name);
    }
    // purely internal setter
    inline HRESULT set_name(const Utf8Str &a_rString)
    {
        return m_name.assignEx(a_rString);
    }

    // attribute value
private:
    Utf8Str    m_value;
public:
    STDMETHOD(COMGETTER(Value))(BSTR * a_value) RT_OVERRIDE
    {
        return m_value.cloneToEx(a_value);
    }
    // purely internal setter
    inline HRESULT set_value(const Utf8Str &a_rString)
    {
        return m_value.assignEx(a_rString);
    }

    // attribute flags
private:
    Utf8Str    m_flags;
public:
    STDMETHOD(COMGETTER(Flags))(BSTR * a_flags) RT_OVERRIDE
    {
        return m_flags.cloneToEx(a_flags);
    }
    // purely internal setter
    inline HRESULT set_flags(const Utf8Str &a_rString)
    {
        return m_flags.assignEx(a_rString);
    }

    // attribute fWasDeleted
private:
    BOOL    m_fWasDeleted;
public:
    STDMETHOD(COMGETTER(FWasDeleted))(BOOL * a_fWasDeleted) RT_OVERRIDE
    {
        *a_fWasDeleted = m_fWasDeleted;
        return S_OK;
    }
    // purely internal setter
    inline void set_fWasDeleted(BOOL a_fWasDeleted)
    {
         m_fWasDeleted = a_fWasDeleted;
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestPropertyChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(GuestPropertyChangedEvent, IGuestPropertyChangedEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestPropertyChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_name, const Utf8Str & a_value, const Utf8Str & a_flags, BOOL a_fWasDeleted)
{
    ComObjPtr<GuestPropertyChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestPropertyChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_name(a_name);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_value(a_value);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_flags(a_flags);
        EvtObj->set_fWasDeleted(a_fWasDeleted);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestPropertyChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_name, const Utf8Str & a_value, const Utf8Str & a_flags, BOOL a_fWasDeleted)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestPropertyChangedEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_name, a_value, a_flags, a_fWasDeleted);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ISnapshotTakenEvent implementation code
class ATL_NO_VTABLE SnapshotTakenEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ISnapshotTakenEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(SnapshotTakenEvent, ISnapshotTakenEvent)
    DECLARE_NOT_AGGREGATABLE(SnapshotTakenEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(SnapshotTakenEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ISnapshotTakenEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ISnapshotTakenEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ISnapshotTakenEvent)
        COM_INTERFACE_ENTRY(ISnapshotTakenEvent)
        COM_INTERFACE_ENTRY(ISnapshotEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    SnapshotTakenEvent() { Log12(("SnapshotTakenEvent %p\n", this)); }
    virtual ~SnapshotTakenEvent() { Log12(("~SnapshotTakenEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute snapshotId
private:
    Utf8Str    m_snapshotId;
public:
    STDMETHOD(COMGETTER(SnapshotId))(BSTR * a_snapshotId) RT_OVERRIDE
    {
        return m_snapshotId.cloneToEx(a_snapshotId);
    }
    // purely internal setter
    inline HRESULT set_snapshotId(const Utf8Str &a_rString)
    {
        return m_snapshotId.assignEx(a_rString);
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SnapshotTakenEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(SnapshotTakenEvent, ISnapshotTakenEvent, ISnapshotEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateSnapshotTakenEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId)
{
    ComObjPtr<SnapshotTakenEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnSnapshotTaken, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_snapshotId(a_snapshotId);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireSnapshotTakenEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateSnapshotTakenEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_snapshotId);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ISnapshotDeletedEvent implementation code
class ATL_NO_VTABLE SnapshotDeletedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ISnapshotDeletedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(SnapshotDeletedEvent, ISnapshotDeletedEvent)
    DECLARE_NOT_AGGREGATABLE(SnapshotDeletedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(SnapshotDeletedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ISnapshotDeletedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ISnapshotDeletedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ISnapshotDeletedEvent)
        COM_INTERFACE_ENTRY(ISnapshotDeletedEvent)
        COM_INTERFACE_ENTRY(ISnapshotEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    SnapshotDeletedEvent() { Log12(("SnapshotDeletedEvent %p\n", this)); }
    virtual ~SnapshotDeletedEvent() { Log12(("~SnapshotDeletedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute snapshotId
private:
    Utf8Str    m_snapshotId;
public:
    STDMETHOD(COMGETTER(SnapshotId))(BSTR * a_snapshotId) RT_OVERRIDE
    {
        return m_snapshotId.cloneToEx(a_snapshotId);
    }
    // purely internal setter
    inline HRESULT set_snapshotId(const Utf8Str &a_rString)
    {
        return m_snapshotId.assignEx(a_rString);
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SnapshotDeletedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(SnapshotDeletedEvent, ISnapshotDeletedEvent, ISnapshotEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateSnapshotDeletedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId)
{
    ComObjPtr<SnapshotDeletedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnSnapshotDeleted, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_snapshotId(a_snapshotId);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireSnapshotDeletedEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateSnapshotDeletedEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_snapshotId);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ISnapshotRestoredEvent implementation code
class ATL_NO_VTABLE SnapshotRestoredEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ISnapshotRestoredEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(SnapshotRestoredEvent, ISnapshotRestoredEvent)
    DECLARE_NOT_AGGREGATABLE(SnapshotRestoredEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(SnapshotRestoredEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ISnapshotRestoredEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ISnapshotRestoredEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ISnapshotRestoredEvent)
        COM_INTERFACE_ENTRY(ISnapshotRestoredEvent)
        COM_INTERFACE_ENTRY(ISnapshotEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    SnapshotRestoredEvent() { Log12(("SnapshotRestoredEvent %p\n", this)); }
    virtual ~SnapshotRestoredEvent() { Log12(("~SnapshotRestoredEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute snapshotId
private:
    Utf8Str    m_snapshotId;
public:
    STDMETHOD(COMGETTER(SnapshotId))(BSTR * a_snapshotId) RT_OVERRIDE
    {
        return m_snapshotId.cloneToEx(a_snapshotId);
    }
    // purely internal setter
    inline HRESULT set_snapshotId(const Utf8Str &a_rString)
    {
        return m_snapshotId.assignEx(a_rString);
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SnapshotRestoredEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(SnapshotRestoredEvent, ISnapshotRestoredEvent, ISnapshotEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateSnapshotRestoredEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId)
{
    ComObjPtr<SnapshotRestoredEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnSnapshotRestored, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_snapshotId(a_snapshotId);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireSnapshotRestoredEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateSnapshotRestoredEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_snapshotId);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ISnapshotChangedEvent implementation code
class ATL_NO_VTABLE SnapshotChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ISnapshotChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(SnapshotChangedEvent, ISnapshotChangedEvent)
    DECLARE_NOT_AGGREGATABLE(SnapshotChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(SnapshotChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ISnapshotChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ISnapshotChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ISnapshotChangedEvent)
        COM_INTERFACE_ENTRY(ISnapshotChangedEvent)
        COM_INTERFACE_ENTRY(ISnapshotEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    SnapshotChangedEvent() { Log12(("SnapshotChangedEvent %p\n", this)); }
    virtual ~SnapshotChangedEvent() { Log12(("~SnapshotChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute snapshotId
private:
    Utf8Str    m_snapshotId;
public:
    STDMETHOD(COMGETTER(SnapshotId))(BSTR * a_snapshotId) RT_OVERRIDE
    {
        return m_snapshotId.cloneToEx(a_snapshotId);
    }
    // purely internal setter
    inline HRESULT set_snapshotId(const Utf8Str &a_rString)
    {
        return m_snapshotId.assignEx(a_rString);
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SnapshotChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(SnapshotChangedEvent, ISnapshotChangedEvent, ISnapshotEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateSnapshotChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId)
{
    ComObjPtr<SnapshotChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnSnapshotChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_snapshotId(a_snapshotId);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireSnapshotChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_snapshotId)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateSnapshotChangedEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_snapshotId);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IMousePointerShapeChangedEvent implementation code
class ATL_NO_VTABLE MousePointerShapeChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IMousePointerShapeChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(MousePointerShapeChangedEvent, IMousePointerShapeChangedEvent)
    DECLARE_NOT_AGGREGATABLE(MousePointerShapeChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(MousePointerShapeChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IMousePointerShapeChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IMousePointerShapeChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IMousePointerShapeChangedEvent)
        COM_INTERFACE_ENTRY(IMousePointerShapeChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    MousePointerShapeChangedEvent() { Log12(("MousePointerShapeChangedEvent %p\n", this)); }
    virtual ~MousePointerShapeChangedEvent() { Log12(("~MousePointerShapeChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute visible
private:
    BOOL    m_visible;
public:
    STDMETHOD(COMGETTER(Visible))(BOOL * a_visible) RT_OVERRIDE
    {
        *a_visible = m_visible;
        return S_OK;
    }
    // purely internal setter
    inline void set_visible(BOOL a_visible)
    {
         m_visible = a_visible;
    }

    // attribute alpha
private:
    BOOL    m_alpha;
public:
    STDMETHOD(COMGETTER(Alpha))(BOOL * a_alpha) RT_OVERRIDE
    {
        *a_alpha = m_alpha;
        return S_OK;
    }
    // purely internal setter
    inline void set_alpha(BOOL a_alpha)
    {
         m_alpha = a_alpha;
    }

    // attribute xhot
private:
    ULONG    m_xhot;
public:
    STDMETHOD(COMGETTER(Xhot))(ULONG * a_xhot) RT_OVERRIDE
    {
        *a_xhot = m_xhot;
        return S_OK;
    }
    // purely internal setter
    inline void set_xhot(ULONG a_xhot)
    {
         m_xhot = a_xhot;
    }

    // attribute yhot
private:
    ULONG    m_yhot;
public:
    STDMETHOD(COMGETTER(Yhot))(ULONG * a_yhot) RT_OVERRIDE
    {
        *a_yhot = m_yhot;
        return S_OK;
    }
    // purely internal setter
    inline void set_yhot(ULONG a_yhot)
    {
         m_yhot = a_yhot;
    }

    // attribute width
private:
    ULONG    m_width;
public:
    STDMETHOD(COMGETTER(Width))(ULONG * a_width) RT_OVERRIDE
    {
        *a_width = m_width;
        return S_OK;
    }
    // purely internal setter
    inline void set_width(ULONG a_width)
    {
         m_width = a_width;
    }

    // attribute height
private:
    ULONG    m_height;
public:
    STDMETHOD(COMGETTER(Height))(ULONG * a_height) RT_OVERRIDE
    {
        *a_height = m_height;
        return S_OK;
    }
    // purely internal setter
    inline void set_height(ULONG a_height)
    {
         m_height = a_height;
    }

    // attribute shape
private:
    com::SafeArray<BYTE>    m_shape;
public:
    STDMETHOD(COMGETTER(Shape))(ComSafeArrayOut(BYTE, a_shape)) RT_OVERRIDE
    {
        SafeArray<BYTE> result;
        HRESULT hrc = m_shape.cloneTo(result);
        if (SUCCEEDED(hrc))
            result.detachTo(ComSafeArrayOutArg(a_shape));
        return hrc;
    }
    // purely internal setter
    inline HRESULT set_shape(ComSafeArrayIn(BYTE,a_shape))
    {
        SafeArray<BYTE> aArr(ComSafeArrayInArg(a_shape));
        return m_shape.initFrom(aArr);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MousePointerShapeChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(MousePointerShapeChangedEvent, IMousePointerShapeChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateMousePointerShapeChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_visible, BOOL a_alpha, ULONG a_xhot, ULONG a_yhot, ULONG a_width, ULONG a_height, ComSafeArrayIn(BYTE,a_shape))
{
    ComObjPtr<MousePointerShapeChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnMousePointerShapeChanged, FALSE /*waitable*/);
        EvtObj->set_visible(a_visible);
        EvtObj->set_alpha(a_alpha);
        EvtObj->set_xhot(a_xhot);
        EvtObj->set_yhot(a_yhot);
        EvtObj->set_width(a_width);
        EvtObj->set_height(a_height);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_shape(ComSafeArrayInArg(a_shape));
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireMousePointerShapeChangedEvent(IEventSource *aSource, BOOL a_visible, BOOL a_alpha, ULONG a_xhot, ULONG a_yhot, ULONG a_width, ULONG a_height, ComSafeArrayIn(BYTE,a_shape))
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateMousePointerShapeChangedEvent(ptrEvent.asOutParam(), aSource, a_visible, a_alpha, a_xhot, a_yhot, a_width, a_height, ComSafeArrayInArg(a_shape));
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IMouseCapabilityChangedEvent implementation code
class ATL_NO_VTABLE MouseCapabilityChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IMouseCapabilityChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(MouseCapabilityChangedEvent, IMouseCapabilityChangedEvent)
    DECLARE_NOT_AGGREGATABLE(MouseCapabilityChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(MouseCapabilityChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IMouseCapabilityChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IMouseCapabilityChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IMouseCapabilityChangedEvent)
        COM_INTERFACE_ENTRY(IMouseCapabilityChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    MouseCapabilityChangedEvent() { Log12(("MouseCapabilityChangedEvent %p\n", this)); }
    virtual ~MouseCapabilityChangedEvent() { Log12(("~MouseCapabilityChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute supportsAbsolute
private:
    BOOL    m_supportsAbsolute;
public:
    STDMETHOD(COMGETTER(SupportsAbsolute))(BOOL * a_supportsAbsolute) RT_OVERRIDE
    {
        *a_supportsAbsolute = m_supportsAbsolute;
        return S_OK;
    }
    // purely internal setter
    inline void set_supportsAbsolute(BOOL a_supportsAbsolute)
    {
         m_supportsAbsolute = a_supportsAbsolute;
    }

    // attribute supportsRelative
private:
    BOOL    m_supportsRelative;
public:
    STDMETHOD(COMGETTER(SupportsRelative))(BOOL * a_supportsRelative) RT_OVERRIDE
    {
        *a_supportsRelative = m_supportsRelative;
        return S_OK;
    }
    // purely internal setter
    inline void set_supportsRelative(BOOL a_supportsRelative)
    {
         m_supportsRelative = a_supportsRelative;
    }

    // attribute supportsTouchScreen
private:
    BOOL    m_supportsTouchScreen;
public:
    STDMETHOD(COMGETTER(SupportsTouchScreen))(BOOL * a_supportsTouchScreen) RT_OVERRIDE
    {
        *a_supportsTouchScreen = m_supportsTouchScreen;
        return S_OK;
    }
    // purely internal setter
    inline void set_supportsTouchScreen(BOOL a_supportsTouchScreen)
    {
         m_supportsTouchScreen = a_supportsTouchScreen;
    }

    // attribute supportsTouchPad
private:
    BOOL    m_supportsTouchPad;
public:
    STDMETHOD(COMGETTER(SupportsTouchPad))(BOOL * a_supportsTouchPad) RT_OVERRIDE
    {
        *a_supportsTouchPad = m_supportsTouchPad;
        return S_OK;
    }
    // purely internal setter
    inline void set_supportsTouchPad(BOOL a_supportsTouchPad)
    {
         m_supportsTouchPad = a_supportsTouchPad;
    }

    // attribute needsHostCursor
private:
    BOOL    m_needsHostCursor;
public:
    STDMETHOD(COMGETTER(NeedsHostCursor))(BOOL * a_needsHostCursor) RT_OVERRIDE
    {
        *a_needsHostCursor = m_needsHostCursor;
        return S_OK;
    }
    // purely internal setter
    inline void set_needsHostCursor(BOOL a_needsHostCursor)
    {
         m_needsHostCursor = a_needsHostCursor;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MouseCapabilityChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(MouseCapabilityChangedEvent, IMouseCapabilityChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateMouseCapabilityChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_supportsAbsolute, BOOL a_supportsRelative, BOOL a_supportsTouchScreen, BOOL a_supportsTouchPad, BOOL a_needsHostCursor)
{
    ComObjPtr<MouseCapabilityChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnMouseCapabilityChanged, FALSE /*waitable*/);
        EvtObj->set_supportsAbsolute(a_supportsAbsolute);
        EvtObj->set_supportsRelative(a_supportsRelative);
        EvtObj->set_supportsTouchScreen(a_supportsTouchScreen);
        EvtObj->set_supportsTouchPad(a_supportsTouchPad);
        EvtObj->set_needsHostCursor(a_needsHostCursor);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireMouseCapabilityChangedEvent(IEventSource *aSource, BOOL a_supportsAbsolute, BOOL a_supportsRelative, BOOL a_supportsTouchScreen, BOOL a_supportsTouchPad, BOOL a_needsHostCursor)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateMouseCapabilityChangedEvent(ptrEvent.asOutParam(), aSource, a_supportsAbsolute, a_supportsRelative, a_supportsTouchScreen, a_supportsTouchPad, a_needsHostCursor);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IKeyboardLedsChangedEvent implementation code
class ATL_NO_VTABLE KeyboardLedsChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IKeyboardLedsChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(KeyboardLedsChangedEvent, IKeyboardLedsChangedEvent)
    DECLARE_NOT_AGGREGATABLE(KeyboardLedsChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(KeyboardLedsChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IKeyboardLedsChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IKeyboardLedsChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IKeyboardLedsChangedEvent)
        COM_INTERFACE_ENTRY(IKeyboardLedsChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    KeyboardLedsChangedEvent() { Log12(("KeyboardLedsChangedEvent %p\n", this)); }
    virtual ~KeyboardLedsChangedEvent() { Log12(("~KeyboardLedsChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute numLock
private:
    BOOL    m_numLock;
public:
    STDMETHOD(COMGETTER(NumLock))(BOOL * a_numLock) RT_OVERRIDE
    {
        *a_numLock = m_numLock;
        return S_OK;
    }
    // purely internal setter
    inline void set_numLock(BOOL a_numLock)
    {
         m_numLock = a_numLock;
    }

    // attribute capsLock
private:
    BOOL    m_capsLock;
public:
    STDMETHOD(COMGETTER(CapsLock))(BOOL * a_capsLock) RT_OVERRIDE
    {
        *a_capsLock = m_capsLock;
        return S_OK;
    }
    // purely internal setter
    inline void set_capsLock(BOOL a_capsLock)
    {
         m_capsLock = a_capsLock;
    }

    // attribute scrollLock
private:
    BOOL    m_scrollLock;
public:
    STDMETHOD(COMGETTER(ScrollLock))(BOOL * a_scrollLock) RT_OVERRIDE
    {
        *a_scrollLock = m_scrollLock;
        return S_OK;
    }
    // purely internal setter
    inline void set_scrollLock(BOOL a_scrollLock)
    {
         m_scrollLock = a_scrollLock;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(KeyboardLedsChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(KeyboardLedsChangedEvent, IKeyboardLedsChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateKeyboardLedsChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_numLock, BOOL a_capsLock, BOOL a_scrollLock)
{
    ComObjPtr<KeyboardLedsChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnKeyboardLedsChanged, FALSE /*waitable*/);
        EvtObj->set_numLock(a_numLock);
        EvtObj->set_capsLock(a_capsLock);
        EvtObj->set_scrollLock(a_scrollLock);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireKeyboardLedsChangedEvent(IEventSource *aSource, BOOL a_numLock, BOOL a_capsLock, BOOL a_scrollLock)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateKeyboardLedsChangedEvent(ptrEvent.asOutParam(), aSource, a_numLock, a_capsLock, a_scrollLock);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IStateChangedEvent implementation code
class ATL_NO_VTABLE StateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(StateChangedEvent, IStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(StateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(StateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IStateChangedEvent)
        COM_INTERFACE_ENTRY(IStateChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    StateChangedEvent() { Log12(("StateChangedEvent %p\n", this)); }
    virtual ~StateChangedEvent() { Log12(("~StateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute state
private:
    MachineState_T    m_state;
public:
    STDMETHOD(COMGETTER(State))(MachineState_T * a_state) RT_OVERRIDE
    {
        *a_state = m_state;
        return S_OK;
    }
    // purely internal setter
    inline void set_state(MachineState_T a_state)
    {
         m_state = a_state;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(StateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(StateChangedEvent, IStateChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateStateChangedEvent(IEvent **aEvent, IEventSource *aSource, MachineState_T a_state)
{
    ComObjPtr<StateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnStateChanged, FALSE /*waitable*/);
        EvtObj->set_state(a_state);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireStateChangedEvent(IEventSource *aSource, MachineState_T a_state)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateStateChangedEvent(ptrEvent.asOutParam(), aSource, a_state);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IAdditionsStateChangedEvent implementation code
class ATL_NO_VTABLE AdditionsStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IAdditionsStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(AdditionsStateChangedEvent, IAdditionsStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(AdditionsStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(AdditionsStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IAdditionsStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IAdditionsStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IAdditionsStateChangedEvent)
        COM_INTERFACE_ENTRY(IAdditionsStateChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    AdditionsStateChangedEvent() { Log12(("AdditionsStateChangedEvent %p\n", this)); }
    virtual ~AdditionsStateChangedEvent() { Log12(("~AdditionsStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(AdditionsStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(AdditionsStateChangedEvent, IAdditionsStateChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateAdditionsStateChangedEvent(IEvent **aEvent, IEventSource *aSource)
{
    ComObjPtr<AdditionsStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnAdditionsStateChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireAdditionsStateChangedEvent(IEventSource *aSource)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateAdditionsStateChangedEvent(ptrEvent.asOutParam(), aSource);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// INetworkAdapterChangedEvent implementation code
class ATL_NO_VTABLE NetworkAdapterChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(INetworkAdapterChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(NetworkAdapterChangedEvent, INetworkAdapterChangedEvent)
    DECLARE_NOT_AGGREGATABLE(NetworkAdapterChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(NetworkAdapterChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(INetworkAdapterChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, INetworkAdapterChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(INetworkAdapterChangedEvent)
        COM_INTERFACE_ENTRY(INetworkAdapterChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    NetworkAdapterChangedEvent() { Log12(("NetworkAdapterChangedEvent %p\n", this)); }
    virtual ~NetworkAdapterChangedEvent() { Log12(("~NetworkAdapterChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute networkAdapter
private:
    ComPtr<INetworkAdapter>    m_networkAdapter;
public:
    STDMETHOD(COMGETTER(NetworkAdapter))(INetworkAdapter * * a_networkAdapter) RT_OVERRIDE
    {
        return m_networkAdapter.queryInterfaceTo(a_networkAdapter);
    }
    // purely internal setter
    inline void set_networkAdapter(INetworkAdapter * a_networkAdapter)
    {
         m_networkAdapter = a_networkAdapter;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NetworkAdapterChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(NetworkAdapterChangedEvent, INetworkAdapterChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateNetworkAdapterChangedEvent(IEvent **aEvent, IEventSource *aSource, INetworkAdapter * a_networkAdapter)
{
    ComObjPtr<NetworkAdapterChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnNetworkAdapterChanged, FALSE /*waitable*/);
        EvtObj->set_networkAdapter(a_networkAdapter);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireNetworkAdapterChangedEvent(IEventSource *aSource, INetworkAdapter * a_networkAdapter)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateNetworkAdapterChangedEvent(ptrEvent.asOutParam(), aSource, a_networkAdapter);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IAudioAdapterChangedEvent implementation code
class ATL_NO_VTABLE AudioAdapterChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IAudioAdapterChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(AudioAdapterChangedEvent, IAudioAdapterChangedEvent)
    DECLARE_NOT_AGGREGATABLE(AudioAdapterChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(AudioAdapterChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IAudioAdapterChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IAudioAdapterChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IAudioAdapterChangedEvent)
        COM_INTERFACE_ENTRY(IAudioAdapterChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    AudioAdapterChangedEvent() { Log12(("AudioAdapterChangedEvent %p\n", this)); }
    virtual ~AudioAdapterChangedEvent() { Log12(("~AudioAdapterChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute audioAdapter
private:
    ComPtr<IAudioAdapter>    m_audioAdapter;
public:
    STDMETHOD(COMGETTER(AudioAdapter))(IAudioAdapter * * a_audioAdapter) RT_OVERRIDE
    {
        return m_audioAdapter.queryInterfaceTo(a_audioAdapter);
    }
    // purely internal setter
    inline void set_audioAdapter(IAudioAdapter * a_audioAdapter)
    {
         m_audioAdapter = a_audioAdapter;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(AudioAdapterChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(AudioAdapterChangedEvent, IAudioAdapterChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateAudioAdapterChangedEvent(IEvent **aEvent, IEventSource *aSource, IAudioAdapter * a_audioAdapter)
{
    ComObjPtr<AudioAdapterChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnAudioAdapterChanged, FALSE /*waitable*/);
        EvtObj->set_audioAdapter(a_audioAdapter);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireAudioAdapterChangedEvent(IEventSource *aSource, IAudioAdapter * a_audioAdapter)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateAudioAdapterChangedEvent(ptrEvent.asOutParam(), aSource, a_audioAdapter);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ISerialPortChangedEvent implementation code
class ATL_NO_VTABLE SerialPortChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ISerialPortChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(SerialPortChangedEvent, ISerialPortChangedEvent)
    DECLARE_NOT_AGGREGATABLE(SerialPortChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(SerialPortChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ISerialPortChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ISerialPortChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ISerialPortChangedEvent)
        COM_INTERFACE_ENTRY(ISerialPortChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    SerialPortChangedEvent() { Log12(("SerialPortChangedEvent %p\n", this)); }
    virtual ~SerialPortChangedEvent() { Log12(("~SerialPortChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute serialPort
private:
    ComPtr<ISerialPort>    m_serialPort;
public:
    STDMETHOD(COMGETTER(SerialPort))(ISerialPort * * a_serialPort) RT_OVERRIDE
    {
        return m_serialPort.queryInterfaceTo(a_serialPort);
    }
    // purely internal setter
    inline void set_serialPort(ISerialPort * a_serialPort)
    {
         m_serialPort = a_serialPort;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SerialPortChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(SerialPortChangedEvent, ISerialPortChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateSerialPortChangedEvent(IEvent **aEvent, IEventSource *aSource, ISerialPort * a_serialPort)
{
    ComObjPtr<SerialPortChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnSerialPortChanged, FALSE /*waitable*/);
        EvtObj->set_serialPort(a_serialPort);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireSerialPortChangedEvent(IEventSource *aSource, ISerialPort * a_serialPort)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateSerialPortChangedEvent(ptrEvent.asOutParam(), aSource, a_serialPort);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IParallelPortChangedEvent implementation code
class ATL_NO_VTABLE ParallelPortChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IParallelPortChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ParallelPortChangedEvent, IParallelPortChangedEvent)
    DECLARE_NOT_AGGREGATABLE(ParallelPortChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ParallelPortChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IParallelPortChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IParallelPortChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IParallelPortChangedEvent)
        COM_INTERFACE_ENTRY(IParallelPortChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ParallelPortChangedEvent() { Log12(("ParallelPortChangedEvent %p\n", this)); }
    virtual ~ParallelPortChangedEvent() { Log12(("~ParallelPortChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute parallelPort
private:
    ComPtr<IParallelPort>    m_parallelPort;
public:
    STDMETHOD(COMGETTER(ParallelPort))(IParallelPort * * a_parallelPort) RT_OVERRIDE
    {
        return m_parallelPort.queryInterfaceTo(a_parallelPort);
    }
    // purely internal setter
    inline void set_parallelPort(IParallelPort * a_parallelPort)
    {
         m_parallelPort = a_parallelPort;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ParallelPortChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ParallelPortChangedEvent, IParallelPortChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateParallelPortChangedEvent(IEvent **aEvent, IEventSource *aSource, IParallelPort * a_parallelPort)
{
    ComObjPtr<ParallelPortChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnParallelPortChanged, FALSE /*waitable*/);
        EvtObj->set_parallelPort(a_parallelPort);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireParallelPortChangedEvent(IEventSource *aSource, IParallelPort * a_parallelPort)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateParallelPortChangedEvent(ptrEvent.asOutParam(), aSource, a_parallelPort);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IStorageControllerChangedEvent implementation code
class ATL_NO_VTABLE StorageControllerChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IStorageControllerChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(StorageControllerChangedEvent, IStorageControllerChangedEvent)
    DECLARE_NOT_AGGREGATABLE(StorageControllerChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(StorageControllerChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IStorageControllerChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IStorageControllerChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IStorageControllerChangedEvent)
        COM_INTERFACE_ENTRY(IStorageControllerChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    StorageControllerChangedEvent() { Log12(("StorageControllerChangedEvent %p\n", this)); }
    virtual ~StorageControllerChangedEvent() { Log12(("~StorageControllerChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute machinId
private:
    Utf8Str    m_machinId;
public:
    STDMETHOD(COMGETTER(MachinId))(BSTR * a_machinId) RT_OVERRIDE
    {
        return m_machinId.cloneToEx(a_machinId);
    }
    // purely internal setter
    inline HRESULT set_machinId(const Utf8Str &a_rString)
    {
        return m_machinId.assignEx(a_rString);
    }

    // attribute controllerName
private:
    Utf8Str    m_controllerName;
public:
    STDMETHOD(COMGETTER(ControllerName))(BSTR * a_controllerName) RT_OVERRIDE
    {
        return m_controllerName.cloneToEx(a_controllerName);
    }
    // purely internal setter
    inline HRESULT set_controllerName(const Utf8Str &a_rString)
    {
        return m_controllerName.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(StorageControllerChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(StorageControllerChangedEvent, IStorageControllerChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateStorageControllerChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machinId, const Utf8Str & a_controllerName)
{
    ComObjPtr<StorageControllerChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnStorageControllerChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machinId(a_machinId);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_controllerName(a_controllerName);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireStorageControllerChangedEvent(IEventSource *aSource, const Utf8Str & a_machinId, const Utf8Str & a_controllerName)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateStorageControllerChangedEvent(ptrEvent.asOutParam(), aSource, a_machinId, a_controllerName);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IMediumChangedEvent implementation code
class ATL_NO_VTABLE MediumChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IMediumChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(MediumChangedEvent, IMediumChangedEvent)
    DECLARE_NOT_AGGREGATABLE(MediumChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(MediumChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IMediumChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IMediumChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IMediumChangedEvent)
        COM_INTERFACE_ENTRY(IMediumChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    MediumChangedEvent() { Log12(("MediumChangedEvent %p\n", this)); }
    virtual ~MediumChangedEvent() { Log12(("~MediumChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute mediumAttachment
private:
    ComPtr<IMediumAttachment>    m_mediumAttachment;
public:
    STDMETHOD(COMGETTER(MediumAttachment))(IMediumAttachment * * a_mediumAttachment) RT_OVERRIDE
    {
        return m_mediumAttachment.queryInterfaceTo(a_mediumAttachment);
    }
    // purely internal setter
    inline void set_mediumAttachment(IMediumAttachment * a_mediumAttachment)
    {
         m_mediumAttachment = a_mediumAttachment;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MediumChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(MediumChangedEvent, IMediumChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateMediumChangedEvent(IEvent **aEvent, IEventSource *aSource, IMediumAttachment * a_mediumAttachment)
{
    ComObjPtr<MediumChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnMediumChanged, FALSE /*waitable*/);
        EvtObj->set_mediumAttachment(a_mediumAttachment);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireMediumChangedEvent(IEventSource *aSource, IMediumAttachment * a_mediumAttachment)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateMediumChangedEvent(ptrEvent.asOutParam(), aSource, a_mediumAttachment);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IClipboardModeChangedEvent implementation code
class ATL_NO_VTABLE ClipboardModeChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IClipboardModeChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ClipboardModeChangedEvent, IClipboardModeChangedEvent)
    DECLARE_NOT_AGGREGATABLE(ClipboardModeChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ClipboardModeChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IClipboardModeChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IClipboardModeChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IClipboardModeChangedEvent)
        COM_INTERFACE_ENTRY(IClipboardModeChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ClipboardModeChangedEvent() { Log12(("ClipboardModeChangedEvent %p\n", this)); }
    virtual ~ClipboardModeChangedEvent() { Log12(("~ClipboardModeChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute clipboardMode
private:
    ClipboardMode_T    m_clipboardMode;
public:
    STDMETHOD(COMGETTER(ClipboardMode))(ClipboardMode_T * a_clipboardMode) RT_OVERRIDE
    {
        *a_clipboardMode = m_clipboardMode;
        return S_OK;
    }
    // purely internal setter
    inline void set_clipboardMode(ClipboardMode_T a_clipboardMode)
    {
         m_clipboardMode = a_clipboardMode;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ClipboardModeChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ClipboardModeChangedEvent, IClipboardModeChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateClipboardModeChangedEvent(IEvent **aEvent, IEventSource *aSource, ClipboardMode_T a_clipboardMode)
{
    ComObjPtr<ClipboardModeChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnClipboardModeChanged, FALSE /*waitable*/);
        EvtObj->set_clipboardMode(a_clipboardMode);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireClipboardModeChangedEvent(IEventSource *aSource, ClipboardMode_T a_clipboardMode)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateClipboardModeChangedEvent(ptrEvent.asOutParam(), aSource, a_clipboardMode);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IClipboardFileTransferModeChangedEvent implementation code
class ATL_NO_VTABLE ClipboardFileTransferModeChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IClipboardFileTransferModeChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ClipboardFileTransferModeChangedEvent, IClipboardFileTransferModeChangedEvent)
    DECLARE_NOT_AGGREGATABLE(ClipboardFileTransferModeChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ClipboardFileTransferModeChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IClipboardFileTransferModeChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IClipboardFileTransferModeChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IClipboardFileTransferModeChangedEvent)
        COM_INTERFACE_ENTRY(IClipboardFileTransferModeChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ClipboardFileTransferModeChangedEvent() { Log12(("ClipboardFileTransferModeChangedEvent %p\n", this)); }
    virtual ~ClipboardFileTransferModeChangedEvent() { Log12(("~ClipboardFileTransferModeChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute enabled
private:
    BOOL    m_enabled;
public:
    STDMETHOD(COMGETTER(Enabled))(BOOL * a_enabled) RT_OVERRIDE
    {
        *a_enabled = m_enabled;
        return S_OK;
    }
    // purely internal setter
    inline void set_enabled(BOOL a_enabled)
    {
         m_enabled = a_enabled;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ClipboardFileTransferModeChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ClipboardFileTransferModeChangedEvent, IClipboardFileTransferModeChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateClipboardFileTransferModeChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_enabled)
{
    ComObjPtr<ClipboardFileTransferModeChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnClipboardFileTransferModeChanged, FALSE /*waitable*/);
        EvtObj->set_enabled(a_enabled);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireClipboardFileTransferModeChangedEvent(IEventSource *aSource, BOOL a_enabled)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateClipboardFileTransferModeChangedEvent(ptrEvent.asOutParam(), aSource, a_enabled);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IClipboardErrorEvent implementation code
class ATL_NO_VTABLE ClipboardErrorEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IClipboardErrorEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ClipboardErrorEvent, IClipboardErrorEvent)
    DECLARE_NOT_AGGREGATABLE(ClipboardErrorEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ClipboardErrorEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IClipboardErrorEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IClipboardErrorEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IClipboardErrorEvent)
        COM_INTERFACE_ENTRY(IClipboardErrorEvent)
        COM_INTERFACE_ENTRY(IClipboardEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ClipboardErrorEvent() { Log12(("ClipboardErrorEvent %p\n", this)); }
    virtual ~ClipboardErrorEvent() { Log12(("~ClipboardErrorEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute msg
private:
    Utf8Str    m_msg;
public:
    STDMETHOD(COMGETTER(Msg))(BSTR * a_msg) RT_OVERRIDE
    {
        return m_msg.cloneToEx(a_msg);
    }
    // purely internal setter
    inline HRESULT set_msg(const Utf8Str &a_rString)
    {
        return m_msg.assignEx(a_rString);
    }

    // attribute rcError
private:
    LONG    m_rcError;
public:
    STDMETHOD(COMGETTER(RcError))(LONG * a_rcError) RT_OVERRIDE
    {
        *a_rcError = m_rcError;
        return S_OK;
    }
    // purely internal setter
    inline void set_rcError(LONG a_rcError)
    {
         m_rcError = a_rcError;
    }

    // attribute id
private:
    Utf8Str    m_id;
public:
    STDMETHOD(COMGETTER(Id))(BSTR * a_id) RT_OVERRIDE
    {
        return m_id.cloneToEx(a_id);
    }
    // purely internal setter
    inline HRESULT set_id(const Utf8Str &a_rString)
    {
        return m_id.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ClipboardErrorEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(ClipboardErrorEvent, IClipboardErrorEvent, IClipboardEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateClipboardErrorEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_id, const Utf8Str & a_msg, LONG a_rcError)
{
    ComObjPtr<ClipboardErrorEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnClipboardError, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_id(a_id);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_msg(a_msg);
        EvtObj->set_rcError(a_rcError);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireClipboardErrorEvent(IEventSource *aSource, const Utf8Str & a_id, const Utf8Str & a_msg, LONG a_rcError)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateClipboardErrorEvent(ptrEvent.asOutParam(), aSource, a_id, a_msg, a_rcError);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IDnDModeChangedEvent implementation code
class ATL_NO_VTABLE DnDModeChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IDnDModeChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(DnDModeChangedEvent, IDnDModeChangedEvent)
    DECLARE_NOT_AGGREGATABLE(DnDModeChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(DnDModeChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IDnDModeChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IDnDModeChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IDnDModeChangedEvent)
        COM_INTERFACE_ENTRY(IDnDModeChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    DnDModeChangedEvent() { Log12(("DnDModeChangedEvent %p\n", this)); }
    virtual ~DnDModeChangedEvent() { Log12(("~DnDModeChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute dndMode
private:
    DnDMode_T    m_dndMode;
public:
    STDMETHOD(COMGETTER(DndMode))(DnDMode_T * a_dndMode) RT_OVERRIDE
    {
        *a_dndMode = m_dndMode;
        return S_OK;
    }
    // purely internal setter
    inline void set_dndMode(DnDMode_T a_dndMode)
    {
         m_dndMode = a_dndMode;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DnDModeChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(DnDModeChangedEvent, IDnDModeChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateDnDModeChangedEvent(IEvent **aEvent, IEventSource *aSource, DnDMode_T a_dndMode)
{
    ComObjPtr<DnDModeChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnDnDModeChanged, FALSE /*waitable*/);
        EvtObj->set_dndMode(a_dndMode);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireDnDModeChangedEvent(IEventSource *aSource, DnDMode_T a_dndMode)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateDnDModeChangedEvent(ptrEvent.asOutParam(), aSource, a_dndMode);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ICPUChangedEvent implementation code
class ATL_NO_VTABLE CPUChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICPUChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CPUChangedEvent, ICPUChangedEvent)
    DECLARE_NOT_AGGREGATABLE(CPUChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(CPUChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICPUChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ICPUChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ICPUChangedEvent)
        COM_INTERFACE_ENTRY(ICPUChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    CPUChangedEvent() { Log12(("CPUChangedEvent %p\n", this)); }
    virtual ~CPUChangedEvent() { Log12(("~CPUChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute CPU
private:
    ULONG    m_CPU;
public:
    STDMETHOD(COMGETTER(CPU))(ULONG * a_CPU) RT_OVERRIDE
    {
        *a_CPU = m_CPU;
        return S_OK;
    }
    // purely internal setter
    inline void set_CPU(ULONG a_CPU)
    {
         m_CPU = a_CPU;
    }

    // attribute add
private:
    BOOL    m_add;
public:
    STDMETHOD(COMGETTER(Add))(BOOL * a_add) RT_OVERRIDE
    {
        *a_add = m_add;
        return S_OK;
    }
    // purely internal setter
    inline void set_add(BOOL a_add)
    {
         m_add = a_add;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CPUChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(CPUChangedEvent, ICPUChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateCPUChangedEvent(IEvent **aEvent, IEventSource *aSource, ULONG a_CPU, BOOL a_add)
{
    ComObjPtr<CPUChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnCPUChanged, FALSE /*waitable*/);
        EvtObj->set_CPU(a_CPU);
        EvtObj->set_add(a_add);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireCPUChangedEvent(IEventSource *aSource, ULONG a_CPU, BOOL a_add)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateCPUChangedEvent(ptrEvent.asOutParam(), aSource, a_CPU, a_add);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ICPUExecutionCapChangedEvent implementation code
class ATL_NO_VTABLE CPUExecutionCapChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICPUExecutionCapChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CPUExecutionCapChangedEvent, ICPUExecutionCapChangedEvent)
    DECLARE_NOT_AGGREGATABLE(CPUExecutionCapChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(CPUExecutionCapChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICPUExecutionCapChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ICPUExecutionCapChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ICPUExecutionCapChangedEvent)
        COM_INTERFACE_ENTRY(ICPUExecutionCapChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    CPUExecutionCapChangedEvent() { Log12(("CPUExecutionCapChangedEvent %p\n", this)); }
    virtual ~CPUExecutionCapChangedEvent() { Log12(("~CPUExecutionCapChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute executionCap
private:
    ULONG    m_executionCap;
public:
    STDMETHOD(COMGETTER(ExecutionCap))(ULONG * a_executionCap) RT_OVERRIDE
    {
        *a_executionCap = m_executionCap;
        return S_OK;
    }
    // purely internal setter
    inline void set_executionCap(ULONG a_executionCap)
    {
         m_executionCap = a_executionCap;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CPUExecutionCapChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(CPUExecutionCapChangedEvent, ICPUExecutionCapChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateCPUExecutionCapChangedEvent(IEvent **aEvent, IEventSource *aSource, ULONG a_executionCap)
{
    ComObjPtr<CPUExecutionCapChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnCPUExecutionCapChanged, FALSE /*waitable*/);
        EvtObj->set_executionCap(a_executionCap);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireCPUExecutionCapChangedEvent(IEventSource *aSource, ULONG a_executionCap)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateCPUExecutionCapChangedEvent(ptrEvent.asOutParam(), aSource, a_executionCap);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestKeyboardEvent implementation code
class ATL_NO_VTABLE GuestKeyboardEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestKeyboardEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestKeyboardEvent, IGuestKeyboardEvent)
    DECLARE_NOT_AGGREGATABLE(GuestKeyboardEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestKeyboardEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestKeyboardEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestKeyboardEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestKeyboardEvent)
        COM_INTERFACE_ENTRY(IGuestKeyboardEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestKeyboardEvent() { Log12(("GuestKeyboardEvent %p\n", this)); }
    virtual ~GuestKeyboardEvent() { Log12(("~GuestKeyboardEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute scancodes
private:
    com::SafeArray<LONG>    m_scancodes;
public:
    STDMETHOD(COMGETTER(Scancodes))(ComSafeArrayOut(LONG, a_scancodes)) RT_OVERRIDE
    {
        SafeArray<LONG> result;
        HRESULT hrc = m_scancodes.cloneTo(result);
        if (SUCCEEDED(hrc))
            result.detachTo(ComSafeArrayOutArg(a_scancodes));
        return hrc;
    }
    // purely internal setter
    inline HRESULT set_scancodes(ComSafeArrayIn(LONG,a_scancodes))
    {
        SafeArray<LONG> aArr(ComSafeArrayInArg(a_scancodes));
        return m_scancodes.initFrom(aArr);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestKeyboardEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestKeyboardEvent, IGuestKeyboardEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestKeyboardEvent(IEvent **aEvent, IEventSource *aSource, ComSafeArrayIn(LONG,a_scancodes))
{
    ComObjPtr<GuestKeyboardEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestKeyboard, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_scancodes(ComSafeArrayInArg(a_scancodes));
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestKeyboardEvent(IEventSource *aSource, ComSafeArrayIn(LONG,a_scancodes))
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestKeyboardEvent(ptrEvent.asOutParam(), aSource, ComSafeArrayInArg(a_scancodes));
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestMouseEvent implementation code
class ATL_NO_VTABLE GuestMouseEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestMouseEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestMouseEvent, IGuestMouseEvent)
    DECLARE_NOT_AGGREGATABLE(GuestMouseEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestMouseEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestMouseEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestMouseEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestMouseEvent)
        COM_INTERFACE_ENTRY(IGuestMouseEvent)
        COM_INTERFACE_ENTRY(IReusableEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestMouseEvent() { Log12(("GuestMouseEvent %p\n", this)); }
    virtual ~GuestMouseEvent() { Log12(("~GuestMouseEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }


    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable = FALSE)
    {
        mGeneration = 1;
        return mEvent->init(aSource, aType, aWaitable);
    }
    STDMETHOD(COMGETTER(Generation))(ULONG *aGeneration) RT_OVERRIDE
    {
        *aGeneration = mGeneration;
        return S_OK;
    }
    STDMETHOD(Reuse)() RT_OVERRIDE
    {
        ASMAtomicIncU32((volatile uint32_t *)&mGeneration);
        return S_OK;
    }
private:
    volatile ULONG              mGeneration;
    ComObjPtr<VBoxEvent>        mEvent;

    // attribute mode
private:
    GuestMouseEventMode_T    m_mode;
public:
    STDMETHOD(COMGETTER(Mode))(GuestMouseEventMode_T * a_mode) RT_OVERRIDE
    {
        *a_mode = m_mode;
        return S_OK;
    }
    // purely internal setter
    inline void set_mode(GuestMouseEventMode_T a_mode)
    {
         m_mode = a_mode;
    }

    // attribute x
private:
    LONG    m_x;
public:
    STDMETHOD(COMGETTER(X))(LONG * a_x) RT_OVERRIDE
    {
        *a_x = m_x;
        return S_OK;
    }
    // purely internal setter
    inline void set_x(LONG a_x)
    {
         m_x = a_x;
    }

    // attribute y
private:
    LONG    m_y;
public:
    STDMETHOD(COMGETTER(Y))(LONG * a_y) RT_OVERRIDE
    {
        *a_y = m_y;
        return S_OK;
    }
    // purely internal setter
    inline void set_y(LONG a_y)
    {
         m_y = a_y;
    }

    // attribute z
private:
    LONG    m_z;
public:
    STDMETHOD(COMGETTER(Z))(LONG * a_z) RT_OVERRIDE
    {
        *a_z = m_z;
        return S_OK;
    }
    // purely internal setter
    inline void set_z(LONG a_z)
    {
         m_z = a_z;
    }

    // attribute w
private:
    LONG    m_w;
public:
    STDMETHOD(COMGETTER(W))(LONG * a_w) RT_OVERRIDE
    {
        *a_w = m_w;
        return S_OK;
    }
    // purely internal setter
    inline void set_w(LONG a_w)
    {
         m_w = a_w;
    }

    // attribute buttons
private:
    LONG    m_buttons;
public:
    STDMETHOD(COMGETTER(Buttons))(LONG * a_buttons) RT_OVERRIDE
    {
        *a_buttons = m_buttons;
        return S_OK;
    }
    // purely internal setter
    inline void set_buttons(LONG a_buttons)
    {
         m_buttons = a_buttons;
    }
    // skipping IReusableEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestMouseEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(GuestMouseEvent, IGuestMouseEvent, IReusableEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) ReinitGuestMouseEvent(IEvent *aEvent, GuestMouseEventMode_T a_mode, LONG a_x, LONG a_y, LONG a_z, LONG a_w, LONG a_buttons)
{
    GuestMouseEvent *pEvtImpl = dynamic_cast<GuestMouseEvent *>(aEvent);
    if (pEvtImpl)
    {
        pEvtImpl->Reuse();
        HRESULT hrc = S_OK;
        pEvtImpl->set_mode(a_mode);
        pEvtImpl->set_x(a_x);
        pEvtImpl->set_y(a_y);
        pEvtImpl->set_z(a_z);
        pEvtImpl->set_w(a_w);
        pEvtImpl->set_buttons(a_buttons);
        return hrc;
    }
    return E_INVALIDARG;
}

DECLHIDDEN(HRESULT) CreateGuestMouseEvent(IEvent **aEvent, IEventSource *aSource, GuestMouseEventMode_T a_mode, LONG a_x, LONG a_y, LONG a_z, LONG a_w, LONG a_buttons)
{
    ComObjPtr<GuestMouseEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestMouse, FALSE /*waitable*/);
        EvtObj->set_mode(a_mode);
        EvtObj->set_x(a_x);
        EvtObj->set_y(a_y);
        EvtObj->set_z(a_z);
        EvtObj->set_w(a_w);
        EvtObj->set_buttons(a_buttons);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestMouseEvent(IEventSource *aSource, GuestMouseEventMode_T a_mode, LONG a_x, LONG a_y, LONG a_z, LONG a_w, LONG a_buttons)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestMouseEvent(ptrEvent.asOutParam(), aSource, a_mode, a_x, a_y, a_z, a_w, a_buttons);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestMultiTouchEvent implementation code
class ATL_NO_VTABLE GuestMultiTouchEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestMultiTouchEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestMultiTouchEvent, IGuestMultiTouchEvent)
    DECLARE_NOT_AGGREGATABLE(GuestMultiTouchEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestMultiTouchEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestMultiTouchEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestMultiTouchEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestMultiTouchEvent)
        COM_INTERFACE_ENTRY(IGuestMultiTouchEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestMultiTouchEvent() { Log12(("GuestMultiTouchEvent %p\n", this)); }
    virtual ~GuestMultiTouchEvent() { Log12(("~GuestMultiTouchEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute contactCount
private:
    LONG    m_contactCount;
public:
    STDMETHOD(COMGETTER(ContactCount))(LONG * a_contactCount) RT_OVERRIDE
    {
        *a_contactCount = m_contactCount;
        return S_OK;
    }
    // purely internal setter
    inline void set_contactCount(LONG a_contactCount)
    {
         m_contactCount = a_contactCount;
    }

    // attribute xPositions
private:
    com::SafeArray<SHORT>    m_xPositions;
public:
    STDMETHOD(COMGETTER(XPositions))(ComSafeArrayOut(SHORT, a_xPositions)) RT_OVERRIDE
    {
        SafeArray<SHORT> result;
        HRESULT hrc = m_xPositions.cloneTo(result);
        if (SUCCEEDED(hrc))
            result.detachTo(ComSafeArrayOutArg(a_xPositions));
        return hrc;
    }
    // purely internal setter
    inline HRESULT set_xPositions(ComSafeArrayIn(SHORT,a_xPositions))
    {
        SafeArray<SHORT> aArr(ComSafeArrayInArg(a_xPositions));
        return m_xPositions.initFrom(aArr);
    }

    // attribute yPositions
private:
    com::SafeArray<SHORT>    m_yPositions;
public:
    STDMETHOD(COMGETTER(YPositions))(ComSafeArrayOut(SHORT, a_yPositions)) RT_OVERRIDE
    {
        SafeArray<SHORT> result;
        HRESULT hrc = m_yPositions.cloneTo(result);
        if (SUCCEEDED(hrc))
            result.detachTo(ComSafeArrayOutArg(a_yPositions));
        return hrc;
    }
    // purely internal setter
    inline HRESULT set_yPositions(ComSafeArrayIn(SHORT,a_yPositions))
    {
        SafeArray<SHORT> aArr(ComSafeArrayInArg(a_yPositions));
        return m_yPositions.initFrom(aArr);
    }

    // attribute contactIds
private:
    com::SafeArray<USHORT>    m_contactIds;
public:
    STDMETHOD(COMGETTER(ContactIds))(ComSafeArrayOut(USHORT, a_contactIds)) RT_OVERRIDE
    {
        SafeArray<USHORT> result;
        HRESULT hrc = m_contactIds.cloneTo(result);
        if (SUCCEEDED(hrc))
            result.detachTo(ComSafeArrayOutArg(a_contactIds));
        return hrc;
    }
    // purely internal setter
    inline HRESULT set_contactIds(ComSafeArrayIn(USHORT,a_contactIds))
    {
        SafeArray<USHORT> aArr(ComSafeArrayInArg(a_contactIds));
        return m_contactIds.initFrom(aArr);
    }

    // attribute contactFlags
private:
    com::SafeArray<USHORT>    m_contactFlags;
public:
    STDMETHOD(COMGETTER(ContactFlags))(ComSafeArrayOut(USHORT, a_contactFlags)) RT_OVERRIDE
    {
        SafeArray<USHORT> result;
        HRESULT hrc = m_contactFlags.cloneTo(result);
        if (SUCCEEDED(hrc))
            result.detachTo(ComSafeArrayOutArg(a_contactFlags));
        return hrc;
    }
    // purely internal setter
    inline HRESULT set_contactFlags(ComSafeArrayIn(USHORT,a_contactFlags))
    {
        SafeArray<USHORT> aArr(ComSafeArrayInArg(a_contactFlags));
        return m_contactFlags.initFrom(aArr);
    }

    // attribute isTouchScreen
private:
    BOOL    m_isTouchScreen;
public:
    STDMETHOD(COMGETTER(IsTouchScreen))(BOOL * a_isTouchScreen) RT_OVERRIDE
    {
        *a_isTouchScreen = m_isTouchScreen;
        return S_OK;
    }
    // purely internal setter
    inline void set_isTouchScreen(BOOL a_isTouchScreen)
    {
         m_isTouchScreen = a_isTouchScreen;
    }

    // attribute scanTime
private:
    ULONG    m_scanTime;
public:
    STDMETHOD(COMGETTER(ScanTime))(ULONG * a_scanTime) RT_OVERRIDE
    {
        *a_scanTime = m_scanTime;
        return S_OK;
    }
    // purely internal setter
    inline void set_scanTime(ULONG a_scanTime)
    {
         m_scanTime = a_scanTime;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestMultiTouchEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestMultiTouchEvent, IGuestMultiTouchEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestMultiTouchEvent(IEvent **aEvent, IEventSource *aSource, LONG a_contactCount, ComSafeArrayIn(SHORT,a_xPositions), ComSafeArrayIn(SHORT,a_yPositions), ComSafeArrayIn(USHORT,a_contactIds), ComSafeArrayIn(USHORT,a_contactFlags), BOOL a_isTouchScreen, ULONG a_scanTime)
{
    ComObjPtr<GuestMultiTouchEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestMultiTouch, FALSE /*waitable*/);
        EvtObj->set_contactCount(a_contactCount);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_xPositions(ComSafeArrayInArg(a_xPositions));
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_yPositions(ComSafeArrayInArg(a_yPositions));
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_contactIds(ComSafeArrayInArg(a_contactIds));
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_contactFlags(ComSafeArrayInArg(a_contactFlags));
        EvtObj->set_isTouchScreen(a_isTouchScreen);
        EvtObj->set_scanTime(a_scanTime);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestMultiTouchEvent(IEventSource *aSource, LONG a_contactCount, ComSafeArrayIn(SHORT,a_xPositions), ComSafeArrayIn(SHORT,a_yPositions), ComSafeArrayIn(USHORT,a_contactIds), ComSafeArrayIn(USHORT,a_contactFlags), BOOL a_isTouchScreen, ULONG a_scanTime)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestMultiTouchEvent(ptrEvent.asOutParam(), aSource, a_contactCount, ComSafeArrayInArg(a_xPositions), ComSafeArrayInArg(a_yPositions), ComSafeArrayInArg(a_contactIds), ComSafeArrayInArg(a_contactFlags), a_isTouchScreen, a_scanTime);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestSessionStateChangedEvent implementation code
class ATL_NO_VTABLE GuestSessionStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestSessionStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestSessionStateChangedEvent, IGuestSessionStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestSessionStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestSessionStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestSessionStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestSessionStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestSessionStateChangedEvent)
        COM_INTERFACE_ENTRY(IGuestSessionStateChangedEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestSessionStateChangedEvent() { Log12(("GuestSessionStateChangedEvent %p\n", this)); }
    virtual ~GuestSessionStateChangedEvent() { Log12(("~GuestSessionStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute id
private:
    ULONG    m_id;
public:
    STDMETHOD(COMGETTER(Id))(ULONG * a_id) RT_OVERRIDE
    {
        *a_id = m_id;
        return S_OK;
    }
    // purely internal setter
    inline void set_id(ULONG a_id)
    {
         m_id = a_id;
    }

    // attribute status
private:
    GuestSessionStatus_T    m_status;
public:
    STDMETHOD(COMGETTER(Status))(GuestSessionStatus_T * a_status) RT_OVERRIDE
    {
        *a_status = m_status;
        return S_OK;
    }
    // purely internal setter
    inline void set_status(GuestSessionStatus_T a_status)
    {
         m_status = a_status;
    }

    // attribute error
private:
    ComPtr<IVirtualBoxErrorInfo>    m_error;
public:
    STDMETHOD(COMGETTER(Error))(IVirtualBoxErrorInfo * * a_error) RT_OVERRIDE
    {
        return m_error.queryInterfaceTo(a_error);
    }
    // purely internal setter
    inline void set_error(IVirtualBoxErrorInfo * a_error)
    {
         m_error = a_error;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestSessionStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(GuestSessionStateChangedEvent, IGuestSessionStateChangedEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestSessionStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, ULONG a_id, GuestSessionStatus_T a_status, IVirtualBoxErrorInfo * a_error)
{
    ComObjPtr<GuestSessionStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestSessionStateChanged, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_id(a_id);
        EvtObj->set_status(a_status);
        EvtObj->set_error(a_error);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestSessionStateChangedEvent(IEventSource *aSource, IGuestSession * a_session, ULONG a_id, GuestSessionStatus_T a_status, IVirtualBoxErrorInfo * a_error)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestSessionStateChangedEvent(ptrEvent.asOutParam(), aSource, a_session, a_id, a_status, a_error);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestSessionRegisteredEvent implementation code
class ATL_NO_VTABLE GuestSessionRegisteredEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestSessionRegisteredEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestSessionRegisteredEvent, IGuestSessionRegisteredEvent)
    DECLARE_NOT_AGGREGATABLE(GuestSessionRegisteredEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestSessionRegisteredEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestSessionRegisteredEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestSessionRegisteredEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestSessionRegisteredEvent)
        COM_INTERFACE_ENTRY(IGuestSessionRegisteredEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestSessionRegisteredEvent() { Log12(("GuestSessionRegisteredEvent %p\n", this)); }
    virtual ~GuestSessionRegisteredEvent() { Log12(("~GuestSessionRegisteredEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute registered
private:
    BOOL    m_registered;
public:
    STDMETHOD(COMGETTER(Registered))(BOOL * a_registered) RT_OVERRIDE
    {
        *a_registered = m_registered;
        return S_OK;
    }
    // purely internal setter
    inline void set_registered(BOOL a_registered)
    {
         m_registered = a_registered;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestSessionRegisteredEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(GuestSessionRegisteredEvent, IGuestSessionRegisteredEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestSessionRegisteredEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, BOOL a_registered)
{
    ComObjPtr<GuestSessionRegisteredEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestSessionRegistered, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_registered(a_registered);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestSessionRegisteredEvent(IEventSource *aSource, IGuestSession * a_session, BOOL a_registered)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestSessionRegisteredEvent(ptrEvent.asOutParam(), aSource, a_session, a_registered);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestProcessRegisteredEvent implementation code
class ATL_NO_VTABLE GuestProcessRegisteredEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestProcessRegisteredEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestProcessRegisteredEvent, IGuestProcessRegisteredEvent)
    DECLARE_NOT_AGGREGATABLE(GuestProcessRegisteredEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestProcessRegisteredEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestProcessRegisteredEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestProcessRegisteredEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestProcessRegisteredEvent)
        COM_INTERFACE_ENTRY(IGuestProcessRegisteredEvent)
        COM_INTERFACE_ENTRY(IGuestProcessEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestProcessRegisteredEvent() { Log12(("GuestProcessRegisteredEvent %p\n", this)); }
    virtual ~GuestProcessRegisteredEvent() { Log12(("~GuestProcessRegisteredEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute registered
private:
    BOOL    m_registered;
public:
    STDMETHOD(COMGETTER(Registered))(BOOL * a_registered) RT_OVERRIDE
    {
        *a_registered = m_registered;
        return S_OK;
    }
    // purely internal setter
    inline void set_registered(BOOL a_registered)
    {
         m_registered = a_registered;
    }

    // attribute process
private:
    ComPtr<IGuestProcess>    m_process;
public:
    STDMETHOD(COMGETTER(Process))(IGuestProcess * * a_process) RT_OVERRIDE
    {
        return m_process.queryInterfaceTo(a_process);
    }
    // purely internal setter
    inline void set_process(IGuestProcess * a_process)
    {
         m_process = a_process;
    }

    // attribute pid
private:
    ULONG    m_pid;
public:
    STDMETHOD(COMGETTER(Pid))(ULONG * a_pid) RT_OVERRIDE
    {
        *a_pid = m_pid;
        return S_OK;
    }
    // purely internal setter
    inline void set_pid(ULONG a_pid)
    {
         m_pid = a_pid;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestProcessRegisteredEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(GuestProcessRegisteredEvent, IGuestProcessRegisteredEvent, IGuestProcessEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestProcessRegisteredEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, BOOL a_registered)
{
    ComObjPtr<GuestProcessRegisteredEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestProcessRegistered, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_process(a_process);
        EvtObj->set_pid(a_pid);
        EvtObj->set_registered(a_registered);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestProcessRegisteredEvent(IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, BOOL a_registered)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestProcessRegisteredEvent(ptrEvent.asOutParam(), aSource, a_session, a_process, a_pid, a_registered);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestProcessStateChangedEvent implementation code
class ATL_NO_VTABLE GuestProcessStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestProcessStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestProcessStateChangedEvent, IGuestProcessStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestProcessStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestProcessStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestProcessStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestProcessStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestProcessStateChangedEvent)
        COM_INTERFACE_ENTRY(IGuestProcessStateChangedEvent)
        COM_INTERFACE_ENTRY(IGuestProcessEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestProcessStateChangedEvent() { Log12(("GuestProcessStateChangedEvent %p\n", this)); }
    virtual ~GuestProcessStateChangedEvent() { Log12(("~GuestProcessStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute status
private:
    ProcessStatus_T    m_status;
public:
    STDMETHOD(COMGETTER(Status))(ProcessStatus_T * a_status) RT_OVERRIDE
    {
        *a_status = m_status;
        return S_OK;
    }
    // purely internal setter
    inline void set_status(ProcessStatus_T a_status)
    {
         m_status = a_status;
    }

    // attribute error
private:
    ComPtr<IVirtualBoxErrorInfo>    m_error;
public:
    STDMETHOD(COMGETTER(Error))(IVirtualBoxErrorInfo * * a_error) RT_OVERRIDE
    {
        return m_error.queryInterfaceTo(a_error);
    }
    // purely internal setter
    inline void set_error(IVirtualBoxErrorInfo * a_error)
    {
         m_error = a_error;
    }

    // attribute process
private:
    ComPtr<IGuestProcess>    m_process;
public:
    STDMETHOD(COMGETTER(Process))(IGuestProcess * * a_process) RT_OVERRIDE
    {
        return m_process.queryInterfaceTo(a_process);
    }
    // purely internal setter
    inline void set_process(IGuestProcess * a_process)
    {
         m_process = a_process;
    }

    // attribute pid
private:
    ULONG    m_pid;
public:
    STDMETHOD(COMGETTER(Pid))(ULONG * a_pid) RT_OVERRIDE
    {
        *a_pid = m_pid;
        return S_OK;
    }
    // purely internal setter
    inline void set_pid(ULONG a_pid)
    {
         m_pid = a_pid;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestProcessStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(GuestProcessStateChangedEvent, IGuestProcessStateChangedEvent, IGuestProcessEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestProcessStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ProcessStatus_T a_status, IVirtualBoxErrorInfo * a_error)
{
    ComObjPtr<GuestProcessStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestProcessStateChanged, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_process(a_process);
        EvtObj->set_pid(a_pid);
        EvtObj->set_status(a_status);
        EvtObj->set_error(a_error);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestProcessStateChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ProcessStatus_T a_status, IVirtualBoxErrorInfo * a_error)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestProcessStateChangedEvent(ptrEvent.asOutParam(), aSource, a_session, a_process, a_pid, a_status, a_error);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestProcessInputNotifyEvent implementation code
class ATL_NO_VTABLE GuestProcessInputNotifyEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestProcessInputNotifyEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestProcessInputNotifyEvent, IGuestProcessInputNotifyEvent)
    DECLARE_NOT_AGGREGATABLE(GuestProcessInputNotifyEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestProcessInputNotifyEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestProcessInputNotifyEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestProcessInputNotifyEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestProcessInputNotifyEvent)
        COM_INTERFACE_ENTRY(IGuestProcessInputNotifyEvent)
        COM_INTERFACE_ENTRY(IGuestProcessIOEvent)
        COM_INTERFACE_ENTRY(IGuestProcessEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestProcessInputNotifyEvent() { Log12(("GuestProcessInputNotifyEvent %p\n", this)); }
    virtual ~GuestProcessInputNotifyEvent() { Log12(("~GuestProcessInputNotifyEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute status
private:
    ProcessInputStatus_T    m_status;
public:
    STDMETHOD(COMGETTER(Status))(ProcessInputStatus_T * a_status) RT_OVERRIDE
    {
        *a_status = m_status;
        return S_OK;
    }
    // purely internal setter
    inline void set_status(ProcessInputStatus_T a_status)
    {
         m_status = a_status;
    }

    // attribute handle
private:
    ULONG    m_handle;
public:
    STDMETHOD(COMGETTER(Handle))(ULONG * a_handle) RT_OVERRIDE
    {
        *a_handle = m_handle;
        return S_OK;
    }
    // purely internal setter
    inline void set_handle(ULONG a_handle)
    {
         m_handle = a_handle;
    }

    // attribute processed
private:
    ULONG    m_processed;
public:
    STDMETHOD(COMGETTER(Processed))(ULONG * a_processed) RT_OVERRIDE
    {
        *a_processed = m_processed;
        return S_OK;
    }
    // purely internal setter
    inline void set_processed(ULONG a_processed)
    {
         m_processed = a_processed;
    }

    // attribute process
private:
    ComPtr<IGuestProcess>    m_process;
public:
    STDMETHOD(COMGETTER(Process))(IGuestProcess * * a_process) RT_OVERRIDE
    {
        return m_process.queryInterfaceTo(a_process);
    }
    // purely internal setter
    inline void set_process(IGuestProcess * a_process)
    {
         m_process = a_process;
    }

    // attribute pid
private:
    ULONG    m_pid;
public:
    STDMETHOD(COMGETTER(Pid))(ULONG * a_pid) RT_OVERRIDE
    {
        *a_pid = m_pid;
        return S_OK;
    }
    // purely internal setter
    inline void set_pid(ULONG a_pid)
    {
         m_pid = a_pid;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestProcessInputNotifyEvent)
NS_IMPL_THREADSAFE_ISUPPORTS5_CI(GuestProcessInputNotifyEvent, IGuestProcessInputNotifyEvent, IGuestProcessIOEvent, IGuestProcessEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestProcessInputNotifyEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ULONG a_handle, ULONG a_processed, ProcessInputStatus_T a_status)
{
    ComObjPtr<GuestProcessInputNotifyEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestProcessInputNotify, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_process(a_process);
        EvtObj->set_pid(a_pid);
        EvtObj->set_handle(a_handle);
        EvtObj->set_processed(a_processed);
        EvtObj->set_status(a_status);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestProcessInputNotifyEvent(IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ULONG a_handle, ULONG a_processed, ProcessInputStatus_T a_status)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestProcessInputNotifyEvent(ptrEvent.asOutParam(), aSource, a_session, a_process, a_pid, a_handle, a_processed, a_status);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestProcessOutputEvent implementation code
class ATL_NO_VTABLE GuestProcessOutputEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestProcessOutputEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestProcessOutputEvent, IGuestProcessOutputEvent)
    DECLARE_NOT_AGGREGATABLE(GuestProcessOutputEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestProcessOutputEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestProcessOutputEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestProcessOutputEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestProcessOutputEvent)
        COM_INTERFACE_ENTRY(IGuestProcessOutputEvent)
        COM_INTERFACE_ENTRY(IGuestProcessIOEvent)
        COM_INTERFACE_ENTRY(IGuestProcessEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestProcessOutputEvent() { Log12(("GuestProcessOutputEvent %p\n", this)); }
    virtual ~GuestProcessOutputEvent() { Log12(("~GuestProcessOutputEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute data
private:
    com::SafeArray<BYTE>    m_data;
public:
    STDMETHOD(COMGETTER(Data))(ComSafeArrayOut(BYTE, a_data)) RT_OVERRIDE
    {
        SafeArray<BYTE> result;
        HRESULT hrc = m_data.cloneTo(result);
        if (SUCCEEDED(hrc))
            result.detachTo(ComSafeArrayOutArg(a_data));
        return hrc;
    }
    // purely internal setter
    inline HRESULT set_data(ComSafeArrayIn(BYTE,a_data))
    {
        SafeArray<BYTE> aArr(ComSafeArrayInArg(a_data));
        return m_data.initFrom(aArr);
    }

    // attribute handle
private:
    ULONG    m_handle;
public:
    STDMETHOD(COMGETTER(Handle))(ULONG * a_handle) RT_OVERRIDE
    {
        *a_handle = m_handle;
        return S_OK;
    }
    // purely internal setter
    inline void set_handle(ULONG a_handle)
    {
         m_handle = a_handle;
    }

    // attribute processed
private:
    ULONG    m_processed;
public:
    STDMETHOD(COMGETTER(Processed))(ULONG * a_processed) RT_OVERRIDE
    {
        *a_processed = m_processed;
        return S_OK;
    }
    // purely internal setter
    inline void set_processed(ULONG a_processed)
    {
         m_processed = a_processed;
    }

    // attribute process
private:
    ComPtr<IGuestProcess>    m_process;
public:
    STDMETHOD(COMGETTER(Process))(IGuestProcess * * a_process) RT_OVERRIDE
    {
        return m_process.queryInterfaceTo(a_process);
    }
    // purely internal setter
    inline void set_process(IGuestProcess * a_process)
    {
         m_process = a_process;
    }

    // attribute pid
private:
    ULONG    m_pid;
public:
    STDMETHOD(COMGETTER(Pid))(ULONG * a_pid) RT_OVERRIDE
    {
        *a_pid = m_pid;
        return S_OK;
    }
    // purely internal setter
    inline void set_pid(ULONG a_pid)
    {
         m_pid = a_pid;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestProcessOutputEvent)
NS_IMPL_THREADSAFE_ISUPPORTS5_CI(GuestProcessOutputEvent, IGuestProcessOutputEvent, IGuestProcessIOEvent, IGuestProcessEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestProcessOutputEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ULONG a_handle, ULONG a_processed, ComSafeArrayIn(BYTE,a_data))
{
    ComObjPtr<GuestProcessOutputEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestProcessOutput, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_process(a_process);
        EvtObj->set_pid(a_pid);
        EvtObj->set_handle(a_handle);
        EvtObj->set_processed(a_processed);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_data(ComSafeArrayInArg(a_data));
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestProcessOutputEvent(IEventSource *aSource, IGuestSession * a_session, IGuestProcess * a_process, ULONG a_pid, ULONG a_handle, ULONG a_processed, ComSafeArrayIn(BYTE,a_data))
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestProcessOutputEvent(ptrEvent.asOutParam(), aSource, a_session, a_process, a_pid, a_handle, a_processed, ComSafeArrayInArg(a_data));
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestDirectoryRegisteredEvent implementation code
class ATL_NO_VTABLE GuestDirectoryRegisteredEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestDirectoryRegisteredEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestDirectoryRegisteredEvent, IGuestDirectoryRegisteredEvent)
    DECLARE_NOT_AGGREGATABLE(GuestDirectoryRegisteredEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestDirectoryRegisteredEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestDirectoryRegisteredEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestDirectoryRegisteredEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestDirectoryRegisteredEvent)
        COM_INTERFACE_ENTRY(IGuestDirectoryRegisteredEvent)
        COM_INTERFACE_ENTRY(IGuestDirectoryEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestDirectoryRegisteredEvent() { Log12(("GuestDirectoryRegisteredEvent %p\n", this)); }
    virtual ~GuestDirectoryRegisteredEvent() { Log12(("~GuestDirectoryRegisteredEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute registered
private:
    BOOL    m_registered;
public:
    STDMETHOD(COMGETTER(Registered))(BOOL * a_registered) RT_OVERRIDE
    {
        *a_registered = m_registered;
        return S_OK;
    }
    // purely internal setter
    inline void set_registered(BOOL a_registered)
    {
         m_registered = a_registered;
    }

    // attribute directory
private:
    ComPtr<IGuestDirectory>    m_directory;
public:
    STDMETHOD(COMGETTER(Directory))(IGuestDirectory * * a_directory) RT_OVERRIDE
    {
        return m_directory.queryInterfaceTo(a_directory);
    }
    // purely internal setter
    inline void set_directory(IGuestDirectory * a_directory)
    {
         m_directory = a_directory;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestDirectoryRegisteredEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(GuestDirectoryRegisteredEvent, IGuestDirectoryRegisteredEvent, IGuestDirectoryEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestDirectoryRegisteredEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, BOOL a_registered)
{
    ComObjPtr<GuestDirectoryRegisteredEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestDirectoryRegistered, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_directory(a_directory);
        EvtObj->set_registered(a_registered);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestDirectoryRegisteredEvent(IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, BOOL a_registered)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestDirectoryRegisteredEvent(ptrEvent.asOutParam(), aSource, a_session, a_directory, a_registered);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestDirectoryStateChangedEvent implementation code
class ATL_NO_VTABLE GuestDirectoryStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestDirectoryStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestDirectoryStateChangedEvent, IGuestDirectoryStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestDirectoryStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestDirectoryStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestDirectoryStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestDirectoryStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestDirectoryStateChangedEvent)
        COM_INTERFACE_ENTRY(IGuestDirectoryStateChangedEvent)
        COM_INTERFACE_ENTRY(IGuestDirectoryEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestDirectoryStateChangedEvent() { Log12(("GuestDirectoryStateChangedEvent %p\n", this)); }
    virtual ~GuestDirectoryStateChangedEvent() { Log12(("~GuestDirectoryStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute status
private:
    DirectoryStatus_T    m_status;
public:
    STDMETHOD(COMGETTER(Status))(DirectoryStatus_T * a_status) RT_OVERRIDE
    {
        *a_status = m_status;
        return S_OK;
    }
    // purely internal setter
    inline void set_status(DirectoryStatus_T a_status)
    {
         m_status = a_status;
    }

    // attribute error
private:
    ComPtr<IVirtualBoxErrorInfo>    m_error;
public:
    STDMETHOD(COMGETTER(Error))(IVirtualBoxErrorInfo * * a_error) RT_OVERRIDE
    {
        return m_error.queryInterfaceTo(a_error);
    }
    // purely internal setter
    inline void set_error(IVirtualBoxErrorInfo * a_error)
    {
         m_error = a_error;
    }

    // attribute directory
private:
    ComPtr<IGuestDirectory>    m_directory;
public:
    STDMETHOD(COMGETTER(Directory))(IGuestDirectory * * a_directory) RT_OVERRIDE
    {
        return m_directory.queryInterfaceTo(a_directory);
    }
    // purely internal setter
    inline void set_directory(IGuestDirectory * a_directory)
    {
         m_directory = a_directory;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestDirectoryStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(GuestDirectoryStateChangedEvent, IGuestDirectoryStateChangedEvent, IGuestDirectoryEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestDirectoryStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, DirectoryStatus_T a_status, IVirtualBoxErrorInfo * a_error)
{
    ComObjPtr<GuestDirectoryStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestDirectoryStateChanged, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_directory(a_directory);
        EvtObj->set_status(a_status);
        EvtObj->set_error(a_error);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestDirectoryStateChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, DirectoryStatus_T a_status, IVirtualBoxErrorInfo * a_error)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestDirectoryStateChangedEvent(ptrEvent.asOutParam(), aSource, a_session, a_directory, a_status, a_error);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestDirectoryReadEvent implementation code
class ATL_NO_VTABLE GuestDirectoryReadEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestDirectoryReadEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestDirectoryReadEvent, IGuestDirectoryReadEvent)
    DECLARE_NOT_AGGREGATABLE(GuestDirectoryReadEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestDirectoryReadEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestDirectoryReadEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestDirectoryReadEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestDirectoryReadEvent)
        COM_INTERFACE_ENTRY(IGuestDirectoryReadEvent)
        COM_INTERFACE_ENTRY(IGuestDirectoryEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestDirectoryReadEvent() { Log12(("GuestDirectoryReadEvent %p\n", this)); }
    virtual ~GuestDirectoryReadEvent() { Log12(("~GuestDirectoryReadEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute path
private:
    Utf8Str    m_path;
public:
    STDMETHOD(COMGETTER(Path))(BSTR * a_path) RT_OVERRIDE
    {
        return m_path.cloneToEx(a_path);
    }
    // purely internal setter
    inline HRESULT set_path(const Utf8Str &a_rString)
    {
        return m_path.assignEx(a_rString);
    }

    // attribute objInfo
private:
    ComPtr<IFsObjInfo>    m_objInfo;
public:
    STDMETHOD(COMGETTER(ObjInfo))(IFsObjInfo * * a_objInfo) RT_OVERRIDE
    {
        return m_objInfo.queryInterfaceTo(a_objInfo);
    }
    // purely internal setter
    inline void set_objInfo(IFsObjInfo * a_objInfo)
    {
         m_objInfo = a_objInfo;
    }

    // attribute owner
private:
    Utf8Str    m_owner;
public:
    STDMETHOD(COMGETTER(Owner))(BSTR * a_owner) RT_OVERRIDE
    {
        return m_owner.cloneToEx(a_owner);
    }
    // purely internal setter
    inline HRESULT set_owner(const Utf8Str &a_rString)
    {
        return m_owner.assignEx(a_rString);
    }

    // attribute groups
private:
    Utf8Str    m_groups;
public:
    STDMETHOD(COMGETTER(Groups))(BSTR * a_groups) RT_OVERRIDE
    {
        return m_groups.cloneToEx(a_groups);
    }
    // purely internal setter
    inline HRESULT set_groups(const Utf8Str &a_rString)
    {
        return m_groups.assignEx(a_rString);
    }

    // attribute directory
private:
    ComPtr<IGuestDirectory>    m_directory;
public:
    STDMETHOD(COMGETTER(Directory))(IGuestDirectory * * a_directory) RT_OVERRIDE
    {
        return m_directory.queryInterfaceTo(a_directory);
    }
    // purely internal setter
    inline void set_directory(IGuestDirectory * a_directory)
    {
         m_directory = a_directory;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestDirectoryReadEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(GuestDirectoryReadEvent, IGuestDirectoryReadEvent, IGuestDirectoryEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestDirectoryReadEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, const Utf8Str & a_path, IFsObjInfo * a_objInfo, const Utf8Str & a_owner, const Utf8Str & a_groups)
{
    ComObjPtr<GuestDirectoryReadEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestDirectoryRead, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_directory(a_directory);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_path(a_path);
        EvtObj->set_objInfo(a_objInfo);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_owner(a_owner);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_groups(a_groups);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestDirectoryReadEvent(IEventSource *aSource, IGuestSession * a_session, IGuestDirectory * a_directory, const Utf8Str & a_path, IFsObjInfo * a_objInfo, const Utf8Str & a_owner, const Utf8Str & a_groups)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestDirectoryReadEvent(ptrEvent.asOutParam(), aSource, a_session, a_directory, a_path, a_objInfo, a_owner, a_groups);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestFileRegisteredEvent implementation code
class ATL_NO_VTABLE GuestFileRegisteredEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestFileRegisteredEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestFileRegisteredEvent, IGuestFileRegisteredEvent)
    DECLARE_NOT_AGGREGATABLE(GuestFileRegisteredEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestFileRegisteredEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestFileRegisteredEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestFileRegisteredEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestFileRegisteredEvent)
        COM_INTERFACE_ENTRY(IGuestFileRegisteredEvent)
        COM_INTERFACE_ENTRY(IGuestFileEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestFileRegisteredEvent() { Log12(("GuestFileRegisteredEvent %p\n", this)); }
    virtual ~GuestFileRegisteredEvent() { Log12(("~GuestFileRegisteredEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute registered
private:
    BOOL    m_registered;
public:
    STDMETHOD(COMGETTER(Registered))(BOOL * a_registered) RT_OVERRIDE
    {
        *a_registered = m_registered;
        return S_OK;
    }
    // purely internal setter
    inline void set_registered(BOOL a_registered)
    {
         m_registered = a_registered;
    }

    // attribute file
private:
    ComPtr<IGuestFile>    m_file;
public:
    STDMETHOD(COMGETTER(File))(IGuestFile * * a_file) RT_OVERRIDE
    {
        return m_file.queryInterfaceTo(a_file);
    }
    // purely internal setter
    inline void set_file(IGuestFile * a_file)
    {
         m_file = a_file;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestFileRegisteredEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(GuestFileRegisteredEvent, IGuestFileRegisteredEvent, IGuestFileEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestFileRegisteredEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, BOOL a_registered)
{
    ComObjPtr<GuestFileRegisteredEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestFileRegistered, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_file(a_file);
        EvtObj->set_registered(a_registered);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestFileRegisteredEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, BOOL a_registered)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestFileRegisteredEvent(ptrEvent.asOutParam(), aSource, a_session, a_file, a_registered);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestFileStateChangedEvent implementation code
class ATL_NO_VTABLE GuestFileStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestFileStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestFileStateChangedEvent, IGuestFileStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestFileStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestFileStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestFileStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestFileStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestFileStateChangedEvent)
        COM_INTERFACE_ENTRY(IGuestFileStateChangedEvent)
        COM_INTERFACE_ENTRY(IGuestFileEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestFileStateChangedEvent() { Log12(("GuestFileStateChangedEvent %p\n", this)); }
    virtual ~GuestFileStateChangedEvent() { Log12(("~GuestFileStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute status
private:
    FileStatus_T    m_status;
public:
    STDMETHOD(COMGETTER(Status))(FileStatus_T * a_status) RT_OVERRIDE
    {
        *a_status = m_status;
        return S_OK;
    }
    // purely internal setter
    inline void set_status(FileStatus_T a_status)
    {
         m_status = a_status;
    }

    // attribute error
private:
    ComPtr<IVirtualBoxErrorInfo>    m_error;
public:
    STDMETHOD(COMGETTER(Error))(IVirtualBoxErrorInfo * * a_error) RT_OVERRIDE
    {
        return m_error.queryInterfaceTo(a_error);
    }
    // purely internal setter
    inline void set_error(IVirtualBoxErrorInfo * a_error)
    {
         m_error = a_error;
    }

    // attribute file
private:
    ComPtr<IGuestFile>    m_file;
public:
    STDMETHOD(COMGETTER(File))(IGuestFile * * a_file) RT_OVERRIDE
    {
        return m_file.queryInterfaceTo(a_file);
    }
    // purely internal setter
    inline void set_file(IGuestFile * a_file)
    {
         m_file = a_file;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestFileStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(GuestFileStateChangedEvent, IGuestFileStateChangedEvent, IGuestFileEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestFileStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, FileStatus_T a_status, IVirtualBoxErrorInfo * a_error)
{
    ComObjPtr<GuestFileStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestFileStateChanged, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_file(a_file);
        EvtObj->set_status(a_status);
        EvtObj->set_error(a_error);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestFileStateChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, FileStatus_T a_status, IVirtualBoxErrorInfo * a_error)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestFileStateChangedEvent(ptrEvent.asOutParam(), aSource, a_session, a_file, a_status, a_error);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestFileOffsetChangedEvent implementation code
class ATL_NO_VTABLE GuestFileOffsetChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestFileOffsetChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestFileOffsetChangedEvent, IGuestFileOffsetChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestFileOffsetChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestFileOffsetChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestFileOffsetChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestFileOffsetChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestFileOffsetChangedEvent)
        COM_INTERFACE_ENTRY(IGuestFileOffsetChangedEvent)
        COM_INTERFACE_ENTRY(IGuestFileIOEvent)
        COM_INTERFACE_ENTRY(IGuestFileEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestFileOffsetChangedEvent() { Log12(("GuestFileOffsetChangedEvent %p\n", this)); }
    virtual ~GuestFileOffsetChangedEvent() { Log12(("~GuestFileOffsetChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute offset
private:
    LONG64    m_offset;
public:
    STDMETHOD(COMGETTER(Offset))(LONG64 * a_offset) RT_OVERRIDE
    {
        *a_offset = m_offset;
        return S_OK;
    }
    // purely internal setter
    inline void set_offset(LONG64 a_offset)
    {
         m_offset = a_offset;
    }

    // attribute processed
private:
    ULONG    m_processed;
public:
    STDMETHOD(COMGETTER(Processed))(ULONG * a_processed) RT_OVERRIDE
    {
        *a_processed = m_processed;
        return S_OK;
    }
    // purely internal setter
    inline void set_processed(ULONG a_processed)
    {
         m_processed = a_processed;
    }

    // attribute file
private:
    ComPtr<IGuestFile>    m_file;
public:
    STDMETHOD(COMGETTER(File))(IGuestFile * * a_file) RT_OVERRIDE
    {
        return m_file.queryInterfaceTo(a_file);
    }
    // purely internal setter
    inline void set_file(IGuestFile * a_file)
    {
         m_file = a_file;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestFileOffsetChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS5_CI(GuestFileOffsetChangedEvent, IGuestFileOffsetChangedEvent, IGuestFileIOEvent, IGuestFileEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestFileOffsetChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed)
{
    ComObjPtr<GuestFileOffsetChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestFileOffsetChanged, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_file(a_file);
        EvtObj->set_offset(a_offset);
        EvtObj->set_processed(a_processed);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestFileOffsetChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestFileOffsetChangedEvent(ptrEvent.asOutParam(), aSource, a_session, a_file, a_offset, a_processed);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestFileSizeChangedEvent implementation code
class ATL_NO_VTABLE GuestFileSizeChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestFileSizeChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestFileSizeChangedEvent, IGuestFileSizeChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestFileSizeChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestFileSizeChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestFileSizeChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestFileSizeChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestFileSizeChangedEvent)
        COM_INTERFACE_ENTRY(IGuestFileSizeChangedEvent)
        COM_INTERFACE_ENTRY(IGuestFileEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestFileSizeChangedEvent() { Log12(("GuestFileSizeChangedEvent %p\n", this)); }
    virtual ~GuestFileSizeChangedEvent() { Log12(("~GuestFileSizeChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute newSize
private:
    LONG64    m_newSize;
public:
    STDMETHOD(COMGETTER(NewSize))(LONG64 * a_newSize) RT_OVERRIDE
    {
        *a_newSize = m_newSize;
        return S_OK;
    }
    // purely internal setter
    inline void set_newSize(LONG64 a_newSize)
    {
         m_newSize = a_newSize;
    }

    // attribute file
private:
    ComPtr<IGuestFile>    m_file;
public:
    STDMETHOD(COMGETTER(File))(IGuestFile * * a_file) RT_OVERRIDE
    {
        return m_file.queryInterfaceTo(a_file);
    }
    // purely internal setter
    inline void set_file(IGuestFile * a_file)
    {
         m_file = a_file;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestFileSizeChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(GuestFileSizeChangedEvent, IGuestFileSizeChangedEvent, IGuestFileEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestFileSizeChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_newSize)
{
    ComObjPtr<GuestFileSizeChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestFileSizeChanged, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_file(a_file);
        EvtObj->set_newSize(a_newSize);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestFileSizeChangedEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_newSize)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestFileSizeChangedEvent(ptrEvent.asOutParam(), aSource, a_session, a_file, a_newSize);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestFileReadEvent implementation code
class ATL_NO_VTABLE GuestFileReadEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestFileReadEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestFileReadEvent, IGuestFileReadEvent)
    DECLARE_NOT_AGGREGATABLE(GuestFileReadEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestFileReadEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestFileReadEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestFileReadEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestFileReadEvent)
        COM_INTERFACE_ENTRY(IGuestFileReadEvent)
        COM_INTERFACE_ENTRY(IGuestFileIOEvent)
        COM_INTERFACE_ENTRY(IGuestFileEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestFileReadEvent() { Log12(("GuestFileReadEvent %p\n", this)); }
    virtual ~GuestFileReadEvent() { Log12(("~GuestFileReadEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute data
private:
    com::SafeArray<BYTE>    m_data;
public:
    STDMETHOD(COMGETTER(Data))(ComSafeArrayOut(BYTE, a_data)) RT_OVERRIDE
    {
        SafeArray<BYTE> result;
        HRESULT hrc = m_data.cloneTo(result);
        if (SUCCEEDED(hrc))
            result.detachTo(ComSafeArrayOutArg(a_data));
        return hrc;
    }
    // purely internal setter
    inline HRESULT set_data(ComSafeArrayIn(BYTE,a_data))
    {
        SafeArray<BYTE> aArr(ComSafeArrayInArg(a_data));
        return m_data.initFrom(aArr);
    }

    // attribute offset
private:
    LONG64    m_offset;
public:
    STDMETHOD(COMGETTER(Offset))(LONG64 * a_offset) RT_OVERRIDE
    {
        *a_offset = m_offset;
        return S_OK;
    }
    // purely internal setter
    inline void set_offset(LONG64 a_offset)
    {
         m_offset = a_offset;
    }

    // attribute processed
private:
    ULONG    m_processed;
public:
    STDMETHOD(COMGETTER(Processed))(ULONG * a_processed) RT_OVERRIDE
    {
        *a_processed = m_processed;
        return S_OK;
    }
    // purely internal setter
    inline void set_processed(ULONG a_processed)
    {
         m_processed = a_processed;
    }

    // attribute file
private:
    ComPtr<IGuestFile>    m_file;
public:
    STDMETHOD(COMGETTER(File))(IGuestFile * * a_file) RT_OVERRIDE
    {
        return m_file.queryInterfaceTo(a_file);
    }
    // purely internal setter
    inline void set_file(IGuestFile * a_file)
    {
         m_file = a_file;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestFileReadEvent)
NS_IMPL_THREADSAFE_ISUPPORTS5_CI(GuestFileReadEvent, IGuestFileReadEvent, IGuestFileIOEvent, IGuestFileEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestFileReadEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed, ComSafeArrayIn(BYTE,a_data))
{
    ComObjPtr<GuestFileReadEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestFileRead, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_file(a_file);
        EvtObj->set_offset(a_offset);
        EvtObj->set_processed(a_processed);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_data(ComSafeArrayInArg(a_data));
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestFileReadEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed, ComSafeArrayIn(BYTE,a_data))
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestFileReadEvent(ptrEvent.asOutParam(), aSource, a_session, a_file, a_offset, a_processed, ComSafeArrayInArg(a_data));
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestFileWriteEvent implementation code
class ATL_NO_VTABLE GuestFileWriteEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestFileWriteEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestFileWriteEvent, IGuestFileWriteEvent)
    DECLARE_NOT_AGGREGATABLE(GuestFileWriteEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestFileWriteEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestFileWriteEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestFileWriteEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestFileWriteEvent)
        COM_INTERFACE_ENTRY(IGuestFileWriteEvent)
        COM_INTERFACE_ENTRY(IGuestFileIOEvent)
        COM_INTERFACE_ENTRY(IGuestFileEvent)
        COM_INTERFACE_ENTRY(IGuestSessionEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestFileWriteEvent() { Log12(("GuestFileWriteEvent %p\n", this)); }
    virtual ~GuestFileWriteEvent() { Log12(("~GuestFileWriteEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute offset
private:
    LONG64    m_offset;
public:
    STDMETHOD(COMGETTER(Offset))(LONG64 * a_offset) RT_OVERRIDE
    {
        *a_offset = m_offset;
        return S_OK;
    }
    // purely internal setter
    inline void set_offset(LONG64 a_offset)
    {
         m_offset = a_offset;
    }

    // attribute processed
private:
    ULONG    m_processed;
public:
    STDMETHOD(COMGETTER(Processed))(ULONG * a_processed) RT_OVERRIDE
    {
        *a_processed = m_processed;
        return S_OK;
    }
    // purely internal setter
    inline void set_processed(ULONG a_processed)
    {
         m_processed = a_processed;
    }

    // attribute file
private:
    ComPtr<IGuestFile>    m_file;
public:
    STDMETHOD(COMGETTER(File))(IGuestFile * * a_file) RT_OVERRIDE
    {
        return m_file.queryInterfaceTo(a_file);
    }
    // purely internal setter
    inline void set_file(IGuestFile * a_file)
    {
         m_file = a_file;
    }

    // attribute session
private:
    ComPtr<IGuestSession>    m_session;
public:
    STDMETHOD(COMGETTER(Session))(IGuestSession * * a_session) RT_OVERRIDE
    {
        return m_session.queryInterfaceTo(a_session);
    }
    // purely internal setter
    inline void set_session(IGuestSession * a_session)
    {
         m_session = a_session;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestFileWriteEvent)
NS_IMPL_THREADSAFE_ISUPPORTS5_CI(GuestFileWriteEvent, IGuestFileWriteEvent, IGuestFileIOEvent, IGuestFileEvent, IGuestSessionEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestFileWriteEvent(IEvent **aEvent, IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed)
{
    ComObjPtr<GuestFileWriteEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestFileWrite, FALSE /*waitable*/);
        EvtObj->set_session(a_session);
        EvtObj->set_file(a_file);
        EvtObj->set_offset(a_offset);
        EvtObj->set_processed(a_processed);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestFileWriteEvent(IEventSource *aSource, IGuestSession * a_session, IGuestFile * a_file, LONG64 a_offset, ULONG a_processed)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestFileWriteEvent(ptrEvent.asOutParam(), aSource, a_session, a_file, a_offset, a_processed);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IVRDEServerChangedEvent implementation code
class ATL_NO_VTABLE VRDEServerChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IVRDEServerChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(VRDEServerChangedEvent, IVRDEServerChangedEvent)
    DECLARE_NOT_AGGREGATABLE(VRDEServerChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(VRDEServerChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IVRDEServerChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IVRDEServerChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IVRDEServerChangedEvent)
        COM_INTERFACE_ENTRY(IVRDEServerChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    VRDEServerChangedEvent() { Log12(("VRDEServerChangedEvent %p\n", this)); }
    virtual ~VRDEServerChangedEvent() { Log12(("~VRDEServerChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VRDEServerChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(VRDEServerChangedEvent, IVRDEServerChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateVRDEServerChangedEvent(IEvent **aEvent, IEventSource *aSource)
{
    ComObjPtr<VRDEServerChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnVRDEServerChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireVRDEServerChangedEvent(IEventSource *aSource)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateVRDEServerChangedEvent(ptrEvent.asOutParam(), aSource);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IVRDEServerInfoChangedEvent implementation code
class ATL_NO_VTABLE VRDEServerInfoChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IVRDEServerInfoChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(VRDEServerInfoChangedEvent, IVRDEServerInfoChangedEvent)
    DECLARE_NOT_AGGREGATABLE(VRDEServerInfoChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(VRDEServerInfoChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IVRDEServerInfoChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IVRDEServerInfoChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IVRDEServerInfoChangedEvent)
        COM_INTERFACE_ENTRY(IVRDEServerInfoChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    VRDEServerInfoChangedEvent() { Log12(("VRDEServerInfoChangedEvent %p\n", this)); }
    virtual ~VRDEServerInfoChangedEvent() { Log12(("~VRDEServerInfoChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VRDEServerInfoChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(VRDEServerInfoChangedEvent, IVRDEServerInfoChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateVRDEServerInfoChangedEvent(IEvent **aEvent, IEventSource *aSource)
{
    ComObjPtr<VRDEServerInfoChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnVRDEServerInfoChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireVRDEServerInfoChangedEvent(IEventSource *aSource)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateVRDEServerInfoChangedEvent(ptrEvent.asOutParam(), aSource);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IRecordingStateChangedEvent implementation code
class ATL_NO_VTABLE RecordingStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IRecordingStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(RecordingStateChangedEvent, IRecordingStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(RecordingStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(RecordingStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IRecordingStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IRecordingStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IRecordingStateChangedEvent)
        COM_INTERFACE_ENTRY(IRecordingStateChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    RecordingStateChangedEvent() { Log12(("RecordingStateChangedEvent %p\n", this)); }
    virtual ~RecordingStateChangedEvent() { Log12(("~RecordingStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute state
private:
    RecordingState_T    m_state;
public:
    STDMETHOD(COMGETTER(State))(RecordingState_T * a_state) RT_OVERRIDE
    {
        *a_state = m_state;
        return S_OK;
    }
    // purely internal setter
    inline void set_state(RecordingState_T a_state)
    {
         m_state = a_state;
    }

    // attribute error
private:
    ComPtr<IVirtualBoxErrorInfo>    m_error;
public:
    STDMETHOD(COMGETTER(Error))(IVirtualBoxErrorInfo * * a_error) RT_OVERRIDE
    {
        return m_error.queryInterfaceTo(a_error);
    }
    // purely internal setter
    inline void set_error(IVirtualBoxErrorInfo * a_error)
    {
         m_error = a_error;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(RecordingStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(RecordingStateChangedEvent, IRecordingStateChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateRecordingStateChangedEvent(IEvent **aEvent, IEventSource *aSource, RecordingState_T a_state, IVirtualBoxErrorInfo * a_error)
{
    ComObjPtr<RecordingStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnRecordingStateChanged, FALSE /*waitable*/);
        EvtObj->set_state(a_state);
        EvtObj->set_error(a_error);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireRecordingStateChangedEvent(IEventSource *aSource, RecordingState_T a_state, IVirtualBoxErrorInfo * a_error)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateRecordingStateChangedEvent(ptrEvent.asOutParam(), aSource, a_state, a_error);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IRecordingScreenStateChangedEvent implementation code
class ATL_NO_VTABLE RecordingScreenStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IRecordingScreenStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(RecordingScreenStateChangedEvent, IRecordingScreenStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(RecordingScreenStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(RecordingScreenStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IRecordingScreenStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IRecordingScreenStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IRecordingScreenStateChangedEvent)
        COM_INTERFACE_ENTRY(IRecordingScreenStateChangedEvent)
        COM_INTERFACE_ENTRY(IRecordingStateChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    RecordingScreenStateChangedEvent() { Log12(("RecordingScreenStateChangedEvent %p\n", this)); }
    virtual ~RecordingScreenStateChangedEvent() { Log12(("~RecordingScreenStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute screen
private:
    ULONG    m_screen;
public:
    STDMETHOD(COMGETTER(Screen))(ULONG * a_screen) RT_OVERRIDE
    {
        *a_screen = m_screen;
        return S_OK;
    }
    // purely internal setter
    inline void set_screen(ULONG a_screen)
    {
         m_screen = a_screen;
    }

    // attribute state
private:
    RecordingState_T    m_state;
public:
    STDMETHOD(COMGETTER(State))(RecordingState_T * a_state) RT_OVERRIDE
    {
        *a_state = m_state;
        return S_OK;
    }
    // purely internal setter
    inline void set_state(RecordingState_T a_state)
    {
         m_state = a_state;
    }

    // attribute error
private:
    ComPtr<IVirtualBoxErrorInfo>    m_error;
public:
    STDMETHOD(COMGETTER(Error))(IVirtualBoxErrorInfo * * a_error) RT_OVERRIDE
    {
        return m_error.queryInterfaceTo(a_error);
    }
    // purely internal setter
    inline void set_error(IVirtualBoxErrorInfo * a_error)
    {
         m_error = a_error;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(RecordingScreenStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(RecordingScreenStateChangedEvent, IRecordingScreenStateChangedEvent, IRecordingStateChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateRecordingScreenStateChangedEvent(IEvent **aEvent, IEventSource *aSource, RecordingState_T a_state, IVirtualBoxErrorInfo * a_error, ULONG a_screen)
{
    ComObjPtr<RecordingScreenStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnRecordingScreenStateChanged, FALSE /*waitable*/);
        EvtObj->set_state(a_state);
        EvtObj->set_error(a_error);
        EvtObj->set_screen(a_screen);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireRecordingScreenStateChangedEvent(IEventSource *aSource, RecordingState_T a_state, IVirtualBoxErrorInfo * a_error, ULONG a_screen)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateRecordingScreenStateChangedEvent(ptrEvent.asOutParam(), aSource, a_state, a_error, a_screen);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IUSBControllerChangedEvent implementation code
class ATL_NO_VTABLE USBControllerChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IUSBControllerChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(USBControllerChangedEvent, IUSBControllerChangedEvent)
    DECLARE_NOT_AGGREGATABLE(USBControllerChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(USBControllerChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IUSBControllerChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IUSBControllerChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IUSBControllerChangedEvent)
        COM_INTERFACE_ENTRY(IUSBControllerChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    USBControllerChangedEvent() { Log12(("USBControllerChangedEvent %p\n", this)); }
    virtual ~USBControllerChangedEvent() { Log12(("~USBControllerChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(USBControllerChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(USBControllerChangedEvent, IUSBControllerChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateUSBControllerChangedEvent(IEvent **aEvent, IEventSource *aSource)
{
    ComObjPtr<USBControllerChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnUSBControllerChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireUSBControllerChangedEvent(IEventSource *aSource)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateUSBControllerChangedEvent(ptrEvent.asOutParam(), aSource);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IUSBDeviceStateChangedEvent implementation code
class ATL_NO_VTABLE USBDeviceStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IUSBDeviceStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(USBDeviceStateChangedEvent, IUSBDeviceStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(USBDeviceStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(USBDeviceStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IUSBDeviceStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IUSBDeviceStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IUSBDeviceStateChangedEvent)
        COM_INTERFACE_ENTRY(IUSBDeviceStateChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    USBDeviceStateChangedEvent() { Log12(("USBDeviceStateChangedEvent %p\n", this)); }
    virtual ~USBDeviceStateChangedEvent() { Log12(("~USBDeviceStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute device
private:
    ComPtr<IUSBDevice>    m_device;
public:
    STDMETHOD(COMGETTER(Device))(IUSBDevice * * a_device) RT_OVERRIDE
    {
        return m_device.queryInterfaceTo(a_device);
    }
    // purely internal setter
    inline void set_device(IUSBDevice * a_device)
    {
         m_device = a_device;
    }

    // attribute attached
private:
    BOOL    m_attached;
public:
    STDMETHOD(COMGETTER(Attached))(BOOL * a_attached) RT_OVERRIDE
    {
        *a_attached = m_attached;
        return S_OK;
    }
    // purely internal setter
    inline void set_attached(BOOL a_attached)
    {
         m_attached = a_attached;
    }

    // attribute error
private:
    ComPtr<IVirtualBoxErrorInfo>    m_error;
public:
    STDMETHOD(COMGETTER(Error))(IVirtualBoxErrorInfo * * a_error) RT_OVERRIDE
    {
        return m_error.queryInterfaceTo(a_error);
    }
    // purely internal setter
    inline void set_error(IVirtualBoxErrorInfo * a_error)
    {
         m_error = a_error;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(USBDeviceStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(USBDeviceStateChangedEvent, IUSBDeviceStateChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateUSBDeviceStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IUSBDevice * a_device, BOOL a_attached, IVirtualBoxErrorInfo * a_error)
{
    ComObjPtr<USBDeviceStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnUSBDeviceStateChanged, FALSE /*waitable*/);
        EvtObj->set_device(a_device);
        EvtObj->set_attached(a_attached);
        EvtObj->set_error(a_error);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireUSBDeviceStateChangedEvent(IEventSource *aSource, IUSBDevice * a_device, BOOL a_attached, IVirtualBoxErrorInfo * a_error)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateUSBDeviceStateChangedEvent(ptrEvent.asOutParam(), aSource, a_device, a_attached, a_error);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ISharedFolderChangedEvent implementation code
class ATL_NO_VTABLE SharedFolderChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ISharedFolderChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(SharedFolderChangedEvent, ISharedFolderChangedEvent)
    DECLARE_NOT_AGGREGATABLE(SharedFolderChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(SharedFolderChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ISharedFolderChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ISharedFolderChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ISharedFolderChangedEvent)
        COM_INTERFACE_ENTRY(ISharedFolderChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    SharedFolderChangedEvent() { Log12(("SharedFolderChangedEvent %p\n", this)); }
    virtual ~SharedFolderChangedEvent() { Log12(("~SharedFolderChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute scope
private:
    Scope_T    m_scope;
public:
    STDMETHOD(COMGETTER(Scope))(Scope_T * a_scope) RT_OVERRIDE
    {
        *a_scope = m_scope;
        return S_OK;
    }
    // purely internal setter
    inline void set_scope(Scope_T a_scope)
    {
         m_scope = a_scope;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SharedFolderChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(SharedFolderChangedEvent, ISharedFolderChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateSharedFolderChangedEvent(IEvent **aEvent, IEventSource *aSource, Scope_T a_scope)
{
    ComObjPtr<SharedFolderChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnSharedFolderChanged, FALSE /*waitable*/);
        EvtObj->set_scope(a_scope);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireSharedFolderChangedEvent(IEventSource *aSource, Scope_T a_scope)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateSharedFolderChangedEvent(ptrEvent.asOutParam(), aSource, a_scope);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IRuntimeErrorEvent implementation code
class ATL_NO_VTABLE RuntimeErrorEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IRuntimeErrorEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(RuntimeErrorEvent, IRuntimeErrorEvent)
    DECLARE_NOT_AGGREGATABLE(RuntimeErrorEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(RuntimeErrorEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IRuntimeErrorEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IRuntimeErrorEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IRuntimeErrorEvent)
        COM_INTERFACE_ENTRY(IRuntimeErrorEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    RuntimeErrorEvent() { Log12(("RuntimeErrorEvent %p\n", this)); }
    virtual ~RuntimeErrorEvent() { Log12(("~RuntimeErrorEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute fatal
private:
    BOOL    m_fatal;
public:
    STDMETHOD(COMGETTER(Fatal))(BOOL * a_fatal) RT_OVERRIDE
    {
        *a_fatal = m_fatal;
        return S_OK;
    }
    // purely internal setter
    inline void set_fatal(BOOL a_fatal)
    {
         m_fatal = a_fatal;
    }

    // attribute id
private:
    Utf8Str    m_id;
public:
    STDMETHOD(COMGETTER(Id))(BSTR * a_id) RT_OVERRIDE
    {
        return m_id.cloneToEx(a_id);
    }
    // purely internal setter
    inline HRESULT set_id(const Utf8Str &a_rString)
    {
        return m_id.assignEx(a_rString);
    }
    inline HRESULT set_id(CBSTR a_id)
    {
        return m_id.assignEx(a_id);
    }

    // attribute message
private:
    Utf8Str    m_message;
public:
    STDMETHOD(COMGETTER(Message))(BSTR * a_message) RT_OVERRIDE
    {
        return m_message.cloneToEx(a_message);
    }
    // purely internal setter
    inline HRESULT set_message(const Utf8Str &a_rString)
    {
        return m_message.assignEx(a_rString);
    }
    inline HRESULT set_message(CBSTR a_message)
    {
        return m_message.assignEx(a_message);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(RuntimeErrorEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(RuntimeErrorEvent, IRuntimeErrorEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateRuntimeErrorEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_fatal, const Utf8Str & a_id, const Utf8Str & a_message)
{
    ComObjPtr<RuntimeErrorEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnRuntimeError, FALSE /*waitable*/);
        EvtObj->set_fatal(a_fatal);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_id(a_id);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_message(a_message);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) CreateRuntimeErrorEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_fatal, CBSTR a_id, CBSTR a_message)
{
    ComObjPtr<RuntimeErrorEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnRuntimeError, FALSE /*waitable*/);
        EvtObj->set_fatal(a_fatal);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_id(a_id);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_message(a_message);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireRuntimeErrorEvent(IEventSource *aSource, BOOL a_fatal, const Utf8Str & a_id, const Utf8Str & a_message)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateRuntimeErrorEvent(ptrEvent.asOutParam(), aSource, a_fatal, a_id, a_message);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

DECLHIDDEN(HRESULT) FireRuntimeErrorEvent(IEventSource *aSource, BOOL a_fatal, CBSTR a_id, CBSTR a_message)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateRuntimeErrorEvent(ptrEvent.asOutParam(), aSource, a_fatal, a_id, a_message);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IEventSourceChangedEvent implementation code
class ATL_NO_VTABLE EventSourceChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IEventSourceChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(EventSourceChangedEvent, IEventSourceChangedEvent)
    DECLARE_NOT_AGGREGATABLE(EventSourceChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(EventSourceChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IEventSourceChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IEventSourceChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IEventSourceChangedEvent)
        COM_INTERFACE_ENTRY(IEventSourceChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    EventSourceChangedEvent() { Log12(("EventSourceChangedEvent %p\n", this)); }
    virtual ~EventSourceChangedEvent() { Log12(("~EventSourceChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute listener
private:
    ComPtr<IEventListener>    m_listener;
public:
    STDMETHOD(COMGETTER(Listener))(IEventListener * * a_listener) RT_OVERRIDE
    {
        return m_listener.queryInterfaceTo(a_listener);
    }
    // purely internal setter
    inline void set_listener(IEventListener * a_listener)
    {
         m_listener = a_listener;
    }

    // attribute add
private:
    BOOL    m_add;
public:
    STDMETHOD(COMGETTER(Add))(BOOL * a_add) RT_OVERRIDE
    {
        *a_add = m_add;
        return S_OK;
    }
    // purely internal setter
    inline void set_add(BOOL a_add)
    {
         m_add = a_add;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(EventSourceChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(EventSourceChangedEvent, IEventSourceChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateEventSourceChangedEvent(IEvent **aEvent, IEventSource *aSource, IEventListener * a_listener, BOOL a_add)
{
    ComObjPtr<EventSourceChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnEventSourceChanged, TRUE /*waitable*/);
        EvtObj->set_listener(a_listener);
        EvtObj->set_add(a_add);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireEventSourceChangedEvent(IEventSource *aSource, IEventListener * a_listener, BOOL a_add)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateEventSourceChangedEvent(ptrEvent.asOutParam(), aSource, a_listener, a_add);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IExtraDataChangedEvent implementation code
class ATL_NO_VTABLE ExtraDataChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IExtraDataChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ExtraDataChangedEvent, IExtraDataChangedEvent)
    DECLARE_NOT_AGGREGATABLE(ExtraDataChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ExtraDataChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IExtraDataChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IExtraDataChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IExtraDataChangedEvent)
        COM_INTERFACE_ENTRY(IExtraDataChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ExtraDataChangedEvent() { Log12(("ExtraDataChangedEvent %p\n", this)); }
    virtual ~ExtraDataChangedEvent() { Log12(("~ExtraDataChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    inline HRESULT set_machineId(CBSTR a_machineId)
    {
        return m_machineId.assignEx(a_machineId);
    }

    // attribute key
private:
    Utf8Str    m_key;
public:
    STDMETHOD(COMGETTER(Key))(BSTR * a_key) RT_OVERRIDE
    {
        return m_key.cloneToEx(a_key);
    }
    // purely internal setter
    inline HRESULT set_key(const Utf8Str &a_rString)
    {
        return m_key.assignEx(a_rString);
    }
    inline HRESULT set_key(CBSTR a_key)
    {
        return m_key.assignEx(a_key);
    }

    // attribute value
private:
    Utf8Str    m_value;
public:
    STDMETHOD(COMGETTER(Value))(BSTR * a_value) RT_OVERRIDE
    {
        return m_value.cloneToEx(a_value);
    }
    // purely internal setter
    inline HRESULT set_value(const Utf8Str &a_rString)
    {
        return m_value.assignEx(a_rString);
    }
    inline HRESULT set_value(CBSTR a_value)
    {
        return m_value.assignEx(a_value);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ExtraDataChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ExtraDataChangedEvent, IExtraDataChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateExtraDataChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_key, const Utf8Str & a_value)
{
    ComObjPtr<ExtraDataChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnExtraDataChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_key(a_key);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_value(a_value);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) CreateExtraDataChangedEvent(IEvent **aEvent, IEventSource *aSource, CBSTR a_machineId, CBSTR a_key, CBSTR a_value)
{
    ComObjPtr<ExtraDataChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnExtraDataChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_key(a_key);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_value(a_value);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireExtraDataChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_key, const Utf8Str & a_value)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateExtraDataChangedEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_key, a_value);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

DECLHIDDEN(HRESULT) FireExtraDataChangedEvent(IEventSource *aSource, CBSTR a_machineId, CBSTR a_key, CBSTR a_value)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateExtraDataChangedEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_key, a_value);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IExtraDataCanChangeEvent implementation code
class ATL_NO_VTABLE ExtraDataCanChangeEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IExtraDataCanChangeEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ExtraDataCanChangeEvent, IExtraDataCanChangeEvent)
    DECLARE_NOT_AGGREGATABLE(ExtraDataCanChangeEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ExtraDataCanChangeEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IExtraDataCanChangeEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IExtraDataCanChangeEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IExtraDataCanChangeEvent)
        COM_INTERFACE_ENTRY(IExtraDataCanChangeEvent)
        COM_INTERFACE_ENTRY(IVetoEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ExtraDataCanChangeEvent() { Log12(("ExtraDataCanChangeEvent %p\n", this)); }
    virtual ~ExtraDataCanChangeEvent() { Log12(("~ExtraDataCanChangeEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable = TRUE)
    {
        NOREF(aWaitable);
        return mEvent->init(aSource, aType);
    }
    STDMETHOD(AddVeto)(IN_BSTR aVeto) RT_OVERRIDE
    {
        return mEvent->AddVeto(aVeto);
    }
    STDMETHOD(IsVetoed)(BOOL *aResult) RT_OVERRIDE
    {
       return mEvent->IsVetoed(aResult);
    }
    STDMETHOD(GetVetos)(ComSafeArrayOut(BSTR, aVetos)) RT_OVERRIDE
    {
       return mEvent->GetVetos(ComSafeArrayOutArg(aVetos));
    }
    STDMETHOD(AddApproval)(IN_BSTR aReason) RT_OVERRIDE
    {
        return mEvent->AddApproval(aReason);
    }
    STDMETHOD(IsApproved)(BOOL *aResult) RT_OVERRIDE
    {
       return mEvent->IsApproved(aResult);
    }
    STDMETHOD(GetApprovals)(ComSafeArrayOut(BSTR, aReasons)) RT_OVERRIDE
    {
       return mEvent->GetApprovals(ComSafeArrayOutArg(aReasons));
    }
private:
    ComObjPtr<VBoxVetoEvent>      mEvent;

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }

    // attribute key
private:
    Utf8Str    m_key;
public:
    STDMETHOD(COMGETTER(Key))(BSTR * a_key) RT_OVERRIDE
    {
        return m_key.cloneToEx(a_key);
    }
    // purely internal setter
    inline HRESULT set_key(const Utf8Str &a_rString)
    {
        return m_key.assignEx(a_rString);
    }

    // attribute value
private:
    Utf8Str    m_value;
public:
    STDMETHOD(COMGETTER(Value))(BSTR * a_value) RT_OVERRIDE
    {
        return m_value.cloneToEx(a_value);
    }
    // purely internal setter
    inline HRESULT set_value(const Utf8Str &a_rString)
    {
        return m_value.assignEx(a_rString);
    }
    // skipping IVetoEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ExtraDataCanChangeEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(ExtraDataCanChangeEvent, IExtraDataCanChangeEvent, IVetoEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateExtraDataCanChangeEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_key, const Utf8Str & a_value)
{
    ComObjPtr<ExtraDataCanChangeEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnExtraDataCanChange, TRUE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_key(a_key);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_value(a_value);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireExtraDataCanChangeEvent(IEventSource *aSource, const Utf8Str & a_machineId, const Utf8Str & a_key, const Utf8Str & a_value)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateExtraDataCanChangeEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_key, a_value);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ICanShowWindowEvent implementation code
class ATL_NO_VTABLE CanShowWindowEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICanShowWindowEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CanShowWindowEvent, ICanShowWindowEvent)
    DECLARE_NOT_AGGREGATABLE(CanShowWindowEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(CanShowWindowEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICanShowWindowEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ICanShowWindowEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ICanShowWindowEvent)
        COM_INTERFACE_ENTRY(ICanShowWindowEvent)
        COM_INTERFACE_ENTRY(IVetoEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    CanShowWindowEvent() { Log12(("CanShowWindowEvent %p\n", this)); }
    virtual ~CanShowWindowEvent() { Log12(("~CanShowWindowEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable = TRUE)
    {
        NOREF(aWaitable);
        return mEvent->init(aSource, aType);
    }
    STDMETHOD(AddVeto)(IN_BSTR aVeto) RT_OVERRIDE
    {
        return mEvent->AddVeto(aVeto);
    }
    STDMETHOD(IsVetoed)(BOOL *aResult) RT_OVERRIDE
    {
       return mEvent->IsVetoed(aResult);
    }
    STDMETHOD(GetVetos)(ComSafeArrayOut(BSTR, aVetos)) RT_OVERRIDE
    {
       return mEvent->GetVetos(ComSafeArrayOutArg(aVetos));
    }
    STDMETHOD(AddApproval)(IN_BSTR aReason) RT_OVERRIDE
    {
        return mEvent->AddApproval(aReason);
    }
    STDMETHOD(IsApproved)(BOOL *aResult) RT_OVERRIDE
    {
       return mEvent->IsApproved(aResult);
    }
    STDMETHOD(GetApprovals)(ComSafeArrayOut(BSTR, aReasons)) RT_OVERRIDE
    {
       return mEvent->GetApprovals(ComSafeArrayOutArg(aReasons));
    }
private:
    ComObjPtr<VBoxVetoEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }
    // skipping IVetoEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CanShowWindowEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(CanShowWindowEvent, ICanShowWindowEvent, IVetoEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateCanShowWindowEvent(IEvent **aEvent, IEventSource *aSource)
{
    ComObjPtr<CanShowWindowEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnCanShowWindow, TRUE /*waitable*/);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireCanShowWindowEvent(IEventSource *aSource)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateCanShowWindowEvent(ptrEvent.asOutParam(), aSource);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IShowWindowEvent implementation code
class ATL_NO_VTABLE ShowWindowEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IShowWindowEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ShowWindowEvent, IShowWindowEvent)
    DECLARE_NOT_AGGREGATABLE(ShowWindowEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ShowWindowEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IShowWindowEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IShowWindowEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IShowWindowEvent)
        COM_INTERFACE_ENTRY(IShowWindowEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ShowWindowEvent() { Log12(("ShowWindowEvent %p\n", this)); }
    virtual ~ShowWindowEvent() { Log12(("~ShowWindowEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute winId
private:
    LONG64    m_winId;
public:
    STDMETHOD(COMGETTER(WinId))(LONG64 * a_winId) RT_OVERRIDE
    {
        *a_winId = m_winId;
        return S_OK;
    }
    STDMETHOD(COMSETTER(WinId))(LONG64 a_winId) RT_OVERRIDE
    {
         m_winId = a_winId;
        return S_OK;
    }
    // purely internal setter
    inline void set_winId(LONG64 a_winId)
    {
         m_winId = a_winId;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ShowWindowEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ShowWindowEvent, IShowWindowEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateShowWindowEvent(IEvent **aEvent, IEventSource *aSource, LONG64 a_winId)
{
    ComObjPtr<ShowWindowEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnShowWindow, TRUE /*waitable*/);
        EvtObj->set_winId(a_winId);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireShowWindowEvent(IEventSource *aSource, LONG64 a_winId)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateShowWindowEvent(ptrEvent.asOutParam(), aSource, a_winId);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// INATRedirectEvent implementation code
class ATL_NO_VTABLE NATRedirectEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(INATRedirectEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(NATRedirectEvent, INATRedirectEvent)
    DECLARE_NOT_AGGREGATABLE(NATRedirectEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(NATRedirectEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(INATRedirectEvent)
        COM_INTERFACE_ENTRY2(IDispatch, INATRedirectEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(INATRedirectEvent)
        COM_INTERFACE_ENTRY(INATRedirectEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    NATRedirectEvent() { Log12(("NATRedirectEvent %p\n", this)); }
    virtual ~NATRedirectEvent() { Log12(("~NATRedirectEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute slot
private:
    ULONG    m_slot;
public:
    STDMETHOD(COMGETTER(Slot))(ULONG * a_slot) RT_OVERRIDE
    {
        *a_slot = m_slot;
        return S_OK;
    }
    // purely internal setter
    inline void set_slot(ULONG a_slot)
    {
         m_slot = a_slot;
    }

    // attribute remove
private:
    BOOL    m_remove;
public:
    STDMETHOD(COMGETTER(Remove))(BOOL * a_remove) RT_OVERRIDE
    {
        *a_remove = m_remove;
        return S_OK;
    }
    // purely internal setter
    inline void set_remove(BOOL a_remove)
    {
         m_remove = a_remove;
    }

    // attribute name
private:
    Utf8Str    m_name;
public:
    STDMETHOD(COMGETTER(Name))(BSTR * a_name) RT_OVERRIDE
    {
        return m_name.cloneToEx(a_name);
    }
    // purely internal setter
    inline HRESULT set_name(const Utf8Str &a_rString)
    {
        return m_name.assignEx(a_rString);
    }

    // attribute proto
private:
    NATProtocol_T    m_proto;
public:
    STDMETHOD(COMGETTER(Proto))(NATProtocol_T * a_proto) RT_OVERRIDE
    {
        *a_proto = m_proto;
        return S_OK;
    }
    // purely internal setter
    inline void set_proto(NATProtocol_T a_proto)
    {
         m_proto = a_proto;
    }

    // attribute hostIP
private:
    Utf8Str    m_hostIP;
public:
    STDMETHOD(COMGETTER(HostIP))(BSTR * a_hostIP) RT_OVERRIDE
    {
        return m_hostIP.cloneToEx(a_hostIP);
    }
    // purely internal setter
    inline HRESULT set_hostIP(const Utf8Str &a_rString)
    {
        return m_hostIP.assignEx(a_rString);
    }

    // attribute hostPort
private:
    LONG    m_hostPort;
public:
    STDMETHOD(COMGETTER(HostPort))(LONG * a_hostPort) RT_OVERRIDE
    {
        *a_hostPort = m_hostPort;
        return S_OK;
    }
    // purely internal setter
    inline void set_hostPort(LONG a_hostPort)
    {
         m_hostPort = a_hostPort;
    }

    // attribute guestIP
private:
    Utf8Str    m_guestIP;
public:
    STDMETHOD(COMGETTER(GuestIP))(BSTR * a_guestIP) RT_OVERRIDE
    {
        return m_guestIP.cloneToEx(a_guestIP);
    }
    // purely internal setter
    inline HRESULT set_guestIP(const Utf8Str &a_rString)
    {
        return m_guestIP.assignEx(a_rString);
    }

    // attribute guestPort
private:
    LONG    m_guestPort;
public:
    STDMETHOD(COMGETTER(GuestPort))(LONG * a_guestPort) RT_OVERRIDE
    {
        *a_guestPort = m_guestPort;
        return S_OK;
    }
    // purely internal setter
    inline void set_guestPort(LONG a_guestPort)
    {
         m_guestPort = a_guestPort;
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NATRedirectEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(NATRedirectEvent, INATRedirectEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateNATRedirectEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, ULONG a_slot, BOOL a_remove, const Utf8Str & a_name, NATProtocol_T a_proto, const Utf8Str & a_hostIP, LONG a_hostPort, const Utf8Str & a_guestIP, LONG a_guestPort)
{
    ComObjPtr<NATRedirectEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnNATRedirect, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        EvtObj->set_slot(a_slot);
        EvtObj->set_remove(a_remove);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_name(a_name);
        EvtObj->set_proto(a_proto);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_hostIP(a_hostIP);
        EvtObj->set_hostPort(a_hostPort);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_guestIP(a_guestIP);
        EvtObj->set_guestPort(a_guestPort);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireNATRedirectEvent(IEventSource *aSource, const Utf8Str & a_machineId, ULONG a_slot, BOOL a_remove, const Utf8Str & a_name, NATProtocol_T a_proto, const Utf8Str & a_hostIP, LONG a_hostPort, const Utf8Str & a_guestIP, LONG a_guestPort)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateNATRedirectEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_slot, a_remove, a_name, a_proto, a_hostIP, a_hostPort, a_guestIP, a_guestPort);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IHostAudioDeviceChangedEvent implementation code
class ATL_NO_VTABLE HostAudioDeviceChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IHostAudioDeviceChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(HostAudioDeviceChangedEvent, IHostAudioDeviceChangedEvent)
    DECLARE_NOT_AGGREGATABLE(HostAudioDeviceChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(HostAudioDeviceChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IHostAudioDeviceChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IHostAudioDeviceChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IHostAudioDeviceChangedEvent)
        COM_INTERFACE_ENTRY(IHostAudioDeviceChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    HostAudioDeviceChangedEvent() { Log12(("HostAudioDeviceChangedEvent %p\n", this)); }
    virtual ~HostAudioDeviceChangedEvent() { Log12(("~HostAudioDeviceChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute device
private:
    ComPtr<IHostAudioDevice>    m_device;
public:
    STDMETHOD(COMGETTER(Device))(IHostAudioDevice * * a_device) RT_OVERRIDE
    {
        return m_device.queryInterfaceTo(a_device);
    }
    // purely internal setter
    inline void set_device(IHostAudioDevice * a_device)
    {
         m_device = a_device;
    }

    // attribute new
private:
    BOOL    m_new;
public:
    STDMETHOD(COMGETTER(New))(BOOL * a_new) RT_OVERRIDE
    {
        *a_new = m_new;
        return S_OK;
    }
    // purely internal setter
    inline void set_new(BOOL a_new)
    {
         m_new = a_new;
    }

    // attribute state
private:
    AudioDeviceState_T    m_state;
public:
    STDMETHOD(COMGETTER(State))(AudioDeviceState_T * a_state) RT_OVERRIDE
    {
        *a_state = m_state;
        return S_OK;
    }
    // purely internal setter
    inline void set_state(AudioDeviceState_T a_state)
    {
         m_state = a_state;
    }

    // attribute error
private:
    ComPtr<IVirtualBoxErrorInfo>    m_error;
public:
    STDMETHOD(COMGETTER(Error))(IVirtualBoxErrorInfo * * a_error) RT_OVERRIDE
    {
        return m_error.queryInterfaceTo(a_error);
    }
    // purely internal setter
    inline void set_error(IVirtualBoxErrorInfo * a_error)
    {
         m_error = a_error;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostAudioDeviceChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(HostAudioDeviceChangedEvent, IHostAudioDeviceChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateHostAudioDeviceChangedEvent(IEvent **aEvent, IEventSource *aSource, IHostAudioDevice * a_device, BOOL a_new, AudioDeviceState_T a_state, IVirtualBoxErrorInfo * a_error)
{
    ComObjPtr<HostAudioDeviceChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnHostAudioDeviceChanged, TRUE /*waitable*/);
        EvtObj->set_device(a_device);
        EvtObj->set_new(a_new);
        EvtObj->set_state(a_state);
        EvtObj->set_error(a_error);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireHostAudioDeviceChangedEvent(IEventSource *aSource, IHostAudioDevice * a_device, BOOL a_new, AudioDeviceState_T a_state, IVirtualBoxErrorInfo * a_error)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateHostAudioDeviceChangedEvent(ptrEvent.asOutParam(), aSource, a_device, a_new, a_state, a_error);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IHostPCIDevicePlugEvent implementation code
class ATL_NO_VTABLE HostPCIDevicePlugEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IHostPCIDevicePlugEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(HostPCIDevicePlugEvent, IHostPCIDevicePlugEvent)
    DECLARE_NOT_AGGREGATABLE(HostPCIDevicePlugEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(HostPCIDevicePlugEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IHostPCIDevicePlugEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IHostPCIDevicePlugEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IHostPCIDevicePlugEvent)
        COM_INTERFACE_ENTRY(IHostPCIDevicePlugEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    HostPCIDevicePlugEvent() { Log12(("HostPCIDevicePlugEvent %p\n", this)); }
    virtual ~HostPCIDevicePlugEvent() { Log12(("~HostPCIDevicePlugEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute plugged
private:
    BOOL    m_plugged;
public:
    STDMETHOD(COMGETTER(Plugged))(BOOL * a_plugged) RT_OVERRIDE
    {
        *a_plugged = m_plugged;
        return S_OK;
    }
    // purely internal setter
    inline void set_plugged(BOOL a_plugged)
    {
         m_plugged = a_plugged;
    }

    // attribute success
private:
    BOOL    m_success;
public:
    STDMETHOD(COMGETTER(Success))(BOOL * a_success) RT_OVERRIDE
    {
        *a_success = m_success;
        return S_OK;
    }
    // purely internal setter
    inline void set_success(BOOL a_success)
    {
         m_success = a_success;
    }

    // attribute attachment
private:
    ComPtr<IPCIDeviceAttachment>    m_attachment;
public:
    STDMETHOD(COMGETTER(Attachment))(IPCIDeviceAttachment * * a_attachment) RT_OVERRIDE
    {
        return m_attachment.queryInterfaceTo(a_attachment);
    }
    // purely internal setter
    inline void set_attachment(IPCIDeviceAttachment * a_attachment)
    {
         m_attachment = a_attachment;
    }

    // attribute message
private:
    Utf8Str    m_message;
public:
    STDMETHOD(COMGETTER(Message))(BSTR * a_message) RT_OVERRIDE
    {
        return m_message.cloneToEx(a_message);
    }
    // purely internal setter
    inline HRESULT set_message(const Utf8Str &a_rString)
    {
        return m_message.assignEx(a_rString);
    }
    inline HRESULT set_message(CBSTR a_message)
    {
        return m_message.assignEx(a_message);
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    inline HRESULT set_machineId(CBSTR a_machineId)
    {
        return m_machineId.assignEx(a_machineId);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostPCIDevicePlugEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(HostPCIDevicePlugEvent, IHostPCIDevicePlugEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateHostPCIDevicePlugEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_plugged, BOOL a_success, IPCIDeviceAttachment * a_attachment, const Utf8Str & a_message)
{
    ComObjPtr<HostPCIDevicePlugEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnHostPCIDevicePlug, TRUE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        EvtObj->set_plugged(a_plugged);
        EvtObj->set_success(a_success);
        EvtObj->set_attachment(a_attachment);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_message(a_message);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) CreateHostPCIDevicePlugEvent(IEvent **aEvent, IEventSource *aSource, CBSTR a_machineId, BOOL a_plugged, BOOL a_success, IPCIDeviceAttachment * a_attachment, CBSTR a_message)
{
    ComObjPtr<HostPCIDevicePlugEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnHostPCIDevicePlug, TRUE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        EvtObj->set_plugged(a_plugged);
        EvtObj->set_success(a_success);
        EvtObj->set_attachment(a_attachment);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_message(a_message);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireHostPCIDevicePlugEvent(IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_plugged, BOOL a_success, IPCIDeviceAttachment * a_attachment, const Utf8Str & a_message)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateHostPCIDevicePlugEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_plugged, a_success, a_attachment, a_message);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

DECLHIDDEN(HRESULT) FireHostPCIDevicePlugEvent(IEventSource *aSource, CBSTR a_machineId, BOOL a_plugged, BOOL a_success, IPCIDeviceAttachment * a_attachment, CBSTR a_message)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateHostPCIDevicePlugEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_plugged, a_success, a_attachment, a_message);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IVBoxSVCAvailabilityChangedEvent implementation code
class ATL_NO_VTABLE VBoxSVCAvailabilityChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IVBoxSVCAvailabilityChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(VBoxSVCAvailabilityChangedEvent, IVBoxSVCAvailabilityChangedEvent)
    DECLARE_NOT_AGGREGATABLE(VBoxSVCAvailabilityChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(VBoxSVCAvailabilityChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IVBoxSVCAvailabilityChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IVBoxSVCAvailabilityChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IVBoxSVCAvailabilityChangedEvent)
        COM_INTERFACE_ENTRY(IVBoxSVCAvailabilityChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    VBoxSVCAvailabilityChangedEvent() { Log12(("VBoxSVCAvailabilityChangedEvent %p\n", this)); }
    virtual ~VBoxSVCAvailabilityChangedEvent() { Log12(("~VBoxSVCAvailabilityChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute available
private:
    BOOL    m_available;
public:
    STDMETHOD(COMGETTER(Available))(BOOL * a_available) RT_OVERRIDE
    {
        *a_available = m_available;
        return S_OK;
    }
    // purely internal setter
    inline void set_available(BOOL a_available)
    {
         m_available = a_available;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VBoxSVCAvailabilityChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(VBoxSVCAvailabilityChangedEvent, IVBoxSVCAvailabilityChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateVBoxSVCAvailabilityChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_available)
{
    ComObjPtr<VBoxSVCAvailabilityChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnVBoxSVCAvailabilityChanged, FALSE /*waitable*/);
        EvtObj->set_available(a_available);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireVBoxSVCAvailabilityChangedEvent(IEventSource *aSource, BOOL a_available)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateVBoxSVCAvailabilityChangedEvent(ptrEvent.asOutParam(), aSource, a_available);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IBandwidthGroupChangedEvent implementation code
class ATL_NO_VTABLE BandwidthGroupChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IBandwidthGroupChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(BandwidthGroupChangedEvent, IBandwidthGroupChangedEvent)
    DECLARE_NOT_AGGREGATABLE(BandwidthGroupChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(BandwidthGroupChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IBandwidthGroupChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IBandwidthGroupChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IBandwidthGroupChangedEvent)
        COM_INTERFACE_ENTRY(IBandwidthGroupChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    BandwidthGroupChangedEvent() { Log12(("BandwidthGroupChangedEvent %p\n", this)); }
    virtual ~BandwidthGroupChangedEvent() { Log12(("~BandwidthGroupChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute bandwidthGroup
private:
    ComPtr<IBandwidthGroup>    m_bandwidthGroup;
public:
    STDMETHOD(COMGETTER(BandwidthGroup))(IBandwidthGroup * * a_bandwidthGroup) RT_OVERRIDE
    {
        return m_bandwidthGroup.queryInterfaceTo(a_bandwidthGroup);
    }
    // purely internal setter
    inline void set_bandwidthGroup(IBandwidthGroup * a_bandwidthGroup)
    {
         m_bandwidthGroup = a_bandwidthGroup;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(BandwidthGroupChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(BandwidthGroupChangedEvent, IBandwidthGroupChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateBandwidthGroupChangedEvent(IEvent **aEvent, IEventSource *aSource, IBandwidthGroup * a_bandwidthGroup)
{
    ComObjPtr<BandwidthGroupChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnBandwidthGroupChanged, FALSE /*waitable*/);
        EvtObj->set_bandwidthGroup(a_bandwidthGroup);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireBandwidthGroupChangedEvent(IEventSource *aSource, IBandwidthGroup * a_bandwidthGroup)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateBandwidthGroupChangedEvent(ptrEvent.asOutParam(), aSource, a_bandwidthGroup);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestMonitorChangedEvent implementation code
class ATL_NO_VTABLE GuestMonitorChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestMonitorChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestMonitorChangedEvent, IGuestMonitorChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestMonitorChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestMonitorChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestMonitorChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestMonitorChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestMonitorChangedEvent)
        COM_INTERFACE_ENTRY(IGuestMonitorChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestMonitorChangedEvent() { Log12(("GuestMonitorChangedEvent %p\n", this)); }
    virtual ~GuestMonitorChangedEvent() { Log12(("~GuestMonitorChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute changeType
private:
    GuestMonitorChangedEventType_T    m_changeType;
public:
    STDMETHOD(COMGETTER(ChangeType))(GuestMonitorChangedEventType_T * a_changeType) RT_OVERRIDE
    {
        *a_changeType = m_changeType;
        return S_OK;
    }
    // purely internal setter
    inline void set_changeType(GuestMonitorChangedEventType_T a_changeType)
    {
         m_changeType = a_changeType;
    }

    // attribute screenId
private:
    ULONG    m_screenId;
public:
    STDMETHOD(COMGETTER(ScreenId))(ULONG * a_screenId) RT_OVERRIDE
    {
        *a_screenId = m_screenId;
        return S_OK;
    }
    // purely internal setter
    inline void set_screenId(ULONG a_screenId)
    {
         m_screenId = a_screenId;
    }

    // attribute originX
private:
    ULONG    m_originX;
public:
    STDMETHOD(COMGETTER(OriginX))(ULONG * a_originX) RT_OVERRIDE
    {
        *a_originX = m_originX;
        return S_OK;
    }
    // purely internal setter
    inline void set_originX(ULONG a_originX)
    {
         m_originX = a_originX;
    }

    // attribute originY
private:
    ULONG    m_originY;
public:
    STDMETHOD(COMGETTER(OriginY))(ULONG * a_originY) RT_OVERRIDE
    {
        *a_originY = m_originY;
        return S_OK;
    }
    // purely internal setter
    inline void set_originY(ULONG a_originY)
    {
         m_originY = a_originY;
    }

    // attribute width
private:
    ULONG    m_width;
public:
    STDMETHOD(COMGETTER(Width))(ULONG * a_width) RT_OVERRIDE
    {
        *a_width = m_width;
        return S_OK;
    }
    // purely internal setter
    inline void set_width(ULONG a_width)
    {
         m_width = a_width;
    }

    // attribute height
private:
    ULONG    m_height;
public:
    STDMETHOD(COMGETTER(Height))(ULONG * a_height) RT_OVERRIDE
    {
        *a_height = m_height;
        return S_OK;
    }
    // purely internal setter
    inline void set_height(ULONG a_height)
    {
         m_height = a_height;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestMonitorChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestMonitorChangedEvent, IGuestMonitorChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestMonitorChangedEvent(IEvent **aEvent, IEventSource *aSource, GuestMonitorChangedEventType_T a_changeType, ULONG a_screenId, ULONG a_originX, ULONG a_originY, ULONG a_width, ULONG a_height)
{
    ComObjPtr<GuestMonitorChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestMonitorChanged, FALSE /*waitable*/);
        EvtObj->set_changeType(a_changeType);
        EvtObj->set_screenId(a_screenId);
        EvtObj->set_originX(a_originX);
        EvtObj->set_originY(a_originY);
        EvtObj->set_width(a_width);
        EvtObj->set_height(a_height);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestMonitorChangedEvent(IEventSource *aSource, GuestMonitorChangedEventType_T a_changeType, ULONG a_screenId, ULONG a_originX, ULONG a_originY, ULONG a_width, ULONG a_height)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestMonitorChangedEvent(ptrEvent.asOutParam(), aSource, a_changeType, a_screenId, a_originX, a_originY, a_width, a_height);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestUserStateChangedEvent implementation code
class ATL_NO_VTABLE GuestUserStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestUserStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestUserStateChangedEvent, IGuestUserStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestUserStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestUserStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestUserStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestUserStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestUserStateChangedEvent)
        COM_INTERFACE_ENTRY(IGuestUserStateChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestUserStateChangedEvent() { Log12(("GuestUserStateChangedEvent %p\n", this)); }
    virtual ~GuestUserStateChangedEvent() { Log12(("~GuestUserStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute name
private:
    Utf8Str    m_name;
public:
    STDMETHOD(COMGETTER(Name))(BSTR * a_name) RT_OVERRIDE
    {
        return m_name.cloneToEx(a_name);
    }
    // purely internal setter
    inline HRESULT set_name(const Utf8Str &a_rString)
    {
        return m_name.assignEx(a_rString);
    }

    // attribute domain
private:
    Utf8Str    m_domain;
public:
    STDMETHOD(COMGETTER(Domain))(BSTR * a_domain) RT_OVERRIDE
    {
        return m_domain.cloneToEx(a_domain);
    }
    // purely internal setter
    inline HRESULT set_domain(const Utf8Str &a_rString)
    {
        return m_domain.assignEx(a_rString);
    }

    // attribute state
private:
    GuestUserState_T    m_state;
public:
    STDMETHOD(COMGETTER(State))(GuestUserState_T * a_state) RT_OVERRIDE
    {
        *a_state = m_state;
        return S_OK;
    }
    // purely internal setter
    inline void set_state(GuestUserState_T a_state)
    {
         m_state = a_state;
    }

    // attribute stateDetails
private:
    Utf8Str    m_stateDetails;
public:
    STDMETHOD(COMGETTER(StateDetails))(BSTR * a_stateDetails) RT_OVERRIDE
    {
        return m_stateDetails.cloneToEx(a_stateDetails);
    }
    // purely internal setter
    inline HRESULT set_stateDetails(const Utf8Str &a_rString)
    {
        return m_stateDetails.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestUserStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestUserStateChangedEvent, IGuestUserStateChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestUserStateChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_name, const Utf8Str & a_domain, GuestUserState_T a_state, const Utf8Str & a_stateDetails)
{
    ComObjPtr<GuestUserStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestUserStateChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_name(a_name);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_domain(a_domain);
        EvtObj->set_state(a_state);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_stateDetails(a_stateDetails);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestUserStateChangedEvent(IEventSource *aSource, const Utf8Str & a_name, const Utf8Str & a_domain, GuestUserState_T a_state, const Utf8Str & a_stateDetails)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestUserStateChangedEvent(ptrEvent.asOutParam(), aSource, a_name, a_domain, a_state, a_stateDetails);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IStorageDeviceChangedEvent implementation code
class ATL_NO_VTABLE StorageDeviceChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IStorageDeviceChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(StorageDeviceChangedEvent, IStorageDeviceChangedEvent)
    DECLARE_NOT_AGGREGATABLE(StorageDeviceChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(StorageDeviceChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IStorageDeviceChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IStorageDeviceChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IStorageDeviceChangedEvent)
        COM_INTERFACE_ENTRY(IStorageDeviceChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    StorageDeviceChangedEvent() { Log12(("StorageDeviceChangedEvent %p\n", this)); }
    virtual ~StorageDeviceChangedEvent() { Log12(("~StorageDeviceChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute storageDevice
private:
    ComPtr<IMediumAttachment>    m_storageDevice;
public:
    STDMETHOD(COMGETTER(StorageDevice))(IMediumAttachment * * a_storageDevice) RT_OVERRIDE
    {
        return m_storageDevice.queryInterfaceTo(a_storageDevice);
    }
    // purely internal setter
    inline void set_storageDevice(IMediumAttachment * a_storageDevice)
    {
         m_storageDevice = a_storageDevice;
    }

    // attribute removed
private:
    BOOL    m_removed;
public:
    STDMETHOD(COMGETTER(Removed))(BOOL * a_removed) RT_OVERRIDE
    {
        *a_removed = m_removed;
        return S_OK;
    }
    // purely internal setter
    inline void set_removed(BOOL a_removed)
    {
         m_removed = a_removed;
    }

    // attribute silent
private:
    BOOL    m_silent;
public:
    STDMETHOD(COMGETTER(Silent))(BOOL * a_silent) RT_OVERRIDE
    {
        *a_silent = m_silent;
        return S_OK;
    }
    // purely internal setter
    inline void set_silent(BOOL a_silent)
    {
         m_silent = a_silent;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(StorageDeviceChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(StorageDeviceChangedEvent, IStorageDeviceChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateStorageDeviceChangedEvent(IEvent **aEvent, IEventSource *aSource, IMediumAttachment * a_storageDevice, BOOL a_removed, BOOL a_silent)
{
    ComObjPtr<StorageDeviceChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnStorageDeviceChanged, FALSE /*waitable*/);
        EvtObj->set_storageDevice(a_storageDevice);
        EvtObj->set_removed(a_removed);
        EvtObj->set_silent(a_silent);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireStorageDeviceChangedEvent(IEventSource *aSource, IMediumAttachment * a_storageDevice, BOOL a_removed, BOOL a_silent)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateStorageDeviceChangedEvent(ptrEvent.asOutParam(), aSource, a_storageDevice, a_removed, a_silent);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// INATNetworkChangedEvent implementation code
class ATL_NO_VTABLE NATNetworkChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(INATNetworkChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(NATNetworkChangedEvent, INATNetworkChangedEvent)
    DECLARE_NOT_AGGREGATABLE(NATNetworkChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(NATNetworkChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(INATNetworkChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, INATNetworkChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(INATNetworkChangedEvent)
        COM_INTERFACE_ENTRY(INATNetworkChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    NATNetworkChangedEvent() { Log12(("NATNetworkChangedEvent %p\n", this)); }
    virtual ~NATNetworkChangedEvent() { Log12(("~NATNetworkChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute networkName
private:
    Utf8Str    m_networkName;
public:
    STDMETHOD(COMGETTER(NetworkName))(BSTR * a_networkName) RT_OVERRIDE
    {
        return m_networkName.cloneToEx(a_networkName);
    }
    // purely internal setter
    inline HRESULT set_networkName(const Utf8Str &a_rString)
    {
        return m_networkName.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NATNetworkChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(NATNetworkChangedEvent, INATNetworkChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateNATNetworkChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName)
{
    ComObjPtr<NATNetworkChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnNATNetworkChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_networkName(a_networkName);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireNATNetworkChangedEvent(IEventSource *aSource, const Utf8Str & a_networkName)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateNATNetworkChangedEvent(ptrEvent.asOutParam(), aSource, a_networkName);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// INATNetworkStartStopEvent implementation code
class ATL_NO_VTABLE NATNetworkStartStopEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(INATNetworkStartStopEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(NATNetworkStartStopEvent, INATNetworkStartStopEvent)
    DECLARE_NOT_AGGREGATABLE(NATNetworkStartStopEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(NATNetworkStartStopEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(INATNetworkStartStopEvent)
        COM_INTERFACE_ENTRY2(IDispatch, INATNetworkStartStopEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(INATNetworkStartStopEvent)
        COM_INTERFACE_ENTRY(INATNetworkStartStopEvent)
        COM_INTERFACE_ENTRY(INATNetworkChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    NATNetworkStartStopEvent() { Log12(("NATNetworkStartStopEvent %p\n", this)); }
    virtual ~NATNetworkStartStopEvent() { Log12(("~NATNetworkStartStopEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute startEvent
private:
    BOOL    m_startEvent;
public:
    STDMETHOD(COMGETTER(StartEvent))(BOOL * a_startEvent) RT_OVERRIDE
    {
        *a_startEvent = m_startEvent;
        return S_OK;
    }
    // purely internal setter
    inline void set_startEvent(BOOL a_startEvent)
    {
         m_startEvent = a_startEvent;
    }

    // attribute networkName
private:
    Utf8Str    m_networkName;
public:
    STDMETHOD(COMGETTER(NetworkName))(BSTR * a_networkName) RT_OVERRIDE
    {
        return m_networkName.cloneToEx(a_networkName);
    }
    // purely internal setter
    inline HRESULT set_networkName(const Utf8Str &a_rString)
    {
        return m_networkName.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NATNetworkStartStopEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(NATNetworkStartStopEvent, INATNetworkStartStopEvent, INATNetworkChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateNATNetworkStartStopEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_startEvent)
{
    ComObjPtr<NATNetworkStartStopEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnNATNetworkStartStop, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_networkName(a_networkName);
        EvtObj->set_startEvent(a_startEvent);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireNATNetworkStartStopEvent(IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_startEvent)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateNATNetworkStartStopEvent(ptrEvent.asOutParam(), aSource, a_networkName, a_startEvent);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// INATNetworkAlterEvent implementation code
class ATL_NO_VTABLE NATNetworkAlterEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(INATNetworkAlterEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(NATNetworkAlterEvent, INATNetworkAlterEvent)
    DECLARE_NOT_AGGREGATABLE(NATNetworkAlterEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(NATNetworkAlterEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(INATNetworkAlterEvent)
        COM_INTERFACE_ENTRY2(IDispatch, INATNetworkAlterEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(INATNetworkAlterEvent)
        COM_INTERFACE_ENTRY(INATNetworkAlterEvent)
        COM_INTERFACE_ENTRY(INATNetworkChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    NATNetworkAlterEvent() { Log12(("NATNetworkAlterEvent %p\n", this)); }
    virtual ~NATNetworkAlterEvent() { Log12(("~NATNetworkAlterEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute networkName
private:
    Utf8Str    m_networkName;
public:
    STDMETHOD(COMGETTER(NetworkName))(BSTR * a_networkName) RT_OVERRIDE
    {
        return m_networkName.cloneToEx(a_networkName);
    }
    // purely internal setter
    inline HRESULT set_networkName(const Utf8Str &a_rString)
    {
        return m_networkName.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NATNetworkAlterEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(NATNetworkAlterEvent, INATNetworkAlterEvent, INATNetworkChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateNATNetworkAlterEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName)
{
    ComObjPtr<NATNetworkAlterEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnNATNetworkAlter, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_networkName(a_networkName);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireNATNetworkAlterEvent(IEventSource *aSource, const Utf8Str & a_networkName)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateNATNetworkAlterEvent(ptrEvent.asOutParam(), aSource, a_networkName);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// INATNetworkCreationDeletionEvent implementation code
class ATL_NO_VTABLE NATNetworkCreationDeletionEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(INATNetworkCreationDeletionEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(NATNetworkCreationDeletionEvent, INATNetworkCreationDeletionEvent)
    DECLARE_NOT_AGGREGATABLE(NATNetworkCreationDeletionEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(NATNetworkCreationDeletionEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(INATNetworkCreationDeletionEvent)
        COM_INTERFACE_ENTRY2(IDispatch, INATNetworkCreationDeletionEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(INATNetworkCreationDeletionEvent)
        COM_INTERFACE_ENTRY(INATNetworkCreationDeletionEvent)
        COM_INTERFACE_ENTRY(INATNetworkAlterEvent)
        COM_INTERFACE_ENTRY(INATNetworkChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    NATNetworkCreationDeletionEvent() { Log12(("NATNetworkCreationDeletionEvent %p\n", this)); }
    virtual ~NATNetworkCreationDeletionEvent() { Log12(("~NATNetworkCreationDeletionEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute creationEvent
private:
    BOOL    m_creationEvent;
public:
    STDMETHOD(COMGETTER(CreationEvent))(BOOL * a_creationEvent) RT_OVERRIDE
    {
        *a_creationEvent = m_creationEvent;
        return S_OK;
    }
    // purely internal setter
    inline void set_creationEvent(BOOL a_creationEvent)
    {
         m_creationEvent = a_creationEvent;
    }

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute networkName
private:
    Utf8Str    m_networkName;
public:
    STDMETHOD(COMGETTER(NetworkName))(BSTR * a_networkName) RT_OVERRIDE
    {
        return m_networkName.cloneToEx(a_networkName);
    }
    // purely internal setter
    inline HRESULT set_networkName(const Utf8Str &a_rString)
    {
        return m_networkName.assignEx(a_rString);
    }
    inline HRESULT set_networkName(CBSTR a_networkName)
    {
        return m_networkName.assignEx(a_networkName);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NATNetworkCreationDeletionEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(NATNetworkCreationDeletionEvent, INATNetworkCreationDeletionEvent, INATNetworkAlterEvent, INATNetworkChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateNATNetworkCreationDeletionEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_creationEvent)
{
    ComObjPtr<NATNetworkCreationDeletionEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnNATNetworkCreationDeletion, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_networkName(a_networkName);
        EvtObj->set_creationEvent(a_creationEvent);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) CreateNATNetworkCreationDeletionEvent(IEvent **aEvent, IEventSource *aSource, CBSTR a_networkName, BOOL a_creationEvent)
{
    ComObjPtr<NATNetworkCreationDeletionEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnNATNetworkCreationDeletion, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_networkName(a_networkName);
        EvtObj->set_creationEvent(a_creationEvent);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireNATNetworkCreationDeletionEvent(IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_creationEvent)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateNATNetworkCreationDeletionEvent(ptrEvent.asOutParam(), aSource, a_networkName, a_creationEvent);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

DECLHIDDEN(HRESULT) FireNATNetworkCreationDeletionEvent(IEventSource *aSource, CBSTR a_networkName, BOOL a_creationEvent)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateNATNetworkCreationDeletionEvent(ptrEvent.asOutParam(), aSource, a_networkName, a_creationEvent);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// INATNetworkSettingEvent implementation code
class ATL_NO_VTABLE NATNetworkSettingEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(INATNetworkSettingEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(NATNetworkSettingEvent, INATNetworkSettingEvent)
    DECLARE_NOT_AGGREGATABLE(NATNetworkSettingEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(NATNetworkSettingEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(INATNetworkSettingEvent)
        COM_INTERFACE_ENTRY2(IDispatch, INATNetworkSettingEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(INATNetworkSettingEvent)
        COM_INTERFACE_ENTRY(INATNetworkSettingEvent)
        COM_INTERFACE_ENTRY(INATNetworkAlterEvent)
        COM_INTERFACE_ENTRY(INATNetworkChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    NATNetworkSettingEvent() { Log12(("NATNetworkSettingEvent %p\n", this)); }
    virtual ~NATNetworkSettingEvent() { Log12(("~NATNetworkSettingEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute enabled
private:
    BOOL    m_enabled;
public:
    STDMETHOD(COMGETTER(Enabled))(BOOL * a_enabled) RT_OVERRIDE
    {
        *a_enabled = m_enabled;
        return S_OK;
    }
    // purely internal setter
    inline void set_enabled(BOOL a_enabled)
    {
         m_enabled = a_enabled;
    }

    // attribute network
private:
    Utf8Str    m_network;
public:
    STDMETHOD(COMGETTER(Network))(BSTR * a_network) RT_OVERRIDE
    {
        return m_network.cloneToEx(a_network);
    }
    // purely internal setter
    inline HRESULT set_network(const Utf8Str &a_rString)
    {
        return m_network.assignEx(a_rString);
    }

    // attribute gateway
private:
    Utf8Str    m_gateway;
public:
    STDMETHOD(COMGETTER(Gateway))(BSTR * a_gateway) RT_OVERRIDE
    {
        return m_gateway.cloneToEx(a_gateway);
    }
    // purely internal setter
    inline HRESULT set_gateway(const Utf8Str &a_rString)
    {
        return m_gateway.assignEx(a_rString);
    }

    // attribute advertiseDefaultIPv6RouteEnabled
private:
    BOOL    m_advertiseDefaultIPv6RouteEnabled;
public:
    STDMETHOD(COMGETTER(AdvertiseDefaultIPv6RouteEnabled))(BOOL * a_advertiseDefaultIPv6RouteEnabled) RT_OVERRIDE
    {
        *a_advertiseDefaultIPv6RouteEnabled = m_advertiseDefaultIPv6RouteEnabled;
        return S_OK;
    }
    // purely internal setter
    inline void set_advertiseDefaultIPv6RouteEnabled(BOOL a_advertiseDefaultIPv6RouteEnabled)
    {
         m_advertiseDefaultIPv6RouteEnabled = a_advertiseDefaultIPv6RouteEnabled;
    }

    // attribute needDhcpServer
private:
    BOOL    m_needDhcpServer;
public:
    STDMETHOD(COMGETTER(NeedDhcpServer))(BOOL * a_needDhcpServer) RT_OVERRIDE
    {
        *a_needDhcpServer = m_needDhcpServer;
        return S_OK;
    }
    // purely internal setter
    inline void set_needDhcpServer(BOOL a_needDhcpServer)
    {
         m_needDhcpServer = a_needDhcpServer;
    }

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute networkName
private:
    Utf8Str    m_networkName;
public:
    STDMETHOD(COMGETTER(NetworkName))(BSTR * a_networkName) RT_OVERRIDE
    {
        return m_networkName.cloneToEx(a_networkName);
    }
    // purely internal setter
    inline HRESULT set_networkName(const Utf8Str &a_rString)
    {
        return m_networkName.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NATNetworkSettingEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(NATNetworkSettingEvent, INATNetworkSettingEvent, INATNetworkAlterEvent, INATNetworkChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateNATNetworkSettingEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_enabled, const Utf8Str & a_network, const Utf8Str & a_gateway, BOOL a_advertiseDefaultIPv6RouteEnabled, BOOL a_needDhcpServer)
{
    ComObjPtr<NATNetworkSettingEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnNATNetworkSetting, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_networkName(a_networkName);
        EvtObj->set_enabled(a_enabled);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_network(a_network);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_gateway(a_gateway);
        EvtObj->set_advertiseDefaultIPv6RouteEnabled(a_advertiseDefaultIPv6RouteEnabled);
        EvtObj->set_needDhcpServer(a_needDhcpServer);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireNATNetworkSettingEvent(IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_enabled, const Utf8Str & a_network, const Utf8Str & a_gateway, BOOL a_advertiseDefaultIPv6RouteEnabled, BOOL a_needDhcpServer)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateNATNetworkSettingEvent(ptrEvent.asOutParam(), aSource, a_networkName, a_enabled, a_network, a_gateway, a_advertiseDefaultIPv6RouteEnabled, a_needDhcpServer);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// INATNetworkPortForwardEvent implementation code
class ATL_NO_VTABLE NATNetworkPortForwardEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(INATNetworkPortForwardEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(NATNetworkPortForwardEvent, INATNetworkPortForwardEvent)
    DECLARE_NOT_AGGREGATABLE(NATNetworkPortForwardEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(NATNetworkPortForwardEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(INATNetworkPortForwardEvent)
        COM_INTERFACE_ENTRY2(IDispatch, INATNetworkPortForwardEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(INATNetworkPortForwardEvent)
        COM_INTERFACE_ENTRY(INATNetworkPortForwardEvent)
        COM_INTERFACE_ENTRY(INATNetworkAlterEvent)
        COM_INTERFACE_ENTRY(INATNetworkChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    NATNetworkPortForwardEvent() { Log12(("NATNetworkPortForwardEvent %p\n", this)); }
    virtual ~NATNetworkPortForwardEvent() { Log12(("~NATNetworkPortForwardEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute create
private:
    BOOL    m_create;
public:
    STDMETHOD(COMGETTER(Create))(BOOL * a_create) RT_OVERRIDE
    {
        *a_create = m_create;
        return S_OK;
    }
    // purely internal setter
    inline void set_create(BOOL a_create)
    {
         m_create = a_create;
    }

    // attribute ipv6
private:
    BOOL    m_ipv6;
public:
    STDMETHOD(COMGETTER(Ipv6))(BOOL * a_ipv6) RT_OVERRIDE
    {
        *a_ipv6 = m_ipv6;
        return S_OK;
    }
    // purely internal setter
    inline void set_ipv6(BOOL a_ipv6)
    {
         m_ipv6 = a_ipv6;
    }

    // attribute name
private:
    Utf8Str    m_name;
public:
    STDMETHOD(COMGETTER(Name))(BSTR * a_name) RT_OVERRIDE
    {
        return m_name.cloneToEx(a_name);
    }
    // purely internal setter
    inline HRESULT set_name(const Utf8Str &a_rString)
    {
        return m_name.assignEx(a_rString);
    }

    // attribute proto
private:
    NATProtocol_T    m_proto;
public:
    STDMETHOD(COMGETTER(Proto))(NATProtocol_T * a_proto) RT_OVERRIDE
    {
        *a_proto = m_proto;
        return S_OK;
    }
    // purely internal setter
    inline void set_proto(NATProtocol_T a_proto)
    {
         m_proto = a_proto;
    }

    // attribute hostIp
private:
    Utf8Str    m_hostIp;
public:
    STDMETHOD(COMGETTER(HostIp))(BSTR * a_hostIp) RT_OVERRIDE
    {
        return m_hostIp.cloneToEx(a_hostIp);
    }
    // purely internal setter
    inline HRESULT set_hostIp(const Utf8Str &a_rString)
    {
        return m_hostIp.assignEx(a_rString);
    }

    // attribute hostPort
private:
    LONG    m_hostPort;
public:
    STDMETHOD(COMGETTER(HostPort))(LONG * a_hostPort) RT_OVERRIDE
    {
        *a_hostPort = m_hostPort;
        return S_OK;
    }
    // purely internal setter
    inline void set_hostPort(LONG a_hostPort)
    {
         m_hostPort = a_hostPort;
    }

    // attribute guestIp
private:
    Utf8Str    m_guestIp;
public:
    STDMETHOD(COMGETTER(GuestIp))(BSTR * a_guestIp) RT_OVERRIDE
    {
        return m_guestIp.cloneToEx(a_guestIp);
    }
    // purely internal setter
    inline HRESULT set_guestIp(const Utf8Str &a_rString)
    {
        return m_guestIp.assignEx(a_rString);
    }

    // attribute guestPort
private:
    LONG    m_guestPort;
public:
    STDMETHOD(COMGETTER(GuestPort))(LONG * a_guestPort) RT_OVERRIDE
    {
        *a_guestPort = m_guestPort;
        return S_OK;
    }
    // purely internal setter
    inline void set_guestPort(LONG a_guestPort)
    {
         m_guestPort = a_guestPort;
    }

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute networkName
private:
    Utf8Str    m_networkName;
public:
    STDMETHOD(COMGETTER(NetworkName))(BSTR * a_networkName) RT_OVERRIDE
    {
        return m_networkName.cloneToEx(a_networkName);
    }
    // purely internal setter
    inline HRESULT set_networkName(const Utf8Str &a_rString)
    {
        return m_networkName.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NATNetworkPortForwardEvent)
NS_IMPL_THREADSAFE_ISUPPORTS4_CI(NATNetworkPortForwardEvent, INATNetworkPortForwardEvent, INATNetworkAlterEvent, INATNetworkChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateNATNetworkPortForwardEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_create, BOOL a_ipv6, const Utf8Str & a_name, NATProtocol_T a_proto, const Utf8Str & a_hostIp, LONG a_hostPort, const Utf8Str & a_guestIp, LONG a_guestPort)
{
    ComObjPtr<NATNetworkPortForwardEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnNATNetworkPortForward, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_networkName(a_networkName);
        EvtObj->set_create(a_create);
        EvtObj->set_ipv6(a_ipv6);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_name(a_name);
        EvtObj->set_proto(a_proto);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_hostIp(a_hostIp);
        EvtObj->set_hostPort(a_hostPort);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_guestIp(a_guestIp);
        EvtObj->set_guestPort(a_guestPort);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireNATNetworkPortForwardEvent(IEventSource *aSource, const Utf8Str & a_networkName, BOOL a_create, BOOL a_ipv6, const Utf8Str & a_name, NATProtocol_T a_proto, const Utf8Str & a_hostIp, LONG a_hostPort, const Utf8Str & a_guestIp, LONG a_guestPort)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateNATNetworkPortForwardEvent(ptrEvent.asOutParam(), aSource, a_networkName, a_create, a_ipv6, a_name, a_proto, a_hostIp, a_hostPort, a_guestIp, a_guestPort);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IHostNameResolutionConfigurationChangeEvent implementation code
class ATL_NO_VTABLE HostNameResolutionConfigurationChangeEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IHostNameResolutionConfigurationChangeEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(HostNameResolutionConfigurationChangeEvent, IHostNameResolutionConfigurationChangeEvent)
    DECLARE_NOT_AGGREGATABLE(HostNameResolutionConfigurationChangeEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(HostNameResolutionConfigurationChangeEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IHostNameResolutionConfigurationChangeEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IHostNameResolutionConfigurationChangeEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IHostNameResolutionConfigurationChangeEvent)
        COM_INTERFACE_ENTRY(IHostNameResolutionConfigurationChangeEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    HostNameResolutionConfigurationChangeEvent() { Log12(("HostNameResolutionConfigurationChangeEvent %p\n", this)); }
    virtual ~HostNameResolutionConfigurationChangeEvent() { Log12(("~HostNameResolutionConfigurationChangeEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostNameResolutionConfigurationChangeEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(HostNameResolutionConfigurationChangeEvent, IHostNameResolutionConfigurationChangeEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateHostNameResolutionConfigurationChangeEvent(IEvent **aEvent, IEventSource *aSource)
{
    ComObjPtr<HostNameResolutionConfigurationChangeEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnHostNameResolutionConfigurationChange, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireHostNameResolutionConfigurationChangeEvent(IEventSource *aSource)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateHostNameResolutionConfigurationChangeEvent(ptrEvent.asOutParam(), aSource);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IProgressCreatedEvent implementation code
class ATL_NO_VTABLE ProgressCreatedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IProgressCreatedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ProgressCreatedEvent, IProgressCreatedEvent)
    DECLARE_NOT_AGGREGATABLE(ProgressCreatedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ProgressCreatedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IProgressCreatedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IProgressCreatedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IProgressCreatedEvent)
        COM_INTERFACE_ENTRY(IProgressCreatedEvent)
        COM_INTERFACE_ENTRY(IProgressEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ProgressCreatedEvent() { Log12(("ProgressCreatedEvent %p\n", this)); }
    virtual ~ProgressCreatedEvent() { Log12(("~ProgressCreatedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute create
private:
    BOOL    m_create;
public:
    STDMETHOD(COMGETTER(Create))(BOOL * a_create) RT_OVERRIDE
    {
        *a_create = m_create;
        return S_OK;
    }
    // purely internal setter
    inline void set_create(BOOL a_create)
    {
         m_create = a_create;
    }

    // attribute progressId
private:
    Utf8Str    m_progressId;
public:
    STDMETHOD(COMGETTER(ProgressId))(BSTR * a_progressId) RT_OVERRIDE
    {
        return m_progressId.cloneToEx(a_progressId);
    }
    // purely internal setter
    inline HRESULT set_progressId(const Utf8Str &a_rString)
    {
        return m_progressId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ProgressCreatedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(ProgressCreatedEvent, IProgressCreatedEvent, IProgressEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateProgressCreatedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_progressId, BOOL a_create)
{
    ComObjPtr<ProgressCreatedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnProgressCreated, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_progressId(a_progressId);
        EvtObj->set_create(a_create);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireProgressCreatedEvent(IEventSource *aSource, const Utf8Str & a_progressId, BOOL a_create)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateProgressCreatedEvent(ptrEvent.asOutParam(), aSource, a_progressId, a_create);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IProgressPercentageChangedEvent implementation code
class ATL_NO_VTABLE ProgressPercentageChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IProgressPercentageChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ProgressPercentageChangedEvent, IProgressPercentageChangedEvent)
    DECLARE_NOT_AGGREGATABLE(ProgressPercentageChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ProgressPercentageChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IProgressPercentageChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IProgressPercentageChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IProgressPercentageChangedEvent)
        COM_INTERFACE_ENTRY(IProgressPercentageChangedEvent)
        COM_INTERFACE_ENTRY(IProgressEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ProgressPercentageChangedEvent() { Log12(("ProgressPercentageChangedEvent %p\n", this)); }
    virtual ~ProgressPercentageChangedEvent() { Log12(("~ProgressPercentageChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute percent
private:
    LONG    m_percent;
public:
    STDMETHOD(COMGETTER(Percent))(LONG * a_percent) RT_OVERRIDE
    {
        *a_percent = m_percent;
        return S_OK;
    }
    // purely internal setter
    inline void set_percent(LONG a_percent)
    {
         m_percent = a_percent;
    }

    // attribute progressId
private:
    Utf8Str    m_progressId;
public:
    STDMETHOD(COMGETTER(ProgressId))(BSTR * a_progressId) RT_OVERRIDE
    {
        return m_progressId.cloneToEx(a_progressId);
    }
    // purely internal setter
    inline HRESULT set_progressId(const Utf8Str &a_rString)
    {
        return m_progressId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ProgressPercentageChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(ProgressPercentageChangedEvent, IProgressPercentageChangedEvent, IProgressEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateProgressPercentageChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_progressId, LONG a_percent)
{
    ComObjPtr<ProgressPercentageChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnProgressPercentageChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_progressId(a_progressId);
        EvtObj->set_percent(a_percent);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireProgressPercentageChangedEvent(IEventSource *aSource, const Utf8Str & a_progressId, LONG a_percent)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateProgressPercentageChangedEvent(ptrEvent.asOutParam(), aSource, a_progressId, a_percent);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IProgressTaskCompletedEvent implementation code
class ATL_NO_VTABLE ProgressTaskCompletedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IProgressTaskCompletedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(ProgressTaskCompletedEvent, IProgressTaskCompletedEvent)
    DECLARE_NOT_AGGREGATABLE(ProgressTaskCompletedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(ProgressTaskCompletedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IProgressTaskCompletedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IProgressTaskCompletedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IProgressTaskCompletedEvent)
        COM_INTERFACE_ENTRY(IProgressTaskCompletedEvent)
        COM_INTERFACE_ENTRY(IProgressEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    ProgressTaskCompletedEvent() { Log12(("ProgressTaskCompletedEvent %p\n", this)); }
    virtual ~ProgressTaskCompletedEvent() { Log12(("~ProgressTaskCompletedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute midlDoesNotLikeEmptyInterfaces
private:
    BOOL    m_midlDoesNotLikeEmptyInterfaces;
public:
    STDMETHOD(COMGETTER(MidlDoesNotLikeEmptyInterfaces))(BOOL * a_midlDoesNotLikeEmptyInterfaces) RT_OVERRIDE
    {
        *a_midlDoesNotLikeEmptyInterfaces = m_midlDoesNotLikeEmptyInterfaces;
        return S_OK;
    }
    // purely internal setter
    inline void set_midlDoesNotLikeEmptyInterfaces(BOOL a_midlDoesNotLikeEmptyInterfaces)
    {
         m_midlDoesNotLikeEmptyInterfaces = a_midlDoesNotLikeEmptyInterfaces;
    }

    // attribute progressId
private:
    Utf8Str    m_progressId;
public:
    STDMETHOD(COMGETTER(ProgressId))(BSTR * a_progressId) RT_OVERRIDE
    {
        return m_progressId.cloneToEx(a_progressId);
    }
    // purely internal setter
    inline HRESULT set_progressId(const Utf8Str &a_rString)
    {
        return m_progressId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ProgressTaskCompletedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(ProgressTaskCompletedEvent, IProgressTaskCompletedEvent, IProgressEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateProgressTaskCompletedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_progressId)
{
    ComObjPtr<ProgressTaskCompletedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnProgressTaskCompleted, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_progressId(a_progressId);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireProgressTaskCompletedEvent(IEventSource *aSource, const Utf8Str & a_progressId)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateProgressTaskCompletedEvent(ptrEvent.asOutParam(), aSource, a_progressId);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ICursorPositionChangedEvent implementation code
class ATL_NO_VTABLE CursorPositionChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICursorPositionChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CursorPositionChangedEvent, ICursorPositionChangedEvent)
    DECLARE_NOT_AGGREGATABLE(CursorPositionChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(CursorPositionChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICursorPositionChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ICursorPositionChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ICursorPositionChangedEvent)
        COM_INTERFACE_ENTRY(ICursorPositionChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    CursorPositionChangedEvent() { Log12(("CursorPositionChangedEvent %p\n", this)); }
    virtual ~CursorPositionChangedEvent() { Log12(("~CursorPositionChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute hasData
private:
    BOOL    m_hasData;
public:
    STDMETHOD(COMGETTER(HasData))(BOOL * a_hasData) RT_OVERRIDE
    {
        *a_hasData = m_hasData;
        return S_OK;
    }
    // purely internal setter
    inline void set_hasData(BOOL a_hasData)
    {
         m_hasData = a_hasData;
    }

    // attribute x
private:
    ULONG    m_x;
public:
    STDMETHOD(COMGETTER(X))(ULONG * a_x) RT_OVERRIDE
    {
        *a_x = m_x;
        return S_OK;
    }
    // purely internal setter
    inline void set_x(ULONG a_x)
    {
         m_x = a_x;
    }

    // attribute y
private:
    ULONG    m_y;
public:
    STDMETHOD(COMGETTER(Y))(ULONG * a_y) RT_OVERRIDE
    {
        *a_y = m_y;
        return S_OK;
    }
    // purely internal setter
    inline void set_y(ULONG a_y)
    {
         m_y = a_y;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CursorPositionChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(CursorPositionChangedEvent, ICursorPositionChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateCursorPositionChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_hasData, ULONG a_x, ULONG a_y)
{
    ComObjPtr<CursorPositionChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnCursorPositionChanged, FALSE /*waitable*/);
        EvtObj->set_hasData(a_hasData);
        EvtObj->set_x(a_x);
        EvtObj->set_y(a_y);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireCursorPositionChangedEvent(IEventSource *aSource, BOOL a_hasData, ULONG a_x, ULONG a_y)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateCursorPositionChangedEvent(ptrEvent.asOutParam(), aSource, a_hasData, a_x, a_y);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestAdditionsStatusChangedEvent implementation code
class ATL_NO_VTABLE GuestAdditionsStatusChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestAdditionsStatusChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestAdditionsStatusChangedEvent, IGuestAdditionsStatusChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestAdditionsStatusChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestAdditionsStatusChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestAdditionsStatusChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestAdditionsStatusChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestAdditionsStatusChangedEvent)
        COM_INTERFACE_ENTRY(IGuestAdditionsStatusChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestAdditionsStatusChangedEvent() { Log12(("GuestAdditionsStatusChangedEvent %p\n", this)); }
    virtual ~GuestAdditionsStatusChangedEvent() { Log12(("~GuestAdditionsStatusChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute facility
private:
    AdditionsFacilityType_T    m_facility;
public:
    STDMETHOD(COMGETTER(Facility))(AdditionsFacilityType_T * a_facility) RT_OVERRIDE
    {
        *a_facility = m_facility;
        return S_OK;
    }
    // purely internal setter
    inline void set_facility(AdditionsFacilityType_T a_facility)
    {
         m_facility = a_facility;
    }

    // attribute status
private:
    AdditionsFacilityStatus_T    m_status;
public:
    STDMETHOD(COMGETTER(Status))(AdditionsFacilityStatus_T * a_status) RT_OVERRIDE
    {
        *a_status = m_status;
        return S_OK;
    }
    // purely internal setter
    inline void set_status(AdditionsFacilityStatus_T a_status)
    {
         m_status = a_status;
    }

    // attribute runLevel
private:
    AdditionsRunLevelType_T    m_runLevel;
public:
    STDMETHOD(COMGETTER(RunLevel))(AdditionsRunLevelType_T * a_runLevel) RT_OVERRIDE
    {
        *a_runLevel = m_runLevel;
        return S_OK;
    }
    // purely internal setter
    inline void set_runLevel(AdditionsRunLevelType_T a_runLevel)
    {
         m_runLevel = a_runLevel;
    }

    // attribute timestamp
private:
    LONG64    m_timestamp;
public:
    STDMETHOD(COMGETTER(Timestamp))(LONG64 * a_timestamp) RT_OVERRIDE
    {
        *a_timestamp = m_timestamp;
        return S_OK;
    }
    // purely internal setter
    inline void set_timestamp(LONG64 a_timestamp)
    {
         m_timestamp = a_timestamp;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestAdditionsStatusChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestAdditionsStatusChangedEvent, IGuestAdditionsStatusChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestAdditionsStatusChangedEvent(IEvent **aEvent, IEventSource *aSource, AdditionsFacilityType_T a_facility, AdditionsFacilityStatus_T a_status, AdditionsRunLevelType_T a_runLevel, LONG64 a_timestamp)
{
    ComObjPtr<GuestAdditionsStatusChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestAdditionsStatusChanged, FALSE /*waitable*/);
        EvtObj->set_facility(a_facility);
        EvtObj->set_status(a_status);
        EvtObj->set_runLevel(a_runLevel);
        EvtObj->set_timestamp(a_timestamp);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestAdditionsStatusChangedEvent(IEventSource *aSource, AdditionsFacilityType_T a_facility, AdditionsFacilityStatus_T a_status, AdditionsRunLevelType_T a_runLevel, LONG64 a_timestamp)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestAdditionsStatusChangedEvent(ptrEvent.asOutParam(), aSource, a_facility, a_status, a_runLevel, a_timestamp);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestMonitorInfoChangedEvent implementation code
class ATL_NO_VTABLE GuestMonitorInfoChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestMonitorInfoChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestMonitorInfoChangedEvent, IGuestMonitorInfoChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestMonitorInfoChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestMonitorInfoChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestMonitorInfoChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestMonitorInfoChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestMonitorInfoChangedEvent)
        COM_INTERFACE_ENTRY(IGuestMonitorInfoChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestMonitorInfoChangedEvent() { Log12(("GuestMonitorInfoChangedEvent %p\n", this)); }
    virtual ~GuestMonitorInfoChangedEvent() { Log12(("~GuestMonitorInfoChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute output
private:
    ULONG    m_output;
public:
    STDMETHOD(COMGETTER(Output))(ULONG * a_output) RT_OVERRIDE
    {
        *a_output = m_output;
        return S_OK;
    }
    // purely internal setter
    inline void set_output(ULONG a_output)
    {
         m_output = a_output;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestMonitorInfoChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestMonitorInfoChangedEvent, IGuestMonitorInfoChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestMonitorInfoChangedEvent(IEvent **aEvent, IEventSource *aSource, ULONG a_output)
{
    ComObjPtr<GuestMonitorInfoChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestMonitorInfoChanged, FALSE /*waitable*/);
        EvtObj->set_output(a_output);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestMonitorInfoChangedEvent(IEventSource *aSource, ULONG a_output)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestMonitorInfoChangedEvent(ptrEvent.asOutParam(), aSource, a_output);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IUpdateAgentSettingsChangedEvent implementation code
class ATL_NO_VTABLE UpdateAgentSettingsChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IUpdateAgentSettingsChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(UpdateAgentSettingsChangedEvent, IUpdateAgentSettingsChangedEvent)
    DECLARE_NOT_AGGREGATABLE(UpdateAgentSettingsChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(UpdateAgentSettingsChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IUpdateAgentSettingsChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IUpdateAgentSettingsChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IUpdateAgentSettingsChangedEvent)
        COM_INTERFACE_ENTRY(IUpdateAgentSettingsChangedEvent)
        COM_INTERFACE_ENTRY(IUpdateAgentEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    UpdateAgentSettingsChangedEvent() { Log12(("UpdateAgentSettingsChangedEvent %p\n", this)); }
    virtual ~UpdateAgentSettingsChangedEvent() { Log12(("~UpdateAgentSettingsChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute attributeHint
private:
    Utf8Str    m_attributeHint;
public:
    STDMETHOD(COMGETTER(AttributeHint))(BSTR * a_attributeHint) RT_OVERRIDE
    {
        return m_attributeHint.cloneToEx(a_attributeHint);
    }
    // purely internal setter
    inline HRESULT set_attributeHint(const Utf8Str &a_rString)
    {
        return m_attributeHint.assignEx(a_rString);
    }

    // attribute agent
private:
    ComPtr<IUpdateAgent>    m_agent;
public:
    STDMETHOD(COMGETTER(Agent))(IUpdateAgent * * a_agent) RT_OVERRIDE
    {
        return m_agent.queryInterfaceTo(a_agent);
    }
    // purely internal setter
    inline void set_agent(IUpdateAgent * a_agent)
    {
         m_agent = a_agent;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(UpdateAgentSettingsChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(UpdateAgentSettingsChangedEvent, IUpdateAgentSettingsChangedEvent, IUpdateAgentEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateUpdateAgentSettingsChangedEvent(IEvent **aEvent, IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_attributeHint)
{
    ComObjPtr<UpdateAgentSettingsChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnUpdateAgentSettingsChanged, FALSE /*waitable*/);
        EvtObj->set_agent(a_agent);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_attributeHint(a_attributeHint);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireUpdateAgentSettingsChangedEvent(IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_attributeHint)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateUpdateAgentSettingsChangedEvent(ptrEvent.asOutParam(), aSource, a_agent, a_attributeHint);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IUpdateAgentErrorEvent implementation code
class ATL_NO_VTABLE UpdateAgentErrorEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IUpdateAgentErrorEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(UpdateAgentErrorEvent, IUpdateAgentErrorEvent)
    DECLARE_NOT_AGGREGATABLE(UpdateAgentErrorEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(UpdateAgentErrorEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IUpdateAgentErrorEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IUpdateAgentErrorEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IUpdateAgentErrorEvent)
        COM_INTERFACE_ENTRY(IUpdateAgentErrorEvent)
        COM_INTERFACE_ENTRY(IUpdateAgentEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    UpdateAgentErrorEvent() { Log12(("UpdateAgentErrorEvent %p\n", this)); }
    virtual ~UpdateAgentErrorEvent() { Log12(("~UpdateAgentErrorEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute msg
private:
    Utf8Str    m_msg;
public:
    STDMETHOD(COMGETTER(Msg))(BSTR * a_msg) RT_OVERRIDE
    {
        return m_msg.cloneToEx(a_msg);
    }
    // purely internal setter
    inline HRESULT set_msg(const Utf8Str &a_rString)
    {
        return m_msg.assignEx(a_rString);
    }

    // attribute rcError
private:
    LONG    m_rcError;
public:
    STDMETHOD(COMGETTER(RcError))(LONG * a_rcError) RT_OVERRIDE
    {
        *a_rcError = m_rcError;
        return S_OK;
    }
    // purely internal setter
    inline void set_rcError(LONG a_rcError)
    {
         m_rcError = a_rcError;
    }

    // attribute agent
private:
    ComPtr<IUpdateAgent>    m_agent;
public:
    STDMETHOD(COMGETTER(Agent))(IUpdateAgent * * a_agent) RT_OVERRIDE
    {
        return m_agent.queryInterfaceTo(a_agent);
    }
    // purely internal setter
    inline void set_agent(IUpdateAgent * a_agent)
    {
         m_agent = a_agent;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(UpdateAgentErrorEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(UpdateAgentErrorEvent, IUpdateAgentErrorEvent, IUpdateAgentEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateUpdateAgentErrorEvent(IEvent **aEvent, IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_msg, LONG a_rcError)
{
    ComObjPtr<UpdateAgentErrorEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnUpdateAgentError, FALSE /*waitable*/);
        EvtObj->set_agent(a_agent);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_msg(a_msg);
        EvtObj->set_rcError(a_rcError);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireUpdateAgentErrorEvent(IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_msg, LONG a_rcError)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateUpdateAgentErrorEvent(ptrEvent.asOutParam(), aSource, a_agent, a_msg, a_rcError);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IUpdateAgentAvailableEvent implementation code
class ATL_NO_VTABLE UpdateAgentAvailableEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IUpdateAgentAvailableEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(UpdateAgentAvailableEvent, IUpdateAgentAvailableEvent)
    DECLARE_NOT_AGGREGATABLE(UpdateAgentAvailableEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(UpdateAgentAvailableEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IUpdateAgentAvailableEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IUpdateAgentAvailableEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IUpdateAgentAvailableEvent)
        COM_INTERFACE_ENTRY(IUpdateAgentAvailableEvent)
        COM_INTERFACE_ENTRY(IUpdateAgentEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    UpdateAgentAvailableEvent() { Log12(("UpdateAgentAvailableEvent %p\n", this)); }
    virtual ~UpdateAgentAvailableEvent() { Log12(("~UpdateAgentAvailableEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute version
private:
    Utf8Str    m_version;
public:
    STDMETHOD(COMGETTER(Version))(BSTR * a_version) RT_OVERRIDE
    {
        return m_version.cloneToEx(a_version);
    }
    // purely internal setter
    inline HRESULT set_version(const Utf8Str &a_rString)
    {
        return m_version.assignEx(a_rString);
    }

    // attribute channel
private:
    UpdateChannel_T    m_channel;
public:
    STDMETHOD(COMGETTER(Channel))(UpdateChannel_T * a_channel) RT_OVERRIDE
    {
        *a_channel = m_channel;
        return S_OK;
    }
    // purely internal setter
    inline void set_channel(UpdateChannel_T a_channel)
    {
         m_channel = a_channel;
    }

    // attribute severity
private:
    UpdateSeverity_T    m_severity;
public:
    STDMETHOD(COMGETTER(Severity))(UpdateSeverity_T * a_severity) RT_OVERRIDE
    {
        *a_severity = m_severity;
        return S_OK;
    }
    // purely internal setter
    inline void set_severity(UpdateSeverity_T a_severity)
    {
         m_severity = a_severity;
    }

    // attribute downloadURL
private:
    Utf8Str    m_downloadURL;
public:
    STDMETHOD(COMGETTER(DownloadURL))(BSTR * a_downloadURL) RT_OVERRIDE
    {
        return m_downloadURL.cloneToEx(a_downloadURL);
    }
    // purely internal setter
    inline HRESULT set_downloadURL(const Utf8Str &a_rString)
    {
        return m_downloadURL.assignEx(a_rString);
    }

    // attribute webURL
private:
    Utf8Str    m_webURL;
public:
    STDMETHOD(COMGETTER(WebURL))(BSTR * a_webURL) RT_OVERRIDE
    {
        return m_webURL.cloneToEx(a_webURL);
    }
    // purely internal setter
    inline HRESULT set_webURL(const Utf8Str &a_rString)
    {
        return m_webURL.assignEx(a_rString);
    }

    // attribute releaseNotes
private:
    Utf8Str    m_releaseNotes;
public:
    STDMETHOD(COMGETTER(ReleaseNotes))(BSTR * a_releaseNotes) RT_OVERRIDE
    {
        return m_releaseNotes.cloneToEx(a_releaseNotes);
    }
    // purely internal setter
    inline HRESULT set_releaseNotes(const Utf8Str &a_rString)
    {
        return m_releaseNotes.assignEx(a_rString);
    }

    // attribute agent
private:
    ComPtr<IUpdateAgent>    m_agent;
public:
    STDMETHOD(COMGETTER(Agent))(IUpdateAgent * * a_agent) RT_OVERRIDE
    {
        return m_agent.queryInterfaceTo(a_agent);
    }
    // purely internal setter
    inline void set_agent(IUpdateAgent * a_agent)
    {
         m_agent = a_agent;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(UpdateAgentAvailableEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(UpdateAgentAvailableEvent, IUpdateAgentAvailableEvent, IUpdateAgentEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateUpdateAgentAvailableEvent(IEvent **aEvent, IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_version, UpdateChannel_T a_channel, UpdateSeverity_T a_severity, const Utf8Str & a_downloadURL, const Utf8Str & a_webURL, const Utf8Str & a_releaseNotes)
{
    ComObjPtr<UpdateAgentAvailableEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnUpdateAgentAvailable, FALSE /*waitable*/);
        EvtObj->set_agent(a_agent);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_version(a_version);
        EvtObj->set_channel(a_channel);
        EvtObj->set_severity(a_severity);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_downloadURL(a_downloadURL);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_webURL(a_webURL);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_releaseNotes(a_releaseNotes);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireUpdateAgentAvailableEvent(IEventSource *aSource, IUpdateAgent * a_agent, const Utf8Str & a_version, UpdateChannel_T a_channel, UpdateSeverity_T a_severity, const Utf8Str & a_downloadURL, const Utf8Str & a_webURL, const Utf8Str & a_releaseNotes)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateUpdateAgentAvailableEvent(ptrEvent.asOutParam(), aSource, a_agent, a_version, a_channel, a_severity, a_downloadURL, a_webURL, a_releaseNotes);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IUpdateAgentStateChangedEvent implementation code
class ATL_NO_VTABLE UpdateAgentStateChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IUpdateAgentStateChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(UpdateAgentStateChangedEvent, IUpdateAgentStateChangedEvent)
    DECLARE_NOT_AGGREGATABLE(UpdateAgentStateChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(UpdateAgentStateChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IUpdateAgentStateChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IUpdateAgentStateChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IUpdateAgentStateChangedEvent)
        COM_INTERFACE_ENTRY(IUpdateAgentStateChangedEvent)
        COM_INTERFACE_ENTRY(IUpdateAgentEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    UpdateAgentStateChangedEvent() { Log12(("UpdateAgentStateChangedEvent %p\n", this)); }
    virtual ~UpdateAgentStateChangedEvent() { Log12(("~UpdateAgentStateChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute state
private:
    UpdateState_T    m_state;
public:
    STDMETHOD(COMGETTER(State))(UpdateState_T * a_state) RT_OVERRIDE
    {
        *a_state = m_state;
        return S_OK;
    }
    // purely internal setter
    inline void set_state(UpdateState_T a_state)
    {
         m_state = a_state;
    }

    // attribute agent
private:
    ComPtr<IUpdateAgent>    m_agent;
public:
    STDMETHOD(COMGETTER(Agent))(IUpdateAgent * * a_agent) RT_OVERRIDE
    {
        return m_agent.queryInterfaceTo(a_agent);
    }
    // purely internal setter
    inline void set_agent(IUpdateAgent * a_agent)
    {
         m_agent = a_agent;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(UpdateAgentStateChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(UpdateAgentStateChangedEvent, IUpdateAgentStateChangedEvent, IUpdateAgentEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateUpdateAgentStateChangedEvent(IEvent **aEvent, IEventSource *aSource, IUpdateAgent * a_agent, UpdateState_T a_state)
{
    ComObjPtr<UpdateAgentStateChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnUpdateAgentStateChanged, FALSE /*waitable*/);
        EvtObj->set_agent(a_agent);
        EvtObj->set_state(a_state);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireUpdateAgentStateChangedEvent(IEventSource *aSource, IUpdateAgent * a_agent, UpdateState_T a_state)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateUpdateAgentStateChangedEvent(ptrEvent.asOutParam(), aSource, a_agent, a_state);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IGuestDebugControlChangedEvent implementation code
class ATL_NO_VTABLE GuestDebugControlChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IGuestDebugControlChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(GuestDebugControlChangedEvent, IGuestDebugControlChangedEvent)
    DECLARE_NOT_AGGREGATABLE(GuestDebugControlChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(GuestDebugControlChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IGuestDebugControlChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IGuestDebugControlChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IGuestDebugControlChangedEvent)
        COM_INTERFACE_ENTRY(IGuestDebugControlChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    GuestDebugControlChangedEvent() { Log12(("GuestDebugControlChangedEvent %p\n", this)); }
    virtual ~GuestDebugControlChangedEvent() { Log12(("~GuestDebugControlChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute guestDebugControl
private:
    ComPtr<IGuestDebugControl>    m_guestDebugControl;
public:
    STDMETHOD(COMGETTER(GuestDebugControl))(IGuestDebugControl * * a_guestDebugControl) RT_OVERRIDE
    {
        return m_guestDebugControl.queryInterfaceTo(a_guestDebugControl);
    }
    // purely internal setter
    inline void set_guestDebugControl(IGuestDebugControl * a_guestDebugControl)
    {
         m_guestDebugControl = a_guestDebugControl;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestDebugControlChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestDebugControlChangedEvent, IGuestDebugControlChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateGuestDebugControlChangedEvent(IEvent **aEvent, IEventSource *aSource, IGuestDebugControl * a_guestDebugControl)
{
    ComObjPtr<GuestDebugControlChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnGuestDebugControlChanged, FALSE /*waitable*/);
        EvtObj->set_guestDebugControl(a_guestDebugControl);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireGuestDebugControlChangedEvent(IEventSource *aSource, IGuestDebugControl * a_guestDebugControl)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateGuestDebugControlChangedEvent(ptrEvent.asOutParam(), aSource, a_guestDebugControl);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// IMachineGroupsChangedEvent implementation code
class ATL_NO_VTABLE MachineGroupsChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(IMachineGroupsChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(MachineGroupsChangedEvent, IMachineGroupsChangedEvent)
    DECLARE_NOT_AGGREGATABLE(MachineGroupsChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(MachineGroupsChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(IMachineGroupsChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, IMachineGroupsChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(IMachineGroupsChangedEvent)
        COM_INTERFACE_ENTRY(IMachineGroupsChangedEvent)
        COM_INTERFACE_ENTRY(IMachineEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    MachineGroupsChangedEvent() { Log12(("MachineGroupsChangedEvent %p\n", this)); }
    virtual ~MachineGroupsChangedEvent() { Log12(("~MachineGroupsChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute dummy
private:
    BOOL    m_dummy;
public:
    STDMETHOD(COMGETTER(Dummy))(BOOL * a_dummy) RT_OVERRIDE
    {
        *a_dummy = m_dummy;
        return S_OK;
    }
    // purely internal setter
    inline void set_dummy(BOOL a_dummy)
    {
         m_dummy = a_dummy;
    }

    // attribute machineId
private:
    Utf8Str    m_machineId;
public:
    STDMETHOD(COMGETTER(MachineId))(BSTR * a_machineId) RT_OVERRIDE
    {
        return m_machineId.cloneToEx(a_machineId);
    }
    // purely internal setter
    inline HRESULT set_machineId(const Utf8Str &a_rString)
    {
        return m_machineId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MachineGroupsChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(MachineGroupsChangedEvent, IMachineGroupsChangedEvent, IMachineEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateMachineGroupsChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_dummy)
{
    ComObjPtr<MachineGroupsChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnMachineGroupsChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_machineId(a_machineId);
        EvtObj->set_dummy(a_dummy);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireMachineGroupsChangedEvent(IEventSource *aSource, const Utf8Str & a_machineId, BOOL a_dummy)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateMachineGroupsChangedEvent(ptrEvent.asOutParam(), aSource, a_machineId, a_dummy);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ICloudProviderListChangedEvent implementation code
class ATL_NO_VTABLE CloudProviderListChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICloudProviderListChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CloudProviderListChangedEvent, ICloudProviderListChangedEvent)
    DECLARE_NOT_AGGREGATABLE(CloudProviderListChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(CloudProviderListChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICloudProviderListChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ICloudProviderListChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ICloudProviderListChangedEvent)
        COM_INTERFACE_ENTRY(ICloudProviderListChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    CloudProviderListChangedEvent() { Log12(("CloudProviderListChangedEvent %p\n", this)); }
    virtual ~CloudProviderListChangedEvent() { Log12(("~CloudProviderListChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute registered
private:
    BOOL    m_registered;
public:
    STDMETHOD(COMGETTER(Registered))(BOOL * a_registered) RT_OVERRIDE
    {
        *a_registered = m_registered;
        return S_OK;
    }
    // purely internal setter
    inline void set_registered(BOOL a_registered)
    {
         m_registered = a_registered;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudProviderListChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(CloudProviderListChangedEvent, ICloudProviderListChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateCloudProviderListChangedEvent(IEvent **aEvent, IEventSource *aSource, BOOL a_registered)
{
    ComObjPtr<CloudProviderListChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnCloudProviderListChanged, FALSE /*waitable*/);
        EvtObj->set_registered(a_registered);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireCloudProviderListChangedEvent(IEventSource *aSource, BOOL a_registered)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateCloudProviderListChangedEvent(ptrEvent.asOutParam(), aSource, a_registered);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ICloudProviderRegisteredEvent implementation code
class ATL_NO_VTABLE CloudProviderRegisteredEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICloudProviderRegisteredEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CloudProviderRegisteredEvent, ICloudProviderRegisteredEvent)
    DECLARE_NOT_AGGREGATABLE(CloudProviderRegisteredEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(CloudProviderRegisteredEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICloudProviderRegisteredEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ICloudProviderRegisteredEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ICloudProviderRegisteredEvent)
        COM_INTERFACE_ENTRY(ICloudProviderRegisteredEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    CloudProviderRegisteredEvent() { Log12(("CloudProviderRegisteredEvent %p\n", this)); }
    virtual ~CloudProviderRegisteredEvent() { Log12(("~CloudProviderRegisteredEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute id
private:
    Utf8Str    m_id;
public:
    STDMETHOD(COMGETTER(Id))(BSTR * a_id) RT_OVERRIDE
    {
        return m_id.cloneToEx(a_id);
    }
    // purely internal setter
    inline HRESULT set_id(const Utf8Str &a_rString)
    {
        return m_id.assignEx(a_rString);
    }

    // attribute registered
private:
    BOOL    m_registered;
public:
    STDMETHOD(COMGETTER(Registered))(BOOL * a_registered) RT_OVERRIDE
    {
        *a_registered = m_registered;
        return S_OK;
    }
    // purely internal setter
    inline void set_registered(BOOL a_registered)
    {
         m_registered = a_registered;
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudProviderRegisteredEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(CloudProviderRegisteredEvent, ICloudProviderRegisteredEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateCloudProviderRegisteredEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_id, BOOL a_registered)
{
    ComObjPtr<CloudProviderRegisteredEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnCloudProviderRegistered, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_id(a_id);
        EvtObj->set_registered(a_registered);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireCloudProviderRegisteredEvent(IEventSource *aSource, const Utf8Str & a_id, BOOL a_registered)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateCloudProviderRegisteredEvent(ptrEvent.asOutParam(), aSource, a_id, a_registered);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ICloudProviderUninstallEvent implementation code
class ATL_NO_VTABLE CloudProviderUninstallEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ICloudProviderUninstallEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(CloudProviderUninstallEvent, ICloudProviderUninstallEvent)
    DECLARE_NOT_AGGREGATABLE(CloudProviderUninstallEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(CloudProviderUninstallEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ICloudProviderUninstallEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ICloudProviderUninstallEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ICloudProviderUninstallEvent)
        COM_INTERFACE_ENTRY(ICloudProviderUninstallEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    CloudProviderUninstallEvent() { Log12(("CloudProviderUninstallEvent %p\n", this)); }
    virtual ~CloudProviderUninstallEvent() { Log12(("~CloudProviderUninstallEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute id
private:
    Utf8Str    m_id;
public:
    STDMETHOD(COMGETTER(Id))(BSTR * a_id) RT_OVERRIDE
    {
        return m_id.cloneToEx(a_id);
    }
    // purely internal setter
    inline HRESULT set_id(const Utf8Str &a_rString)
    {
        return m_id.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudProviderUninstallEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(CloudProviderUninstallEvent, ICloudProviderUninstallEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateCloudProviderUninstallEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_id)
{
    ComObjPtr<CloudProviderUninstallEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnCloudProviderUninstall, TRUE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_id(a_id);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireCloudProviderUninstallEvent(IEventSource *aSource, const Utf8Str & a_id)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateCloudProviderUninstallEvent(ptrEvent.asOutParam(), aSource, a_id);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

// ILanguageChangedEvent implementation code
class ATL_NO_VTABLE LanguageChangedEvent
    : public VirtualBoxBase
    , VBOX_SCRIPTABLE_IMPL(ILanguageChangedEvent)
{
public:
    VIRTUALBOXBASE_ADD_ERRORINFO_SUPPORT(LanguageChangedEvent, ILanguageChangedEvent)
    DECLARE_NOT_AGGREGATABLE(LanguageChangedEvent)
    DECLARE_PROTECT_FINAL_CONSTRUCT()
    BEGIN_COM_MAP(LanguageChangedEvent)
        COM_INTERFACE_ENTRY(ISupportErrorInfo)
        COM_INTERFACE_ENTRY(ILanguageChangedEvent)
        COM_INTERFACE_ENTRY2(IDispatch, ILanguageChangedEvent)
        VBOX_TWEAK_INTERFACE_ENTRY(ILanguageChangedEvent)
        COM_INTERFACE_ENTRY(ILanguageChangedEvent)
        COM_INTERFACE_ENTRY(IEvent)
    END_COM_MAP()
    LanguageChangedEvent() { Log12(("LanguageChangedEvent %p\n", this)); }
    virtual ~LanguageChangedEvent() { Log12(("~LanguageChangedEvent %p\n", this)); uninit(); }

    HRESULT FinalConstruct()
    {
        BaseFinalConstruct();
        return mEvent.createObject();
    }
    void FinalRelease()
    {
        uninit();
        BaseFinalRelease();
    }
    STDMETHOD(COMGETTER(Type))(VBoxEventType_T *aType) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Type)(aType);
    }
    STDMETHOD(COMGETTER(Source))(IEventSource * *aSource) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Source)(aSource);
    }
    STDMETHOD(COMGETTER(Waitable))(BOOL *aWaitable) RT_OVERRIDE
    {
        return mEvent->COMGETTER(Waitable)(aWaitable);
    }
    STDMETHOD(SetProcessed)() RT_OVERRIDE
    {
       return mEvent->SetProcessed();
    }
    STDMETHOD(WaitProcessed)(LONG aTimeout, BOOL *aResult) RT_OVERRIDE
    {
        return mEvent->WaitProcessed(aTimeout, aResult);
    }
    void uninit() RT_OVERRIDE
    {
        if (!mEvent.isNull())
        {
           mEvent->uninit();
           mEvent.setNull();
        }
    }

    HRESULT init(IEventSource *aSource, VBoxEventType_T aType, BOOL aWaitable)
    {
        return mEvent->init(aSource, aType, aWaitable);
    }
private:
    ComObjPtr<VBoxEvent>      mEvent;

    // attribute languageId
private:
    Utf8Str    m_languageId;
public:
    STDMETHOD(COMGETTER(LanguageId))(BSTR * a_languageId) RT_OVERRIDE
    {
        return m_languageId.cloneToEx(a_languageId);
    }
    // purely internal setter
    inline HRESULT set_languageId(const Utf8Str &a_rString)
    {
        return m_languageId.assignEx(a_rString);
    }
    // skipping IEvent attributes 
};
#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(LanguageChangedEvent)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(LanguageChangedEvent, ILanguageChangedEvent, IEvent)
#endif

DECLHIDDEN(HRESULT) CreateLanguageChangedEvent(IEvent **aEvent, IEventSource *aSource, const Utf8Str & a_languageId)
{
    ComObjPtr<LanguageChangedEvent> EvtObj;
    HRESULT hrc = EvtObj.createObject();
    if (SUCCEEDED(hrc))
    {
        hrc = EvtObj->init(aSource, VBoxEventType_OnLanguageChanged, FALSE /*waitable*/);
        if (SUCCEEDED(hrc))
            hrc = EvtObj->set_languageId(a_languageId);
        if (SUCCEEDED(hrc))
        {
            hrc = EvtObj.queryInterfaceTo(aEvent);
            if (SUCCEEDED(hrc))
                return hrc;
        }
    }
    *aEvent = NULL;
    return hrc;
}

DECLHIDDEN(HRESULT) FireLanguageChangedEvent(IEventSource *aSource, const Utf8Str & a_languageId)
{
    AssertReturn(aSource, E_INVALIDARG);
    ComPtr<IEvent> ptrEvent;
    HRESULT hrc = CreateLanguageChangedEvent(ptrEvent.asOutParam(), aSource, a_languageId);
    if (SUCCEEDED(hrc))
    {
        BOOL fDeliveredIgnored = FALSE;
        hrc = aSource->FireEvent(ptrEvent, /* do not wait for delivery */ 0, &fDeliveredIgnored);
        AssertComRC(hrc);
    }
    return hrc;
}

