// python wrapper for ttkHarmonicField
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkHarmonicField.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkHarmonicField(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkHarmonicField_ClassNew(); }


static PyObject *
PyttkHarmonicField_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkHarmonicField::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkHarmonicField::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkHarmonicField *tempr = ttkHarmonicField::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkHarmonicField *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkHarmonicField::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkHarmonicField::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkHarmonicField::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_SetOutputScalarFieldName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputScalarFieldName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputScalarFieldName(temp0);
    }
    else
    {
      op->ttkHarmonicField::SetOutputScalarFieldName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_GetOutputScalarFieldName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputScalarFieldName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetOutputScalarFieldName() :
      op->ttkHarmonicField::GetOutputScalarFieldName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_SetForceConstraintIdentifiers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceConstraintIdentifiers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceConstraintIdentifiers(temp0);
    }
    else
    {
      op->ttkHarmonicField::SetForceConstraintIdentifiers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_GetForceConstraintIdentifiers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceConstraintIdentifiers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceConstraintIdentifiers() :
      op->ttkHarmonicField::GetForceConstraintIdentifiers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_SetUseCotanWeights(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseCotanWeights");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseCotanWeights(temp0);
    }
    else
    {
      op->ttkHarmonicField::SetUseCotanWeights(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_GetUseCotanWeights(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseCotanWeights");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseCotanWeights() :
      op->ttkHarmonicField::GetUseCotanWeights());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_SetSolvingMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSolvingMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSolvingMethod(temp0);
    }
    else
    {
      op->ttkHarmonicField::SetSolvingMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_GetSolvingMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSolvingMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSolvingMethod() :
      op->ttkHarmonicField::GetSolvingMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_SetLogAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLogAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLogAlpha(temp0);
    }
    else
    {
      op->ttkHarmonicField::SetLogAlpha(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkHarmonicField_GetLogAlpha(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLogAlpha");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkHarmonicField *op = static_cast<ttkHarmonicField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLogAlpha() :
      op->ttkHarmonicField::GetLogAlpha());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkHarmonicField_Methods[] = {
  {"IsTypeOf", PyttkHarmonicField_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkHarmonicField_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkHarmonicField_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkHarmonicField\nC++: static ttkHarmonicField *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkHarmonicField_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkHarmonicField\nC++: ttkHarmonicField *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkHarmonicField_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkHarmonicField_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetOutputScalarFieldName", PyttkHarmonicField_SetOutputScalarFieldName, METH_VARARGS,
   "SetOutputScalarFieldName(self, _arg:str) -> None\nC++: virtual void SetOutputScalarFieldName(\n    const std::string &_arg)\n\n"},
  {"GetOutputScalarFieldName", PyttkHarmonicField_GetOutputScalarFieldName, METH_VARARGS,
   "GetOutputScalarFieldName(self) -> str\nC++: virtual std::string GetOutputScalarFieldName()\n\n"},
  {"SetForceConstraintIdentifiers", PyttkHarmonicField_SetForceConstraintIdentifiers, METH_VARARGS,
   "SetForceConstraintIdentifiers(self, _arg:bool) -> None\nC++: virtual void SetForceConstraintIdentifiers(bool _arg)\n\n"},
  {"GetForceConstraintIdentifiers", PyttkHarmonicField_GetForceConstraintIdentifiers, METH_VARARGS,
   "GetForceConstraintIdentifiers(self) -> bool\nC++: virtual bool GetForceConstraintIdentifiers()\n\n"},
  {"SetUseCotanWeights", PyttkHarmonicField_SetUseCotanWeights, METH_VARARGS,
   "SetUseCotanWeights(self, _arg:bool) -> None\nC++: virtual void SetUseCotanWeights(bool _arg)\n\n"},
  {"GetUseCotanWeights", PyttkHarmonicField_GetUseCotanWeights, METH_VARARGS,
   "GetUseCotanWeights(self) -> bool\nC++: virtual bool GetUseCotanWeights()\n\n"},
  {"SetSolvingMethod", PyttkHarmonicField_SetSolvingMethod, METH_VARARGS,
   "SetSolvingMethod(self, arg_:int) -> None\nC++: void SetSolvingMethod(const int arg_)\n\n"},
  {"GetSolvingMethod", PyttkHarmonicField_GetSolvingMethod, METH_VARARGS,
   "GetSolvingMethod(self) -> int\nC++: virtual int GetSolvingMethod()\n\n"},
  {"SetLogAlpha", PyttkHarmonicField_SetLogAlpha, METH_VARARGS,
   "SetLogAlpha(self, _arg:float) -> None\nC++: virtual void SetLogAlpha(double _arg)\n\n"},
  {"GetLogAlpha", PyttkHarmonicField_GetLogAlpha, METH_VARARGS,
   "GetLogAlpha(self) -> float\nC++: virtual double GetLogAlpha()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkHarmonicField_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("output_scalar_field_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkHarmonicField_GetOutputScalarFieldName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkHarmonicField_SetOutputScalarFieldName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkHarmonicField_SetOutputScalarFieldName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputScalarFieldName/SetOutputScalarFieldName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_constraint_identifiers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkHarmonicField_GetForceConstraintIdentifiers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkHarmonicField_SetForceConstraintIdentifiers(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkHarmonicField_SetForceConstraintIdentifiers(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceConstraintIdentifiers/SetForceConstraintIdentifiers\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_cotan_weights"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkHarmonicField_GetUseCotanWeights(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkHarmonicField_SetUseCotanWeights(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkHarmonicField_SetUseCotanWeights(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseCotanWeights/SetUseCotanWeights\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("solving_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkHarmonicField_GetSolvingMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkHarmonicField_SetSolvingMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkHarmonicField_SetSolvingMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSolvingMethod/SetSolvingMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("log_alpha"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkHarmonicField_GetLogAlpha(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkHarmonicField_SetLogAlpha(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkHarmonicField_SetLogAlpha(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLogAlpha/SetLogAlpha\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkHarmonicField_Doc =
  "ttkHarmonicField - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Pierre Guillou <pierre.guillou@lip6.fr>\\date February 2019\n\n"
  "TTK VTK-filter for harmonic field computations.\n\n"
  "The current filter takes a list of sources with attached scalar\n"
  "values and produces a scalar harmonic field fulfilling these\n"
  "constraints.\n\n"
  "\\param Input0 Input geometry, either 2D or 3D, either regular grid\n"
  "or triangulation (vtkDataSet)\n"
  "\\param Input1 List of critical point constraints (vtkPointSet)\n"
  "\\param Output Output harmonic scalar field (vtkDataSet)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Dynamic harmonic fields for surface processing\"\n\n"
  "Kai Xu, Hao Zhang, Daniel Cohen-Or, Yueshan Xiong\n\n"
  "Computers & Graphics 2009.\n\n"
  "\\sa ttkScalarFieldCriticalPoints\n"
  "\\sa ttkIntegralLines\n"
  "\\sa ttkMergeTree\n"
  "\\sa ttkIdentifiers\n"
  "\\sa ttk::HarmonicField\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/harmonicSkeleton/\"\n"
  "  > Harmonic Skeleton example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkHarmonicField_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkHarmonicField.ttkHarmonicField", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkHarmonicField_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkHarmonicField_StaticNew()
{
  return ttkHarmonicField::New();
}

PyObject *PyttkHarmonicField_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkHarmonicField_Type, PyttkHarmonicField_Methods,
    "ttkHarmonicField",
 &PyttkHarmonicField_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkHarmonicField_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkHarmonicField(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkHarmonicField_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkHarmonicField", o) != 0)
  {
    Py_DECREF(o);
  }

}

