/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the SPIRV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(SPIRVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(SPIRVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static SPIRVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static SPIRVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_s64,
  GILLT_v2s64,
};
const static size_t NumTypeObjects = 3;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 64),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset SPIRVInstructionSelector::
computeAvailableModuleFeatures(const SPIRVSubtarget *Subtarget) const {
  PredicateBitset Features{};
  return Features;
}

void SPIRVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const SPIRVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset SPIRVInstructionSelector::
computeAvailableFunctionFeatures(const SPIRVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

SPIRVInstructionSelector::ComplexMatcherMemFn
SPIRVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool SPIRVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool SPIRVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_PseudoConstF = GICXXPred_Invalid + 1,
};
bool SPIRVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_PseudoConstF: {
      return true; 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_ConstPseudoFalse = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_ConstPseudoNull,
  GICXXPred_APInt_Predicate_ConstPseudoTrue,
  GICXXPred_APInt_Predicate_PseudoConstI,
};
bool SPIRVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_ConstPseudoFalse: {
     return Imm.getBitWidth() == 1 && Imm.getZExtValue() == 0; 
  }
  case GICXXPred_APInt_Predicate_ConstPseudoNull: {
     return Imm.isZero(); 
  }
  case GICXXPred_APInt_Predicate_ConstPseudoTrue: {
     return Imm.getBitWidth() == 1 && Imm.getZExtValue() == 1; 
  }
  case GICXXPred_APInt_Predicate_PseudoConstI: {
     return Imm.getBitWidth() <= 32; 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool SPIRVInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("SPIRVInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderFImm64,
  GICR_renderImm32,
};
SPIRVInstructionSelector::CustomRendererFn
SPIRVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &SPIRVInstructionSelector::renderFImm64,
  &SPIRVInstructionSelector::renderImm32,
};

bool SPIRVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool SPIRVInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("SPIRVInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *SPIRVInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_Try, /*On fail goto*//*Label 0*/ GIMT_Encode4(3828),
      GIM_CheckOpcode, /*MI*/0, GIMT_Encode2(SPIRV::ASSIGN_TYPE),
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(3), /*)*//*default:*//*Label 4*/ GIMT_Encode4(3827),
      /*GILLT_p0s64*//*Label 1*/ GIMT_Encode4(32),
      /*GILLT_s64*//*Label 2*/ GIMT_Encode4(179),
      /*GILLT_v2s64*//*Label 3*/ GIMT_Encode4(2151),
      // Label 1: @32
      GIM_Try, /*On fail goto*//*Label 5*/ GIMT_Encode4(178),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_p0s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
        GIM_Try, /*On fail goto*//*Label 6*/ GIMT_Encode4(114), // Rule ID 56 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_p0s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_p0s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (select:{ *:[i64] } iID:{ *:[i64] }:$cond, pID:{ *:[i64] }:$src1, pID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSPSCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, pID:{ *:[i64] }:$src1, pID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSPSCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 56,
          GIR_EraseRootFromParent_Done,
        // Label 6: @114
        GIM_Try, /*On fail goto*//*Label 7*/ GIMT_Encode4(177), // Rule ID 57 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_p0s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_p0s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (select:{ *:[i64] } vID:{ *:[v2i64] }:$cond, pID:{ *:[i64] }:$src1, pID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSPVCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, pID:{ *:[i64] }:$src1, pID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSPVCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 57,
          GIR_EraseRootFromParent_Done,
        // Label 7: @177
        GIM_Reject,
      // Label 5: @178
      GIM_Reject,
      // Label 2: @179
      GIM_Try, /*On fail goto*//*Label 8*/ GIMT_Encode4(2150),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_Try, /*On fail goto*//*Label 9*/ GIMT_Encode4(231), // Rule ID 3 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
          GIM_CheckAPFloatImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APFloat_Predicate_PseudoConstF),
          // MIs[1] Operand 1
          // No operand predicates
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (fpimm:{ *:[f64] })<<P:Predicate_PseudoConstF>><<X:fimm_to_i64>>:$src, TYPE:{ *:[i64] }:$type)  =>  (OpConstantF:{ *:[f64] } TYPE:{ *:[i64] }:$type, (fimm_to_i64:{ *:[f64] } (fpimm:{ *:[f64] }):$src))
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpConstantF),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // type
          GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderFImm64), // src
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 3,
          GIR_EraseRootFromParent_Done,
        // Label 9: @231
        GIM_Try, /*On fail goto*//*Label 10*/ GIMT_Encode4(267), // Rule ID 0 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
          GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_ConstPseudoTrue),
          // MIs[1] Operand 1
          // No operand predicates
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_ConstPseudoTrue>>, TYPE:{ *:[i64] }:$src_ty)  =>  (OpConstantTrue:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpConstantTrue),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 0,
          GIR_EraseRootFromParent_Done,
        // Label 10: @267
        GIM_Try, /*On fail goto*//*Label 11*/ GIMT_Encode4(303), // Rule ID 1 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
          GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_ConstPseudoFalse),
          // MIs[1] Operand 1
          // No operand predicates
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_ConstPseudoFalse>>, TYPE:{ *:[i64] }:$src_ty)  =>  (OpConstantFalse:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpConstantFalse),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 1,
          GIR_EraseRootFromParent_Done,
        // Label 11: @303
        GIM_Try, /*On fail goto*//*Label 12*/ GIMT_Encode4(344), // Rule ID 2 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
          GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_PseudoConstI),
          // MIs[1] Operand 1
          // No operand predicates
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_PseudoConstI>><<X:imm_to_i32>>:$src, TYPE:{ *:[i64] }:$type)  =>  (OpConstantI:{ *:[i64] } TYPE:{ *:[i64] }:$type, (imm_to_i32:{ *:[i64] } (imm:{ *:[i64] }):$src))
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpConstantI),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // type
          GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderImm32), // src
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 2,
          GIR_EraseRootFromParent_Done,
        // Label 12: @344
        GIM_Try, /*On fail goto*//*Label 13*/ GIMT_Encode4(415), // Rule ID 58 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (select:{ *:[i64] } iID:{ *:[i64] }:$cond, iID:{ *:[i64] }:$src1, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSISCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, iID:{ *:[i64] }:$src1, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSISCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 58,
          GIR_EraseRootFromParent_Done,
        // Label 13: @415
        GIM_Try, /*On fail goto*//*Label 14*/ GIMT_Encode4(486), // Rule ID 59 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (select:{ *:[i64] } vID:{ *:[v2i64] }:$cond, iID:{ *:[i64] }:$src1, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSIVCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, iID:{ *:[i64] }:$src1, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSIVCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 59,
          GIR_EraseRootFromParent_Done,
        // Label 14: @486
        GIM_Try, /*On fail goto*//*Label 15*/ GIMT_Encode4(557), // Rule ID 60 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (select:{ *:[f64] } iID:{ *:[i64] }:$cond, fID:{ *:[f64] }:$src1, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSFSCond:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, fID:{ *:[f64] }:$src1, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSFSCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 60,
          GIR_EraseRootFromParent_Done,
        // Label 15: @557
        GIM_Try, /*On fail goto*//*Label 16*/ GIMT_Encode4(628), // Rule ID 61 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (select:{ *:[f64] } vID:{ *:[v2i64] }:$cond, fID:{ *:[f64] }:$src1, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSFVCond:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, fID:{ *:[f64] }:$src1, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSFVCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 61,
          GIR_EraseRootFromParent_Done,
        // Label 16: @628
        GIM_Try, /*On fail goto*//*Label 17*/ GIMT_Encode4(699), // Rule ID 62 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (select:{ *:[i64] } iID:{ *:[i64] }:$cond, vpID:{ *:[i64] }:$src1, vpID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVPSCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, vpID:{ *:[i64] }:$src1, vpID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVPSCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 62,
          GIR_EraseRootFromParent_Done,
        // Label 17: @699
        GIM_Try, /*On fail goto*//*Label 18*/ GIMT_Encode4(770), // Rule ID 63 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (select:{ *:[i64] } vID:{ *:[v2i64] }:$cond, vpID:{ *:[i64] }:$src1, vpID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVPVCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, vpID:{ *:[i64] }:$src1, vpID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVPVCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 63,
          GIR_EraseRootFromParent_Done,
        // Label 18: @770
        GIM_Try, /*On fail goto*//*Label 19*/ GIMT_Encode4(828), // Rule ID 6 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (add:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpIAddS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpIAddS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 6,
          GIR_EraseRootFromParent_Done,
        // Label 19: @828
        GIM_Try, /*On fail goto*//*Label 20*/ GIMT_Encode4(886), // Rule ID 54 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (and:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseAndS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseAndS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 54,
          GIR_EraseRootFromParent_Done,
        // Label 20: @886
        GIM_Try, /*On fail goto*//*Label 21*/ GIMT_Encode4(944), // Rule ID 46 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (sra:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftRightArithmeticS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftRightArithmeticS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 46,
          GIR_EraseRootFromParent_Done,
        // Label 21: @944
        GIM_Try, /*On fail goto*//*Label 22*/ GIMT_Encode4(1002), // Rule ID 8 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FADD),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (fadd:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFAddS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFAddS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 8,
          GIR_EraseRootFromParent_Done,
        // Label 22: @1002
        GIM_Try, /*On fail goto*//*Label 23*/ GIMT_Encode4(1060), // Rule ID 28 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FDIV),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (fdiv:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFDivS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFDivS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 28,
          GIR_EraseRootFromParent_Done,
        // Label 23: @1060
        GIM_Try, /*On fail goto*//*Label 24*/ GIMT_Encode4(1118), // Rule ID 20 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FMUL),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (fmul:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFMulS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFMulS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 20,
          GIR_EraseRootFromParent_Done,
        // Label 24: @1118
        GIM_Try, /*On fail goto*//*Label 25*/ GIMT_Encode4(1176), // Rule ID 36 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FREM),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (frem:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFRemS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFRemS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 36,
          GIR_EraseRootFromParent_Done,
        // Label 25: @1176
        GIM_Try, /*On fail goto*//*Label 26*/ GIMT_Encode4(1234), // Rule ID 14 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FSUB),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (fsub:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFSubS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFSubS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 14,
          GIR_EraseRootFromParent_Done,
        // Label 26: @1234
        GIM_Try, /*On fail goto*//*Label 27*/ GIMT_Encode4(1292), // Rule ID 44 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (srl:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftRightLogicalS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftRightLogicalS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 44,
          GIR_EraseRootFromParent_Done,
        // Label 27: @1292
        GIM_Try, /*On fail goto*//*Label 28*/ GIMT_Encode4(1350), // Rule ID 18 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (mul:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpIMulS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpIMulS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 18,
          GIR_EraseRootFromParent_Done,
        // Label 28: @1350
        GIM_Try, /*On fail goto*//*Label 29*/ GIMT_Encode4(1408), // Rule ID 50 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (or:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseOrS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseOrS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 50,
          GIR_EraseRootFromParent_Done,
        // Label 29: @1408
        GIM_Try, /*On fail goto*//*Label 30*/ GIMT_Encode4(1466), // Rule ID 26 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SDIV),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (sdiv:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSDivS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSDivS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 26,
          GIR_EraseRootFromParent_Done,
        // Label 30: @1466
        GIM_Try, /*On fail goto*//*Label 31*/ GIMT_Encode4(1524), // Rule ID 48 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (shl:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftLeftLogicalS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftLeftLogicalS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 48,
          GIR_EraseRootFromParent_Done,
        // Label 31: @1524
        GIM_Try, /*On fail goto*//*Label 32*/ GIMT_Encode4(1582), // Rule ID 34 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SREM),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (srem:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSRemS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSRemS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 34,
          GIR_EraseRootFromParent_Done,
        // Label 32: @1582
        GIM_Try, /*On fail goto*//*Label 33*/ GIMT_Encode4(1640), // Rule ID 10 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FADD),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (strict_fadd:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFAddS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFAddS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 10,
          GIR_EraseRootFromParent_Done,
        // Label 33: @1640
        GIM_Try, /*On fail goto*//*Label 34*/ GIMT_Encode4(1698), // Rule ID 30 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FDIV),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (strict_fdiv:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFDivS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFDivS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 30,
          GIR_EraseRootFromParent_Done,
        // Label 34: @1698
        GIM_Try, /*On fail goto*//*Label 35*/ GIMT_Encode4(1756), // Rule ID 22 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FMUL),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (strict_fmul:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFMulS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFMulS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 22,
          GIR_EraseRootFromParent_Done,
        // Label 35: @1756
        GIM_Try, /*On fail goto*//*Label 36*/ GIMT_Encode4(1814), // Rule ID 38 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FREM),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (strict_frem:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFRemS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFRemS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 38,
          GIR_EraseRootFromParent_Done,
        // Label 36: @1814
        GIM_Try, /*On fail goto*//*Label 37*/ GIMT_Encode4(1872), // Rule ID 16 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FSUB),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (strict_fsub:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFSubS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFSubS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 16,
          GIR_EraseRootFromParent_Done,
        // Label 37: @1872
        GIM_Try, /*On fail goto*//*Label 38*/ GIMT_Encode4(1930), // Rule ID 12 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (sub:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpISubS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpISubS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 12,
          GIR_EraseRootFromParent_Done,
        // Label 38: @1930
        GIM_Try, /*On fail goto*//*Label 39*/ GIMT_Encode4(1988), // Rule ID 24 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UDIV),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (udiv:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpUDivS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpUDivS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 24,
          GIR_EraseRootFromParent_Done,
        // Label 39: @1988
        GIM_Try, /*On fail goto*//*Label 40*/ GIMT_Encode4(2046), // Rule ID 32 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UREM),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (urem:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpUModS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpUModS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 32,
          GIR_EraseRootFromParent_Done,
        // Label 40: @2046
        GIM_Try, /*On fail goto*//*Label 41*/ GIMT_Encode4(2104), // Rule ID 52 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[i64] } (xor:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseXorS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseXorS),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 52,
          GIR_EraseRootFromParent_Done,
        // Label 41: @2104
        GIM_Try, /*On fail goto*//*Label 42*/ GIMT_Encode4(2149), // Rule ID 4 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[f64] } (fneg:{ *:[f64] } fID:{ *:[f64] }:$src), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFNegate:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFNegate),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 4,
          GIR_EraseRootFromParent_Done,
        // Label 42: @2149
        GIM_Reject,
      // Label 8: @2150
      GIM_Reject,
      // Label 3: @2151
      GIM_Try, /*On fail goto*//*Label 43*/ GIMT_Encode4(3826),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_Try, /*On fail goto*//*Label 44*/ GIMT_Encode4(2233), // Rule ID 64 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (select:{ *:[v2i64] } iID:{ *:[i64] }:$cond, vID:{ *:[v2i64] }:$src1, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVISCond:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, vID:{ *:[v2i64] }:$src1, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVISCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 64,
          GIR_EraseRootFromParent_Done,
        // Label 44: @2233
        GIM_Try, /*On fail goto*//*Label 45*/ GIMT_Encode4(2304), // Rule ID 65 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (select:{ *:[v2i64] } vID:{ *:[v2i64] }:$cond, vID:{ *:[v2i64] }:$src1, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVIVCond:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, vID:{ *:[v2i64] }:$src1, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVIVCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 65,
          GIR_EraseRootFromParent_Done,
        // Label 45: @2304
        GIM_Try, /*On fail goto*//*Label 46*/ GIMT_Encode4(2375), // Rule ID 66 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (select:{ *:[v2f64] } iID:{ *:[i64] }:$cond, vfID:{ *:[v2f64] }:$src1, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVFSCond:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, vfID:{ *:[v2f64] }:$src1, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVFSCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 66,
          GIR_EraseRootFromParent_Done,
        // Label 46: @2375
        GIM_Try, /*On fail goto*//*Label 47*/ GIMT_Encode4(2446), // Rule ID 67 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (select:{ *:[v2f64] } vID:{ *:[v2i64] }:$cond, vfID:{ *:[v2f64] }:$src1, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVFVCond:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, vfID:{ *:[v2f64] }:$src1, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVFVCond),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 67,
          GIR_EraseRootFromParent_Done,
        // Label 47: @2446
        GIM_Try, /*On fail goto*//*Label 48*/ GIMT_Encode4(2504), // Rule ID 7 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (add:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpIAddV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpIAddV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 7,
          GIR_EraseRootFromParent_Done,
        // Label 48: @2504
        GIM_Try, /*On fail goto*//*Label 49*/ GIMT_Encode4(2562), // Rule ID 55 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (and:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseAndV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseAndV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 55,
          GIR_EraseRootFromParent_Done,
        // Label 49: @2562
        GIM_Try, /*On fail goto*//*Label 50*/ GIMT_Encode4(2620), // Rule ID 47 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (sra:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftRightArithmeticV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftRightArithmeticV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 47,
          GIR_EraseRootFromParent_Done,
        // Label 50: @2620
        GIM_Try, /*On fail goto*//*Label 51*/ GIMT_Encode4(2678), // Rule ID 9 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FADD),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (fadd:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFAddV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFAddV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 9,
          GIR_EraseRootFromParent_Done,
        // Label 51: @2678
        GIM_Try, /*On fail goto*//*Label 52*/ GIMT_Encode4(2736), // Rule ID 29 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FDIV),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (fdiv:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFDivV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFDivV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 29,
          GIR_EraseRootFromParent_Done,
        // Label 52: @2736
        GIM_Try, /*On fail goto*//*Label 53*/ GIMT_Encode4(2794), // Rule ID 21 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FMUL),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (fmul:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFMulV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFMulV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 21,
          GIR_EraseRootFromParent_Done,
        // Label 53: @2794
        GIM_Try, /*On fail goto*//*Label 54*/ GIMT_Encode4(2852), // Rule ID 37 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FREM),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (frem:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFRemV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFRemV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 37,
          GIR_EraseRootFromParent_Done,
        // Label 54: @2852
        GIM_Try, /*On fail goto*//*Label 55*/ GIMT_Encode4(2910), // Rule ID 15 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FSUB),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (fsub:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFSubV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFSubV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 15,
          GIR_EraseRootFromParent_Done,
        // Label 55: @2910
        GIM_Try, /*On fail goto*//*Label 56*/ GIMT_Encode4(2968), // Rule ID 45 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (srl:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftRightLogicalV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftRightLogicalV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 45,
          GIR_EraseRootFromParent_Done,
        // Label 56: @2968
        GIM_Try, /*On fail goto*//*Label 57*/ GIMT_Encode4(3026), // Rule ID 19 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (mul:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpIMulV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpIMulV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 19,
          GIR_EraseRootFromParent_Done,
        // Label 57: @3026
        GIM_Try, /*On fail goto*//*Label 58*/ GIMT_Encode4(3084), // Rule ID 51 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (or:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseOrV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseOrV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 51,
          GIR_EraseRootFromParent_Done,
        // Label 58: @3084
        GIM_Try, /*On fail goto*//*Label 59*/ GIMT_Encode4(3142), // Rule ID 27 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SDIV),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (sdiv:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSDivV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSDivV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 27,
          GIR_EraseRootFromParent_Done,
        // Label 59: @3142
        GIM_Try, /*On fail goto*//*Label 60*/ GIMT_Encode4(3200), // Rule ID 49 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (shl:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftLeftLogicalV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftLeftLogicalV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 49,
          GIR_EraseRootFromParent_Done,
        // Label 60: @3200
        GIM_Try, /*On fail goto*//*Label 61*/ GIMT_Encode4(3258), // Rule ID 35 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SREM),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (srem:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSRemV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSRemV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 35,
          GIR_EraseRootFromParent_Done,
        // Label 61: @3258
        GIM_Try, /*On fail goto*//*Label 62*/ GIMT_Encode4(3316), // Rule ID 11 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FADD),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (strict_fadd:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFAddV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFAddV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 11,
          GIR_EraseRootFromParent_Done,
        // Label 62: @3316
        GIM_Try, /*On fail goto*//*Label 63*/ GIMT_Encode4(3374), // Rule ID 31 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FDIV),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (strict_fdiv:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFDivV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFDivV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 31,
          GIR_EraseRootFromParent_Done,
        // Label 63: @3374
        GIM_Try, /*On fail goto*//*Label 64*/ GIMT_Encode4(3432), // Rule ID 23 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FMUL),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (strict_fmul:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFMulV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFMulV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 23,
          GIR_EraseRootFromParent_Done,
        // Label 64: @3432
        GIM_Try, /*On fail goto*//*Label 65*/ GIMT_Encode4(3490), // Rule ID 39 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FREM),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (strict_frem:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFRemV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFRemV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 39,
          GIR_EraseRootFromParent_Done,
        // Label 65: @3490
        GIM_Try, /*On fail goto*//*Label 66*/ GIMT_Encode4(3548), // Rule ID 17 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FSUB),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (strict_fsub:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFSubV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFSubV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 17,
          GIR_EraseRootFromParent_Done,
        // Label 66: @3548
        GIM_Try, /*On fail goto*//*Label 67*/ GIMT_Encode4(3606), // Rule ID 13 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (sub:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpISubV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpISubV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 13,
          GIR_EraseRootFromParent_Done,
        // Label 67: @3606
        GIM_Try, /*On fail goto*//*Label 68*/ GIMT_Encode4(3664), // Rule ID 25 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UDIV),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (udiv:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpUDivV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpUDivV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 25,
          GIR_EraseRootFromParent_Done,
        // Label 68: @3664
        GIM_Try, /*On fail goto*//*Label 69*/ GIMT_Encode4(3722), // Rule ID 33 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UREM),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (urem:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpUModV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpUModV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 33,
          GIR_EraseRootFromParent_Done,
        // Label 69: @3722
        GIM_Try, /*On fail goto*//*Label 70*/ GIMT_Encode4(3780), // Rule ID 53 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2i64] } (xor:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseXorV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseXorV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 53,
          GIR_EraseRootFromParent_Done,
        // Label 70: @3780
        GIM_Try, /*On fail goto*//*Label 71*/ GIMT_Encode4(3825), // Rule ID 5 //
          GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
          GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
          GIM_CheckIsSafeToFold, /*NumInsns*/1,
          // (assigntype:{ *:[v2f64] } (fneg:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFNegateV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src)
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFNegateV),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
          GIR_RootConstrainSelectedInstOperands,
          // GIR_Coverage, 5,
          GIR_EraseRootFromParent_Done,
        // Label 71: @3825
        GIM_Reject,
      // Label 43: @3826
      GIM_Reject,
      // Label 4: @3827
      GIM_Reject,
    // Label 0: @3828
    GIM_Reject,
    }; // Size: 3829 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GLOBALISEL_IMPL

#ifdef GET_GLOBALISEL_PREDICATES_DECL
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const SPIRVSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const SPIRVSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GLOBALISEL_PREDICATES_DECL
#ifdef GET_GLOBALISEL_PREDICATES_INIT
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GLOBALISEL_PREDICATES_INIT
