
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktwofingerswiperecognizer_wrapper.h"

// Wrappers providing overrides
#include "ktwofingertaprecognizer_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qgesture.h>
#include <qobject.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KTwoFingerSwipeRecognizer_Type = nullptr;
static PyTypeObject *Sbk_KTwoFingerSwipeRecognizer_TypeF(void)
{
    return _Sbk_KTwoFingerSwipeRecognizer_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KTwoFingerSwipeRecognizerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KTwoFingerSwipeRecognizerWrapper::KTwoFingerSwipeRecognizerWrapper()
{
}

::QGesture * KTwoFingerSwipeRecognizerWrapper::create(::QObject * target)
{
    static const char *funcName = "create";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipeRecognizer_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTwoFingerSwipeRecognizer::create(target);
    }
    return KTwoFingerTapRecognizerWrapper::sbk_o_create("KTwoFingerSwipeRecognizer", funcName, gil, pyOverride, target);
}

::QFlags<QGestureRecognizer::ResultFlag> KTwoFingerSwipeRecognizerWrapper::recognize(::QGesture * gesture, ::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "recognize";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipeRecognizer_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KTwoFingerSwipeRecognizer::recognize(gesture, watched, event);
    }
    return KTwoFingerTapRecognizerWrapper::sbk_o_recognize("KTwoFingerSwipeRecognizer", funcName, gil, pyOverride, gesture, watched, event);
}

void KTwoFingerSwipeRecognizerWrapper::reset(::QGesture * state)
{
    static const char *funcName = "reset";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerSwipeRecognizer_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QGestureRecognizer::reset(state);
    }
    KTwoFingerTapRecognizerWrapper::sbk_o_reset("KTwoFingerSwipeRecognizer", funcName, gil, pyOverride, state);
}

KTwoFingerSwipeRecognizerWrapper::~KTwoFingerSwipeRecognizerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KTwoFingerSwipeRecognizer_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KTwoFingerSwipeRecognizer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KTwoFingerSwipeRecognizer >()))
        return -1;

    KTwoFingerSwipeRecognizerWrapper *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // KTwoFingerSwipeRecognizer()
        cptr = new KTwoFingerSwipeRecognizerWrapper();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KTwoFingerSwipeRecognizer >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KTwoFingerSwipeRecognizerFunc_create(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipeRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGestureRecognizer::create(QObject*)->QGesture*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArg)))) {
        overloadId = 0; // create(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "create", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // create(QObject*)
            QGesture * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTwoFingerSwipeRecognizer::create(cppArg0)
                : cppSelf->create(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]), cppResult);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerSwipeRecognizerFunc_maxSwipeTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipeRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // maxSwipeTime()const
        int cppResult = const_cast<const ::KTwoFingerSwipeRecognizer *>(cppSelf)->maxSwipeTime();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerSwipeRecognizerFunc_minSswipeDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipeRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minSswipeDistance()const
        int cppResult = const_cast<const ::KTwoFingerSwipeRecognizer *>(cppSelf)->minSswipeDistance();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerSwipeRecognizerFunc_recognize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipeRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "recognize", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QGestureRecognizer::recognize(QGesture*,QObject*,QEvent*)->QFlags<QGestureRecognizer::ResultFlag>
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // recognize(QGesture*,QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "recognize", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGesture *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // recognize(QGesture*,QObject*,QEvent*)
            QFlags<QGestureRecognizer::ResultFlag> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KTwoFingerSwipeRecognizer::recognize(cppArg0, cppArg1, cppArg2)
                : cppSelf->recognize(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QGestureRecognizer_ResultFlag_IDX])))->flagsConverter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerSwipeRecognizerFunc_setMaxSwipeTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipeRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerSwipeRecognizer::setMaxSwipeTime(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaxSwipeTime(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMaxSwipeTime", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaxSwipeTime(int)
            cppSelf->setMaxSwipeTime(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTwoFingerSwipeRecognizerFunc_setSwipeDistance(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerSwipeRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerSwipeRecognizer::setSwipeDistance(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSwipeDistance(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSwipeDistance", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSwipeDistance(int)
            cppSelf->setSwipeDistance(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KTwoFingerSwipeRecognizer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KTwoFingerSwipeRecognizer_methods[] = {
    {"create", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeRecognizerFunc_create), METH_O, nullptr},
    {"maxSwipeTime", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeRecognizerFunc_maxSwipeTime), METH_NOARGS, nullptr},
    {"minSswipeDistance", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeRecognizerFunc_minSswipeDistance), METH_NOARGS, nullptr},
    {"recognize", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeRecognizerFunc_recognize), METH_VARARGS, nullptr},
    {"setMaxSwipeTime", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeRecognizerFunc_setMaxSwipeTime), METH_O, nullptr},
    {"setSwipeDistance", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerSwipeRecognizerFunc_setSwipeDistance), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KTwoFingerSwipeRecognizer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KTwoFingerSwipeRecognizer *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KTwoFingerSwipeRecognizerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KTwoFingerSwipeRecognizer_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KTwoFingerSwipeRecognizer_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KTwoFingerSwipeRecognizer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KTwoFingerSwipeRecognizer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KTwoFingerSwipeRecognizer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KTwoFingerSwipeRecognizer_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KTwoFingerSwipeRecognizer_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KTwoFingerSwipeRecognizer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KTwoFingerSwipeRecognizer_spec = {
    "1:KWidgetsAddons.KTwoFingerSwipeRecognizer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KTwoFingerSwipeRecognizer_slots
};

} //extern "C"

static void *Sbk_KTwoFingerSwipeRecognizer_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QGestureRecognizer >())
        return dynamic_cast< ::KTwoFingerSwipeRecognizer *>(reinterpret_cast< ::QGestureRecognizer *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KTwoFingerSwipeRecognizer_PythonToCpp_KTwoFingerSwipeRecognizer_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KTwoFingerSwipeRecognizer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KTwoFingerSwipeRecognizer_PythonToCpp_KTwoFingerSwipeRecognizer_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KTwoFingerSwipeRecognizer_TypeF()))
        return KTwoFingerSwipeRecognizer_PythonToCpp_KTwoFingerSwipeRecognizer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KTwoFingerSwipeRecognizer_PTR_CppToPython_KTwoFingerSwipeRecognizer(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KTwoFingerSwipeRecognizer_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::KTwoFingerSwipeRecognizer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_KTwoFingerSwipeRecognizer_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KTwoFingerSwipeRecognizer_SignatureStrings[] = {
    "KWidgetsAddons.KTwoFingerSwipeRecognizer(self)",
    "KWidgetsAddons.KTwoFingerSwipeRecognizer.create(self,target:PySide6.QtCore.QObject)->PySide6.QtWidgets.QGesture",
    "KWidgetsAddons.KTwoFingerSwipeRecognizer.maxSwipeTime(self)->int",
    "KWidgetsAddons.KTwoFingerSwipeRecognizer.minSswipeDistance(self)->int",
    "KWidgetsAddons.KTwoFingerSwipeRecognizer.recognize(self,gesture:PySide6.QtWidgets.QGesture,watched:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->PySide6.QtWidgets.QGestureRecognizer.ResultFlag",
    "KWidgetsAddons.KTwoFingerSwipeRecognizer.setMaxSwipeTime(self,i:int)",
    "KWidgetsAddons.KTwoFingerSwipeRecognizer.setSwipeDistance(self,i:int)",
    nullptr}; // Sentinel
#else
static constexpr size_t KTwoFingerSwipeRecognizer_SignatureByteSize = 207;
static constexpr uint8_t KTwoFingerSwipeRecognizer_SignatureBytes[207] = {
    0x78, 0xda, 0x9d, 0x90, 0x4d, 0x8b, 0xc2, 0x30, 0x14, 0x45, 0xf7, 0xf3, 0x4b, 0x2c, 0xd4, 0x2c,
    0x67, 0xd1, 0x85, 0x20, 0x7e, 0x2d, 0x8a, 0x68, 0xad, 0xe0, 0x3a, 0x26, 0xd7, 0xf8, 0xa4, 0x4d,
    0x25, 0x79, 0x5a, 0xf5, 0xd7, 0x5b, 0xad, 0xa2, 0x8c, 0x38, 0x54, 0x77, 0xe1, 0x26, 0xef, 0xbc,
    0xdc, 0x13, 0x2f, 0x48, 0x1b, 0xb0, 0xef, 0x6a, 0x5d, 0x58, 0x2f, 0xe2, 0x79, 0x59, 0x0c, 0xc9,
    0x1a, 0xb8, 0xb4, 0xa4, 0x2d, 0x66, 0x50, 0x85, 0xb1, 0x74, 0x82, 0x6b, 0x79, 0x64, 0xab, 0xe0,
    0x27, 0x6e, 0xf8, 0x5c, 0x28, 0x07, 0xc9, 0xb8, 0x4e, 0x85, 0x2c, 0x5d, 0x35, 0x13, 0x4d, 0x8f,
    0x29, 0x69, 0xfc, 0x8a, 0x84, 0x7b, 0x85, 0x83, 0x48, 0x26, 0xcb, 0x0d, 0x14, 0x07, 0xed, 0xce,
    0xe3, 0xe2, 0x46, 0x17, 0xc9, 0x08, 0x9e, 0x77, 0x0e, 0xcd, 0xf7, 0xe5, 0xf2, 0x70, 0x8d, 0xe6,
    0x94, 0xd7, 0x5b, 0x2b, 0x2e, 0x59, 0xfe, 0x00, 0x40, 0x36, 0xf5, 0x97, 0xac, 0x4f, 0x9e, 0xa5,
    0x55, 0xdf, 0x51, 0xdc, 0xfd, 0x58, 0x37, 0x37, 0x75, 0x8d, 0xe8, 0x7d, 0xc3, 0xb0, 0x94, 0xac,
    0xd6, 0xd0, 0x6f, 0xec, 0x84, 0xd8, 0xc3, 0xbe, 0xaa, 0x1b, 0x5c, 0xd2, 0x7f, 0xcd, 0x3d, 0xfd,
    0x69, 0x06, 0xbf, 0xcb, 0x78, 0x98, 0x49, 0xd3, 0xbc, 0x87, 0x07, 0x8f, 0xff, 0x1a, 0x0d, 0x29,
    0xaa, 0x5c, 0x04, 0x1f, 0x41, 0xd2, 0x17, 0xa3, 0x77, 0xca, 0x19, 0x12, 0xb5, 0xec, 0x66
};
#endif

PyTypeObject *init_KTwoFingerSwipeRecognizer(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX].type;

    Shiboken::AutoDecRef Sbk_KTwoFingerSwipeRecognizer_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGestureRecognizer_IDX]))));

    _Sbk_KTwoFingerSwipeRecognizer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KTwoFingerSwipeRecognizer",
        "KTwoFingerSwipeRecognizer*",
        &Sbk_KTwoFingerSwipeRecognizer_spec,
        &Shiboken::callCppDestructor< KTwoFingerSwipeRecognizer >,
        Sbk_KTwoFingerSwipeRecognizer_Type_bases.object(),
        0);
    auto *pyType = Sbk_KTwoFingerSwipeRecognizer_TypeF(); // references _Sbk_KTwoFingerSwipeRecognizer_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KTwoFingerSwipeRecognizer_SignatureStrings);
#else
    InitSignatureBytes(pyType, KTwoFingerSwipeRecognizer_SignatureBytes, KTwoFingerSwipeRecognizer_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KTwoFingerSwipeRecognizer_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KTwoFingerSwipeRecognizer_PythonToCpp_KTwoFingerSwipeRecognizer_PTR,
        is_KTwoFingerSwipeRecognizer_PythonToCpp_KTwoFingerSwipeRecognizer_PTR_Convertible,
        KTwoFingerSwipeRecognizer_PTR_CppToPython_KTwoFingerSwipeRecognizer);

    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerSwipeRecognizer");
    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerSwipeRecognizer*");
    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerSwipeRecognizer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KTwoFingerSwipeRecognizer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KTwoFingerSwipeRecognizerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KTwoFingerSwipeRecognizer_TypeF(), &Sbk_KTwoFingerSwipeRecognizer_typeDiscovery);

    qRegisterMetaType< ::KTwoFingerSwipeRecognizer *>();

    return pyType;
}
