{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A parse context is used to parse a stream of bytes that
-- you expect to contain marked-up text.
-- 
-- See 'GI.GLib.Structs.MarkupParseContext.markupParseContextNew', t'GI.GLib.Structs.MarkupParser.MarkupParser', and so
-- on for more details.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.MarkupParseContext
    ( 

-- * Exported types
    MarkupParseContext(..)                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [endParse]("GI.GLib.Structs.MarkupParseContext#g:method:endParse"), [free]("GI.GLib.Structs.MarkupParseContext#g:method:free"), [parse]("GI.GLib.Structs.MarkupParseContext#g:method:parse"), [pop]("GI.GLib.Structs.MarkupParseContext#g:method:pop"), [push]("GI.GLib.Structs.MarkupParseContext#g:method:push"), [ref]("GI.GLib.Structs.MarkupParseContext#g:method:ref"), [unref]("GI.GLib.Structs.MarkupParseContext#g:method:unref").
-- 
-- ==== Getters
-- [getElement]("GI.GLib.Structs.MarkupParseContext#g:method:getElement"), [getElementStack]("GI.GLib.Structs.MarkupParseContext#g:method:getElementStack"), [getPosition]("GI.GLib.Structs.MarkupParseContext#g:method:getPosition"), [getUserData]("GI.GLib.Structs.MarkupParseContext#g:method:getUserData").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveMarkupParseContextMethod         ,
#endif

-- ** endParse #method:endParse#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextEndParseMethodInfo    ,
#endif
    markupParseContextEndParse              ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextFreeMethodInfo        ,
#endif
    markupParseContextFree                  ,


-- ** getElement #method:getElement#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextGetElementMethodInfo  ,
#endif
    markupParseContextGetElement            ,


-- ** getElementStack #method:getElementStack#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextGetElementStackMethodInfo,
#endif
    markupParseContextGetElementStack       ,


-- ** getPosition #method:getPosition#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextGetPositionMethodInfo ,
#endif
    markupParseContextGetPosition           ,


-- ** getUserData #method:getUserData#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextGetUserDataMethodInfo ,
#endif
    markupParseContextGetUserData           ,


-- ** new #method:new#

    markupParseContextNew                   ,


-- ** parse #method:parse#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextParseMethodInfo       ,
#endif
    markupParseContextParse                 ,


-- ** pop #method:pop#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextPopMethodInfo         ,
#endif
    markupParseContextPop                   ,


-- ** push #method:push#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextPushMethodInfo        ,
#endif
    markupParseContextPush                  ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextRefMethodInfo         ,
#endif
    markupParseContextRef                   ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    MarkupParseContextUnrefMethodInfo       ,
#endif
    markupParseContextUnref                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.MarkupParser as GLib.MarkupParser

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.MarkupParser as GLib.MarkupParser

#endif

-- | Memory-managed wrapper type.
newtype MarkupParseContext = MarkupParseContext (SP.ManagedPtr MarkupParseContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype MarkupParseContext where
    toManagedPtr (MarkupParseContext p) = p

foreign import ccall "g_markup_parse_context_get_type" c_g_markup_parse_context_get_type :: 
    IO GType

type instance O.ParentTypes MarkupParseContext = '[]
instance O.HasParentTypes MarkupParseContext

instance B.Types.TypedObject MarkupParseContext where
    glibType = c_g_markup_parse_context_get_type

instance B.Types.GBoxed MarkupParseContext

-- | Convert t'MarkupParseContext' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MarkupParseContext) where
    gvalueGType_ = c_g_markup_parse_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr MarkupParseContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr MarkupParseContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed MarkupParseContext ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MarkupParseContext
type instance O.AttributeList MarkupParseContext = MarkupParseContextAttributeList
type MarkupParseContextAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method MarkupParseContext::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "parser"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MarkupParser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParser" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MarkupParseFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "one or more #GMarkupParseFlags"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to #GMarkupParser functions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data_dnotify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user data destroy notifier called when\n    the parse context is freed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GLib" , name = "MarkupParseContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_new" g_markup_parse_context_new :: 
    Ptr GLib.MarkupParser.MarkupParser ->   -- parser : TInterface (Name {namespace = "GLib", name = "MarkupParser"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "MarkupParseFlags"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- user_data_dnotify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr MarkupParseContext)

-- | Creates a new parse context. A parse context is used to parse
-- marked-up documents. You can feed any number of documents into
-- a context, as long as no errors occur; once an error occurs,
-- the parse context can\'t continue to parse text (you have to
-- free it and create a new parse context).
markupParseContextNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.MarkupParser.MarkupParser
    -- ^ /@parser@/: a t'GI.GLib.Structs.MarkupParser.MarkupParser'
    -> [GLib.Flags.MarkupParseFlags]
    -- ^ /@flags@/: one or more t'GI.GLib.Flags.MarkupParseFlags'
    -> Ptr ()
    -- ^ /@userData@/: user data to pass to t'GI.GLib.Structs.MarkupParser.MarkupParser' functions
    -> GLib.Callbacks.DestroyNotify
    -- ^ /@userDataDnotify@/: user data destroy notifier called when
    --     the parse context is freed
    -> m MarkupParseContext
    -- ^ __Returns:__ a new t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
markupParseContextNew parser flags userData userDataDnotify = liftIO $ do
    parser' <- unsafeManagedPtrGetPtr parser
    let flags' = gflagsToWord flags
    ptruserDataDnotify <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
    userDataDnotify' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptruserDataDnotify) userDataDnotify)
    poke ptruserDataDnotify userDataDnotify'
    result <- g_markup_parse_context_new parser' flags' userData userDataDnotify'
    checkUnexpectedReturnNULL "markupParseContextNew" result
    result' <- (wrapBoxed MarkupParseContext) result
    touchManagedPtr parser
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MarkupParseContext::end_parse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_markup_parse_context_end_parse" g_markup_parse_context_end_parse :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Signals to the t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext' that all data has been
-- fed into the parse context with 'GI.GLib.Structs.MarkupParseContext.markupParseContextParse'.
-- 
-- This function reports an error if the document isn\'t complete,
-- for example if elements are still open.
markupParseContextEndParse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
markupParseContextEndParse context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    onException (do
        _ <- propagateGError $ g_markup_parse_context_end_parse context'
        touchManagedPtr context
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextEndParseMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MarkupParseContextEndParseMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextEndParse

instance O.OverloadedMethodInfo MarkupParseContextEndParseMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextEndParse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextEndParse"
        })


#endif

-- method MarkupParseContext::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_free" g_markup_parse_context_free :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    IO ()

-- | Frees a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'.
-- 
-- This function can\'t be called from inside one of the
-- t'GI.GLib.Structs.MarkupParser.MarkupParser' functions or while a subparser is pushed.
markupParseContextFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> m ()
markupParseContextFree context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    g_markup_parse_context_free context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MarkupParseContextFreeMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextFree

instance O.OverloadedMethodInfo MarkupParseContextFreeMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextFree"
        })


#endif

-- method MarkupParseContext::get_element
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_get_element" g_markup_parse_context_get_element :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    IO CString

-- | Retrieves the name of the currently open element.
-- 
-- If called from the start_element or end_element handlers this will
-- give the element_name as passed to those functions. For the parent
-- elements, see 'GI.GLib.Structs.MarkupParseContext.markupParseContextGetElementStack'.
-- 
-- /Since: 2.2/
markupParseContextGetElement ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> m T.Text
    -- ^ __Returns:__ the name of the currently open element, or 'P.Nothing'
markupParseContextGetElement context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_markup_parse_context_get_element context'
    checkUnexpectedReturnNULL "markupParseContextGetElement" result
    result' <- cstringToText result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextGetElementMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod MarkupParseContextGetElementMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextGetElement

instance O.OverloadedMethodInfo MarkupParseContextGetElementMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextGetElement",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextGetElement"
        })


#endif

-- method MarkupParseContext::get_element_stack
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGSList (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_get_element_stack" g_markup_parse_context_get_element_stack :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    IO (Ptr (GSList CString))

-- | Retrieves the element stack from the internal state of the parser.
-- 
-- The returned t'GI.GLib.Structs.SList.SList' is a list of strings where the first item is
-- the currently open tag (as would be returned by
-- 'GI.GLib.Structs.MarkupParseContext.markupParseContextGetElement') and the next item is its
-- immediate parent.
-- 
-- This function is intended to be used in the start_element and
-- end_element handlers where 'GI.GLib.Structs.MarkupParseContext.markupParseContextGetElement'
-- would merely return the name of the element that is being
-- processed.
-- 
-- /Since: 2.16/
markupParseContextGetElementStack ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> m [T.Text]
    -- ^ __Returns:__ the element stack, which must not be modified
markupParseContextGetElementStack context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_markup_parse_context_get_element_stack context'
    result' <- unpackGSList result
    result'' <- mapM cstringToText result'
    touchManagedPtr context
    return result''

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextGetElementStackMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m) => O.OverloadedMethod MarkupParseContextGetElementStackMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextGetElementStack

instance O.OverloadedMethodInfo MarkupParseContextGetElementStackMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextGetElementStack",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextGetElementStack"
        })


#endif

-- method MarkupParseContext::get_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line_number"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a line number, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "char_number"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for a char-on-line number, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_get_position" g_markup_parse_context_get_position :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    Ptr Int32 ->                            -- line_number : TBasicType TInt
    Ptr Int32 ->                            -- char_number : TBasicType TInt
    IO ()

-- | Retrieves the current line number and the number of the character on
-- that line. Intended for use in error messages; there are no strict
-- semantics for what constitutes the \"current\" line number other than
-- \"the best number we could come up with for error messages.\"
markupParseContextGetPosition ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> m ((Int32, Int32))
markupParseContextGetPosition context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    lineNumber <- allocMem :: IO (Ptr Int32)
    charNumber <- allocMem :: IO (Ptr Int32)
    g_markup_parse_context_get_position context' lineNumber charNumber
    lineNumber' <- peek lineNumber
    charNumber' <- peek charNumber
    touchManagedPtr context
    freeMem lineNumber
    freeMem charNumber
    return (lineNumber', charNumber')

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextGetPositionMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m) => O.OverloadedMethod MarkupParseContextGetPositionMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextGetPosition

instance O.OverloadedMethodInfo MarkupParseContextGetPositionMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextGetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextGetPosition"
        })


#endif

-- method MarkupParseContext::get_user_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_get_user_data" g_markup_parse_context_get_user_data :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    IO (Ptr ())

-- | Returns the user_data associated with /@context@/.
-- 
-- This will either be the user_data that was provided to
-- 'GI.GLib.Structs.MarkupParseContext.markupParseContextNew' or to the most recent call
-- of 'GI.GLib.Structs.MarkupParseContext.markupParseContextPush'.
-- 
-- /Since: 2.18/
markupParseContextGetUserData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> m (Ptr ())
    -- ^ __Returns:__ the provided user_data. The returned data belongs to
    --     the markup context and will be freed when
    --     'GI.GLib.Structs.MarkupParseContext.markupParseContextFree' is called.
markupParseContextGetUserData context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_markup_parse_context_get_user_data context'
    touchManagedPtr context
    return result

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextGetUserDataMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod MarkupParseContextGetUserDataMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextGetUserData

instance O.OverloadedMethodInfo MarkupParseContextGetUserDataMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextGetUserData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextGetUserData"
        })


#endif

-- method MarkupParseContext::parse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "chunk of text to parse"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text_len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of @text in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_markup_parse_context_parse" g_markup_parse_context_parse :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    CString ->                              -- text : TBasicType TUTF8
    DI.Int64 ->                             -- text_len : TBasicType TSSize
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Feed some data to the t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'.
-- 
-- The data need not be valid UTF-8; an error will be signaled if
-- it\'s invalid. The data need not be an entire document; you can
-- feed a document into the parser incrementally, via multiple calls
-- to this function. Typically, as you receive data from a network
-- connection or file, you feed each received chunk of data into this
-- function, aborting the process if an error occurs. Once an error
-- is reported, no further data may be fed to the t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext';
-- all errors are fatal.
markupParseContextParse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> T.Text
    -- ^ /@text@/: chunk of text to parse
    -> DI.Int64
    -- ^ /@textLen@/: length of /@text@/ in bytes
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
markupParseContextParse context text textLen = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    text' <- textToCString text
    onException (do
        _ <- propagateGError $ g_markup_parse_context_parse context' text' textLen
        touchManagedPtr context
        freeMem text'
        return ()
     ) (do
        freeMem text'
     )

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextParseMethodInfo
instance (signature ~ (T.Text -> DI.Int64 -> m ()), MonadIO m) => O.OverloadedMethod MarkupParseContextParseMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextParse

instance O.OverloadedMethodInfo MarkupParseContextParseMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextParse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextParse"
        })


#endif

-- method MarkupParseContext::pop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_pop" g_markup_parse_context_pop :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    IO (Ptr ())

-- | Completes the process of a temporary sub-parser redirection.
-- 
-- This function exists to collect the user_data allocated by a
-- matching call to 'GI.GLib.Structs.MarkupParseContext.markupParseContextPush'. It must be called
-- in the end_element handler corresponding to the start_element
-- handler during which 'GI.GLib.Structs.MarkupParseContext.markupParseContextPush' was called.
-- You must not call this function from the error callback -- the
-- /@userData@/ is provided directly to the callback in that case.
-- 
-- This function is not intended to be directly called by users
-- interested in invoking subparsers. Instead, it is intended to
-- be used by the subparsers themselves to implement a higher-level
-- interface.
-- 
-- /Since: 2.18/
markupParseContextPop ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> m (Ptr ())
    -- ^ __Returns:__ the user data passed to 'GI.GLib.Structs.MarkupParseContext.markupParseContextPush'
markupParseContextPop context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_markup_parse_context_pop context'
    touchManagedPtr context
    return result

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextPopMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod MarkupParseContextPopMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextPop

instance O.OverloadedMethodInfo MarkupParseContextPopMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextPop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextPop"
        })


#endif

-- method MarkupParseContext::push
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parser"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MarkupParser" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParser" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to #GMarkupParser functions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_push" g_markup_parse_context_push :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    Ptr GLib.MarkupParser.MarkupParser ->   -- parser : TInterface (Name {namespace = "GLib", name = "MarkupParser"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Temporarily redirects markup data to a sub-parser.
-- 
-- This function may only be called from the start_element handler of
-- a t'GI.GLib.Structs.MarkupParser.MarkupParser'. It must be matched with a corresponding call to
-- 'GI.GLib.Structs.MarkupParseContext.markupParseContextPop' in the matching end_element handler
-- (except in the case that the parser aborts due to an error).
-- 
-- All tags, text and other data between the matching tags is
-- redirected to the subparser given by /@parser@/. /@userData@/ is used
-- as the user_data for that parser. /@userData@/ is also passed to the
-- error callback in the event that an error occurs. This includes
-- errors that occur in subparsers of the subparser.
-- 
-- The end tag matching the start tag for which this call was made is
-- handled by the previous parser (which is given its own user_data)
-- which is why 'GI.GLib.Structs.MarkupParseContext.markupParseContextPop' is provided to allow \"one
-- last access\" to the /@userData@/ provided to this function. In the
-- case of error, the /@userData@/ provided here is passed directly to
-- the error callback of the subparser and 'GI.GLib.Structs.MarkupParseContext.markupParseContextPop'
-- should not be called. In either case, if /@userData@/ was allocated
-- then it ought to be freed from both of these locations.
-- 
-- This function is not intended to be directly called by users
-- interested in invoking subparsers. Instead, it is intended to be
-- used by the subparsers themselves to implement a higher-level
-- interface.
-- 
-- As an example, see the following implementation of a simple
-- parser that counts the number of tags encountered.
-- 
-- 
-- === /C code/
-- >
-- >typedef struct
-- >{
-- >  gint tag_count;
-- >} CounterData;
-- >
-- >static void
-- >counter_start_element (GMarkupParseContext  *context,
-- >                       const gchar          *element_name,
-- >                       const gchar         **attribute_names,
-- >                       const gchar         **attribute_values,
-- >                       gpointer              user_data,
-- >                       GError              **error)
-- >{
-- >  CounterData *data = user_data;
-- >
-- >  data->tag_count++;
-- >}
-- >
-- >static void
-- >counter_error (GMarkupParseContext *context,
-- >               GError              *error,
-- >               gpointer             user_data)
-- >{
-- >  CounterData *data = user_data;
-- >
-- >  g_slice_free (CounterData, data);
-- >}
-- >
-- >static GMarkupParser counter_subparser =
-- >{
-- >  counter_start_element,
-- >  NULL,
-- >  NULL,
-- >  NULL,
-- >  counter_error
-- >};
-- 
-- 
-- In order to allow this parser to be easily used as a subparser, the
-- following interface is provided:
-- 
-- 
-- === /C code/
-- >
-- >void
-- >start_counting (GMarkupParseContext *context)
-- >{
-- >  CounterData *data = g_slice_new (CounterData);
-- >
-- >  data->tag_count = 0;
-- >  g_markup_parse_context_push (context, &counter_subparser, data);
-- >}
-- >
-- >gint
-- >end_counting (GMarkupParseContext *context)
-- >{
-- >  CounterData *data = g_markup_parse_context_pop (context);
-- >  int result;
-- >
-- >  result = data->tag_count;
-- >  g_slice_free (CounterData, data);
-- >
-- >  return result;
-- >}
-- 
-- 
-- The subparser would then be used as follows:
-- 
-- 
-- === /C code/
-- >
-- >static void start_element (context, element_name, ...)
-- >{
-- >  if (strcmp (element_name, "count-these") == 0)
-- >    start_counting (context);
-- >
-- >  // else, handle other tags...
-- >}
-- >
-- >static void end_element (context, element_name, ...)
-- >{
-- >  if (strcmp (element_name, "count-these") == 0)
-- >    g_print ("Counted %d tags\n", end_counting (context));
-- >
-- >  // else, handle other tags...
-- >}
-- 
-- 
-- /Since: 2.18/
markupParseContextPush ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> GLib.MarkupParser.MarkupParser
    -- ^ /@parser@/: a t'GI.GLib.Structs.MarkupParser.MarkupParser'
    -> Ptr ()
    -- ^ /@userData@/: user data to pass to t'GI.GLib.Structs.MarkupParser.MarkupParser' functions
    -> m ()
markupParseContextPush context parser userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    parser' <- unsafeManagedPtrGetPtr parser
    g_markup_parse_context_push context' parser' userData
    touchManagedPtr context
    touchManagedPtr parser
    return ()

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextPushMethodInfo
instance (signature ~ (GLib.MarkupParser.MarkupParser -> Ptr () -> m ()), MonadIO m) => O.OverloadedMethod MarkupParseContextPushMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextPush

instance O.OverloadedMethodInfo MarkupParseContextPushMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextPush",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextPush"
        })


#endif

-- method MarkupParseContext::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GLib" , name = "MarkupParseContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_ref" g_markup_parse_context_ref :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    IO (Ptr MarkupParseContext)

-- | Increases the reference count of /@context@/.
-- 
-- /Since: 2.36/
markupParseContextRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> m MarkupParseContext
    -- ^ __Returns:__ the same /@context@/
markupParseContextRef context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_markup_parse_context_ref context'
    checkUnexpectedReturnNULL "markupParseContextRef" result
    result' <- (wrapBoxed MarkupParseContext) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextRefMethodInfo
instance (signature ~ (m MarkupParseContext), MonadIO m) => O.OverloadedMethod MarkupParseContextRefMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextRef

instance O.OverloadedMethodInfo MarkupParseContextRefMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextRef"
        })


#endif

-- method MarkupParseContext::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMarkupParseContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_parse_context_unref" g_markup_parse_context_unref :: 
    Ptr MarkupParseContext ->               -- context : TInterface (Name {namespace = "GLib", name = "MarkupParseContext"})
    IO ()

-- | Decreases the reference count of /@context@/.  When its reference count
-- drops to 0, it is freed.
-- 
-- /Since: 2.36/
markupParseContextUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MarkupParseContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MarkupParseContext.MarkupParseContext'
    -> m ()
markupParseContextUnref context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    g_markup_parse_context_unref context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data MarkupParseContextUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MarkupParseContextUnrefMethodInfo MarkupParseContext signature where
    overloadedMethod = markupParseContextUnref

instance O.OverloadedMethodInfo MarkupParseContextUnrefMethodInfo MarkupParseContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParseContext.markupParseContextUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-MarkupParseContext.html#v:markupParseContextUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMarkupParseContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMarkupParseContextMethod "endParse" o = MarkupParseContextEndParseMethodInfo
    ResolveMarkupParseContextMethod "free" o = MarkupParseContextFreeMethodInfo
    ResolveMarkupParseContextMethod "parse" o = MarkupParseContextParseMethodInfo
    ResolveMarkupParseContextMethod "pop" o = MarkupParseContextPopMethodInfo
    ResolveMarkupParseContextMethod "push" o = MarkupParseContextPushMethodInfo
    ResolveMarkupParseContextMethod "ref" o = MarkupParseContextRefMethodInfo
    ResolveMarkupParseContextMethod "unref" o = MarkupParseContextUnrefMethodInfo
    ResolveMarkupParseContextMethod "getElement" o = MarkupParseContextGetElementMethodInfo
    ResolveMarkupParseContextMethod "getElementStack" o = MarkupParseContextGetElementStackMethodInfo
    ResolveMarkupParseContextMethod "getPosition" o = MarkupParseContextGetPositionMethodInfo
    ResolveMarkupParseContextMethod "getUserData" o = MarkupParseContextGetUserDataMethodInfo
    ResolveMarkupParseContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMarkupParseContextMethod t MarkupParseContext, O.OverloadedMethod info MarkupParseContext p) => OL.IsLabel t (MarkupParseContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMarkupParseContextMethod t MarkupParseContext, O.OverloadedMethod info MarkupParseContext p, R.HasField t MarkupParseContext p) => R.HasField t MarkupParseContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMarkupParseContextMethod t MarkupParseContext, O.OverloadedMethodInfo info MarkupParseContext) => OL.IsLabel t (O.MethodProxy info MarkupParseContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


