{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GSimpleProxyResolver@ is a simple t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver' implementation
-- that handles a single default proxy, multiple URI-scheme-specific
-- proxies, and a list of hosts that proxies should not be used for.
-- 
-- @GSimpleProxyResolver@ is never the default proxy resolver, but it
-- can be used as the base class for another proxy resolver
-- implementation, or it can be created and used manually, such as
-- with 'GI.Gio.Objects.SocketClient.socketClientSetProxyResolver'.
-- 
-- /Since: 2.36/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SimpleProxyResolver
    ( 

-- * Exported types
    SimpleProxyResolver(..)                 ,
    IsSimpleProxyResolver                   ,
    toSimpleProxyResolver                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isSupported]("GI.Gio.Interfaces.ProxyResolver#g:method:isSupported"), [lookup]("GI.Gio.Interfaces.ProxyResolver#g:method:lookup"), [lookupAsync]("GI.Gio.Interfaces.ProxyResolver#g:method:lookupAsync"), [lookupFinish]("GI.Gio.Interfaces.ProxyResolver#g:method:lookupFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultProxy]("GI.Gio.Objects.SimpleProxyResolver#g:method:setDefaultProxy"), [setIgnoreHosts]("GI.Gio.Objects.SimpleProxyResolver#g:method:setIgnoreHosts"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setUriProxy]("GI.Gio.Objects.SimpleProxyResolver#g:method:setUriProxy").

#if defined(ENABLE_OVERLOADING)
    ResolveSimpleProxyResolverMethod        ,
#endif

-- ** new #method:new#

    simpleProxyResolverNew                  ,


-- ** setDefaultProxy #method:setDefaultProxy#

#if defined(ENABLE_OVERLOADING)
    SimpleProxyResolverSetDefaultProxyMethodInfo,
#endif
    simpleProxyResolverSetDefaultProxy      ,


-- ** setIgnoreHosts #method:setIgnoreHosts#

#if defined(ENABLE_OVERLOADING)
    SimpleProxyResolverSetIgnoreHostsMethodInfo,
#endif
    simpleProxyResolverSetIgnoreHosts       ,


-- ** setUriProxy #method:setUriProxy#

#if defined(ENABLE_OVERLOADING)
    SimpleProxyResolverSetUriProxyMethodInfo,
#endif
    simpleProxyResolverSetUriProxy          ,




 -- * Properties


-- ** defaultProxy #attr:defaultProxy#
-- | The default proxy URI that will be used for any URI that doesn\'t
-- match [SimpleProxyResolver:ignoreHosts]("GI.Gio.Objects.SimpleProxyResolver#g:attr:ignoreHosts"), and doesn\'t match any
-- of the schemes set with 'GI.Gio.Objects.SimpleProxyResolver.simpleProxyResolverSetUriProxy'.
-- 
-- Note that as a special case, if this URI starts with
-- \"socks:\/\/\", t'GI.Gio.Objects.SimpleProxyResolver.SimpleProxyResolver' will treat it as referring
-- to all three of the socks5, socks4a, and socks4 proxy types.

#if defined(ENABLE_OVERLOADING)
    SimpleProxyResolverDefaultProxyPropertyInfo,
#endif
    clearSimpleProxyResolverDefaultProxy    ,
    constructSimpleProxyResolverDefaultProxy,
    getSimpleProxyResolverDefaultProxy      ,
    setSimpleProxyResolverDefaultProxy      ,
#if defined(ENABLE_OVERLOADING)
    simpleProxyResolverDefaultProxy         ,
#endif


-- ** ignoreHosts #attr:ignoreHosts#
-- | A list of hostnames and IP addresses that the resolver should
-- allow direct connections to.
-- 
-- Entries can be in one of 4 formats:
-- 
-- * A hostname, such as \"example.com\", \".example.com\", or
--   \"*.example.com\", any of which match \"example.com\" or
--   any subdomain of it.
-- * An IPv4 or IPv6 address, such as \"192.168.1.1\",
--   which matches only that address.
-- * A hostname or IP address followed by a port, such as
--   \"example.com:80\", which matches whatever the hostname or IP
--   address would match, but only for URLs with the (explicitly)
--   indicated port. In the case of an IPv6 address, the address
--   part must appear in brackets: \"[[1](#g:signal:1)]:443\"
-- * An IP address range, given by a base address and prefix length,
--   such as \"fe80::\/10\", which matches any address in that range.
-- 
-- 
-- Note that when dealing with Unicode hostnames, the matching is
-- done against the ASCII form of the name.
-- 
-- Also note that hostname exclusions apply only to connections made
-- to hosts identified by name, and IP address exclusions apply only
-- to connections made to hosts identified by address. That is, if
-- example.com has an address of 192.168.1.1, and the :ignore-hosts list
-- contains only \"192.168.1.1\", then a connection to \"example.com\"
-- (eg, via a t'GI.Gio.Objects.NetworkAddress.NetworkAddress') will use the proxy, and a connection to
-- \"192.168.1.1\" (eg, via a t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress') will not.
-- 
-- These rules match the \"ignore-hosts\"\/\"noproxy\" rules most
-- commonly used by other applications.

#if defined(ENABLE_OVERLOADING)
    SimpleProxyResolverIgnoreHostsPropertyInfo,
#endif
    constructSimpleProxyResolverIgnoreHosts ,
    getSimpleProxyResolverIgnoreHosts       ,
    setSimpleProxyResolverIgnoreHosts       ,
#if defined(ENABLE_OVERLOADING)
    simpleProxyResolverIgnoreHosts          ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ProxyResolver as Gio.ProxyResolver
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ProxyResolver as Gio.ProxyResolver

#endif

-- | Memory-managed wrapper type.
newtype SimpleProxyResolver = SimpleProxyResolver (SP.ManagedPtr SimpleProxyResolver)
    deriving (Eq)

instance SP.ManagedPtrNewtype SimpleProxyResolver where
    toManagedPtr (SimpleProxyResolver p) = p

foreign import ccall "g_simple_proxy_resolver_get_type"
    c_g_simple_proxy_resolver_get_type :: IO B.Types.GType

instance B.Types.TypedObject SimpleProxyResolver where
    glibType = c_g_simple_proxy_resolver_get_type

instance B.Types.GObject SimpleProxyResolver

-- | Type class for types which can be safely cast to t'SimpleProxyResolver', for instance with `toSimpleProxyResolver`.
class (SP.GObject o, O.IsDescendantOf SimpleProxyResolver o) => IsSimpleProxyResolver o
instance (SP.GObject o, O.IsDescendantOf SimpleProxyResolver o) => IsSimpleProxyResolver o

instance O.HasParentTypes SimpleProxyResolver
type instance O.ParentTypes SimpleProxyResolver = '[GObject.Object.Object, Gio.ProxyResolver.ProxyResolver]

-- | Cast to t'SimpleProxyResolver', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSimpleProxyResolver :: (MIO.MonadIO m, IsSimpleProxyResolver o) => o -> m SimpleProxyResolver
toSimpleProxyResolver = MIO.liftIO . B.ManagedPtr.unsafeCastTo SimpleProxyResolver

-- | Convert t'SimpleProxyResolver' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SimpleProxyResolver) where
    gvalueGType_ = c_g_simple_proxy_resolver_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SimpleProxyResolver)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SimpleProxyResolver)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SimpleProxyResolver ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSimpleProxyResolverMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSimpleProxyResolverMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSimpleProxyResolverMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSimpleProxyResolverMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSimpleProxyResolverMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSimpleProxyResolverMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSimpleProxyResolverMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSimpleProxyResolverMethod "isSupported" o = Gio.ProxyResolver.ProxyResolverIsSupportedMethodInfo
    ResolveSimpleProxyResolverMethod "lookup" o = Gio.ProxyResolver.ProxyResolverLookupMethodInfo
    ResolveSimpleProxyResolverMethod "lookupAsync" o = Gio.ProxyResolver.ProxyResolverLookupAsyncMethodInfo
    ResolveSimpleProxyResolverMethod "lookupFinish" o = Gio.ProxyResolver.ProxyResolverLookupFinishMethodInfo
    ResolveSimpleProxyResolverMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSimpleProxyResolverMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSimpleProxyResolverMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSimpleProxyResolverMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSimpleProxyResolverMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSimpleProxyResolverMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSimpleProxyResolverMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSimpleProxyResolverMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSimpleProxyResolverMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSimpleProxyResolverMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSimpleProxyResolverMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSimpleProxyResolverMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSimpleProxyResolverMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSimpleProxyResolverMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSimpleProxyResolverMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSimpleProxyResolverMethod "setDefaultProxy" o = SimpleProxyResolverSetDefaultProxyMethodInfo
    ResolveSimpleProxyResolverMethod "setIgnoreHosts" o = SimpleProxyResolverSetIgnoreHostsMethodInfo
    ResolveSimpleProxyResolverMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSimpleProxyResolverMethod "setUriProxy" o = SimpleProxyResolverSetUriProxyMethodInfo
    ResolveSimpleProxyResolverMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSimpleProxyResolverMethod t SimpleProxyResolver, O.OverloadedMethod info SimpleProxyResolver p) => OL.IsLabel t (SimpleProxyResolver -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSimpleProxyResolverMethod t SimpleProxyResolver, O.OverloadedMethod info SimpleProxyResolver p, R.HasField t SimpleProxyResolver p) => R.HasField t SimpleProxyResolver p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSimpleProxyResolverMethod t SimpleProxyResolver, O.OverloadedMethodInfo info SimpleProxyResolver) => OL.IsLabel t (O.MethodProxy info SimpleProxyResolver) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "default-proxy"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@default-proxy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' simpleProxyResolver #defaultProxy
-- @
getSimpleProxyResolverDefaultProxy :: (MonadIO m, IsSimpleProxyResolver o) => o -> m (Maybe T.Text)
getSimpleProxyResolverDefaultProxy obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "default-proxy"

-- | Set the value of the “@default-proxy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' simpleProxyResolver [ #defaultProxy 'Data.GI.Base.Attributes.:=' value ]
-- @
setSimpleProxyResolverDefaultProxy :: (MonadIO m, IsSimpleProxyResolver o) => o -> T.Text -> m ()
setSimpleProxyResolverDefaultProxy obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "default-proxy" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@default-proxy@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSimpleProxyResolverDefaultProxy :: (IsSimpleProxyResolver o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructSimpleProxyResolverDefaultProxy val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "default-proxy" (P.Just val)

-- | Set the value of the “@default-proxy@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #defaultProxy
-- @
clearSimpleProxyResolverDefaultProxy :: (MonadIO m, IsSimpleProxyResolver o) => o -> m ()
clearSimpleProxyResolverDefaultProxy obj = liftIO $ B.Properties.setObjectPropertyString obj "default-proxy" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data SimpleProxyResolverDefaultProxyPropertyInfo
instance AttrInfo SimpleProxyResolverDefaultProxyPropertyInfo where
    type AttrAllowedOps SimpleProxyResolverDefaultProxyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SimpleProxyResolverDefaultProxyPropertyInfo = IsSimpleProxyResolver
    type AttrSetTypeConstraint SimpleProxyResolverDefaultProxyPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint SimpleProxyResolverDefaultProxyPropertyInfo = (~) T.Text
    type AttrTransferType SimpleProxyResolverDefaultProxyPropertyInfo = T.Text
    type AttrGetType SimpleProxyResolverDefaultProxyPropertyInfo = (Maybe T.Text)
    type AttrLabel SimpleProxyResolverDefaultProxyPropertyInfo = "default-proxy"
    type AttrOrigin SimpleProxyResolverDefaultProxyPropertyInfo = SimpleProxyResolver
    attrGet = getSimpleProxyResolverDefaultProxy
    attrSet = setSimpleProxyResolverDefaultProxy
    attrTransfer _ v = do
        return v
    attrConstruct = constructSimpleProxyResolverDefaultProxy
    attrClear = clearSimpleProxyResolverDefaultProxy
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleProxyResolver.defaultProxy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleProxyResolver.html#g:attr:defaultProxy"
        })
#endif

-- VVV Prop "ignore-hosts"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@ignore-hosts@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' simpleProxyResolver #ignoreHosts
-- @
getSimpleProxyResolverIgnoreHosts :: (MonadIO m, IsSimpleProxyResolver o) => o -> m (Maybe [T.Text])
getSimpleProxyResolverIgnoreHosts obj = MIO.liftIO $ B.Properties.getObjectPropertyStringArray obj "ignore-hosts"

-- | Set the value of the “@ignore-hosts@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' simpleProxyResolver [ #ignoreHosts 'Data.GI.Base.Attributes.:=' value ]
-- @
setSimpleProxyResolverIgnoreHosts :: (MonadIO m, IsSimpleProxyResolver o) => o -> [T.Text] -> m ()
setSimpleProxyResolverIgnoreHosts obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyStringArray obj "ignore-hosts" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@ignore-hosts@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSimpleProxyResolverIgnoreHosts :: (IsSimpleProxyResolver o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructSimpleProxyResolverIgnoreHosts val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "ignore-hosts" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data SimpleProxyResolverIgnoreHostsPropertyInfo
instance AttrInfo SimpleProxyResolverIgnoreHostsPropertyInfo where
    type AttrAllowedOps SimpleProxyResolverIgnoreHostsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SimpleProxyResolverIgnoreHostsPropertyInfo = IsSimpleProxyResolver
    type AttrSetTypeConstraint SimpleProxyResolverIgnoreHostsPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint SimpleProxyResolverIgnoreHostsPropertyInfo = (~) [T.Text]
    type AttrTransferType SimpleProxyResolverIgnoreHostsPropertyInfo = [T.Text]
    type AttrGetType SimpleProxyResolverIgnoreHostsPropertyInfo = (Maybe [T.Text])
    type AttrLabel SimpleProxyResolverIgnoreHostsPropertyInfo = "ignore-hosts"
    type AttrOrigin SimpleProxyResolverIgnoreHostsPropertyInfo = SimpleProxyResolver
    attrGet = getSimpleProxyResolverIgnoreHosts
    attrSet = setSimpleProxyResolverIgnoreHosts
    attrTransfer _ v = do
        return v
    attrConstruct = constructSimpleProxyResolverIgnoreHosts
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleProxyResolver.ignoreHosts"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleProxyResolver.html#g:attr:ignoreHosts"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SimpleProxyResolver
type instance O.AttributeList SimpleProxyResolver = SimpleProxyResolverAttributeList
type SimpleProxyResolverAttributeList = ('[ '("defaultProxy", SimpleProxyResolverDefaultProxyPropertyInfo), '("ignoreHosts", SimpleProxyResolverIgnoreHostsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
simpleProxyResolverDefaultProxy :: AttrLabelProxy "defaultProxy"
simpleProxyResolverDefaultProxy = AttrLabelProxy

simpleProxyResolverIgnoreHosts :: AttrLabelProxy "ignoreHosts"
simpleProxyResolverIgnoreHosts = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SimpleProxyResolver = SimpleProxyResolverSignalList
type SimpleProxyResolverSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SimpleProxyResolver::set_default_proxy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "resolver"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SimpleProxyResolver" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleProxyResolver"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_proxy"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the default proxy to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_proxy_resolver_set_default_proxy" g_simple_proxy_resolver_set_default_proxy :: 
    Ptr SimpleProxyResolver ->              -- resolver : TInterface (Name {namespace = "Gio", name = "SimpleProxyResolver"})
    CString ->                              -- default_proxy : TBasicType TUTF8
    IO ()

-- | Sets the default proxy on /@resolver@/, to be used for any URIs that
-- don\'t match [SimpleProxyResolver:ignoreHosts]("GI.Gio.Objects.SimpleProxyResolver#g:attr:ignoreHosts") or a proxy set
-- via 'GI.Gio.Objects.SimpleProxyResolver.simpleProxyResolverSetUriProxy'.
-- 
-- If /@defaultProxy@/ starts with \"socks:\/\/\",
-- t'GI.Gio.Objects.SimpleProxyResolver.SimpleProxyResolver' will treat it as referring to all three of
-- the socks5, socks4a, and socks4 proxy types.
-- 
-- /Since: 2.36/
simpleProxyResolverSetDefaultProxy ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleProxyResolver a) =>
    a
    -- ^ /@resolver@/: a t'GI.Gio.Objects.SimpleProxyResolver.SimpleProxyResolver'
    -> Maybe (T.Text)
    -- ^ /@defaultProxy@/: the default proxy to use
    -> m ()
simpleProxyResolverSetDefaultProxy resolver defaultProxy = liftIO $ do
    resolver' <- unsafeManagedPtrCastPtr resolver
    maybeDefaultProxy <- case defaultProxy of
        Nothing -> return FP.nullPtr
        Just jDefaultProxy -> do
            jDefaultProxy' <- textToCString jDefaultProxy
            return jDefaultProxy'
    g_simple_proxy_resolver_set_default_proxy resolver' maybeDefaultProxy
    touchManagedPtr resolver
    freeMem maybeDefaultProxy
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleProxyResolverSetDefaultProxyMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsSimpleProxyResolver a) => O.OverloadedMethod SimpleProxyResolverSetDefaultProxyMethodInfo a signature where
    overloadedMethod = simpleProxyResolverSetDefaultProxy

instance O.OverloadedMethodInfo SimpleProxyResolverSetDefaultProxyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleProxyResolver.simpleProxyResolverSetDefaultProxy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleProxyResolver.html#v:simpleProxyResolverSetDefaultProxy"
        })


#endif

-- method SimpleProxyResolver::set_ignore_hosts
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "resolver"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SimpleProxyResolver" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleProxyResolver"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ignore_hosts"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%NULL-terminated list of hosts/IP addresses\n    to not use a proxy for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_proxy_resolver_set_ignore_hosts" g_simple_proxy_resolver_set_ignore_hosts :: 
    Ptr SimpleProxyResolver ->              -- resolver : TInterface (Name {namespace = "Gio", name = "SimpleProxyResolver"})
    Ptr CString ->                          -- ignore_hosts : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Sets the list of ignored hosts.
-- 
-- See [SimpleProxyResolver:ignoreHosts]("GI.Gio.Objects.SimpleProxyResolver#g:attr:ignoreHosts") for more details on how the
-- /@ignoreHosts@/ argument is interpreted.
-- 
-- /Since: 2.36/
simpleProxyResolverSetIgnoreHosts ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleProxyResolver a) =>
    a
    -- ^ /@resolver@/: a t'GI.Gio.Objects.SimpleProxyResolver.SimpleProxyResolver'
    -> [T.Text]
    -- ^ /@ignoreHosts@/: 'P.Nothing'-terminated list of hosts\/IP addresses
    --     to not use a proxy for
    -> m ()
simpleProxyResolverSetIgnoreHosts resolver ignoreHosts = liftIO $ do
    resolver' <- unsafeManagedPtrCastPtr resolver
    ignoreHosts' <- packZeroTerminatedUTF8CArray ignoreHosts
    g_simple_proxy_resolver_set_ignore_hosts resolver' ignoreHosts'
    touchManagedPtr resolver
    mapZeroTerminatedCArray freeMem ignoreHosts'
    freeMem ignoreHosts'
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleProxyResolverSetIgnoreHostsMethodInfo
instance (signature ~ ([T.Text] -> m ()), MonadIO m, IsSimpleProxyResolver a) => O.OverloadedMethod SimpleProxyResolverSetIgnoreHostsMethodInfo a signature where
    overloadedMethod = simpleProxyResolverSetIgnoreHosts

instance O.OverloadedMethodInfo SimpleProxyResolverSetIgnoreHostsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleProxyResolver.simpleProxyResolverSetIgnoreHosts",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleProxyResolver.html#v:simpleProxyResolverSetIgnoreHosts"
        })


#endif

-- method SimpleProxyResolver::set_uri_proxy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "resolver"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SimpleProxyResolver" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleProxyResolver"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri_scheme"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the URI scheme to add a proxy for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "proxy"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the proxy to use for @uri_scheme"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_proxy_resolver_set_uri_proxy" g_simple_proxy_resolver_set_uri_proxy :: 
    Ptr SimpleProxyResolver ->              -- resolver : TInterface (Name {namespace = "Gio", name = "SimpleProxyResolver"})
    CString ->                              -- uri_scheme : TBasicType TUTF8
    CString ->                              -- proxy : TBasicType TUTF8
    IO ()

-- | Adds a URI-scheme-specific proxy to /@resolver@/; URIs whose scheme
-- matches /@uriScheme@/ (and which don\'t match
-- [SimpleProxyResolver:ignoreHosts]("GI.Gio.Objects.SimpleProxyResolver#g:attr:ignoreHosts")) will be proxied via /@proxy@/.
-- 
-- As with [SimpleProxyResolver:defaultProxy]("GI.Gio.Objects.SimpleProxyResolver#g:attr:defaultProxy"), if /@proxy@/ starts with
-- \"socks:\/\/\", t'GI.Gio.Objects.SimpleProxyResolver.SimpleProxyResolver' will treat it
-- as referring to all three of the socks5, socks4a, and socks4 proxy
-- types.
-- 
-- /Since: 2.36/
simpleProxyResolverSetUriProxy ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleProxyResolver a) =>
    a
    -- ^ /@resolver@/: a t'GI.Gio.Objects.SimpleProxyResolver.SimpleProxyResolver'
    -> T.Text
    -- ^ /@uriScheme@/: the URI scheme to add a proxy for
    -> T.Text
    -- ^ /@proxy@/: the proxy to use for /@uriScheme@/
    -> m ()
simpleProxyResolverSetUriProxy resolver uriScheme proxy = liftIO $ do
    resolver' <- unsafeManagedPtrCastPtr resolver
    uriScheme' <- textToCString uriScheme
    proxy' <- textToCString proxy
    g_simple_proxy_resolver_set_uri_proxy resolver' uriScheme' proxy'
    touchManagedPtr resolver
    freeMem uriScheme'
    freeMem proxy'
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleProxyResolverSetUriProxyMethodInfo
instance (signature ~ (T.Text -> T.Text -> m ()), MonadIO m, IsSimpleProxyResolver a) => O.OverloadedMethod SimpleProxyResolverSetUriProxyMethodInfo a signature where
    overloadedMethod = simpleProxyResolverSetUriProxy

instance O.OverloadedMethodInfo SimpleProxyResolverSetUriProxyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleProxyResolver.simpleProxyResolverSetUriProxy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleProxyResolver.html#v:simpleProxyResolverSetUriProxy"
        })


#endif

-- method SimpleProxyResolver::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "default_proxy"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the default proxy to use, eg\n    \"socks://192.168.1.1\""
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ignore_hosts"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an optional list of hosts/IP addresses\n    to not use a proxy for."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "ProxyResolver" })
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_proxy_resolver_new" g_simple_proxy_resolver_new :: 
    CString ->                              -- default_proxy : TBasicType TUTF8
    Ptr CString ->                          -- ignore_hosts : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO (Ptr Gio.ProxyResolver.ProxyResolver)

-- | Creates a new t'GI.Gio.Objects.SimpleProxyResolver.SimpleProxyResolver'. See
-- [SimpleProxyResolver:defaultProxy]("GI.Gio.Objects.SimpleProxyResolver#g:attr:defaultProxy") and
-- [SimpleProxyResolver:ignoreHosts]("GI.Gio.Objects.SimpleProxyResolver#g:attr:ignoreHosts") for more details on how the
-- arguments are interpreted.
-- 
-- /Since: 2.36/
simpleProxyResolverNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@defaultProxy@/: the default proxy to use, eg
    --     \"socks:\/\/192.168.1.1\"
    -> Maybe ([T.Text])
    -- ^ /@ignoreHosts@/: an optional list of hosts\/IP addresses
    --     to not use a proxy for.
    -> m Gio.ProxyResolver.ProxyResolver
    -- ^ __Returns:__ a new t'GI.Gio.Objects.SimpleProxyResolver.SimpleProxyResolver'
simpleProxyResolverNew defaultProxy ignoreHosts = liftIO $ do
    maybeDefaultProxy <- case defaultProxy of
        Nothing -> return FP.nullPtr
        Just jDefaultProxy -> do
            jDefaultProxy' <- textToCString jDefaultProxy
            return jDefaultProxy'
    maybeIgnoreHosts <- case ignoreHosts of
        Nothing -> return FP.nullPtr
        Just jIgnoreHosts -> do
            jIgnoreHosts' <- packZeroTerminatedUTF8CArray jIgnoreHosts
            return jIgnoreHosts'
    result <- g_simple_proxy_resolver_new maybeDefaultProxy maybeIgnoreHosts
    checkUnexpectedReturnNULL "simpleProxyResolverNew" result
    result' <- (wrapObject Gio.ProxyResolver.ProxyResolver) result
    freeMem maybeDefaultProxy
    mapZeroTerminatedCArray freeMem maybeIgnoreHosts
    freeMem maybeIgnoreHosts
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


