/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_async_encoder = R"doc(Creates the encoder block for use in GNU Radio flowgraphs with async message from a given FEC API object derived from the generic_encoder class.

Encodes frames received as async messages or as a PDU over a message port. This encoder works off a full message as one frame or block to encode. The message length is used as the frame length. To support this, the encoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that.


This deployment works off messages and expects them to either be messages full of unpacked bits or PDU messages, which means full bytes of a frame from the higher layers, including things like headers, tails, CRC check bytes, etc. For handling PDUs, set the  option of this deployment block to True. The block will then use the FEC API to properly unpack the bits from the PDU, pass it through the encoder, and repack them to output the PDUs for the next stage of processing.


The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are unpacked and packed, where reading or writing from the LSB or MSB. By default, the  and  modes are set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream encoders. That is, putting the same data into both the tagged stream encoder deployment and this with these default settings should produce the same data.

Constructor Specific Documentation:

Build the PDU-based FEC encoder block from an FECAPI encoder object.

Args:
    my_encoder : An FECAPI encoder object child of the generic_encoder class.
    packed : True if working on packed bytes (like PDUs).
    rev_unpack : Reverse the unpacking order from input bytes to bits.
    rev_pack : Reverse the packing order from bits to output bytes.
    mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.)doc";


static const char* __doc_gr_fec_async_encoder_async_encoder_0 = R"doc()doc";


static const char* __doc_gr_fec_async_encoder_async_encoder_1 = R"doc()doc";


static const char* __doc_gr_fec_async_encoder_make = R"doc(Creates the encoder block for use in GNU Radio flowgraphs with async message from a given FEC API object derived from the generic_encoder class.

Encodes frames received as async messages or as a PDU over a message port. This encoder works off a full message as one frame or block to encode. The message length is used as the frame length. To support this, the encoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that.


This deployment works off messages and expects them to either be messages full of unpacked bits or PDU messages, which means full bytes of a frame from the higher layers, including things like headers, tails, CRC check bytes, etc. For handling PDUs, set the  option of this deployment block to True. The block will then use the FEC API to properly unpack the bits from the PDU, pass it through the encoder, and repack them to output the PDUs for the next stage of processing.


The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are unpacked and packed, where reading or writing from the LSB or MSB. By default, the  and  modes are set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream encoders. That is, putting the same data into both the tagged stream encoder deployment and this with these default settings should produce the same data.

Constructor Specific Documentation:

Build the PDU-based FEC encoder block from an FECAPI encoder object.

Args:
    my_encoder : An FECAPI encoder object child of the generic_encoder class.
    packed : True if working on packed bytes (like PDUs).
    rev_unpack : Reverse the unpacking order from input bytes to bits.
    rev_pack : Reverse the packing order from bits to output bytes.
    mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.)doc";


static const char* __doc_gr_fec_async_encoder_general_work = R"doc(compute output items from input items

WORK_CALLED_PRODUCE is used where not all outputs produce the same number of items. general_work must call produce() for each output to indicate the number of items actually produced.


WORK_DONE indicates that no more data will be produced by this block.


general_work must call consume or consume_each to indicate how many items were consumed on each input stream.)doc";
