
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "iconprovider_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_IconProvider_Type = nullptr;
static PyTypeObject *Sbk_IconProvider_TypeF(void)
{
    return _Sbk_IconProvider_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void IconProviderWrapper::pysideInitQtMetaTypes()
{
}

void IconProviderWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

IconProviderWrapper::IconProviderWrapper()
{
}

void IconProviderWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("IconProvider", funcName, gil, pyOverride, signal);
}

void IconProviderWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("IconProvider", funcName, gil, pyOverride, event);
}

int IconProviderWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("IconProvider", funcName, gil, pyOverride);
}

void IconProviderWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("IconProvider", funcName, gil, pyOverride, signal);
}

void IconProviderWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("IconProvider", funcName, gil, pyOverride, event);
}

bool IconProviderWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return WebViewWrapper::sbk_o_event("IconProvider", funcName, gil, pyOverride, event);
}

bool IconProviderWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("IconProvider", funcName, gil, pyOverride, watched, event);
}

void IconProviderWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("IconProvider", funcName, gil, pyOverride, event);
}

bool IconProviderWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("IconProvider", funcName, gil, pyOverride, next);
}

void IconProviderWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("IconProvider", funcName, gil, pyOverride, event);
}

bool IconProviderWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("IconProvider", funcName, gil, pyOverride);
}

int IconProviderWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("IconProvider", funcName, gil, pyOverride, arg__1);
}

void IconProviderWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("IconProvider", funcName, gil, pyOverride, painter);
}

void IconProviderWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("IconProvider", funcName, gil, pyOverride, event);
}

::QVariant IconProviderWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("IconProvider", funcName, gil, pyOverride, arg__1);
}

void IconProviderWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    WebViewWrapper::sbk_o_keyPressEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("IconProvider", funcName, gil, pyOverride, event);
}

int IconProviderWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("IconProvider", funcName, gil, pyOverride, arg__1);
}

::QSize IconProviderWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("IconProvider", funcName, gil, pyOverride);
}

void IconProviderWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("IconProvider", funcName, gil, pyOverride, event);
}

bool IconProviderWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("IconProvider", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * IconProviderWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("IconProvider", funcName, gil, pyOverride);
}

void IconProviderWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("IconProvider", funcName, gil, pyOverride, event);
}

::QPaintDevice * IconProviderWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("IconProvider", funcName, gil, pyOverride, offset);
}

void IconProviderWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("IconProvider", funcName, gil, pyOverride, visible);
}

::QPainter * IconProviderWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("IconProvider", funcName, gil, pyOverride);
}

void IconProviderWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("IconProvider", funcName, gil, pyOverride, event);
}

::QSize IconProviderWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("IconProvider", funcName, gil, pyOverride);
}

void IconProviderWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("IconProvider", funcName, gil, pyOverride, event);
}

void IconProviderWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_IconProvider_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("IconProvider", funcName, gil, pyOverride, event);
}

const QMetaObject *IconProviderWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return IconProvider::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int IconProviderWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = IconProvider::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *IconProviderWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< IconProviderWrapper *>(this));
    }
    return IconProvider::qt_metacast(_clname);
}

IconProviderWrapper::~IconProviderWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_IconProvider_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_IconProvider_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::IconProvider >()))
        return -1;

    IconProviderWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // IconProvider()
        void *addr = PySide::nextQObjectMemoryAddr();
        if (addr != nullptr) {
            cptr = new (addr) IconProviderWrapper();
            PySide::setNextQObjectMemoryAddr(nullptr);
        } else {
            cptr = new IconProviderWrapper();
        }

    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< IconProvider >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);
    };


    return 1;
}

static PyObject *Sbk_IconProviderFunc_bookmarkIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<IconProviderWrapper *>(reinterpret_cast< ::IconProvider *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // bookmarkIcon()const
        QIcon cppResult = const_cast<const IconProviderWrapper *>(cppSelf)->bookmarkIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_clearOldIconsInDatabase(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<IconProviderWrapper *>(reinterpret_cast< ::IconProvider *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearOldIconsInDatabase()
        cppSelf->clearOldIconsInDatabase();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_IconProviderFunc_emptyWebIcon(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // emptyWebIcon()
        QIcon cppResult = ::IconProvider::emptyWebIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_emptyWebImage(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // emptyWebImage()
        QImage cppResult = ::IconProvider::emptyWebImage();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QImage_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_iconForDomain(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "iconForDomain", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    if (PyArg_ParseTuple(args, "|OO:iconForDomain", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static IconProvider::iconForDomain(QUrl,bool=)->QIcon
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // iconForDomain(QUrl,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // iconForDomain(QUrl,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "iconForDomain", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"allowNull", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "iconForDomain", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // iconForDomain(QUrl,bool)
            QIcon cppResult = ::IconProvider::iconForDomain(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_iconForUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "iconForUrl", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    if (PyArg_ParseTuple(args, "|OO:iconForUrl", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static IconProvider::iconForUrl(QUrl,bool=)->QIcon
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // iconForUrl(QUrl,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // iconForUrl(QUrl,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "iconForUrl", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"allowNull", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "iconForUrl", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // iconForUrl(QUrl,bool)
            QIcon cppResult = ::IconProvider::iconForUrl(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_imageForDomain(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "imageForDomain", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    if (PyArg_ParseTuple(args, "|OO:imageForDomain", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static IconProvider::imageForDomain(QUrl,bool=)->QImage
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // imageForDomain(QUrl,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // imageForDomain(QUrl,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "imageForDomain", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"allowNull", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "imageForDomain", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // imageForDomain(QUrl,bool)
            QImage cppResult = ::IconProvider::imageForDomain(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QImage_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_imageForUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "imageForUrl", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    if (PyArg_ParseTuple(args, "|OO:imageForUrl", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static IconProvider::imageForUrl(QUrl,bool=)->QImage
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // imageForUrl(QUrl,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // imageForUrl(QUrl,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "imageForUrl", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"allowNull", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "imageForUrl", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // imageForUrl(QUrl,bool)
            QImage cppResult = ::IconProvider::imageForUrl(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QImage_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_instance(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // instance()
        IconProvider * cppResult = ::IconProvider::instance();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_newTabIcon(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // newTabIcon()
        QIcon cppResult = ::IconProvider::newTabIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_newWindowIcon(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // newWindowIcon()
        QIcon cppResult = ::IconProvider::newWindowIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_privateBrowsingIcon(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // privateBrowsingIcon()
        QIcon cppResult = ::IconProvider::privateBrowsingIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_saveIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<IconProviderWrapper *>(reinterpret_cast< ::IconProvider *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: IconProvider::saveIcon(WebView*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), (pyArg)))) {
        overloadId = 0; // saveIcon(WebView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "saveIcon", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // saveIcon(WebView*)
            cppSelf->saveIcon(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_IconProviderFunc_saveIconsToDatabase(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<IconProviderWrapper *>(reinterpret_cast< ::IconProvider *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveIconsToDatabase()
        cppSelf->saveIconsToDatabase();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_IconProviderFunc_setBookmarkIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<IconProviderWrapper *>(reinterpret_cast< ::IconProvider *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: IconProvider::setBookmarkIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setBookmarkIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBookmarkIcon", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setBookmarkIcon(QIcon)
            cppSelf->setBookmarkIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_IconProviderFunc_settingsIcon(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // settingsIcon()
        QIcon cppResult = ::IconProvider::settingsIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_IconProviderFunc_standardIcon(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static IconProvider::standardIcon(QStyle::StandardPixmap)->QIcon
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyle_StandardPixmap_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // standardIcon(QStyle::StandardPixmap)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "standardIcon", errInfo, SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]);

    // Call function/method
    {
        ::QStyle::StandardPixmap cppArg0{QStyle::SP_TitleBarMenuButton};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // standardIcon(QStyle::StandardPixmap)
            QIcon cppResult = ::IconProvider::standardIcon(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_IconProvider_PropertyStrings[] = {
    "bookmarkIcon::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_IconProvider_methods[] = {
    {"bookmarkIcon", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_bookmarkIcon), METH_NOARGS, nullptr},
    {"clearOldIconsInDatabase", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_clearOldIconsInDatabase), METH_NOARGS, nullptr},
    {"emptyWebIcon", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_emptyWebIcon), METH_NOARGS|METH_STATIC, nullptr},
    {"emptyWebImage", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_emptyWebImage), METH_NOARGS|METH_STATIC, nullptr},
    {"iconForDomain", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_iconForDomain), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"iconForUrl", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_iconForUrl), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"imageForDomain", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_imageForDomain), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"imageForUrl", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_imageForUrl), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_instance), METH_NOARGS|METH_STATIC, nullptr},
    {"newTabIcon", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_newTabIcon), METH_NOARGS|METH_STATIC, nullptr},
    {"newWindowIcon", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_newWindowIcon), METH_NOARGS|METH_STATIC, nullptr},
    {"privateBrowsingIcon", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_privateBrowsingIcon), METH_NOARGS|METH_STATIC, nullptr},
    {"saveIcon", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_saveIcon), METH_O, nullptr},
    {"saveIconsToDatabase", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_saveIconsToDatabase), METH_NOARGS, nullptr},
    {"setBookmarkIcon", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_setBookmarkIcon), METH_O, nullptr},
    {"settingsIcon", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_settingsIcon), METH_NOARGS|METH_STATIC, nullptr},
    {"standardIcon", reinterpret_cast<PyCFunction>(Sbk_IconProviderFunc_standardIcon), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_IconProvider_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::IconProvider *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_IconProvider_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<IconProviderWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_IconProvider_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_IconProvider_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_IconProviderSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::IconProvider *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_IconProvider_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_IconProvider_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_IconProvider_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_IconProvider_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_IconProvider_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_IconProvider_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_IconProvider_spec = {
    "1:PyFalkon.IconProvider",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_IconProvider_slots
};

} //extern "C"

static void *Sbk_IconProvider_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::IconProvider *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::IconProvider *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::IconProvider *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void IconProvider_PythonToCpp_IconProvider_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_IconProvider_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_IconProvider_PythonToCpp_IconProvider_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_IconProvider_TypeF()))
        return IconProvider_PythonToCpp_IconProvider_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *IconProvider_PTR_CppToPython_IconProvider(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::IconProvider *>(const_cast<void *>(cppIn)), Sbk_IconProvider_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *IconProvider_SignatureStrings[] = {
    "PyFalkon.IconProvider(self,*:KeywordOnly=None,bookmarkIcon:QIcon=None)",
    "PyFalkon.IconProvider.bookmarkIcon(self)->PySide6.QtGui.QIcon",
    "PyFalkon.IconProvider.clearOldIconsInDatabase(self)",
    "PyFalkon.IconProvider.emptyWebIcon()->PySide6.QtGui.QIcon",
    "PyFalkon.IconProvider.emptyWebImage()->PySide6.QtGui.QImage",
    "PyFalkon.IconProvider.iconForDomain(url:typing.Union[PySide6.QtCore.QUrl, QString],allowNull:bool=false)->PySide6.QtGui.QIcon",
    "PyFalkon.IconProvider.iconForUrl(url:typing.Union[PySide6.QtCore.QUrl, QString],allowNull:bool=false)->PySide6.QtGui.QIcon",
    "PyFalkon.IconProvider.imageForDomain(url:typing.Union[PySide6.QtCore.QUrl, QString],allowNull:bool=false)->PySide6.QtGui.QImage",
    "PyFalkon.IconProvider.imageForUrl(url:typing.Union[PySide6.QtCore.QUrl, QString],allowNull:bool=false)->PySide6.QtGui.QImage",
    "PyFalkon.IconProvider.instance()->PyFalkon.IconProvider",
    "PyFalkon.IconProvider.newTabIcon()->PySide6.QtGui.QIcon",
    "PyFalkon.IconProvider.newWindowIcon()->PySide6.QtGui.QIcon",
    "PyFalkon.IconProvider.privateBrowsingIcon()->PySide6.QtGui.QIcon",
    "PyFalkon.IconProvider.saveIcon(self,view:PyFalkon.WebView)",
    "PyFalkon.IconProvider.saveIconsToDatabase(self)",
    "PyFalkon.IconProvider.setBookmarkIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "PyFalkon.IconProvider.settingsIcon()->PySide6.QtGui.QIcon",
    "PyFalkon.IconProvider.standardIcon(icon:PySide6.QtWidgets.QStyle.StandardPixmap)->PySide6.QtGui.QIcon",
    nullptr}; // Sentinel
#else
static constexpr size_t IconProvider_SignatureByteSize = 354;
static constexpr uint8_t IconProvider_SignatureBytes[354] = {
    0x78, 0xda, 0xbd, 0x54, 0xcd, 0x6e, 0xc2, 0x30, 0x0c, 0xbe, 0xef, 0x29, 0x38, 0xc2, 0x94, 0xe5,
    0xb8, 0x43, 0x25, 0x76, 0x60, 0x88, 0x09, 0x4d, 0x82, 0x56, 0xc0, 0x38, 0x4c, 0x1c, 0x0c, 0x35,
    0x28, 0x22, 0x8d, 0xab, 0x24, 0xb4, 0xcb, 0xdb, 0x2f, 0x2d, 0x55, 0x99, 0x10, 0x65, 0x2b, 0x12,
    0xbb, 0x54, 0xaa, 0xf3, 0xfd, 0xd8, 0x8e, 0x9d, 0xd0, 0x8d, 0x40, 0xee, 0x49, 0xf1, 0xf1, 0x86,
    0x54, 0xa8, 0x29, 0x13, 0x31, 0xea, 0xae, 0x41, 0xb9, 0x65, 0x8f, 0xc1, 0x3b, 0xba, 0x9c, 0x74,
    0x3c, 0x55, 0xd2, 0xf5, 0x27, 0xa4, 0x90, 0xad, 0x89, 0xf6, 0x09, 0xe8, 0x7d, 0x01, 0x0e, 0xa2,
    0xe2, 0x5b, 0xc6, 0x7b, 0x0f, 0xe1, 0x25, 0x19, 0xfe, 0x13, 0x5e, 0x6a, 0xf6, 0x9e, 0x5e, 0x42,
    0x37, 0xf3, 0x67, 0xcf, 0x3c, 0xb2, 0x6f, 0x07, 0xc1, 0x4b, 0x8d, 0x06, 0xf6, 0x46, 0x22, 0xe8,
    0xa9, 0x8c, 0x8b, 0xa0, 0x19, 0xab, 0x21, 0x58, 0x58, 0x83, 0xc1, 0xa3, 0x50, 0x03, 0x07, 0x93,
    0xd4, 0xba, 0x25, 0xae, 0x4b, 0xc7, 0x56, 0x6e, 0x35, 0x33, 0x81, 0x1d, 0x5e, 0xa2, 0x16, 0xf1,
    0x06, 0xae, 0xf0, 0x3f, 0x23, 0xd2, 0x43, 0x4a, 0x40, 0xa8, 0xee, 0x41, 0xcb, 0xc0, 0xba, 0x54,
    0xa8, 0x1d, 0x5f, 0x28, 0x41, 0xea, 0xf3, 0xa4, 0xf4, 0x4a, 0x1a, 0x79, 0xb4, 0xd0, 0x92, 0x75,
    0xa2, 0x99, 0xd5, 0x1e, 0xb2, 0x62, 0x20, 0x25, 0xe5, 0x93, 0x83, 0x94, 0x81, 0x6f, 0x97, 0xec,
    0x6f, 0x41, 0x1a, 0x6c, 0x95, 0x79, 0xe5, 0xee, 0x55, 0xff, 0xdf, 0xba, 0x68, 0xca, 0xbd, 0x2b,
    0xbf, 0xd6, 0xf8, 0xca, 0xff, 0x7e, 0xb5, 0x5f, 0x33, 0x57, 0xc6, 0x82, 0xda, 0x54, 0xc3, 0x72,
    0x01, 0xd1, 0xc0, 0x53, 0x98, 0xcf, 0xe1, 0x86, 0x09, 0xf5, 0xbc, 0xa5, 0x50, 0x31, 0xe5, 0xed,
    0xa9, 0xa9, 0x16, 0x19, 0x58, 0x1c, 0x68, 0xca, 0x8d, 0xaf, 0xbe, 0xbd, 0x80, 0x81, 0x0c, 0xeb,
    0x2d, 0x66, 0x99, 0xc0, 0x3c, 0xa8, 0x81, 0x7e, 0x69, 0x3e, 0x7c, 0xa0, 0xf7, 0x0b, 0xd5, 0xcc,
    0xe9, 0x4f, 0x2b, 0x6c, 0xd0, 0x0e, 0xce, 0xdf, 0x0d, 0x56, 0xcc, 0x78, 0xd3, 0xed, 0xd6, 0xb9,
    0xb3, 0xce, 0x59, 0x30, 0x14, 0x5f, 0x09, 0xa4, 0xab, 0x2b, 0x4e, 0xd6, 0x0b, 0x9a, 0x1b, 0xda,
    0xe1, 0x2f, 0x3e, 0x06, 0x5d, 0x3e, 0x4d, 0xdd, 0x32, 0xb7, 0x13, 0x77, 0x29, 0xe2, 0x1d, 0x5a,
    0xc3, 0xfd, 0xa4, 0x39, 0x89, 0x7c, 0x56, 0x41, 0x8f, 0xb9, 0x34, 0xb8, 0x7c, 0x03, 0x1c, 0x4a,
    0x00, 0xc0
};
#endif

PyTypeObject *init_IconProvider(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_IconProvider_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_IconProvider_IDX].type;

    Shiboken::AutoDecRef Sbk_IconProvider_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_IconProvider_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "IconProvider",
        "IconProvider*",
        &Sbk_IconProvider_spec,
        &Shiboken::callCppDestructor< IconProvider >,
        Sbk_IconProvider_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_IconProvider_TypeF(); // references _Sbk_IconProvider_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, IconProvider_SignatureStrings);
#else
    InitSignatureBytes(pyType, IconProvider_SignatureBytes, IconProvider_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_IconProvider_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_IconProvider_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        IconProvider_PythonToCpp_IconProvider_PTR,
        is_IconProvider_PythonToCpp_IconProvider_PTR_Convertible,
        IconProvider_PTR_CppToPython_IconProvider);

    Shiboken::Conversions::registerConverterName(converter, "IconProvider");
    Shiboken::Conversions::registerConverterName(converter, "IconProvider*");
    Shiboken::Conversions::registerConverterName(converter, "IconProvider&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::IconProvider).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(IconProviderWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_IconProvider_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_IconProvider_TypeF(), &Sbk_IconProviderSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_IconProvider_TypeF(), &Sbk_IconProvider_typeDiscovery);

    IconProviderWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::IconProvider::staticMetaObject, sizeof(IconProviderWrapper));

    return pyType;
}
