// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/registry/plugin/v1beta1/collection.proto

//go:build !protoopaque

package pluginv1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A collection for a Plugin.
//
// These collections help organize plugins based on their functionality or ecosystem.
type Collection struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The id of the Collection.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The time the Collection was created on the BSR.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last time the Collection was updated on the BSR.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The name of the Collection.
	//
	// Unique within a BSR instance.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The configurable description of the Collection.
	Description   string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Collection) Reset() {
	*x = Collection{}
	mi := &file_buf_registry_plugin_v1beta1_collection_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Collection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Collection) ProtoMessage() {}

func (x *Collection) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_collection_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Collection) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Collection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Collection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Collection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Collection) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Collection) SetId(v string) {
	x.Id = v
}

func (x *Collection) SetCreateTime(v *timestamppb.Timestamp) {
	x.CreateTime = v
}

func (x *Collection) SetUpdateTime(v *timestamppb.Timestamp) {
	x.UpdateTime = v
}

func (x *Collection) SetName(v string) {
	x.Name = v
}

func (x *Collection) SetDescription(v string) {
	x.Description = v
}

func (x *Collection) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.CreateTime != nil
}

func (x *Collection) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.UpdateTime != nil
}

func (x *Collection) ClearCreateTime() {
	x.CreateTime = nil
}

func (x *Collection) ClearUpdateTime() {
	x.UpdateTime = nil
}

type Collection_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The id of the Collection.
	Id string
	// The time the Collection was created on the BSR.
	CreateTime *timestamppb.Timestamp
	// The last time the Collection was updated on the BSR.
	UpdateTime *timestamppb.Timestamp
	// The name of the Collection.
	//
	// Unique within a BSR instance.
	Name string
	// The configurable description of the Collection.
	Description string
}

func (b0 Collection_builder) Build() *Collection {
	m0 := &Collection{}
	b, x := &b0, m0
	_, _ = b, x
	x.Id = b.Id
	x.CreateTime = b.CreateTime
	x.UpdateTime = b.UpdateTime
	x.Name = b.Name
	x.Description = b.Description
	return m0
}

// CollectionRef is a reference to a Collection, either an id or a name.
type CollectionRef struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Types that are valid to be assigned to Value:
	//
	//	*CollectionRef_Id
	//	*CollectionRef_Name
	Value         isCollectionRef_Value `protobuf_oneof:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CollectionRef) Reset() {
	*x = CollectionRef{}
	mi := &file_buf_registry_plugin_v1beta1_collection_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CollectionRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CollectionRef) ProtoMessage() {}

func (x *CollectionRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_collection_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CollectionRef) GetValue() isCollectionRef_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *CollectionRef) GetId() string {
	if x != nil {
		if x, ok := x.Value.(*CollectionRef_Id); ok {
			return x.Id
		}
	}
	return ""
}

func (x *CollectionRef) GetName() string {
	if x != nil {
		if x, ok := x.Value.(*CollectionRef_Name); ok {
			return x.Name
		}
	}
	return ""
}

func (x *CollectionRef) SetId(v string) {
	x.Value = &CollectionRef_Id{v}
}

func (x *CollectionRef) SetName(v string) {
	x.Value = &CollectionRef_Name{v}
}

func (x *CollectionRef) HasValue() bool {
	if x == nil {
		return false
	}
	return x.Value != nil
}

func (x *CollectionRef) HasId() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*CollectionRef_Id)
	return ok
}

func (x *CollectionRef) HasName() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*CollectionRef_Name)
	return ok
}

func (x *CollectionRef) ClearValue() {
	x.Value = nil
}

func (x *CollectionRef) ClearId() {
	if _, ok := x.Value.(*CollectionRef_Id); ok {
		x.Value = nil
	}
}

func (x *CollectionRef) ClearName() {
	if _, ok := x.Value.(*CollectionRef_Name); ok {
		x.Value = nil
	}
}

const CollectionRef_Value_not_set_case case_CollectionRef_Value = 0
const CollectionRef_Id_case case_CollectionRef_Value = 1
const CollectionRef_Name_case case_CollectionRef_Value = 2

func (x *CollectionRef) WhichValue() case_CollectionRef_Value {
	if x == nil {
		return CollectionRef_Value_not_set_case
	}
	switch x.Value.(type) {
	case *CollectionRef_Id:
		return CollectionRef_Id_case
	case *CollectionRef_Name:
		return CollectionRef_Name_case
	default:
		return CollectionRef_Value_not_set_case
	}
}

type CollectionRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof Value:
	// The id of the Collection.
	Id *string
	// The name of the Collection.
	Name *string
	// -- end of Value
}

func (b0 CollectionRef_builder) Build() *CollectionRef {
	m0 := &CollectionRef{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Id != nil {
		x.Value = &CollectionRef_Id{*b.Id}
	}
	if b.Name != nil {
		x.Value = &CollectionRef_Name{*b.Name}
	}
	return m0
}

type case_CollectionRef_Value protoreflect.FieldNumber

func (x case_CollectionRef_Value) String() string {
	md := file_buf_registry_plugin_v1beta1_collection_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isCollectionRef_Value interface {
	isCollectionRef_Value()
}

type CollectionRef_Id struct {
	// The id of the Collection.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type CollectionRef_Name struct {
	// The name of the Collection.
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*CollectionRef_Id) isCollectionRef_Value() {}

func (*CollectionRef_Name) isCollectionRef_Value() {}

var File_buf_registry_plugin_v1beta1_collection_proto protoreflect.FileDescriptor

const file_buf_registry_plugin_v1beta1_collection_proto_rawDesc = "" +
	"\n" +
	",buf/registry/plugin/v1beta1/collection.proto\x12\x1bbuf.registry.plugin.v1beta1\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\x88\x02\n" +
	"\n" +
	"Collection\x12\x1b\n" +
	"\x02id\x18\x01 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\x02id\x12C\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"createTime\x12C\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"updateTime\x12\x1f\n" +
	"\x04name\x18\x04 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x18\xfa\x01R\x04name\x12*\n" +
	"\vdescription\x18\x05 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription:\x06\xea\xc5+\x02\x10\x01\"d\n" +
	"\rCollectionRef\x12\x1a\n" +
	"\x02id\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x88\x02\x01H\x00R\x02id\x12\x1f\n" +
	"\x04name\x18\x02 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dH\x00R\x04name:\x06\xea\xc5+\x02\b\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/plugin/v1beta1;pluginv1beta1b\x06proto3"

var file_buf_registry_plugin_v1beta1_collection_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_buf_registry_plugin_v1beta1_collection_proto_goTypes = []any{
	(*Collection)(nil),            // 0: buf.registry.plugin.v1beta1.Collection
	(*CollectionRef)(nil),         // 1: buf.registry.plugin.v1beta1.CollectionRef
	(*timestamppb.Timestamp)(nil), // 2: google.protobuf.Timestamp
}
var file_buf_registry_plugin_v1beta1_collection_proto_depIdxs = []int32{
	2, // 0: buf.registry.plugin.v1beta1.Collection.create_time:type_name -> google.protobuf.Timestamp
	2, // 1: buf.registry.plugin.v1beta1.Collection.update_time:type_name -> google.protobuf.Timestamp
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_buf_registry_plugin_v1beta1_collection_proto_init() }
func file_buf_registry_plugin_v1beta1_collection_proto_init() {
	if File_buf_registry_plugin_v1beta1_collection_proto != nil {
		return
	}
	file_buf_registry_plugin_v1beta1_collection_proto_msgTypes[1].OneofWrappers = []any{
		(*CollectionRef_Id)(nil),
		(*CollectionRef_Name)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_plugin_v1beta1_collection_proto_rawDesc), len(file_buf_registry_plugin_v1beta1_collection_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_plugin_v1beta1_collection_proto_goTypes,
		DependencyIndexes: file_buf_registry_plugin_v1beta1_collection_proto_depIdxs,
		MessageInfos:      file_buf_registry_plugin_v1beta1_collection_proto_msgTypes,
	}.Build()
	File_buf_registry_plugin_v1beta1_collection_proto = out.File
	file_buf_registry_plugin_v1beta1_collection_proto_goTypes = nil
	file_buf_registry_plugin_v1beta1_collection_proto_depIdxs = nil
}
