"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GET_ALERTS_SORT_FILTERS = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const GET_ALERTS_SORT_FILTERS = exports.GET_ALERTS_SORT_FILTERS = {
  MONITOR_NAME: 'monitor_name',
  TRIGGER_NAME: 'trigger_name',
  START_TIME: 'start_time',
  END_TIME: 'end_time',
  ACKNOWLEDGE_TIME: 'acknowledged_time'
};
class AlertService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getAlerts", async (context, req, res) => {
      const {
        from = 0,
        size = 20,
        search = '',
        sortDirection = 'desc',
        sortField = GET_ALERTS_SORT_FILTERS.START_TIME,
        severityLevel = 'ALL',
        alertState = 'ALL',
        monitorIds = [],
        monitorType = 'monitor'
      } = req.query;
      var params;
      switch (sortField) {
        case GET_ALERTS_SORT_FILTERS.MONITOR_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        case GET_ALERTS_SORT_FILTERS.TRIGGER_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        case GET_ALERTS_SORT_FILTERS.END_TIME:
          params = {
            sortString: sortField,
            sortOrder: sortDirection,
            missing: sortDirection === 'asc' ? '_last' : '_first'
          };
          break;
        case GET_ALERTS_SORT_FILTERS.ACKNOWLEDGE_TIME:
          params = {
            sortString: sortField,
            sortOrder: sortDirection,
            missing: '_last'
          };
          break;
        default:
          // If the sortField parsed from the URL isn't a valid option for this API, use a default option.
          params = {
            sortString: GET_ALERTS_SORT_FILTERS.START_TIME,
            sortOrder: sortDirection
          };
      }
      params.startIndex = from;
      params.size = size;
      params.severityLevel = severityLevel;
      params.alertState = alertState;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      if (monitorIds.length > 0) {
        const idField = monitorType === 'composite' ? 'workflowIds' : 'monitorId';
        params[idField] = !Array.isArray(monitorIds) ? monitorIds : monitorIds[0];
      }
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.getAlerts', params);
        const alerts = resp.alerts.map(hit => {
          const alert = hit;
          const id = hit.alert_id;
          const version = hit.alert_version;
          return {
            id,
            ...alert,
            version,
            alert_source: !!alert.workflow_id ? 'workflow' : 'monitor'
          };
        });
        const totalAlerts = resp.totalAlerts;
        return res.ok({
          body: {
            ok: true,
            alerts,
            totalAlerts
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    _defineProperty(this, "getWorkflowAlerts", async (context, req, res) => {
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.getWorkflowAlerts', req.query);
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
  }
}
exports.default = AlertService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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