﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcampaignsv2/ConnectCampaignsV2Request.h>
#include <aws/connectcampaignsv2/ConnectCampaignsV2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ConnectCampaignsV2 {
namespace Model {

/**
 * <p>The request for UpdateCampaignFlowAssociation API.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connectcampaignsv2-2024-04-23/UpdateCampaignFlowAssociationRequest">AWS
 * API Reference</a></p>
 */
class UpdateCampaignFlowAssociationRequest : public ConnectCampaignsV2Request {
 public:
  AWS_CONNECTCAMPAIGNSV2_API UpdateCampaignFlowAssociationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateCampaignFlowAssociation"; }

  AWS_CONNECTCAMPAIGNSV2_API Aws::String SerializePayload() const override;

  ///@{

  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  UpdateCampaignFlowAssociationRequest& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetConnectCampaignFlowArn() const { return m_connectCampaignFlowArn; }
  inline bool ConnectCampaignFlowArnHasBeenSet() const { return m_connectCampaignFlowArnHasBeenSet; }
  template <typename ConnectCampaignFlowArnT = Aws::String>
  void SetConnectCampaignFlowArn(ConnectCampaignFlowArnT&& value) {
    m_connectCampaignFlowArnHasBeenSet = true;
    m_connectCampaignFlowArn = std::forward<ConnectCampaignFlowArnT>(value);
  }
  template <typename ConnectCampaignFlowArnT = Aws::String>
  UpdateCampaignFlowAssociationRequest& WithConnectCampaignFlowArn(ConnectCampaignFlowArnT&& value) {
    SetConnectCampaignFlowArn(std::forward<ConnectCampaignFlowArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_connectCampaignFlowArn;
  bool m_connectCampaignFlowArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCampaignsV2
}  // namespace Aws
