// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudVault20201125MajorVersionUpgradeConfig MajorVersionUpgradeConfig is the major version upgrade configuration for the cluster
//
// swagger:model hashicorp.cloud.vault_20201125.MajorVersionUpgradeConfig
type HashicorpCloudVault20201125MajorVersionUpgradeConfig struct {

	// maintenance_window is the time window in which upgrades will occur, if upgrade_type is scheduled
	MaintenanceWindow *HashicorpCloudVault20201125MajorVersionUpgradeConfigMaintenanceWindow `json:"maintenance_window,omitempty"`

	// upgrade_type is the upgrade method that will be used
	UpgradeType *HashicorpCloudVault20201125MajorVersionUpgradeConfigUpgradeType `json:"upgrade_type,omitempty"`
}

// Validate validates this hashicorp cloud vault 20201125 major version upgrade config
func (m *HashicorpCloudVault20201125MajorVersionUpgradeConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMaintenanceWindow(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpgradeType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVault20201125MajorVersionUpgradeConfig) validateMaintenanceWindow(formats strfmt.Registry) error {
	if swag.IsZero(m.MaintenanceWindow) { // not required
		return nil
	}

	if m.MaintenanceWindow != nil {
		if err := m.MaintenanceWindow.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("maintenance_window")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("maintenance_window")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVault20201125MajorVersionUpgradeConfig) validateUpgradeType(formats strfmt.Registry) error {
	if swag.IsZero(m.UpgradeType) { // not required
		return nil
	}

	if m.UpgradeType != nil {
		if err := m.UpgradeType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("upgrade_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("upgrade_type")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud vault 20201125 major version upgrade config based on the context it is used
func (m *HashicorpCloudVault20201125MajorVersionUpgradeConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMaintenanceWindow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpgradeType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVault20201125MajorVersionUpgradeConfig) contextValidateMaintenanceWindow(ctx context.Context, formats strfmt.Registry) error {

	if m.MaintenanceWindow != nil {

		if swag.IsZero(m.MaintenanceWindow) { // not required
			return nil
		}

		if err := m.MaintenanceWindow.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("maintenance_window")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("maintenance_window")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVault20201125MajorVersionUpgradeConfig) contextValidateUpgradeType(ctx context.Context, formats strfmt.Registry) error {

	if m.UpgradeType != nil {

		if swag.IsZero(m.UpgradeType) { // not required
			return nil
		}

		if err := m.UpgradeType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("upgrade_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("upgrade_type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudVault20201125MajorVersionUpgradeConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudVault20201125MajorVersionUpgradeConfig) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudVault20201125MajorVersionUpgradeConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
