// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "StyleProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::StylePropertyPrivate
{
public:
    std::optional<LayoutProperty> layout;
    std::optional<TextProperty> text;
    std::optional<IconProperty> icon;
    std::optional<BackgroundProperty> background;
    std::optional<BorderProperty> border;
    std::optional<OutlineProperty> outline;
    std::optional<CornersProperty> corners;
    std::optional<ShadowProperty> shadow;
};

StyleProperty::StyleProperty()
    : d(std::make_unique<StylePropertyPrivate>())
{
}

StyleProperty::StyleProperty(const StyleProperty &other)
    : d(std::make_unique<StylePropertyPrivate>())
{
    d->layout = other.d->layout;
    d->text = other.d->text;
    d->icon = other.d->icon;
    d->background = other.d->background;
    d->border = other.d->border;
    d->outline = other.d->outline;
    d->corners = other.d->corners;
    d->shadow = other.d->shadow;
}

StyleProperty::StyleProperty(StyleProperty &&other)
    : d(std::move(other.d))
{
}

StyleProperty::~StyleProperty() = default;

StyleProperty &StyleProperty::operator=(const StyleProperty &other)
{
    if (this != &other) {
        d->layout = other.d->layout;
        d->text = other.d->text;
        d->icon = other.d->icon;
        d->background = other.d->background;
        d->border = other.d->border;
        d->outline = other.d->outline;
        d->corners = other.d->corners;
        d->shadow = other.d->shadow;
    }
    return *this;
}

StyleProperty &StyleProperty::operator=(StyleProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<LayoutProperty> StyleProperty::layout() const
{
    return d->layout;
}

LayoutProperty StyleProperty::layout_or_new() const
{
    return d->layout.value_or(LayoutProperty{});
}

void StyleProperty::setLayout(const std::optional<LayoutProperty> &newValue)
{
    if (newValue == d->layout) {
        return;
    }

    d->layout = newValue;
}
std::optional<TextProperty> StyleProperty::text() const
{
    return d->text;
}

TextProperty StyleProperty::text_or_new() const
{
    return d->text.value_or(TextProperty{});
}

void StyleProperty::setText(const std::optional<TextProperty> &newValue)
{
    if (newValue == d->text) {
        return;
    }

    d->text = newValue;
}
std::optional<IconProperty> StyleProperty::icon() const
{
    return d->icon;
}

IconProperty StyleProperty::icon_or_new() const
{
    return d->icon.value_or(IconProperty{});
}

void StyleProperty::setIcon(const std::optional<IconProperty> &newValue)
{
    if (newValue == d->icon) {
        return;
    }

    d->icon = newValue;
}
std::optional<BackgroundProperty> StyleProperty::background() const
{
    return d->background;
}

BackgroundProperty StyleProperty::background_or_new() const
{
    return d->background.value_or(BackgroundProperty{});
}

void StyleProperty::setBackground(const std::optional<BackgroundProperty> &newValue)
{
    if (newValue == d->background) {
        return;
    }

    d->background = newValue;
}
std::optional<BorderProperty> StyleProperty::border() const
{
    return d->border;
}

BorderProperty StyleProperty::border_or_new() const
{
    return d->border.value_or(BorderProperty{});
}

void StyleProperty::setBorder(const std::optional<BorderProperty> &newValue)
{
    if (newValue == d->border) {
        return;
    }

    d->border = newValue;
}
std::optional<OutlineProperty> StyleProperty::outline() const
{
    return d->outline;
}

OutlineProperty StyleProperty::outline_or_new() const
{
    return d->outline.value_or(OutlineProperty{});
}

void StyleProperty::setOutline(const std::optional<OutlineProperty> &newValue)
{
    if (newValue == d->outline) {
        return;
    }

    d->outline = newValue;
}
std::optional<CornersProperty> StyleProperty::corners() const
{
    return d->corners;
}

CornersProperty StyleProperty::corners_or_new() const
{
    return d->corners.value_or(CornersProperty{});
}

void StyleProperty::setCorners(const std::optional<CornersProperty> &newValue)
{
    if (newValue == d->corners) {
        return;
    }

    d->corners = newValue;
}
std::optional<ShadowProperty> StyleProperty::shadow() const
{
    return d->shadow;
}

ShadowProperty StyleProperty::shadow_or_new() const
{
    return d->shadow.value_or(ShadowProperty{});
}

void StyleProperty::setShadow(const std::optional<ShadowProperty> &newValue)
{
    if (newValue == d->shadow) {
        return;
    }

    d->shadow = newValue;
}

bool StyleProperty::hasAnyValue() const
{
    if (d->layout.has_value() && d->layout->hasAnyValue()) {
        return true;
    }
    if (d->text.has_value() && d->text->hasAnyValue()) {
        return true;
    }
    if (d->icon.has_value() && d->icon->hasAnyValue()) {
        return true;
    }
    if (d->background.has_value() && d->background->hasAnyValue()) {
        return true;
    }
    if (d->border.has_value() && d->border->hasAnyValue()) {
        return true;
    }
    if (d->outline.has_value() && d->outline->hasAnyValue()) {
        return true;
    }
    if (d->corners.has_value() && d->corners->hasAnyValue()) {
        return true;
    }
    if (d->shadow.has_value() && d->shadow->hasAnyValue()) {
        return true;
    }
    return false;
}

void StyleProperty::resolveProperties(const StyleProperty &source, StyleProperty &destination)
{
    if (source.d->layout.has_value()) {
        LayoutProperty property;
        if (destination.d->layout.has_value()) {
            property = destination.d->layout.value();
        }
        LayoutProperty::resolveProperties(source.d->layout.value(), property);
        if (property.hasAnyValue()) {
            destination.d->layout = property;
        }
    }
    if (source.d->text.has_value()) {
        TextProperty property;
        if (destination.d->text.has_value()) {
            property = destination.d->text.value();
        }
        TextProperty::resolveProperties(source.d->text.value(), property);
        if (property.hasAnyValue()) {
            destination.d->text = property;
        }
    }
    if (source.d->icon.has_value()) {
        IconProperty property;
        if (destination.d->icon.has_value()) {
            property = destination.d->icon.value();
        }
        IconProperty::resolveProperties(source.d->icon.value(), property);
        if (property.hasAnyValue()) {
            destination.d->icon = property;
        }
    }
    if (source.d->background.has_value()) {
        BackgroundProperty property;
        if (destination.d->background.has_value()) {
            property = destination.d->background.value();
        }
        BackgroundProperty::resolveProperties(source.d->background.value(), property);
        if (property.hasAnyValue()) {
            destination.d->background = property;
        }
    }
    if (source.d->border.has_value()) {
        BorderProperty property;
        if (destination.d->border.has_value()) {
            property = destination.d->border.value();
        }
        BorderProperty::resolveProperties(source.d->border.value(), property);
        if (property.hasAnyValue()) {
            destination.d->border = property;
        }
    }
    if (source.d->outline.has_value()) {
        OutlineProperty property;
        if (destination.d->outline.has_value()) {
            property = destination.d->outline.value();
        }
        OutlineProperty::resolveProperties(source.d->outline.value(), property);
        if (property.hasAnyValue()) {
            destination.d->outline = property;
        }
    }
    if (source.d->corners.has_value()) {
        CornersProperty property;
        if (destination.d->corners.has_value()) {
            property = destination.d->corners.value();
        }
        CornersProperty::resolveProperties(source.d->corners.value(), property);
        if (property.hasAnyValue()) {
            destination.d->corners = property;
        }
    }
    if (source.d->shadow.has_value()) {
        ShadowProperty property;
        if (destination.d->shadow.has_value()) {
            property = destination.d->shadow.value();
        }
        ShadowProperty::resolveProperties(source.d->shadow.value(), property);
        if (property.hasAnyValue()) {
            destination.d->shadow = property;
        }
    }
}

StyleProperty StyleProperty::empty()
{
    StyleProperty result;
    result.d->layout = emptyValue<LayoutProperty>();
    result.d->text = emptyValue<TextProperty>();
    result.d->icon = emptyValue<IconProperty>();
    result.d->background = emptyValue<BackgroundProperty>();
    result.d->border = emptyValue<BorderProperty>();
    result.d->outline = emptyValue<OutlineProperty>();
    result.d->corners = emptyValue<CornersProperty>();
    result.d->shadow = emptyValue<ShadowProperty>();
    return result;
}

bool Union::Properties::operator==(const StyleProperty &left, const StyleProperty &right)
{
    if (left.layout() != right.layout()) {
        return false;
    }
    if (left.text() != right.text()) {
        return false;
    }
    if (left.icon() != right.icon()) {
        return false;
    }
    if (left.background() != right.background()) {
        return false;
    }
    if (left.border() != right.border()) {
        return false;
    }
    if (left.outline() != right.outline()) {
        return false;
    }
    if (left.corners() != right.corners()) {
        return false;
    }
    if (left.shadow() != right.shadow()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::StyleProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "StyleProperty(" //
                    << "layout: " << type.layout() //
                    << ", text: " << type.text() //
                    << ", icon: " << type.icon() //
                    << ", background: " << type.background() //
                    << ", border: " << type.border() //
                    << ", outline: " << type.outline() //
                    << ", corners: " << type.corners() //
                    << ", shadow: " << type.shadow() //
                    << ")";
    return debug;
}