// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>

#include <QMarginsF>


#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class SizePropertyPrivate;

/*!
\class Union::Properties::SizeProperty
\inmodule core
\ingroup core-properties

\brief A property group representing a set of sizes for cardinal directions.

*/
class UNION_EXPORT SizeProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    SizeProperty();
    /*!
     * Copy constructor.
     */
    SizeProperty(const SizeProperty &other);
    /*!
     * Move constructor.
     */
    SizeProperty(SizeProperty &&other);
    ~SizeProperty();

    /*!
     * Copy assignment operator.
     */
    SizeProperty &operator=(const SizeProperty &other);
    /*!
     * Move assignment operator.
     */
    SizeProperty &operator=(SizeProperty &&other);

    /*!
     * Returns the value of left.
     */
    std::optional<qreal> left() const;
    /*!
     * Set the value of left.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setLeft(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of right.
     */
    std::optional<qreal> right() const;
    /*!
     * Set the value of right.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setRight(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of top.
     */
    std::optional<qreal> top() const;
    /*!
     * Set the value of top.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setTop(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of bottom.
     */
    std::optional<qreal> bottom() const;
    /*!
     * Set the value of bottom.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBottom(const std::optional<qreal> &newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const SizeProperty &source, SizeProperty &destination);

    /*!
     * Create and return an empty SizeProperty instance.
     *
     * This will create an empty SizeProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static SizeProperty empty();

    /*!
       Convert a Size property to QMarginsF.

       If any values are not set, they will use 0.0.
     */
    QMarginsF toMargins() const;

private:
    std::unique_ptr<SizePropertyPrivate> d;
};

/*!
 * \relates Union::Properties::SizeProperty
 * Equality comparison for SizeProperty.
 */
UNION_EXPORT bool operator==(const SizeProperty &left, const SizeProperty &right);
}
}

/*!
 * \relates Union::Properties::SizeProperty
 * QDebug support for SizeProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, const Union::Properties::SizeProperty &type);