// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "AlignmentProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::AlignmentPropertyPrivate
{
public:
    std::optional<Union::Properties::AlignmentContainer> container;
    std::optional<Union::Properties::Alignment> horizontal;
    std::optional<Union::Properties::Alignment> vertical;
    std::optional<int> order;
};

AlignmentProperty::AlignmentProperty()
    : d(std::make_unique<AlignmentPropertyPrivate>())
{
}

AlignmentProperty::AlignmentProperty(const AlignmentProperty &other)
    : d(std::make_unique<AlignmentPropertyPrivate>())
{
    d->container = other.d->container;
    d->horizontal = other.d->horizontal;
    d->vertical = other.d->vertical;
    d->order = other.d->order;
}

AlignmentProperty::AlignmentProperty(AlignmentProperty &&other)
    : d(std::move(other.d))
{
}

AlignmentProperty::~AlignmentProperty() = default;

AlignmentProperty &AlignmentProperty::operator=(const AlignmentProperty &other)
{
    if (this != &other) {
        d->container = other.d->container;
        d->horizontal = other.d->horizontal;
        d->vertical = other.d->vertical;
        d->order = other.d->order;
    }
    return *this;
}

AlignmentProperty &AlignmentProperty::operator=(AlignmentProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<Union::Properties::AlignmentContainer> AlignmentProperty::container() const
{
    return d->container;
}

void AlignmentProperty::setContainer(const std::optional<Union::Properties::AlignmentContainer> &newValue)
{
    if (newValue == d->container) {
        return;
    }

    d->container = newValue;
}
std::optional<Union::Properties::Alignment> AlignmentProperty::horizontal() const
{
    return d->horizontal;
}

void AlignmentProperty::setHorizontal(const std::optional<Union::Properties::Alignment> &newValue)
{
    if (newValue == d->horizontal) {
        return;
    }

    d->horizontal = newValue;
}
std::optional<Union::Properties::Alignment> AlignmentProperty::vertical() const
{
    return d->vertical;
}

void AlignmentProperty::setVertical(const std::optional<Union::Properties::Alignment> &newValue)
{
    if (newValue == d->vertical) {
        return;
    }

    d->vertical = newValue;
}
std::optional<int> AlignmentProperty::order() const
{
    return d->order;
}

void AlignmentProperty::setOrder(const std::optional<int> &newValue)
{
    if (newValue == d->order) {
        return;
    }

    d->order = newValue;
}

bool AlignmentProperty::hasAnyValue() const
{
    if (d->container.has_value()) {
        return true;
    }
    if (d->horizontal.has_value()) {
        return true;
    }
    if (d->vertical.has_value()) {
        return true;
    }
    if (d->order.has_value()) {
        return true;
    }
    return false;
}

void AlignmentProperty::resolveProperties(const AlignmentProperty &source, AlignmentProperty &destination)
{
    if (!destination.d->container.has_value()) {
        destination.d->container = source.d->container;
    }
    if (!destination.d->horizontal.has_value()) {
        destination.d->horizontal = source.d->horizontal;
    }
    if (!destination.d->vertical.has_value()) {
        destination.d->vertical = source.d->vertical;
    }
    if (!destination.d->order.has_value()) {
        destination.d->order = source.d->order;
    }
}

AlignmentProperty AlignmentProperty::empty()
{
    AlignmentProperty result;
    result.d->container = emptyValue<Union::Properties::AlignmentContainer>();
    result.d->horizontal = emptyValue<Union::Properties::Alignment>();
    result.d->vertical = emptyValue<Union::Properties::Alignment>();
    result.d->order = emptyValue<int>();
    return result;
}

bool Union::Properties::operator==(const AlignmentProperty &left, const AlignmentProperty &right)
{
    if (left.container() != right.container()) {
        return false;
    }
    if (left.horizontal() != right.horizontal()) {
        return false;
    }
    if (left.vertical() != right.vertical()) {
        return false;
    }
    if (left.order() != right.order()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::AlignmentProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "AlignmentProperty(" //
                    << "container: " << type.container() //
                    << ", horizontal: " << type.horizontal() //
                    << ", vertical: " << type.vertical() //
                    << ", order: " << type.order() //
                    << ")";
    return debug;
}