// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off
#include <QJSValue>
#include <QObject>
#include <QProperty>
#include <qqmlregistration.h>


#include <properties/ImageProperty.h>

// clang-format on

class QuickStyle;

/*!
 * \qmltype ImagePropertyGroup
 * \inqmlmodule org.kde.union.impl
 * \ingroup qtquick-properties
 *
 * \brief A group object exposing the properties of ImageProperty to QML.
 */
class ImagePropertyGroup : public QObject
{
    Q_OBJECT
    QML_ANONYMOUS

public:
    explicit ImagePropertyGroup(QuickStyle *style);

    void update(const std::optional<Union::Properties::ImageProperty> &newState);
    Q_SIGNAL void updated();

    /*!
     * \qmlproperty QImage ImagePropertyGroup::imageData
     *
     * Exposes ImageProperty::imageData to QML.
     */
    Q_PROPERTY(QJSValue imageData READ imageData NOTIFY imageDataChanged)
    QJSValue imageData() const;
    Q_SIGNAL void imageDataChanged();

    /*!
     * \qmlproperty qreal ImagePropertyGroup::width
     *
     * Exposes ImageProperty::width to QML.
     */
    Q_PROPERTY(QJSValue width READ width NOTIFY widthChanged)
    QJSValue width() const;
    Q_SIGNAL void widthChanged();

    /*!
     * \qmlproperty qreal ImagePropertyGroup::height
     *
     * Exposes ImageProperty::height to QML.
     */
    Q_PROPERTY(QJSValue height READ height NOTIFY heightChanged)
    QJSValue height() const;
    Q_SIGNAL void heightChanged();

    /*!
     * \qmlproperty qreal ImagePropertyGroup::xOffset
     *
     * Exposes ImageProperty::xOffset to QML.
     */
    Q_PROPERTY(QJSValue xOffset READ xOffset NOTIFY xOffsetChanged)
    QJSValue xOffset() const;
    Q_SIGNAL void xOffsetChanged();

    /*!
     * \qmlproperty qreal ImagePropertyGroup::yOffset
     *
     * Exposes ImageProperty::yOffset to QML.
     */
    Q_PROPERTY(QJSValue yOffset READ yOffset NOTIFY yOffsetChanged)
    QJSValue yOffset() const;
    Q_SIGNAL void yOffsetChanged();

    /*!
     * \qmlproperty Union::Properties::ImageFlags ImagePropertyGroup::flags
     *
     * Exposes ImageProperty::flags to QML.
     */
    Q_PROPERTY(QJSValue flags READ flags NOTIFY flagsChanged)
    QJSValue flags() const;
    Q_SIGNAL void flagsChanged();

private:
    QuickStyle *m_style = nullptr;

    inline static std::optional<Union::Properties::ImageProperty> nullValue = std::nullopt;
    std::optional<Union::Properties::ImageProperty> &m_state = nullValue;
};