/*
 * Copyright 2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_rfnoc_tx_radio = R"doc(RFNoC TX Radio


This wraps a radio block into GNU Radio. Note: When doing TX and RX in the same flow graph, simply create an rfnoc_rx_radio and an rfnoc_tx_radio with the same block ID.

Constructor Specific Documentation:



Args:
    graph : Reference to the underlying rfnoc_graph object
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_rfnoc_tx_radio_0 = R"doc()doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_rfnoc_tx_radio_1 = R"doc()doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_make = R"doc(RFNoC TX Radio


This wraps a radio block into GNU Radio. Note: When doing TX and RX in the same flow graph, simply create an rfnoc_rx_radio and an rfnoc_tx_radio with the same block ID.

Constructor Specific Documentation:



Args:
    graph : Reference to the underlying rfnoc_graph object
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_rate = R"doc(Set the input sampling rate of the radio block.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_antenna = R"doc(Set the antenna for this radio.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_frequency = R"doc(Set the TX frequency for this radio.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_tune_args = R"doc(Configure the tune args for this RX radio.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_gain_0 = R"doc()doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_gain_1 = R"doc()doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_gain_profile = R"doc(Switch the gain profile for this RX radio.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_bandwidth = R"doc(Set the analog bandwidth for this RX radio.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_lo_source = R"doc(Set the LO source for this TX radio.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_lo_export_enabled = R"doc(Enable/disable LO export for this TX radio.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_lo_freq = R"doc(Configure the LO frequency explicitly.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_dc_offset = R"doc(Set the DC offset value explicitly.)doc";


static const char* __doc_gr_uhd_rfnoc_tx_radio_set_iq_balance = R"doc(Set the I/Q imbalance correction value explicitly.)doc";
