/* imap-engine-empty-folder.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-engine-empty-folder.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION (geary_imap_engine_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))

typedef struct _GearyImapEngineReplayOperation GearyImapEngineReplayOperation;
typedef struct _GearyImapEngineReplayOperationClass GearyImapEngineReplayOperationClass;
typedef struct _GearyImapEngineReplayOperationPrivate GearyImapEngineReplayOperationPrivate;

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE
} GearyImapEngineReplayOperationStatus;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_STATUS (geary_imap_engine_replay_operation_status_get_type ())

#define GEARY_IMAP_TYPE_FOLDER_SESSION (geary_imap_folder_session_get_type ())
#define GEARY_IMAP_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSession))
#define GEARY_IMAP_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))
#define GEARY_IMAP_IS_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_IS_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_FOLDER_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))

typedef struct _GearyImapFolderSession GearyImapFolderSession;
typedef struct _GearyImapFolderSessionClass GearyImapFolderSessionClass;

#define GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION (geary_imap_engine_send_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_SEND_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, GearyImapEngineSendReplayOperation))
#define GEARY_IMAP_ENGINE_SEND_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, GearyImapEngineSendReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_SEND_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_SEND_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_SEND_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, GearyImapEngineSendReplayOperationClass))

typedef struct _GearyImapEngineSendReplayOperation GearyImapEngineSendReplayOperation;
typedef struct _GearyImapEngineSendReplayOperationClass GearyImapEngineSendReplayOperationClass;
typedef struct _GearyImapEngineSendReplayOperationPrivate GearyImapEngineSendReplayOperationPrivate;

#define GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER (geary_imap_engine_empty_folder_get_type ())
#define GEARY_IMAP_ENGINE_EMPTY_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, GearyImapEngineEmptyFolder))
#define GEARY_IMAP_ENGINE_EMPTY_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, GearyImapEngineEmptyFolderClass))
#define GEARY_IMAP_ENGINE_IS_EMPTY_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER))
#define GEARY_IMAP_ENGINE_IS_EMPTY_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER))
#define GEARY_IMAP_ENGINE_EMPTY_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, GearyImapEngineEmptyFolderClass))

typedef struct _GearyImapEngineEmptyFolder GearyImapEngineEmptyFolder;
typedef struct _GearyImapEngineEmptyFolderClass GearyImapEngineEmptyFolderClass;
typedef struct _GearyImapEngineEmptyFolderPrivate GearyImapEngineEmptyFolderPrivate;

#define GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER (geary_imap_engine_minimal_folder_get_type ())
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))

typedef struct _GearyImapEngineMinimalFolder GearyImapEngineMinimalFolder;
typedef struct _GearyImapEngineMinimalFolderClass GearyImapEngineMinimalFolderClass;
enum  {
	GEARY_IMAP_ENGINE_EMPTY_FOLDER_0_PROPERTY,
	GEARY_IMAP_ENGINE_EMPTY_FOLDER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_empty_folder_properties[GEARY_IMAP_ENGINE_EMPTY_FOLDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_THROW,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE
} GearyImapEngineReplayOperationOnError;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_ON_ERROR (geary_imap_engine_replay_operation_on_error_get_type ())

#define GEARY_IMAP_DB_TYPE_FOLDER (geary_imap_db_folder_get_type ())
#define GEARY_IMAP_DB_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolder))
#define GEARY_IMAP_DB_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))
#define GEARY_IMAP_DB_IS_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_IS_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))

typedef struct _GearyImapDBFolder GearyImapDBFolder;
typedef struct _GearyImapDBFolderClass GearyImapDBFolderClass;
typedef struct _GearyImapEngineEmptyFolderReplayLocalAsyncData GearyImapEngineEmptyFolderReplayLocalAsyncData;
typedef struct _GearyImapEngineEmptyFolderReplayRemoteAsyncData GearyImapEngineEmptyFolderReplayRemoteAsyncData;
typedef struct _GearyImapEngineEmptyFolderBackoutLocalAsyncData GearyImapEngineEmptyFolderBackoutLocalAsyncData;

struct _GearyImapEngineReplayOperation {
	GearyBaseObject parent_instance;
	GearyImapEngineReplayOperationPrivate * priv;
};

struct _GearyImapEngineReplayOperationClass {
	GearyBaseObjectClass parent_class;
	void (*notify_remote_removed_position) (GearyImapEngineReplayOperation* self, GearyImapSequenceNumber* removed);
	void (*notify_remote_removed_ids) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*get_ids_to_be_remote_removed) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*replay_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GearyImapEngineReplayOperationStatus (*replay_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*replay_remote_async) (GearyImapEngineReplayOperation* self, GearyImapFolderSession* remote, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*replay_remote_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*backout_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*backout_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	gchar* (*describe_state) (GearyImapEngineReplayOperation* self);
};

struct _GearyImapEngineSendReplayOperation {
	GearyImapEngineReplayOperation parent_instance;
	GearyImapEngineSendReplayOperationPrivate * priv;
};

struct _GearyImapEngineSendReplayOperationClass {
	GearyImapEngineReplayOperationClass parent_class;
};

struct _GearyImapEngineEmptyFolder {
	GearyImapEngineSendReplayOperation parent_instance;
	GearyImapEngineEmptyFolderPrivate * priv;
};

struct _GearyImapEngineEmptyFolderClass {
	GearyImapEngineSendReplayOperationClass parent_class;
};

struct _GearyImapEngineEmptyFolderPrivate {
	GearyImapEngineMinimalFolder* engine;
	GCancellable* cancellable;
	GeeSet* removed_ids;
	gint original_count;
};

struct _GearyImapEngineEmptyFolderReplayLocalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineEmptyFolder* self;
	GearyImapEngineReplayOperationStatus result;
	GearyImapEngineMinimalFolder* _tmp0_;
	GearyFolderProperties* _tmp1_;
	GearyFolderProperties* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeSet* _tmp5_;
	GearyImapEngineMinimalFolder* _tmp6_;
	GearyImapDBFolder* _tmp7_;
	GearyImapDBFolder* _tmp8_;
	GCancellable* _tmp9_;
	GeeSet* _tmp10_;
	GeeSet* _tmp11_;
	GeeSet* _tmp12_;
	GeeSet* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GearyImapEngineMinimalFolder* _tmp16_;
	GeeSet* _tmp17_;
	gint new_count;
	GeeSet* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GearyImapEngineMinimalFolder* _tmp21_;
	GError* _inner_error0_;
};

struct _GearyImapEngineEmptyFolderReplayRemoteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineEmptyFolder* self;
	GearyImapFolderSession* remote;
	GearyImapMessageSet* msg_set;
	GearyImapSequenceNumber* _tmp0_;
	GearyImapSequenceNumber* _tmp1_;
	GearyImapMessageSet* _tmp2_;
	GearyImapMessageSet* _tmp3_;
	GeeList* _tmp4_;
	GeeList* _tmp5_;
	GCancellable* _tmp6_;
	GError* _inner_error0_;
};

struct _GearyImapEngineEmptyFolderBackoutLocalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineEmptyFolder* self;
	gboolean _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GearyImapEngineMinimalFolder* _tmp5_;
	GearyImapDBFolder* _tmp6_;
	GearyImapDBFolder* _tmp7_;
	GeeSet* _tmp8_;
	GCancellable* _tmp9_;
	GeeSet* _tmp10_;
	GeeSet* _tmp11_;
	GearyImapEngineMinimalFolder* _tmp12_;
	GeeSet* _tmp13_;
	GearyImapEngineMinimalFolder* _tmp14_;
	GError* _inner_error0_;
};

static gint GearyImapEngineEmptyFolder_private_offset;
static gpointer geary_imap_engine_empty_folder_parent_class = NULL;

VALA_EXTERN GType geary_imap_engine_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_folder_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_send_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_empty_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_minimal_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_engine_replay_operation_replay_local_async (GearyImapEngineReplayOperation* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
VALA_EXTERN GearyImapEngineReplayOperationStatus geary_imap_engine_replay_operation_replay_local_finish (GearyImapEngineReplayOperation* self,
                                                                                             GAsyncResult* _res_,
                                                                                             GError** error);
VALA_EXTERN void geary_imap_engine_replay_operation_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* self,
                                                                      GeeCollection* ids);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
VALA_EXTERN void geary_imap_engine_replay_operation_backout_local_async (GearyImapEngineReplayOperation* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_backout_local_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_describe_state (GearyImapEngineReplayOperation* self);
VALA_EXTERN GearyImapEngineEmptyFolder* geary_imap_engine_empty_folder_new (GearyImapEngineMinimalFolder* engine,
                                                                GCancellable* cancellable);
VALA_EXTERN GearyImapEngineEmptyFolder* geary_imap_engine_empty_folder_construct (GType object_type,
                                                                      GearyImapEngineMinimalFolder* engine,
                                                                      GCancellable* cancellable);
VALA_EXTERN GType geary_imap_engine_replay_operation_on_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineSendReplayOperation* geary_imap_engine_send_replay_operation_construct (GType object_type,
                                                                                       const gchar* name,
                                                                                       GearyImapEngineReplayOperationOnError on_remote_error);
static void geary_imap_engine_empty_folder_real_replay_local_async_data_free (gpointer _data);
static void geary_imap_engine_empty_folder_real_replay_local_async (GearyImapEngineReplayOperation* base,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean geary_imap_engine_empty_folder_real_replay_local_async_co (GearyImapEngineEmptyFolderReplayLocalAsyncData* _data_);
VALA_EXTERN GType geary_imap_db_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapDBFolder* geary_imap_engine_minimal_folder_get_local_folder (GearyImapEngineMinimalFolder* self);
VALA_EXTERN void geary_imap_db_folder_mark_removed_async (GearyImapDBFolder* self,
                                              GeeCollection* ids,
                                              gboolean mark_removed,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN GeeSet* geary_imap_db_folder_mark_removed_finish (GearyImapDBFolder* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static void geary_imap_engine_empty_folder_replay_local_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_minimal_folder_replay_notify_email_removed (GearyImapEngineMinimalFolder* self,
                                                                   GeeCollection* ids);
VALA_EXTERN void geary_imap_engine_minimal_folder_replay_notify_email_count_changed (GearyImapEngineMinimalFolder* self,
                                                                         gint new_count,
                                                                         GearyFolderCountChangeReason reason);
static void geary_imap_engine_empty_folder_real_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* base,
                                                                       GeeCollection* ids);
static void geary_imap_engine_empty_folder_real_replay_remote_async_data_free (gpointer _data);
static void geary_imap_engine_empty_folder_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                              GearyImapFolderSession* remote,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean geary_imap_engine_empty_folder_real_replay_remote_async_co (GearyImapEngineEmptyFolderReplayRemoteAsyncData* _data_);
VALA_EXTERN void geary_imap_folder_session_remove_email_async (GearyImapFolderSession* self,
                                                   GeeList* msg_sets,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void geary_imap_folder_session_remove_email_finish (GearyImapFolderSession* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void geary_imap_engine_empty_folder_replay_remote_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void geary_imap_engine_empty_folder_real_backout_local_async_data_free (gpointer _data);
static void geary_imap_engine_empty_folder_real_backout_local_async (GearyImapEngineReplayOperation* base,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean geary_imap_engine_empty_folder_real_backout_local_async_co (GearyImapEngineEmptyFolderBackoutLocalAsyncData* _data_);
static void geary_imap_engine_empty_folder_backout_local_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_minimal_folder_replay_notify_email_inserted (GearyImapEngineMinimalFolder* self,
                                                                    GeeCollection* ids);
static gchar* geary_imap_engine_empty_folder_real_describe_state (GearyImapEngineReplayOperation* base);
static void geary_imap_engine_empty_folder_finalize (GObject * obj);
static GType geary_imap_engine_empty_folder_get_type_once (void);

static inline gpointer
geary_imap_engine_empty_folder_get_instance_private (GearyImapEngineEmptyFolder* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineEmptyFolder_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapEngineEmptyFolder*
geary_imap_engine_empty_folder_construct (GType object_type,
                                          GearyImapEngineMinimalFolder* engine,
                                          GCancellable* cancellable)
{
	GearyImapEngineEmptyFolder * self = NULL;
	GearyImapEngineMinimalFolder* _tmp0_;
	GCancellable* _tmp1_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER (engine), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyImapEngineEmptyFolder*) geary_imap_engine_send_replay_operation_construct (object_type, "EmptyFolder", GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY);
	_tmp0_ = _g_object_ref0 (engine);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	return self;
}

GearyImapEngineEmptyFolder*
geary_imap_engine_empty_folder_new (GearyImapEngineMinimalFolder* engine,
                                    GCancellable* cancellable)
{
	return geary_imap_engine_empty_folder_construct (GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, engine, cancellable);
}

static void
geary_imap_engine_empty_folder_real_replay_local_async_data_free (gpointer _data)
{
	GearyImapEngineEmptyFolderReplayLocalAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineEmptyFolderReplayLocalAsyncData, _data_);
}

static void
geary_imap_engine_empty_folder_real_replay_local_async (GearyImapEngineReplayOperation* base,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearyImapEngineEmptyFolder * self;
	GearyImapEngineEmptyFolderReplayLocalAsyncData* _data_;
	GearyImapEngineEmptyFolder* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, GearyImapEngineEmptyFolder);
	_data_ = g_slice_new0 (GearyImapEngineEmptyFolderReplayLocalAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_empty_folder_real_replay_local_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_engine_empty_folder_real_replay_local_async_co (_data_);
}

static GearyImapEngineReplayOperationStatus
geary_imap_engine_empty_folder_replay_local_finish (GearyImapEngineReplayOperation* base,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	GearyImapEngineReplayOperationStatus result;
	GearyImapEngineEmptyFolderReplayLocalAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return 0;
	}
	result = _data_->result;
	return result;
}

static void
geary_imap_engine_empty_folder_replay_local_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GearyImapEngineEmptyFolderReplayLocalAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_empty_folder_real_replay_local_async_co (_data_);
}

static gboolean
geary_imap_engine_empty_folder_real_replay_local_async_co (GearyImapEngineEmptyFolderReplayLocalAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->engine;
	_data_->_tmp1_ = geary_folder_get_properties (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_TYPE_FOLDER, GearyFolder));
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = geary_folder_properties_get_email_total (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->self->priv->original_count = _data_->_tmp4_;
	if (_data_->self->priv->original_count < 0) {
		_data_->self->priv->original_count = 0;
	}
	_data_->_tmp6_ = _data_->self->priv->engine;
	_data_->_tmp7_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->self->priv->cancellable;
	_data_->_state_ = 1;
	geary_imap_db_folder_mark_removed_async (_data_->_tmp8_, NULL, TRUE, _data_->_tmp9_, geary_imap_engine_empty_folder_replay_local_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp10_ = geary_imap_db_folder_mark_removed_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp5_ = _data_->_tmp10_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->_tmp5_;
	_data_->_tmp5_ = NULL;
	_g_object_unref0 (_data_->self->priv->removed_ids);
	_data_->self->priv->removed_ids = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->self->priv->removed_ids;
	if (_data_->_tmp12_ != NULL) {
		_data_->_tmp13_ = _data_->self->priv->removed_ids;
		_data_->_tmp14_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp15_ = _data_->_tmp14_;
		if (_data_->_tmp15_ > 0) {
			_data_->_tmp16_ = _data_->self->priv->engine;
			_data_->_tmp17_ = _data_->self->priv->removed_ids;
			geary_imap_engine_minimal_folder_replay_notify_email_removed (_data_->_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
		}
		_data_->_tmp18_ = _data_->self->priv->removed_ids;
		_data_->_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->new_count = geary_numeric_int_floor (_data_->self->priv->original_count - _data_->_tmp20_, 0);
		if (_data_->new_count != _data_->self->priv->original_count) {
			_data_->_tmp21_ = _data_->self->priv->engine;
			geary_imap_engine_minimal_folder_replay_notify_email_count_changed (_data_->_tmp21_, _data_->new_count, GEARY_FOLDER_COUNT_CHANGE_REASON_REMOVED);
		}
		_data_->result = GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE;
		_g_object_unref0 (_data_->_tmp5_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED;
	_g_object_unref0 (_data_->_tmp5_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_empty_folder_real_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* base,
                                                                  GeeCollection* ids)
{
	GearyImapEngineEmptyFolder * self;
	GeeSet* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, GearyImapEngineEmptyFolder);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->removed_ids;
	if (_tmp0_ != NULL) {
		GeeSet* _tmp1_;
		_tmp1_ = self->priv->removed_ids;
		gee_collection_add_all (ids, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	}
}

static void
geary_imap_engine_empty_folder_real_replay_remote_async_data_free (gpointer _data)
{
	GearyImapEngineEmptyFolderReplayRemoteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineEmptyFolderReplayRemoteAsyncData, _data_);
}

static void
geary_imap_engine_empty_folder_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                         GearyImapFolderSession* remote,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearyImapEngineEmptyFolder * self;
	GearyImapEngineEmptyFolderReplayRemoteAsyncData* _data_;
	GearyImapEngineEmptyFolder* _tmp0_;
	GearyImapFolderSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_SESSION (remote));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, GearyImapEngineEmptyFolder);
	_data_ = g_slice_new0 (GearyImapEngineEmptyFolderReplayRemoteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_empty_folder_real_replay_remote_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	geary_imap_engine_empty_folder_real_replay_remote_async_co (_data_);
}

static void
geary_imap_engine_empty_folder_replay_remote_finish (GearyImapEngineReplayOperation* base,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	GearyImapEngineEmptyFolderReplayRemoteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_empty_folder_replay_remote_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	GearyImapEngineEmptyFolderReplayRemoteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_empty_folder_real_replay_remote_async_co (_data_);
}

static gboolean
geary_imap_engine_empty_folder_real_replay_remote_async_co (GearyImapEngineEmptyFolderReplayRemoteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_imap_sequence_number_new (GEARY_IMAP_SEQUENCE_NUMBER_MIN);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_imap_message_set_new_range_to_highest (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->msg_set = _data_->_tmp3_;
	_data_->_tmp4_ = geary_imap_message_set_to_list (_data_->msg_set);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->self->priv->cancellable;
	_data_->_state_ = 1;
	geary_imap_folder_session_remove_email_async (_data_->remote, _data_->_tmp5_, _data_->_tmp6_, geary_imap_engine_empty_folder_replay_remote_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_folder_session_remove_email_finish (_data_->remote, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp5_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->msg_set);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->msg_set);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_empty_folder_real_backout_local_async_data_free (gpointer _data)
{
	GearyImapEngineEmptyFolderBackoutLocalAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineEmptyFolderBackoutLocalAsyncData, _data_);
}

static void
geary_imap_engine_empty_folder_real_backout_local_async (GearyImapEngineReplayOperation* base,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearyImapEngineEmptyFolder * self;
	GearyImapEngineEmptyFolderBackoutLocalAsyncData* _data_;
	GearyImapEngineEmptyFolder* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, GearyImapEngineEmptyFolder);
	_data_ = g_slice_new0 (GearyImapEngineEmptyFolderBackoutLocalAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_empty_folder_real_backout_local_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_engine_empty_folder_real_backout_local_async_co (_data_);
}

static void
geary_imap_engine_empty_folder_backout_local_finish (GearyImapEngineReplayOperation* base,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	GearyImapEngineEmptyFolderBackoutLocalAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_empty_folder_backout_local_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	GearyImapEngineEmptyFolderBackoutLocalAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_empty_folder_real_backout_local_async_co (_data_);
}

static gboolean
geary_imap_engine_empty_folder_real_backout_local_async_co (GearyImapEngineEmptyFolderBackoutLocalAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->removed_ids;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->removed_ids;
		_data_->_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = _data_->_tmp4_ > 0;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp5_ = _data_->self->priv->engine;
		_data_->_tmp6_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->self->priv->removed_ids;
		_data_->_tmp9_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		geary_imap_db_folder_mark_removed_async (_data_->_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), FALSE, _data_->_tmp9_, geary_imap_engine_empty_folder_backout_local_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp10_ = geary_imap_db_folder_mark_removed_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_object_unref0 (_data_->_tmp11_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp12_ = _data_->self->priv->engine;
		_data_->_tmp13_ = _data_->self->priv->removed_ids;
		geary_imap_engine_minimal_folder_replay_notify_email_inserted (_data_->_tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEE_TYPE_COLLECTION, GeeCollection));
	}
	_data_->_tmp14_ = _data_->self->priv->engine;
	geary_imap_engine_minimal_folder_replay_notify_email_count_changed (_data_->_tmp14_, _data_->self->priv->original_count, GEARY_FOLDER_COUNT_CHANGE_REASON_INSERTED);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
geary_imap_engine_empty_folder_real_describe_state (GearyImapEngineReplayOperation* base)
{
	GearyImapEngineEmptyFolder * self;
	gint _tmp0_ = 0;
	GeeSet* _tmp1_;
	gchar* _tmp5_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, GearyImapEngineEmptyFolder);
	_tmp1_ = self->priv->removed_ids;
	if (_tmp1_ != NULL) {
		GeeSet* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->removed_ids;
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0;
	}
	_tmp5_ = g_strdup_printf ("removed_ids.size=%d", _tmp0_);
	result = _tmp5_;
	return result;
}

static void
geary_imap_engine_empty_folder_class_init (GearyImapEngineEmptyFolderClass * klass,
                                           gpointer klass_data)
{
	geary_imap_engine_empty_folder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineEmptyFolder_private_offset);
	((GearyImapEngineReplayOperationClass *) klass)->replay_local_async = (void (*) (GearyImapEngineReplayOperation*, GAsyncReadyCallback, gpointer)) geary_imap_engine_empty_folder_real_replay_local_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_local_finish = (GearyImapEngineReplayOperationStatus (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_empty_folder_replay_local_finish;
	((GearyImapEngineReplayOperationClass *) klass)->get_ids_to_be_remote_removed = (void (*) (GearyImapEngineReplayOperation*, GeeCollection*)) geary_imap_engine_empty_folder_real_get_ids_to_be_remote_removed;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_async = (void (*) (GearyImapEngineReplayOperation*, GearyImapFolderSession*, GAsyncReadyCallback, gpointer)) geary_imap_engine_empty_folder_real_replay_remote_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_finish = (void (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_empty_folder_replay_remote_finish;
	((GearyImapEngineReplayOperationClass *) klass)->backout_local_async = (void (*) (GearyImapEngineReplayOperation*, GAsyncReadyCallback, gpointer)) geary_imap_engine_empty_folder_real_backout_local_async;
	((GearyImapEngineReplayOperationClass *) klass)->backout_local_finish = (void (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_empty_folder_backout_local_finish;
	((GearyImapEngineReplayOperationClass *) klass)->describe_state = (gchar* (*) (GearyImapEngineReplayOperation*)) geary_imap_engine_empty_folder_real_describe_state;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_empty_folder_finalize;
}

static void
geary_imap_engine_empty_folder_instance_init (GearyImapEngineEmptyFolder * self,
                                              gpointer klass)
{
	self->priv = geary_imap_engine_empty_folder_get_instance_private (self);
	self->priv->removed_ids = NULL;
	self->priv->original_count = 0;
}

static void
geary_imap_engine_empty_folder_finalize (GObject * obj)
{
	GearyImapEngineEmptyFolder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_EMPTY_FOLDER, GearyImapEngineEmptyFolder);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->removed_ids);
	G_OBJECT_CLASS (geary_imap_engine_empty_folder_parent_class)->finalize (obj);
}

/**
 * Similar to RemoveEmail, except this command ''always'' issues the command to remove all mail,
 * ensuring the entire folder is emptied even if only a portion of it is synchronized locally.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_engine_empty_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineEmptyFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_empty_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineEmptyFolder), 0, (GInstanceInitFunc) geary_imap_engine_empty_folder_instance_init, NULL };
	GType geary_imap_engine_empty_folder_type_id;
	geary_imap_engine_empty_folder_type_id = g_type_register_static (GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, "GearyImapEngineEmptyFolder", &g_define_type_info, 0);
	GearyImapEngineEmptyFolder_private_offset = g_type_add_instance_private (geary_imap_engine_empty_folder_type_id, sizeof (GearyImapEngineEmptyFolderPrivate));
	return geary_imap_engine_empty_folder_type_id;
}

GType
geary_imap_engine_empty_folder_get_type (void)
{
	static gsize geary_imap_engine_empty_folder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_empty_folder_type_id__once)) {
		GType geary_imap_engine_empty_folder_type_id;
		geary_imap_engine_empty_folder_type_id = geary_imap_engine_empty_folder_get_type_once ();
		g_once_init_leave (&geary_imap_engine_empty_folder_type_id__once, geary_imap_engine_empty_folder_type_id);
	}
	return geary_imap_engine_empty_folder_type_id__once;
}

