#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_XKB_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_XKB_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-xkb", _Xkb_)

static void*
__fcitx_Xkb_function_GetRules(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxXkb*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxXkb* self = __self;
    FCITX_UNUSED(self);
    FcitxXkbRules* res = ((self)->rules);
    FCITX_RETURN_AS_PTR(FcitxXkbRules*, res);
}

static void*
__fcitx_Xkb_function_GetCurrentLayout(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxXkb*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(char**, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(char**, arg1, _args.args[1]);
    FcitxXkb* self = __self;
    FCITX_UNUSED(self);
    FcitxXkbGetCurrentLayoutInternal(self, arg0, arg1);
    return NULL;
}

static void*
__fcitx_Xkb_function_LayoutExists(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxXkb*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(boolean*, arg2, _args.args[2]);
    FcitxXkb* self = __self;
    FCITX_UNUSED(self);
    *(arg2) = (FcitxXkbFindLayoutIndex((self), (arg0), (arg1)) >= 0);
    return NULL;
}

static void*
__fcitx_Xkb_function_GetLayoutOverride(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxXkb*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(char**, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(char**, arg2, _args.args[2]);
    FcitxXkb* self = __self;
    FCITX_UNUSED(self);
    FcitxXkbGetLayoutOverride(self, arg0, arg1, arg2);
    return NULL;
}

static void*
__fcitx_Xkb_function_SetLayoutOverride(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxXkb*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg2, _args.args[2]);
    FcitxXkb* self = __self;
    FCITX_UNUSED(self);
    FcitxXkbSetLayoutOverride(self, arg0, arg1, arg2);
    return NULL;
}

static void*
__fcitx_Xkb_function_SetDefaultLayout(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxXkb*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FcitxXkb* self = __self;
    FCITX_UNUSED(self);
    FcitxXkbSetDefaultLayout(self, arg0, arg1);
    return NULL;
}

static void
FcitxXkbAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_Xkb_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_Xkb_addon_functions_table[] = {
        __fcitx_Xkb_function_GetRules,
        __fcitx_Xkb_function_GetCurrentLayout,
        __fcitx_Xkb_function_LayoutExists,
        __fcitx_Xkb_function_GetLayoutOverride,
        __fcitx_Xkb_function_SetLayoutOverride,
        __fcitx_Xkb_function_SetDefaultLayout,
    };
    for (i = 0;i < 6;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_Xkb_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
