/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LastUnchangedContentTracker {
    private static final Logger LOG = Logger.getInstance(LastUnchangedContentTracker.class);
    private static final Key<Long> LAST_TS_KEY = Key.create((String)"LAST_TS_KEY");
    private static final FileAttribute LAST_TS_ATTR = new FileAttribute("LAST_TS_ATTR", 0, true);
    private static final FileAttribute ACQUIRED_CONTENT_ATTR = new FileAttribute("ACQUIRED_CONTENT_ATTR", 1, true);
    private static final Key<Boolean> VCS_INVALID_FILE_STATUS = Key.create((String)"VCS_INVALID_FILE_STATUS");

    public static void updateLastUnchangedContent(@NotNull VirtualFile file) {
        if (file == null) {
            LastUnchangedContentTracker.$$$reportNull$$$0(0);
        }
        if (LastUnchangedContentTracker.isTouched(file)) {
            return;
        }
        Long lastTs = LastUnchangedContentTracker.getLastSavedStamp(file);
        long stamp = file.getTimeStamp();
        if (lastTs != null && stamp == lastTs) {
            return;
        }
        Integer oldContentId = LastUnchangedContentTracker.getSavedContentId(file);
        if (oldContentId != null && oldContentId > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("releasing content for " + String.valueOf(file) + ", id = " + oldContentId);
            }
            LastUnchangedContentTracker.getFS().releaseContent(oldContentId.intValue());
        }
        LastUnchangedContentTracker.saveContentReference(file, LastUnchangedContentTracker.getFS().acquireContent(file));
        LastUnchangedContentTracker.markTouched(file);
    }

    private static boolean isTouched(VirtualFile file) {
        return Boolean.TRUE.equals(file.getUserData(VCS_INVALID_FILE_STATUS));
    }

    public static void markTouched(VirtualFile file) {
        file.putUserData(VCS_INVALID_FILE_STATUS, (Object)Boolean.TRUE);
    }

    public static void markUntouched(VirtualFile file) {
        file.putUserData(VCS_INVALID_FILE_STATUS, null);
    }

    public static byte @Nullable [] getLastUnchangedContent(@NotNull VirtualFile file) {
        if (file == null) {
            LastUnchangedContentTracker.$$$reportNull$$$0(1);
        }
        Integer id = LastUnchangedContentTracker.getSavedContentId(file);
        try {
            return id == null ? null : LastUnchangedContentTracker.getFS().contentsToByteArray(id.intValue());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    private static PersistentFS getFS() {
        return (PersistentFS)ManagingFS.getInstance();
    }

    private static void saveContentReference(VirtualFile file, int contentId) {
        if (contentId == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("saveContentReference without content for file = " + String.valueOf(file));
            }
            return;
        }
        LOG.assertTrue(contentId > 0, (Object)contentId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("saveContentReference file = " + String.valueOf(file) + ", id = " + contentId);
        }
        long stamp = file.getTimeStamp();
        try {
            try (AttributeOutputStream contentStream = ACQUIRED_CONTENT_ATTR.writeFileAttribute(file);){
                contentStream.writeInt(contentId);
            }
            try (AttributeOutputStream tsStream = LAST_TS_ATTR.writeFileAttribute(file);){
                tsStream.writeLong(stamp);
            }
            file.putUserData(LAST_TS_KEY, (Object)stamp);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static boolean hasSavedContent(VirtualFile file) {
        return LastUnchangedContentTracker.getSavedContentId(file) != null;
    }

    public static void forceSavedContent(VirtualFile file, @NotNull String content) {
        if (content == null) {
            LastUnchangedContentTracker.$$$reportNull$$$0(2);
        }
        LastUnchangedContentTracker.saveContentReference(file, LastUnchangedContentTracker.getFS().storeUnlinkedContent(content.getBytes(file.getCharset())));
    }

    @Nullable
    private static Integer getSavedContentId(VirtualFile file) {
        if (!file.isValid()) {
            return null;
        }
        Integer oldContentId = null;
        try (AttributeInputStream stream = ACQUIRED_CONTENT_ATTR.readFileAttribute(file);){
            if (LOG.isDebugEnabled()) {
                LOG.debug("getSavedContentId for " + String.valueOf(file) + "; stream=" + String.valueOf(stream));
            }
            if (stream != null) {
                oldContentId = stream.readInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("oldContentId=" + oldContentId);
                }
                LOG.assertTrue(oldContentId > 0, (Object)oldContentId);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return oldContentId;
    }

    @Nullable
    private static Long getLastSavedStamp(VirtualFile file) {
        Long l = (Long)file.getUserData(LAST_TS_KEY);
        if (l == null) {
            try (AttributeInputStream stream = LAST_TS_ATTR.readFileAttribute(file);){
                if (stream != null) {
                    l = stream.readLong();
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return l;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/LastUnchangedContentTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLastUnchangedContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastUnchangedContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "forceSavedContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

