/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy;

import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;
import org.keycloak.services.clientregistration.policy.RegistrationAuth;

public class ClientRegistrationPolicyManager {
    private static final Logger logger = Logger.getLogger(ClientRegistrationPolicyManager.class);

    public static void triggerBeforeRegister(ClientRegistrationContext context, RegistrationAuth authType) throws ClientRegistrationPolicyException {
        ClientRegistrationPolicyManager.triggerPolicies(context.getSession(), context.getProvider(), authType, "before register client", policy -> policy.beforeRegister(context));
    }

    public static void triggerAfterRegister(ClientRegistrationContext context, RegistrationAuth authType, ClientModel client) {
        try {
            ClientRegistrationPolicyManager.triggerPolicies(context.getSession(), context.getProvider(), authType, "after register client " + client.getClientId(), policy -> policy.afterRegister(context, client));
        }
        catch (ClientRegistrationPolicyException crpe) {
            throw new IllegalStateException(crpe);
        }
    }

    public static void triggerBeforeUpdate(ClientRegistrationContext context, RegistrationAuth authType, ClientModel client) throws ClientRegistrationPolicyException {
        ClientRegistrationPolicyManager.triggerPolicies(context.getSession(), context.getProvider(), authType, "before update client " + client.getClientId(), policy -> policy.beforeUpdate(context, client));
    }

    public static void triggerAfterUpdate(ClientRegistrationContext context, RegistrationAuth authType, ClientModel client) {
        try {
            ClientRegistrationPolicyManager.triggerPolicies(context.getSession(), context.getProvider(), authType, "after update client " + client.getClientId(), policy -> policy.afterUpdate(context, client));
        }
        catch (ClientRegistrationPolicyException crpe) {
            throw new IllegalStateException(crpe);
        }
    }

    public static void triggerBeforeView(KeycloakSession session, ClientRegistrationProvider provider, RegistrationAuth authType, ClientModel client) throws ClientRegistrationPolicyException {
        ClientRegistrationPolicyManager.triggerPolicies(session, provider, authType, "before view client " + client.getClientId(), policy -> policy.beforeView(provider, client));
    }

    public static void triggerBeforeRemove(KeycloakSession session, ClientRegistrationProvider provider, RegistrationAuth authType, ClientModel client) throws ClientRegistrationPolicyException {
        ClientRegistrationPolicyManager.triggerPolicies(session, provider, authType, "before delete client " + client.getClientId(), policy -> policy.beforeDelete(provider, client));
    }

    private static void triggerPolicies(KeycloakSession session, ClientRegistrationProvider provider, RegistrationAuth authType, String opDescription, ClientRegOperation op) throws ClientRegistrationPolicyException {
        RealmModel realm = session.getContext().getRealm();
        String policyTypeKey = ClientRegistrationPolicyManager.getComponentTypeKey(authType);
        realm.getComponentsStream(realm.getId(), ClientRegistrationPolicy.class.getName()).filter(componentModel -> Objects.equals(componentModel.getSubType(), policyTypeKey)).forEach(policyModel -> ClientRegistrationPolicyManager.runPolicy(policyModel, session, provider, opDescription, op));
    }

    private static void runPolicy(ComponentModel policyModel, KeycloakSession session, ClientRegistrationProvider provider, String opDescription, ClientRegOperation op) throws ClientRegistrationPolicyException {
        ClientRegistrationPolicy policy = (ClientRegistrationPolicy)session.getProvider(ClientRegistrationPolicy.class, policyModel);
        if (policy == null) {
            throw new ClientRegistrationPolicyException("Policy of type '" + policyModel.getProviderId() + "' not found");
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Running policy '%s' %s", (Object)policyModel.getName(), (Object)opDescription);
        }
        try {
            op.run(policy);
        }
        catch (ClientRegistrationPolicyException crpe) {
            provider.getEvent().detail("client_registration_policy", policyModel.getName());
            crpe.setPolicyModel(policyModel);
            ServicesLogger.LOGGER.clientRegistrationRequestRejected(opDescription, crpe.getMessage());
            throw crpe;
        }
    }

    public static String getComponentTypeKey(RegistrationAuth authType) {
        return authType.toString().toLowerCase();
    }

    private static interface ClientRegOperation {
        public void run(ClientRegistrationPolicy var1) throws ClientRegistrationPolicyException;
    }
}

