/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Cacheable;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.IdClass;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import jakarta.persistence.SecondaryTable;
import jakarta.persistence.SecondaryTables;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Checks;
import org.hibernate.annotations.ConcreteProxy;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.HQLSelect;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.annotations.QueryCacheLayout;
import org.hibernate.annotations.RowId;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLRestriction;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.SecondaryRow;
import org.hibernate.annotations.SecondaryRows;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.Synchronize;
import org.hibernate.annotations.TypeBinderType;
import org.hibernate.annotations.View;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedDiscriminatorColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CreateKeySecondPass;
import org.hibernate.boot.model.internal.DialectOverridesAnnotationHelper;
import org.hibernate.boot.model.internal.DiscriminatorColumnSecondPass;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.FkSecondPass;
import org.hibernate.boot.model.internal.IndexBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.NamedGraphCreatorJpa;
import org.hibernate.boot.model.internal.NamedGraphCreatorParsed;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.model.internal.QueryBinder;
import org.hibernate.boot.model.internal.SecondaryTableFromAnnotationSecondPass;
import org.hibernate.boot.model.internal.SecondaryTableSecondPass;
import org.hibernate.boot.model.internal.SoftDeleteHelper;
import org.hibernate.boot.model.internal.TableBinder;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.NamingStrategyHelper;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.CacheAnnotation;
import org.hibernate.boot.models.annotations.spi.CustomSqlDetails;
import org.hibernate.boot.models.annotations.spi.DialectOverrider;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jpa.event.internal.CallbackDefinitionResolver;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.SyntheticProperty;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;

public class EntityBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityBinder.class);
    private static final String NATURAL_ID_CACHE_SUFFIX = "##NaturalId";
    private final MetadataBuildingContext context;
    private String name;
    private ClassDetails annotatedClass;
    private PersistentClass persistentClass;
    private String where;
    private final Map<String, Join> secondaryTables = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableJoins = new HashMap<String, Object>();
    private final Map<String, Join> secondaryTablesFromAnnotation = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableFromAnnotationJoins = new HashMap<String, Object>();
    private final List<Filter> filters = new ArrayList<Filter>();
    private boolean ignoreIdAnnotations;
    private AccessType propertyAccessType = AccessType.DEFAULT;
    private boolean wrapIdsInEmbeddedComponents;
    private String subselect;
    private boolean isCached;
    private String cacheConcurrentStrategy;
    private String cacheRegion;
    private boolean cacheLazyProperty;
    private String naturalIdCacheRegion;
    private CacheLayout queryCacheLayout;

    private ModelsContext modelsContext() {
        return this.context.getBootstrapContext().getModelsContext();
    }

    private InFlightMetadataCollector getMetadataCollector() {
        return this.context.getMetadataCollector();
    }

    public static void bindEntityClass(ClassDetails clazzToProcess, Map<ClassDetails, InheritanceState> inheritanceStates, MetadataBuildingContext context) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Binding entity with annotated class: " + clazzToProcess.getName());
        }
        InFlightMetadataCollector collector = context.getMetadataCollector();
        ModelsContext modelsContext = context.getBootstrapContext().getModelsContext();
        InheritanceState inheritanceState = inheritanceStates.get(clazzToProcess);
        PersistentClass superEntity = EntityBinder.getSuperEntity(clazzToProcess, inheritanceStates, context, inheritanceState);
        PersistentClass persistentClass = EntityBinder.makePersistentClass(inheritanceState, superEntity, context);
        EntityBinder.checkOverrides(clazzToProcess, superEntity, modelsContext);
        EntityBinder entityBinder = new EntityBinder(clazzToProcess, persistentClass, context);
        entityBinder.bindEntity();
        entityBinder.bindSubselect();
        entityBinder.bindTables(inheritanceState, superEntity);
        entityBinder.bindCustomSql();
        entityBinder.bindSynchronize();
        entityBinder.bindFilters();
        entityBinder.handleCheckConstraints();
        PropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(clazzToProcess, persistentClass, entityBinder, context, inheritanceStates);
        entityBinder.handleInheritance(inheritanceState, superEntity, holder);
        entityBinder.handleIdentifier(holder, inheritanceStates, inheritanceState);
        if (persistentClass instanceof RootClass) {
            RootClass rootClass = (RootClass)persistentClass;
            collector.addSecondPass(new CreateKeySecondPass(rootClass));
            EntityBinder.bindSoftDelete(clazzToProcess, rootClass, context);
        }
        if (persistentClass instanceof Subclass) {
            Subclass subclass = (Subclass)persistentClass;
            assert (superEntity != null);
            superEntity.addSubclass(subclass);
        }
        collector.addEntityBinding(persistentClass);
        collector.addSecondPass(new SecondaryTableFromAnnotationSecondPass(entityBinder, holder));
        collector.addSecondPass(new SecondaryTableSecondPass(entityBinder, holder));
        collector.addSecondPass(ignored -> persistentClass.createConstraints(context));
        entityBinder.processComplementaryTableDefinitions();
        CallbackDefinitionResolver.resolveLifecycleCallbacks(clazzToProcess, persistentClass, context.getMetadataCollector());
        entityBinder.callTypeBinders(persistentClass);
    }

    private void bindTables(InheritanceState inheritanceState, PersistentClass superEntity) {
        this.handleClassTable(inheritanceState, superEntity);
        this.handleSecondaryTables();
    }

    private static void checkOverrides(ClassDetails clazzToProcess, PersistentClass superEntity, ModelsContext sourceModelContext) {
        if (superEntity != null) {
            clazzToProcess.forEachAnnotationUsage(AttributeOverride.class, sourceModelContext, usage -> EntityBinder.checkOverride(superEntity, usage.name(), clazzToProcess, AttributeOverride.class));
            clazzToProcess.forEachAnnotationUsage(AssociationOverride.class, sourceModelContext, usage -> EntityBinder.checkOverride(superEntity, usage.name(), clazzToProcess, AttributeOverride.class));
        }
    }

    private static void checkOverride(PersistentClass superEntity, String name, ClassDetails clazzToProcess, Class<?> overrideClass) {
        if (superEntity.hasProperty(StringHelper.root(name))) {
            throw new AnnotationException("Property '" + name + "' is inherited from entity '" + superEntity.getEntityName() + "' and may not be overridden using '@" + overrideClass.getSimpleName() + "' in entity subclass '" + clazzToProcess.getName() + "'");
        }
    }

    private static void bindSoftDelete(ClassDetails classDetails, RootClass rootClass, MetadataBuildingContext context) {
        SoftDelete softDelete = EntityBinder.extractSoftDelete(classDetails, context);
        if (softDelete != null) {
            SoftDeleteHelper.bindSoftDeleteIndicator(softDelete, rootClass, rootClass.getRootTable(), context);
        }
    }

    private static SoftDelete extractSoftDelete(ClassDetails classDetails, MetadataBuildingContext context) {
        ModelsContext modelsContext = context.getBootstrapContext().getModelsContext();
        SoftDelete fromClass = (SoftDelete)classDetails.getAnnotationUsage(SoftDelete.class, modelsContext);
        if (fromClass != null) {
            return fromClass;
        }
        for (ClassDetails classToCheck = classDetails.getSuperClass(); classToCheck != null; classToCheck = classToCheck.getSuperClass()) {
            SoftDelete fromSuper = (SoftDelete)classToCheck.getAnnotationUsage(SoftDelete.class, modelsContext);
            if (fromSuper == null || !classToCheck.hasAnnotationUsage(jakarta.persistence.MappedSuperclass.class, modelsContext)) continue;
            return fromSuper;
        }
        return BinderHelper.extractFromPackage(SoftDelete.class, classDetails, context);
    }

    private void handleCheckConstraints() {
        if (this.annotatedClass.hasAnnotationUsage(Checks.class, this.modelsContext())) {
            Checks explicitUsage = (Checks)this.annotatedClass.getAnnotationUsage(Checks.class, this.modelsContext());
            for (Check check : explicitUsage.value()) {
                this.addCheckToEntity(check);
            }
        } else {
            Check check = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, Check.class, this.context);
            if (check != null) {
                this.addCheckToEntity(check);
            }
        }
    }

    private void addCheckToEntity(Check check) {
        String name = check.name();
        String constraint = check.constraints();
        this.persistentClass.addCheckConstraint(name.isBlank() ? new CheckConstraint(constraint) : new CheckConstraint(name, constraint));
    }

    private void callTypeBinders(PersistentClass persistentClass) {
        List metaAnnotatedList = this.annotatedClass.getMetaAnnotated(TypeBinderType.class, this.modelsContext());
        for (Annotation metaAnnotated : metaAnnotatedList) {
            this.applyTypeBinder(metaAnnotated, persistentClass);
        }
    }

    private void applyTypeBinder(Annotation containingAnnotation, PersistentClass persistentClass) {
        Class<TypeBinder<?>> binderClass = containingAnnotation.annotationType().getAnnotation(TypeBinderType.class).binder();
        try {
            TypeBinder<?> binder = binderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            binder.bind(containingAnnotation, this.context, persistentClass);
        }
        catch (Exception e) {
            throw new AnnotationException("error processing @TypeBinderType annotation '" + String.valueOf(containingAnnotation) + "'", e);
        }
    }

    private void handleIdentifier(PropertyHolder propertyHolder, Map<ClassDetails, InheritanceState> inheritanceStates, InheritanceState inheritanceState) {
        InheritanceState.ElementsToProcess elementsToProcess = inheritanceState.postProcess(this.persistentClass, this);
        Set<String> idPropertiesIfIdClass = this.handleIdClass(this.persistentClass, inheritanceState, this.context, propertyHolder, elementsToProcess, inheritanceStates);
        this.processIdPropertiesIfNotAlready(this.persistentClass, inheritanceState, this.context, propertyHolder, idPropertiesIfIdClass, elementsToProcess, inheritanceStates);
    }

    private void processComplementaryTableDefinitions() {
        ModelsContext models = this.modelsContext();
        Table jpaTableUsage = (Table)this.annotatedClass.getAnnotationUsage(Table.class, models);
        if (jpaTableUsage != null) {
            org.hibernate.mapping.Table table = this.persistentClass.getTable();
            TableBinder.addJpaIndexes(table, jpaTableUsage.indexes(), this.context);
            TableBinder.addTableCheck(table, jpaTableUsage.check());
            TableBinder.addTableComment(table, jpaTableUsage.comment());
            TableBinder.addTableOptions(table, jpaTableUsage.options());
        }
        InFlightMetadataCollector.EntityTableXref entityTableXref = this.getMetadataCollector().getEntityTableXref(this.persistentClass.getEntityName());
        this.annotatedClass.forEachAnnotationUsage(SecondaryTable.class, models, usage -> {
            Identifier secondaryTableLogicalName = Identifier.toIdentifier(usage.name());
            org.hibernate.mapping.Table table = entityTableXref.resolveTable(secondaryTableLogicalName);
            assert (table != null);
            TableBinder.addJpaIndexes(table, usage.indexes(), this.context);
        });
    }

    private Set<String> handleIdClass(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Map<ClassDetails, InheritanceState> inheritanceStates) {
        HashSet<String> idPropertiesIfIdClass = new HashSet<String>();
        boolean isIdClass = this.mapAsIdClass(inheritanceStates, inheritanceState, persistentClass, propertyHolder, elementsToProcess, idPropertiesIfIdClass, context);
        if (!isIdClass) {
            this.wrapIdsInEmbeddedComponents = elementsToProcess.getIdPropertyCount() > 1;
        }
        return idPropertiesIfIdClass;
    }

    private boolean mapAsIdClass(Map<ClassDetails, InheritanceState> inheritanceStates, InheritanceState inheritanceState, PersistentClass persistentClass, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Set<String> idPropertiesIfIdClass, MetadataBuildingContext context) {
        ClassDetails classWithIdClass = inheritanceState.getClassWithIdClass(false);
        if (classWithIdClass != null) {
            ClassDetails compositeClass = this.idClassDetails(inheritanceState, classWithIdClass);
            return compositeClass != null && this.mapAsIdClass(inheritanceStates, persistentClass, propertyHolder, elementsToProcess, idPropertiesIfIdClass, context, compositeClass, classWithIdClass);
        }
        return false;
    }

    private boolean mapAsIdClass(Map<ClassDetails, InheritanceState> inheritanceStates, PersistentClass persistentClass, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Set<String> idPropertiesIfIdClass, MetadataBuildingContext context, ClassDetails compositeClass, ClassDetails classWithIdClass) {
        AccessType propertyAccessor;
        PropertyPreloadedData baseInferredData;
        ClassTypeDetailsImpl compositeType = new ClassTypeDetailsImpl(compositeClass, TypeDetails.Kind.CLASS);
        ClassTypeDetailsImpl classWithIdType = new ClassTypeDetailsImpl(classWithIdClass, TypeDetails.Kind.CLASS);
        AccessType accessType = this.getPropertyAccessType();
        PropertyPreloadedData inferredData = new PropertyPreloadedData(accessType, "id", (TypeDetails)compositeType);
        boolean isFakeIdClass = this.isIdClassPrimaryKeyOfAssociatedEntity(elementsToProcess, compositeClass, inferredData, baseInferredData = new PropertyPreloadedData(accessType, "id", (TypeDetails)classWithIdType), propertyAccessor = this.getPropertyAccessor((AnnotationTarget)compositeClass), inheritanceStates, context);
        if (isFakeIdClass) {
            return false;
        }
        boolean ignoreIdAnnotations = this.isIgnoreIdAnnotations();
        this.ignoreIdAnnotations = true;
        Component idClassComponent = this.bindIdClass(inferredData, baseInferredData, propertyHolder, propertyAccessor, context, inheritanceStates);
        Component mapper = this.createMapperProperty(inheritanceStates, persistentClass, propertyHolder, context, classWithIdClass, (TypeDetails)compositeType, baseInferredData, propertyAccessor, true);
        if (idClassComponent.isSimpleRecord()) {
            mapper.setSimpleRecord(true);
        }
        this.ignoreIdAnnotations = ignoreIdAnnotations;
        for (Property property : mapper.getProperties()) {
            idPropertiesIfIdClass.add(property.getName());
        }
        return true;
    }

    private ClassDetails idClassDetails(InheritanceState inheritanceState, ClassDetails classWithIdClass) {
        IdClass idClassAnn = (IdClass)classWithIdClass.getDirectAnnotationUsage(IdClass.class);
        ClassDetailsRegistry classDetailsRegistry = this.modelsContext().getClassDetailsRegistry();
        if (idClassAnn == null) {
            try {
                Class javaClass = inheritanceState.getClassDetails().toJavaClass();
                String generatedIdClassName = EntityBinder.getGeneratedClassName(javaClass) + "$Id";
                return classDetailsRegistry.resolveClassDetails(generatedIdClassName);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return classDetailsRegistry.resolveClassDetails(idClassAnn.value().getName());
    }

    private static String getGeneratedClassName(Class<?> javaClass) {
        return javaClass.isMemberClass() ? EntityBinder.getGeneratedClassName(javaClass.getEnclosingClass()) + "$" + javaClass.getSimpleName() + "_" : javaClass.getName() + "_";
    }

    private Component createMapperProperty(Map<ClassDetails, InheritanceState> inheritanceStates, PersistentClass persistentClass, PropertyHolder propertyHolder, MetadataBuildingContext context, ClassDetails classWithIdClass, TypeDetails compositeClass, PropertyData baseInferredData, AccessType propertyAccessor, boolean isIdClass) {
        Component mapper = this.createMapper(inheritanceStates, persistentClass, propertyHolder, context, classWithIdClass, compositeClass, baseInferredData, propertyAccessor, isIdClass);
        SyntheticProperty mapperProperty = new SyntheticProperty();
        mapperProperty.setName("_identifierMapper");
        mapperProperty.setUpdatable(false);
        mapperProperty.setInsertable(false);
        mapperProperty.setPropertyAccessorName(BuiltInPropertyAccessStrategies.EMBEDDED.getExternalName());
        mapperProperty.setValue(mapper);
        persistentClass.addProperty(mapperProperty);
        return mapper;
    }

    private Component createMapper(Map<ClassDetails, InheritanceState> inheritanceStates, PersistentClass persistentClass, PropertyHolder propertyHolder, MetadataBuildingContext context, ClassDetails classWithIdClass, TypeDetails compositeClass, PropertyData baseInferredData, AccessType propertyAccessor, boolean isIdClass) {
        Component mapper = EmbeddableBinder.fillEmbeddable(propertyHolder, new PropertyPreloadedData(propertyAccessor, "_identifierMapper", compositeClass), baseInferredData, propertyAccessor, this.annotatedClass, false, this, true, true, false, null, null, null, context, inheritanceStates, isIdClass);
        persistentClass.setIdentifierMapper(mapper);
        MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(classWithIdClass, inheritanceStates, context);
        if (superclass != null) {
            superclass.setDeclaredIdentifierMapper(mapper);
        } else {
            persistentClass.setDeclaredIdentifierMapper(mapper);
        }
        return mapper;
    }

    private static PropertyData getUniqueIdPropertyFromBaseClass(PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context) {
        ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
        PropertyContainer propContainer = new PropertyContainer(baseInferredData.getClassOrElementType().determineRawClass(), (TypeVariableScope)inferredData.getPropertyType(), propertyAccessor);
        int idPropertyCount = PropertyBinder.addElementsOfClass(baseClassElements, propContainer, context, 0);
        assert (idPropertyCount == 1);
        return (PropertyData)baseClassElements.get(0);
    }

    private boolean isIdClassPrimaryKeyOfAssociatedEntity(InheritanceState.ElementsToProcess elementsToProcess, ClassDetails compositeClass, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, Map<ClassDetails, InheritanceState> inheritanceStates, MetadataBuildingContext context) {
        if (elementsToProcess.getIdPropertyCount() == 1) {
            PropertyData idPropertyOnBaseClass = EntityBinder.getUniqueIdPropertyFromBaseClass(inferredData, baseInferredData, propertyAccessor, context);
            TypeDetails idPropertyType = idPropertyOnBaseClass.getClassOrElementType();
            InheritanceState state = inheritanceStates.get(idPropertyType.determineRawClass());
            if (state == null) {
                return false;
            }
            ClassDetails associatedClassWithIdClass = state.getClassWithIdClass(true);
            if (associatedClassWithIdClass == null) {
                return BinderHelper.hasToOneAnnotation((AnnotationTarget)idPropertyOnBaseClass.getAttributeMember()) && EntityBinder.isIdClassOfAssociatedEntity(compositeClass, propertyAccessor, context, idPropertyType);
            }
            IdClass idClass = (IdClass)associatedClassWithIdClass.getAnnotationUsage(IdClass.class, this.modelsContext());
            return compositeClass.getName().equals(idClass.value().getName());
        }
        return false;
    }

    private static boolean isIdClassOfAssociatedEntity(ClassDetails compositeClass, AccessType propertyAccessor, MetadataBuildingContext context, TypeDetails idPropertyType) {
        ArrayList<PropertyData> idProperties = new ArrayList<PropertyData>();
        PropertyContainer propertyContainer = new PropertyContainer(idPropertyType.determineRawClass(), (TypeVariableScope)idPropertyType, propertyAccessor);
        int idPropertyCount = PropertyBinder.addElementsOfClass(idProperties, propertyContainer, context, 0);
        if (idPropertyCount == 1) {
            PropertyData idPropertyOfAssociatedEntity = (PropertyData)idProperties.get(0);
            return compositeClass.getName().equals(idPropertyOfAssociatedEntity.getPropertyType().getName());
        }
        return false;
    }

    private Component bindIdClass(PropertyData inferredData, PropertyData baseInferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, MetadataBuildingContext buildingContext, Map<ClassDetails, InheritanceState> inheritanceStates) {
        propertyHolder.setInIdClass(true);
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' is a subclass in an entity inheritance hierarchy and may not redefine the identifier of the root entity");
        }
        RootClass rootClass = (RootClass)persistentClass;
        Component id = EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, baseInferredData, propertyAccessor, this.annotatedClass, false, this, true, false, false, null, null, null, buildingContext, inheritanceStates, true);
        id.setKey(true);
        if (rootClass.getIdentifier() != null) {
            throw new AssertionFailure("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' and may not have an identifier property");
        }
        if (id.getPropertySpan() == 0) {
            throw new AnnotationException("Class '" + id.getComponentClassName() + " is the '@IdClass' for the entity '" + persistentClass.getEntityName() + "' but has no persistent properties");
        }
        rootClass.setIdentifier(id);
        rootClass.setEmbeddedIdentifier(inferredData.getPropertyType() == null);
        propertyHolder.setInIdClass(null);
        return id;
    }

    private void handleSecondaryTables() {
        this.annotatedClass.forEachRepeatedAnnotationUsages(JpaAnnotations.SECONDARY_TABLE, this.modelsContext(), usage -> this.addSecondaryTable((SecondaryTable)usage, null, false));
    }

    private void handleClassTable(InheritanceState inheritanceState, PersistentClass superEntity) {
        UniqueConstraint[] uniqueConstraints;
        String catalog;
        String schema;
        String table;
        Table tableAnnotation = (Table)this.annotatedClass.getAnnotationUsage(Table.class, this.modelsContext());
        if (tableAnnotation != null) {
            table = tableAnnotation.name();
            schema = tableAnnotation.schema();
            catalog = tableAnnotation.catalog();
            uniqueConstraints = tableAnnotation.uniqueConstraints();
        } else {
            schema = "";
            table = "";
            catalog = "";
            uniqueConstraints = new UniqueConstraint[]{};
        }
        if (inheritanceState.hasTable()) {
            this.createTable(inheritanceState, superEntity, schema, table, catalog, uniqueConstraints);
        } else {
            if (tableAnnotation != null) {
                throw new AnnotationException("Entity '" + this.annotatedClass.getName() + "' is a subclass in a 'SINGLE_TABLE' hierarchy and may not be annotated '@Table' (the root class declares the table mapping for the hierarchy)");
            }
            this.bindTableForDiscriminatedSubclass(superEntity.getEntityName());
        }
    }

    private void createTable(InheritanceState inheritanceState, PersistentClass superEntity, String schema, String table, String catalog, UniqueConstraint[] uniqueConstraints) {
        ModelsContext models = this.modelsContext();
        RowId rowId = (RowId)this.annotatedClass.getAnnotationUsage(RowId.class, models);
        View view = (View)this.annotatedClass.getAnnotationUsage(View.class, models);
        this.bindTable(schema, catalog, table, uniqueConstraints, rowId == null ? null : rowId.value(), view == null ? null : view.query(), inheritanceState.hasDenormalizedTable() ? this.getMetadataCollector().getEntityTableXref(superEntity.getEntityName()) : null);
    }

    private void handleInheritance(InheritanceState inheritanceState, PersistentClass superEntity, PropertyHolder propertyHolder) {
        boolean isJoinedSubclass = switch (inheritanceState.getType()) {
            case InheritanceType.JOINED -> {
                this.joinedInheritance(inheritanceState, superEntity, propertyHolder);
                yield inheritanceState.hasParents();
            }
            case InheritanceType.SINGLE_TABLE -> {
                this.singleTableInheritance(inheritanceState, propertyHolder);
                yield false;
            }
            case InheritanceType.TABLE_PER_CLASS -> false;
            default -> throw new AssertionFailure("Unrecognized InheritanceType");
        };
        this.bindDiscriminatorValue();
        if (!isJoinedSubclass) {
            this.checkNoJoinColumns(this.annotatedClass);
            this.checkNoOnDelete(this.annotatedClass);
        }
    }

    private void singleTableInheritance(InheritanceState inheritanceState, PropertyHolder holder) {
        AnnotatedDiscriminatorColumn discriminatorColumn = this.processSingleTableDiscriminatorProperties(inheritanceState);
        if (!inheritanceState.hasParents()) {
            RootClass rootClass = (RootClass)this.persistentClass;
            if (inheritanceState.hasSiblings() || discriminatorColumn != null && !discriminatorColumn.isImplicit()) {
                this.bindDiscriminatorColumnToRootPersistentClass(rootClass, discriminatorColumn, holder);
                if (this.context.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect()) {
                    rootClass.setForceDiscriminator(true);
                }
            }
        }
    }

    private void joinedInheritance(InheritanceState state, PersistentClass superEntity, PropertyHolder holder) {
        if (state.hasParents()) {
            AnnotatedJoinColumns joinColumns = EntityBinder.subclassJoinColumns(this.annotatedClass, superEntity, this.context);
            JoinedSubclass joinedSubclass = (JoinedSubclass)this.persistentClass;
            DependantValue key = new DependantValue(this.context, joinedSubclass.getTable(), joinedSubclass.getIdentifier());
            joinedSubclass.setKey(key);
            this.handleForeignKeys(this.annotatedClass, this.context, key);
            OnDelete onDelete = (OnDelete)this.annotatedClass.getAnnotationUsage(OnDelete.class, this.modelsContext());
            key.setOnDeleteAction(onDelete == null ? null : onDelete.action());
            InFlightMetadataCollector metadataCollector = this.getMetadataCollector();
            metadataCollector.addSecondPass(new JoinedSubclassFkSecondPass(joinedSubclass, joinColumns, key, this.context));
            metadataCollector.addSecondPass(new CreateKeySecondPass(joinedSubclass));
        }
        AnnotatedDiscriminatorColumn discriminatorColumn = this.processJoinedDiscriminatorProperties(state);
        if (!state.hasParents()) {
            RootClass rootClass = (RootClass)this.persistentClass;
            if (discriminatorColumn != null && (state.hasSiblings() || !discriminatorColumn.isImplicit())) {
                this.bindDiscriminatorColumnToRootPersistentClass(rootClass, discriminatorColumn, holder);
                if (this.context.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect()) {
                    rootClass.setForceDiscriminator(true);
                }
            }
        }
    }

    private void checkNoJoinColumns(ClassDetails annotatedClass) {
        if (annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumns.class, this.modelsContext()) || annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumn.class, this.modelsContext())) {
            throw new AnnotationException("Entity class '" + annotatedClass.getName() + "' may not specify a '@PrimaryKeyJoinColumn'");
        }
    }

    private void checkNoOnDelete(ClassDetails annotatedClass) {
        if (annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumns.class, this.modelsContext()) || annotatedClass.hasAnnotationUsage(PrimaryKeyJoinColumn.class, this.modelsContext())) {
            throw new AnnotationException("Entity class '" + annotatedClass.getName() + "' may not be annotated '@OnDelete'");
        }
    }

    private void handleForeignKeys(ClassDetails clazzToProcess, MetadataBuildingContext context, DependantValue key) {
        PrimaryKeyJoinColumn pkJoinColumn = (PrimaryKeyJoinColumn)clazzToProcess.getDirectAnnotationUsage(PrimaryKeyJoinColumn.class);
        PrimaryKeyJoinColumns pkJoinColumns = (PrimaryKeyJoinColumns)clazzToProcess.getDirectAnnotationUsage(PrimaryKeyJoinColumns.class);
        boolean noConstraintByDefault = context.getBuildingOptions().isNoConstraintByDefault();
        if (pkJoinColumn != null && BinderHelper.noConstraint(pkJoinColumn.foreignKey(), noConstraintByDefault) || pkJoinColumns != null && BinderHelper.noConstraint(pkJoinColumns.foreignKey(), noConstraintByDefault)) {
            key.disableForeignKey();
        } else {
            ForeignKey foreignKey = (ForeignKey)clazzToProcess.getDirectAnnotationUsage(ForeignKey.class);
            if (BinderHelper.noConstraint(foreignKey, noConstraintByDefault)) {
                key.disableForeignKey();
            } else if (foreignKey != null) {
                key.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                key.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
                key.setForeignKeyOptions(foreignKey.options());
            } else if (noConstraintByDefault) {
                key.disableForeignKey();
            } else if (pkJoinColumns != null) {
                ForeignKey nestedFk = pkJoinColumns.foreignKey();
                key.setForeignKeyName(StringHelper.nullIfEmpty(nestedFk.name()));
                key.setForeignKeyDefinition(StringHelper.nullIfEmpty(nestedFk.foreignKeyDefinition()));
                key.setForeignKeyOptions(nestedFk.options());
            } else if (pkJoinColumn != null) {
                ForeignKey nestedFk = pkJoinColumn.foreignKey();
                key.setForeignKeyName(StringHelper.nullIfEmpty(nestedFk.name()));
                key.setForeignKeyDefinition(StringHelper.nullIfEmpty(nestedFk.foreignKeyDefinition()));
                key.setForeignKeyOptions(nestedFk.options());
            }
        }
    }

    private void bindDiscriminatorColumnToRootPersistentClass(RootClass rootClass, AnnotatedDiscriminatorColumn discriminatorColumn, PropertyHolder holder) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            AnnotatedColumns columns = new AnnotatedColumns();
            columns.setPropertyHolder(holder);
            columns.setBuildingContext(this.context);
            columns.setJoins(this.secondaryTables);
            discriminatorColumn.setParent(columns);
            BasicValue discriminatorColumnBinding = new BasicValue(this.context, rootClass.getTable());
            rootClass.setDiscriminator(discriminatorColumnBinding);
            discriminatorColumn.linkWithValue(discriminatorColumnBinding);
            discriminatorColumnBinding.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            this.getMetadataCollector().addSecondPass(new DiscriminatorColumnSecondPass(rootClass.getEntityName(), this.context.getMetadataCollector().getDatabase().getDialect()));
        }
    }

    private AnnotatedDiscriminatorColumn processSingleTableDiscriminatorProperties(InheritanceState inheritanceState) {
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)this.annotatedClass.getAnnotationUsage(DiscriminatorColumn.class, this.modelsContext());
        DiscriminatorFormula discriminatorFormula = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, DiscriminatorFormula.class, this.context);
        if (!inheritanceState.hasParents() || this.annotatedClass.hasAnnotationUsage(Inheritance.class, this.modelsContext())) {
            return AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorColumn, discriminatorFormula, null, "DTYPE", this.context);
        }
        if (discriminatorColumn != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorColumn' but it is not the root of the entity inheritance hierarchy");
        }
        if (discriminatorFormula != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorFormula' but it is not the root of the entity inheritance hierarchy");
        }
        return null;
    }

    private AnnotatedDiscriminatorColumn processJoinedDiscriminatorProperties(InheritanceState inheritanceState) {
        if (this.annotatedClass.hasAnnotationUsage(DiscriminatorFormula.class, this.modelsContext())) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' has 'JOINED' inheritance and is annotated '@DiscriminatorFormula'");
        }
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)this.annotatedClass.getAnnotationUsage(DiscriminatorColumn.class, this.modelsContext());
        if (!inheritanceState.hasParents() || this.annotatedClass.hasAnnotationUsage(Inheritance.class, this.modelsContext())) {
            return this.useDiscriminatorColumnForJoined(discriminatorColumn) ? AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorColumn, null, null, "DTYPE", this.context) : null;
        }
        if (discriminatorColumn != null) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@DiscriminatorColumn' but it is not the root of the entity inheritance hierarchy");
        }
        return null;
    }

    private boolean useDiscriminatorColumnForJoined(DiscriminatorColumn discriminatorColumn) {
        MetadataBuildingOptions buildingOptions = this.context.getBuildingOptions();
        if (discriminatorColumn != null) {
            boolean ignore = buildingOptions.ignoreExplicitDiscriminatorsForJoinedInheritance();
            if (ignore && LOG.isTraceEnabled()) {
                LOG.trace("Ignoring explicit @DiscriminatorColumn annotation on: " + this.annotatedClass.getName());
            }
            return !ignore;
        }
        boolean createImplicit = buildingOptions.createImplicitDiscriminatorsForJoinedInheritance();
        if (createImplicit && LOG.isTraceEnabled()) {
            LOG.trace("Inferring implicit @DiscriminatorColumn using defaults for: " + this.annotatedClass.getName());
        }
        return createImplicit;
    }

    private void processIdPropertiesIfNotAlready(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, PropertyHolder propertyHolder, Set<String> idPropertiesIfIdClass, InheritanceState.ElementsToProcess elementsToProcess, Map<ClassDetails, InheritanceState> inheritanceStates) {
        HashSet<String> missingIdProperties = new HashSet<String>(idPropertiesIfIdClass);
        HashSet<String> missingEntityProperties = new HashSet<String>();
        for (PropertyData propertyAnnotatedElement : elementsToProcess.getElements()) {
            String propertyName = propertyAnnotatedElement.getPropertyName();
            if (!idPropertiesIfIdClass.contains(propertyName)) {
                boolean subclassAndSingleTableStrategy;
                MemberDetails property = propertyAnnotatedElement.getAttributeMember();
                boolean hasIdAnnotation = PropertyBinder.hasIdAnnotation(property);
                if (!idPropertiesIfIdClass.isEmpty() && !this.isIgnoreIdAnnotations() && hasIdAnnotation) {
                    missingEntityProperties.add(propertyName);
                    continue;
                }
                boolean bl = subclassAndSingleTableStrategy = inheritanceState.getType() == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents();
                if (!hasIdAnnotation && property.hasAnnotationUsage(GeneratedValue.class, this.modelsContext())) {
                    throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, propertyAnnotatedElement) + "' is annotated '@GeneratedValue' but is not part of an identifier");
                }
                PropertyBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement, this, false, false, false, context, inheritanceStates);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (!missingIdProperties.isEmpty()) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' with properties " + EntityBinder.getMissingPropertiesString(missingIdProperties) + " which do not match properties of the entity class");
        }
        if (!missingEntityProperties.isEmpty()) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' has '@Id' annotated properties " + EntityBinder.getMissingPropertiesString(missingEntityProperties) + " which do not match properties of the specified '@IdClass'");
        }
    }

    private static String getMissingPropertiesString(Set<String> propertyNames) {
        StringBuilder missingProperties = new StringBuilder();
        for (String propertyName : propertyNames) {
            if (!missingProperties.isEmpty()) {
                missingProperties.append(", ");
            }
            missingProperties.append("'").append(propertyName).append("'");
        }
        return missingProperties.toString();
    }

    private static PersistentClass makePersistentClass(InheritanceState inheritanceState, PersistentClass superEntity, MetadataBuildingContext metadataBuildingContext) {
        if (!inheritanceState.hasParents()) {
            return new RootClass(metadataBuildingContext);
        }
        return switch (inheritanceState.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case InheritanceType.SINGLE_TABLE -> new SingleTableSubclass(superEntity, metadataBuildingContext);
            case InheritanceType.JOINED -> new JoinedSubclass(superEntity, metadataBuildingContext);
            case InheritanceType.TABLE_PER_CLASS -> new UnionSubclass(superEntity, metadataBuildingContext);
        };
    }

    private static AnnotatedJoinColumns subclassJoinColumns(ClassDetails clazzToProcess, PersistentClass superEntity, MetadataBuildingContext context) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(context);
        ModelsContext modelsContext = context.getBootstrapContext().getModelsContext();
        PrimaryKeyJoinColumns primaryKeyJoinColumns = (PrimaryKeyJoinColumns)clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumns.class, modelsContext);
        if (primaryKeyJoinColumns != null) {
            Object[] columns = primaryKeyJoinColumns.value();
            if (!ArrayHelper.isEmpty(columns)) {
                for (Object column : columns) {
                    AnnotatedJoinColumn.buildInheritanceJoinColumn((PrimaryKeyJoinColumn)column, null, superEntity.getIdentifier(), joinColumns, context);
                }
            } else {
                PrimaryKeyJoinColumn columnAnnotation = (PrimaryKeyJoinColumn)clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumn.class, modelsContext);
                AnnotatedJoinColumn.buildInheritanceJoinColumn(columnAnnotation, null, superEntity.getIdentifier(), joinColumns, context);
            }
        } else {
            AnnotatedJoinColumn.buildInheritanceJoinColumn((PrimaryKeyJoinColumn)clazzToProcess.getAnnotationUsage(PrimaryKeyJoinColumn.class, modelsContext), null, superEntity.getIdentifier(), joinColumns, context);
        }
        return joinColumns;
    }

    private static PersistentClass getSuperEntity(ClassDetails clazzToProcess, Map<ClassDetails, InheritanceState> inheritanceStates, MetadataBuildingContext context, InheritanceState inheritanceState) {
        InheritanceState superState = InheritanceState.getInheritanceStateOfSuperEntity(clazzToProcess, inheritanceStates);
        if (superState == null) {
            return null;
        }
        PersistentClass superEntity = context.getMetadataCollector().getEntityBinding(superState.getClassDetails().getName());
        if (superEntity == null && inheritanceState.hasParents()) {
            throw new AssertionFailure("Subclass has to be bound after its parent class: " + superState.getClassDetails().getName());
        }
        return superEntity;
    }

    public boolean wrapIdsInEmbeddedComponents() {
        return this.wrapIdsInEmbeddedComponents;
    }

    public EntityBinder(MetadataBuildingContext context) {
        this.context = context;
    }

    public EntityBinder(ClassDetails annotatedClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        this.context = context;
        this.persistentClass = persistentClass;
        this.annotatedClass = annotatedClass;
    }

    public boolean isPropertyDefinedInSuperHierarchy(String name) {
        return this.persistentClass != null && this.persistentClass.isPropertyDefinedInSuperHierarchy(name);
    }

    private void bindRowManagement() {
        DynamicInsert dynamicInsertAnn = (DynamicInsert)this.annotatedClass.getAnnotationUsage(DynamicInsert.class, this.modelsContext());
        this.persistentClass.setDynamicInsert(dynamicInsertAnn != null);
        DynamicUpdate dynamicUpdateAnn = (DynamicUpdate)this.annotatedClass.getAnnotationUsage(DynamicUpdate.class, this.modelsContext());
        this.persistentClass.setDynamicUpdate(dynamicUpdateAnn != null);
        if (this.persistentClass.useDynamicInsert() && this.annotatedClass.hasAnnotationUsage(SQLInsert.class, this.modelsContext())) {
            throw new AnnotationException("Entity '" + this.name + "' is annotated both '@DynamicInsert' and '@SQLInsert'");
        }
        if (this.persistentClass.useDynamicUpdate() && this.annotatedClass.hasAnnotationUsage(SQLUpdate.class, this.modelsContext())) {
            throw new AnnotationException("Entity '" + this.name + "' is annotated both '@DynamicUpdate' and '@SQLUpdate'");
        }
    }

    private void bindOptimisticLocking() {
        OptimisticLocking optimisticLockingAnn = (OptimisticLocking)this.annotatedClass.getAnnotationUsage(OptimisticLocking.class, this.modelsContext());
        this.persistentClass.setOptimisticLockStyle(OptimisticLockStyle.fromLockType(optimisticLockingAnn == null ? OptimisticLockType.VERSION : optimisticLockingAnn.type()));
    }

    private void bindEntityAnnotation() {
        Entity entity = (Entity)this.annotatedClass.getAnnotationUsage(Entity.class, this.modelsContext());
        if (entity == null) {
            throw new AssertionFailure("@Entity should never be missing");
        }
        String entityName = entity.name();
        this.name = entityName.isBlank() ? StringHelper.unqualify(this.annotatedClass.getName()) : entityName;
    }

    public boolean isRootEntity() {
        return this.persistentClass instanceof RootClass;
    }

    private void bindEntity() {
        this.bindEntityAnnotation();
        this.bindRowManagement();
        this.bindOptimisticLocking();
        this.bindConcreteProxy();
        this.bindSqlRestriction();
        this.bindCache();
        this.bindNaturalIdCache();
        this.bindFiltersInHierarchy();
        this.persistentClass.setAbstract(this.annotatedClass.isAbstract());
        this.persistentClass.setClassName(this.annotatedClass.getClassName());
        this.persistentClass.setJpaEntityName(this.name);
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        this.persistentClass.setCached(this.isCached);
        this.persistentClass.setLazy(true);
        this.persistentClass.setQueryCacheLayout(this.queryCacheLayout);
        this.persistentClass.setProxyInterfaceName(this.annotatedClass.getName());
        if (this.persistentClass instanceof RootClass) {
            this.bindRootEntity();
        } else {
            this.checkSubclassEntity();
        }
        this.ensureNoMutabilityPlan();
        this.registerImportName();
        this.processNamedEntityGraphs();
    }

    private void checkSubclassEntity() {
        if (!this.isMutable()) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' is annotated '@Immutable' but it is a subclass in an entity inheritance hierarchy (only a root class may declare its mutability)");
        }
        if (StringHelper.isNotBlank(this.where)) {
            throw new AnnotationException("Entity class '" + this.annotatedClass.getName() + "' specifies an '@SQLRestriction' but it is a subclass in an entity inheritance hierarchy (only a root class may be specify a restriction)");
        }
    }

    private void ensureNoMutabilityPlan() {
        if (this.annotatedClass.hasAnnotationUsage(Mutability.class, this.modelsContext())) {
            throw new MappingException("@Mutability is not allowed on entity");
        }
    }

    private boolean isMutable() {
        return !this.annotatedClass.hasAnnotationUsage(Immutable.class, this.modelsContext());
    }

    private void registerImportName() {
        try {
            InFlightMetadataCollector metadataCollector = this.getMetadataCollector();
            metadataCollector.addImport(this.name, this.persistentClass.getEntityName());
            String entityName = this.persistentClass.getEntityName();
            if (!entityName.equals(this.name)) {
                metadataCollector.addImport(entityName, entityName);
            }
        }
        catch (MappingException me) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name, (Throwable)((Object)me));
        }
    }

    private void bindRootEntity() {
        RootClass rootClass = (RootClass)this.persistentClass;
        rootClass.setMutable(this.isMutable());
        if (StringHelper.isNotBlank(this.where)) {
            rootClass.setWhere(this.where);
        }
        if (this.cacheConcurrentStrategy != null) {
            rootClass.setCacheConcurrencyStrategy(this.cacheConcurrentStrategy);
            rootClass.setCacheRegionName(this.cacheRegion);
            rootClass.setLazyPropertiesCacheable(this.cacheLazyProperty);
        }
        rootClass.setNaturalIdCacheRegionName(this.naturalIdCacheRegion);
    }

    private void bindCustomSql() {
        HQLSelect hqlSelect;
        SQLDeleteAll sqlDeleteAll;
        SQLDelete sqlDelete;
        SQLUpdate sqlUpdate;
        String primaryTableName = this.persistentClass.getTable().getName();
        SQLInsert sqlInsert = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLInsert.class, primaryTableName);
        if (sqlInsert == null) {
            sqlInsert = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLInsert.class, "");
        }
        if (sqlInsert != null) {
            this.persistentClass.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlInsert.check()));
            Class<? extends Expectation> expectationClass = sqlInsert.verify();
            if (expectationClass != Expectation.class) {
                this.persistentClass.setInsertExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlUpdate = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLUpdate.class, primaryTableName)) == null) {
            sqlUpdate = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLUpdate.class, "");
        }
        if (sqlUpdate != null) {
            this.persistentClass.setCustomSQLUpdate(sqlUpdate.sql().trim(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlUpdate.check()));
            Class<? extends Expectation> expectationClass = sqlUpdate.verify();
            if (expectationClass != Expectation.class) {
                this.persistentClass.setUpdateExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlDelete = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDelete.class, primaryTableName)) == null) {
            sqlDelete = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDelete.class, "");
        }
        if (sqlDelete != null) {
            this.persistentClass.setCustomSQLDelete(sqlDelete.sql().trim(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlDelete.check()));
            Class<? extends Expectation> expectationClass = sqlDelete.verify();
            if (expectationClass != Expectation.class) {
                this.persistentClass.setDeleteExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlDeleteAll = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDeleteAll.class, "")) != null) {
            throw new AnnotationException("@SQLDeleteAll does not apply to entities: " + this.persistentClass.getEntityName());
        }
        SQLSelect sqlSelect = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.annotatedClass, SQLSelect.class, this.context);
        if (sqlSelect != null) {
            String loaderName = this.persistentClass.getEntityName() + "$SQLSelect";
            this.persistentClass.setLoaderName(loaderName);
            QueryBinder.bindNativeQuery(loaderName, sqlSelect, this.annotatedClass, this.context);
        }
        if ((hqlSelect = (HQLSelect)this.annotatedClass.getAnnotationUsage(HQLSelect.class, this.modelsContext())) != null) {
            String loaderName = this.persistentClass.getEntityName() + "$HQLSelect";
            this.persistentClass.setLoaderName(loaderName);
            QueryBinder.bindQuery(loaderName, hqlSelect, this.context);
        }
    }

    private void bindSubselect() {
        Subselect subselect = (Subselect)this.annotatedClass.getAnnotationUsage(Subselect.class, this.modelsContext());
        if (subselect != null) {
            this.subselect = subselect.value();
        }
    }

    private <A extends Annotation> A resolveCustomSqlAnnotation(ClassDetails annotatedClass, Class<A> annotationType, String tableName) {
        Class overrideAnnotation = DialectOverridesAnnotationHelper.getOverrideAnnotation(annotationType);
        Object[] dialectOverrides = annotatedClass.getRepeatedAnnotationUsages(overrideAnnotation, this.modelsContext());
        if (CollectionHelper.isNotEmpty(dialectOverrides)) {
            Dialect dialect = this.getMetadataCollector().getDatabase().getDialect();
            for (Object annotation : dialectOverrides) {
                DialectOverrider dialectOverride = (DialectOverrider)annotation;
                if (!dialectOverride.matches(dialect)) continue;
                Object override = dialectOverride.override();
                String table = ((CustomSqlDetails)override).table();
                if ((!StringHelper.isBlank(tableName) || !StringHelper.isBlank(table)) && !Objects.equals(tableName, table)) continue;
                return (A)override;
            }
        }
        return (A)annotatedClass.getNamedAnnotationUsage(annotationType, tableName, "table", this.modelsContext());
    }

    private void bindFilters() {
        for (Filter filter : this.filters) {
            String filterName = filter.name();
            String condition = filter.condition();
            if (condition.isBlank()) {
                condition = this.getDefaultFilterCondition(filterName);
            }
            this.persistentClass.addFilter(filterName, condition, filter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(filter.aliases()), BinderHelper.toAliasEntityMap(filter.aliases()));
        }
    }

    private String getDefaultFilterCondition(String filterName) {
        FilterDefinition definition = this.getMetadataCollector().getFilterDefinition(filterName);
        if (definition == null) {
            throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' for an undefined filter named '" + filterName + "'");
        }
        String condition = definition.getDefaultFilterCondition();
        if (StringHelper.isBlank(condition)) {
            throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' with no 'condition' and no default condition was given by the '@FilterDef' named '" + filterName + "'");
        }
        return condition;
    }

    private void bindSynchronize() {
        Synchronize synchronize = (Synchronize)this.annotatedClass.getAnnotationUsage(Synchronize.class, this.modelsContext());
        if (synchronize != null) {
            JdbcEnvironment jdbcEnvironment = this.getMetadataCollector().getDatabase().getJdbcEnvironment();
            boolean logical = synchronize.logical();
            for (String tableName : synchronize.value()) {
                String physicalName = logical ? this.toPhysicalName(jdbcEnvironment, tableName) : tableName;
                this.persistentClass.addSynchronizedTable(physicalName);
            }
        }
    }

    private String toPhysicalName(JdbcEnvironment jdbcEnvironment, String logicalName) {
        Identifier identifier = jdbcEnvironment.getIdentifierHelper().toIdentifier(logicalName);
        return this.context.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(identifier, jdbcEnvironment).render(jdbcEnvironment.getDialect());
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    private void processNamedEntityGraphs() {
        this.annotatedClass.forEachAnnotationUsage(NamedEntityGraph.class, this.modelsContext(), this::processNamedEntityGraph);
        this.processParsedNamedGraphs();
    }

    private void processParsedNamedGraphs() {
        this.annotatedClass.forEachRepeatedAnnotationUsages(HibernateAnnotations.NAMED_ENTITY_GRAPH, this.modelsContext(), this::processParsedNamedEntityGraph);
    }

    private void processNamedEntityGraph(NamedEntityGraph annotation) {
        if (annotation != null) {
            this.getMetadataCollector().addNamedEntityGraph(this.namedEntityGraphDefinition(annotation));
        }
    }

    private NamedEntityGraphDefinition namedEntityGraphDefinition(NamedEntityGraph annotation) {
        String explicitName = annotation.name();
        return new NamedEntityGraphDefinition(StringHelper.isNotEmpty(explicitName) ? explicitName : this.name, this.persistentClass.getEntityName(), NamedEntityGraphDefinition.Source.JPA, new NamedGraphCreatorJpa(annotation, this.name));
    }

    private void processParsedNamedEntityGraph(org.hibernate.annotations.NamedEntityGraph annotation) {
        if (annotation != null) {
            this.getMetadataCollector().addNamedEntityGraph(this.namedEntityGraphDefinition(annotation));
        }
    }

    private NamedEntityGraphDefinition namedEntityGraphDefinition(org.hibernate.annotations.NamedEntityGraph annotation) {
        String explicitName = annotation.name();
        return new NamedEntityGraphDefinition(StringHelper.isNotEmpty(explicitName) ? explicitName : this.persistentClass.getJpaEntityName(), this.persistentClass.getEntityName(), NamedEntityGraphDefinition.Source.PARSED, new NamedGraphCreatorParsed(this.persistentClass.getMappedClass(), annotation));
    }

    private void bindDiscriminatorValue() {
        DiscriminatorValue discriminatorValueAnn = (DiscriminatorValue)this.annotatedClass.getAnnotationUsage(DiscriminatorValue.class, this.modelsContext());
        if (discriminatorValueAnn == null) {
            Value discriminator = this.persistentClass.getDiscriminator();
            if (discriminator == null) {
                this.persistentClass.setDiscriminatorValue(this.name);
            } else {
                switch (discriminator.getType().getName()) {
                    case "character": {
                        throw new AnnotationException("Entity '" + this.name + "' has a discriminator of character type and must specify its '@DiscriminatorValue'");
                    }
                    case "integer": {
                        this.persistentClass.setDiscriminatorValue(String.valueOf(this.name.hashCode()));
                        break;
                    }
                    default: {
                        this.persistentClass.setDiscriminatorValue(this.name);
                    }
                }
            }
        } else {
            this.persistentClass.setDiscriminatorValue(discriminatorValueAnn.value());
        }
    }

    private void bindConcreteProxy() {
        ConcreteProxy annotationUsage = (ConcreteProxy)this.annotatedClass.getAnnotationUsage(ConcreteProxy.class, this.modelsContext());
        if (annotationUsage != null) {
            if (this.persistentClass.getSuperclass() != null) {
                throw new AnnotationException("Entity class '" + this.persistentClass.getClassName() + "' is annotated '@ConcreteProxy' but it is not the root of the entity inheritance hierarchy");
            }
            this.persistentClass.getRootClass().setConcreteProxy(true);
        }
    }

    private void bindSqlRestriction() {
        SQLRestriction restriction = this.extractSQLRestriction(this.annotatedClass);
        if (restriction != null) {
            this.where = restriction.value();
        }
    }

    private SQLRestriction extractSQLRestriction(ClassDetails classDetails) {
        ModelsContext modelsContext = this.modelsContext();
        SQLRestriction fromClass = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)classDetails, SQLRestriction.class, this.context);
        if (fromClass != null) {
            return fromClass;
        }
        for (ClassDetails classToCheck = classDetails.getSuperClass(); classToCheck != null && classToCheck.hasAnnotationUsage(jakarta.persistence.MappedSuperclass.class, modelsContext); classToCheck = classToCheck.getSuperClass()) {
            SQLRestriction fromSuper = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)classToCheck, SQLRestriction.class, this.context);
            if (fromSuper == null) continue;
            return fromSuper;
        }
        return null;
    }

    private void bindNaturalIdCache() {
        Cache explicitCacheAnn;
        String region;
        NaturalIdCache naturalIdCacheAnn = (NaturalIdCache)this.annotatedClass.getAnnotationUsage(NaturalIdCache.class, this.modelsContext());
        this.naturalIdCacheRegion = naturalIdCacheAnn != null ? ((region = naturalIdCacheAnn.region()).isBlank() ? ((explicitCacheAnn = (Cache)this.annotatedClass.getAnnotationUsage(Cache.class, this.modelsContext())) != null && StringHelper.isNotBlank(explicitCacheAnn.region()) ? explicitCacheAnn.region() + NATURAL_ID_CACHE_SUFFIX : this.annotatedClass.getName() + NATURAL_ID_CACHE_SUFFIX) : naturalIdCacheAnn.region()) : null;
    }

    private void bindCache() {
        this.isCached = false;
        this.cacheConcurrentStrategy = null;
        this.cacheRegion = null;
        this.cacheLazyProperty = true;
        this.queryCacheLayout = null;
        if (this.isRootEntity()) {
            this.bindRootClassCache();
        } else {
            this.bindSubclassCache();
        }
    }

    private void bindSubclassCache() {
        if (this.annotatedClass.hasAnnotationUsage(Cache.class, this.modelsContext())) {
            String className = this.persistentClass.getClassName() == null ? this.annotatedClass.getName() : this.persistentClass.getClassName();
            throw new AnnotationException("Entity class '" + className + "' is annotated '@Cache' but it is a subclass in an entity inheritance hierarchy (only root classes may define second-level caching semantics)");
        }
        Cacheable cacheable = (Cacheable)this.annotatedClass.getAnnotationUsage(Cacheable.class, this.modelsContext());
        this.isCached = cacheable == null && this.persistentClass.getSuperclass() != null ? this.persistentClass.getSuperclass().isCached() : this.isCacheable(cacheable);
    }

    private void bindRootClassCache() {
        ModelsContext sourceModelContext = this.modelsContext();
        Cache cache = (Cache)this.annotatedClass.getAnnotationUsage(Cache.class, sourceModelContext);
        Cacheable cacheable = (Cacheable)this.annotatedClass.getAnnotationUsage(Cacheable.class, sourceModelContext);
        Cache effectiveCache = cache != null ? cache : this.buildCacheMock(this.annotatedClass);
        this.isCached = cache != null || this.isCacheable(cacheable);
        this.cacheConcurrentStrategy = EntityBinder.getCacheConcurrencyStrategy(effectiveCache.usage());
        this.cacheRegion = effectiveCache.region();
        this.cacheLazyProperty = effectiveCache.includeLazy();
        QueryCacheLayout queryCache = (QueryCacheLayout)this.annotatedClass.getAnnotationUsage(QueryCacheLayout.class, sourceModelContext);
        this.queryCacheLayout = queryCache == null ? null : queryCache.layout();
    }

    private boolean isCacheable(Cacheable explicitCacheableAnn) {
        return switch (this.context.getBuildingOptions().getSharedCacheMode()) {
            case SharedCacheMode.ALL -> true;
            case SharedCacheMode.ENABLE_SELECTIVE, SharedCacheMode.UNSPECIFIED -> {
                if (explicitCacheableAnn != null && explicitCacheableAnn.value()) {
                    yield true;
                }
                yield false;
            }
            case SharedCacheMode.DISABLE_SELECTIVE -> {
                if (explicitCacheableAnn == null || explicitCacheableAnn.value()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private Cache buildCacheMock(ClassDetails classDetails) {
        CacheAnnotation cacheUsage = (CacheAnnotation)HibernateAnnotations.CACHE.createUsage(this.modelsContext());
        cacheUsage.region(classDetails.getName());
        cacheUsage.usage(this.determineCacheConcurrencyStrategy());
        return cacheUsage;
    }

    private CacheConcurrencyStrategy determineCacheConcurrencyStrategy() {
        return CacheConcurrencyStrategy.fromAccessType(this.context.getBuildingOptions().getImplicitCacheAccessType());
    }

    private void bindTableForDiscriminatedSubclass(String entityName) {
        if (!(this.persistentClass instanceof SingleTableSubclass)) {
            throw new AssertionFailure("Was expecting a discriminated subclass [" + SingleTableSubclass.class.getName() + "] but found [" + this.persistentClass.getClass().getName() + "] for entity [" + this.persistentClass.getEntityName() + "]");
        }
        InFlightMetadataCollector collector = this.getMetadataCollector();
        InFlightMetadataCollector.EntityTableXref superTableXref = collector.getEntityTableXref(entityName);
        org.hibernate.mapping.Table primaryTable = superTableXref.getPrimaryTable();
        collector.addEntityTableXref(this.persistentClass.getEntityName(), collector.getDatabase().toIdentifier(collector.getLogicalTableName(primaryTable)), primaryTable, superTableXref);
    }

    private void bindTable(String schema, String catalog, String tableName, UniqueConstraint[] uniqueConstraints, String rowId, String viewQuery, InFlightMetadataCollector.EntityTableXref denormalizedSuperTableXref) {
        String entityName = this.persistentClass.getEntityName();
        EntityTableNamingStrategyHelper namingStrategyHelper = new EntityTableNamingStrategyHelper(this.persistentClass.getClassName(), entityName, this.name);
        Identifier logicalName = StringHelper.isNotBlank(tableName) ? namingStrategyHelper.handleExplicitName(tableName, this.context) : namingStrategyHelper.determineImplicitName(this.context);
        org.hibernate.mapping.Table table = TableBinder.buildAndFillTable(schema, catalog, logicalName, this.persistentClass.isAbstract(), uniqueConstraints, this.context, this.subselect, denormalizedSuperTableXref);
        table.setRowId(rowId);
        table.setViewQuery(viewQuery);
        this.getMetadataCollector().addEntityTableXref(entityName, logicalName, table, denormalizedSuperTableXref);
        PersistentClass persistentClass = this.persistentClass;
        if (!(persistentClass instanceof TableOwner)) {
            throw new AssertionFailure("binding a table for a subclass");
        }
        TableOwner tableOwner = (TableOwner)((Object)persistentClass);
        tableOwner.setTable(table);
    }

    public void finalSecondaryTableBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    public void finalSecondaryTableFromAnnotationBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableFromAnnotationJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (!this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    private void createPrimaryColumnsToSecondaryTable(Object incoming, PropertyHolder propertyHolder, Join join) {
        AnnotatedJoinColumns annotatedJoinColumns;
        Object[] joinColumnSource = (Annotation[])incoming;
        if (CollectionHelper.isEmpty(joinColumnSource)) {
            annotatedJoinColumns = this.createDefaultJoinColumn(propertyHolder);
        } else {
            JoinColumn[] joinColumns;
            PrimaryKeyJoinColumn[] pkJoinColumns;
            Object first = joinColumnSource[0];
            if (first instanceof PrimaryKeyJoinColumn) {
                pkJoinColumns = (PrimaryKeyJoinColumn[])joinColumnSource;
                joinColumns = null;
            } else if (first instanceof JoinColumn) {
                pkJoinColumns = null;
                joinColumns = (JoinColumn[])joinColumnSource;
            } else {
                throw new IllegalArgumentException("Expecting list of AnnotationUsages for either @JoinColumn or @PrimaryKeyJoinColumn, but got as list of AnnotationUsages for @" + first.annotationType().getName());
            }
            annotatedJoinColumns = this.createJoinColumns(propertyHolder, pkJoinColumns, joinColumns);
        }
        for (AnnotatedJoinColumn joinColumn : annotatedJoinColumns.getJoinColumns()) {
            joinColumn.forceNotNull();
        }
        this.bindJoinToPersistentClass(join, annotatedJoinColumns, this.context);
    }

    private AnnotatedJoinColumns createDefaultJoinColumn(PropertyHolder propertyHolder) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(this.context);
        joinColumns.setJoins(this.secondaryTables);
        joinColumns.setPropertyHolder(propertyHolder);
        AnnotatedJoinColumn.buildInheritanceJoinColumn(null, null, this.persistentClass.getIdentifier(), joinColumns, this.context);
        return joinColumns;
    }

    private AnnotatedJoinColumns createJoinColumns(PropertyHolder propertyHolder, PrimaryKeyJoinColumn[] primaryKeyJoinColumns, JoinColumn[] joinColumns) {
        int joinColumnCount;
        int n = joinColumnCount = primaryKeyJoinColumns != null ? primaryKeyJoinColumns.length : joinColumns.length;
        if (joinColumnCount == 0) {
            return this.createDefaultJoinColumn(propertyHolder);
        }
        AnnotatedJoinColumns columns = new AnnotatedJoinColumns();
        columns.setBuildingContext(this.context);
        columns.setJoins(this.secondaryTables);
        columns.setPropertyHolder(propertyHolder);
        for (int colIndex = 0; colIndex < joinColumnCount; ++colIndex) {
            PrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns != null ? primaryKeyJoinColumns[colIndex] : null;
            JoinColumn joinColumn = joinColumns != null ? joinColumns[colIndex] : null;
            AnnotatedJoinColumn.buildInheritanceJoinColumn(primaryKeyJoinColumn, joinColumn, this.persistentClass.getIdentifier(), columns, this.context);
        }
        return columns;
    }

    private void bindJoinToPersistentClass(Join join, AnnotatedJoinColumns joinColumns, MetadataBuildingContext context) {
        DependantValue key = new DependantValue(context, join.getTable(), this.persistentClass.getIdentifier());
        join.setKey(key);
        this.setForeignKeyNameIfDefined(join);
        key.setOnDeleteAction(null);
        TableBinder.bindForeignKey(this.persistentClass, null, joinColumns, key, false, context);
        key.sortProperties();
        join.createPrimaryKey();
        join.createForeignKey();
        this.persistentClass.addJoin(join);
    }

    private void setForeignKeyNameIfDefined(Join join) {
        SimpleValue key = (SimpleValue)join.getKey();
        SecondaryTable jpaSecondaryTable = this.findMatchingSecondaryTable(join);
        if (jpaSecondaryTable != null) {
            boolean noConstraintByDefault = this.context.getBuildingOptions().isNoConstraintByDefault();
            if (jpaSecondaryTable.foreignKey().value() == ConstraintMode.NO_CONSTRAINT || jpaSecondaryTable.foreignKey().value() == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault) {
                key.disableForeignKey();
            } else {
                key.setForeignKeyName(StringHelper.nullIfEmpty(jpaSecondaryTable.foreignKey().name()));
                key.setForeignKeyDefinition(StringHelper.nullIfEmpty(jpaSecondaryTable.foreignKey().foreignKeyDefinition()));
                key.setForeignKeyOptions(jpaSecondaryTable.foreignKey().options());
            }
        }
    }

    private SecondaryTable findMatchingSecondaryTable(Join join) {
        String nameToMatch = join.getTable().getQuotedName();
        SecondaryTable secondaryTable = (SecondaryTable)this.annotatedClass.getDirectAnnotationUsage(SecondaryTable.class);
        if (secondaryTable != null && nameToMatch.equals(secondaryTable.name())) {
            return secondaryTable;
        }
        SecondaryTables secondaryTables = (SecondaryTables)this.annotatedClass.getDirectAnnotationUsage(SecondaryTables.class);
        if (secondaryTables != null) {
            SecondaryTable[] nestedSecondaryTableList;
            for (SecondaryTable nestedSecondaryTable : nestedSecondaryTableList = secondaryTables.value()) {
                if (nestedSecondaryTable == null || !nameToMatch.equals(nestedSecondaryTable.name())) continue;
                return nestedSecondaryTable;
            }
        }
        return null;
    }

    private SecondaryRow findMatchingSecondaryRowAnnotation(String tableName) {
        SecondaryRow row = (SecondaryRow)this.annotatedClass.getDirectAnnotationUsage(SecondaryRow.class);
        if (row != null && (row.table().isBlank() || this.equalsTableName(tableName, row))) {
            return row;
        }
        SecondaryRows tables = (SecondaryRows)this.annotatedClass.getDirectAnnotationUsage(SecondaryRows.class);
        if (tables != null) {
            SecondaryRow[] rowList;
            for (SecondaryRow current : rowList = tables.value()) {
                if (!this.equalsTableName(tableName, current)) continue;
                return current;
            }
        }
        return null;
    }

    private boolean equalsTableName(String physicalTableName, SecondaryRow secondaryRow) {
        Identifier logicalName = this.context.getMetadataCollector().getDatabase().toIdentifier(secondaryRow.table());
        Identifier secondaryRowPhysicalTableName = this.context.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalName, EntityTableNamingStrategyHelper.jdbcEnvironment(this.context));
        return physicalTableName.equals(secondaryRowPhysicalTableName.render());
    }

    public Join addJoinTable(JoinTable joinTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        Join join = this.addJoin(holder, noDelayInPkColumnCreation, false, joinTable.name(), joinTable.schema(), joinTable.catalog(), joinTable.joinColumns(), joinTable.uniqueConstraints());
        org.hibernate.mapping.Table table = join.getTable();
        TableBinder.addTableCheck(table, joinTable.check());
        TableBinder.addTableComment(table, joinTable.comment());
        TableBinder.addTableOptions(table, joinTable.options());
        return join;
    }

    public Join addSecondaryTable(SecondaryTable secondaryTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        Join join = this.addJoin(holder, noDelayInPkColumnCreation, true, secondaryTable.name(), secondaryTable.schema(), secondaryTable.catalog(), secondaryTable.pkJoinColumns(), secondaryTable.uniqueConstraints());
        org.hibernate.mapping.Table table = join.getTable();
        new IndexBinder(this.context).bindIndexes(table, secondaryTable.indexes());
        TableBinder.addTableCheck(table, secondaryTable.check());
        TableBinder.addTableComment(table, secondaryTable.comment());
        TableBinder.addTableOptions(table, secondaryTable.options());
        return join;
    }

    private Join addJoin(PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation, boolean secondaryTable, String name, String schema, String catalog, Object joinColumns, UniqueConstraint[] uniqueConstraints) {
        QualifiedTableName logicalName = this.logicalTableName(name, schema, catalog);
        return this.createJoin(propertyHolder, noDelayInPkColumnCreation, secondaryTable, joinColumns, logicalName, TableBinder.buildAndFillTable(schema, catalog, logicalName.getTableName(), false, uniqueConstraints, this.context));
    }

    private QualifiedTableName logicalTableName(String name, String schema, String catalog) {
        return new QualifiedTableName(Identifier.toIdentifier(catalog), Identifier.toIdentifier(schema), this.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(name));
    }

    Join createJoin(PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation, boolean secondaryTable, Object joinColumns, QualifiedTableName logicalName, org.hibernate.mapping.Table table) {
        Join join = new Join();
        this.persistentClass.addJoin(join);
        String entityName = this.persistentClass.getEntityName();
        InFlightMetadataCollector.EntityTableXref tableXref = this.getMetadataCollector().getEntityTableXref(entityName);
        assert (tableXref != null) : "Could not locate EntityTableXref for entity [" + entityName + "]";
        tableXref.addSecondaryTable(logicalName, join);
        join.setTable(table);
        this.handleSecondaryRowManagement(join);
        this.processSecondaryTableCustomSql(join);
        if (noDelayInPkColumnCreation) {
            this.createPrimaryColumnsToSecondaryTable(joinColumns, propertyHolder, join);
        } else {
            String quotedName = table.getQuotedName();
            if (secondaryTable) {
                this.secondaryTablesFromAnnotation.put(quotedName, join);
                this.secondaryTableFromAnnotationJoins.put(quotedName, joinColumns);
            } else {
                this.secondaryTableJoins.put(quotedName, joinColumns);
            }
            this.secondaryTables.put(quotedName, join);
        }
        return join;
    }

    private void handleSecondaryRowManagement(Join join) {
        String tableName = join.getTable().getQuotedName();
        SecondaryRow matchingRow = this.findMatchingSecondaryRowAnnotation(tableName);
        if (matchingRow != null) {
            join.setInverse(!matchingRow.owned());
            join.setOptional(matchingRow.optional());
        } else {
            join.setInverse(false);
            join.setOptional(true);
        }
    }

    private void processSecondaryTableCustomSql(Join join) {
        SQLDelete sqlDelete;
        SQLUpdate sqlUpdate;
        String tableName = join.getTable().getQuotedName();
        SQLInsert sqlInsert = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLInsert.class, tableName);
        if (sqlInsert != null) {
            join.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlInsert.check()));
            Class<? extends Expectation> expectationClass = sqlInsert.verify();
            if (expectationClass != Expectation.class) {
                join.setInsertExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlUpdate = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLUpdate.class, tableName)) != null) {
            join.setCustomSQLUpdate(sqlUpdate.sql().trim(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlUpdate.check()));
            Class<? extends Expectation> expectationClass = sqlUpdate.verify();
            if (expectationClass != Expectation.class) {
                join.setUpdateExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
        if ((sqlDelete = this.resolveCustomSqlAnnotation(this.annotatedClass, SQLDelete.class, tableName)) != null) {
            join.setCustomSQLDelete(sqlDelete.sql().trim(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.fromResultCheckStyle(sqlDelete.check()));
            Class<? extends Expectation> expectationClass = sqlDelete.verify();
            if (expectationClass != Expectation.class) {
                join.setDeleteExpectation(ReflectHelper.getDefaultSupplier(expectationClass));
            }
        }
    }

    public Map<String, Join> getSecondaryTables() {
        return this.secondaryTables;
    }

    public static String getCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        org.hibernate.cache.spi.access.AccessType accessType = strategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    public boolean isIgnoreIdAnnotations() {
        return this.ignoreIdAnnotations;
    }

    public AccessType getPropertyAccessType() {
        return this.propertyAccessType;
    }

    public void setPropertyAccessType(AccessType propertyAccessType) {
        this.propertyAccessType = this.getExplicitAccessType((AnnotationTarget)this.annotatedClass);
        if (this.propertyAccessType == null) {
            this.propertyAccessType = propertyAccessType;
        }
    }

    public AccessType getPropertyAccessor(AnnotationTarget element) {
        AccessType accessType = this.getExplicitAccessType(element);
        return accessType == null ? this.propertyAccessType : accessType;
    }

    private AccessType getExplicitAccessType(AnnotationTarget element) {
        Access access;
        if (element != null && (access = (Access)element.getAnnotationUsage(Access.class, this.modelsContext())) != null) {
            return AccessType.getAccessStrategy(access.value());
        }
        return null;
    }

    private void bindFiltersInHierarchy() {
        AnnotatedClassType classType;
        this.bindFilters((AnnotationTarget)this.annotatedClass);
        for (ClassDetails classToProcess = this.annotatedClass.getSuperClass(); classToProcess != null && (classType = this.getMetadataCollector().getClassType(classToProcess)) == AnnotatedClassType.MAPPED_SUPERCLASS; classToProcess = classToProcess.getSuperClass()) {
            this.bindFilters((AnnotationTarget)classToProcess);
        }
    }

    private void bindFilters(AnnotationTarget element) {
        Filter filter;
        Filters filters = DialectOverridesAnnotationHelper.getOverridableAnnotation(element, Filters.class, this.context);
        if (filters != null) {
            Collections.addAll(this.filters, filters.value());
        }
        if ((filter = (Filter)element.getDirectAnnotationUsage(Filter.class)) != null) {
            this.filters.add(filter);
        }
    }

    private static class JoinedSubclassFkSecondPass
    implements FkSecondPass {
        private final JoinedSubclass entity;
        private final MetadataBuildingContext buildingContext;
        private final SimpleValue key;
        private final AnnotatedJoinColumns columns;

        private JoinedSubclassFkSecondPass(JoinedSubclass entity, AnnotatedJoinColumns inheritanceJoinedColumns, SimpleValue key, MetadataBuildingContext buildingContext) {
            this.entity = entity;
            this.buildingContext = buildingContext;
            this.key = key;
            this.columns = inheritanceJoinedColumns;
        }

        @Override
        public Value getValue() {
            return this.key;
        }

        @Override
        public String getReferencedEntityName() {
            return this.entity.getSuperclass().getEntityName();
        }

        @Override
        public boolean isInPrimaryKey() {
            return true;
        }

        @Override
        public void doSecondPass(Map<String, PersistentClass> persistentClasses) {
            TableBinder.bindForeignKey(this.entity.getSuperclass(), this.entity, this.columns, this.key, false, this.buildingContext);
        }
    }

    private static class EntityTableNamingStrategyHelper
    implements NamingStrategyHelper {
        private final String className;
        private final String entityName;
        private final String jpaEntityName;

        private EntityTableNamingStrategyHelper(String className, String entityName, String jpaEntityName) {
            this.className = className;
            this.entityName = entityName;
            this.jpaEntityName = jpaEntityName;
        }

        @Override
        public Identifier determineImplicitName(final MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getImplicitNamingStrategy().determinePrimaryTableName(new ImplicitEntityNameSource(){
                private final EntityNaming entityNaming = new EntityNaming(){

                    @Override
                    public String getClassName() {
                        return className;
                    }

                    @Override
                    public String getEntityName() {
                        return entityName;
                    }

                    @Override
                    public String getJpaEntityName() {
                        return jpaEntityName;
                    }
                };

                @Override
                public EntityNaming getEntityNaming() {
                    return this.entityNaming;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return buildingContext;
                }
            });
        }

        @Override
        public Identifier handleExplicitName(String explicitName, MetadataBuildingContext buildingContext) {
            return EntityTableNamingStrategyHelper.jdbcEnvironment(buildingContext).getIdentifierHelper().toIdentifier(explicitName);
        }

        @Override
        public Identifier toPhysicalName(Identifier logicalName, MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalName, EntityTableNamingStrategyHelper.jdbcEnvironment(buildingContext));
        }

        private static JdbcEnvironment jdbcEnvironment(MetadataBuildingContext buildingContext) {
            return buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment();
        }
    }
}

