/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.asm;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;

@NullMarked
public final class BootstrapMethod {
    private final Handle handle;
    private final List<Object> arguments;

    public static BootstrapMethod fromIndy(Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        return new BootstrapMethod(bootstrapMethodHandle, Arrays.asList(bootstrapMethodArguments));
    }

    public static BootstrapMethod fromConstantDynamic(ConstantDynamic constantDynamic) {
        return new BootstrapMethod(constantDynamic.getBootstrapMethod(), new ConstantDynamicBootstrapArguments(constantDynamic));
    }

    private BootstrapMethod(Handle handle, List<Object> arguments) {
        this.handle = handle;
        this.arguments = arguments;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    @NullMarked
    private static class ConstantDynamicBootstrapArguments
    extends AbstractList<Object> {
        private final ConstantDynamic constantDynamic;

        public ConstantDynamicBootstrapArguments(ConstantDynamic constantDynamic) {
            this.constantDynamic = constantDynamic;
        }

        @Override
        public Object get(int index) {
            return this.constantDynamic.getBootstrapMethodArgument(index);
        }

        @Override
        public int size() {
            return this.constantDynamic.getBootstrapMethodArgumentCount();
        }
    }
}

