# ----------------------------------------------------------------------------
#
#  Copyright (C) 2018-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------



import globdef as G
from PyQt6 import QtGui, QtCore, QtWidgets
from matrixwin import *
from controls import *


class Gainelm (QtWidgets.QWidget):

    def __init__(self, parent, style, callb, index): 
        super (Gainelm, self).__init__(parent)
        self.resize (G.ELM_XS, G.ELM_YS)
        self.callb = callb
        self.index = index
        self.invert = 0
        R = Rgainctl (self, style)
        R.move (7, 2)
        R.valueEvent.connect (self.value_event)
        R.pressEvent.connect (self.press_event)
        R.show ()
        self.gainctl = R
        L = QtWidgets.QLabel (self)
        L.setFont (G.VAL_FONT)
        L.setText ('')
        L.setGeometry (0, 30, G.ELM_XS - 8, 14)
        L.setAlignment (QtCore.Qt.AlignmentFlag.AlignRight)
        self.gaintxt = L

    def redraw (self):
        gaindb = self.gainctl.get_value ()
        if (gaindb > -200):
            self.gaintxt.setText('%5.1f' % (gaindb,))    
            if self.invert: self.gainctl.set_state (2)
            else:           self.gainctl.set_state (1)
        else:
            self.gaintxt.setText('')    
            self.gainctl.set_state (0)    

    def value_event (self, args):
        self.redraw ()
        self.callb (self.index, G.ACT_GAIN, args.get_value (), self.invert)     

    def press_event (self, args):
        b = args.mousebutt
        if b == QtCore.Qt.MouseButton.RightButton:
            self.invert ^= 1
            self.value_event (args)
            
    def get_state (self):
        return self.gainctl.get_value (), self.invert

    def set_state (self, gaindb, invert):
        self.gainctl.set_value (gaindb)
        self.invert = invert
        self.redraw ()
         
     
         
class Gainmatwin (Matrixwin):

    def __init__(self, parent, nrow, ncol, callb): 
        super (Gainmatwin, self).__init__(parent, nrow, ncol)
        pal = self.palette () 
        bgc = pal.color (pal.ColorRole.Window)
        style = RotaryStyle (11, bgc, [G.FG_N,G.COL4,G.COL3], [G.MK_N,G.COL0,G.COL0])
        self.controls = {}
        y = 1
        for r in range (nrow):
            x = 1
            for c in range (ncol):
                index = (r, c)
                E = Gainelm (self, style, callb, index)  
                E.move (x, y)
                self.controls [index] = E
                x += G.ELM_XS + 1
            y += G.ELM_YS + 1

    def get_state (self, row, col):
        return self.controls [(row, col)].get_state ()
    
    def set_state (self, row, col, gaindb, invert):
        self.controls [(row, col)].set_state (gaindb, invert)
        

