# This file has been autogenerated by the pywayland scanner

# Copyright © 2021 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WpSecurityContextV1(Interface):
    """Client security context

    The security context allows a client to register a new client and attach
    security context metadata to the connections.

    When both are set, the combination of the application ID and the sandbox
    engine must uniquely identify an application. The same application ID will
    be used across instances (e.g. if the application is restarted, or if the
    application is started multiple times).

    When both are set, the combination of the instance ID and the sandbox
    engine must uniquely identify a running instance of an application.
    """

    name = "wp_security_context_v1"
    version = 1

    class error(enum.IntEnum):
        already_used = 1
        already_set = 2
        invalid_metadata = 3


class WpSecurityContextV1Proxy(Proxy[WpSecurityContextV1]):
    interface = WpSecurityContextV1

    @WpSecurityContextV1.request()
    def destroy(self) -> None:
        """Destroy the security context object

        Destroy the security context object.
        """
        self._marshal(0)
        self._destroy()

    @WpSecurityContextV1.request(
        Argument(ArgumentType.String),
    )
    def set_sandbox_engine(self, name: str) -> None:
        """Set the sandbox engine

        Attach a unique sandbox engine name to the security context. The name
        should follow the reverse-DNS style (e.g. "org.flatpak").

        A list of well-known engines is maintained at:
        https://gitlab.freedesktop.org/wayland/wayland-
        protocols/-/blob/main/staging/security-context/engines.md

        It is a protocol error to call this request twice. The already_set
        error is sent in this case.

        :param name:
            the sandbox engine name
        :type name:
            `ArgumentType.String`
        """
        self._marshal(1, name)

    @WpSecurityContextV1.request(
        Argument(ArgumentType.String),
    )
    def set_app_id(self, app_id: str) -> None:
        """Set the application id

        Attach an application ID to the security context.

        The application ID is an opaque, sandbox-specific identifier for an
        application. See the well-known engines document for more details:
        https://gitlab.freedesktop.org/wayland/wayland-
        protocols/-/blob/main/staging/security-context/engines.md

        The compositor may use the application ID to group clients belonging to
        the same security context application.

        Whether this request is optional or not depends on the sandbox engine
        used.

        It is a protocol error to call this request twice. The already_set
        error is sent in this case.

        :param app_id:
            the application ID
        :type app_id:
            `ArgumentType.String`
        """
        self._marshal(2, app_id)

    @WpSecurityContextV1.request(
        Argument(ArgumentType.String),
    )
    def set_instance_id(self, instance_id: str) -> None:
        """Set the instance id

        Attach an instance ID to the security context.

        The instance ID is an opaque, sandbox-specific identifier for a running
        instance of an application. See the well-known engines document for
        more details: https://gitlab.freedesktop.org/wayland/wayland-
        protocols/-/blob/main/staging/security-context/engines.md

        Whether this request is optional or not depends on the sandbox engine
        used.

        It is a protocol error to call this request twice. The already_set
        error is sent in this case.

        :param instance_id:
            the instance ID
        :type instance_id:
            `ArgumentType.String`
        """
        self._marshal(3, instance_id)

    @WpSecurityContextV1.request()
    def commit(self) -> None:
        """Register the security context

        Atomically register the new client and attach the security context
        metadata.

        If the provided metadata is inconsistent or does not match with out of
        band metadata (see https://gitlab.freedesktop.org/wayland/wayland-
        protocols/-/blob/main/staging/security-context/engines.md), the
        invalid_metadata error may be sent eventually.

        It's a protocol error to send any request other than "destroy" after
        this request. In this case, the already_used error is sent.
        """
        self._marshal(4)


class WpSecurityContextV1Resource(Resource):
    interface = WpSecurityContextV1


class WpSecurityContextV1Global(Global):
    interface = WpSecurityContextV1


WpSecurityContextV1._gen_c()
WpSecurityContextV1.proxy_class = WpSecurityContextV1Proxy
WpSecurityContextV1.resource_class = WpSecurityContextV1Resource
WpSecurityContextV1.global_class = WpSecurityContextV1Global
