/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.community.ide.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class PythonSourceRootConfigurator
implements DirectoryProjectConfigurator {
    @NonNls
    private static final String SETUP_PY = "setup.py";
    @NonNls
    private static final String SRC_FOLDER = "src";

    PythonSourceRootConfigurator() {
    }

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        VirtualFile srcFolder;
        VirtualFile setupPy;
        if (project == null) {
            PythonSourceRootConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            PythonSourceRootConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            PythonSourceRootConfigurator.$$$reportNull$$$0(2);
        }
        if ((setupPy = baseDir.findChild(SETUP_PY)) != null) {
            PythonSourceRootConfigurator.configureFromSetupPy(project, baseDir, setupPy);
        }
        if ((srcFolder = baseDir.findChild(SRC_FOLDER)) != null) {
            PythonSourceRootConfigurator.configureSrcDirectory(project, baseDir, srcFolder);
        }
    }

    private static void configureSrcDirectory(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull VirtualFile srcFolder) {
        if (project == null) {
            PythonSourceRootConfigurator.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            PythonSourceRootConfigurator.$$$reportNull$$$0(4);
        }
        if (srcFolder == null) {
            PythonSourceRootConfigurator.$$$reportNull$$$0(5);
        }
        PythonSourceRootConfigurator.addSourceRoot(project, baseDir, srcFolder, false);
    }

    private static void configureFromSetupPy(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull VirtualFile setupPy) {
        if (project == null) {
            PythonSourceRootConfigurator.$$$reportNull$$$0(6);
        }
        if (baseDir == null) {
            PythonSourceRootConfigurator.$$$reportNull$$$0(7);
        }
        if (setupPy == null) {
            PythonSourceRootConfigurator.$$$reportNull$$$0(8);
        }
        CharSequence content = LoadTextUtil.loadText((VirtualFile)setupPy);
        PsiFile setupPyFile = PsiFileFactory.getInstance((Project)project).createFileFromText(SETUP_PY, (FileType)PythonFileType.INSTANCE, (CharSequence)content.toString());
        SetupCallVisitor visitor = new SetupCallVisitor();
        setupPyFile.accept((PsiElementVisitor)visitor);
        String dir = visitor.getRootPackageDir();
        if (dir != null) {
            VirtualFile rootPackageVFile = baseDir.findFileByRelativePath(dir);
            PythonSourceRootConfigurator.addSourceRoot(project, baseDir, rootPackageVFile, true);
        }
    }

    private static void addSourceRoot(Project project, VirtualFile baseDir, VirtualFile root, boolean unique) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length > 0 && root != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                ContentEntry[] contentEntries;
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
                for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
                    if (!Comparing.equal((Object)contentEntry.getFile(), (Object)baseDir)) continue;
                    SourceFolder[] sourceFolders = contentEntry.getSourceFolders();
                    if (unique && sourceFolders.length != 0) continue;
                    contentEntry.addSourceFolder(root, false);
                }
                model.commit();
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupPy";
                break;
            }
        }
        objectArray2[1] = "com/intellij/pycharm/community/ide/impl/PythonSourceRootConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "configureSrcDirectory";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "configureFromSetupPy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SetupCallVisitor
    extends PyRecursiveElementVisitor {
        private String myRootPackageDir = null;

        private SetupCallVisitor() {
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                SetupCallVisitor.$$$reportNull$$$0(0);
            }
            PyArgumentList argList = node.getArgumentList();
            if (node.isCalleeText(new String[]{"setup"}) && argList != null) {
                PyExpression valueExpression;
                PyKeywordArgument packageDirArg = argList.getKeywordArgument("package_dir");
                if (packageDirArg != null && (valueExpression = packageDirArg.getValueExpression()) instanceof PyDictLiteralExpression) {
                    PyDictLiteralExpression packageDirDict = (PyDictLiteralExpression)valueExpression;
                    for (PyKeyValueExpression keyValue : packageDirDict.getElements()) {
                        PyExpression keyExpr = keyValue.getKey();
                        PyExpression valueExpr = keyValue.getValue();
                        if (!(keyExpr instanceof PyStringLiteralExpression) || !(valueExpr instanceof PyStringLiteralExpression)) continue;
                        String key = ((PyStringLiteralExpression)keyExpr).getStringValue();
                        String value = ((PyStringLiteralExpression)valueExpr).getStringValue();
                        if (!key.isEmpty()) continue;
                        this.myRootPackageDir = value;
                    }
                }
            } else {
                super.visitPyCallExpression(node);
            }
        }

        public String getRootPackageDir() {
            return this.myRootPackageDir;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/pycharm/community/ide/impl/PythonSourceRootConfigurator$SetupCallVisitor", "visitPyCallExpression"));
        }
    }
}

