/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error.future;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;

public class ShouldBeCompletedWithin
extends BasicErrorMessageFactory {
    private static final String SHOULD_BE_COMPLETED_WITHIN_DURATION = "%nExpecting%n  <%s>%nto be completed within %s.%n%nexception caught while trying to get the future result: ";
    private static final String SHOULD_BE_COMPLETED_WITHIN = "%nExpecting%n  <%s>%nto be completed within %s %s.%n%nexception caught while trying to get the future result: ";

    public static ErrorMessageFactory shouldBeCompletedWithin(Future<?> actual, Duration duration, Exception exception) {
        return new ShouldBeCompletedWithin(actual, duration, exception);
    }

    public static ErrorMessageFactory shouldBeCompletedWithin(Future<?> actual, long timeout2, TimeUnit timeUnit, Exception exception) {
        return new ShouldBeCompletedWithin(actual, timeout2, timeUnit, exception);
    }

    private ShouldBeCompletedWithin(Future<?> actual, Duration duration, Exception exception) {
        super(SHOULD_BE_COMPLETED_WITHIN_DURATION + Strings.escapePercent(Throwables.getStackTrace(exception)), actual, duration);
    }

    private ShouldBeCompletedWithin(Future<?> actual, long timeout2, TimeUnit timeUnit, Exception exception) {
        super(SHOULD_BE_COMPLETED_WITHIN + Strings.escapePercent(Throwables.getStackTrace(exception)), actual, timeout2, ShouldBeCompletedWithin.toChronoUnit(timeUnit));
    }

    private static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError();
    }
}

