/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.compression;

import io.ktor.client.HttpClientConfig;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.api.ClientPlugin;
import io.ktor.client.plugins.api.ClientPluginBuilder;
import io.ktor.client.plugins.api.CreatePluginUtilsKt;
import io.ktor.client.plugins.api.OnRequestContext;
import io.ktor.client.plugins.compression.AfterRenderHook;
import io.ktor.client.plugins.compression.ContentEncodingConfig;
import io.ktor.client.plugins.compression.ContentEncodingKt;
import io.ktor.client.plugins.compression.ReceiveStateHook;
import io.ktor.client.plugins.compression.UnsupportedContentEncodingException;
import io.ktor.client.plugins.observer.DelegatedCallKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HeadersKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.content.CompressedContentKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.AttributeKey;
import io.ktor.util.ContentEncoder;
import io.ktor.util.Encoder;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.utils.io.ByteReadChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a:\u0010\b\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u0019\b\u0002\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\b\u0010\t\u001a%\u0010\u000e\u001a\u00020\u0005*\u00020\n2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001f\u0010\u000e\u001a\u00020\u0005*\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0004\b\u000e\u0010\u0012\"\u0018\u0010\u0015\u001a\u00060\u0013j\u0002`\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\"#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00178\u0006\u00a2\u0006\u0012\n\u0004\b\b\u0010\u0018\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\"&\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\u001d8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"&\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00100\u001d8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010!\"\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u0010*\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lio/ktor/client/HttpClientConfig;", "Lio/ktor/client/plugins/compression/ContentEncodingConfig$Mode;", "mode", "Lkotlin/Function1;", "Lio/ktor/client/plugins/compression/ContentEncodingConfig;", "", "Lkotlin/ExtensionFunctionType;", "block", "ContentEncoding", "(Lio/ktor/client/HttpClientConfig;Lio/ktor/client/plugins/compression/ContentEncodingConfig$Mode;Lkotlin/jvm/functions/Function1;)V", "Lio/ktor/client/request/HttpRequestBuilder;", "", "", "contentEncoderName", "compress", "(Lio/ktor/client/request/HttpRequestBuilder;[Ljava/lang/String;)V", "", "contentEncoderNames", "(Lio/ktor/client/request/HttpRequestBuilder;Ljava/util/List;)V", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "Lio/ktor/client/plugins/api/ClientPlugin;", "Lio/ktor/client/plugins/api/ClientPlugin;", "getContentEncoding", "()Lio/ktor/client/plugins/api/ClientPlugin;", "getContentEncoding$annotations", "()V", "Lio/ktor/util/AttributeKey;", "CompressionListAttribute", "Lio/ktor/util/AttributeKey;", "getCompressionListAttribute", "()Lio/ktor/util/AttributeKey;", "DecompressionListAttribute", "getDecompressionListAttribute", "Lio/ktor/client/statement/HttpResponse;", "getAppliedDecoders", "(Lio/ktor/client/statement/HttpResponse;)Ljava/util/List;", "appliedDecoders", "ktor-client-encoding"})
@SourceDebugExtension(value={"SMAP\nContentEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentEncoding.kt\nio/ktor/client/plugins/compression/ContentEncodingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Attributes.kt\nio/ktor/util/AttributesKt\n+ 5 Type.kt\nio/ktor/util/reflect/TypeKt\n*L\n1#1,298:1\n774#2:299\n865#2,2:300\n1563#2:302\n1634#2,3:303\n1#3:306\n21#4:307\n21#4:326\n65#5,18:308\n65#5,18:327\n*S KotlinDebug\n*F\n+ 1 ContentEncoding.kt\nio/ktor/client/plugins/compression/ContentEncodingKt\n*L\n163#1:299\n163#1:300,2\n133#1:302\n133#1:303,3\n264#1:307\n265#1:326\n264#1:308,18\n265#1:327,18\n*E\n"})
public final class ContentEncodingKt {
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final ClientPlugin<ContentEncodingConfig> ContentEncoding;
    @NotNull
    private static final AttributeKey<List<String>> CompressionListAttribute;
    @NotNull
    private static final AttributeKey<List<String>> DecompressionListAttribute;

    @NotNull
    public static final ClientPlugin<ContentEncodingConfig> getContentEncoding() {
        return ContentEncoding;
    }

    public static /* synthetic */ void getContentEncoding$annotations() {
    }

    public static final void ContentEncoding(@NotNull HttpClientConfig<?> $this$ContentEncoding, @NotNull ContentEncodingConfig.Mode mode, @NotNull Function1<? super ContentEncodingConfig, Unit> block) {
        Intrinsics.checkNotNullParameter($this$ContentEncoding, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        $this$ContentEncoding.install((HttpClientPlugin)ContentEncoding, arg_0 -> ContentEncodingKt.ContentEncoding$lambda$10(mode, block, arg_0));
    }

    public static /* synthetic */ void ContentEncoding$default(HttpClientConfig httpClientConfig, ContentEncodingConfig.Mode mode, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            mode = ContentEncodingConfig.Mode.DecompressResponse;
        }
        if ((n & 2) != 0) {
            function1 = ContentEncodingKt::ContentEncoding$lambda$9;
        }
        ContentEncodingKt.ContentEncoding(httpClientConfig, mode, (Function1<? super ContentEncodingConfig, Unit>)function1);
    }

    @NotNull
    public static final AttributeKey<List<String>> getCompressionListAttribute() {
        return CompressionListAttribute;
    }

    @NotNull
    public static final AttributeKey<List<String>> getDecompressionListAttribute() {
        return DecompressionListAttribute;
    }

    public static final void compress(@NotNull HttpRequestBuilder $this$compress, String ... contentEncoderName) {
        Intrinsics.checkNotNullParameter((Object)$this$compress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentEncoderName, (String)"contentEncoderName");
        $this$compress.getAttributes().put(CompressionListAttribute, (Object)ArraysKt.toList((Object[])contentEncoderName));
    }

    public static final void compress(@NotNull HttpRequestBuilder $this$compress, @NotNull List<String> contentEncoderNames) {
        Intrinsics.checkNotNullParameter((Object)$this$compress, (String)"<this>");
        Intrinsics.checkNotNullParameter(contentEncoderNames, (String)"contentEncoderNames");
        $this$compress.getAttributes().put(CompressionListAttribute, contentEncoderNames);
    }

    @NotNull
    public static final List<String> getAppliedDecoders(@NotNull HttpResponse $this$appliedDecoders) {
        Intrinsics.checkNotNullParameter((Object)$this$appliedDecoders, (String)"<this>");
        List list = (List)$this$appliedDecoders.getCall().getAttributes().getOrNull(DecompressionListAttribute);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Unit ContentEncoding$lambda$8$decode$lambda$7$lambda$5(HeadersBuilder $this_headers, String name, List values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (StringsKt.equals((String)name, (String)HttpHeaders.INSTANCE.getContentEncoding(), (boolean)true) || StringsKt.equals((String)name, (String)HttpHeaders.INSTANCE.getContentLength(), (boolean)true)) {
            return Unit.INSTANCE;
        }
        $this_headers.appendAll(name, values);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit ContentEncoding$lambda$8$decode$lambda$7(HttpResponse $response, List $encodings, HeadersBuilder $this$headers) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$headers), (String)"$this$headers");
        $response.getHeaders().forEach((arg_0, arg_1) -> ContentEncodingKt.ContentEncoding$lambda$8$decode$lambda$7$lambda$5($this$headers, arg_0, arg_1));
        Iterable $this$filter$iv = $encodings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!$encodings.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List remainingEncodings = (List)destination$iv$iv;
        if (!((Collection)remainingEncodings).isEmpty()) {
            $this$headers.append(HttpHeaders.INSTANCE.getContentEncoding(), CollectionsKt.joinToString$default((Iterable)remainingEncodings, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final HttpResponse ContentEncoding$lambda$8$decode(CoroutineScope $this$ContentEncoding_u24lambda_u248_u24decode, Map<String, ? extends ContentEncoder> encoders, HttpResponse response2) {
        Collection destination$iv$iv;
        String[] stringArray;
        Object object = response2.getHeaders().get(HttpHeaders.INSTANCE.getContentEncoding());
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                collection.add(string2);
            }
        } else {
            CoroutineScope $this$ContentEncoding_u24lambda_u248_u24decode_u24lambda_u243 = $this$ContentEncoding_u24lambda_u248_u24decode;
            boolean bl = false;
            LOGGER.trace("Empty or no Content-Encoding header in response. Skipping ContentEncoding for " + response2.getCall().getRequest().getUrl());
            return response2;
        }
        List encodings = (List)destination$iv$iv;
        ByteReadChannel current = null;
        current = response2.getRawContent();
        for (String encoding : CollectionsKt.reversed((Iterable)encodings)) {
            ContentEncoder contentEncoder = encoders.get(encoding);
            if (contentEncoder == null) {
                throw new UnsupportedContentEncodingException(encoding);
            }
            Encoder encoder = (Encoder)contentEncoder;
            LOGGER.trace("Decoding response with " + encoder + " for " + response2.getCall().getRequest().getUrl());
            Encoder $this$ContentEncoding_u24lambda_u248_u24decode_u24lambda_u244 = encoder;
            boolean bl = false;
            current = $this$ContentEncoding_u24lambda_u248_u24decode_u24lambda_u244.decode(current, response2.getCoroutineContext());
        }
        Headers headers = HeadersKt.headers((Function1<? super HeadersBuilder, Unit>)((Function1)arg_0 -> ContentEncodingKt.ContentEncoding$lambda$8$decode$lambda$7(response2, encodings, arg_0)));
        response2.getCall().getAttributes().put(DecompressionListAttribute, (Object)encodings);
        return DelegatedCallKt.wrap(response2.getCall(), current, headers).getResponse();
    }

    private static final Unit ContentEncoding$lambda$8(ClientPluginBuilder $this$createClientPlugin) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$createClientPlugin, (String)"$this$createClientPlugin");
        Map<String, ContentEncoder> encoders = ((ContentEncodingConfig)$this$createClientPlugin.getPluginConfig()).getEncoders$ktor_client_encoding();
        Map<String, Float> qualityValues = ((ContentEncodingConfig)$this$createClientPlugin.getPluginConfig()).getQualityValues$ktor_client_encoding();
        ContentEncodingConfig.Mode mode = ((ContentEncodingConfig)$this$createClientPlugin.getPluginConfig()).getMode();
        StringBuilder $this$ContentEncoding_u24lambda_u248_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (ContentEncoder encoder : encoders.values()) {
            if (((CharSequence)$this$ContentEncoding_u24lambda_u248_u24lambda_u241).length() > 0) {
                $this$ContentEncoding_u24lambda_u248_u24lambda_u241.append(',');
            }
            $this$ContentEncoding_u24lambda_u248_u24lambda_u241.append(encoder.getName());
            Float f = qualityValues.get(encoder.getName());
            if (f == null) {
                continue;
            }
            float quality = f.floatValue();
            double d = quality;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Invalid quality value: " + quality + " for encoder: " + encoder;
                throw new IllegalStateException(string.toString());
            }
            String qualityValue = StringsKt.take((String)String.valueOf(quality), (int)5);
            $this$ContentEncoding_u24lambda_u248_u24lambda_u241.append(";q=" + qualityValue);
        }
        String requestHeader = stringBuilder.toString();
        $this$createClientPlugin.onRequest((Function4<OnRequestContext, HttpRequestBuilder, Object, Continuation<Unit>, Object>)((Function4)new Function4<OnRequestContext, HttpRequestBuilder, Object, Continuation<? super Unit>, Object>(mode, requestHeader, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ContentEncodingConfig.Mode $mode;
            final /* synthetic */ String $requestHeader;
            {
                this.$mode = $mode;
                this.$requestHeader = $requestHeader;
                super(4, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        HttpRequestBuilder request2 = (HttpRequestBuilder)this.L$0;
                        if (!this.$mode.getResponse$ktor_client_encoding()) {
                            return Unit.INSTANCE;
                        }
                        if (request2.getHeaders().contains(HttpHeaders.INSTANCE.getAcceptEncoding())) {
                            return Unit.INSTANCE;
                        }
                        ContentEncodingKt.access$getLOGGER$p().trace("Adding Accept-Encoding=" + this.$requestHeader + " for " + request2.getUrl());
                        request2.getHeaders().set(HttpHeaders.INSTANCE.getAcceptEncoding(), this.$requestHeader);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(OnRequestContext p1, HttpRequestBuilder p2, Object p3, Continuation<? super Unit> p4) {
                Function4<OnRequestContext, HttpRequestBuilder, Object, Continuation<? super Unit>, Object> function4 = new /* invalid duplicate definition of identical inner class */;
                function4.L$0 = p2;
                return function4.invokeSuspend((Object)Unit.INSTANCE);
            }
        }));
        $this$createClientPlugin.on(AfterRenderHook.INSTANCE, new Function3<HttpRequestBuilder, OutgoingContent, Continuation<? super OutgoingContent>, Object>(mode, (ClientPluginBuilder<ContentEncodingConfig>)$this$createClientPlugin, encoders, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ ContentEncodingConfig.Mode $mode;
            final /* synthetic */ ClientPluginBuilder<ContentEncodingConfig> $this_createClientPlugin;
            final /* synthetic */ Map<String, ContentEncoder> $encoders;
            {
                this.$mode = $mode;
                this.$this_createClientPlugin = $this_createClientPlugin;
                this.$encoders = $encoders;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)object);
                        HttpRequestBuilder request2 = (HttpRequestBuilder)this.L$0;
                        OutgoingContent content2 = (OutgoingContent)this.L$1;
                        if (!this.$mode.getRequest$ktor_client_encoding()) {
                            return null;
                        }
                        List list = (List)request2.getAttributes().getOrNull(ContentEncodingKt.getCompressionListAttribute());
                        if (list == null) {
                            boolean bl = false;
                            ContentEncodingKt.access$getLOGGER$p().trace("Skipping request compression for " + request2.getUrl() + " because no compressions set");
                            return null;
                        }
                        List encoderNames = list;
                        ContentEncodingKt.access$getLOGGER$p().trace("Compressing request body for " + request2.getUrl() + " using " + encoderNames);
                        Iterable iterable = encoderNames;
                        Map<String, ContentEncoder> map2 = this.$encoders;
                        boolean $i$f$map = false;
                        Iterator<T> iterator = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            ContentEncoder contentEncoder = map2.get(it);
                            if (contentEncoder == null) {
                                throw new UnsupportedContentEncodingException((String)it);
                            }
                            collection.add(contentEncoder);
                        }
                        List selectedEncoders = (List)destination$iv$iv;
                        if (selectedEncoders.isEmpty()) {
                            return null;
                        }
                        Iterable $this$fold$iv = selectedEncoders;
                        boolean $i$f$fold = false;
                        OutgoingContent accumulator$iv = content2;
                        for (T element$iv : $this$fold$iv) {
                            void encoder;
                            ContentEncoder $i$f$mapTo2 = (ContentEncoder)element$iv;
                            OutgoingContent compressed = accumulator$iv;
                            boolean bl = false;
                            OutgoingContent outgoingContent = CompressedContentKt.compressed(compressed, (ContentEncoder)encoder, (CoroutineContext)request2.getExecutionContext());
                            if (outgoingContent == null) {
                                outgoingContent = compressed;
                            }
                            accumulator$iv = outgoingContent;
                        }
                        return accumulator$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(HttpRequestBuilder p1, OutgoingContent p2, Continuation<? super OutgoingContent> p3) {
                Function3<HttpRequestBuilder, OutgoingContent, Continuation<? super OutgoingContent>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
        $this$createClientPlugin.on(ReceiveStateHook.INSTANCE, new Function2<HttpResponse, Continuation<? super HttpResponse>, Object>(mode, encoders, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ContentEncodingConfig.Mode $mode;
            final /* synthetic */ Map<String, ContentEncoder> $encoders;
            {
                this.$mode = $mode;
                this.$encoders = $encoders;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Long contentLength;
                        ResultKt.throwOnFailure((Object)object);
                        HttpResponse response2 = (HttpResponse)this.L$0;
                        if (!this.$mode.getResponse$ktor_client_encoding()) {
                            return null;
                        }
                        HttpMethod method = HttpResponseKt.getRequest(response2).getMethod();
                        Long l = contentLength = HttpMessagePropertiesKt.contentLength(response2);
                        long l2 = 0L;
                        if (l != null && l == l2) {
                            return null;
                        }
                        if (contentLength == null && Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getHead())) {
                            return null;
                        }
                        return ContentEncodingKt.access$ContentEncoding$lambda$8$decode(response2.getCall(), this.$encoders, response2);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<HttpResponse, Continuation<? super HttpResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(HttpResponse p1, Continuation<? super HttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit ContentEncoding$lambda$9(ContentEncodingConfig contentEncodingConfig) {
        Intrinsics.checkNotNullParameter((Object)contentEncodingConfig, (String)"<this>");
        ContentEncodingConfig.gzip$default(contentEncodingConfig, null, 1, null);
        ContentEncodingConfig.deflate$default(contentEncodingConfig, null, 1, null);
        ContentEncodingConfig.identity$default(contentEncodingConfig, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit ContentEncoding$lambda$10(ContentEncodingConfig.Mode $mode, Function1 $block, ContentEncodingConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setMode($mode);
        $block.invoke((Object)$this$install);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p() {
        return LOGGER;
    }

    public static final /* synthetic */ HttpResponse access$ContentEncoding$lambda$8$decode(CoroutineScope $receiver, Map encoders, HttpResponse response2) {
        return ContentEncodingKt.ContentEncoding$lambda$8$decode($receiver, encoders, response2);
    }

    static {
        KType kType;
        LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger((String)"io.ktor.client.plugins.compression.ContentEncoding");
        ContentEncoding = CreatePluginUtilsKt.createClientPlugin("HttpEncoding", ContentEncoding.1.INSTANCE, ContentEncodingKt::ContentEncoding$lambda$8);
        String name$iv = "CompressionListAttribute";
        boolean $i$f$AttributeKey = false;
        String string = name$iv;
        boolean $i$f$typeInfo = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(List.class);
        boolean $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)));
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KType kType2 = kType;
        KClass kClass2 = kClass;
        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
        String string2 = string;
        CompressionListAttribute = new AttributeKey(string2, typeInfo);
        name$iv = "DecompressionListAttribute";
        $i$f$AttributeKey = false;
        string = name$iv;
        $i$f$typeInfo = false;
        kClass = Reflection.getOrCreateKotlinClass(List.class);
        $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)));
        }
        catch (Throwable throwable) {
            kType = null;
        }
        kType2 = kType;
        kClass2 = kClass;
        typeInfo = new TypeInfo(kClass2, kType2);
        string2 = string;
        DecompressionListAttribute = new AttributeKey(string2, typeInfo);
    }
}

