/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.ecmascript;

import com.intellij.lang.Language;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpParser;
import org.intellij.lang.regexp.RegExpParserDefinition;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.ecmascript.EcmaScriptRegexpLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EcmaScriptRegexpParserDefinition
extends RegExpParserDefinition {
    public static final IFileElementType JS_REGEXP_FILE = new IFileElementType("JS_REGEXP_FILE", (Language)EcmaScriptRegexpLanguage.INSTANCE);
    private final EnumSet<RegExpCapability> CAPABILITIES = EnumSet.of(RegExpCapability.OCTAL_NO_LEADING_ZERO, RegExpCapability.DANGLING_METACHARACTERS, RegExpCapability.ALLOW_EMPTY_CHARACTER_CLASS, RegExpCapability.PROPERTY_VALUES, RegExpCapability.MAX_OCTAL_377);

    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        return new RegExpLexer(this, this.CAPABILITIES){

            @Nullable
            public IElementType getTokenType() {
                IElementType baseType = super.getTokenType();
                if (baseType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN || baseType == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) {
                    return RegExpTT.REDUNDANT_ESCAPE;
                }
                if (baseType == RegExpTT.BAD_OCT_VALUE) {
                    return RegExpTT.OCT_CHAR;
                }
                return baseType;
            }
        };
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        return new RegExpParser(this.CAPABILITIES);
    }

    @Override
    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = JS_REGEXP_FILE;
        if (iFileElementType == null) {
            EcmaScriptRegexpParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            EcmaScriptRegexpParserDefinition.$$$reportNull$$$0(1);
        }
        return new RegExpFile(viewProvider, EcmaScriptRegexpLanguage.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/ecmascript/EcmaScriptRegexpParserDefinition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/ecmascript/EcmaScriptRegexpParserDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

