/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.api.core.BetaApi;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@BetaApi
public final class ListPartsRequest {
    private final String bucket;
    private final String key;
    private final String uploadId;
    private final Integer maxParts;
    private final Integer partNumberMarker;

    private ListPartsRequest(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.maxParts = builder.maxParts;
        this.partNumberMarker = builder.partNumberMarker;
    }

    @BetaApi
    public String bucket() {
        return this.bucket;
    }

    @BetaApi
    public String key() {
        return this.key;
    }

    @BetaApi
    public String uploadId() {
        return this.uploadId;
    }

    @BetaApi
    public Integer getMaxParts() {
        return this.maxParts;
    }

    @BetaApi
    public Integer getPartNumberMarker() {
        return this.partNumberMarker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPartsRequest)) {
            return false;
        }
        ListPartsRequest that = (ListPartsRequest)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals(this.maxParts, that.maxParts) && Objects.equals(this.partNumberMarker, that.partNumberMarker);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.key, this.uploadId, this.maxParts, this.partNumberMarker);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("key", (Object)this.key).add("uploadId", (Object)this.uploadId).add("maxParts", (Object)this.maxParts).add("partNumberMarker", (Object)this.partNumberMarker).toString();
    }

    @BetaApi
    public static Builder builder() {
        return new Builder();
    }

    @BetaApi
    public static class Builder {
        private String bucket;
        private String key;
        private String uploadId;
        private Integer maxParts;
        private Integer partNumberMarker;

        private Builder() {
        }

        @BetaApi
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @BetaApi
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @BetaApi
        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @BetaApi
        public Builder maxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        @BetaApi
        public Builder partNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        @BetaApi
        public ListPartsRequest build() {
            return new ListPartsRequest(this);
        }
    }
}

