/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.implementation.models.BlobTag;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobTags
implements XmlSerializable<BlobTags> {
    private List<BlobTag> blobTagSet;

    public List<BlobTag> getBlobTagSet() {
        if (this.blobTagSet == null) {
            this.blobTagSet = new ArrayList<BlobTag>();
        }
        return this.blobTagSet;
    }

    public BlobTags setBlobTagSet(List<BlobTag> blobTagSet) {
        this.blobTagSet = blobTagSet;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Tags" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.blobTagSet != null) {
            xmlWriter.writeStartElement("TagSet");
            for (BlobTag element : this.blobTagSet) {
                xmlWriter.writeXml((XmlSerializable)element, "Tag");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static BlobTags fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobTags.fromXml(xmlReader, null);
    }

    public static BlobTags fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Tags" : rootElementName;
        return (BlobTags)xmlReader.readObject(finalRootElementName, reader -> {
            BlobTags deserializedBlobTags = new BlobTags();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("TagSet".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("Tag".equals(elementName.getLocalPart())) {
                            if (deserializedBlobTags.blobTagSet == null) {
                                deserializedBlobTags.blobTagSet = new ArrayList<BlobTag>();
                            }
                            deserializedBlobTags.blobTagSet.add(BlobTag.fromXml(reader, "Tag"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobTags;
        });
    }
}

