/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.http.logging.HttpMessageArgProviderFactory;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.compression.HttpCompressionOptionsSpec;

final class Http2StreamBridgeServerHandler
extends ChannelDuplexHandler {
    final @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress;
    final @Nullable HttpCompressionOptionsSpec compressionOptions;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final HttpMessageLogFactory httpMessageLogFactory;
    final ConnectionObserver listener;
    final @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    final @Nullable Duration readTimeout;
    final @Nullable Duration requestTimeout;
    SocketAddress remoteAddress;
    Boolean secured;
    boolean pendingResponse;

    Http2StreamBridgeServerHandler(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress, @Nullable HttpCompressionOptionsSpec compressionOptions, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Duration readTimeout, @Nullable Duration requestTimeout) {
        this.compress = compress;
        this.compressionOptions = compressionOptions;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.formDecoderProvider = formDecoderProvider;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.httpMessageLogFactory = httpMessageLogFactory;
        this.listener = listener;
        this.mapHandle = mapHandle;
        this.readTimeout = readTimeout;
        this.requestTimeout = requestTimeout;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format((Channel)ctx.channel(), (String)"New HTTP/2 stream"));
        }
        ctx.read();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.secured == null) {
            this.secured = ctx.channel().parent().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel().parent())).orElse(ctx.channel().parent().remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            HttpRequest request = (HttpRequest)msg;
            ZonedDateTime timestamp = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
            ConnectionInfo connectionInfo = null;
            try {
                this.pendingResponse = true;
                connectionInfo = ConnectionInfo.from(request, this.secured, ctx.channel().localAddress(), this.remoteAddress, this.forwardedHeaderHandler);
                ops = new HttpServerOperations(Connection.from((Channel)ctx.channel()), this.listener, request, this.compressionOptions, this.compress, connectionInfo, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.httpMessageLogFactory, true, this.mapHandle, this.readTimeout, this.requestTimeout, this.secured, timestamp, true);
            }
            catch (RuntimeException e) {
                this.pendingResponse = false;
                request.setDecoderResult(DecoderResult.failure((Throwable)(e.getCause() != null ? e.getCause() : e)));
                HttpServerOperations.sendDecodingFailures(ctx, this.listener, this.secured, e, msg, this.httpMessageLogFactory, true, timestamp, connectionInfo, this.remoteAddress, true);
                return;
            }
            ops.bind();
            this.listener.onStateChange((Connection)ops, ConnectionObserver.State.CONFIGURED);
        } else if (!this.pendingResponse) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format((Channel)ctx.channel(), (String)"Dropped HTTP content, since response has been sent already: {}"), new Object[]{msg instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(msg)) : msg});
            }
            ReferenceCountUtil.release((Object)msg);
            ctx.read();
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Class<?> msgClass = msg.getClass();
        if (msgClass == DefaultHttpResponse.class) {
            ctx.write(msg, promise);
        } else if (msgClass == DefaultFullHttpResponse.class) {
            ctx.write(msg, promise);
            if (HttpResponseStatus.CONTINUE.code() == ((DefaultFullHttpResponse)msg).status().code()) {
                return;
            }
            this.finalizeResponse(ctx);
        } else if (msg == LastHttpContent.EMPTY_LAST_CONTENT || msgClass == DefaultLastHttpContent.class) {
            ctx.write(msg, promise);
            this.finalizeResponse(ctx);
        } else if (msg instanceof ByteBuf) {
            if (!this.pendingResponse) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format((Channel)ctx.channel(), (String)"Dropped HTTP content, since response has been sent already: {}"), new Object[]{msg});
                }
                ((ByteBuf)msg).release();
                promise.setSuccess();
                return;
            }
            ctx.write((Object)new DefaultHttpContent((ByteBuf)msg), promise);
        } else if (msg instanceof HttpResponse && HttpResponseStatus.CONTINUE.code() == ((HttpResponse)msg).status().code()) {
            ctx.write(msg, promise);
        } else {
            ctx.write(msg, promise);
            if (msg instanceof LastHttpContent) {
                this.finalizeResponse(ctx);
            }
        }
    }

    void finalizeResponse(ChannelHandlerContext ctx) {
        this.pendingResponse = false;
        ctx.read();
    }
}

