/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructureSegment;

public class PathSegment {
    private final StructureSegment member;

    protected PathSegment(BuilderImpl builder) {
        this.member = builder.member();
    }

    public StructureSegment member() {
        return this.member;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected StructureSegment member;

        protected BuilderImpl() {
        }

        protected BuilderImpl(PathSegment model) {
            this.member = model.member();
        }

        @Override
        public Builder member(StructureSegment member) {
            this.member = member;
            return this;
        }

        @Override
        public StructureSegment member() {
            return this.member;
        }

        @Override
        public PathSegment build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`PathSegment` is a Union. A Union MUST have one and only one value set.");
            }
            return new PathSegment(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.member};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder member(StructureSegment var1);

        public StructureSegment member();

        public PathSegment build();
    }
}

