/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;

public class EncryptedPart {
    private final String name;
    private final String prefix;

    protected EncryptedPart(BuilderImpl builder) {
        this.name = builder.name();
        this.prefix = builder.prefix();
    }

    public String name() {
        return this.name;
    }

    public String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String name;
        protected String prefix;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EncryptedPart model) {
            this.name = model.name();
            this.prefix = model.prefix();
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public String prefix() {
            return this.prefix;
        }

        @Override
        public EncryptedPart build() {
            if (Objects.isNull(this.name())) {
                throw new IllegalArgumentException("Missing value for required field `name`");
            }
            if (Objects.isNull(this.prefix())) {
                throw new IllegalArgumentException("Missing value for required field `prefix`");
            }
            if (Objects.nonNull(this.prefix()) && this.prefix().length() < 1) {
                throw new IllegalArgumentException("The size of `prefix` must be greater than or equal to 1");
            }
            return new EncryptedPart(this);
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public String name();

        public Builder prefix(String var1);

        public String prefix();

        public EncryptedPart build();
    }
}

